// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves properties for a specific compute resource in an Amazon GameLift
// fleet. You can list all computes in a fleet by calling [ListCompute].
//
// # Request options
//
// Provide the fleet ID and compute name. The compute name varies depending on the
// type of fleet.
//
//   - For a compute in a managed EC2 fleet, provide an instance ID. Each instance
//     in the fleet is a compute.
//
//   - For a compute in a managed container fleet, provide a compute name. In a
//     container fleet, each game server container group on a fleet instance is
//     assigned a compute name.
//
//   - For a compute in an Anywhere fleet, provide a registered compute name.
//     Anywhere fleet computes are created when you register a hosting resource with
//     the fleet.
//
// # Results
//
// If successful, this operation returns details for the requested compute
// resource. Depending on the fleet's compute type, the result includes the
// following information:
//
//   - For a managed EC2 fleet, this operation returns information about the EC2
//     instance.
//
//   - For an Anywhere fleet, this operation returns information about the
//     registered compute.
//
// [ListCompute]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListCompute.html
func (c *Client) DescribeCompute(ctx context.Context, params *DescribeComputeInput, optFns ...func(*Options)) (*DescribeComputeOutput, error) {
	if params == nil {
		params = &DescribeComputeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeCompute", params, optFns, c.addOperationDescribeComputeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeComputeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeComputeInput struct {

	// The unique identifier of the compute resource to retrieve properties for. For a
	// managed container fleet or Anywhere fleet, use a compute name. For an EC2 fleet,
	// use an instance ID. To retrieve a fleet's compute identifiers, call [ListCompute].
	//
	// [ListCompute]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListCompute.html
	//
	// This member is required.
	ComputeName *string

	// A unique identifier for the fleet that the compute belongs to. You can use
	// either the fleet ID or ARN value.
	//
	// This member is required.
	FleetId *string

	noSmithyDocumentSerde
}

type DescribeComputeOutput struct {

	// The set of properties for the requested compute resource.
	Compute *types.Compute

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeComputeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeCompute{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeCompute{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeCompute"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeComputeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeCompute(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeCompute(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeCompute",
	}
}
