// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes one or more route server peers.
//
// A route server peer is a session between a route server endpoint and the device
// deployed in Amazon Web Services (such as a firewall appliance or other network
// security function running on an EC2 instance). The device must meet these
// requirements:
//
//   - Have an elastic network interface in the VPC
//
//   - Support BGP (Border Gateway Protocol)
//
//   - Can initiate BGP sessions
//
// For more information see [Dynamic routing in your VPC with VPC Route Server] in the Amazon VPC User Guide.
//
// [Dynamic routing in your VPC with VPC Route Server]: https://docs.aws.amazon.com/vpc/latest/userguide/dynamic-routing-route-server.html
func (c *Client) DescribeRouteServerPeers(ctx context.Context, params *DescribeRouteServerPeersInput, optFns ...func(*Options)) (*DescribeRouteServerPeersOutput, error) {
	if params == nil {
		params = &DescribeRouteServerPeersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeRouteServerPeers", params, optFns, c.addOperationDescribeRouteServerPeersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeRouteServerPeersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeRouteServerPeersInput struct {

	// A check for whether you have the required permissions for the action without
	// actually making the request and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// One or more filters to apply to the describe request.
	Filters []types.Filter

	// The maximum number of results to return with a single call.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	// The IDs of the route server peers to describe.
	RouteServerPeerIds []string

	noSmithyDocumentSerde
}

type DescribeRouteServerPeersOutput struct {

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Information about the described route server peers.
	RouteServerPeers []types.RouteServerPeer

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeRouteServerPeersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeRouteServerPeers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeRouteServerPeers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeRouteServerPeers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeRouteServerPeers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeRouteServerPeersPaginatorOptions is the paginator options for
// DescribeRouteServerPeers
type DescribeRouteServerPeersPaginatorOptions struct {
	// The maximum number of results to return with a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeRouteServerPeersPaginator is a paginator for DescribeRouteServerPeers
type DescribeRouteServerPeersPaginator struct {
	options   DescribeRouteServerPeersPaginatorOptions
	client    DescribeRouteServerPeersAPIClient
	params    *DescribeRouteServerPeersInput
	nextToken *string
	firstPage bool
}

// NewDescribeRouteServerPeersPaginator returns a new
// DescribeRouteServerPeersPaginator
func NewDescribeRouteServerPeersPaginator(client DescribeRouteServerPeersAPIClient, params *DescribeRouteServerPeersInput, optFns ...func(*DescribeRouteServerPeersPaginatorOptions)) *DescribeRouteServerPeersPaginator {
	if params == nil {
		params = &DescribeRouteServerPeersInput{}
	}

	options := DescribeRouteServerPeersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeRouteServerPeersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeRouteServerPeersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeRouteServerPeers page.
func (p *DescribeRouteServerPeersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeRouteServerPeersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeRouteServerPeers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeRouteServerPeersAPIClient is a client that implements the
// DescribeRouteServerPeers operation.
type DescribeRouteServerPeersAPIClient interface {
	DescribeRouteServerPeers(context.Context, *DescribeRouteServerPeersInput, ...func(*Options)) (*DescribeRouteServerPeersOutput, error)
}

var _ DescribeRouteServerPeersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeRouteServerPeers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeRouteServerPeers",
	}
}
