// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the distributions by the connection mode that you specify.
func (c *Client) ListDistributionsByConnectionMode(ctx context.Context, params *ListDistributionsByConnectionModeInput, optFns ...func(*Options)) (*ListDistributionsByConnectionModeOutput, error) {
	if params == nil {
		params = &ListDistributionsByConnectionModeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDistributionsByConnectionMode", params, optFns, c.addOperationListDistributionsByConnectionModeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDistributionsByConnectionModeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDistributionsByConnectionModeInput struct {

	// The connection mode to filter distributions by.
	//
	// This member is required.
	ConnectionMode types.ConnectionMode

	//  The marker for the next set of distributions to retrieve.
	Marker *string

	// The maximum number of distributions to return.
	MaxItems *int32

	noSmithyDocumentSerde
}

type ListDistributionsByConnectionModeOutput struct {

	// A distribution list.
	DistributionList *types.DistributionList

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDistributionsByConnectionModeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListDistributionsByConnectionMode{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListDistributionsByConnectionMode{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDistributionsByConnectionMode"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDistributionsByConnectionModeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDistributionsByConnectionMode(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListDistributionsByConnectionModePaginatorOptions is the paginator options for
// ListDistributionsByConnectionMode
type ListDistributionsByConnectionModePaginatorOptions struct {
	// The maximum number of distributions to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDistributionsByConnectionModePaginator is a paginator for
// ListDistributionsByConnectionMode
type ListDistributionsByConnectionModePaginator struct {
	options   ListDistributionsByConnectionModePaginatorOptions
	client    ListDistributionsByConnectionModeAPIClient
	params    *ListDistributionsByConnectionModeInput
	nextToken *string
	firstPage bool
}

// NewListDistributionsByConnectionModePaginator returns a new
// ListDistributionsByConnectionModePaginator
func NewListDistributionsByConnectionModePaginator(client ListDistributionsByConnectionModeAPIClient, params *ListDistributionsByConnectionModeInput, optFns ...func(*ListDistributionsByConnectionModePaginatorOptions)) *ListDistributionsByConnectionModePaginator {
	if params == nil {
		params = &ListDistributionsByConnectionModeInput{}
	}

	options := ListDistributionsByConnectionModePaginatorOptions{}
	if params.MaxItems != nil {
		options.Limit = *params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDistributionsByConnectionModePaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDistributionsByConnectionModePaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDistributionsByConnectionMode page.
func (p *ListDistributionsByConnectionModePaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDistributionsByConnectionModeOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxItems = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDistributionsByConnectionMode(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = nil
	if result.DistributionList != nil {
		p.nextToken = result.DistributionList.NextMarker
	}

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDistributionsByConnectionModeAPIClient is a client that implements the
// ListDistributionsByConnectionMode operation.
type ListDistributionsByConnectionModeAPIClient interface {
	ListDistributionsByConnectionMode(context.Context, *ListDistributionsByConnectionModeInput, ...func(*Options)) (*ListDistributionsByConnectionModeOutput, error)
}

var _ ListDistributionsByConnectionModeAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDistributionsByConnectionMode(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDistributionsByConnectionMode",
	}
}
