// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanrooms

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanrooms/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the analysis rule for a configured table association.
func (c *Client) GetConfiguredTableAssociationAnalysisRule(ctx context.Context, params *GetConfiguredTableAssociationAnalysisRuleInput, optFns ...func(*Options)) (*GetConfiguredTableAssociationAnalysisRuleOutput, error) {
	if params == nil {
		params = &GetConfiguredTableAssociationAnalysisRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetConfiguredTableAssociationAnalysisRule", params, optFns, c.addOperationGetConfiguredTableAssociationAnalysisRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetConfiguredTableAssociationAnalysisRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetConfiguredTableAssociationAnalysisRuleInput struct {

	//  The type of analysis rule that you want to retrieve.
	//
	// This member is required.
	AnalysisRuleType types.ConfiguredTableAssociationAnalysisRuleType

	//  The identiﬁer for the conﬁgured table association that's related to the
	// analysis rule.
	//
	// This member is required.
	ConfiguredTableAssociationIdentifier *string

	//  A unique identifier for the membership that the configured table association
	// belongs to. Currently accepts the membership ID.
	//
	// This member is required.
	MembershipIdentifier *string

	noSmithyDocumentSerde
}

type GetConfiguredTableAssociationAnalysisRuleOutput struct {

	// The analysis rule for the conﬁgured table association. In the console, the
	// ConfiguredTableAssociationAnalysisRule is referred to as the collaboration
	// analysis rule.
	//
	// This member is required.
	AnalysisRule *types.ConfiguredTableAssociationAnalysisRule

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetConfiguredTableAssociationAnalysisRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetConfiguredTableAssociationAnalysisRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetConfiguredTableAssociationAnalysisRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetConfiguredTableAssociationAnalysisRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetConfiguredTableAssociationAnalysisRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetConfiguredTableAssociationAnalysisRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetConfiguredTableAssociationAnalysisRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetConfiguredTableAssociationAnalysisRule",
	}
}
