// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all executions of a flow. Results can be paginated and include summary
// information about each execution, such as status, start and end times, and the
// execution's Amazon Resource Name (ARN).
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
func (c *Client) ListFlowExecutions(ctx context.Context, params *ListFlowExecutionsInput, optFns ...func(*Options)) (*ListFlowExecutionsOutput, error) {
	if params == nil {
		params = &ListFlowExecutionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListFlowExecutions", params, optFns, c.addOperationListFlowExecutionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListFlowExecutionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListFlowExecutionsInput struct {

	// The unique identifier of the flow to list executions for.
	//
	// This member is required.
	FlowIdentifier *string

	// The unique identifier of the flow alias to list executions for.
	FlowAliasIdentifier *string

	// The maximum number of flow executions to return in a single response. If more
	// executions exist than the specified maxResults value, a token is included in
	// the response so that the remaining results can be retrieved.
	MaxResults *int32

	// A token to retrieve the next set of results. This value is returned in the
	// response if more results are available.
	NextToken *string

	noSmithyDocumentSerde
}

type ListFlowExecutionsOutput struct {

	// A list of flow execution summaries. Each summary includes the execution ARN,
	// flow identifier, flow alias identifier, flow version, status, and timestamps.
	//
	// This member is required.
	FlowExecutionSummaries []types.FlowExecutionSummary

	// A token to retrieve the next set of results. This value is returned if more
	// results are available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListFlowExecutionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListFlowExecutions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListFlowExecutions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListFlowExecutions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListFlowExecutionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListFlowExecutions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListFlowExecutionsPaginatorOptions is the paginator options for
// ListFlowExecutions
type ListFlowExecutionsPaginatorOptions struct {
	// The maximum number of flow executions to return in a single response. If more
	// executions exist than the specified maxResults value, a token is included in
	// the response so that the remaining results can be retrieved.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListFlowExecutionsPaginator is a paginator for ListFlowExecutions
type ListFlowExecutionsPaginator struct {
	options   ListFlowExecutionsPaginatorOptions
	client    ListFlowExecutionsAPIClient
	params    *ListFlowExecutionsInput
	nextToken *string
	firstPage bool
}

// NewListFlowExecutionsPaginator returns a new ListFlowExecutionsPaginator
func NewListFlowExecutionsPaginator(client ListFlowExecutionsAPIClient, params *ListFlowExecutionsInput, optFns ...func(*ListFlowExecutionsPaginatorOptions)) *ListFlowExecutionsPaginator {
	if params == nil {
		params = &ListFlowExecutionsInput{}
	}

	options := ListFlowExecutionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListFlowExecutionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListFlowExecutionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListFlowExecutions page.
func (p *ListFlowExecutionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListFlowExecutionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListFlowExecutions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListFlowExecutionsAPIClient is a client that implements the ListFlowExecutions
// operation.
type ListFlowExecutionsAPIClient interface {
	ListFlowExecutions(context.Context, *ListFlowExecutionsInput, ...func(*Options)) (*ListFlowExecutionsOutput, error)
}

var _ ListFlowExecutionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListFlowExecutions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListFlowExecutions",
	}
}
