// Code generated by smithy-go-codegen DO NOT EDIT.

package appstream

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/appstream/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates custom branding that customizes the appearance of the streaming
// application catalog page.
func (c *Client) CreateThemeForStack(ctx context.Context, params *CreateThemeForStackInput, optFns ...func(*Options)) (*CreateThemeForStackOutput, error) {
	if params == nil {
		params = &CreateThemeForStackInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateThemeForStack", params, optFns, c.addOperationCreateThemeForStackMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateThemeForStackOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateThemeForStackInput struct {

	// The S3 location of the favicon. The favicon enables users to recognize their
	// application streaming site in a browser full of tabs or bookmarks. It is
	// displayed at the top of the browser tab for the application streaming site
	// during users' streaming sessions.
	//
	// This member is required.
	FaviconS3Location *types.S3Location

	// The organization logo that appears on the streaming application catalog page.
	//
	// This member is required.
	OrganizationLogoS3Location *types.S3Location

	// The name of the stack for the theme.
	//
	// This member is required.
	StackName *string

	// The color theme that is applied to website links, text, and buttons. These
	// colors are also applied as accents in the background for the streaming
	// application catalog page.
	//
	// This member is required.
	ThemeStyling types.ThemeStyling

	// The title that is displayed at the top of the browser tab during users'
	// application streaming sessions.
	//
	// This member is required.
	TitleText *string

	// The links that are displayed in the footer of the streaming application catalog
	// page. These links are helpful resources for users, such as the organization's IT
	// support and product marketing sites.
	FooterLinks []types.ThemeFooterLink

	noSmithyDocumentSerde
}

type CreateThemeForStackOutput struct {

	//  The theme object that contains the metadata of the custom branding.
	Theme *types.Theme

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateThemeForStackMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateThemeForStack{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateThemeForStack{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateThemeForStack"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateThemeForStackValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateThemeForStack(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateThemeForStack(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateThemeForStack",
	}
}
