// Code generated by smithy-go-codegen DO NOT EDIT.

package smithyrpcv2cborquerycompatible

import (
	"bytes"
	"context"
	"fmt"
	smithy "github.com/aws/smithy-go"
	smithycbor "github.com/aws/smithy-go/encoding/cbor"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"net/http"
)

type smithyRpcv2cbor_serializeOpGetItem struct {
}

func (*smithyRpcv2cbor_serializeOpGetItem) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpGetItem) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*GetItemInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/RpcV2CborQueryCompatible/operation/GetItem"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	req.Header.Set("X-Amzn-Query-Mode", "true")

	cv, err := serializeCBOR_GetItemInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}
func serializeCBOR_GetItemInput(v *GetItemInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}

	return vm, nil
}
