// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Enables Security Hub for your account in the current Region or the Region you
// specify in the request. When you enable Security Hub, you grant to Security Hub
// the permissions necessary to gather findings from other services that are
// integrated with Security Hub. When you use the EnableSecurityHub operation to
// enable Security Hub, you also automatically enable the following standards:
//   - Center for Internet Security (CIS) Amazon Web Services Foundations
//     Benchmark v1.2.0
//   - Amazon Web Services Foundational Security Best Practices
//
// Other standards are not automatically enabled. To opt out of automatically
// enabled standards, set EnableDefaultStandards to false . After you enable
// Security Hub, to enable a standard, use the BatchEnableStandards operation. To
// disable a standard, use the BatchDisableStandards operation. To learn more, see
// the setup information (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html)
// in the Security Hub User Guide.
func (c *Client) EnableSecurityHub(ctx context.Context, params *EnableSecurityHubInput, optFns ...func(*Options)) (*EnableSecurityHubOutput, error) {
	if params == nil {
		params = &EnableSecurityHubInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "EnableSecurityHub", params, optFns, c.addOperationEnableSecurityHubMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*EnableSecurityHubOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type EnableSecurityHubInput struct {

	// This field, used when enabling Security Hub, specifies whether the calling
	// account has consolidated control findings turned on. If the value for this field
	// is set to SECURITY_CONTROL , Security Hub generates a single finding for a
	// control check even when the check applies to multiple enabled standards. If the
	// value for this field is set to STANDARD_CONTROL , Security Hub generates
	// separate findings for a control check when the check applies to multiple enabled
	// standards. The value for this field in a member account matches the value in the
	// administrator account. For accounts that aren't part of an organization, the
	// default value of this field is SECURITY_CONTROL if you enabled Security Hub on
	// or after February 23, 2023.
	ControlFindingGenerator types.ControlFindingGenerator

	// Whether to enable the security standards that Security Hub has designated as
	// automatically enabled. If you do not provide a value for EnableDefaultStandards
	// , it is set to true . To not enable the automatically enabled standards, set
	// EnableDefaultStandards to false .
	EnableDefaultStandards *bool

	// The tags to add to the hub resource when you enable Security Hub.
	Tags map[string]string

	noSmithyDocumentSerde
}

type EnableSecurityHubOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationEnableSecurityHubMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpEnableSecurityHub{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpEnableSecurityHub{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "EnableSecurityHub"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opEnableSecurityHub(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opEnableSecurityHub(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "EnableSecurityHub",
	}
}
