// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Adds a retriever to your Amazon Q application.
func (c *Client) CreateRetriever(ctx context.Context, params *CreateRetrieverInput, optFns ...func(*Options)) (*CreateRetrieverOutput, error) {
	if params == nil {
		params = &CreateRetrieverInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRetriever", params, optFns, c.addOperationCreateRetrieverMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRetrieverOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateRetrieverInput struct {

	// The identifier of your Amazon Q application.
	//
	// This member is required.
	ApplicationId *string

	// Provides information on how the retriever used for your Amazon Q application is
	// configured.
	//
	// This member is required.
	Configuration types.RetrieverConfiguration

	// The name of your retriever.
	//
	// This member is required.
	DisplayName *string

	// The type of retriever you are using.
	//
	// This member is required.
	Type types.RetrieverType

	// A token that you provide to identify the request to create your Amazon Q
	// application retriever.
	ClientToken *string

	// The ARN of an IAM role used by Amazon Q to access the basic authentication
	// credentials stored in a Secrets Manager secret.
	RoleArn *string

	// A list of key-value pairs that identify or categorize the retriever. You can
	// also use tags to help control access to the retriever. Tag keys and values can
	// consist of Unicode letters, digits, white space, and any of the following
	// symbols: _ . : / = + - @.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateRetrieverOutput struct {

	// The Amazon Resource Name (ARN) of an IAM role associated with a retriever.
	RetrieverArn *string

	// The identifier of the retriever you are using.
	RetrieverId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRetrieverMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateRetriever{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateRetriever{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateRetriever"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateRetrieverMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateRetrieverValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRetriever(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateRetriever struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateRetriever) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateRetriever) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateRetrieverInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateRetrieverInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateRetrieverMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateRetriever{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateRetriever(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateRetriever",
	}
}
