// Code generated by smithy-go-codegen DO NOT EDIT.

package lookoutequipment

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lookoutequipment/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a label for an event.
func (c *Client) CreateLabel(ctx context.Context, params *CreateLabelInput, optFns ...func(*Options)) (*CreateLabelOutput, error) {
	if params == nil {
		params = &CreateLabelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateLabel", params, optFns, c.addOperationCreateLabelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateLabelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateLabelInput struct {

	// A unique identifier for the request to create a label. If you do not set the
	// client request token, Lookout for Equipment generates one.
	//
	// This member is required.
	ClientToken *string

	// The end time of the labeled event.
	//
	// This member is required.
	EndTime *time.Time

	// The name of a group of labels. Data in this field will be retained for service
	// usage. Follow best practices for the security of your data.
	//
	// This member is required.
	LabelGroupName *string

	// Indicates whether a labeled event represents an anomaly.
	//
	// This member is required.
	Rating types.LabelRating

	// The start time of the labeled event.
	//
	// This member is required.
	StartTime *time.Time

	// Indicates that a label pertains to a particular piece of equipment. Data in
	// this field will be retained for service usage. Follow best practices for the
	// security of your data.
	Equipment *string

	// Provides additional information about the label. The fault code must be defined
	// in the FaultCodes attribute of the label group. Data in this field will be
	// retained for service usage. Follow best practices for the security of your data.
	FaultCode *string

	// Metadata providing additional information about the label. Data in this field
	// will be retained for service usage. Follow best practices for the security of
	// your data.
	Notes *string

	noSmithyDocumentSerde
}

type CreateLabelOutput struct {

	// The ID of the label that you have created.
	LabelId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateLabelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateLabel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateLabel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateLabel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateLabelMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateLabelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateLabel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateLabel struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateLabel) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateLabel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateLabelInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateLabelInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateLabelMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateLabel{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateLabel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateLabel",
	}
}
