// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The filters applied to data store query.
type DatastoreFilter struct {

	// A filter that allows the user to set cutoff dates for records. All data stores
	// created after the specified date will be included in the results.
	CreatedAfter *time.Time

	// A filter that allows the user to set cutoff dates for records. All data stores
	// created before the specified date will be included in the results.
	CreatedBefore *time.Time

	// Allows the user to filter data store results by name.
	DatastoreName *string

	// Allows the user to filter data store results by status.
	DatastoreStatus DatastoreStatus

	noSmithyDocumentSerde
}

// Displays the properties of the data store, including the ID, ARN, name, and the
// status of the data store.
type DatastoreProperties struct {

	// The Amazon Resource Name used in the creation of the data store.
	//
	// This member is required.
	DatastoreArn *string

	// The AWS endpoint for the data store. Each data store will have it's own
	// endpoint with data store ID in the endpoint URL.
	//
	// This member is required.
	DatastoreEndpoint *string

	// The AWS-generated ID number for the data store.
	//
	// This member is required.
	DatastoreId *string

	// The status of the data store.
	//
	// This member is required.
	DatastoreStatus DatastoreStatus

	// The FHIR version. Only R4 version data is supported.
	//
	// This member is required.
	DatastoreTypeVersion FHIRVersion

	// The time that a data store was created.
	CreatedAt *time.Time

	// The user-generated name for the data store.
	DatastoreName *string

	// The identity provider that you selected when you created the data store.
	IdentityProviderConfiguration *IdentityProviderConfiguration

	// The preloaded data configuration for the data store. Only data preloaded from
	// Synthea is supported.
	PreloadDataConfig *PreloadDataConfig

	// The server-side encryption key configuration for a customer provided encryption
	// key (CMK).
	SseConfiguration *SseConfiguration

	noSmithyDocumentSerde
}

// The properties of a FHIR export job, including the ID, ARN, name, and the
// status of the job.
type ExportJobProperties struct {

	// The AWS generated ID for the data store from which files are being exported for
	// an export job.
	//
	// This member is required.
	DatastoreId *string

	// The AWS generated ID for an export job.
	//
	// This member is required.
	JobId *string

	// The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS,
	// COMPLETED, or FAILED.
	//
	// This member is required.
	JobStatus JobStatus

	// The output data configuration that was supplied when the export job was created.
	//
	// This member is required.
	OutputDataConfig OutputDataConfig

	// The time an export job was initiated.
	//
	// This member is required.
	SubmitTime *time.Time

	// The Amazon Resource Name used during the initiation of the job.
	DataAccessRoleArn *string

	// The time an export job completed.
	EndTime *time.Time

	// The user generated name for an export job.
	JobName *string

	// An explanation of any errors that may have occurred during the export job.
	Message *string

	noSmithyDocumentSerde
}

// The identity provider configuration that you gave when the data store was
// created.
type IdentityProviderConfiguration struct {

	// The authorization strategy that you selected when you created the data store.
	//
	// This member is required.
	AuthorizationStrategy AuthorizationStrategy

	// If you enabled fine-grained authorization when you created the data store.
	FineGrainedAuthorizationEnabled bool

	// The Amazon Resource Name (ARN) of the Lambda function that you want to use to
	// decode the access token created by the authorization server.
	IdpLambdaArn *string

	// The JSON metadata elements that you want to use in your identity provider
	// configuration. Required elements are listed based on the launch specification of
	// the SMART application. For more information on all possible elements, see
	// Metadata (https://build.fhir.org/ig/HL7/smart-app-launch/conformance.html#metadata)
	// in SMART's App Launch specification. authorization_endpoint : The URL to the
	// OAuth2 authorization endpoint. grant_types_supported : An array of grant types
	// that are supported at the token endpoint. You must provide at least one grant
	// type option. Valid options are authorization_code and client_credentials .
	// token_endpoint : The URL to the OAuth2 token endpoint. capabilities : An array
	// of strings of the SMART capabilities that the authorization server supports.
	// code_challenge_methods_supported : An array of strings of supported PKCE code
	// challenge methods. You must include the S256 method in the array of PKCE code
	// challenge methods.
	Metadata *string

	noSmithyDocumentSerde
}

// Displays the properties of the import job, including the ID, Arn, Name, the
// status of the job, and the progress report of the job.
type ImportJobProperties struct {

	// The datastore id used when the Import job was created.
	//
	// This member is required.
	DatastoreId *string

	// The input data configuration that was supplied when the Import job was created.
	//
	// This member is required.
	InputDataConfig InputDataConfig

	// The AWS-generated id number for the Import job.
	//
	// This member is required.
	JobId *string

	// The job status for an Import job. Possible statuses are SUBMITTED, IN_PROGRESS,
	// COMPLETED_WITH_ERRORS, COMPLETED, FAILED.
	//
	// This member is required.
	JobStatus JobStatus

	// The time that the Import job was submitted for processing.
	//
	// This member is required.
	SubmitTime *time.Time

	// The Amazon Resource Name (ARN) that gives AWS HealthLake access to your input
	// data.
	DataAccessRoleArn *string

	// The time that the Import job was completed.
	EndTime *time.Time

	// The user-generated name for an Import job.
	JobName *string

	// The output data configuration that was supplied when the export job was created.
	JobOutputDataConfig OutputDataConfig

	// Displays the progress of the import job, including total resources scanned,
	// total resources ingested, and total size of data ingested.
	JobProgressReport *JobProgressReport

	// An explanation of any errors that may have occurred during the FHIR import job.
	Message *string

	noSmithyDocumentSerde
}

// The input properties for an import job.
//
// The following types satisfy this interface:
//
//	InputDataConfigMemberS3Uri
type InputDataConfig interface {
	isInputDataConfig()
}

// The S3Uri is the user specified S3 location of the FHIR data to be imported
// into AWS HealthLake.
type InputDataConfigMemberS3Uri struct {
	Value string

	noSmithyDocumentSerde
}

func (*InputDataConfigMemberS3Uri) isInputDataConfig() {}

// The progress report of an import job.
type JobProgressReport struct {

	// The throughput (in MB/sec) of the import job.
	Throughput *float64

	// The number of files that failed to be read from the input S3 bucket due to
	// customer error.
	TotalNumberOfFilesReadWithCustomerError *int64

	// The number of files imported so far.
	TotalNumberOfImportedFiles *int64

	// The number of resources imported so far.
	TotalNumberOfResourcesImported *int64

	// The number of resources scanned from the input S3 bucket.
	TotalNumberOfResourcesScanned *int64

	// The number of resources that failed due to customer error.
	TotalNumberOfResourcesWithCustomerError *int64

	// The number of files scanned from input S3 bucket.
	TotalNumberOfScannedFiles *int64

	// The size (in MB) of the files scanned from the input S3 bucket.
	TotalSizeOfScannedFilesInMB *float64

	noSmithyDocumentSerde
}

// The customer-managed-key(CMK) used when creating a data store. If a customer
// owned key is not specified, an AWS owned key will be used for encryption.
type KmsEncryptionConfig struct {

	// The type of customer-managed-key(CMK) used for encryption. The two types of
	// supported CMKs are customer owned CMKs and AWS owned CMKs.
	//
	// This member is required.
	CmkType CmkType

	// The KMS encryption key id/alias used to encrypt the data store contents at rest.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// The output data configuration that was supplied when the export job was created.
//
// The following types satisfy this interface:
//
//	OutputDataConfigMemberS3Configuration
type OutputDataConfig interface {
	isOutputDataConfig()
}

// The output data configuration that was supplied when the export job was created.
type OutputDataConfigMemberS3Configuration struct {
	Value S3Configuration

	noSmithyDocumentSerde
}

func (*OutputDataConfigMemberS3Configuration) isOutputDataConfig() {}

// The input properties for the preloaded data store. Only data preloaded from
// Synthea is supported.
type PreloadDataConfig struct {

	// The type of preloaded data. Only Synthea preloaded data is supported.
	//
	// This member is required.
	PreloadDataType PreloadDataType

	noSmithyDocumentSerde
}

// The configuration of the S3 bucket for either an import or export job. This
// includes assigning permissions for access.
type S3Configuration struct {

	// The KMS key ID used to access the S3 bucket.
	//
	// This member is required.
	KmsKeyId *string

	// The S3Uri is the user specified S3 location of the FHIR data to be imported
	// into AWS HealthLake.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// The server-side encryption key configuration for a customer provided encryption
// key.
type SseConfiguration struct {

	// The KMS encryption configuration used to provide details for data encryption.
	//
	// This member is required.
	KmsEncryptionConfig *KmsEncryptionConfig

	noSmithyDocumentSerde
}

// A tag is a label consisting of a user-defined key and value. The form for tags
// is {"Key", "Value"}
type Tag struct {

	// The key portion of a tag. Tag keys are case sensitive.
	//
	// This member is required.
	Key *string

	// The value portion of a tag. Tag values are case sensitive.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isInputDataConfig()  {}
func (*UnknownUnionMember) isOutputDataConfig() {}
