// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudsearch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudsearch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Configures an analysis scheme that can be applied to a text or text-array field
// to define language-specific text processing options. For more information, see
// Configuring Analysis Schemes (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html)
// in the Amazon CloudSearch Developer Guide.
func (c *Client) DefineAnalysisScheme(ctx context.Context, params *DefineAnalysisSchemeInput, optFns ...func(*Options)) (*DefineAnalysisSchemeOutput, error) {
	if params == nil {
		params = &DefineAnalysisSchemeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DefineAnalysisScheme", params, optFns, c.addOperationDefineAnalysisSchemeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DefineAnalysisSchemeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Container for the parameters to the DefineAnalysisScheme operation. Specifies
// the name of the domain you want to update and the analysis scheme configuration.
type DefineAnalysisSchemeInput struct {

	// Configuration information for an analysis scheme. Each analysis scheme has a
	// unique name and specifies the language of the text to be processed. The
	// following options can be configured for an analysis scheme: Synonyms , Stopwords
	// , StemmingDictionary , JapaneseTokenizationDictionary and AlgorithmicStemming .
	//
	// This member is required.
	AnalysisScheme *types.AnalysisScheme

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start with a
	// letter or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	//
	// This member is required.
	DomainName *string

	noSmithyDocumentSerde
}

// The result of a DefineAnalysisScheme request. Contains the status of the
// newly-configured analysis scheme.
type DefineAnalysisSchemeOutput struct {

	// The status and configuration of an AnalysisScheme .
	//
	// This member is required.
	AnalysisScheme *types.AnalysisSchemeStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDefineAnalysisSchemeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDefineAnalysisScheme{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDefineAnalysisScheme{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DefineAnalysisScheme"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDefineAnalysisSchemeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDefineAnalysisScheme(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDefineAnalysisScheme(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DefineAnalysisScheme",
	}
}
