// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a continuous deployment policy that distributes traffic for a custom
// domain name to two different CloudFront distributions. To use a continuous
// deployment policy, first use CopyDistribution to create a staging distribution,
// then use UpdateDistribution to modify the staging distribution's configuration.
// After you create and update a staging distribution, you can use a continuous
// deployment policy to incrementally move traffic to the staging distribution.
// This workflow enables you to test changes to a distribution's configuration
// before moving all of your domain's production traffic to the new configuration.
func (c *Client) CreateContinuousDeploymentPolicy(ctx context.Context, params *CreateContinuousDeploymentPolicyInput, optFns ...func(*Options)) (*CreateContinuousDeploymentPolicyOutput, error) {
	if params == nil {
		params = &CreateContinuousDeploymentPolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateContinuousDeploymentPolicy", params, optFns, c.addOperationCreateContinuousDeploymentPolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateContinuousDeploymentPolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateContinuousDeploymentPolicyInput struct {

	// Contains the configuration for a continuous deployment policy.
	//
	// This member is required.
	ContinuousDeploymentPolicyConfig *types.ContinuousDeploymentPolicyConfig

	noSmithyDocumentSerde
}

type CreateContinuousDeploymentPolicyOutput struct {

	// A continuous deployment policy.
	ContinuousDeploymentPolicy *types.ContinuousDeploymentPolicy

	// The version identifier for the current version of the continuous deployment
	// policy.
	ETag *string

	// The location of the continuous deployment policy.
	Location *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateContinuousDeploymentPolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpCreateContinuousDeploymentPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpCreateContinuousDeploymentPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateContinuousDeploymentPolicy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateContinuousDeploymentPolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateContinuousDeploymentPolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateContinuousDeploymentPolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateContinuousDeploymentPolicy",
	}
}
