// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Preferences which apply for AWS Chatbot usage in the calling AWS account.
type AccountPreferences struct {

	// Turns on training data collection. This helps improve the AWS Chatbot
	// experience by allowing AWS Chatbot to store and use your customer information,
	// such as AWS Chatbot configurations, notifications, user inputs, AWS Chatbot
	// generated responses, and interaction data. This data helps us to continuously
	// improve and develop Artificial Intelligence (AI) technologies. Your data is not
	// shared with any third parties and is protected using sophisticated controls to
	// prevent unauthorized access and misuse. AWS Chatbot does not store or use
	// interactions in chat channels with Amazon Q for training AWS Chatbot’s AI
	// technologies.
	TrainingDataCollectionEnabled *bool

	// Enables use of a user role requirement in your chat configuration.
	UserAuthorizationRequired *bool

	noSmithyDocumentSerde
}

// An AWS Chatbot configuration for Amazon Chime.
type ChimeWebhookConfiguration struct {

	// The ARN of the ChimeWebhookConfiguration.
	//
	// This member is required.
	ChatConfigurationArn *string

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a
	// user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	//
	// This member is required.
	IamRoleArn *string

	// The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
	//
	// This member is required.
	SnsTopicArns []string

	// Description of the webhook. Recommend using the convention RoomName/WebhookName
	// . See Chime setup tutorial for more details:
	// https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html.
	//
	// This member is required.
	WebhookDescription *string

	// The name of the configuration.
	ConfigurationName *string

	// Specifies the logging level for this configuration. This property affects the
	// log entries pushed to Amazon CloudWatch Logs.Logging levels include ERROR, INFO,
	// or NONE.
	LoggingLevel *string

	noSmithyDocumentSerde
}

// A Microsoft Teams team that has been authorized with AWS Chatbot.
type ConfiguredTeam struct {

	// The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID,
	// you must perform the initial authorization flow with Microsoft Teams in the AWS
	// Chatbot console. Then you can copy and paste the team ID from the console. For
	// more details, see steps 1-4 in Get started with Microsoft Teams in the AWS
	// Chatbot Administrator Guide.
	//
	// This member is required.
	TeamId *string

	// The ID of the Microsoft Teams tenant.
	//
	// This member is required.
	TenantId *string

	// The name of the Microsoft Teams Team.
	TeamName *string

	noSmithyDocumentSerde
}

// An AWS Chatbot configuration for Slack.
type SlackChannelConfiguration struct {

	// The ARN of the SlackChannelConfiguration.
	//
	// This member is required.
	ChatConfigurationArn *string

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a
	// user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	//
	// This member is required.
	IamRoleArn *string

	// The ID of the Slack channel. To get the ID, open Slack, right click on the
	// channel name in the left pane, then choose Copy Link. The channel ID is the
	// 9-character string at the end of the URL. For example, ABCBBLZZZ.
	//
	// This member is required.
	SlackChannelId *string

	// The name of the Slack Channel.
	//
	// This member is required.
	SlackChannelName *string

	// The ID of the Slack workspace authorized with AWS Chatbot.
	//
	// This member is required.
	SlackTeamId *string

	// Name of the Slack Workspace.
	//
	// This member is required.
	SlackTeamName *string

	// The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
	//
	// This member is required.
	SnsTopicArns []string

	// The name of the configuration.
	ConfigurationName *string

	// The list of IAM policy ARNs that are applied as channel guardrails. The AWS
	// managed 'AdministratorAccess' policy is applied by default if this is not set.
	GuardrailPolicyArns []string

	// Logging levels include ERROR, INFO, or NONE.
	LoggingLevel *string

	// Enables use of a user role requirement in your chat configuration.
	UserAuthorizationRequired *bool

	noSmithyDocumentSerde
}

// Identifes a User level permission for a channel configuration.
type SlackUserIdentity struct {

	// The ARN of the SlackChannelConfiguration associated with the user identity.
	//
	// This member is required.
	ChatConfigurationArn *string

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a
	// user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	//
	// This member is required.
	IamRoleArn *string

	// The ID of the Slack workspace authorized with AWS Chatbot.
	//
	// This member is required.
	SlackTeamId *string

	// The ID of the user in Slack.
	//
	// This member is required.
	SlackUserId *string

	// The AWS user identity ARN used to associate a Slack User Identity with an IAM
	// Role.
	AwsUserIdentity *string

	noSmithyDocumentSerde
}

// A Slack Workspace.
type SlackWorkspace struct {

	// The ID of the Slack workspace authorized with AWS Chatbot.
	//
	// This member is required.
	SlackTeamId *string

	// Name of the Slack Workspace.
	//
	// This member is required.
	SlackTeamName *string

	noSmithyDocumentSerde
}

// An AWS Chatbot configuration for Microsoft Teams.
type TeamsChannelConfiguration struct {

	// The ID of the Microsoft Teams channel.
	//
	// This member is required.
	ChannelId *string

	// The ARN of the MicrosoftTeamsChannelConfiguration.
	//
	// This member is required.
	ChatConfigurationArn *string

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a
	// user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	//
	// This member is required.
	IamRoleArn *string

	// The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
	//
	// This member is required.
	SnsTopicArns []string

	// The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID,
	// you must perform the initial authorization flow with Microsoft Teams in the AWS
	// Chatbot console. Then you can copy and paste the team ID from the console. For
	// more details, see steps 1-4 in Get started with Microsoft Teams in the AWS
	// Chatbot Administrator Guide.
	//
	// This member is required.
	TeamId *string

	// The ID of the Microsoft Teams tenant.
	//
	// This member is required.
	TenantId *string

	// The name of the Microsoft Teams channel.
	ChannelName *string

	// The name of the configuration.
	ConfigurationName *string

	// The list of IAM policy ARNs that are applied as channel guardrails. The AWS
	// managed 'AdministratorAccess' policy is applied by default if this is not set.
	GuardrailPolicyArns []string

	// Logging levels include ERROR, INFO, or NONE.
	LoggingLevel *string

	// The name of the Microsoft Teams Team.
	TeamName *string

	// Enables use of a user role requirement in your chat configuration.
	UserAuthorizationRequired *bool

	noSmithyDocumentSerde
}

// Identifes a user level permission for a channel configuration.
type TeamsUserIdentity struct {

	// The ARN of the MicrosoftTeamsChannelConfiguration associated with the user
	// identity.
	//
	// This member is required.
	ChatConfigurationArn *string

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a
	// user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	//
	// This member is required.
	IamRoleArn *string

	// The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID,
	// you must perform the initial authorization flow with Microsoft Teams in the AWS
	// Chatbot console. Then you can copy and paste the team ID from the console. For
	// more details, see steps 1-4 in Get started with Microsoft Teams in the AWS
	// Chatbot Administrator Guide.
	//
	// This member is required.
	TeamId *string

	// The AWS user identity ARN used to associate a Microsoft Teams User Identity
	// with an IAM Role.
	AwsUserIdentity *string

	// The ID of the Microsoft Teams channel.
	TeamsChannelId *string

	// The ID of the Microsoft Teams tenant.
	TeamsTenantId *string

	// Id from Microsoft Teams for user.
	UserId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
