// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmdataexports

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmdataexports/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a data export and specifies the data query, the delivery preference,
// and any optional resource tags. A DataQuery consists of both a QueryStatement
// and TableConfigurations . The QueryStatement is an SQL statement. Data Exports
// only supports a limited subset of the SQL syntax. For more information on the
// SQL syntax that is supported, see Data query (https://docs.aws.amazon.com/cur/latest/userguide/de-data-query.html)
// . To view the available tables and columns, see the Data Exports table
// dictionary (https://docs.aws.amazon.com/cur/latest/userguide/de-table-dictionary.html)
// . The TableConfigurations is a collection of specified TableProperties for the
// table being queried in the QueryStatement . TableProperties are additional
// configurations you can provide to change the data and schema of a table. Each
// table can have different TableProperties. However, tables are not required to
// have any TableProperties. Each table property has a default value that it
// assumes if not specified. For more information on table configurations, see
// Data query (https://docs.aws.amazon.com/cur/latest/userguide/de-data-query.html)
// . To view the table properties available for each table, see the Data Exports
// table dictionary (https://docs.aws.amazon.com/cur/latest/userguide/de-table-dictionary.html)
// or use the ListTables API to get a response of all tables and their available
// properties.
func (c *Client) CreateExport(ctx context.Context, params *CreateExportInput, optFns ...func(*Options)) (*CreateExportOutput, error) {
	if params == nil {
		params = &CreateExportInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateExport", params, optFns, c.addOperationCreateExportMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateExportOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateExportInput struct {

	// The details of the export, including data query, name, description, and
	// destination configuration.
	//
	// This member is required.
	Export *types.Export

	// An optional list of tags to associate with the specified export. Each tag
	// consists of a key and a value, and each key must be unique for the resource.
	ResourceTags []types.ResourceTag

	noSmithyDocumentSerde
}

type CreateExportOutput struct {

	// The Amazon Resource Name (ARN) for this export.
	ExportArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateExportMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateExport{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateExport{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateExport"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateExportValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateExport(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateExport(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateExport",
	}
}
