// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A capability object. Currently, only EDI (electronic data interchange)
// capabilities are supported. A trading capability contains the information
// required to transform incoming EDI documents into JSON or XML outputs.
//
// The following types satisfy this interface:
//
//	CapabilityConfigurationMemberEdi
type CapabilityConfiguration interface {
	isCapabilityConfiguration()
}

// An EDI (electronic data interchange) configuration object.
type CapabilityConfigurationMemberEdi struct {
	Value EdiConfiguration

	noSmithyDocumentSerde
}

func (*CapabilityConfigurationMemberEdi) isCapabilityConfiguration() {}

// Returns the capability summary details. A trading capability contains the
// information required to transform incoming EDI documents into JSON or XML
// outputs.
type CapabilitySummary struct {

	// Returns a system-assigned unique identifier for the capability.
	//
	// This member is required.
	CapabilityId *string

	// Returns a timestamp for creation date and time of the capability.
	//
	// This member is required.
	CreatedAt *time.Time

	// The display name of the capability.
	//
	// This member is required.
	Name *string

	// Returns the type of the capability. Currently, only edi is supported.
	//
	// This member is required.
	Type CapabilityType

	// Returns a timestamp that identifies the most recent date and time that the
	// capability was modified.
	ModifiedAt *time.Time

	noSmithyDocumentSerde
}

// Specifies the details for the EDI (electronic data interchange) transformation.
type EdiConfiguration struct {

	// Contains the Amazon S3 bucket and prefix for the location of the input file,
	// which is contained in an S3Location object.
	//
	// This member is required.
	InputLocation *S3Location

	// Contains the Amazon S3 bucket and prefix for the location of the output file,
	// which is contained in an S3Location object.
	//
	// This member is required.
	OutputLocation *S3Location

	// Returns the system-assigned unique identifier for the transformer.
	//
	// This member is required.
	TransformerId *string

	// Returns the type of the capability. Currently, only edi is supported.
	//
	// This member is required.
	Type EdiType

	noSmithyDocumentSerde
}

// Specifies the details for the EDI standard that is being used for the
// transformer. Currently, only X12 is supported. X12 is a set of standards and
// corresponding messages that define specific business documents.
//
// The following types satisfy this interface:
//
//	EdiTypeMemberX12Details
type EdiType interface {
	isEdiType()
}

// Returns the details for the EDI standard that is being used for the
// transformer. Currently, only X12 is supported. X12 is a set of standards and
// corresponding messages that define specific business documents.
type EdiTypeMemberX12Details struct {
	Value X12Details

	noSmithyDocumentSerde
}

func (*EdiTypeMemberX12Details) isEdiType() {}

// A structure that contains the details for a partnership. A partnership
// represents the connection between you and your trading partner. It ties together
// a profile and one or more trading capabilities.
type PartnershipSummary struct {

	// Returns a timestamp for creation date and time of the partnership.
	//
	// This member is required.
	CreatedAt *time.Time

	// Returns the unique, system-generated identifier for a partnership.
	//
	// This member is required.
	PartnershipId *string

	// Returns the unique, system-generated identifier for the profile connected to
	// this partnership.
	//
	// This member is required.
	ProfileId *string

	// Returns one or more capabilities associated with this partnership.
	Capabilities []string

	// Returns a timestamp that identifies the most recent date and time that the
	// partnership was modified.
	ModifiedAt *time.Time

	// Returns the name of the partnership.
	Name *string

	// Returns the unique, system-generated identifier for a trading partner.
	TradingPartnerId *string

	noSmithyDocumentSerde
}

// Contains the details for a profile. A profile is the mechanism used to create
// the concept of a private network.
type ProfileSummary struct {

	// Returns the name for the business associated with this profile.
	//
	// This member is required.
	BusinessName *string

	// Returns the timestamp for creation date and time of the profile.
	//
	// This member is required.
	CreatedAt *time.Time

	// Returns the display name for profile.
	//
	// This member is required.
	Name *string

	// Returns the unique, system-generated identifier for the profile.
	//
	// This member is required.
	ProfileId *string

	// Returns the name of the logging group.
	LogGroupName *string

	// Specifies whether or not logging is enabled for this profile.
	Logging Logging

	// Returns the timestamp that identifies the most recent date and time that the
	// profile was modified.
	ModifiedAt *time.Time

	noSmithyDocumentSerde
}

// Specifies the details for the Amazon S3 file location that is being used with
// Amazon Web Services B2BI Data Interchange. File locations in Amazon S3 are
// identified using a combination of the bucket and key.
type S3Location struct {

	// Specifies the name of the Amazon S3 bucket.
	BucketName *string

	// Specifies the Amazon S3 key for the file location.
	Key *string

	noSmithyDocumentSerde
}

// Creates a key-value pair for a specific resource. Tags are metadata that you
// can use to search for and group a resource for various purposes. You can apply
// tags to capabilities, partnerships, profiles and transformers. A tag key can
// take more than one value. For example, to group capabilities for accounting
// purposes, you might create a tag called Group and assign the values Research
// and Accounting to that group.
type Tag struct {

	// Specifies the name assigned to the tag that you create.
	//
	// This member is required.
	Key *string

	// Contains one or more values that you assigned to the key name that you create.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Contains the details for a transformer object. A transformer describes how to
// process the incoming EDI documents and extract the necessary information to the
// output file.
type TransformerSummary struct {

	// Returns a timestamp indicating when the transformer was created. For example,
	// 2023-07-20T19:58:44.624Z .
	//
	// This member is required.
	CreatedAt *time.Time

	// Returns the details for the EDI standard that is being used for the
	// transformer. Currently, only X12 is supported. X12 is a set of standards and
	// corresponding messages that define specific business documents.
	//
	// This member is required.
	EdiType EdiType

	// Returns that the currently supported file formats for EDI transformations are
	// JSON and XML .
	//
	// This member is required.
	FileFormat FileFormat

	// Returns the name of the mapping template for the transformer. This template is
	// used to convert the input document into the correct set of objects.
	//
	// This member is required.
	MappingTemplate *string

	// Returns the descriptive name for the transformer.
	//
	// This member is required.
	Name *string

	// Returns the state of the newly created transformer. The transformer can be
	// either active or inactive . For the transformer to be used in a capability, its
	// status must active .
	//
	// This member is required.
	Status TransformerStatus

	// Returns the system-assigned unique identifier for the transformer.
	//
	// This member is required.
	TransformerId *string

	// Returns a timestamp representing the date and time for the most recent change
	// for the transformer object.
	ModifiedAt *time.Time

	// Returns a sample EDI document that is used by a transformer as a guide for
	// processing the EDI data.
	SampleDocument *string

	noSmithyDocumentSerde
}

// A structure that contains the X12 transaction set and version. The X12
// structure is used when the system transforms an EDI (electronic data
// interchange) file. If an EDI input file contains more than one transaction, each
// transaction must have the same transaction set and version, for example
// 214/4010. If not, the transformer cannot parse the file.
type X12Details struct {

	// Returns an enumerated type where each value identifies an X12 transaction set.
	// Transaction sets are maintained by the X12 Accredited Standards Committee.
	TransactionSet X12TransactionSet

	// Returns the version to use for the specified X12 transaction set.
	Version X12Version

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isCapabilityConfiguration() {}
func (*UnknownUnionMember) isEdiType()                 {}
