// Code generated by smithy-go-codegen DO NOT EDIT.

package alexaforbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/alexaforbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the configuration of the report delivery schedule with the specified
// schedule ARN.
//
// Deprecated: Alexa For Business is no longer supported
func (c *Client) UpdateBusinessReportSchedule(ctx context.Context, params *UpdateBusinessReportScheduleInput, optFns ...func(*Options)) (*UpdateBusinessReportScheduleOutput, error) {
	if params == nil {
		params = &UpdateBusinessReportScheduleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateBusinessReportSchedule", params, optFns, c.addOperationUpdateBusinessReportScheduleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateBusinessReportScheduleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateBusinessReportScheduleInput struct {

	// The ARN of the business report schedule.
	//
	// This member is required.
	ScheduleArn *string

	// The format of the generated report (individual CSV files or zipped files of
	// individual files).
	Format types.BusinessReportFormat

	// The recurrence of the reports.
	Recurrence *types.BusinessReportRecurrence

	// The S3 location of the output reports.
	S3BucketName *string

	// The S3 key where the report is delivered.
	S3KeyPrefix *string

	// The name identifier of the schedule.
	ScheduleName *string

	noSmithyDocumentSerde
}

type UpdateBusinessReportScheduleOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateBusinessReportScheduleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateBusinessReportSchedule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateBusinessReportSchedule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateBusinessReportSchedule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateBusinessReportScheduleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateBusinessReportSchedule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateBusinessReportSchedule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateBusinessReportSchedule",
	}
}
