// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The container for abort incomplete multipart upload
type AbortIncompleteMultipartUpload struct {

	// Specifies the number of days after which Amazon S3 aborts an incomplete
	// multipart upload to the Outposts bucket.
	DaysAfterInitiation int32

	noSmithyDocumentSerde
}

// An access point used to access a bucket.
type AccessPoint struct {

	// The name of the bucket associated with this access point.
	//
	// This member is required.
	Bucket *string

	// The name of this access point.
	//
	// This member is required.
	Name *string

	// Indicates whether this access point allows access from the public internet. If
	// VpcConfiguration is specified for this access point, then NetworkOrigin is VPC,
	// and the access point doesn't allow access from the public internet. Otherwise,
	// NetworkOrigin is Internet, and the access point allows access from the public
	// internet, subject to the access point and bucket access policies.
	//
	// This member is required.
	NetworkOrigin NetworkOrigin

	// The ARN for the access point.
	AccessPointArn *string

	// The name or alias of the access point.
	Alias *string

	// The Amazon Web Services account ID associated with the S3 bucket associated with
	// this access point.
	BucketAccountId *string

	// The virtual private cloud (VPC) configuration for this access point, if one
	// exists. This element is empty if this access point is an Amazon S3 on Outposts
	// access point that is used by other Amazon Web Services.
	VpcConfiguration *VpcConfiguration

	noSmithyDocumentSerde
}

// A container for the account-level Amazon S3 Storage Lens configuration. For more
// information about S3 Storage Lens, see Assessing your storage activity and usage
// with S3 Storage Lens
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the
// Amazon S3 User Guide. For a complete list of S3 Storage Lens metrics, see S3
// Storage Lens metrics glossary
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html)
// in the Amazon S3 User Guide.
type AccountLevel struct {

	// A container for the S3 Storage Lens bucket-level configuration.
	//
	// This member is required.
	BucketLevel *BucketLevel

	// A container for S3 Storage Lens activity metrics.
	ActivityMetrics *ActivityMetrics

	// A container for S3 Storage Lens advanced cost-optimization metrics.
	AdvancedCostOptimizationMetrics *AdvancedCostOptimizationMetrics

	// A container for S3 Storage Lens advanced data-protection metrics.
	AdvancedDataProtectionMetrics *AdvancedDataProtectionMetrics

	// A container for detailed status code metrics.
	DetailedStatusCodesMetrics *DetailedStatusCodesMetrics

	noSmithyDocumentSerde
}

// The container element for Amazon S3 Storage Lens activity metrics. Activity
// metrics show details about how your storage is requested, such as requests (for
// example, All requests, Get requests, Put requests), bytes uploaded or
// downloaded, and errors. For more information about S3 Storage Lens, see
// Assessing your storage activity and usage with S3 Storage Lens
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the
// Amazon S3 User Guide. For a complete list of S3 Storage Lens metrics, see S3
// Storage Lens metrics glossary
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html)
// in the Amazon S3 User Guide.
type ActivityMetrics struct {

	// A container that indicates whether activity metrics are enabled.
	IsEnabled bool

	noSmithyDocumentSerde
}

// The container element for Amazon S3 Storage Lens advanced cost-optimization
// metrics. Advanced cost-optimization metrics provide insights that you can use to
// manage and optimize your storage costs, for example, lifecycle rule counts for
// transitions, expirations, and incomplete multipart uploads. For more information
// about S3 Storage Lens, see Assessing your storage activity and usage with S3
// Storage Lens
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the
// Amazon S3 User Guide. For a complete list of S3 Storage Lens metrics, see S3
// Storage Lens metrics glossary
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html)
// in the Amazon S3 User Guide.
type AdvancedCostOptimizationMetrics struct {

	// A container that indicates whether advanced cost-optimization metrics are
	// enabled.
	IsEnabled bool

	noSmithyDocumentSerde
}

// The container element for Amazon S3 Storage Lens advanced data-protection
// metrics. Advanced data-protection metrics provide insights that you can use to
// perform audits and protect your data, for example replication rule counts within
// and across Regions. For more information about S3 Storage Lens, see Assessing
// your storage activity and usage with S3 Storage Lens
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the
// Amazon S3 User Guide. For a complete list of S3 Storage Lens metrics, see S3
// Storage Lens metrics glossary
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html)
// in the Amazon S3 User Guide.
type AdvancedDataProtectionMetrics struct {

	// A container that indicates whether advanced data-protection metrics are enabled.
	IsEnabled bool

	noSmithyDocumentSerde
}

// Error details for the failed asynchronous operation.
type AsyncErrorDetails struct {

	// A string that uniquely identifies the error condition.
	Code *string

	// A generic description of the error condition in English.
	Message *string

	// The ID of the request associated with the error.
	RequestId *string

	// The identifier of the resource associated with the error.
	Resource *string

	noSmithyDocumentSerde
}

// A container for the information about an asynchronous operation.
type AsyncOperation struct {

	// The time that the request was sent to the service.
	CreationTime *time.Time

	// The specific operation for the asynchronous request.
	Operation AsyncOperationName

	// The parameters associated with the request.
	RequestParameters *AsyncRequestParameters

	// The current status of the request.
	RequestStatus *string

	// The request token associated with the request.
	RequestTokenARN *string

	// The details of the response.
	ResponseDetails *AsyncResponseDetails

	noSmithyDocumentSerde
}

// A container for the request parameters associated with an asynchronous request.
type AsyncRequestParameters struct {

	// A container of the parameters for a CreateMultiRegionAccessPoint
	// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
	// request.
	CreateMultiRegionAccessPointRequest *CreateMultiRegionAccessPointInput

	// A container of the parameters for a DeleteMultiRegionAccessPoint
	// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
	// request.
	DeleteMultiRegionAccessPointRequest *DeleteMultiRegionAccessPointInput

	// A container of the parameters for a PutMultiRegionAccessPoint
	// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html)
	// request.
	PutMultiRegionAccessPointPolicyRequest *PutMultiRegionAccessPointPolicyInput

	noSmithyDocumentSerde
}

// A container for the response details that are returned when querying about an
// asynchronous request.
type AsyncResponseDetails struct {

	// Error details for an asynchronous request.
	ErrorDetails *AsyncErrorDetails

	// The details for the Multi-Region Access Point.
	MultiRegionAccessPointDetails *MultiRegionAccessPointsAsyncResponse

	noSmithyDocumentSerde
}

// Lambda function used to transform objects through an Object Lambda Access Point.
type AwsLambdaTransformation struct {

	// The Amazon Resource Name (ARN) of the Lambda function.
	//
	// This member is required.
	FunctionArn *string

	// Additional JSON that provides supplemental data to the Lambda function used to
	// transform objects.
	FunctionPayload *string

	noSmithyDocumentSerde
}

// A container for the bucket-level configuration for Amazon S3 Storage Lens. For
// more information about S3 Storage Lens, see Assessing your storage activity and
// usage with S3 Storage Lens
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the
// Amazon S3 User Guide.
type BucketLevel struct {

	// A container for the bucket-level activity metrics for S3 Storage Lens.
	ActivityMetrics *ActivityMetrics

	// A container for bucket-level advanced cost-optimization metrics for S3 Storage
	// Lens.
	AdvancedCostOptimizationMetrics *AdvancedCostOptimizationMetrics

	// A container for bucket-level advanced data-protection metrics for S3 Storage
	// Lens.
	AdvancedDataProtectionMetrics *AdvancedDataProtectionMetrics

	// A container for bucket-level detailed status code metrics for S3 Storage Lens.
	DetailedStatusCodesMetrics *DetailedStatusCodesMetrics

	// A container for the prefix-level metrics for S3 Storage Lens.
	PrefixLevel *PrefixLevel

	noSmithyDocumentSerde
}

// A container for enabling Amazon CloudWatch publishing for S3 Storage Lens
// metrics. For more information about publishing S3 Storage Lens metrics to
// CloudWatch, see Monitor S3 Storage Lens metrics in CloudWatch
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_view_metrics_cloudwatch.html)
// in the Amazon S3 User Guide.
type CloudWatchMetrics struct {

	// A container that indicates whether CloudWatch publishing for S3 Storage Lens
	// metrics is enabled. A value of true indicates that CloudWatch publishing for S3
	// Storage Lens metrics is enabled.
	//
	// This member is required.
	IsEnabled bool

	noSmithyDocumentSerde
}

// The container for the bucket configuration. This is not supported by Amazon S3
// on Outposts buckets.
type CreateBucketConfiguration struct {

	// Specifies the Region where the bucket will be created. If you are creating a
	// bucket on the US East (N. Virginia) Region (us-east-1), you do not need to
	// specify the location. This is not supported by Amazon S3 on Outposts buckets.
	LocationConstraint BucketLocationConstraint

	noSmithyDocumentSerde
}

// A container for the information associated with a CreateMultiRegionAccessPoint
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
// request.
type CreateMultiRegionAccessPointInput struct {

	// The name of the Multi-Region Access Point associated with this request.
	//
	// This member is required.
	Name *string

	// The buckets in different Regions that are associated with the Multi-Region
	// Access Point.
	//
	// This member is required.
	Regions []Region

	// The PublicAccessBlock configuration that you want to apply to this Amazon S3
	// account. You can enable the configuration options in any combination. For more
	// information about when Amazon S3 considers a bucket or object public, see The
	// Meaning of "Public"
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
	// in the Amazon S3 User Guide. This data type is not supported for Amazon S3 on
	// Outposts.
	PublicAccessBlock *PublicAccessBlockConfiguration

	noSmithyDocumentSerde
}

// A container for the information associated with a DeleteMultiRegionAccessPoint
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
// request.
type DeleteMultiRegionAccessPointInput struct {

	// The name of the Multi-Region Access Point associated with this request.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The container element for Amazon S3 Storage Lens detailed status code metrics.
// Detailed status code metrics generate metrics for HTTP status codes, such as 200
// OK, 403 Forbidden, 503 Service Unavailable and others. For more information
// about S3 Storage Lens, see Assessing your storage activity and usage with S3
// Storage Lens
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the
// Amazon S3 User Guide. For a complete list of S3 Storage Lens metrics, see S3
// Storage Lens metrics glossary
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html)
// in the Amazon S3 User Guide.
type DetailedStatusCodesMetrics struct {

	// A container that indicates whether detailed status code metrics are enabled.
	IsEnabled bool

	noSmithyDocumentSerde
}

// The last established access control policy for a Multi-Region Access Point. When
// you update the policy, the update is first listed as the proposed policy. After
// the update is finished and all Regions have been updated, the proposed policy is
// listed as the established policy. If both policies have the same version number,
// the proposed policy is the established policy.
type EstablishedMultiRegionAccessPointPolicy struct {

	// The details of the last established policy.
	Policy *string

	noSmithyDocumentSerde
}

// A container for what Amazon S3 Storage Lens will exclude.
type Exclude struct {

	// A container for the S3 Storage Lens bucket excludes.
	Buckets []string

	// A container for the S3 Storage Lens Region excludes.
	Regions []string

	noSmithyDocumentSerde
}

// The encryption configuration to use when storing the generated manifest.
type GeneratedManifestEncryption struct {

	// Configuration details on how SSE-KMS is used to encrypt generated manifest
	// objects.
	SSEKMS *SSEKMSEncryption

	// Specifies the use of SSE-S3 to encrypt generated manifest objects.
	SSES3 *SSES3Encryption

	noSmithyDocumentSerde
}

// A container for what Amazon S3 Storage Lens configuration includes.
type Include struct {

	// A container for the S3 Storage Lens bucket includes.
	Buckets []string

	// A container for the S3 Storage Lens Region includes.
	Regions []string

	noSmithyDocumentSerde
}

// A container element for the job configuration and status information returned by
// a Describe Job request.
type JobDescriptor struct {

	// Indicates whether confirmation is required before Amazon S3 begins running the
	// specified job. Confirmation is required only for jobs created through the Amazon
	// S3 console.
	ConfirmationRequired *bool

	// A timestamp indicating when this job was created.
	CreationTime *time.Time

	// The description for this job, if one was provided in this job's Create Job
	// request.
	Description *string

	// If the specified job failed, this field contains information describing the
	// failure.
	FailureReasons []JobFailure

	// The attribute of the JobDescriptor containing details about the job's generated
	// manifest.
	GeneratedManifestDescriptor *S3GeneratedManifestDescriptor

	// The Amazon Resource Name (ARN) for this job.
	JobArn *string

	// The ID for the specified job.
	JobId *string

	// The configuration information for the specified job's manifest object.
	Manifest *JobManifest

	// The manifest generator that was used to generate a job manifest for this job.
	ManifestGenerator JobManifestGenerator

	// The operation that the specified job is configured to run on the objects listed
	// in the manifest.
	Operation *JobOperation

	// The priority of the specified job.
	Priority int32

	// Describes the total number of tasks that the specified job has run, the number
	// of tasks that succeeded, and the number of tasks that failed.
	ProgressSummary *JobProgressSummary

	// Contains the configuration information for the job-completion report if you
	// requested one in the Create Job request.
	Report *JobReport

	// The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role
	// assigned to run the tasks for this job.
	RoleArn *string

	// The current status of the specified job.
	Status JobStatus

	// The reason for updating the job.
	StatusUpdateReason *string

	// The reason why the specified job was suspended. A job is only suspended if you
	// create it through the Amazon S3 console. When you create the job, it enters the
	// Suspended state to await confirmation before running. After you confirm the job,
	// it automatically exits the Suspended state.
	SuspendedCause *string

	// The timestamp when this job was suspended, if it has been suspended.
	SuspendedDate *time.Time

	// A timestamp indicating when this job terminated. A job's termination date is the
	// date and time when it succeeded, failed, or was canceled.
	TerminationDate *time.Time

	noSmithyDocumentSerde
}

// If this job failed, this element indicates why the job failed.
type JobFailure struct {

	// The failure code, if any, for the specified job.
	FailureCode *string

	// The failure reason, if any, for the specified job.
	FailureReason *string

	noSmithyDocumentSerde
}

// Contains the configuration and status information for a single job retrieved as
// part of a job list.
type JobListDescriptor struct {

	// A timestamp indicating when the specified job was created.
	CreationTime *time.Time

	// The user-specified description that was included in the specified job's Create
	// Job request.
	Description *string

	// The ID for the specified job.
	JobId *string

	// The operation that the specified job is configured to run on every object listed
	// in the manifest.
	Operation OperationName

	// The current priority for the specified job.
	Priority int32

	// Describes the total number of tasks that the specified job has run, the number
	// of tasks that succeeded, and the number of tasks that failed.
	ProgressSummary *JobProgressSummary

	// The specified job's current status.
	Status JobStatus

	// A timestamp indicating when the specified job terminated. A job's termination
	// date is the date and time when it succeeded, failed, or was canceled.
	TerminationDate *time.Time

	noSmithyDocumentSerde
}

// Contains the configuration information for a job's manifest.
type JobManifest struct {

	// Contains the information required to locate the specified job's manifest.
	//
	// This member is required.
	Location *JobManifestLocation

	// Describes the format of the specified job's manifest. If the manifest is in CSV
	// format, also describes the columns contained within the manifest.
	//
	// This member is required.
	Spec *JobManifestSpec

	noSmithyDocumentSerde
}

// Configures the type of the job's ManifestGenerator.
//
// The following types satisfy this interface:
//
//	JobManifestGeneratorMemberS3JobManifestGenerator
type JobManifestGenerator interface {
	isJobManifestGenerator()
}

// The S3 job ManifestGenerator's configuration details.
type JobManifestGeneratorMemberS3JobManifestGenerator struct {
	Value S3JobManifestGenerator

	noSmithyDocumentSerde
}

func (*JobManifestGeneratorMemberS3JobManifestGenerator) isJobManifestGenerator() {}

// The filter used to describe a set of objects for the job's manifest.
type JobManifestGeneratorFilter struct {

	// If provided, the generated manifest should include only source bucket objects
	// that were created after this time.
	CreatedAfter *time.Time

	// If provided, the generated manifest should include only source bucket objects
	// that were created before this time.
	CreatedBefore *time.Time

	// Include objects in the generated manifest only if they are eligible for
	// replication according to the Replication configuration on the source bucket.
	EligibleForReplication *bool

	// If provided, the generated manifest should include only source bucket objects
	// that have one of the specified Replication statuses.
	ObjectReplicationStatuses []ReplicationStatus

	noSmithyDocumentSerde
}

// Contains the information required to locate a manifest object.
type JobManifestLocation struct {

	// The ETag for the specified manifest object.
	//
	// This member is required.
	ETag *string

	// The Amazon Resource Name (ARN) for a manifest object. Replacement must be made
	// for object keys containing special characters (such as carriage returns) when
	// using XML requests. For more information, see  XML related object key
	// constraints
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
	//
	// This member is required.
	ObjectArn *string

	// The optional version ID to identify a specific version of the manifest object.
	ObjectVersionId *string

	noSmithyDocumentSerde
}

// Describes the format of a manifest. If the manifest is in CSV format, also
// describes the columns contained within the manifest.
type JobManifestSpec struct {

	// Indicates which of the available formats the specified manifest uses.
	//
	// This member is required.
	Format JobManifestFormat

	// If the specified manifest object is in the S3BatchOperations_CSV_20180820
	// format, this element describes which columns contain the required data.
	Fields []JobManifestFieldName

	noSmithyDocumentSerde
}

// The operation that you want this job to perform on every object listed in the
// manifest. For more information about the available operations, see Operations
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-operations.html) in
// the Amazon S3 User Guide.
type JobOperation struct {

	// Directs the specified job to invoke an Lambda function on every object in the
	// manifest.
	LambdaInvoke *LambdaInvokeOperation

	// Directs the specified job to execute a DELETE Object tagging call on every
	// object in the manifest.
	S3DeleteObjectTagging *S3DeleteObjectTaggingOperation

	// Directs the specified job to initiate restore requests for every archived object
	// in the manifest.
	S3InitiateRestoreObject *S3InitiateRestoreObjectOperation

	// Directs the specified job to run a PutObjectAcl call on every object in the
	// manifest.
	S3PutObjectAcl *S3SetObjectAclOperation

	// Directs the specified job to run a PUT Copy object call on every object in the
	// manifest.
	S3PutObjectCopy *S3CopyObjectOperation

	// Contains the configuration for an S3 Object Lock legal hold operation that an S3
	// Batch Operations job passes every object to the underlying PutObjectLegalHold
	// API. For more information, see Using S3 Object Lock legal hold with S3 Batch
	// Operations
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html) in
	// the Amazon S3 User Guide.
	S3PutObjectLegalHold *S3SetObjectLegalHoldOperation

	// Contains the configuration parameters for the Object Lock retention action for
	// an S3 Batch Operations job. Batch Operations passes every object to the
	// underlying PutObjectRetention API. For more information, see Using S3 Object
	// Lock retention with S3 Batch Operations
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html)
	// in the Amazon S3 User Guide.
	S3PutObjectRetention *S3SetObjectRetentionOperation

	// Directs the specified job to run a PUT Object tagging call on every object in
	// the manifest.
	S3PutObjectTagging *S3SetObjectTaggingOperation

	// Directs the specified job to invoke ReplicateObject on every object in the job's
	// manifest.
	S3ReplicateObject *S3ReplicateObjectOperation

	noSmithyDocumentSerde
}

// Describes the total number of tasks that the specified job has started, the
// number of tasks that succeeded, and the number of tasks that failed.
type JobProgressSummary struct {

	//
	NumberOfTasksFailed *int64

	//
	NumberOfTasksSucceeded *int64

	// The JobTimers attribute of a job's progress summary.
	Timers *JobTimers

	//
	TotalNumberOfTasks *int64

	noSmithyDocumentSerde
}

// Contains the configuration parameters for a job-completion report.
type JobReport struct {

	// Indicates whether the specified job will generate a job-completion report.
	//
	// This member is required.
	Enabled bool

	// The Amazon Resource Name (ARN) for the bucket where specified job-completion
	// report will be stored.
	Bucket *string

	// The format of the specified job-completion report.
	Format JobReportFormat

	// An optional prefix to describe where in the specified bucket the job-completion
	// report will be stored. Amazon S3 stores the job-completion report at
	// /job-/report.json.
	Prefix *string

	// Indicates whether the job-completion report will include details of all tasks or
	// only failed tasks.
	ReportScope JobReportScope

	noSmithyDocumentSerde
}

// Provides timing details for the job.
type JobTimers struct {

	// Indicates the elapsed time in seconds the job has been in the Active job state.
	ElapsedTimeInActiveSeconds *int64

	noSmithyDocumentSerde
}

// Contains the configuration parameters for a Lambda Invoke operation.
type LambdaInvokeOperation struct {

	// The Amazon Resource Name (ARN) for the Lambda function that the specified job
	// will invoke on every object in the manifest.
	FunctionArn *string

	noSmithyDocumentSerde
}

// The container for the Outposts bucket lifecycle configuration.
type LifecycleConfiguration struct {

	// A lifecycle rule for individual objects in an Outposts bucket.
	Rules []LifecycleRule

	noSmithyDocumentSerde
}

// The container of the Outposts bucket lifecycle expiration.
type LifecycleExpiration struct {

	// Indicates at what date the object is to be deleted. Should be in GMT ISO 8601
	// format.
	Date *time.Time

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days int32

	// Indicates whether Amazon S3 will remove a delete marker with no noncurrent
	// versions. If set to true, the delete marker will be expired. If set to false,
	// the policy takes no action. This cannot be specified with Days or Date in a
	// Lifecycle Expiration Policy.
	ExpiredObjectDeleteMarker bool

	noSmithyDocumentSerde
}

// The container for the Outposts bucket lifecycle rule.
type LifecycleRule struct {

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is
	// not currently being applied.
	//
	// This member is required.
	Status ExpirationStatus

	// Specifies the days since the initiation of an incomplete multipart upload that
	// Amazon S3 waits before permanently removing all parts of the upload. For more
	// information, see  Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle
	// Policy
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config)
	// in the Amazon S3 User Guide.
	AbortIncompleteMultipartUpload *AbortIncompleteMultipartUpload

	// Specifies the expiration for the lifecycle of the object in the form of date,
	// days and, whether the object has a delete marker.
	Expiration *LifecycleExpiration

	// The container for the filter of lifecycle rule.
	Filter *LifecycleRuleFilter

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string

	// The noncurrent version expiration of the lifecycle rule.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration

	// Specifies the transition rule for the lifecycle rule that describes when
	// noncurrent objects transition to a specific storage class. If your bucket is
	// versioning-enabled (or versioning is suspended), you can set this action to
	// request that Amazon S3 transition noncurrent object versions to a specific
	// storage class at a set period in the object's lifetime. This is not supported by
	// Amazon S3 on Outposts buckets.
	NoncurrentVersionTransitions []NoncurrentVersionTransition

	// Specifies when an Amazon S3 object transitions to a specified storage class.
	// This is not supported by Amazon S3 on Outposts buckets.
	Transitions []Transition

	noSmithyDocumentSerde
}

// The container for the Outposts bucket lifecycle rule and operator.
type LifecycleRuleAndOperator struct {

	// Minimum object size to which the rule applies.
	ObjectSizeGreaterThan *int64

	// Maximum object size to which the rule applies.
	ObjectSizeLessThan *int64

	// Prefix identifying one or more objects to which the rule applies.
	Prefix *string

	// All of these tags must exist in the object's tag set in order for the rule to
	// apply.
	Tags []S3Tag

	noSmithyDocumentSerde
}

// The container for the filter of the lifecycle rule.
type LifecycleRuleFilter struct {

	// The container for the AND condition for the lifecycle rule.
	And *LifecycleRuleAndOperator

	// Minimum object size to which the rule applies.
	ObjectSizeGreaterThan *int64

	// Maximum object size to which the rule applies.
	ObjectSizeLessThan *int64

	// Prefix identifying one or more objects to which the rule applies. Replacement
	// must be made for object keys containing special characters (such as carriage
	// returns) when using XML requests. For more information, see  XML related object
	// key constraints
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
	Prefix *string

	// A container for a key-value name pair.
	Tag *S3Tag

	noSmithyDocumentSerde
}

// Part of ListStorageLensConfigurationResult. Each entry includes the description
// of the S3 Storage Lens configuration, its home Region, whether it is enabled,
// its Amazon Resource Name (ARN), and config ID.
type ListStorageLensConfigurationEntry struct {

	// A container for the S3 Storage Lens home Region. Your metrics data is stored and
	// retained in your designated S3 Storage Lens home Region.
	//
	// This member is required.
	HomeRegion *string

	// A container for the S3 Storage Lens configuration ID.
	//
	// This member is required.
	Id *string

	// The ARN of the S3 Storage Lens configuration. This property is read-only.
	//
	// This member is required.
	StorageLensArn *string

	// A container for whether the S3 Storage Lens configuration is enabled. This
	// property is required.
	IsEnabled bool

	noSmithyDocumentSerde
}

// The Multi-Region Access Point access control policy. When you update the policy,
// the update is first listed as the proposed policy. After the update is finished
// and all Regions have been updated, the proposed policy is listed as the
// established policy. If both policies have the same version number, the proposed
// policy is the established policy.
type MultiRegionAccessPointPolicyDocument struct {

	// The last established policy for the Multi-Region Access Point.
	Established *EstablishedMultiRegionAccessPointPolicy

	// The proposed policy for the Multi-Region Access Point.
	Proposed *ProposedMultiRegionAccessPointPolicy

	noSmithyDocumentSerde
}

// Status information for a single Multi-Region Access Point Region.
type MultiRegionAccessPointRegionalResponse struct {

	// The name of the Region in the Multi-Region Access Point.
	Name *string

	// The current status of the Multi-Region Access Point in this Region.
	RequestStatus *string

	noSmithyDocumentSerde
}

// A collection of statuses for a Multi-Region Access Point in the various Regions
// it supports.
type MultiRegionAccessPointReport struct {

	// The alias for the Multi-Region Access Point. For more information about the
	// distinction between the name and the alias of an Multi-Region Access Point, see
	// Managing Multi-Region Access Points
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming).
	Alias *string

	// When the Multi-Region Access Point create request was received.
	CreatedAt *time.Time

	// The name of the Multi-Region Access Point.
	Name *string

	// The PublicAccessBlock configuration that you want to apply to this Amazon S3
	// account. You can enable the configuration options in any combination. For more
	// information about when Amazon S3 considers a bucket or object public, see The
	// Meaning of "Public"
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
	// in the Amazon S3 User Guide. This data type is not supported for Amazon S3 on
	// Outposts.
	PublicAccessBlock *PublicAccessBlockConfiguration

	// A collection of the Regions and buckets associated with the Multi-Region Access
	// Point.
	Regions []RegionReport

	// The current status of the Multi-Region Access Point. CREATING and DELETING are
	// temporary states that exist while the request is propagating and being
	// completed. If a Multi-Region Access Point has a status of PARTIALLY_CREATED, you
	// can retry creation or send a request to delete the Multi-Region Access Point. If
	// a Multi-Region Access Point has a status of PARTIALLY_DELETED, you can retry a
	// delete request to finish the deletion of the Multi-Region Access Point.
	Status MultiRegionAccessPointStatus

	noSmithyDocumentSerde
}

// A structure for a Multi-Region Access Point that indicates where Amazon S3
// traffic can be routed. Routes can be either active or passive. Active routes can
// process Amazon S3 requests through the Multi-Region Access Point, but passive
// routes are not eligible to process Amazon S3 requests. Each route contains the
// Amazon S3 bucket name and the Amazon Web Services Region that the bucket is
// located in. The route also includes the TrafficDialPercentage value, which shows
// whether the bucket and Region are active (indicated by a value of 100) or
// passive (indicated by a value of 0).
type MultiRegionAccessPointRoute struct {

	// The traffic state for the specified bucket or Amazon Web Services Region. A
	// value of 0 indicates a passive state, which means that no new traffic will be
	// routed to the Region. A value of 100 indicates an active state, which means that
	// traffic will be routed to the specified Region. When the routing configuration
	// for a Region is changed from active to passive, any in-progress operations
	// (uploads, copies, deletes, and so on) to the formerly active Region will
	// continue to run to until a final success or failure status is reached. If all
	// Regions in the routing configuration are designated as passive, you'll receive
	// an InvalidRequest error.
	//
	// This member is required.
	TrafficDialPercentage *int32

	// The name of the Amazon S3 bucket for which you'll submit a routing configuration
	// change. Either the Bucket or the Region value must be provided. If both are
	// provided, the bucket must be in the specified Region.
	Bucket *string

	// The Amazon Web Services Region to which you'll be submitting a routing
	// configuration change. Either the Bucket or the Region value must be provided. If
	// both are provided, the bucket must be in the specified Region.
	Region *string

	noSmithyDocumentSerde
}

// The Multi-Region Access Point details that are returned when querying about an
// asynchronous request.
type MultiRegionAccessPointsAsyncResponse struct {

	// A collection of status information for the different Regions that a Multi-Region
	// Access Point supports.
	Regions []MultiRegionAccessPointRegionalResponse

	noSmithyDocumentSerde
}

// The container of the noncurrent version expiration.
type NoncurrentVersionExpiration struct {

	// Specifies how many noncurrent versions S3 on Outposts will retain. If there are
	// this many more recent noncurrent versions, S3 on Outposts will take the
	// associated action. For more information about noncurrent versions, see Lifecycle
	// configuration elements
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html)
	// in the Amazon S3 User Guide.
	NewerNoncurrentVersions *int32

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates When an Object Became Noncurrent
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations)
	// in the Amazon S3 User Guide.
	NoncurrentDays int32

	noSmithyDocumentSerde
}

// The container for the noncurrent version transition.
type NoncurrentVersionTransition struct {

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see  How Amazon S3 Calculates How Long an Object Has Been
	// Noncurrent
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations)
	// in the Amazon S3 User Guide.
	NoncurrentDays int32

	// The class of storage used to store the object.
	StorageClass TransitionStorageClass

	noSmithyDocumentSerde
}

// An access point with an attached Lambda function used to access transformed data
// from an Amazon S3 bucket.
type ObjectLambdaAccessPoint struct {

	// The name of the Object Lambda Access Point.
	//
	// This member is required.
	Name *string

	// Specifies the ARN for the Object Lambda Access Point.
	ObjectLambdaAccessPointArn *string

	noSmithyDocumentSerde
}

// A configuration used when creating an Object Lambda Access Point.
type ObjectLambdaConfiguration struct {

	// Standard access point associated with the Object Lambda Access Point.
	//
	// This member is required.
	SupportingAccessPoint *string

	// A container for transformation configurations for an Object Lambda Access Point.
	//
	// This member is required.
	TransformationConfigurations []ObjectLambdaTransformationConfiguration

	// A container for allowed features. Valid inputs are GetObject-Range,
	// GetObject-PartNumber, HeadObject-Range, and HeadObject-PartNumber.
	AllowedFeatures []ObjectLambdaAllowedFeature

	// A container for whether the CloudWatch metrics configuration is enabled.
	CloudWatchMetricsEnabled bool

	noSmithyDocumentSerde
}

// A container for AwsLambdaTransformation.
//
// The following types satisfy this interface:
//
//	ObjectLambdaContentTransformationMemberAwsLambda
type ObjectLambdaContentTransformation interface {
	isObjectLambdaContentTransformation()
}

// A container for an Lambda function.
type ObjectLambdaContentTransformationMemberAwsLambda struct {
	Value AwsLambdaTransformation

	noSmithyDocumentSerde
}

func (*ObjectLambdaContentTransformationMemberAwsLambda) isObjectLambdaContentTransformation() {}

// A configuration used when creating an Object Lambda Access Point transformation.
type ObjectLambdaTransformationConfiguration struct {

	// A container for the action of an Object Lambda Access Point configuration. Valid
	// inputs are GetObject, ListObjects, HeadObject, and ListObjectsV2.
	//
	// This member is required.
	Actions []ObjectLambdaTransformationConfigurationAction

	// A container for the content transformation of an Object Lambda Access Point
	// configuration.
	//
	// This member is required.
	ContentTransformation ObjectLambdaContentTransformation

	noSmithyDocumentSerde
}

// Indicates whether this access point policy is public. For more information about
// how Amazon S3 evaluates policies to determine whether they are public, see The
// Meaning of "Public"
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
// in the Amazon S3 User Guide.
type PolicyStatus struct {

	//
	IsPublic bool

	noSmithyDocumentSerde
}

// A container for the prefix-level configuration.
type PrefixLevel struct {

	// A container for the prefix-level storage metrics for S3 Storage Lens.
	//
	// This member is required.
	StorageMetrics *PrefixLevelStorageMetrics

	noSmithyDocumentSerde
}

// A container for the prefix-level storage metrics for S3 Storage Lens.
type PrefixLevelStorageMetrics struct {

	// A container for whether prefix-level storage metrics are enabled.
	IsEnabled bool

	//
	SelectionCriteria *SelectionCriteria

	noSmithyDocumentSerde
}

// The proposed access control policy for the Multi-Region Access Point. When you
// update the policy, the update is first listed as the proposed policy. After the
// update is finished and all Regions have been updated, the proposed policy is
// listed as the established policy. If both policies have the same version number,
// the proposed policy is the established policy.
type ProposedMultiRegionAccessPointPolicy struct {

	// The details of the proposed policy.
	Policy *string

	noSmithyDocumentSerde
}

// The PublicAccessBlock configuration that you want to apply to this Amazon S3
// account. You can enable the configuration options in any combination. For more
// information about when Amazon S3 considers a bucket or object public, see The
// Meaning of "Public"
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
// in the Amazon S3 User Guide. This data type is not supported for Amazon S3 on
// Outposts.
type PublicAccessBlockConfiguration struct {

	// Specifies whether Amazon S3 should block public access control lists (ACLs) for
	// buckets in this account. Setting this element to TRUE causes the following
	// behavior:
	//
	// * PutBucketAcl and PutObjectAcl calls fail if the specified ACL is
	// public.
	//
	// * PUT Object calls fail if the request includes a public ACL.
	//
	// * PUT
	// Bucket calls fail if the request includes a public ACL.
	//
	// Enabling this setting
	// doesn't affect existing policies or ACLs. This property is not supported for
	// Amazon S3 on Outposts.
	BlockPublicAcls bool

	// Specifies whether Amazon S3 should block public bucket policies for buckets in
	// this account. Setting this element to TRUE causes Amazon S3 to reject calls to
	// PUT Bucket policy if the specified bucket policy allows public access. Enabling
	// this setting doesn't affect existing bucket policies. This property is not
	// supported for Amazon S3 on Outposts.
	BlockPublicPolicy bool

	// Specifies whether Amazon S3 should ignore public ACLs for buckets in this
	// account. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs
	// on buckets in this account and any objects that they contain. Enabling this
	// setting doesn't affect the persistence of any existing ACLs and doesn't prevent
	// new public ACLs from being set. This property is not supported for Amazon S3 on
	// Outposts.
	IgnorePublicAcls bool

	// Specifies whether Amazon S3 should restrict public bucket policies for buckets
	// in this account. Setting this element to TRUE restricts access to buckets with
	// public policies to only Amazon Web Service principals and authorized users
	// within this account. Enabling this setting doesn't affect previously stored
	// bucket policies, except that public and cross-account access within any public
	// bucket policy, including non-public delegation to specific accounts, is blocked.
	// This property is not supported for Amazon S3 on Outposts.
	RestrictPublicBuckets bool

	noSmithyDocumentSerde
}

// A container for the information associated with a PutMultiRegionAccessPoint
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html)
// request.
type PutMultiRegionAccessPointPolicyInput struct {

	// The name of the Multi-Region Access Point associated with the request.
	//
	// This member is required.
	Name *string

	// The policy details for the PutMultiRegionAccessPoint request.
	//
	// This member is required.
	Policy *string

	noSmithyDocumentSerde
}

// A Region that supports a Multi-Region Access Point as well as the associated
// bucket for the Region.
type Region struct {

	// The name of the associated bucket for the Region.
	//
	// This member is required.
	Bucket *string

	noSmithyDocumentSerde
}

// The container for the regional bucket.
type RegionalBucket struct {

	//
	//
	// This member is required.
	Bucket *string

	// The creation date of the regional bucket
	//
	// This member is required.
	CreationDate *time.Time

	//
	//
	// This member is required.
	PublicAccessBlockEnabled bool

	// The Amazon Resource Name (ARN) for the regional bucket.
	BucketArn *string

	// The Outposts ID of the regional bucket.
	OutpostId *string

	noSmithyDocumentSerde
}

// A combination of a bucket and Region that's part of a Multi-Region Access Point.
type RegionReport struct {

	// The name of the bucket.
	Bucket *string

	// The name of the Region.
	Region *string

	noSmithyDocumentSerde
}

type S3AccessControlList struct {

	//
	//
	// This member is required.
	Owner *S3ObjectOwner

	//
	Grants []S3Grant

	noSmithyDocumentSerde
}

type S3AccessControlPolicy struct {

	//
	AccessControlList *S3AccessControlList

	//
	CannedAccessControlList S3CannedAccessControlList

	noSmithyDocumentSerde
}

// A container for the bucket where the Amazon S3 Storage Lens metrics export files
// are located.
type S3BucketDestination struct {

	// The account ID of the owner of the S3 Storage Lens metrics export bucket.
	//
	// This member is required.
	AccountId *string

	// The Amazon Resource Name (ARN) of the bucket. This property is read-only and
	// follows the following format:
	// arn:aws:s3:us-east-1:example-account-id:bucket/your-destination-bucket-name
	//
	// This member is required.
	Arn *string

	//
	//
	// This member is required.
	Format Format

	// The schema version of the export file.
	//
	// This member is required.
	OutputSchemaVersion OutputSchemaVersion

	// The container for the type encryption of the metrics exports in this bucket.
	Encryption *StorageLensDataExportEncryption

	// The prefix of the destination bucket where the metrics export will be delivered.
	Prefix *string

	noSmithyDocumentSerde
}

// Contains the configuration parameters for a PUT Copy object operation. S3 Batch
// Operations passes every object to the underlying PUT Copy object API. For more
// information about the parameters for this operation, see PUT Object - Copy
// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectCOPY.html).
type S3CopyObjectOperation struct {

	//
	AccessControlGrants []S3Grant

	// Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption
	// with server-side encryption using Amazon Web Services KMS (SSE-KMS). Setting
	// this header to true causes Amazon S3 to use an S3 Bucket Key for object
	// encryption with SSE-KMS. Specifying this header with an object action doesn’t
	// affect bucket-level settings for S3 Bucket Key.
	BucketKeyEnabled bool

	//
	CannedAccessControlList S3CannedAccessControlList

	// Indicates the algorithm you want Amazon S3 to use to create the checksum. For
	// more information see  Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/CheckingObjectIntegrity.xml)
	// in the Amazon S3 User Guide.
	ChecksumAlgorithm S3ChecksumAlgorithm

	//
	MetadataDirective S3MetadataDirective

	//
	ModifiedSinceConstraint *time.Time

	// If you don't provide this parameter, Amazon S3 copies all the metadata from the
	// original objects. If you specify an empty set, the new objects will have no
	// tags. Otherwise, Amazon S3 assigns the supplied tags to the new objects.
	NewObjectMetadata *S3ObjectMetadata

	//
	NewObjectTagging []S3Tag

	// The legal hold status to be applied to all objects in the Batch Operations job.
	ObjectLockLegalHoldStatus S3ObjectLockLegalHoldStatus

	// The retention mode to be applied to all objects in the Batch Operations job.
	ObjectLockMode S3ObjectLockMode

	// The date when the applied object retention configuration expires on all objects
	// in the Batch Operations job.
	ObjectLockRetainUntilDate *time.Time

	// Specifies an optional metadata property for website redirects,
	// x-amz-website-redirect-location. Allows webpage redirects if the object is
	// accessed through a website endpoint.
	RedirectLocation *string

	//
	RequesterPays bool

	//
	SSEAwsKmsKeyId *string

	//
	StorageClass S3StorageClass

	// Specifies the folder prefix into which you would like the objects to be copied.
	// For example, to copy objects into a folder named Folder1 in the destination
	// bucket, set the TargetKeyPrefix to Folder1.
	TargetKeyPrefix *string

	// Specifies the destination bucket ARN for the batch copy operation. For example,
	// to copy objects to a bucket named destinationBucket, set the TargetResource
	// property to arn:aws:s3:::destinationBucket.
	TargetResource *string

	//
	UnModifiedSinceConstraint *time.Time

	noSmithyDocumentSerde
}

// Contains no configuration parameters because the DELETE Object tagging API only
// accepts the bucket name and key name as parameters, which are defined in the
// job's manifest.
type S3DeleteObjectTaggingOperation struct {
	noSmithyDocumentSerde
}

// Describes the specified job's generated manifest. Batch Operations jobs created
// with a ManifestGenerator populate details of this descriptor after execution of
// the ManifestGenerator.
type S3GeneratedManifestDescriptor struct {

	// The format of the generated manifest.
	Format GeneratedManifestFormat

	// Contains the information required to locate a manifest object.
	Location *JobManifestLocation

	noSmithyDocumentSerde
}

type S3Grant struct {

	//
	Grantee *S3Grantee

	//
	Permission S3Permission

	noSmithyDocumentSerde
}

type S3Grantee struct {

	//
	DisplayName *string

	//
	Identifier *string

	//
	TypeIdentifier S3GranteeTypeIdentifier

	noSmithyDocumentSerde
}

// Contains the configuration parameters for an S3 Initiate Restore Object job. S3
// Batch Operations passes every object to the underlying POST Object restore API.
// For more information about the parameters for this operation, see RestoreObject
// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html#RESTObjectPOSTrestore-restore-request).
type S3InitiateRestoreObjectOperation struct {

	// This argument specifies how long the S3 Glacier or S3 Glacier Deep Archive
	// object remains available in Amazon S3. S3 Initiate Restore Object jobs that
	// target S3 Glacier and S3 Glacier Deep Archive objects require ExpirationInDays
	// set to 1 or greater. Conversely, do not set ExpirationInDays when creating S3
	// Initiate Restore Object jobs that target S3 Intelligent-Tiering Archive Access
	// and Deep Archive Access tier objects. Objects in S3 Intelligent-Tiering archive
	// access tiers are not subject to restore expiry, so specifying ExpirationInDays
	// results in restore request failure. S3 Batch Operations jobs can operate either
	// on S3 Glacier and S3 Glacier Deep Archive storage class objects or on S3
	// Intelligent-Tiering Archive Access and Deep Archive Access storage tier objects,
	// but not both types in the same job. If you need to restore objects of both types
	// you must create separate Batch Operations jobs.
	ExpirationInDays *int32

	// S3 Batch Operations supports STANDARD and BULK retrieval tiers, but not the
	// EXPEDITED retrieval tier.
	GlacierJobTier S3GlacierJobTier

	noSmithyDocumentSerde
}

// The container for the service that will create the S3 manifest.
type S3JobManifestGenerator struct {

	// Determines whether or not to write the job's generated manifest to a bucket.
	//
	// This member is required.
	EnableManifestOutput bool

	// The source bucket used by the ManifestGenerator.
	//
	// This member is required.
	SourceBucket *string

	// The Amazon Web Services account ID that owns the bucket the generated manifest
	// is written to. If provided the generated manifest bucket's owner Amazon Web
	// Services account ID must match this value, else the job fails.
	ExpectedBucketOwner *string

	// Specifies rules the S3JobManifestGenerator should use to use to decide whether
	// an object in the source bucket should or should not be included in the generated
	// job manifest.
	Filter *JobManifestGeneratorFilter

	// Specifies the location the generated manifest will be written to.
	ManifestOutputLocation *S3ManifestOutputLocation

	noSmithyDocumentSerde
}

// Location details for where the generated manifest should be written.
type S3ManifestOutputLocation struct {

	// The bucket ARN the generated manifest should be written to.
	//
	// This member is required.
	Bucket *string

	// The format of the generated manifest.
	//
	// This member is required.
	ManifestFormat GeneratedManifestFormat

	// The Account ID that owns the bucket the generated manifest is written to.
	ExpectedManifestBucketOwner *string

	// Specifies what encryption should be used when the generated manifest objects are
	// written.
	ManifestEncryption *GeneratedManifestEncryption

	// Prefix identifying one or more objects to which the manifest applies.
	ManifestPrefix *string

	noSmithyDocumentSerde
}

// Whether S3 Object Lock legal hold will be applied to objects in an S3 Batch
// Operations job.
type S3ObjectLockLegalHold struct {

	// The Object Lock legal hold status to be applied to all objects in the Batch
	// Operations job.
	//
	// This member is required.
	Status S3ObjectLockLegalHoldStatus

	noSmithyDocumentSerde
}

type S3ObjectMetadata struct {

	//
	CacheControl *string

	//
	ContentDisposition *string

	//
	ContentEncoding *string

	//
	ContentLanguage *string

	//
	ContentLength *int64

	//
	ContentMD5 *string

	//
	ContentType *string

	//
	HttpExpiresDate *time.Time

	//
	RequesterCharged bool

	//
	SSEAlgorithm S3SSEAlgorithm

	//
	UserMetadata map[string]string

	noSmithyDocumentSerde
}

type S3ObjectOwner struct {

	//
	DisplayName *string

	//
	ID *string

	noSmithyDocumentSerde
}

// Directs the specified job to invoke ReplicateObject on every object in the job's
// manifest.
type S3ReplicateObjectOperation struct {
	noSmithyDocumentSerde
}

// Contains the S3 Object Lock retention mode to be applied to all objects in the
// S3 Batch Operations job. If you don't provide Mode and RetainUntilDate data
// types in your operation, you will remove the retention from your objects. For
// more information, see Using S3 Object Lock retention with S3 Batch Operations
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html)
// in the Amazon S3 User Guide.
type S3Retention struct {

	// The Object Lock retention mode to be applied to all objects in the Batch
	// Operations job.
	Mode S3ObjectLockRetentionMode

	// The date when the applied Object Lock retention will expire on all objects set
	// by the Batch Operations job.
	RetainUntilDate *time.Time

	noSmithyDocumentSerde
}

// Contains the configuration parameters for a Set Object ACL operation. S3 Batch
// Operations passes every object to the underlying PutObjectAcl API. For more
// information about the parameters for this operation, see PutObjectAcl
// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTacl.html).
type S3SetObjectAclOperation struct {

	//
	AccessControlPolicy *S3AccessControlPolicy

	noSmithyDocumentSerde
}

// Contains the configuration for an S3 Object Lock legal hold operation that an S3
// Batch Operations job passes every object to the underlying PutObjectLegalHold
// API. For more information, see Using S3 Object Lock legal hold with S3 Batch
// Operations
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html) in
// the Amazon S3 User Guide.
type S3SetObjectLegalHoldOperation struct {

	// Contains the Object Lock legal hold status to be applied to all objects in the
	// Batch Operations job.
	//
	// This member is required.
	LegalHold *S3ObjectLockLegalHold

	noSmithyDocumentSerde
}

// Contains the configuration parameters for the Object Lock retention action for
// an S3 Batch Operations job. Batch Operations passes every object to the
// underlying PutObjectRetention API. For more information, see Using S3 Object
// Lock retention with S3 Batch Operations
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html)
// in the Amazon S3 User Guide.
type S3SetObjectRetentionOperation struct {

	// Contains the Object Lock retention mode to be applied to all objects in the
	// Batch Operations job. For more information, see Using S3 Object Lock retention
	// with S3 Batch Operations
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html)
	// in the Amazon S3 User Guide.
	//
	// This member is required.
	Retention *S3Retention

	// Indicates if the action should be applied to objects in the Batch Operations job
	// even if they have Object Lock  GOVERNANCE type in place.
	BypassGovernanceRetention *bool

	noSmithyDocumentSerde
}

// Contains the configuration parameters for a Set Object Tagging operation. S3
// Batch Operations passes every object to the underlying PUT Object tagging API.
// For more information about the parameters for this operation, see PUT Object
// tagging
// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTtagging.html).
type S3SetObjectTaggingOperation struct {

	//
	TagSet []S3Tag

	noSmithyDocumentSerde
}

// A container for a key-value name pair.
type S3Tag struct {

	// Key of the tag
	//
	// This member is required.
	Key *string

	// Value of the tag
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type SelectionCriteria struct {

	// A container for the delimiter of the selection criteria being used.
	Delimiter *string

	// The max depth of the selection criteria
	MaxDepth int32

	// The minimum number of storage bytes percentage whose metrics will be selected.
	// You must choose a value greater than or equal to 1.0.
	MinStorageBytesPercentage float64

	noSmithyDocumentSerde
}

type SSEKMS struct {

	// A container for the ARN of the SSE-KMS encryption. This property is read-only
	// and follows the following format:
	// arn:aws:kms:us-east-1:example-account-id:key/example-9a73-4afc-8d29-8f5900cef44e
	//
	// This member is required.
	KeyId *string

	noSmithyDocumentSerde
}

// Configuration for the use of SSE-KMS to encrypt generated manifest objects.
type SSEKMSEncryption struct {

	// Specifies the ID of the Amazon Web Services Key Management Service (Amazon Web
	// Services KMS) symmetric encryption customer managed key to use for encrypting
	// generated manifest objects.
	//
	// This member is required.
	KeyId *string

	noSmithyDocumentSerde
}

type SSES3 struct {
	noSmithyDocumentSerde
}

// Configuration for the use of SSE-S3 to encrypt generated manifest objects.
type SSES3Encryption struct {
	noSmithyDocumentSerde
}

// The Amazon Web Services organization for your S3 Storage Lens.
type StorageLensAwsOrg struct {

	// A container for the Amazon Resource Name (ARN) of the Amazon Web Services
	// organization. This property is read-only and follows the following format:
	// arn:aws:organizations:us-east-1:example-account-id:organization/o-ex2l495dck
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

// A container for the Amazon S3 Storage Lens configuration.
type StorageLensConfiguration struct {

	// A container for all the account-level configurations of your S3 Storage Lens
	// configuration.
	//
	// This member is required.
	AccountLevel *AccountLevel

	// A container for the Amazon S3 Storage Lens configuration ID.
	//
	// This member is required.
	Id *string

	// A container for whether the S3 Storage Lens configuration is enabled.
	//
	// This member is required.
	IsEnabled bool

	// A container for the Amazon Web Services organization for this S3 Storage Lens
	// configuration.
	AwsOrg *StorageLensAwsOrg

	// A container to specify the properties of your S3 Storage Lens metrics export
	// including, the destination, schema and format.
	DataExport *StorageLensDataExport

	// A container for what is excluded in this configuration. This container can only
	// be valid if there is no Include container submitted, and it's not empty.
	Exclude *Exclude

	// A container for what is included in this configuration. This container can only
	// be valid if there is no Exclude container submitted, and it's not empty.
	Include *Include

	// The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This
	// property is read-only and follows the following format:
	// arn:aws:s3:us-east-1:example-account-id:storage-lens/your-dashboard-name
	StorageLensArn *string

	noSmithyDocumentSerde
}

// A container to specify the properties of your S3 Storage Lens metrics export,
// including the destination, schema, and format.
type StorageLensDataExport struct {

	// A container for enabling Amazon CloudWatch publishing for S3 Storage Lens
	// metrics.
	CloudWatchMetrics *CloudWatchMetrics

	// A container for the bucket where the S3 Storage Lens metrics export will be
	// located. This bucket must be located in the same Region as the storage lens
	// configuration.
	S3BucketDestination *S3BucketDestination

	noSmithyDocumentSerde
}

// A container for the encryption of the S3 Storage Lens metrics exports.
type StorageLensDataExportEncryption struct {

	//
	SSEKMS *SSEKMS

	//
	SSES3 *SSES3

	noSmithyDocumentSerde
}

type StorageLensTag struct {

	//
	//
	// This member is required.
	Key *string

	//
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type Tagging struct {

	// A collection for a set of tags.
	//
	// This member is required.
	TagSet []S3Tag

	noSmithyDocumentSerde
}

// Specifies when an object transitions to a specified storage class. For more
// information about Amazon S3 Lifecycle configuration rules, see  Transitioning
// objects using Amazon S3 Lifecycle
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html)
// in the Amazon S3 User Guide.
type Transition struct {

	// Indicates when objects are transitioned to the specified storage class. The date
	// value must be in ISO 8601 format. The time is always midnight UTC.
	Date *time.Time

	// Indicates the number of days after creation when objects are transitioned to the
	// specified storage class. The value must be a positive integer.
	Days int32

	// The storage class to which you want the object to transition.
	StorageClass TransitionStorageClass

	noSmithyDocumentSerde
}

// Describes the versioning state of an Amazon S3 on Outposts bucket. For more
// information, see PutBucketVersioning
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketVersioning.html).
type VersioningConfiguration struct {

	// Specifies whether MFA delete is enabled or disabled in the bucket versioning
	// configuration for the S3 on Outposts bucket.
	MFADelete MFADelete

	// Sets the versioning state of the S3 on Outposts bucket.
	Status BucketVersioningStatus

	noSmithyDocumentSerde
}

// The virtual private cloud (VPC) configuration for an access point.
type VpcConfiguration struct {

	// If this field is specified, this access point will only allow connections from
	// the specified VPC ID.
	//
	// This member is required.
	VpcId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isJobManifestGenerator()              {}
func (*UnknownUnionMember) isObjectLambdaContentTransformation() {}
