// Code generated by smithy-go-codegen DO NOT EDIT.

package medialive

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/medialive/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpAcceptInputDeviceTransfer struct {
}

func (*awsRestjson1_serializeOpAcceptInputDeviceTransfer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAcceptInputDeviceTransfer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcceptInputDeviceTransferInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputDevices/{InputDeviceId}/accept")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAcceptInputDeviceTransferInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAcceptInputDeviceTransferInput(v *AcceptInputDeviceTransferInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputDeviceId == nil || len(*v.InputDeviceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputDeviceId must not be empty")}
	}
	if v.InputDeviceId != nil {
		if err := encoder.SetURI("InputDeviceId").String(*v.InputDeviceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchDelete struct {
}

func (*awsRestjson1_serializeOpBatchDelete) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchDelete) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/batch/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchDeleteInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchDeleteInput(v *BatchDeleteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchDeleteInput(v *BatchDeleteInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelIds != nil {
		ok := object.Key("channelIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.ChannelIds, ok); err != nil {
			return err
		}
	}

	if v.InputIds != nil {
		ok := object.Key("inputIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.InputIds, ok); err != nil {
			return err
		}
	}

	if v.InputSecurityGroupIds != nil {
		ok := object.Key("inputSecurityGroupIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.InputSecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.MultiplexIds != nil {
		ok := object.Key("multiplexIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.MultiplexIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchStart struct {
}

func (*awsRestjson1_serializeOpBatchStart) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchStart) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchStartInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/batch/start")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchStartInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchStartInput(v *BatchStartInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchStartInput(v *BatchStartInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelIds != nil {
		ok := object.Key("channelIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.ChannelIds, ok); err != nil {
			return err
		}
	}

	if v.MultiplexIds != nil {
		ok := object.Key("multiplexIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.MultiplexIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchStop struct {
}

func (*awsRestjson1_serializeOpBatchStop) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchStop) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchStopInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/batch/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchStopInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchStopInput(v *BatchStopInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchStopInput(v *BatchStopInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelIds != nil {
		ok := object.Key("channelIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.ChannelIds, ok); err != nil {
			return err
		}
	}

	if v.MultiplexIds != nil {
		ok := object.Key("multiplexIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.MultiplexIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchUpdateSchedule struct {
}

func (*awsRestjson1_serializeOpBatchUpdateSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchUpdateSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchUpdateScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/channels/{ChannelId}/schedule")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchUpdateScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchUpdateScheduleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchUpdateScheduleInput(v *BatchUpdateScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelId == nil || len(*v.ChannelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelId must not be empty")}
	}
	if v.ChannelId != nil {
		if err := encoder.SetURI("ChannelId").String(*v.ChannelId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchUpdateScheduleInput(v *BatchUpdateScheduleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Creates != nil {
		ok := object.Key("creates")
		if err := awsRestjson1_serializeDocumentBatchScheduleActionCreateRequest(v.Creates, ok); err != nil {
			return err
		}
	}

	if v.Deletes != nil {
		ok := object.Key("deletes")
		if err := awsRestjson1_serializeDocumentBatchScheduleActionDeleteRequest(v.Deletes, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCancelInputDeviceTransfer struct {
}

func (*awsRestjson1_serializeOpCancelInputDeviceTransfer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelInputDeviceTransfer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelInputDeviceTransferInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputDevices/{InputDeviceId}/cancel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelInputDeviceTransferInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelInputDeviceTransferInput(v *CancelInputDeviceTransferInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputDeviceId == nil || len(*v.InputDeviceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputDeviceId must not be empty")}
	}
	if v.InputDeviceId != nil {
		if err := encoder.SetURI("InputDeviceId").String(*v.InputDeviceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpClaimDevice struct {
}

func (*awsRestjson1_serializeOpClaimDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpClaimDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ClaimDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/claimDevice")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentClaimDeviceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsClaimDeviceInput(v *ClaimDeviceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentClaimDeviceInput(v *ClaimDeviceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	return nil
}

type awsRestjson1_serializeOpCreateChannel struct {
}

func (*awsRestjson1_serializeOpCreateChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/channels")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateChannelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateChannelInput(v *CreateChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateChannelInput(v *CreateChannelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CdiInputSpecification != nil {
		ok := object.Key("cdiInputSpecification")
		if err := awsRestjson1_serializeDocumentCdiInputSpecification(v.CdiInputSpecification, ok); err != nil {
			return err
		}
	}

	if len(v.ChannelClass) > 0 {
		ok := object.Key("channelClass")
		ok.String(string(v.ChannelClass))
	}

	if v.Destinations != nil {
		ok := object.Key("destinations")
		if err := awsRestjson1_serializeDocument__listOfOutputDestination(v.Destinations, ok); err != nil {
			return err
		}
	}

	if v.EncoderSettings != nil {
		ok := object.Key("encoderSettings")
		if err := awsRestjson1_serializeDocumentEncoderSettings(v.EncoderSettings, ok); err != nil {
			return err
		}
	}

	if v.InputAttachments != nil {
		ok := object.Key("inputAttachments")
		if err := awsRestjson1_serializeDocument__listOfInputAttachment(v.InputAttachments, ok); err != nil {
			return err
		}
	}

	if v.InputSpecification != nil {
		ok := object.Key("inputSpecification")
		if err := awsRestjson1_serializeDocumentInputSpecification(v.InputSpecification, ok); err != nil {
			return err
		}
	}

	if len(v.LogLevel) > 0 {
		ok := object.Key("logLevel")
		ok.String(string(v.LogLevel))
	}

	if v.Maintenance != nil {
		ok := object.Key("maintenance")
		if err := awsRestjson1_serializeDocumentMaintenanceCreateSettings(v.Maintenance, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RequestId != nil {
		ok := object.Key("requestId")
		ok.String(*v.RequestId)
	}

	if v.Reserved != nil {
		ok := object.Key("reserved")
		ok.String(*v.Reserved)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Vpc != nil {
		ok := object.Key("vpc")
		if err := awsRestjson1_serializeDocumentVpcOutputSettings(v.Vpc, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateInput struct {
}

func (*awsRestjson1_serializeOpCreateInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateInputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateInputInput(v *CreateInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateInputInput(v *CreateInputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destinations != nil {
		ok := object.Key("destinations")
		if err := awsRestjson1_serializeDocument__listOfInputDestinationRequest(v.Destinations, ok); err != nil {
			return err
		}
	}

	if v.InputDevices != nil {
		ok := object.Key("inputDevices")
		if err := awsRestjson1_serializeDocument__listOfInputDeviceSettings(v.InputDevices, ok); err != nil {
			return err
		}
	}

	if v.InputSecurityGroups != nil {
		ok := object.Key("inputSecurityGroups")
		if err := awsRestjson1_serializeDocument__listOf__string(v.InputSecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.MediaConnectFlows != nil {
		ok := object.Key("mediaConnectFlows")
		if err := awsRestjson1_serializeDocument__listOfMediaConnectFlowRequest(v.MediaConnectFlows, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RequestId != nil {
		ok := object.Key("requestId")
		ok.String(*v.RequestId)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Sources != nil {
		ok := object.Key("sources")
		if err := awsRestjson1_serializeDocument__listOfInputSourceRequest(v.Sources, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	if v.Vpc != nil {
		ok := object.Key("vpc")
		if err := awsRestjson1_serializeDocumentInputVpcRequest(v.Vpc, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateInputSecurityGroup struct {
}

func (*awsRestjson1_serializeOpCreateInputSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateInputSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateInputSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputSecurityGroups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateInputSecurityGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateInputSecurityGroupInput(v *CreateInputSecurityGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateInputSecurityGroupInput(v *CreateInputSecurityGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.WhitelistRules != nil {
		ok := object.Key("whitelistRules")
		if err := awsRestjson1_serializeDocument__listOfInputWhitelistRuleCidr(v.WhitelistRules, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateMultiplex struct {
}

func (*awsRestjson1_serializeOpCreateMultiplex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateMultiplex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMultiplexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/multiplexes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateMultiplexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateMultiplexInput(v *CreateMultiplexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateMultiplexInput(v *CreateMultiplexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityZones != nil {
		ok := object.Key("availabilityZones")
		if err := awsRestjson1_serializeDocument__listOf__string(v.AvailabilityZones, ok); err != nil {
			return err
		}
	}

	if v.MultiplexSettings != nil {
		ok := object.Key("multiplexSettings")
		if err := awsRestjson1_serializeDocumentMultiplexSettings(v.MultiplexSettings, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RequestId != nil {
		ok := object.Key("requestId")
		ok.String(*v.RequestId)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateMultiplexProgram struct {
}

func (*awsRestjson1_serializeOpCreateMultiplexProgram) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateMultiplexProgram) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMultiplexProgramInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/multiplexes/{MultiplexId}/programs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateMultiplexProgramInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateMultiplexProgramInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateMultiplexProgramInput(v *CreateMultiplexProgramInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MultiplexId == nil || len(*v.MultiplexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MultiplexId must not be empty")}
	}
	if v.MultiplexId != nil {
		if err := encoder.SetURI("MultiplexId").String(*v.MultiplexId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateMultiplexProgramInput(v *CreateMultiplexProgramInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MultiplexProgramSettings != nil {
		ok := object.Key("multiplexProgramSettings")
		if err := awsRestjson1_serializeDocumentMultiplexProgramSettings(v.MultiplexProgramSettings, ok); err != nil {
			return err
		}
	}

	if v.ProgramName != nil {
		ok := object.Key("programName")
		ok.String(*v.ProgramName)
	}

	if v.RequestId != nil {
		ok := object.Key("requestId")
		ok.String(*v.RequestId)
	}

	return nil
}

type awsRestjson1_serializeOpCreatePartnerInput struct {
}

func (*awsRestjson1_serializeOpCreatePartnerInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePartnerInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePartnerInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputs/{InputId}/partners")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreatePartnerInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePartnerInputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePartnerInputInput(v *CreatePartnerInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputId == nil || len(*v.InputId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputId must not be empty")}
	}
	if v.InputId != nil {
		if err := encoder.SetURI("InputId").String(*v.InputId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePartnerInputInput(v *CreatePartnerInputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RequestId != nil {
		ok := object.Key("requestId")
		ok.String(*v.RequestId)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateTags struct {
}

func (*awsRestjson1_serializeOpCreateTags) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateTagsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTagsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTagsInput(v *CreateTagsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTagsInput(v *CreateTagsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChannel struct {
}

func (*awsRestjson1_serializeOpDeleteChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/channels/{ChannelId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChannelInput(v *DeleteChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelId == nil || len(*v.ChannelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelId must not be empty")}
	}
	if v.ChannelId != nil {
		if err := encoder.SetURI("ChannelId").String(*v.ChannelId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteInput struct {
}

func (*awsRestjson1_serializeOpDeleteInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputs/{InputId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteInputInput(v *DeleteInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputId == nil || len(*v.InputId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputId must not be empty")}
	}
	if v.InputId != nil {
		if err := encoder.SetURI("InputId").String(*v.InputId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteInputSecurityGroup struct {
}

func (*awsRestjson1_serializeOpDeleteInputSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteInputSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteInputSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputSecurityGroups/{InputSecurityGroupId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteInputSecurityGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteInputSecurityGroupInput(v *DeleteInputSecurityGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputSecurityGroupId == nil || len(*v.InputSecurityGroupId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputSecurityGroupId must not be empty")}
	}
	if v.InputSecurityGroupId != nil {
		if err := encoder.SetURI("InputSecurityGroupId").String(*v.InputSecurityGroupId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteMultiplex struct {
}

func (*awsRestjson1_serializeOpDeleteMultiplex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteMultiplex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMultiplexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/multiplexes/{MultiplexId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteMultiplexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteMultiplexInput(v *DeleteMultiplexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MultiplexId == nil || len(*v.MultiplexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MultiplexId must not be empty")}
	}
	if v.MultiplexId != nil {
		if err := encoder.SetURI("MultiplexId").String(*v.MultiplexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteMultiplexProgram struct {
}

func (*awsRestjson1_serializeOpDeleteMultiplexProgram) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteMultiplexProgram) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMultiplexProgramInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/multiplexes/{MultiplexId}/programs/{ProgramName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteMultiplexProgramInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteMultiplexProgramInput(v *DeleteMultiplexProgramInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MultiplexId == nil || len(*v.MultiplexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MultiplexId must not be empty")}
	}
	if v.MultiplexId != nil {
		if err := encoder.SetURI("MultiplexId").String(*v.MultiplexId); err != nil {
			return err
		}
	}

	if v.ProgramName == nil || len(*v.ProgramName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ProgramName must not be empty")}
	}
	if v.ProgramName != nil {
		if err := encoder.SetURI("ProgramName").String(*v.ProgramName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteReservation struct {
}

func (*awsRestjson1_serializeOpDeleteReservation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteReservation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteReservationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/reservations/{ReservationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteReservationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteReservationInput(v *DeleteReservationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ReservationId == nil || len(*v.ReservationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ReservationId must not be empty")}
	}
	if v.ReservationId != nil {
		if err := encoder.SetURI("ReservationId").String(*v.ReservationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteSchedule struct {
}

func (*awsRestjson1_serializeOpDeleteSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/channels/{ChannelId}/schedule")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteScheduleInput(v *DeleteScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelId == nil || len(*v.ChannelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelId must not be empty")}
	}
	if v.ChannelId != nil {
		if err := encoder.SetURI("ChannelId").String(*v.ChannelId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTags struct {
}

func (*awsRestjson1_serializeOpDeleteTags) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTagsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTagsInput(v *DeleteTagsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeChannel struct {
}

func (*awsRestjson1_serializeOpDescribeChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/channels/{ChannelId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeChannelInput(v *DescribeChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelId == nil || len(*v.ChannelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelId must not be empty")}
	}
	if v.ChannelId != nil {
		if err := encoder.SetURI("ChannelId").String(*v.ChannelId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeInput struct {
}

func (*awsRestjson1_serializeOpDescribeInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputs/{InputId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeInputInput(v *DescribeInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputId == nil || len(*v.InputId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputId must not be empty")}
	}
	if v.InputId != nil {
		if err := encoder.SetURI("InputId").String(*v.InputId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeInputDevice struct {
}

func (*awsRestjson1_serializeOpDescribeInputDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeInputDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInputDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputDevices/{InputDeviceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeInputDeviceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeInputDeviceInput(v *DescribeInputDeviceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputDeviceId == nil || len(*v.InputDeviceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputDeviceId must not be empty")}
	}
	if v.InputDeviceId != nil {
		if err := encoder.SetURI("InputDeviceId").String(*v.InputDeviceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeInputDeviceThumbnail struct {
}

func (*awsRestjson1_serializeOpDescribeInputDeviceThumbnail) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeInputDeviceThumbnail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInputDeviceThumbnailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputDevices/{InputDeviceId}/thumbnailData")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeInputDeviceThumbnailInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeInputDeviceThumbnailInput(v *DescribeInputDeviceThumbnailInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.Accept) > 0 {
		locationName := "Accept"
		encoder.SetHeader(locationName).String(string(v.Accept))
	}

	if v.InputDeviceId == nil || len(*v.InputDeviceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputDeviceId must not be empty")}
	}
	if v.InputDeviceId != nil {
		if err := encoder.SetURI("InputDeviceId").String(*v.InputDeviceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeInputSecurityGroup struct {
}

func (*awsRestjson1_serializeOpDescribeInputSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeInputSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInputSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputSecurityGroups/{InputSecurityGroupId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeInputSecurityGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeInputSecurityGroupInput(v *DescribeInputSecurityGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputSecurityGroupId == nil || len(*v.InputSecurityGroupId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputSecurityGroupId must not be empty")}
	}
	if v.InputSecurityGroupId != nil {
		if err := encoder.SetURI("InputSecurityGroupId").String(*v.InputSecurityGroupId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeMultiplex struct {
}

func (*awsRestjson1_serializeOpDescribeMultiplex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeMultiplex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMultiplexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/multiplexes/{MultiplexId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeMultiplexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeMultiplexInput(v *DescribeMultiplexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MultiplexId == nil || len(*v.MultiplexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MultiplexId must not be empty")}
	}
	if v.MultiplexId != nil {
		if err := encoder.SetURI("MultiplexId").String(*v.MultiplexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeMultiplexProgram struct {
}

func (*awsRestjson1_serializeOpDescribeMultiplexProgram) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeMultiplexProgram) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMultiplexProgramInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/multiplexes/{MultiplexId}/programs/{ProgramName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeMultiplexProgramInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeMultiplexProgramInput(v *DescribeMultiplexProgramInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MultiplexId == nil || len(*v.MultiplexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MultiplexId must not be empty")}
	}
	if v.MultiplexId != nil {
		if err := encoder.SetURI("MultiplexId").String(*v.MultiplexId); err != nil {
			return err
		}
	}

	if v.ProgramName == nil || len(*v.ProgramName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ProgramName must not be empty")}
	}
	if v.ProgramName != nil {
		if err := encoder.SetURI("ProgramName").String(*v.ProgramName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeOffering struct {
}

func (*awsRestjson1_serializeOpDescribeOffering) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeOffering) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeOfferingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/offerings/{OfferingId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeOfferingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeOfferingInput(v *DescribeOfferingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.OfferingId == nil || len(*v.OfferingId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OfferingId must not be empty")}
	}
	if v.OfferingId != nil {
		if err := encoder.SetURI("OfferingId").String(*v.OfferingId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeReservation struct {
}

func (*awsRestjson1_serializeOpDescribeReservation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeReservation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReservationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/reservations/{ReservationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeReservationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeReservationInput(v *DescribeReservationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ReservationId == nil || len(*v.ReservationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ReservationId must not be empty")}
	}
	if v.ReservationId != nil {
		if err := encoder.SetURI("ReservationId").String(*v.ReservationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeSchedule struct {
}

func (*awsRestjson1_serializeOpDescribeSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/channels/{ChannelId}/schedule")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeScheduleInput(v *DescribeScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelId == nil || len(*v.ChannelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelId must not be empty")}
	}
	if v.ChannelId != nil {
		if err := encoder.SetURI("ChannelId").String(*v.ChannelId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListChannels struct {
}

func (*awsRestjson1_serializeOpListChannels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChannels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChannelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/channels")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListChannelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChannelsInput(v *ListChannelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListInputDevices struct {
}

func (*awsRestjson1_serializeOpListInputDevices) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListInputDevices) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInputDevicesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputDevices")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListInputDevicesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListInputDevicesInput(v *ListInputDevicesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListInputDeviceTransfers struct {
}

func (*awsRestjson1_serializeOpListInputDeviceTransfers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListInputDeviceTransfers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInputDeviceTransfersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputDeviceTransfers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListInputDeviceTransfersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListInputDeviceTransfersInput(v *ListInputDeviceTransfersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.TransferType != nil {
		encoder.SetQuery("transferType").String(*v.TransferType)
	}

	return nil
}

type awsRestjson1_serializeOpListInputs struct {
}

func (*awsRestjson1_serializeOpListInputs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListInputs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInputsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListInputsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListInputsInput(v *ListInputsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListInputSecurityGroups struct {
}

func (*awsRestjson1_serializeOpListInputSecurityGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListInputSecurityGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInputSecurityGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputSecurityGroups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListInputSecurityGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListInputSecurityGroupsInput(v *ListInputSecurityGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListMultiplexes struct {
}

func (*awsRestjson1_serializeOpListMultiplexes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMultiplexes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMultiplexesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/multiplexes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMultiplexesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMultiplexesInput(v *ListMultiplexesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListMultiplexPrograms struct {
}

func (*awsRestjson1_serializeOpListMultiplexPrograms) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMultiplexPrograms) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMultiplexProgramsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/multiplexes/{MultiplexId}/programs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMultiplexProgramsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMultiplexProgramsInput(v *ListMultiplexProgramsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.MultiplexId == nil || len(*v.MultiplexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MultiplexId must not be empty")}
	}
	if v.MultiplexId != nil {
		if err := encoder.SetURI("MultiplexId").String(*v.MultiplexId); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListOfferings struct {
}

func (*awsRestjson1_serializeOpListOfferings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListOfferings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListOfferingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/offerings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListOfferingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListOfferingsInput(v *ListOfferingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelClass != nil {
		encoder.SetQuery("channelClass").String(*v.ChannelClass)
	}

	if v.ChannelConfiguration != nil {
		encoder.SetQuery("channelConfiguration").String(*v.ChannelConfiguration)
	}

	if v.Codec != nil {
		encoder.SetQuery("codec").String(*v.Codec)
	}

	if v.Duration != nil {
		encoder.SetQuery("duration").String(*v.Duration)
	}

	if v.MaximumBitrate != nil {
		encoder.SetQuery("maximumBitrate").String(*v.MaximumBitrate)
	}

	if v.MaximumFramerate != nil {
		encoder.SetQuery("maximumFramerate").String(*v.MaximumFramerate)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.Resolution != nil {
		encoder.SetQuery("resolution").String(*v.Resolution)
	}

	if v.ResourceType != nil {
		encoder.SetQuery("resourceType").String(*v.ResourceType)
	}

	if v.SpecialFeature != nil {
		encoder.SetQuery("specialFeature").String(*v.SpecialFeature)
	}

	if v.VideoQuality != nil {
		encoder.SetQuery("videoQuality").String(*v.VideoQuality)
	}

	return nil
}

type awsRestjson1_serializeOpListReservations struct {
}

func (*awsRestjson1_serializeOpListReservations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListReservations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListReservationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/reservations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListReservationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListReservationsInput(v *ListReservationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelClass != nil {
		encoder.SetQuery("channelClass").String(*v.ChannelClass)
	}

	if v.Codec != nil {
		encoder.SetQuery("codec").String(*v.Codec)
	}

	if v.MaximumBitrate != nil {
		encoder.SetQuery("maximumBitrate").String(*v.MaximumBitrate)
	}

	if v.MaximumFramerate != nil {
		encoder.SetQuery("maximumFramerate").String(*v.MaximumFramerate)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.Resolution != nil {
		encoder.SetQuery("resolution").String(*v.Resolution)
	}

	if v.ResourceType != nil {
		encoder.SetQuery("resourceType").String(*v.ResourceType)
	}

	if v.SpecialFeature != nil {
		encoder.SetQuery("specialFeature").String(*v.SpecialFeature)
	}

	if v.VideoQuality != nil {
		encoder.SetQuery("videoQuality").String(*v.VideoQuality)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPurchaseOffering struct {
}

func (*awsRestjson1_serializeOpPurchaseOffering) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPurchaseOffering) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PurchaseOfferingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/offerings/{OfferingId}/purchase")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPurchaseOfferingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPurchaseOfferingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPurchaseOfferingInput(v *PurchaseOfferingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.OfferingId == nil || len(*v.OfferingId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OfferingId must not be empty")}
	}
	if v.OfferingId != nil {
		if err := encoder.SetURI("OfferingId").String(*v.OfferingId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPurchaseOfferingInput(v *PurchaseOfferingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("count")
		ok.Integer(v.Count)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RenewalSettings != nil {
		ok := object.Key("renewalSettings")
		if err := awsRestjson1_serializeDocumentRenewalSettings(v.RenewalSettings, ok); err != nil {
			return err
		}
	}

	if v.RequestId != nil {
		ok := object.Key("requestId")
		ok.String(*v.RequestId)
	}

	if v.Start != nil {
		ok := object.Key("start")
		ok.String(*v.Start)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRebootInputDevice struct {
}

func (*awsRestjson1_serializeOpRebootInputDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRebootInputDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RebootInputDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputDevices/{InputDeviceId}/reboot")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRebootInputDeviceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRebootInputDeviceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRebootInputDeviceInput(v *RebootInputDeviceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputDeviceId == nil || len(*v.InputDeviceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputDeviceId must not be empty")}
	}
	if v.InputDeviceId != nil {
		if err := encoder.SetURI("InputDeviceId").String(*v.InputDeviceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRebootInputDeviceInput(v *RebootInputDeviceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Force) > 0 {
		ok := object.Key("force")
		ok.String(string(v.Force))
	}

	return nil
}

type awsRestjson1_serializeOpRejectInputDeviceTransfer struct {
}

func (*awsRestjson1_serializeOpRejectInputDeviceTransfer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRejectInputDeviceTransfer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RejectInputDeviceTransferInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputDevices/{InputDeviceId}/reject")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRejectInputDeviceTransferInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRejectInputDeviceTransferInput(v *RejectInputDeviceTransferInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputDeviceId == nil || len(*v.InputDeviceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputDeviceId must not be empty")}
	}
	if v.InputDeviceId != nil {
		if err := encoder.SetURI("InputDeviceId").String(*v.InputDeviceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartChannel struct {
}

func (*awsRestjson1_serializeOpStartChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/channels/{ChannelId}/start")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartChannelInput(v *StartChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelId == nil || len(*v.ChannelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelId must not be empty")}
	}
	if v.ChannelId != nil {
		if err := encoder.SetURI("ChannelId").String(*v.ChannelId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartInputDeviceMaintenanceWindow struct {
}

func (*awsRestjson1_serializeOpStartInputDeviceMaintenanceWindow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartInputDeviceMaintenanceWindow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartInputDeviceMaintenanceWindowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputDevices/{InputDeviceId}/startInputDeviceMaintenanceWindow")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartInputDeviceMaintenanceWindowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartInputDeviceMaintenanceWindowInput(v *StartInputDeviceMaintenanceWindowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputDeviceId == nil || len(*v.InputDeviceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputDeviceId must not be empty")}
	}
	if v.InputDeviceId != nil {
		if err := encoder.SetURI("InputDeviceId").String(*v.InputDeviceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartMultiplex struct {
}

func (*awsRestjson1_serializeOpStartMultiplex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartMultiplex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartMultiplexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/multiplexes/{MultiplexId}/start")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartMultiplexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartMultiplexInput(v *StartMultiplexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MultiplexId == nil || len(*v.MultiplexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MultiplexId must not be empty")}
	}
	if v.MultiplexId != nil {
		if err := encoder.SetURI("MultiplexId").String(*v.MultiplexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopChannel struct {
}

func (*awsRestjson1_serializeOpStopChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/channels/{ChannelId}/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopChannelInput(v *StopChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelId == nil || len(*v.ChannelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelId must not be empty")}
	}
	if v.ChannelId != nil {
		if err := encoder.SetURI("ChannelId").String(*v.ChannelId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopMultiplex struct {
}

func (*awsRestjson1_serializeOpStopMultiplex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopMultiplex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopMultiplexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/multiplexes/{MultiplexId}/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopMultiplexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopMultiplexInput(v *StopMultiplexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MultiplexId == nil || len(*v.MultiplexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MultiplexId must not be empty")}
	}
	if v.MultiplexId != nil {
		if err := encoder.SetURI("MultiplexId").String(*v.MultiplexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTransferInputDevice struct {
}

func (*awsRestjson1_serializeOpTransferInputDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTransferInputDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TransferInputDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputDevices/{InputDeviceId}/transfer")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTransferInputDeviceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTransferInputDeviceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTransferInputDeviceInput(v *TransferInputDeviceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputDeviceId == nil || len(*v.InputDeviceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputDeviceId must not be empty")}
	}
	if v.InputDeviceId != nil {
		if err := encoder.SetURI("InputDeviceId").String(*v.InputDeviceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTransferInputDeviceInput(v *TransferInputDeviceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetCustomerId != nil {
		ok := object.Key("targetCustomerId")
		ok.String(*v.TargetCustomerId)
	}

	if v.TargetRegion != nil {
		ok := object.Key("targetRegion")
		ok.String(*v.TargetRegion)
	}

	if v.TransferMessage != nil {
		ok := object.Key("transferMessage")
		ok.String(*v.TransferMessage)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateChannel struct {
}

func (*awsRestjson1_serializeOpUpdateChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/channels/{ChannelId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateChannelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateChannelInput(v *UpdateChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelId == nil || len(*v.ChannelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelId must not be empty")}
	}
	if v.ChannelId != nil {
		if err := encoder.SetURI("ChannelId").String(*v.ChannelId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateChannelInput(v *UpdateChannelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CdiInputSpecification != nil {
		ok := object.Key("cdiInputSpecification")
		if err := awsRestjson1_serializeDocumentCdiInputSpecification(v.CdiInputSpecification, ok); err != nil {
			return err
		}
	}

	if v.Destinations != nil {
		ok := object.Key("destinations")
		if err := awsRestjson1_serializeDocument__listOfOutputDestination(v.Destinations, ok); err != nil {
			return err
		}
	}

	if v.EncoderSettings != nil {
		ok := object.Key("encoderSettings")
		if err := awsRestjson1_serializeDocumentEncoderSettings(v.EncoderSettings, ok); err != nil {
			return err
		}
	}

	if v.InputAttachments != nil {
		ok := object.Key("inputAttachments")
		if err := awsRestjson1_serializeDocument__listOfInputAttachment(v.InputAttachments, ok); err != nil {
			return err
		}
	}

	if v.InputSpecification != nil {
		ok := object.Key("inputSpecification")
		if err := awsRestjson1_serializeDocumentInputSpecification(v.InputSpecification, ok); err != nil {
			return err
		}
	}

	if len(v.LogLevel) > 0 {
		ok := object.Key("logLevel")
		ok.String(string(v.LogLevel))
	}

	if v.Maintenance != nil {
		ok := object.Key("maintenance")
		if err := awsRestjson1_serializeDocumentMaintenanceUpdateSettings(v.Maintenance, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateChannelClass struct {
}

func (*awsRestjson1_serializeOpUpdateChannelClass) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateChannelClass) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateChannelClassInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/channels/{ChannelId}/channelClass")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateChannelClassInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateChannelClassInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateChannelClassInput(v *UpdateChannelClassInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelId == nil || len(*v.ChannelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelId must not be empty")}
	}
	if v.ChannelId != nil {
		if err := encoder.SetURI("ChannelId").String(*v.ChannelId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateChannelClassInput(v *UpdateChannelClassInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ChannelClass) > 0 {
		ok := object.Key("channelClass")
		ok.String(string(v.ChannelClass))
	}

	if v.Destinations != nil {
		ok := object.Key("destinations")
		if err := awsRestjson1_serializeDocument__listOfOutputDestination(v.Destinations, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateInput struct {
}

func (*awsRestjson1_serializeOpUpdateInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputs/{InputId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateInputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateInputInput(v *UpdateInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputId == nil || len(*v.InputId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputId must not be empty")}
	}
	if v.InputId != nil {
		if err := encoder.SetURI("InputId").String(*v.InputId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateInputInput(v *UpdateInputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destinations != nil {
		ok := object.Key("destinations")
		if err := awsRestjson1_serializeDocument__listOfInputDestinationRequest(v.Destinations, ok); err != nil {
			return err
		}
	}

	if v.InputDevices != nil {
		ok := object.Key("inputDevices")
		if err := awsRestjson1_serializeDocument__listOfInputDeviceRequest(v.InputDevices, ok); err != nil {
			return err
		}
	}

	if v.InputSecurityGroups != nil {
		ok := object.Key("inputSecurityGroups")
		if err := awsRestjson1_serializeDocument__listOf__string(v.InputSecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.MediaConnectFlows != nil {
		ok := object.Key("mediaConnectFlows")
		if err := awsRestjson1_serializeDocument__listOfMediaConnectFlowRequest(v.MediaConnectFlows, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Sources != nil {
		ok := object.Key("sources")
		if err := awsRestjson1_serializeDocument__listOfInputSourceRequest(v.Sources, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateInputDevice struct {
}

func (*awsRestjson1_serializeOpUpdateInputDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateInputDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateInputDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputDevices/{InputDeviceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateInputDeviceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateInputDeviceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateInputDeviceInput(v *UpdateInputDeviceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputDeviceId == nil || len(*v.InputDeviceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputDeviceId must not be empty")}
	}
	if v.InputDeviceId != nil {
		if err := encoder.SetURI("InputDeviceId").String(*v.InputDeviceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateInputDeviceInput(v *UpdateInputDeviceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HdDeviceSettings != nil {
		ok := object.Key("hdDeviceSettings")
		if err := awsRestjson1_serializeDocumentInputDeviceConfigurableSettings(v.HdDeviceSettings, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.UhdDeviceSettings != nil {
		ok := object.Key("uhdDeviceSettings")
		if err := awsRestjson1_serializeDocumentInputDeviceConfigurableSettings(v.UhdDeviceSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateInputSecurityGroup struct {
}

func (*awsRestjson1_serializeOpUpdateInputSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateInputSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateInputSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/inputSecurityGroups/{InputSecurityGroupId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateInputSecurityGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateInputSecurityGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateInputSecurityGroupInput(v *UpdateInputSecurityGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputSecurityGroupId == nil || len(*v.InputSecurityGroupId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InputSecurityGroupId must not be empty")}
	}
	if v.InputSecurityGroupId != nil {
		if err := encoder.SetURI("InputSecurityGroupId").String(*v.InputSecurityGroupId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateInputSecurityGroupInput(v *UpdateInputSecurityGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.WhitelistRules != nil {
		ok := object.Key("whitelistRules")
		if err := awsRestjson1_serializeDocument__listOfInputWhitelistRuleCidr(v.WhitelistRules, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateMultiplex struct {
}

func (*awsRestjson1_serializeOpUpdateMultiplex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateMultiplex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateMultiplexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/multiplexes/{MultiplexId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateMultiplexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateMultiplexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateMultiplexInput(v *UpdateMultiplexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MultiplexId == nil || len(*v.MultiplexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MultiplexId must not be empty")}
	}
	if v.MultiplexId != nil {
		if err := encoder.SetURI("MultiplexId").String(*v.MultiplexId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateMultiplexInput(v *UpdateMultiplexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MultiplexSettings != nil {
		ok := object.Key("multiplexSettings")
		if err := awsRestjson1_serializeDocumentMultiplexSettings(v.MultiplexSettings, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateMultiplexProgram struct {
}

func (*awsRestjson1_serializeOpUpdateMultiplexProgram) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateMultiplexProgram) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateMultiplexProgramInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/multiplexes/{MultiplexId}/programs/{ProgramName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateMultiplexProgramInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateMultiplexProgramInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateMultiplexProgramInput(v *UpdateMultiplexProgramInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MultiplexId == nil || len(*v.MultiplexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MultiplexId must not be empty")}
	}
	if v.MultiplexId != nil {
		if err := encoder.SetURI("MultiplexId").String(*v.MultiplexId); err != nil {
			return err
		}
	}

	if v.ProgramName == nil || len(*v.ProgramName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ProgramName must not be empty")}
	}
	if v.ProgramName != nil {
		if err := encoder.SetURI("ProgramName").String(*v.ProgramName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateMultiplexProgramInput(v *UpdateMultiplexProgramInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MultiplexProgramSettings != nil {
		ok := object.Key("multiplexProgramSettings")
		if err := awsRestjson1_serializeDocumentMultiplexProgramSettings(v.MultiplexProgramSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateReservation struct {
}

func (*awsRestjson1_serializeOpUpdateReservation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateReservation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateReservationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prod/reservations/{ReservationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateReservationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateReservationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateReservationInput(v *UpdateReservationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ReservationId == nil || len(*v.ReservationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ReservationId must not be empty")}
	}
	if v.ReservationId != nil {
		if err := encoder.SetURI("ReservationId").String(*v.ReservationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateReservationInput(v *UpdateReservationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RenewalSettings != nil {
		ok := object.Key("renewalSettings")
		if err := awsRestjson1_serializeDocumentRenewalSettings(v.RenewalSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocument__listOf__string(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAudioChannelMapping(v []types.AudioChannelMapping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAudioChannelMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAudioDescription(v []types.AudioDescription, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAudioDescription(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAudioSelector(v []types.AudioSelector, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAudioSelector(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAudioTrack(v []types.AudioTrack, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAudioTrack(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfCaptionDescription(v []types.CaptionDescription, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCaptionDescription(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfCaptionLanguageMapping(v []types.CaptionLanguageMapping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCaptionLanguageMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfCaptionSelector(v []types.CaptionSelector, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCaptionSelector(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfFailoverCondition(v []types.FailoverCondition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFailoverCondition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfHlsAdMarkers(v []types.HlsAdMarkers, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfInputAttachment(v []types.InputAttachment, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInputAttachment(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfInputChannelLevel(v []types.InputChannelLevel, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInputChannelLevel(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfInputDestinationRequest(v []types.InputDestinationRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInputDestinationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfInputDeviceRequest(v []types.InputDeviceRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInputDeviceRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfInputDeviceSettings(v []types.InputDeviceSettings, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInputDeviceSettings(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfInputSourceRequest(v []types.InputSourceRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInputSourceRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfInputWhitelistRuleCidr(v []types.InputWhitelistRuleCidr, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInputWhitelistRuleCidr(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfMediaConnectFlowRequest(v []types.MediaConnectFlowRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMediaConnectFlowRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfMediaPackageOutputDestinationSettings(v []types.MediaPackageOutputDestinationSettings, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMediaPackageOutputDestinationSettings(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfOutput(v []types.Output, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentOutput(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfOutputDestination(v []types.OutputDestination, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentOutputDestination(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfOutputDestinationSettings(v []types.OutputDestinationSettings, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentOutputDestinationSettings(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfOutputGroup(v []types.OutputGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentOutputGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfPipelinePauseStateSettings(v []types.PipelinePauseStateSettings, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPipelinePauseStateSettings(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfRtmpAdMarkers(v []types.RtmpAdMarkers, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfScheduleAction(v []types.ScheduleAction, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentScheduleAction(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfScte35Descriptor(v []types.Scte35Descriptor, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentScte35Descriptor(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfVideoDescription(v []types.VideoDescription, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentVideoDescription(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAacSettings(v *types.AacSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bitrate != 0 {
		ok := object.Key("bitrate")
		switch {
		case math.IsNaN(v.Bitrate):
			ok.String("NaN")

		case math.IsInf(v.Bitrate, 1):
			ok.String("Infinity")

		case math.IsInf(v.Bitrate, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Bitrate)

		}
	}

	if len(v.CodingMode) > 0 {
		ok := object.Key("codingMode")
		ok.String(string(v.CodingMode))
	}

	if len(v.InputType) > 0 {
		ok := object.Key("inputType")
		ok.String(string(v.InputType))
	}

	if len(v.Profile) > 0 {
		ok := object.Key("profile")
		ok.String(string(v.Profile))
	}

	if len(v.RateControlMode) > 0 {
		ok := object.Key("rateControlMode")
		ok.String(string(v.RateControlMode))
	}

	if len(v.RawFormat) > 0 {
		ok := object.Key("rawFormat")
		ok.String(string(v.RawFormat))
	}

	if v.SampleRate != 0 {
		ok := object.Key("sampleRate")
		switch {
		case math.IsNaN(v.SampleRate):
			ok.String("NaN")

		case math.IsInf(v.SampleRate, 1):
			ok.String("Infinity")

		case math.IsInf(v.SampleRate, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.SampleRate)

		}
	}

	if len(v.Spec) > 0 {
		ok := object.Key("spec")
		ok.String(string(v.Spec))
	}

	if len(v.VbrQuality) > 0 {
		ok := object.Key("vbrQuality")
		ok.String(string(v.VbrQuality))
	}

	return nil
}

func awsRestjson1_serializeDocumentAc3Settings(v *types.Ac3Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bitrate != 0 {
		ok := object.Key("bitrate")
		switch {
		case math.IsNaN(v.Bitrate):
			ok.String("NaN")

		case math.IsInf(v.Bitrate, 1):
			ok.String("Infinity")

		case math.IsInf(v.Bitrate, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Bitrate)

		}
	}

	if len(v.BitstreamMode) > 0 {
		ok := object.Key("bitstreamMode")
		ok.String(string(v.BitstreamMode))
	}

	if len(v.CodingMode) > 0 {
		ok := object.Key("codingMode")
		ok.String(string(v.CodingMode))
	}

	if v.Dialnorm != 0 {
		ok := object.Key("dialnorm")
		ok.Integer(v.Dialnorm)
	}

	if len(v.DrcProfile) > 0 {
		ok := object.Key("drcProfile")
		ok.String(string(v.DrcProfile))
	}

	if len(v.LfeFilter) > 0 {
		ok := object.Key("lfeFilter")
		ok.String(string(v.LfeFilter))
	}

	if len(v.MetadataControl) > 0 {
		ok := object.Key("metadataControl")
		ok.String(string(v.MetadataControl))
	}

	return nil
}

func awsRestjson1_serializeDocumentAncillarySourceSettings(v *types.AncillarySourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SourceAncillaryChannelNumber != 0 {
		ok := object.Key("sourceAncillaryChannelNumber")
		ok.Integer(v.SourceAncillaryChannelNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentArchiveCdnSettings(v *types.ArchiveCdnSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ArchiveS3Settings != nil {
		ok := object.Key("archiveS3Settings")
		if err := awsRestjson1_serializeDocumentArchiveS3Settings(v.ArchiveS3Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentArchiveContainerSettings(v *types.ArchiveContainerSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.M2tsSettings != nil {
		ok := object.Key("m2tsSettings")
		if err := awsRestjson1_serializeDocumentM2tsSettings(v.M2tsSettings, ok); err != nil {
			return err
		}
	}

	if v.RawSettings != nil {
		ok := object.Key("rawSettings")
		if err := awsRestjson1_serializeDocumentRawSettings(v.RawSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentArchiveGroupSettings(v *types.ArchiveGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ArchiveCdnSettings != nil {
		ok := object.Key("archiveCdnSettings")
		if err := awsRestjson1_serializeDocumentArchiveCdnSettings(v.ArchiveCdnSettings, ok); err != nil {
			return err
		}
	}

	if v.Destination != nil {
		ok := object.Key("destination")
		if err := awsRestjson1_serializeDocumentOutputLocationRef(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.RolloverInterval != 0 {
		ok := object.Key("rolloverInterval")
		ok.Integer(v.RolloverInterval)
	}

	return nil
}

func awsRestjson1_serializeDocumentArchiveOutputSettings(v *types.ArchiveOutputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerSettings != nil {
		ok := object.Key("containerSettings")
		if err := awsRestjson1_serializeDocumentArchiveContainerSettings(v.ContainerSettings, ok); err != nil {
			return err
		}
	}

	if v.Extension != nil {
		ok := object.Key("extension")
		ok.String(*v.Extension)
	}

	if v.NameModifier != nil {
		ok := object.Key("nameModifier")
		ok.String(*v.NameModifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentArchiveS3Settings(v *types.ArchiveS3Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CannedAcl) > 0 {
		ok := object.Key("cannedAcl")
		ok.String(string(v.CannedAcl))
	}

	return nil
}

func awsRestjson1_serializeDocumentAribDestinationSettings(v *types.AribDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentAribSourceSettings(v *types.AribSourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentAudioChannelMapping(v *types.AudioChannelMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputChannelLevels != nil {
		ok := object.Key("inputChannelLevels")
		if err := awsRestjson1_serializeDocument__listOfInputChannelLevel(v.InputChannelLevels, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("outputChannel")
		ok.Integer(v.OutputChannel)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioCodecSettings(v *types.AudioCodecSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AacSettings != nil {
		ok := object.Key("aacSettings")
		if err := awsRestjson1_serializeDocumentAacSettings(v.AacSettings, ok); err != nil {
			return err
		}
	}

	if v.Ac3Settings != nil {
		ok := object.Key("ac3Settings")
		if err := awsRestjson1_serializeDocumentAc3Settings(v.Ac3Settings, ok); err != nil {
			return err
		}
	}

	if v.Eac3AtmosSettings != nil {
		ok := object.Key("eac3AtmosSettings")
		if err := awsRestjson1_serializeDocumentEac3AtmosSettings(v.Eac3AtmosSettings, ok); err != nil {
			return err
		}
	}

	if v.Eac3Settings != nil {
		ok := object.Key("eac3Settings")
		if err := awsRestjson1_serializeDocumentEac3Settings(v.Eac3Settings, ok); err != nil {
			return err
		}
	}

	if v.Mp2Settings != nil {
		ok := object.Key("mp2Settings")
		if err := awsRestjson1_serializeDocumentMp2Settings(v.Mp2Settings, ok); err != nil {
			return err
		}
	}

	if v.PassThroughSettings != nil {
		ok := object.Key("passThroughSettings")
		if err := awsRestjson1_serializeDocumentPassThroughSettings(v.PassThroughSettings, ok); err != nil {
			return err
		}
	}

	if v.WavSettings != nil {
		ok := object.Key("wavSettings")
		if err := awsRestjson1_serializeDocumentWavSettings(v.WavSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioDescription(v *types.AudioDescription, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioNormalizationSettings != nil {
		ok := object.Key("audioNormalizationSettings")
		if err := awsRestjson1_serializeDocumentAudioNormalizationSettings(v.AudioNormalizationSettings, ok); err != nil {
			return err
		}
	}

	if v.AudioSelectorName != nil {
		ok := object.Key("audioSelectorName")
		ok.String(*v.AudioSelectorName)
	}

	if len(v.AudioType) > 0 {
		ok := object.Key("audioType")
		ok.String(string(v.AudioType))
	}

	if len(v.AudioTypeControl) > 0 {
		ok := object.Key("audioTypeControl")
		ok.String(string(v.AudioTypeControl))
	}

	if v.AudioWatermarkingSettings != nil {
		ok := object.Key("audioWatermarkingSettings")
		if err := awsRestjson1_serializeDocumentAudioWatermarkSettings(v.AudioWatermarkingSettings, ok); err != nil {
			return err
		}
	}

	if v.CodecSettings != nil {
		ok := object.Key("codecSettings")
		if err := awsRestjson1_serializeDocumentAudioCodecSettings(v.CodecSettings, ok); err != nil {
			return err
		}
	}

	if v.LanguageCode != nil {
		ok := object.Key("languageCode")
		ok.String(*v.LanguageCode)
	}

	if len(v.LanguageCodeControl) > 0 {
		ok := object.Key("languageCodeControl")
		ok.String(string(v.LanguageCodeControl))
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RemixSettings != nil {
		ok := object.Key("remixSettings")
		if err := awsRestjson1_serializeDocumentRemixSettings(v.RemixSettings, ok); err != nil {
			return err
		}
	}

	if v.StreamName != nil {
		ok := object.Key("streamName")
		ok.String(*v.StreamName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioDolbyEDecode(v *types.AudioDolbyEDecode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ProgramSelection) > 0 {
		ok := object.Key("programSelection")
		ok.String(string(v.ProgramSelection))
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioHlsRenditionSelection(v *types.AudioHlsRenditionSelection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupId != nil {
		ok := object.Key("groupId")
		ok.String(*v.GroupId)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioLanguageSelection(v *types.AudioLanguageSelection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LanguageCode != nil {
		ok := object.Key("languageCode")
		ok.String(*v.LanguageCode)
	}

	if len(v.LanguageSelectionPolicy) > 0 {
		ok := object.Key("languageSelectionPolicy")
		ok.String(string(v.LanguageSelectionPolicy))
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioNormalizationSettings(v *types.AudioNormalizationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Algorithm) > 0 {
		ok := object.Key("algorithm")
		ok.String(string(v.Algorithm))
	}

	if len(v.AlgorithmControl) > 0 {
		ok := object.Key("algorithmControl")
		ok.String(string(v.AlgorithmControl))
	}

	if v.TargetLkfs != 0 {
		ok := object.Key("targetLkfs")
		switch {
		case math.IsNaN(v.TargetLkfs):
			ok.String("NaN")

		case math.IsInf(v.TargetLkfs, 1):
			ok.String("Infinity")

		case math.IsInf(v.TargetLkfs, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.TargetLkfs)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioOnlyHlsSettings(v *types.AudioOnlyHlsSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioGroupId != nil {
		ok := object.Key("audioGroupId")
		ok.String(*v.AudioGroupId)
	}

	if v.AudioOnlyImage != nil {
		ok := object.Key("audioOnlyImage")
		if err := awsRestjson1_serializeDocumentInputLocation(v.AudioOnlyImage, ok); err != nil {
			return err
		}
	}

	if len(v.AudioTrackType) > 0 {
		ok := object.Key("audioTrackType")
		ok.String(string(v.AudioTrackType))
	}

	if len(v.SegmentType) > 0 {
		ok := object.Key("segmentType")
		ok.String(string(v.SegmentType))
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioPidSelection(v *types.AudioPidSelection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("pid")
		ok.Integer(v.Pid)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioSelector(v *types.AudioSelector, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SelectorSettings != nil {
		ok := object.Key("selectorSettings")
		if err := awsRestjson1_serializeDocumentAudioSelectorSettings(v.SelectorSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioSelectorSettings(v *types.AudioSelectorSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioHlsRenditionSelection != nil {
		ok := object.Key("audioHlsRenditionSelection")
		if err := awsRestjson1_serializeDocumentAudioHlsRenditionSelection(v.AudioHlsRenditionSelection, ok); err != nil {
			return err
		}
	}

	if v.AudioLanguageSelection != nil {
		ok := object.Key("audioLanguageSelection")
		if err := awsRestjson1_serializeDocumentAudioLanguageSelection(v.AudioLanguageSelection, ok); err != nil {
			return err
		}
	}

	if v.AudioPidSelection != nil {
		ok := object.Key("audioPidSelection")
		if err := awsRestjson1_serializeDocumentAudioPidSelection(v.AudioPidSelection, ok); err != nil {
			return err
		}
	}

	if v.AudioTrackSelection != nil {
		ok := object.Key("audioTrackSelection")
		if err := awsRestjson1_serializeDocumentAudioTrackSelection(v.AudioTrackSelection, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioSilenceFailoverSettings(v *types.AudioSilenceFailoverSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioSelectorName != nil {
		ok := object.Key("audioSelectorName")
		ok.String(*v.AudioSelectorName)
	}

	if v.AudioSilenceThresholdMsec != 0 {
		ok := object.Key("audioSilenceThresholdMsec")
		ok.Integer(v.AudioSilenceThresholdMsec)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioTrack(v *types.AudioTrack, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("track")
		ok.Integer(v.Track)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioTrackSelection(v *types.AudioTrackSelection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DolbyEDecode != nil {
		ok := object.Key("dolbyEDecode")
		if err := awsRestjson1_serializeDocumentAudioDolbyEDecode(v.DolbyEDecode, ok); err != nil {
			return err
		}
	}

	if v.Tracks != nil {
		ok := object.Key("tracks")
		if err := awsRestjson1_serializeDocument__listOfAudioTrack(v.Tracks, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioWatermarkSettings(v *types.AudioWatermarkSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NielsenWatermarksSettings != nil {
		ok := object.Key("nielsenWatermarksSettings")
		if err := awsRestjson1_serializeDocumentNielsenWatermarksSettings(v.NielsenWatermarksSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAutomaticInputFailoverSettings(v *types.AutomaticInputFailoverSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ErrorClearTimeMsec != 0 {
		ok := object.Key("errorClearTimeMsec")
		ok.Integer(v.ErrorClearTimeMsec)
	}

	if v.FailoverConditions != nil {
		ok := object.Key("failoverConditions")
		if err := awsRestjson1_serializeDocument__listOfFailoverCondition(v.FailoverConditions, ok); err != nil {
			return err
		}
	}

	if len(v.InputPreference) > 0 {
		ok := object.Key("inputPreference")
		ok.String(string(v.InputPreference))
	}

	if v.SecondaryInputId != nil {
		ok := object.Key("secondaryInputId")
		ok.String(*v.SecondaryInputId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAvailBlanking(v *types.AvailBlanking, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailBlankingImage != nil {
		ok := object.Key("availBlankingImage")
		if err := awsRestjson1_serializeDocumentInputLocation(v.AvailBlankingImage, ok); err != nil {
			return err
		}
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentAvailConfiguration(v *types.AvailConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailSettings != nil {
		ok := object.Key("availSettings")
		if err := awsRestjson1_serializeDocumentAvailSettings(v.AvailSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAvailSettings(v *types.AvailSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Esam != nil {
		ok := object.Key("esam")
		if err := awsRestjson1_serializeDocumentEsam(v.Esam, ok); err != nil {
			return err
		}
	}

	if v.Scte35SpliceInsert != nil {
		ok := object.Key("scte35SpliceInsert")
		if err := awsRestjson1_serializeDocumentScte35SpliceInsert(v.Scte35SpliceInsert, ok); err != nil {
			return err
		}
	}

	if v.Scte35TimeSignalApos != nil {
		ok := object.Key("scte35TimeSignalApos")
		if err := awsRestjson1_serializeDocumentScte35TimeSignalApos(v.Scte35TimeSignalApos, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchScheduleActionCreateRequest(v *types.BatchScheduleActionCreateRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ScheduleActions != nil {
		ok := object.Key("scheduleActions")
		if err := awsRestjson1_serializeDocument__listOfScheduleAction(v.ScheduleActions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchScheduleActionDeleteRequest(v *types.BatchScheduleActionDeleteRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionNames != nil {
		ok := object.Key("actionNames")
		if err := awsRestjson1_serializeDocument__listOf__string(v.ActionNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBlackoutSlate(v *types.BlackoutSlate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlackoutSlateImage != nil {
		ok := object.Key("blackoutSlateImage")
		if err := awsRestjson1_serializeDocumentInputLocation(v.BlackoutSlateImage, ok); err != nil {
			return err
		}
	}

	if len(v.NetworkEndBlackout) > 0 {
		ok := object.Key("networkEndBlackout")
		ok.String(string(v.NetworkEndBlackout))
	}

	if v.NetworkEndBlackoutImage != nil {
		ok := object.Key("networkEndBlackoutImage")
		if err := awsRestjson1_serializeDocumentInputLocation(v.NetworkEndBlackoutImage, ok); err != nil {
			return err
		}
	}

	if v.NetworkId != nil {
		ok := object.Key("networkId")
		ok.String(*v.NetworkId)
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentBurnInDestinationSettings(v *types.BurnInDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Alignment) > 0 {
		ok := object.Key("alignment")
		ok.String(string(v.Alignment))
	}

	if len(v.BackgroundColor) > 0 {
		ok := object.Key("backgroundColor")
		ok.String(string(v.BackgroundColor))
	}

	if v.BackgroundOpacity != 0 {
		ok := object.Key("backgroundOpacity")
		ok.Integer(v.BackgroundOpacity)
	}

	if v.Font != nil {
		ok := object.Key("font")
		if err := awsRestjson1_serializeDocumentInputLocation(v.Font, ok); err != nil {
			return err
		}
	}

	if len(v.FontColor) > 0 {
		ok := object.Key("fontColor")
		ok.String(string(v.FontColor))
	}

	if v.FontOpacity != 0 {
		ok := object.Key("fontOpacity")
		ok.Integer(v.FontOpacity)
	}

	if v.FontResolution != 0 {
		ok := object.Key("fontResolution")
		ok.Integer(v.FontResolution)
	}

	if v.FontSize != nil {
		ok := object.Key("fontSize")
		ok.String(*v.FontSize)
	}

	if len(v.OutlineColor) > 0 {
		ok := object.Key("outlineColor")
		ok.String(string(v.OutlineColor))
	}

	if v.OutlineSize != 0 {
		ok := object.Key("outlineSize")
		ok.Integer(v.OutlineSize)
	}

	if len(v.ShadowColor) > 0 {
		ok := object.Key("shadowColor")
		ok.String(string(v.ShadowColor))
	}

	if v.ShadowOpacity != 0 {
		ok := object.Key("shadowOpacity")
		ok.Integer(v.ShadowOpacity)
	}

	if v.ShadowXOffset != 0 {
		ok := object.Key("shadowXOffset")
		ok.Integer(v.ShadowXOffset)
	}

	if v.ShadowYOffset != 0 {
		ok := object.Key("shadowYOffset")
		ok.Integer(v.ShadowYOffset)
	}

	if len(v.TeletextGridControl) > 0 {
		ok := object.Key("teletextGridControl")
		ok.String(string(v.TeletextGridControl))
	}

	if v.XPosition != 0 {
		ok := object.Key("xPosition")
		ok.Integer(v.XPosition)
	}

	if v.YPosition != 0 {
		ok := object.Key("yPosition")
		ok.Integer(v.YPosition)
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionDescription(v *types.CaptionDescription, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Accessibility) > 0 {
		ok := object.Key("accessibility")
		ok.String(string(v.Accessibility))
	}

	if v.CaptionSelectorName != nil {
		ok := object.Key("captionSelectorName")
		ok.String(*v.CaptionSelectorName)
	}

	if v.DestinationSettings != nil {
		ok := object.Key("destinationSettings")
		if err := awsRestjson1_serializeDocumentCaptionDestinationSettings(v.DestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.LanguageCode != nil {
		ok := object.Key("languageCode")
		ok.String(*v.LanguageCode)
	}

	if v.LanguageDescription != nil {
		ok := object.Key("languageDescription")
		ok.String(*v.LanguageDescription)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionDestinationSettings(v *types.CaptionDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AribDestinationSettings != nil {
		ok := object.Key("aribDestinationSettings")
		if err := awsRestjson1_serializeDocumentAribDestinationSettings(v.AribDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.BurnInDestinationSettings != nil {
		ok := object.Key("burnInDestinationSettings")
		if err := awsRestjson1_serializeDocumentBurnInDestinationSettings(v.BurnInDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.DvbSubDestinationSettings != nil {
		ok := object.Key("dvbSubDestinationSettings")
		if err := awsRestjson1_serializeDocumentDvbSubDestinationSettings(v.DvbSubDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.EbuTtDDestinationSettings != nil {
		ok := object.Key("ebuTtDDestinationSettings")
		if err := awsRestjson1_serializeDocumentEbuTtDDestinationSettings(v.EbuTtDDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.EmbeddedDestinationSettings != nil {
		ok := object.Key("embeddedDestinationSettings")
		if err := awsRestjson1_serializeDocumentEmbeddedDestinationSettings(v.EmbeddedDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.EmbeddedPlusScte20DestinationSettings != nil {
		ok := object.Key("embeddedPlusScte20DestinationSettings")
		if err := awsRestjson1_serializeDocumentEmbeddedPlusScte20DestinationSettings(v.EmbeddedPlusScte20DestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.RtmpCaptionInfoDestinationSettings != nil {
		ok := object.Key("rtmpCaptionInfoDestinationSettings")
		if err := awsRestjson1_serializeDocumentRtmpCaptionInfoDestinationSettings(v.RtmpCaptionInfoDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.Scte20PlusEmbeddedDestinationSettings != nil {
		ok := object.Key("scte20PlusEmbeddedDestinationSettings")
		if err := awsRestjson1_serializeDocumentScte20PlusEmbeddedDestinationSettings(v.Scte20PlusEmbeddedDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.Scte27DestinationSettings != nil {
		ok := object.Key("scte27DestinationSettings")
		if err := awsRestjson1_serializeDocumentScte27DestinationSettings(v.Scte27DestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.SmpteTtDestinationSettings != nil {
		ok := object.Key("smpteTtDestinationSettings")
		if err := awsRestjson1_serializeDocumentSmpteTtDestinationSettings(v.SmpteTtDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.TeletextDestinationSettings != nil {
		ok := object.Key("teletextDestinationSettings")
		if err := awsRestjson1_serializeDocumentTeletextDestinationSettings(v.TeletextDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.TtmlDestinationSettings != nil {
		ok := object.Key("ttmlDestinationSettings")
		if err := awsRestjson1_serializeDocumentTtmlDestinationSettings(v.TtmlDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.WebvttDestinationSettings != nil {
		ok := object.Key("webvttDestinationSettings")
		if err := awsRestjson1_serializeDocumentWebvttDestinationSettings(v.WebvttDestinationSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionLanguageMapping(v *types.CaptionLanguageMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("captionChannel")
		ok.Integer(v.CaptionChannel)
	}

	if v.LanguageCode != nil {
		ok := object.Key("languageCode")
		ok.String(*v.LanguageCode)
	}

	if v.LanguageDescription != nil {
		ok := object.Key("languageDescription")
		ok.String(*v.LanguageDescription)
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionRectangle(v *types.CaptionRectangle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("height")
		switch {
		case math.IsNaN(v.Height):
			ok.String("NaN")

		case math.IsInf(v.Height, 1):
			ok.String("Infinity")

		case math.IsInf(v.Height, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Height)

		}
	}

	{
		ok := object.Key("leftOffset")
		switch {
		case math.IsNaN(v.LeftOffset):
			ok.String("NaN")

		case math.IsInf(v.LeftOffset, 1):
			ok.String("Infinity")

		case math.IsInf(v.LeftOffset, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.LeftOffset)

		}
	}

	{
		ok := object.Key("topOffset")
		switch {
		case math.IsNaN(v.TopOffset):
			ok.String("NaN")

		case math.IsInf(v.TopOffset, 1):
			ok.String("Infinity")

		case math.IsInf(v.TopOffset, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.TopOffset)

		}
	}

	{
		ok := object.Key("width")
		switch {
		case math.IsNaN(v.Width):
			ok.String("NaN")

		case math.IsInf(v.Width, 1):
			ok.String("Infinity")

		case math.IsInf(v.Width, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Width)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionSelector(v *types.CaptionSelector, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LanguageCode != nil {
		ok := object.Key("languageCode")
		ok.String(*v.LanguageCode)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SelectorSettings != nil {
		ok := object.Key("selectorSettings")
		if err := awsRestjson1_serializeDocumentCaptionSelectorSettings(v.SelectorSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionSelectorSettings(v *types.CaptionSelectorSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AncillarySourceSettings != nil {
		ok := object.Key("ancillarySourceSettings")
		if err := awsRestjson1_serializeDocumentAncillarySourceSettings(v.AncillarySourceSettings, ok); err != nil {
			return err
		}
	}

	if v.AribSourceSettings != nil {
		ok := object.Key("aribSourceSettings")
		if err := awsRestjson1_serializeDocumentAribSourceSettings(v.AribSourceSettings, ok); err != nil {
			return err
		}
	}

	if v.DvbSubSourceSettings != nil {
		ok := object.Key("dvbSubSourceSettings")
		if err := awsRestjson1_serializeDocumentDvbSubSourceSettings(v.DvbSubSourceSettings, ok); err != nil {
			return err
		}
	}

	if v.EmbeddedSourceSettings != nil {
		ok := object.Key("embeddedSourceSettings")
		if err := awsRestjson1_serializeDocumentEmbeddedSourceSettings(v.EmbeddedSourceSettings, ok); err != nil {
			return err
		}
	}

	if v.Scte20SourceSettings != nil {
		ok := object.Key("scte20SourceSettings")
		if err := awsRestjson1_serializeDocumentScte20SourceSettings(v.Scte20SourceSettings, ok); err != nil {
			return err
		}
	}

	if v.Scte27SourceSettings != nil {
		ok := object.Key("scte27SourceSettings")
		if err := awsRestjson1_serializeDocumentScte27SourceSettings(v.Scte27SourceSettings, ok); err != nil {
			return err
		}
	}

	if v.TeletextSourceSettings != nil {
		ok := object.Key("teletextSourceSettings")
		if err := awsRestjson1_serializeDocumentTeletextSourceSettings(v.TeletextSourceSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCdiInputSpecification(v *types.CdiInputSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Resolution) > 0 {
		ok := object.Key("resolution")
		ok.String(string(v.Resolution))
	}

	return nil
}

func awsRestjson1_serializeDocumentColorSpacePassthroughSettings(v *types.ColorSpacePassthroughSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentDolbyVision81Settings(v *types.DolbyVision81Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentDvbNitSettings(v *types.DvbNitSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("networkId")
		ok.Integer(v.NetworkId)
	}

	if v.NetworkName != nil {
		ok := object.Key("networkName")
		ok.String(*v.NetworkName)
	}

	if v.RepInterval != 0 {
		ok := object.Key("repInterval")
		ok.Integer(v.RepInterval)
	}

	return nil
}

func awsRestjson1_serializeDocumentDvbSdtSettings(v *types.DvbSdtSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.OutputSdt) > 0 {
		ok := object.Key("outputSdt")
		ok.String(string(v.OutputSdt))
	}

	if v.RepInterval != 0 {
		ok := object.Key("repInterval")
		ok.Integer(v.RepInterval)
	}

	if v.ServiceName != nil {
		ok := object.Key("serviceName")
		ok.String(*v.ServiceName)
	}

	if v.ServiceProviderName != nil {
		ok := object.Key("serviceProviderName")
		ok.String(*v.ServiceProviderName)
	}

	return nil
}

func awsRestjson1_serializeDocumentDvbSubDestinationSettings(v *types.DvbSubDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Alignment) > 0 {
		ok := object.Key("alignment")
		ok.String(string(v.Alignment))
	}

	if len(v.BackgroundColor) > 0 {
		ok := object.Key("backgroundColor")
		ok.String(string(v.BackgroundColor))
	}

	if v.BackgroundOpacity != 0 {
		ok := object.Key("backgroundOpacity")
		ok.Integer(v.BackgroundOpacity)
	}

	if v.Font != nil {
		ok := object.Key("font")
		if err := awsRestjson1_serializeDocumentInputLocation(v.Font, ok); err != nil {
			return err
		}
	}

	if len(v.FontColor) > 0 {
		ok := object.Key("fontColor")
		ok.String(string(v.FontColor))
	}

	if v.FontOpacity != 0 {
		ok := object.Key("fontOpacity")
		ok.Integer(v.FontOpacity)
	}

	if v.FontResolution != 0 {
		ok := object.Key("fontResolution")
		ok.Integer(v.FontResolution)
	}

	if v.FontSize != nil {
		ok := object.Key("fontSize")
		ok.String(*v.FontSize)
	}

	if len(v.OutlineColor) > 0 {
		ok := object.Key("outlineColor")
		ok.String(string(v.OutlineColor))
	}

	if v.OutlineSize != 0 {
		ok := object.Key("outlineSize")
		ok.Integer(v.OutlineSize)
	}

	if len(v.ShadowColor) > 0 {
		ok := object.Key("shadowColor")
		ok.String(string(v.ShadowColor))
	}

	if v.ShadowOpacity != 0 {
		ok := object.Key("shadowOpacity")
		ok.Integer(v.ShadowOpacity)
	}

	if v.ShadowXOffset != 0 {
		ok := object.Key("shadowXOffset")
		ok.Integer(v.ShadowXOffset)
	}

	if v.ShadowYOffset != 0 {
		ok := object.Key("shadowYOffset")
		ok.Integer(v.ShadowYOffset)
	}

	if len(v.TeletextGridControl) > 0 {
		ok := object.Key("teletextGridControl")
		ok.String(string(v.TeletextGridControl))
	}

	if v.XPosition != 0 {
		ok := object.Key("xPosition")
		ok.Integer(v.XPosition)
	}

	if v.YPosition != 0 {
		ok := object.Key("yPosition")
		ok.Integer(v.YPosition)
	}

	return nil
}

func awsRestjson1_serializeDocumentDvbSubSourceSettings(v *types.DvbSubSourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.OcrLanguage) > 0 {
		ok := object.Key("ocrLanguage")
		ok.String(string(v.OcrLanguage))
	}

	if v.Pid != 0 {
		ok := object.Key("pid")
		ok.Integer(v.Pid)
	}

	return nil
}

func awsRestjson1_serializeDocumentDvbTdtSettings(v *types.DvbTdtSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RepInterval != 0 {
		ok := object.Key("repInterval")
		ok.Integer(v.RepInterval)
	}

	return nil
}

func awsRestjson1_serializeDocumentEac3AtmosSettings(v *types.Eac3AtmosSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bitrate != 0 {
		ok := object.Key("bitrate")
		switch {
		case math.IsNaN(v.Bitrate):
			ok.String("NaN")

		case math.IsInf(v.Bitrate, 1):
			ok.String("Infinity")

		case math.IsInf(v.Bitrate, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Bitrate)

		}
	}

	if len(v.CodingMode) > 0 {
		ok := object.Key("codingMode")
		ok.String(string(v.CodingMode))
	}

	if v.Dialnorm != 0 {
		ok := object.Key("dialnorm")
		ok.Integer(v.Dialnorm)
	}

	if len(v.DrcLine) > 0 {
		ok := object.Key("drcLine")
		ok.String(string(v.DrcLine))
	}

	if len(v.DrcRf) > 0 {
		ok := object.Key("drcRf")
		ok.String(string(v.DrcRf))
	}

	if v.HeightTrim != 0 {
		ok := object.Key("heightTrim")
		switch {
		case math.IsNaN(v.HeightTrim):
			ok.String("NaN")

		case math.IsInf(v.HeightTrim, 1):
			ok.String("Infinity")

		case math.IsInf(v.HeightTrim, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.HeightTrim)

		}
	}

	if v.SurroundTrim != 0 {
		ok := object.Key("surroundTrim")
		switch {
		case math.IsNaN(v.SurroundTrim):
			ok.String("NaN")

		case math.IsInf(v.SurroundTrim, 1):
			ok.String("Infinity")

		case math.IsInf(v.SurroundTrim, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.SurroundTrim)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEac3Settings(v *types.Eac3Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AttenuationControl) > 0 {
		ok := object.Key("attenuationControl")
		ok.String(string(v.AttenuationControl))
	}

	if v.Bitrate != 0 {
		ok := object.Key("bitrate")
		switch {
		case math.IsNaN(v.Bitrate):
			ok.String("NaN")

		case math.IsInf(v.Bitrate, 1):
			ok.String("Infinity")

		case math.IsInf(v.Bitrate, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Bitrate)

		}
	}

	if len(v.BitstreamMode) > 0 {
		ok := object.Key("bitstreamMode")
		ok.String(string(v.BitstreamMode))
	}

	if len(v.CodingMode) > 0 {
		ok := object.Key("codingMode")
		ok.String(string(v.CodingMode))
	}

	if len(v.DcFilter) > 0 {
		ok := object.Key("dcFilter")
		ok.String(string(v.DcFilter))
	}

	if v.Dialnorm != 0 {
		ok := object.Key("dialnorm")
		ok.Integer(v.Dialnorm)
	}

	if len(v.DrcLine) > 0 {
		ok := object.Key("drcLine")
		ok.String(string(v.DrcLine))
	}

	if len(v.DrcRf) > 0 {
		ok := object.Key("drcRf")
		ok.String(string(v.DrcRf))
	}

	if len(v.LfeControl) > 0 {
		ok := object.Key("lfeControl")
		ok.String(string(v.LfeControl))
	}

	if len(v.LfeFilter) > 0 {
		ok := object.Key("lfeFilter")
		ok.String(string(v.LfeFilter))
	}

	if v.LoRoCenterMixLevel != 0 {
		ok := object.Key("loRoCenterMixLevel")
		switch {
		case math.IsNaN(v.LoRoCenterMixLevel):
			ok.String("NaN")

		case math.IsInf(v.LoRoCenterMixLevel, 1):
			ok.String("Infinity")

		case math.IsInf(v.LoRoCenterMixLevel, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.LoRoCenterMixLevel)

		}
	}

	if v.LoRoSurroundMixLevel != 0 {
		ok := object.Key("loRoSurroundMixLevel")
		switch {
		case math.IsNaN(v.LoRoSurroundMixLevel):
			ok.String("NaN")

		case math.IsInf(v.LoRoSurroundMixLevel, 1):
			ok.String("Infinity")

		case math.IsInf(v.LoRoSurroundMixLevel, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.LoRoSurroundMixLevel)

		}
	}

	if v.LtRtCenterMixLevel != 0 {
		ok := object.Key("ltRtCenterMixLevel")
		switch {
		case math.IsNaN(v.LtRtCenterMixLevel):
			ok.String("NaN")

		case math.IsInf(v.LtRtCenterMixLevel, 1):
			ok.String("Infinity")

		case math.IsInf(v.LtRtCenterMixLevel, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.LtRtCenterMixLevel)

		}
	}

	if v.LtRtSurroundMixLevel != 0 {
		ok := object.Key("ltRtSurroundMixLevel")
		switch {
		case math.IsNaN(v.LtRtSurroundMixLevel):
			ok.String("NaN")

		case math.IsInf(v.LtRtSurroundMixLevel, 1):
			ok.String("Infinity")

		case math.IsInf(v.LtRtSurroundMixLevel, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.LtRtSurroundMixLevel)

		}
	}

	if len(v.MetadataControl) > 0 {
		ok := object.Key("metadataControl")
		ok.String(string(v.MetadataControl))
	}

	if len(v.PassthroughControl) > 0 {
		ok := object.Key("passthroughControl")
		ok.String(string(v.PassthroughControl))
	}

	if len(v.PhaseControl) > 0 {
		ok := object.Key("phaseControl")
		ok.String(string(v.PhaseControl))
	}

	if len(v.StereoDownmix) > 0 {
		ok := object.Key("stereoDownmix")
		ok.String(string(v.StereoDownmix))
	}

	if len(v.SurroundExMode) > 0 {
		ok := object.Key("surroundExMode")
		ok.String(string(v.SurroundExMode))
	}

	if len(v.SurroundMode) > 0 {
		ok := object.Key("surroundMode")
		ok.String(string(v.SurroundMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentEbuTtDDestinationSettings(v *types.EbuTtDDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CopyrightHolder != nil {
		ok := object.Key("copyrightHolder")
		ok.String(*v.CopyrightHolder)
	}

	if len(v.FillLineGap) > 0 {
		ok := object.Key("fillLineGap")
		ok.String(string(v.FillLineGap))
	}

	if v.FontFamily != nil {
		ok := object.Key("fontFamily")
		ok.String(*v.FontFamily)
	}

	if len(v.StyleControl) > 0 {
		ok := object.Key("styleControl")
		ok.String(string(v.StyleControl))
	}

	return nil
}

func awsRestjson1_serializeDocumentEmbeddedDestinationSettings(v *types.EmbeddedDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentEmbeddedPlusScte20DestinationSettings(v *types.EmbeddedPlusScte20DestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentEmbeddedSourceSettings(v *types.EmbeddedSourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Convert608To708) > 0 {
		ok := object.Key("convert608To708")
		ok.String(string(v.Convert608To708))
	}

	if len(v.Scte20Detection) > 0 {
		ok := object.Key("scte20Detection")
		ok.String(string(v.Scte20Detection))
	}

	if v.Source608ChannelNumber != 0 {
		ok := object.Key("source608ChannelNumber")
		ok.Integer(v.Source608ChannelNumber)
	}

	if v.Source608TrackNumber != 0 {
		ok := object.Key("source608TrackNumber")
		ok.Integer(v.Source608TrackNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentEncoderSettings(v *types.EncoderSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioDescriptions != nil {
		ok := object.Key("audioDescriptions")
		if err := awsRestjson1_serializeDocument__listOfAudioDescription(v.AudioDescriptions, ok); err != nil {
			return err
		}
	}

	if v.AvailBlanking != nil {
		ok := object.Key("availBlanking")
		if err := awsRestjson1_serializeDocumentAvailBlanking(v.AvailBlanking, ok); err != nil {
			return err
		}
	}

	if v.AvailConfiguration != nil {
		ok := object.Key("availConfiguration")
		if err := awsRestjson1_serializeDocumentAvailConfiguration(v.AvailConfiguration, ok); err != nil {
			return err
		}
	}

	if v.BlackoutSlate != nil {
		ok := object.Key("blackoutSlate")
		if err := awsRestjson1_serializeDocumentBlackoutSlate(v.BlackoutSlate, ok); err != nil {
			return err
		}
	}

	if v.CaptionDescriptions != nil {
		ok := object.Key("captionDescriptions")
		if err := awsRestjson1_serializeDocument__listOfCaptionDescription(v.CaptionDescriptions, ok); err != nil {
			return err
		}
	}

	if v.FeatureActivations != nil {
		ok := object.Key("featureActivations")
		if err := awsRestjson1_serializeDocumentFeatureActivations(v.FeatureActivations, ok); err != nil {
			return err
		}
	}

	if v.GlobalConfiguration != nil {
		ok := object.Key("globalConfiguration")
		if err := awsRestjson1_serializeDocumentGlobalConfiguration(v.GlobalConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MotionGraphicsConfiguration != nil {
		ok := object.Key("motionGraphicsConfiguration")
		if err := awsRestjson1_serializeDocumentMotionGraphicsConfiguration(v.MotionGraphicsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.NielsenConfiguration != nil {
		ok := object.Key("nielsenConfiguration")
		if err := awsRestjson1_serializeDocumentNielsenConfiguration(v.NielsenConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OutputGroups != nil {
		ok := object.Key("outputGroups")
		if err := awsRestjson1_serializeDocument__listOfOutputGroup(v.OutputGroups, ok); err != nil {
			return err
		}
	}

	if v.TimecodeConfig != nil {
		ok := object.Key("timecodeConfig")
		if err := awsRestjson1_serializeDocumentTimecodeConfig(v.TimecodeConfig, ok); err != nil {
			return err
		}
	}

	if v.VideoDescriptions != nil {
		ok := object.Key("videoDescriptions")
		if err := awsRestjson1_serializeDocument__listOfVideoDescription(v.VideoDescriptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEsam(v *types.Esam, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AcquisitionPointId != nil {
		ok := object.Key("acquisitionPointId")
		ok.String(*v.AcquisitionPointId)
	}

	if v.AdAvailOffset != 0 {
		ok := object.Key("adAvailOffset")
		ok.Integer(v.AdAvailOffset)
	}

	if v.PasswordParam != nil {
		ok := object.Key("passwordParam")
		ok.String(*v.PasswordParam)
	}

	if v.PoisEndpoint != nil {
		ok := object.Key("poisEndpoint")
		ok.String(*v.PoisEndpoint)
	}

	if v.Username != nil {
		ok := object.Key("username")
		ok.String(*v.Username)
	}

	if v.ZoneIdentity != nil {
		ok := object.Key("zoneIdentity")
		ok.String(*v.ZoneIdentity)
	}

	return nil
}

func awsRestjson1_serializeDocumentFailoverCondition(v *types.FailoverCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FailoverConditionSettings != nil {
		ok := object.Key("failoverConditionSettings")
		if err := awsRestjson1_serializeDocumentFailoverConditionSettings(v.FailoverConditionSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFailoverConditionSettings(v *types.FailoverConditionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioSilenceSettings != nil {
		ok := object.Key("audioSilenceSettings")
		if err := awsRestjson1_serializeDocumentAudioSilenceFailoverSettings(v.AudioSilenceSettings, ok); err != nil {
			return err
		}
	}

	if v.InputLossSettings != nil {
		ok := object.Key("inputLossSettings")
		if err := awsRestjson1_serializeDocumentInputLossFailoverSettings(v.InputLossSettings, ok); err != nil {
			return err
		}
	}

	if v.VideoBlackSettings != nil {
		ok := object.Key("videoBlackSettings")
		if err := awsRestjson1_serializeDocumentVideoBlackFailoverSettings(v.VideoBlackSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFeatureActivations(v *types.FeatureActivations, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InputPrepareScheduleActions) > 0 {
		ok := object.Key("inputPrepareScheduleActions")
		ok.String(string(v.InputPrepareScheduleActions))
	}

	return nil
}

func awsRestjson1_serializeDocumentFecOutputSettings(v *types.FecOutputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnDepth != 0 {
		ok := object.Key("columnDepth")
		ok.Integer(v.ColumnDepth)
	}

	if len(v.IncludeFec) > 0 {
		ok := object.Key("includeFec")
		ok.String(string(v.IncludeFec))
	}

	if v.RowLength != 0 {
		ok := object.Key("rowLength")
		ok.Integer(v.RowLength)
	}

	return nil
}

func awsRestjson1_serializeDocumentFixedModeScheduleActionStartSettings(v *types.FixedModeScheduleActionStartSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Time != nil {
		ok := object.Key("time")
		ok.String(*v.Time)
	}

	return nil
}

func awsRestjson1_serializeDocumentFmp4HlsSettings(v *types.Fmp4HlsSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioRenditionSets != nil {
		ok := object.Key("audioRenditionSets")
		ok.String(*v.AudioRenditionSets)
	}

	if len(v.NielsenId3Behavior) > 0 {
		ok := object.Key("nielsenId3Behavior")
		ok.String(string(v.NielsenId3Behavior))
	}

	if len(v.TimedMetadataBehavior) > 0 {
		ok := object.Key("timedMetadataBehavior")
		ok.String(string(v.TimedMetadataBehavior))
	}

	return nil
}

func awsRestjson1_serializeDocumentFollowModeScheduleActionStartSettings(v *types.FollowModeScheduleActionStartSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FollowPoint) > 0 {
		ok := object.Key("followPoint")
		ok.String(string(v.FollowPoint))
	}

	if v.ReferenceActionName != nil {
		ok := object.Key("referenceActionName")
		ok.String(*v.ReferenceActionName)
	}

	return nil
}

func awsRestjson1_serializeDocumentFrameCaptureCdnSettings(v *types.FrameCaptureCdnSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FrameCaptureS3Settings != nil {
		ok := object.Key("frameCaptureS3Settings")
		if err := awsRestjson1_serializeDocumentFrameCaptureS3Settings(v.FrameCaptureS3Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFrameCaptureGroupSettings(v *types.FrameCaptureGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("destination")
		if err := awsRestjson1_serializeDocumentOutputLocationRef(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.FrameCaptureCdnSettings != nil {
		ok := object.Key("frameCaptureCdnSettings")
		if err := awsRestjson1_serializeDocumentFrameCaptureCdnSettings(v.FrameCaptureCdnSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFrameCaptureHlsSettings(v *types.FrameCaptureHlsSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentFrameCaptureOutputSettings(v *types.FrameCaptureOutputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NameModifier != nil {
		ok := object.Key("nameModifier")
		ok.String(*v.NameModifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentFrameCaptureS3Settings(v *types.FrameCaptureS3Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CannedAcl) > 0 {
		ok := object.Key("cannedAcl")
		ok.String(string(v.CannedAcl))
	}

	return nil
}

func awsRestjson1_serializeDocumentFrameCaptureSettings(v *types.FrameCaptureSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CaptureInterval != 0 {
		ok := object.Key("captureInterval")
		ok.Integer(v.CaptureInterval)
	}

	if len(v.CaptureIntervalUnits) > 0 {
		ok := object.Key("captureIntervalUnits")
		ok.String(string(v.CaptureIntervalUnits))
	}

	if v.TimecodeBurninSettings != nil {
		ok := object.Key("timecodeBurninSettings")
		if err := awsRestjson1_serializeDocumentTimecodeBurninSettings(v.TimecodeBurninSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGlobalConfiguration(v *types.GlobalConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialAudioGain != 0 {
		ok := object.Key("initialAudioGain")
		ok.Integer(v.InitialAudioGain)
	}

	if len(v.InputEndAction) > 0 {
		ok := object.Key("inputEndAction")
		ok.String(string(v.InputEndAction))
	}

	if v.InputLossBehavior != nil {
		ok := object.Key("inputLossBehavior")
		if err := awsRestjson1_serializeDocumentInputLossBehavior(v.InputLossBehavior, ok); err != nil {
			return err
		}
	}

	if len(v.OutputLockingMode) > 0 {
		ok := object.Key("outputLockingMode")
		ok.String(string(v.OutputLockingMode))
	}

	if len(v.OutputTimingSource) > 0 {
		ok := object.Key("outputTimingSource")
		ok.String(string(v.OutputTimingSource))
	}

	if len(v.SupportLowFramerateInputs) > 0 {
		ok := object.Key("supportLowFramerateInputs")
		ok.String(string(v.SupportLowFramerateInputs))
	}

	return nil
}

func awsRestjson1_serializeDocumentH264ColorSpaceSettings(v *types.H264ColorSpaceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColorSpacePassthroughSettings != nil {
		ok := object.Key("colorSpacePassthroughSettings")
		if err := awsRestjson1_serializeDocumentColorSpacePassthroughSettings(v.ColorSpacePassthroughSettings, ok); err != nil {
			return err
		}
	}

	if v.Rec601Settings != nil {
		ok := object.Key("rec601Settings")
		if err := awsRestjson1_serializeDocumentRec601Settings(v.Rec601Settings, ok); err != nil {
			return err
		}
	}

	if v.Rec709Settings != nil {
		ok := object.Key("rec709Settings")
		if err := awsRestjson1_serializeDocumentRec709Settings(v.Rec709Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentH264FilterSettings(v *types.H264FilterSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TemporalFilterSettings != nil {
		ok := object.Key("temporalFilterSettings")
		if err := awsRestjson1_serializeDocumentTemporalFilterSettings(v.TemporalFilterSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentH264Settings(v *types.H264Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AdaptiveQuantization) > 0 {
		ok := object.Key("adaptiveQuantization")
		ok.String(string(v.AdaptiveQuantization))
	}

	if len(v.AfdSignaling) > 0 {
		ok := object.Key("afdSignaling")
		ok.String(string(v.AfdSignaling))
	}

	if v.Bitrate != 0 {
		ok := object.Key("bitrate")
		ok.Integer(v.Bitrate)
	}

	if v.BufFillPct != 0 {
		ok := object.Key("bufFillPct")
		ok.Integer(v.BufFillPct)
	}

	if v.BufSize != 0 {
		ok := object.Key("bufSize")
		ok.Integer(v.BufSize)
	}

	if len(v.ColorMetadata) > 0 {
		ok := object.Key("colorMetadata")
		ok.String(string(v.ColorMetadata))
	}

	if v.ColorSpaceSettings != nil {
		ok := object.Key("colorSpaceSettings")
		if err := awsRestjson1_serializeDocumentH264ColorSpaceSettings(v.ColorSpaceSettings, ok); err != nil {
			return err
		}
	}

	if len(v.EntropyEncoding) > 0 {
		ok := object.Key("entropyEncoding")
		ok.String(string(v.EntropyEncoding))
	}

	if v.FilterSettings != nil {
		ok := object.Key("filterSettings")
		if err := awsRestjson1_serializeDocumentH264FilterSettings(v.FilterSettings, ok); err != nil {
			return err
		}
	}

	if len(v.FixedAfd) > 0 {
		ok := object.Key("fixedAfd")
		ok.String(string(v.FixedAfd))
	}

	if len(v.FlickerAq) > 0 {
		ok := object.Key("flickerAq")
		ok.String(string(v.FlickerAq))
	}

	if len(v.ForceFieldPictures) > 0 {
		ok := object.Key("forceFieldPictures")
		ok.String(string(v.ForceFieldPictures))
	}

	if len(v.FramerateControl) > 0 {
		ok := object.Key("framerateControl")
		ok.String(string(v.FramerateControl))
	}

	if v.FramerateDenominator != 0 {
		ok := object.Key("framerateDenominator")
		ok.Integer(v.FramerateDenominator)
	}

	if v.FramerateNumerator != 0 {
		ok := object.Key("framerateNumerator")
		ok.Integer(v.FramerateNumerator)
	}

	if len(v.GopBReference) > 0 {
		ok := object.Key("gopBReference")
		ok.String(string(v.GopBReference))
	}

	if v.GopClosedCadence != 0 {
		ok := object.Key("gopClosedCadence")
		ok.Integer(v.GopClosedCadence)
	}

	if v.GopNumBFrames != 0 {
		ok := object.Key("gopNumBFrames")
		ok.Integer(v.GopNumBFrames)
	}

	if v.GopSize != 0 {
		ok := object.Key("gopSize")
		switch {
		case math.IsNaN(v.GopSize):
			ok.String("NaN")

		case math.IsInf(v.GopSize, 1):
			ok.String("Infinity")

		case math.IsInf(v.GopSize, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.GopSize)

		}
	}

	if len(v.GopSizeUnits) > 0 {
		ok := object.Key("gopSizeUnits")
		ok.String(string(v.GopSizeUnits))
	}

	if len(v.Level) > 0 {
		ok := object.Key("level")
		ok.String(string(v.Level))
	}

	if len(v.LookAheadRateControl) > 0 {
		ok := object.Key("lookAheadRateControl")
		ok.String(string(v.LookAheadRateControl))
	}

	if v.MaxBitrate != 0 {
		ok := object.Key("maxBitrate")
		ok.Integer(v.MaxBitrate)
	}

	if v.MinIInterval != 0 {
		ok := object.Key("minIInterval")
		ok.Integer(v.MinIInterval)
	}

	if v.NumRefFrames != 0 {
		ok := object.Key("numRefFrames")
		ok.Integer(v.NumRefFrames)
	}

	if len(v.ParControl) > 0 {
		ok := object.Key("parControl")
		ok.String(string(v.ParControl))
	}

	if v.ParDenominator != 0 {
		ok := object.Key("parDenominator")
		ok.Integer(v.ParDenominator)
	}

	if v.ParNumerator != 0 {
		ok := object.Key("parNumerator")
		ok.Integer(v.ParNumerator)
	}

	if len(v.Profile) > 0 {
		ok := object.Key("profile")
		ok.String(string(v.Profile))
	}

	if len(v.QualityLevel) > 0 {
		ok := object.Key("qualityLevel")
		ok.String(string(v.QualityLevel))
	}

	if v.QvbrQualityLevel != 0 {
		ok := object.Key("qvbrQualityLevel")
		ok.Integer(v.QvbrQualityLevel)
	}

	if len(v.RateControlMode) > 0 {
		ok := object.Key("rateControlMode")
		ok.String(string(v.RateControlMode))
	}

	if len(v.ScanType) > 0 {
		ok := object.Key("scanType")
		ok.String(string(v.ScanType))
	}

	if len(v.SceneChangeDetect) > 0 {
		ok := object.Key("sceneChangeDetect")
		ok.String(string(v.SceneChangeDetect))
	}

	if v.Slices != 0 {
		ok := object.Key("slices")
		ok.Integer(v.Slices)
	}

	if v.Softness != 0 {
		ok := object.Key("softness")
		ok.Integer(v.Softness)
	}

	if len(v.SpatialAq) > 0 {
		ok := object.Key("spatialAq")
		ok.String(string(v.SpatialAq))
	}

	if len(v.SubgopLength) > 0 {
		ok := object.Key("subgopLength")
		ok.String(string(v.SubgopLength))
	}

	if len(v.Syntax) > 0 {
		ok := object.Key("syntax")
		ok.String(string(v.Syntax))
	}

	if len(v.TemporalAq) > 0 {
		ok := object.Key("temporalAq")
		ok.String(string(v.TemporalAq))
	}

	if v.TimecodeBurninSettings != nil {
		ok := object.Key("timecodeBurninSettings")
		if err := awsRestjson1_serializeDocumentTimecodeBurninSettings(v.TimecodeBurninSettings, ok); err != nil {
			return err
		}
	}

	if len(v.TimecodeInsertion) > 0 {
		ok := object.Key("timecodeInsertion")
		ok.String(string(v.TimecodeInsertion))
	}

	return nil
}

func awsRestjson1_serializeDocumentH265ColorSpaceSettings(v *types.H265ColorSpaceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColorSpacePassthroughSettings != nil {
		ok := object.Key("colorSpacePassthroughSettings")
		if err := awsRestjson1_serializeDocumentColorSpacePassthroughSettings(v.ColorSpacePassthroughSettings, ok); err != nil {
			return err
		}
	}

	if v.DolbyVision81Settings != nil {
		ok := object.Key("dolbyVision81Settings")
		if err := awsRestjson1_serializeDocumentDolbyVision81Settings(v.DolbyVision81Settings, ok); err != nil {
			return err
		}
	}

	if v.Hdr10Settings != nil {
		ok := object.Key("hdr10Settings")
		if err := awsRestjson1_serializeDocumentHdr10Settings(v.Hdr10Settings, ok); err != nil {
			return err
		}
	}

	if v.Rec601Settings != nil {
		ok := object.Key("rec601Settings")
		if err := awsRestjson1_serializeDocumentRec601Settings(v.Rec601Settings, ok); err != nil {
			return err
		}
	}

	if v.Rec709Settings != nil {
		ok := object.Key("rec709Settings")
		if err := awsRestjson1_serializeDocumentRec709Settings(v.Rec709Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentH265FilterSettings(v *types.H265FilterSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TemporalFilterSettings != nil {
		ok := object.Key("temporalFilterSettings")
		if err := awsRestjson1_serializeDocumentTemporalFilterSettings(v.TemporalFilterSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentH265Settings(v *types.H265Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AdaptiveQuantization) > 0 {
		ok := object.Key("adaptiveQuantization")
		ok.String(string(v.AdaptiveQuantization))
	}

	if len(v.AfdSignaling) > 0 {
		ok := object.Key("afdSignaling")
		ok.String(string(v.AfdSignaling))
	}

	if len(v.AlternativeTransferFunction) > 0 {
		ok := object.Key("alternativeTransferFunction")
		ok.String(string(v.AlternativeTransferFunction))
	}

	if v.Bitrate != 0 {
		ok := object.Key("bitrate")
		ok.Integer(v.Bitrate)
	}

	if v.BufSize != 0 {
		ok := object.Key("bufSize")
		ok.Integer(v.BufSize)
	}

	if len(v.ColorMetadata) > 0 {
		ok := object.Key("colorMetadata")
		ok.String(string(v.ColorMetadata))
	}

	if v.ColorSpaceSettings != nil {
		ok := object.Key("colorSpaceSettings")
		if err := awsRestjson1_serializeDocumentH265ColorSpaceSettings(v.ColorSpaceSettings, ok); err != nil {
			return err
		}
	}

	if v.FilterSettings != nil {
		ok := object.Key("filterSettings")
		if err := awsRestjson1_serializeDocumentH265FilterSettings(v.FilterSettings, ok); err != nil {
			return err
		}
	}

	if len(v.FixedAfd) > 0 {
		ok := object.Key("fixedAfd")
		ok.String(string(v.FixedAfd))
	}

	if len(v.FlickerAq) > 0 {
		ok := object.Key("flickerAq")
		ok.String(string(v.FlickerAq))
	}

	{
		ok := object.Key("framerateDenominator")
		ok.Integer(v.FramerateDenominator)
	}

	{
		ok := object.Key("framerateNumerator")
		ok.Integer(v.FramerateNumerator)
	}

	if v.GopClosedCadence != 0 {
		ok := object.Key("gopClosedCadence")
		ok.Integer(v.GopClosedCadence)
	}

	if v.GopSize != 0 {
		ok := object.Key("gopSize")
		switch {
		case math.IsNaN(v.GopSize):
			ok.String("NaN")

		case math.IsInf(v.GopSize, 1):
			ok.String("Infinity")

		case math.IsInf(v.GopSize, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.GopSize)

		}
	}

	if len(v.GopSizeUnits) > 0 {
		ok := object.Key("gopSizeUnits")
		ok.String(string(v.GopSizeUnits))
	}

	if len(v.Level) > 0 {
		ok := object.Key("level")
		ok.String(string(v.Level))
	}

	if len(v.LookAheadRateControl) > 0 {
		ok := object.Key("lookAheadRateControl")
		ok.String(string(v.LookAheadRateControl))
	}

	if v.MaxBitrate != 0 {
		ok := object.Key("maxBitrate")
		ok.Integer(v.MaxBitrate)
	}

	if v.MinIInterval != 0 {
		ok := object.Key("minIInterval")
		ok.Integer(v.MinIInterval)
	}

	if v.ParDenominator != 0 {
		ok := object.Key("parDenominator")
		ok.Integer(v.ParDenominator)
	}

	if v.ParNumerator != 0 {
		ok := object.Key("parNumerator")
		ok.Integer(v.ParNumerator)
	}

	if len(v.Profile) > 0 {
		ok := object.Key("profile")
		ok.String(string(v.Profile))
	}

	if v.QvbrQualityLevel != 0 {
		ok := object.Key("qvbrQualityLevel")
		ok.Integer(v.QvbrQualityLevel)
	}

	if len(v.RateControlMode) > 0 {
		ok := object.Key("rateControlMode")
		ok.String(string(v.RateControlMode))
	}

	if len(v.ScanType) > 0 {
		ok := object.Key("scanType")
		ok.String(string(v.ScanType))
	}

	if len(v.SceneChangeDetect) > 0 {
		ok := object.Key("sceneChangeDetect")
		ok.String(string(v.SceneChangeDetect))
	}

	if v.Slices != 0 {
		ok := object.Key("slices")
		ok.Integer(v.Slices)
	}

	if len(v.Tier) > 0 {
		ok := object.Key("tier")
		ok.String(string(v.Tier))
	}

	if v.TimecodeBurninSettings != nil {
		ok := object.Key("timecodeBurninSettings")
		if err := awsRestjson1_serializeDocumentTimecodeBurninSettings(v.TimecodeBurninSettings, ok); err != nil {
			return err
		}
	}

	if len(v.TimecodeInsertion) > 0 {
		ok := object.Key("timecodeInsertion")
		ok.String(string(v.TimecodeInsertion))
	}

	return nil
}

func awsRestjson1_serializeDocumentHdr10Settings(v *types.Hdr10Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxCll != 0 {
		ok := object.Key("maxCll")
		ok.Integer(v.MaxCll)
	}

	if v.MaxFall != 0 {
		ok := object.Key("maxFall")
		ok.Integer(v.MaxFall)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsAkamaiSettings(v *types.HlsAkamaiSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionRetryInterval != 0 {
		ok := object.Key("connectionRetryInterval")
		ok.Integer(v.ConnectionRetryInterval)
	}

	if v.FilecacheDuration != 0 {
		ok := object.Key("filecacheDuration")
		ok.Integer(v.FilecacheDuration)
	}

	if len(v.HttpTransferMode) > 0 {
		ok := object.Key("httpTransferMode")
		ok.String(string(v.HttpTransferMode))
	}

	if v.NumRetries != 0 {
		ok := object.Key("numRetries")
		ok.Integer(v.NumRetries)
	}

	if v.RestartDelay != 0 {
		ok := object.Key("restartDelay")
		ok.Integer(v.RestartDelay)
	}

	if v.Salt != nil {
		ok := object.Key("salt")
		ok.String(*v.Salt)
	}

	if v.Token != nil {
		ok := object.Key("token")
		ok.String(*v.Token)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsBasicPutSettings(v *types.HlsBasicPutSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionRetryInterval != 0 {
		ok := object.Key("connectionRetryInterval")
		ok.Integer(v.ConnectionRetryInterval)
	}

	if v.FilecacheDuration != 0 {
		ok := object.Key("filecacheDuration")
		ok.Integer(v.FilecacheDuration)
	}

	if v.NumRetries != 0 {
		ok := object.Key("numRetries")
		ok.Integer(v.NumRetries)
	}

	if v.RestartDelay != 0 {
		ok := object.Key("restartDelay")
		ok.Integer(v.RestartDelay)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsCdnSettings(v *types.HlsCdnSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HlsAkamaiSettings != nil {
		ok := object.Key("hlsAkamaiSettings")
		if err := awsRestjson1_serializeDocumentHlsAkamaiSettings(v.HlsAkamaiSettings, ok); err != nil {
			return err
		}
	}

	if v.HlsBasicPutSettings != nil {
		ok := object.Key("hlsBasicPutSettings")
		if err := awsRestjson1_serializeDocumentHlsBasicPutSettings(v.HlsBasicPutSettings, ok); err != nil {
			return err
		}
	}

	if v.HlsMediaStoreSettings != nil {
		ok := object.Key("hlsMediaStoreSettings")
		if err := awsRestjson1_serializeDocumentHlsMediaStoreSettings(v.HlsMediaStoreSettings, ok); err != nil {
			return err
		}
	}

	if v.HlsS3Settings != nil {
		ok := object.Key("hlsS3Settings")
		if err := awsRestjson1_serializeDocumentHlsS3Settings(v.HlsS3Settings, ok); err != nil {
			return err
		}
	}

	if v.HlsWebdavSettings != nil {
		ok := object.Key("hlsWebdavSettings")
		if err := awsRestjson1_serializeDocumentHlsWebdavSettings(v.HlsWebdavSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsGroupSettings(v *types.HlsGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdMarkers != nil {
		ok := object.Key("adMarkers")
		if err := awsRestjson1_serializeDocument__listOfHlsAdMarkers(v.AdMarkers, ok); err != nil {
			return err
		}
	}

	if v.BaseUrlContent != nil {
		ok := object.Key("baseUrlContent")
		ok.String(*v.BaseUrlContent)
	}

	if v.BaseUrlContent1 != nil {
		ok := object.Key("baseUrlContent1")
		ok.String(*v.BaseUrlContent1)
	}

	if v.BaseUrlManifest != nil {
		ok := object.Key("baseUrlManifest")
		ok.String(*v.BaseUrlManifest)
	}

	if v.BaseUrlManifest1 != nil {
		ok := object.Key("baseUrlManifest1")
		ok.String(*v.BaseUrlManifest1)
	}

	if v.CaptionLanguageMappings != nil {
		ok := object.Key("captionLanguageMappings")
		if err := awsRestjson1_serializeDocument__listOfCaptionLanguageMapping(v.CaptionLanguageMappings, ok); err != nil {
			return err
		}
	}

	if len(v.CaptionLanguageSetting) > 0 {
		ok := object.Key("captionLanguageSetting")
		ok.String(string(v.CaptionLanguageSetting))
	}

	if len(v.ClientCache) > 0 {
		ok := object.Key("clientCache")
		ok.String(string(v.ClientCache))
	}

	if len(v.CodecSpecification) > 0 {
		ok := object.Key("codecSpecification")
		ok.String(string(v.CodecSpecification))
	}

	if v.ConstantIv != nil {
		ok := object.Key("constantIv")
		ok.String(*v.ConstantIv)
	}

	if v.Destination != nil {
		ok := object.Key("destination")
		if err := awsRestjson1_serializeDocumentOutputLocationRef(v.Destination, ok); err != nil {
			return err
		}
	}

	if len(v.DirectoryStructure) > 0 {
		ok := object.Key("directoryStructure")
		ok.String(string(v.DirectoryStructure))
	}

	if len(v.DiscontinuityTags) > 0 {
		ok := object.Key("discontinuityTags")
		ok.String(string(v.DiscontinuityTags))
	}

	if len(v.EncryptionType) > 0 {
		ok := object.Key("encryptionType")
		ok.String(string(v.EncryptionType))
	}

	if v.HlsCdnSettings != nil {
		ok := object.Key("hlsCdnSettings")
		if err := awsRestjson1_serializeDocumentHlsCdnSettings(v.HlsCdnSettings, ok); err != nil {
			return err
		}
	}

	if len(v.HlsId3SegmentTagging) > 0 {
		ok := object.Key("hlsId3SegmentTagging")
		ok.String(string(v.HlsId3SegmentTagging))
	}

	if len(v.IFrameOnlyPlaylists) > 0 {
		ok := object.Key("iFrameOnlyPlaylists")
		ok.String(string(v.IFrameOnlyPlaylists))
	}

	if len(v.IncompleteSegmentBehavior) > 0 {
		ok := object.Key("incompleteSegmentBehavior")
		ok.String(string(v.IncompleteSegmentBehavior))
	}

	if v.IndexNSegments != 0 {
		ok := object.Key("indexNSegments")
		ok.Integer(v.IndexNSegments)
	}

	if len(v.InputLossAction) > 0 {
		ok := object.Key("inputLossAction")
		ok.String(string(v.InputLossAction))
	}

	if len(v.IvInManifest) > 0 {
		ok := object.Key("ivInManifest")
		ok.String(string(v.IvInManifest))
	}

	if len(v.IvSource) > 0 {
		ok := object.Key("ivSource")
		ok.String(string(v.IvSource))
	}

	if v.KeepSegments != 0 {
		ok := object.Key("keepSegments")
		ok.Integer(v.KeepSegments)
	}

	if v.KeyFormat != nil {
		ok := object.Key("keyFormat")
		ok.String(*v.KeyFormat)
	}

	if v.KeyFormatVersions != nil {
		ok := object.Key("keyFormatVersions")
		ok.String(*v.KeyFormatVersions)
	}

	if v.KeyProviderSettings != nil {
		ok := object.Key("keyProviderSettings")
		if err := awsRestjson1_serializeDocumentKeyProviderSettings(v.KeyProviderSettings, ok); err != nil {
			return err
		}
	}

	if len(v.ManifestCompression) > 0 {
		ok := object.Key("manifestCompression")
		ok.String(string(v.ManifestCompression))
	}

	if len(v.ManifestDurationFormat) > 0 {
		ok := object.Key("manifestDurationFormat")
		ok.String(string(v.ManifestDurationFormat))
	}

	if v.MinSegmentLength != 0 {
		ok := object.Key("minSegmentLength")
		ok.Integer(v.MinSegmentLength)
	}

	if len(v.Mode) > 0 {
		ok := object.Key("mode")
		ok.String(string(v.Mode))
	}

	if len(v.OutputSelection) > 0 {
		ok := object.Key("outputSelection")
		ok.String(string(v.OutputSelection))
	}

	if len(v.ProgramDateTime) > 0 {
		ok := object.Key("programDateTime")
		ok.String(string(v.ProgramDateTime))
	}

	if len(v.ProgramDateTimeClock) > 0 {
		ok := object.Key("programDateTimeClock")
		ok.String(string(v.ProgramDateTimeClock))
	}

	if v.ProgramDateTimePeriod != 0 {
		ok := object.Key("programDateTimePeriod")
		ok.Integer(v.ProgramDateTimePeriod)
	}

	if len(v.RedundantManifest) > 0 {
		ok := object.Key("redundantManifest")
		ok.String(string(v.RedundantManifest))
	}

	if len(v.SegmentationMode) > 0 {
		ok := object.Key("segmentationMode")
		ok.String(string(v.SegmentationMode))
	}

	if v.SegmentLength != 0 {
		ok := object.Key("segmentLength")
		ok.Integer(v.SegmentLength)
	}

	if v.SegmentsPerSubdirectory != 0 {
		ok := object.Key("segmentsPerSubdirectory")
		ok.Integer(v.SegmentsPerSubdirectory)
	}

	if len(v.StreamInfResolution) > 0 {
		ok := object.Key("streamInfResolution")
		ok.String(string(v.StreamInfResolution))
	}

	if len(v.TimedMetadataId3Frame) > 0 {
		ok := object.Key("timedMetadataId3Frame")
		ok.String(string(v.TimedMetadataId3Frame))
	}

	if v.TimedMetadataId3Period != 0 {
		ok := object.Key("timedMetadataId3Period")
		ok.Integer(v.TimedMetadataId3Period)
	}

	if v.TimestampDeltaMilliseconds != 0 {
		ok := object.Key("timestampDeltaMilliseconds")
		ok.Integer(v.TimestampDeltaMilliseconds)
	}

	if len(v.TsFileMode) > 0 {
		ok := object.Key("tsFileMode")
		ok.String(string(v.TsFileMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsId3SegmentTaggingScheduleActionSettings(v *types.HlsId3SegmentTaggingScheduleActionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tag != nil {
		ok := object.Key("tag")
		ok.String(*v.Tag)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsInputSettings(v *types.HlsInputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bandwidth != 0 {
		ok := object.Key("bandwidth")
		ok.Integer(v.Bandwidth)
	}

	if v.BufferSegments != 0 {
		ok := object.Key("bufferSegments")
		ok.Integer(v.BufferSegments)
	}

	if v.Retries != 0 {
		ok := object.Key("retries")
		ok.Integer(v.Retries)
	}

	if v.RetryInterval != 0 {
		ok := object.Key("retryInterval")
		ok.Integer(v.RetryInterval)
	}

	if len(v.Scte35Source) > 0 {
		ok := object.Key("scte35Source")
		ok.String(string(v.Scte35Source))
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsMediaStoreSettings(v *types.HlsMediaStoreSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionRetryInterval != 0 {
		ok := object.Key("connectionRetryInterval")
		ok.Integer(v.ConnectionRetryInterval)
	}

	if v.FilecacheDuration != 0 {
		ok := object.Key("filecacheDuration")
		ok.Integer(v.FilecacheDuration)
	}

	if len(v.MediaStoreStorageClass) > 0 {
		ok := object.Key("mediaStoreStorageClass")
		ok.String(string(v.MediaStoreStorageClass))
	}

	if v.NumRetries != 0 {
		ok := object.Key("numRetries")
		ok.Integer(v.NumRetries)
	}

	if v.RestartDelay != 0 {
		ok := object.Key("restartDelay")
		ok.Integer(v.RestartDelay)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsOutputSettings(v *types.HlsOutputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.H265PackagingType) > 0 {
		ok := object.Key("h265PackagingType")
		ok.String(string(v.H265PackagingType))
	}

	if v.HlsSettings != nil {
		ok := object.Key("hlsSettings")
		if err := awsRestjson1_serializeDocumentHlsSettings(v.HlsSettings, ok); err != nil {
			return err
		}
	}

	if v.NameModifier != nil {
		ok := object.Key("nameModifier")
		ok.String(*v.NameModifier)
	}

	if v.SegmentModifier != nil {
		ok := object.Key("segmentModifier")
		ok.String(*v.SegmentModifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsS3Settings(v *types.HlsS3Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CannedAcl) > 0 {
		ok := object.Key("cannedAcl")
		ok.String(string(v.CannedAcl))
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsSettings(v *types.HlsSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioOnlyHlsSettings != nil {
		ok := object.Key("audioOnlyHlsSettings")
		if err := awsRestjson1_serializeDocumentAudioOnlyHlsSettings(v.AudioOnlyHlsSettings, ok); err != nil {
			return err
		}
	}

	if v.Fmp4HlsSettings != nil {
		ok := object.Key("fmp4HlsSettings")
		if err := awsRestjson1_serializeDocumentFmp4HlsSettings(v.Fmp4HlsSettings, ok); err != nil {
			return err
		}
	}

	if v.FrameCaptureHlsSettings != nil {
		ok := object.Key("frameCaptureHlsSettings")
		if err := awsRestjson1_serializeDocumentFrameCaptureHlsSettings(v.FrameCaptureHlsSettings, ok); err != nil {
			return err
		}
	}

	if v.StandardHlsSettings != nil {
		ok := object.Key("standardHlsSettings")
		if err := awsRestjson1_serializeDocumentStandardHlsSettings(v.StandardHlsSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsTimedMetadataScheduleActionSettings(v *types.HlsTimedMetadataScheduleActionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id3 != nil {
		ok := object.Key("id3")
		ok.String(*v.Id3)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsWebdavSettings(v *types.HlsWebdavSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionRetryInterval != 0 {
		ok := object.Key("connectionRetryInterval")
		ok.Integer(v.ConnectionRetryInterval)
	}

	if v.FilecacheDuration != 0 {
		ok := object.Key("filecacheDuration")
		ok.Integer(v.FilecacheDuration)
	}

	if len(v.HttpTransferMode) > 0 {
		ok := object.Key("httpTransferMode")
		ok.String(string(v.HttpTransferMode))
	}

	if v.NumRetries != 0 {
		ok := object.Key("numRetries")
		ok.Integer(v.NumRetries)
	}

	if v.RestartDelay != 0 {
		ok := object.Key("restartDelay")
		ok.Integer(v.RestartDelay)
	}

	return nil
}

func awsRestjson1_serializeDocumentHtmlMotionGraphicsSettings(v *types.HtmlMotionGraphicsSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentImmediateModeScheduleActionStartSettings(v *types.ImmediateModeScheduleActionStartSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentInputAttachment(v *types.InputAttachment, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutomaticInputFailoverSettings != nil {
		ok := object.Key("automaticInputFailoverSettings")
		if err := awsRestjson1_serializeDocumentAutomaticInputFailoverSettings(v.AutomaticInputFailoverSettings, ok); err != nil {
			return err
		}
	}

	if v.InputAttachmentName != nil {
		ok := object.Key("inputAttachmentName")
		ok.String(*v.InputAttachmentName)
	}

	if v.InputId != nil {
		ok := object.Key("inputId")
		ok.String(*v.InputId)
	}

	if v.InputSettings != nil {
		ok := object.Key("inputSettings")
		if err := awsRestjson1_serializeDocumentInputSettings(v.InputSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInputChannelLevel(v *types.InputChannelLevel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("gain")
		ok.Integer(v.Gain)
	}

	{
		ok := object.Key("inputChannel")
		ok.Integer(v.InputChannel)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputClippingSettings(v *types.InputClippingSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InputTimecodeSource) > 0 {
		ok := object.Key("inputTimecodeSource")
		ok.String(string(v.InputTimecodeSource))
	}

	if v.StartTimecode != nil {
		ok := object.Key("startTimecode")
		if err := awsRestjson1_serializeDocumentStartTimecode(v.StartTimecode, ok); err != nil {
			return err
		}
	}

	if v.StopTimecode != nil {
		ok := object.Key("stopTimecode")
		if err := awsRestjson1_serializeDocumentStopTimecode(v.StopTimecode, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInputDestinationRequest(v *types.InputDestinationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StreamName != nil {
		ok := object.Key("streamName")
		ok.String(*v.StreamName)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputDeviceConfigurableSettings(v *types.InputDeviceConfigurableSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ConfiguredInput) > 0 {
		ok := object.Key("configuredInput")
		ok.String(string(v.ConfiguredInput))
	}

	if v.LatencyMs != 0 {
		ok := object.Key("latencyMs")
		ok.Integer(v.LatencyMs)
	}

	if v.MaxBitrate != 0 {
		ok := object.Key("maxBitrate")
		ok.Integer(v.MaxBitrate)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputDeviceRequest(v *types.InputDeviceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputDeviceSettings(v *types.InputDeviceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputLocation(v *types.InputLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PasswordParam != nil {
		ok := object.Key("passwordParam")
		ok.String(*v.PasswordParam)
	}

	if v.Uri != nil {
		ok := object.Key("uri")
		ok.String(*v.Uri)
	}

	if v.Username != nil {
		ok := object.Key("username")
		ok.String(*v.Username)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputLossBehavior(v *types.InputLossBehavior, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlackFrameMsec != 0 {
		ok := object.Key("blackFrameMsec")
		ok.Integer(v.BlackFrameMsec)
	}

	if v.InputLossImageColor != nil {
		ok := object.Key("inputLossImageColor")
		ok.String(*v.InputLossImageColor)
	}

	if v.InputLossImageSlate != nil {
		ok := object.Key("inputLossImageSlate")
		if err := awsRestjson1_serializeDocumentInputLocation(v.InputLossImageSlate, ok); err != nil {
			return err
		}
	}

	if len(v.InputLossImageType) > 0 {
		ok := object.Key("inputLossImageType")
		ok.String(string(v.InputLossImageType))
	}

	if v.RepeatFrameMsec != 0 {
		ok := object.Key("repeatFrameMsec")
		ok.Integer(v.RepeatFrameMsec)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputLossFailoverSettings(v *types.InputLossFailoverSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputLossThresholdMsec != 0 {
		ok := object.Key("inputLossThresholdMsec")
		ok.Integer(v.InputLossThresholdMsec)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputPrepareScheduleActionSettings(v *types.InputPrepareScheduleActionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputAttachmentNameReference != nil {
		ok := object.Key("inputAttachmentNameReference")
		ok.String(*v.InputAttachmentNameReference)
	}

	if v.InputClippingSettings != nil {
		ok := object.Key("inputClippingSettings")
		if err := awsRestjson1_serializeDocumentInputClippingSettings(v.InputClippingSettings, ok); err != nil {
			return err
		}
	}

	if v.UrlPath != nil {
		ok := object.Key("urlPath")
		if err := awsRestjson1_serializeDocument__listOf__string(v.UrlPath, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInputSettings(v *types.InputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioSelectors != nil {
		ok := object.Key("audioSelectors")
		if err := awsRestjson1_serializeDocument__listOfAudioSelector(v.AudioSelectors, ok); err != nil {
			return err
		}
	}

	if v.CaptionSelectors != nil {
		ok := object.Key("captionSelectors")
		if err := awsRestjson1_serializeDocument__listOfCaptionSelector(v.CaptionSelectors, ok); err != nil {
			return err
		}
	}

	if len(v.DeblockFilter) > 0 {
		ok := object.Key("deblockFilter")
		ok.String(string(v.DeblockFilter))
	}

	if len(v.DenoiseFilter) > 0 {
		ok := object.Key("denoiseFilter")
		ok.String(string(v.DenoiseFilter))
	}

	if v.FilterStrength != 0 {
		ok := object.Key("filterStrength")
		ok.Integer(v.FilterStrength)
	}

	if len(v.InputFilter) > 0 {
		ok := object.Key("inputFilter")
		ok.String(string(v.InputFilter))
	}

	if v.NetworkInputSettings != nil {
		ok := object.Key("networkInputSettings")
		if err := awsRestjson1_serializeDocumentNetworkInputSettings(v.NetworkInputSettings, ok); err != nil {
			return err
		}
	}

	if v.Scte35Pid != 0 {
		ok := object.Key("scte35Pid")
		ok.Integer(v.Scte35Pid)
	}

	if len(v.Smpte2038DataPreference) > 0 {
		ok := object.Key("smpte2038DataPreference")
		ok.String(string(v.Smpte2038DataPreference))
	}

	if len(v.SourceEndBehavior) > 0 {
		ok := object.Key("sourceEndBehavior")
		ok.String(string(v.SourceEndBehavior))
	}

	if v.VideoSelector != nil {
		ok := object.Key("videoSelector")
		if err := awsRestjson1_serializeDocumentVideoSelector(v.VideoSelector, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInputSourceRequest(v *types.InputSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PasswordParam != nil {
		ok := object.Key("passwordParam")
		ok.String(*v.PasswordParam)
	}

	if v.Url != nil {
		ok := object.Key("url")
		ok.String(*v.Url)
	}

	if v.Username != nil {
		ok := object.Key("username")
		ok.String(*v.Username)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputSpecification(v *types.InputSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Codec) > 0 {
		ok := object.Key("codec")
		ok.String(string(v.Codec))
	}

	if len(v.MaximumBitrate) > 0 {
		ok := object.Key("maximumBitrate")
		ok.String(string(v.MaximumBitrate))
	}

	if len(v.Resolution) > 0 {
		ok := object.Key("resolution")
		ok.String(string(v.Resolution))
	}

	return nil
}

func awsRestjson1_serializeDocumentInputSwitchScheduleActionSettings(v *types.InputSwitchScheduleActionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputAttachmentNameReference != nil {
		ok := object.Key("inputAttachmentNameReference")
		ok.String(*v.InputAttachmentNameReference)
	}

	if v.InputClippingSettings != nil {
		ok := object.Key("inputClippingSettings")
		if err := awsRestjson1_serializeDocumentInputClippingSettings(v.InputClippingSettings, ok); err != nil {
			return err
		}
	}

	if v.UrlPath != nil {
		ok := object.Key("urlPath")
		if err := awsRestjson1_serializeDocument__listOf__string(v.UrlPath, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInputVpcRequest(v *types.InputVpcRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("subnetIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInputWhitelistRuleCidr(v *types.InputWhitelistRuleCidr, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cidr != nil {
		ok := object.Key("cidr")
		ok.String(*v.Cidr)
	}

	return nil
}

func awsRestjson1_serializeDocumentKeyProviderSettings(v *types.KeyProviderSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StaticKeySettings != nil {
		ok := object.Key("staticKeySettings")
		if err := awsRestjson1_serializeDocumentStaticKeySettings(v.StaticKeySettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentM2tsSettings(v *types.M2tsSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AbsentInputAudioBehavior) > 0 {
		ok := object.Key("absentInputAudioBehavior")
		ok.String(string(v.AbsentInputAudioBehavior))
	}

	if len(v.Arib) > 0 {
		ok := object.Key("arib")
		ok.String(string(v.Arib))
	}

	if v.AribCaptionsPid != nil {
		ok := object.Key("aribCaptionsPid")
		ok.String(*v.AribCaptionsPid)
	}

	if len(v.AribCaptionsPidControl) > 0 {
		ok := object.Key("aribCaptionsPidControl")
		ok.String(string(v.AribCaptionsPidControl))
	}

	if len(v.AudioBufferModel) > 0 {
		ok := object.Key("audioBufferModel")
		ok.String(string(v.AudioBufferModel))
	}

	if v.AudioFramesPerPes != 0 {
		ok := object.Key("audioFramesPerPes")
		ok.Integer(v.AudioFramesPerPes)
	}

	if v.AudioPids != nil {
		ok := object.Key("audioPids")
		ok.String(*v.AudioPids)
	}

	if len(v.AudioStreamType) > 0 {
		ok := object.Key("audioStreamType")
		ok.String(string(v.AudioStreamType))
	}

	if v.Bitrate != 0 {
		ok := object.Key("bitrate")
		ok.Integer(v.Bitrate)
	}

	if len(v.BufferModel) > 0 {
		ok := object.Key("bufferModel")
		ok.String(string(v.BufferModel))
	}

	if len(v.CcDescriptor) > 0 {
		ok := object.Key("ccDescriptor")
		ok.String(string(v.CcDescriptor))
	}

	if v.DvbNitSettings != nil {
		ok := object.Key("dvbNitSettings")
		if err := awsRestjson1_serializeDocumentDvbNitSettings(v.DvbNitSettings, ok); err != nil {
			return err
		}
	}

	if v.DvbSdtSettings != nil {
		ok := object.Key("dvbSdtSettings")
		if err := awsRestjson1_serializeDocumentDvbSdtSettings(v.DvbSdtSettings, ok); err != nil {
			return err
		}
	}

	if v.DvbSubPids != nil {
		ok := object.Key("dvbSubPids")
		ok.String(*v.DvbSubPids)
	}

	if v.DvbTdtSettings != nil {
		ok := object.Key("dvbTdtSettings")
		if err := awsRestjson1_serializeDocumentDvbTdtSettings(v.DvbTdtSettings, ok); err != nil {
			return err
		}
	}

	if v.DvbTeletextPid != nil {
		ok := object.Key("dvbTeletextPid")
		ok.String(*v.DvbTeletextPid)
	}

	if len(v.Ebif) > 0 {
		ok := object.Key("ebif")
		ok.String(string(v.Ebif))
	}

	if len(v.EbpAudioInterval) > 0 {
		ok := object.Key("ebpAudioInterval")
		ok.String(string(v.EbpAudioInterval))
	}

	if v.EbpLookaheadMs != 0 {
		ok := object.Key("ebpLookaheadMs")
		ok.Integer(v.EbpLookaheadMs)
	}

	if len(v.EbpPlacement) > 0 {
		ok := object.Key("ebpPlacement")
		ok.String(string(v.EbpPlacement))
	}

	if v.EcmPid != nil {
		ok := object.Key("ecmPid")
		ok.String(*v.EcmPid)
	}

	if len(v.EsRateInPes) > 0 {
		ok := object.Key("esRateInPes")
		ok.String(string(v.EsRateInPes))
	}

	if v.EtvPlatformPid != nil {
		ok := object.Key("etvPlatformPid")
		ok.String(*v.EtvPlatformPid)
	}

	if v.EtvSignalPid != nil {
		ok := object.Key("etvSignalPid")
		ok.String(*v.EtvSignalPid)
	}

	if v.FragmentTime != 0 {
		ok := object.Key("fragmentTime")
		switch {
		case math.IsNaN(v.FragmentTime):
			ok.String("NaN")

		case math.IsInf(v.FragmentTime, 1):
			ok.String("Infinity")

		case math.IsInf(v.FragmentTime, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.FragmentTime)

		}
	}

	if len(v.Klv) > 0 {
		ok := object.Key("klv")
		ok.String(string(v.Klv))
	}

	if v.KlvDataPids != nil {
		ok := object.Key("klvDataPids")
		ok.String(*v.KlvDataPids)
	}

	if len(v.NielsenId3Behavior) > 0 {
		ok := object.Key("nielsenId3Behavior")
		ok.String(string(v.NielsenId3Behavior))
	}

	if v.NullPacketBitrate != 0 {
		ok := object.Key("nullPacketBitrate")
		switch {
		case math.IsNaN(v.NullPacketBitrate):
			ok.String("NaN")

		case math.IsInf(v.NullPacketBitrate, 1):
			ok.String("Infinity")

		case math.IsInf(v.NullPacketBitrate, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.NullPacketBitrate)

		}
	}

	if v.PatInterval != 0 {
		ok := object.Key("patInterval")
		ok.Integer(v.PatInterval)
	}

	if len(v.PcrControl) > 0 {
		ok := object.Key("pcrControl")
		ok.String(string(v.PcrControl))
	}

	if v.PcrPeriod != 0 {
		ok := object.Key("pcrPeriod")
		ok.Integer(v.PcrPeriod)
	}

	if v.PcrPid != nil {
		ok := object.Key("pcrPid")
		ok.String(*v.PcrPid)
	}

	if v.PmtInterval != 0 {
		ok := object.Key("pmtInterval")
		ok.Integer(v.PmtInterval)
	}

	if v.PmtPid != nil {
		ok := object.Key("pmtPid")
		ok.String(*v.PmtPid)
	}

	if v.ProgramNum != 0 {
		ok := object.Key("programNum")
		ok.Integer(v.ProgramNum)
	}

	if len(v.RateMode) > 0 {
		ok := object.Key("rateMode")
		ok.String(string(v.RateMode))
	}

	if v.Scte27Pids != nil {
		ok := object.Key("scte27Pids")
		ok.String(*v.Scte27Pids)
	}

	if len(v.Scte35Control) > 0 {
		ok := object.Key("scte35Control")
		ok.String(string(v.Scte35Control))
	}

	if v.Scte35Pid != nil {
		ok := object.Key("scte35Pid")
		ok.String(*v.Scte35Pid)
	}

	if v.Scte35PrerollPullupMilliseconds != 0 {
		ok := object.Key("scte35PrerollPullupMilliseconds")
		switch {
		case math.IsNaN(v.Scte35PrerollPullupMilliseconds):
			ok.String("NaN")

		case math.IsInf(v.Scte35PrerollPullupMilliseconds, 1):
			ok.String("Infinity")

		case math.IsInf(v.Scte35PrerollPullupMilliseconds, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Scte35PrerollPullupMilliseconds)

		}
	}

	if len(v.SegmentationMarkers) > 0 {
		ok := object.Key("segmentationMarkers")
		ok.String(string(v.SegmentationMarkers))
	}

	if len(v.SegmentationStyle) > 0 {
		ok := object.Key("segmentationStyle")
		ok.String(string(v.SegmentationStyle))
	}

	if v.SegmentationTime != 0 {
		ok := object.Key("segmentationTime")
		switch {
		case math.IsNaN(v.SegmentationTime):
			ok.String("NaN")

		case math.IsInf(v.SegmentationTime, 1):
			ok.String("Infinity")

		case math.IsInf(v.SegmentationTime, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.SegmentationTime)

		}
	}

	if len(v.TimedMetadataBehavior) > 0 {
		ok := object.Key("timedMetadataBehavior")
		ok.String(string(v.TimedMetadataBehavior))
	}

	if v.TimedMetadataPid != nil {
		ok := object.Key("timedMetadataPid")
		ok.String(*v.TimedMetadataPid)
	}

	if v.TransportStreamId != 0 {
		ok := object.Key("transportStreamId")
		ok.Integer(v.TransportStreamId)
	}

	if v.VideoPid != nil {
		ok := object.Key("videoPid")
		ok.String(*v.VideoPid)
	}

	return nil
}

func awsRestjson1_serializeDocumentM3u8Settings(v *types.M3u8Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioFramesPerPes != 0 {
		ok := object.Key("audioFramesPerPes")
		ok.Integer(v.AudioFramesPerPes)
	}

	if v.AudioPids != nil {
		ok := object.Key("audioPids")
		ok.String(*v.AudioPids)
	}

	if v.EcmPid != nil {
		ok := object.Key("ecmPid")
		ok.String(*v.EcmPid)
	}

	if len(v.NielsenId3Behavior) > 0 {
		ok := object.Key("nielsenId3Behavior")
		ok.String(string(v.NielsenId3Behavior))
	}

	if v.PatInterval != 0 {
		ok := object.Key("patInterval")
		ok.Integer(v.PatInterval)
	}

	if len(v.PcrControl) > 0 {
		ok := object.Key("pcrControl")
		ok.String(string(v.PcrControl))
	}

	if v.PcrPeriod != 0 {
		ok := object.Key("pcrPeriod")
		ok.Integer(v.PcrPeriod)
	}

	if v.PcrPid != nil {
		ok := object.Key("pcrPid")
		ok.String(*v.PcrPid)
	}

	if v.PmtInterval != 0 {
		ok := object.Key("pmtInterval")
		ok.Integer(v.PmtInterval)
	}

	if v.PmtPid != nil {
		ok := object.Key("pmtPid")
		ok.String(*v.PmtPid)
	}

	if v.ProgramNum != 0 {
		ok := object.Key("programNum")
		ok.Integer(v.ProgramNum)
	}

	if len(v.Scte35Behavior) > 0 {
		ok := object.Key("scte35Behavior")
		ok.String(string(v.Scte35Behavior))
	}

	if v.Scte35Pid != nil {
		ok := object.Key("scte35Pid")
		ok.String(*v.Scte35Pid)
	}

	if len(v.TimedMetadataBehavior) > 0 {
		ok := object.Key("timedMetadataBehavior")
		ok.String(string(v.TimedMetadataBehavior))
	}

	if v.TimedMetadataPid != nil {
		ok := object.Key("timedMetadataPid")
		ok.String(*v.TimedMetadataPid)
	}

	if v.TransportStreamId != 0 {
		ok := object.Key("transportStreamId")
		ok.Integer(v.TransportStreamId)
	}

	if v.VideoPid != nil {
		ok := object.Key("videoPid")
		ok.String(*v.VideoPid)
	}

	return nil
}

func awsRestjson1_serializeDocumentMaintenanceCreateSettings(v *types.MaintenanceCreateSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MaintenanceDay) > 0 {
		ok := object.Key("maintenanceDay")
		ok.String(string(v.MaintenanceDay))
	}

	if v.MaintenanceStartTime != nil {
		ok := object.Key("maintenanceStartTime")
		ok.String(*v.MaintenanceStartTime)
	}

	return nil
}

func awsRestjson1_serializeDocumentMaintenanceUpdateSettings(v *types.MaintenanceUpdateSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MaintenanceDay) > 0 {
		ok := object.Key("maintenanceDay")
		ok.String(string(v.MaintenanceDay))
	}

	if v.MaintenanceScheduledDate != nil {
		ok := object.Key("maintenanceScheduledDate")
		ok.String(*v.MaintenanceScheduledDate)
	}

	if v.MaintenanceStartTime != nil {
		ok := object.Key("maintenanceStartTime")
		ok.String(*v.MaintenanceStartTime)
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaConnectFlowRequest(v *types.MediaConnectFlowRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowArn != nil {
		ok := object.Key("flowArn")
		ok.String(*v.FlowArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaPackageGroupSettings(v *types.MediaPackageGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("destination")
		if err := awsRestjson1_serializeDocumentOutputLocationRef(v.Destination, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaPackageOutputDestinationSettings(v *types.MediaPackageOutputDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelId != nil {
		ok := object.Key("channelId")
		ok.String(*v.ChannelId)
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaPackageOutputSettings(v *types.MediaPackageOutputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentMotionGraphicsActivateScheduleActionSettings(v *types.MotionGraphicsActivateScheduleActionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Duration != 0 {
		ok := object.Key("duration")
		ok.Long(v.Duration)
	}

	if v.PasswordParam != nil {
		ok := object.Key("passwordParam")
		ok.String(*v.PasswordParam)
	}

	if v.Url != nil {
		ok := object.Key("url")
		ok.String(*v.Url)
	}

	if v.Username != nil {
		ok := object.Key("username")
		ok.String(*v.Username)
	}

	return nil
}

func awsRestjson1_serializeDocumentMotionGraphicsConfiguration(v *types.MotionGraphicsConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MotionGraphicsInsertion) > 0 {
		ok := object.Key("motionGraphicsInsertion")
		ok.String(string(v.MotionGraphicsInsertion))
	}

	if v.MotionGraphicsSettings != nil {
		ok := object.Key("motionGraphicsSettings")
		if err := awsRestjson1_serializeDocumentMotionGraphicsSettings(v.MotionGraphicsSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMotionGraphicsDeactivateScheduleActionSettings(v *types.MotionGraphicsDeactivateScheduleActionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentMotionGraphicsSettings(v *types.MotionGraphicsSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HtmlMotionGraphicsSettings != nil {
		ok := object.Key("htmlMotionGraphicsSettings")
		if err := awsRestjson1_serializeDocumentHtmlMotionGraphicsSettings(v.HtmlMotionGraphicsSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMp2Settings(v *types.Mp2Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bitrate != 0 {
		ok := object.Key("bitrate")
		switch {
		case math.IsNaN(v.Bitrate):
			ok.String("NaN")

		case math.IsInf(v.Bitrate, 1):
			ok.String("Infinity")

		case math.IsInf(v.Bitrate, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Bitrate)

		}
	}

	if len(v.CodingMode) > 0 {
		ok := object.Key("codingMode")
		ok.String(string(v.CodingMode))
	}

	if v.SampleRate != 0 {
		ok := object.Key("sampleRate")
		switch {
		case math.IsNaN(v.SampleRate):
			ok.String("NaN")

		case math.IsInf(v.SampleRate, 1):
			ok.String("Infinity")

		case math.IsInf(v.SampleRate, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.SampleRate)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMpeg2FilterSettings(v *types.Mpeg2FilterSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TemporalFilterSettings != nil {
		ok := object.Key("temporalFilterSettings")
		if err := awsRestjson1_serializeDocumentTemporalFilterSettings(v.TemporalFilterSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMpeg2Settings(v *types.Mpeg2Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AdaptiveQuantization) > 0 {
		ok := object.Key("adaptiveQuantization")
		ok.String(string(v.AdaptiveQuantization))
	}

	if len(v.AfdSignaling) > 0 {
		ok := object.Key("afdSignaling")
		ok.String(string(v.AfdSignaling))
	}

	if len(v.ColorMetadata) > 0 {
		ok := object.Key("colorMetadata")
		ok.String(string(v.ColorMetadata))
	}

	if len(v.ColorSpace) > 0 {
		ok := object.Key("colorSpace")
		ok.String(string(v.ColorSpace))
	}

	if len(v.DisplayAspectRatio) > 0 {
		ok := object.Key("displayAspectRatio")
		ok.String(string(v.DisplayAspectRatio))
	}

	if v.FilterSettings != nil {
		ok := object.Key("filterSettings")
		if err := awsRestjson1_serializeDocumentMpeg2FilterSettings(v.FilterSettings, ok); err != nil {
			return err
		}
	}

	if len(v.FixedAfd) > 0 {
		ok := object.Key("fixedAfd")
		ok.String(string(v.FixedAfd))
	}

	{
		ok := object.Key("framerateDenominator")
		ok.Integer(v.FramerateDenominator)
	}

	{
		ok := object.Key("framerateNumerator")
		ok.Integer(v.FramerateNumerator)
	}

	if v.GopClosedCadence != 0 {
		ok := object.Key("gopClosedCadence")
		ok.Integer(v.GopClosedCadence)
	}

	if v.GopNumBFrames != 0 {
		ok := object.Key("gopNumBFrames")
		ok.Integer(v.GopNumBFrames)
	}

	if v.GopSize != 0 {
		ok := object.Key("gopSize")
		switch {
		case math.IsNaN(v.GopSize):
			ok.String("NaN")

		case math.IsInf(v.GopSize, 1):
			ok.String("Infinity")

		case math.IsInf(v.GopSize, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.GopSize)

		}
	}

	if len(v.GopSizeUnits) > 0 {
		ok := object.Key("gopSizeUnits")
		ok.String(string(v.GopSizeUnits))
	}

	if len(v.ScanType) > 0 {
		ok := object.Key("scanType")
		ok.String(string(v.ScanType))
	}

	if len(v.SubgopLength) > 0 {
		ok := object.Key("subgopLength")
		ok.String(string(v.SubgopLength))
	}

	if v.TimecodeBurninSettings != nil {
		ok := object.Key("timecodeBurninSettings")
		if err := awsRestjson1_serializeDocumentTimecodeBurninSettings(v.TimecodeBurninSettings, ok); err != nil {
			return err
		}
	}

	if len(v.TimecodeInsertion) > 0 {
		ok := object.Key("timecodeInsertion")
		ok.String(string(v.TimecodeInsertion))
	}

	return nil
}

func awsRestjson1_serializeDocumentMsSmoothGroupSettings(v *types.MsSmoothGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AcquisitionPointId != nil {
		ok := object.Key("acquisitionPointId")
		ok.String(*v.AcquisitionPointId)
	}

	if len(v.AudioOnlyTimecodeControl) > 0 {
		ok := object.Key("audioOnlyTimecodeControl")
		ok.String(string(v.AudioOnlyTimecodeControl))
	}

	if len(v.CertificateMode) > 0 {
		ok := object.Key("certificateMode")
		ok.String(string(v.CertificateMode))
	}

	if v.ConnectionRetryInterval != 0 {
		ok := object.Key("connectionRetryInterval")
		ok.Integer(v.ConnectionRetryInterval)
	}

	if v.Destination != nil {
		ok := object.Key("destination")
		if err := awsRestjson1_serializeDocumentOutputLocationRef(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.EventId != nil {
		ok := object.Key("eventId")
		ok.String(*v.EventId)
	}

	if len(v.EventIdMode) > 0 {
		ok := object.Key("eventIdMode")
		ok.String(string(v.EventIdMode))
	}

	if len(v.EventStopBehavior) > 0 {
		ok := object.Key("eventStopBehavior")
		ok.String(string(v.EventStopBehavior))
	}

	if v.FilecacheDuration != 0 {
		ok := object.Key("filecacheDuration")
		ok.Integer(v.FilecacheDuration)
	}

	if v.FragmentLength != 0 {
		ok := object.Key("fragmentLength")
		ok.Integer(v.FragmentLength)
	}

	if len(v.InputLossAction) > 0 {
		ok := object.Key("inputLossAction")
		ok.String(string(v.InputLossAction))
	}

	if v.NumRetries != 0 {
		ok := object.Key("numRetries")
		ok.Integer(v.NumRetries)
	}

	if v.RestartDelay != 0 {
		ok := object.Key("restartDelay")
		ok.Integer(v.RestartDelay)
	}

	if len(v.SegmentationMode) > 0 {
		ok := object.Key("segmentationMode")
		ok.String(string(v.SegmentationMode))
	}

	if v.SendDelayMs != 0 {
		ok := object.Key("sendDelayMs")
		ok.Integer(v.SendDelayMs)
	}

	if len(v.SparseTrackType) > 0 {
		ok := object.Key("sparseTrackType")
		ok.String(string(v.SparseTrackType))
	}

	if len(v.StreamManifestBehavior) > 0 {
		ok := object.Key("streamManifestBehavior")
		ok.String(string(v.StreamManifestBehavior))
	}

	if v.TimestampOffset != nil {
		ok := object.Key("timestampOffset")
		ok.String(*v.TimestampOffset)
	}

	if len(v.TimestampOffsetMode) > 0 {
		ok := object.Key("timestampOffsetMode")
		ok.String(string(v.TimestampOffsetMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentMsSmoothOutputSettings(v *types.MsSmoothOutputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.H265PackagingType) > 0 {
		ok := object.Key("h265PackagingType")
		ok.String(string(v.H265PackagingType))
	}

	if v.NameModifier != nil {
		ok := object.Key("nameModifier")
		ok.String(*v.NameModifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentMultiplexGroupSettings(v *types.MultiplexGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentMultiplexOutputSettings(v *types.MultiplexOutputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("destination")
		if err := awsRestjson1_serializeDocumentOutputLocationRef(v.Destination, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMultiplexProgramChannelDestinationSettings(v *types.MultiplexProgramChannelDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MultiplexId != nil {
		ok := object.Key("multiplexId")
		ok.String(*v.MultiplexId)
	}

	if v.ProgramName != nil {
		ok := object.Key("programName")
		ok.String(*v.ProgramName)
	}

	return nil
}

func awsRestjson1_serializeDocumentMultiplexProgramServiceDescriptor(v *types.MultiplexProgramServiceDescriptor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProviderName != nil {
		ok := object.Key("providerName")
		ok.String(*v.ProviderName)
	}

	if v.ServiceName != nil {
		ok := object.Key("serviceName")
		ok.String(*v.ServiceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentMultiplexProgramSettings(v *types.MultiplexProgramSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.PreferredChannelPipeline) > 0 {
		ok := object.Key("preferredChannelPipeline")
		ok.String(string(v.PreferredChannelPipeline))
	}

	{
		ok := object.Key("programNumber")
		ok.Integer(v.ProgramNumber)
	}

	if v.ServiceDescriptor != nil {
		ok := object.Key("serviceDescriptor")
		if err := awsRestjson1_serializeDocumentMultiplexProgramServiceDescriptor(v.ServiceDescriptor, ok); err != nil {
			return err
		}
	}

	if v.VideoSettings != nil {
		ok := object.Key("videoSettings")
		if err := awsRestjson1_serializeDocumentMultiplexVideoSettings(v.VideoSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMultiplexSettings(v *types.MultiplexSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaximumVideoBufferDelayMilliseconds != 0 {
		ok := object.Key("maximumVideoBufferDelayMilliseconds")
		ok.Integer(v.MaximumVideoBufferDelayMilliseconds)
	}

	{
		ok := object.Key("transportStreamBitrate")
		ok.Integer(v.TransportStreamBitrate)
	}

	{
		ok := object.Key("transportStreamId")
		ok.Integer(v.TransportStreamId)
	}

	if v.TransportStreamReservedBitrate != 0 {
		ok := object.Key("transportStreamReservedBitrate")
		ok.Integer(v.TransportStreamReservedBitrate)
	}

	return nil
}

func awsRestjson1_serializeDocumentMultiplexStatmuxVideoSettings(v *types.MultiplexStatmuxVideoSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaximumBitrate != 0 {
		ok := object.Key("maximumBitrate")
		ok.Integer(v.MaximumBitrate)
	}

	if v.MinimumBitrate != 0 {
		ok := object.Key("minimumBitrate")
		ok.Integer(v.MinimumBitrate)
	}

	if v.Priority != 0 {
		ok := object.Key("priority")
		ok.Integer(v.Priority)
	}

	return nil
}

func awsRestjson1_serializeDocumentMultiplexVideoSettings(v *types.MultiplexVideoSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConstantBitrate != 0 {
		ok := object.Key("constantBitrate")
		ok.Integer(v.ConstantBitrate)
	}

	if v.StatmuxSettings != nil {
		ok := object.Key("statmuxSettings")
		if err := awsRestjson1_serializeDocumentMultiplexStatmuxVideoSettings(v.StatmuxSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNetworkInputSettings(v *types.NetworkInputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HlsInputSettings != nil {
		ok := object.Key("hlsInputSettings")
		if err := awsRestjson1_serializeDocumentHlsInputSettings(v.HlsInputSettings, ok); err != nil {
			return err
		}
	}

	if len(v.ServerValidation) > 0 {
		ok := object.Key("serverValidation")
		ok.String(string(v.ServerValidation))
	}

	return nil
}

func awsRestjson1_serializeDocumentNielsenCBET(v *types.NielsenCBET, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CbetCheckDigitString != nil {
		ok := object.Key("cbetCheckDigitString")
		ok.String(*v.CbetCheckDigitString)
	}

	if len(v.CbetStepaside) > 0 {
		ok := object.Key("cbetStepaside")
		ok.String(string(v.CbetStepaside))
	}

	if v.Csid != nil {
		ok := object.Key("csid")
		ok.String(*v.Csid)
	}

	return nil
}

func awsRestjson1_serializeDocumentNielsenConfiguration(v *types.NielsenConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DistributorId != nil {
		ok := object.Key("distributorId")
		ok.String(*v.DistributorId)
	}

	if len(v.NielsenPcmToId3Tagging) > 0 {
		ok := object.Key("nielsenPcmToId3Tagging")
		ok.String(string(v.NielsenPcmToId3Tagging))
	}

	return nil
}

func awsRestjson1_serializeDocumentNielsenNaesIiNw(v *types.NielsenNaesIiNw, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CheckDigitString != nil {
		ok := object.Key("checkDigitString")
		ok.String(*v.CheckDigitString)
	}

	{
		ok := object.Key("sid")
		switch {
		case math.IsNaN(v.Sid):
			ok.String("NaN")

		case math.IsInf(v.Sid, 1):
			ok.String("Infinity")

		case math.IsInf(v.Sid, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Sid)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNielsenWatermarksSettings(v *types.NielsenWatermarksSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NielsenCbetSettings != nil {
		ok := object.Key("nielsenCbetSettings")
		if err := awsRestjson1_serializeDocumentNielsenCBET(v.NielsenCbetSettings, ok); err != nil {
			return err
		}
	}

	if len(v.NielsenDistributionType) > 0 {
		ok := object.Key("nielsenDistributionType")
		ok.String(string(v.NielsenDistributionType))
	}

	if v.NielsenNaesIiNwSettings != nil {
		ok := object.Key("nielsenNaesIiNwSettings")
		if err := awsRestjson1_serializeDocumentNielsenNaesIiNw(v.NielsenNaesIiNwSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOutput(v *types.Output, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioDescriptionNames != nil {
		ok := object.Key("audioDescriptionNames")
		if err := awsRestjson1_serializeDocument__listOf__string(v.AudioDescriptionNames, ok); err != nil {
			return err
		}
	}

	if v.CaptionDescriptionNames != nil {
		ok := object.Key("captionDescriptionNames")
		if err := awsRestjson1_serializeDocument__listOf__string(v.CaptionDescriptionNames, ok); err != nil {
			return err
		}
	}

	if v.OutputName != nil {
		ok := object.Key("outputName")
		ok.String(*v.OutputName)
	}

	if v.OutputSettings != nil {
		ok := object.Key("outputSettings")
		if err := awsRestjson1_serializeDocumentOutputSettings(v.OutputSettings, ok); err != nil {
			return err
		}
	}

	if v.VideoDescriptionName != nil {
		ok := object.Key("videoDescriptionName")
		ok.String(*v.VideoDescriptionName)
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputDestination(v *types.OutputDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.MediaPackageSettings != nil {
		ok := object.Key("mediaPackageSettings")
		if err := awsRestjson1_serializeDocument__listOfMediaPackageOutputDestinationSettings(v.MediaPackageSettings, ok); err != nil {
			return err
		}
	}

	if v.MultiplexSettings != nil {
		ok := object.Key("multiplexSettings")
		if err := awsRestjson1_serializeDocumentMultiplexProgramChannelDestinationSettings(v.MultiplexSettings, ok); err != nil {
			return err
		}
	}

	if v.Settings != nil {
		ok := object.Key("settings")
		if err := awsRestjson1_serializeDocument__listOfOutputDestinationSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputDestinationSettings(v *types.OutputDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PasswordParam != nil {
		ok := object.Key("passwordParam")
		ok.String(*v.PasswordParam)
	}

	if v.StreamName != nil {
		ok := object.Key("streamName")
		ok.String(*v.StreamName)
	}

	if v.Url != nil {
		ok := object.Key("url")
		ok.String(*v.Url)
	}

	if v.Username != nil {
		ok := object.Key("username")
		ok.String(*v.Username)
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputGroup(v *types.OutputGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.OutputGroupSettings != nil {
		ok := object.Key("outputGroupSettings")
		if err := awsRestjson1_serializeDocumentOutputGroupSettings(v.OutputGroupSettings, ok); err != nil {
			return err
		}
	}

	if v.Outputs != nil {
		ok := object.Key("outputs")
		if err := awsRestjson1_serializeDocument__listOfOutput(v.Outputs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputGroupSettings(v *types.OutputGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ArchiveGroupSettings != nil {
		ok := object.Key("archiveGroupSettings")
		if err := awsRestjson1_serializeDocumentArchiveGroupSettings(v.ArchiveGroupSettings, ok); err != nil {
			return err
		}
	}

	if v.FrameCaptureGroupSettings != nil {
		ok := object.Key("frameCaptureGroupSettings")
		if err := awsRestjson1_serializeDocumentFrameCaptureGroupSettings(v.FrameCaptureGroupSettings, ok); err != nil {
			return err
		}
	}

	if v.HlsGroupSettings != nil {
		ok := object.Key("hlsGroupSettings")
		if err := awsRestjson1_serializeDocumentHlsGroupSettings(v.HlsGroupSettings, ok); err != nil {
			return err
		}
	}

	if v.MediaPackageGroupSettings != nil {
		ok := object.Key("mediaPackageGroupSettings")
		if err := awsRestjson1_serializeDocumentMediaPackageGroupSettings(v.MediaPackageGroupSettings, ok); err != nil {
			return err
		}
	}

	if v.MsSmoothGroupSettings != nil {
		ok := object.Key("msSmoothGroupSettings")
		if err := awsRestjson1_serializeDocumentMsSmoothGroupSettings(v.MsSmoothGroupSettings, ok); err != nil {
			return err
		}
	}

	if v.MultiplexGroupSettings != nil {
		ok := object.Key("multiplexGroupSettings")
		if err := awsRestjson1_serializeDocumentMultiplexGroupSettings(v.MultiplexGroupSettings, ok); err != nil {
			return err
		}
	}

	if v.RtmpGroupSettings != nil {
		ok := object.Key("rtmpGroupSettings")
		if err := awsRestjson1_serializeDocumentRtmpGroupSettings(v.RtmpGroupSettings, ok); err != nil {
			return err
		}
	}

	if v.UdpGroupSettings != nil {
		ok := object.Key("udpGroupSettings")
		if err := awsRestjson1_serializeDocumentUdpGroupSettings(v.UdpGroupSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputLocationRef(v *types.OutputLocationRef, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationRefId != nil {
		ok := object.Key("destinationRefId")
		ok.String(*v.DestinationRefId)
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputSettings(v *types.OutputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ArchiveOutputSettings != nil {
		ok := object.Key("archiveOutputSettings")
		if err := awsRestjson1_serializeDocumentArchiveOutputSettings(v.ArchiveOutputSettings, ok); err != nil {
			return err
		}
	}

	if v.FrameCaptureOutputSettings != nil {
		ok := object.Key("frameCaptureOutputSettings")
		if err := awsRestjson1_serializeDocumentFrameCaptureOutputSettings(v.FrameCaptureOutputSettings, ok); err != nil {
			return err
		}
	}

	if v.HlsOutputSettings != nil {
		ok := object.Key("hlsOutputSettings")
		if err := awsRestjson1_serializeDocumentHlsOutputSettings(v.HlsOutputSettings, ok); err != nil {
			return err
		}
	}

	if v.MediaPackageOutputSettings != nil {
		ok := object.Key("mediaPackageOutputSettings")
		if err := awsRestjson1_serializeDocumentMediaPackageOutputSettings(v.MediaPackageOutputSettings, ok); err != nil {
			return err
		}
	}

	if v.MsSmoothOutputSettings != nil {
		ok := object.Key("msSmoothOutputSettings")
		if err := awsRestjson1_serializeDocumentMsSmoothOutputSettings(v.MsSmoothOutputSettings, ok); err != nil {
			return err
		}
	}

	if v.MultiplexOutputSettings != nil {
		ok := object.Key("multiplexOutputSettings")
		if err := awsRestjson1_serializeDocumentMultiplexOutputSettings(v.MultiplexOutputSettings, ok); err != nil {
			return err
		}
	}

	if v.RtmpOutputSettings != nil {
		ok := object.Key("rtmpOutputSettings")
		if err := awsRestjson1_serializeDocumentRtmpOutputSettings(v.RtmpOutputSettings, ok); err != nil {
			return err
		}
	}

	if v.UdpOutputSettings != nil {
		ok := object.Key("udpOutputSettings")
		if err := awsRestjson1_serializeDocumentUdpOutputSettings(v.UdpOutputSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPassThroughSettings(v *types.PassThroughSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentPauseStateScheduleActionSettings(v *types.PauseStateScheduleActionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Pipelines != nil {
		ok := object.Key("pipelines")
		if err := awsRestjson1_serializeDocument__listOfPipelinePauseStateSettings(v.Pipelines, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPipelinePauseStateSettings(v *types.PipelinePauseStateSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.PipelineId) > 0 {
		ok := object.Key("pipelineId")
		ok.String(string(v.PipelineId))
	}

	return nil
}

func awsRestjson1_serializeDocumentRawSettings(v *types.RawSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentRec601Settings(v *types.Rec601Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentRec709Settings(v *types.Rec709Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentRemixSettings(v *types.RemixSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelMappings != nil {
		ok := object.Key("channelMappings")
		if err := awsRestjson1_serializeDocument__listOfAudioChannelMapping(v.ChannelMappings, ok); err != nil {
			return err
		}
	}

	if v.ChannelsIn != 0 {
		ok := object.Key("channelsIn")
		ok.Integer(v.ChannelsIn)
	}

	if v.ChannelsOut != 0 {
		ok := object.Key("channelsOut")
		ok.Integer(v.ChannelsOut)
	}

	return nil
}

func awsRestjson1_serializeDocumentRenewalSettings(v *types.RenewalSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AutomaticRenewal) > 0 {
		ok := object.Key("automaticRenewal")
		ok.String(string(v.AutomaticRenewal))
	}

	if v.RenewalCount != 0 {
		ok := object.Key("renewalCount")
		ok.Integer(v.RenewalCount)
	}

	return nil
}

func awsRestjson1_serializeDocumentRtmpCaptionInfoDestinationSettings(v *types.RtmpCaptionInfoDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentRtmpGroupSettings(v *types.RtmpGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdMarkers != nil {
		ok := object.Key("adMarkers")
		if err := awsRestjson1_serializeDocument__listOfRtmpAdMarkers(v.AdMarkers, ok); err != nil {
			return err
		}
	}

	if len(v.AuthenticationScheme) > 0 {
		ok := object.Key("authenticationScheme")
		ok.String(string(v.AuthenticationScheme))
	}

	if len(v.CacheFullBehavior) > 0 {
		ok := object.Key("cacheFullBehavior")
		ok.String(string(v.CacheFullBehavior))
	}

	if v.CacheLength != 0 {
		ok := object.Key("cacheLength")
		ok.Integer(v.CacheLength)
	}

	if len(v.CaptionData) > 0 {
		ok := object.Key("captionData")
		ok.String(string(v.CaptionData))
	}

	if len(v.InputLossAction) > 0 {
		ok := object.Key("inputLossAction")
		ok.String(string(v.InputLossAction))
	}

	if v.RestartDelay != 0 {
		ok := object.Key("restartDelay")
		ok.Integer(v.RestartDelay)
	}

	return nil
}

func awsRestjson1_serializeDocumentRtmpOutputSettings(v *types.RtmpOutputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CertificateMode) > 0 {
		ok := object.Key("certificateMode")
		ok.String(string(v.CertificateMode))
	}

	if v.ConnectionRetryInterval != 0 {
		ok := object.Key("connectionRetryInterval")
		ok.Integer(v.ConnectionRetryInterval)
	}

	if v.Destination != nil {
		ok := object.Key("destination")
		if err := awsRestjson1_serializeDocumentOutputLocationRef(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.NumRetries != 0 {
		ok := object.Key("numRetries")
		ok.Integer(v.NumRetries)
	}

	return nil
}

func awsRestjson1_serializeDocumentScheduleAction(v *types.ScheduleAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionName != nil {
		ok := object.Key("actionName")
		ok.String(*v.ActionName)
	}

	if v.ScheduleActionSettings != nil {
		ok := object.Key("scheduleActionSettings")
		if err := awsRestjson1_serializeDocumentScheduleActionSettings(v.ScheduleActionSettings, ok); err != nil {
			return err
		}
	}

	if v.ScheduleActionStartSettings != nil {
		ok := object.Key("scheduleActionStartSettings")
		if err := awsRestjson1_serializeDocumentScheduleActionStartSettings(v.ScheduleActionStartSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentScheduleActionSettings(v *types.ScheduleActionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HlsId3SegmentTaggingSettings != nil {
		ok := object.Key("hlsId3SegmentTaggingSettings")
		if err := awsRestjson1_serializeDocumentHlsId3SegmentTaggingScheduleActionSettings(v.HlsId3SegmentTaggingSettings, ok); err != nil {
			return err
		}
	}

	if v.HlsTimedMetadataSettings != nil {
		ok := object.Key("hlsTimedMetadataSettings")
		if err := awsRestjson1_serializeDocumentHlsTimedMetadataScheduleActionSettings(v.HlsTimedMetadataSettings, ok); err != nil {
			return err
		}
	}

	if v.InputPrepareSettings != nil {
		ok := object.Key("inputPrepareSettings")
		if err := awsRestjson1_serializeDocumentInputPrepareScheduleActionSettings(v.InputPrepareSettings, ok); err != nil {
			return err
		}
	}

	if v.InputSwitchSettings != nil {
		ok := object.Key("inputSwitchSettings")
		if err := awsRestjson1_serializeDocumentInputSwitchScheduleActionSettings(v.InputSwitchSettings, ok); err != nil {
			return err
		}
	}

	if v.MotionGraphicsImageActivateSettings != nil {
		ok := object.Key("motionGraphicsImageActivateSettings")
		if err := awsRestjson1_serializeDocumentMotionGraphicsActivateScheduleActionSettings(v.MotionGraphicsImageActivateSettings, ok); err != nil {
			return err
		}
	}

	if v.MotionGraphicsImageDeactivateSettings != nil {
		ok := object.Key("motionGraphicsImageDeactivateSettings")
		if err := awsRestjson1_serializeDocumentMotionGraphicsDeactivateScheduleActionSettings(v.MotionGraphicsImageDeactivateSettings, ok); err != nil {
			return err
		}
	}

	if v.PauseStateSettings != nil {
		ok := object.Key("pauseStateSettings")
		if err := awsRestjson1_serializeDocumentPauseStateScheduleActionSettings(v.PauseStateSettings, ok); err != nil {
			return err
		}
	}

	if v.Scte35InputSettings != nil {
		ok := object.Key("scte35InputSettings")
		if err := awsRestjson1_serializeDocumentScte35InputScheduleActionSettings(v.Scte35InputSettings, ok); err != nil {
			return err
		}
	}

	if v.Scte35ReturnToNetworkSettings != nil {
		ok := object.Key("scte35ReturnToNetworkSettings")
		if err := awsRestjson1_serializeDocumentScte35ReturnToNetworkScheduleActionSettings(v.Scte35ReturnToNetworkSettings, ok); err != nil {
			return err
		}
	}

	if v.Scte35SpliceInsertSettings != nil {
		ok := object.Key("scte35SpliceInsertSettings")
		if err := awsRestjson1_serializeDocumentScte35SpliceInsertScheduleActionSettings(v.Scte35SpliceInsertSettings, ok); err != nil {
			return err
		}
	}

	if v.Scte35TimeSignalSettings != nil {
		ok := object.Key("scte35TimeSignalSettings")
		if err := awsRestjson1_serializeDocumentScte35TimeSignalScheduleActionSettings(v.Scte35TimeSignalSettings, ok); err != nil {
			return err
		}
	}

	if v.StaticImageActivateSettings != nil {
		ok := object.Key("staticImageActivateSettings")
		if err := awsRestjson1_serializeDocumentStaticImageActivateScheduleActionSettings(v.StaticImageActivateSettings, ok); err != nil {
			return err
		}
	}

	if v.StaticImageDeactivateSettings != nil {
		ok := object.Key("staticImageDeactivateSettings")
		if err := awsRestjson1_serializeDocumentStaticImageDeactivateScheduleActionSettings(v.StaticImageDeactivateSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentScheduleActionStartSettings(v *types.ScheduleActionStartSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FixedModeScheduleActionStartSettings != nil {
		ok := object.Key("fixedModeScheduleActionStartSettings")
		if err := awsRestjson1_serializeDocumentFixedModeScheduleActionStartSettings(v.FixedModeScheduleActionStartSettings, ok); err != nil {
			return err
		}
	}

	if v.FollowModeScheduleActionStartSettings != nil {
		ok := object.Key("followModeScheduleActionStartSettings")
		if err := awsRestjson1_serializeDocumentFollowModeScheduleActionStartSettings(v.FollowModeScheduleActionStartSettings, ok); err != nil {
			return err
		}
	}

	if v.ImmediateModeScheduleActionStartSettings != nil {
		ok := object.Key("immediateModeScheduleActionStartSettings")
		if err := awsRestjson1_serializeDocumentImmediateModeScheduleActionStartSettings(v.ImmediateModeScheduleActionStartSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentScte20PlusEmbeddedDestinationSettings(v *types.Scte20PlusEmbeddedDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentScte20SourceSettings(v *types.Scte20SourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Convert608To708) > 0 {
		ok := object.Key("convert608To708")
		ok.String(string(v.Convert608To708))
	}

	if v.Source608ChannelNumber != 0 {
		ok := object.Key("source608ChannelNumber")
		ok.Integer(v.Source608ChannelNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentScte27DestinationSettings(v *types.Scte27DestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentScte27SourceSettings(v *types.Scte27SourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.OcrLanguage) > 0 {
		ok := object.Key("ocrLanguage")
		ok.String(string(v.OcrLanguage))
	}

	if v.Pid != 0 {
		ok := object.Key("pid")
		ok.Integer(v.Pid)
	}

	return nil
}

func awsRestjson1_serializeDocumentScte35DeliveryRestrictions(v *types.Scte35DeliveryRestrictions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ArchiveAllowedFlag) > 0 {
		ok := object.Key("archiveAllowedFlag")
		ok.String(string(v.ArchiveAllowedFlag))
	}

	if len(v.DeviceRestrictions) > 0 {
		ok := object.Key("deviceRestrictions")
		ok.String(string(v.DeviceRestrictions))
	}

	if len(v.NoRegionalBlackoutFlag) > 0 {
		ok := object.Key("noRegionalBlackoutFlag")
		ok.String(string(v.NoRegionalBlackoutFlag))
	}

	if len(v.WebDeliveryAllowedFlag) > 0 {
		ok := object.Key("webDeliveryAllowedFlag")
		ok.String(string(v.WebDeliveryAllowedFlag))
	}

	return nil
}

func awsRestjson1_serializeDocumentScte35Descriptor(v *types.Scte35Descriptor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Scte35DescriptorSettings != nil {
		ok := object.Key("scte35DescriptorSettings")
		if err := awsRestjson1_serializeDocumentScte35DescriptorSettings(v.Scte35DescriptorSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentScte35DescriptorSettings(v *types.Scte35DescriptorSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SegmentationDescriptorScte35DescriptorSettings != nil {
		ok := object.Key("segmentationDescriptorScte35DescriptorSettings")
		if err := awsRestjson1_serializeDocumentScte35SegmentationDescriptor(v.SegmentationDescriptorScte35DescriptorSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentScte35InputScheduleActionSettings(v *types.Scte35InputScheduleActionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputAttachmentNameReference != nil {
		ok := object.Key("inputAttachmentNameReference")
		ok.String(*v.InputAttachmentNameReference)
	}

	if len(v.Mode) > 0 {
		ok := object.Key("mode")
		ok.String(string(v.Mode))
	}

	return nil
}

func awsRestjson1_serializeDocumentScte35ReturnToNetworkScheduleActionSettings(v *types.Scte35ReturnToNetworkScheduleActionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("spliceEventId")
		ok.Long(v.SpliceEventId)
	}

	return nil
}

func awsRestjson1_serializeDocumentScte35SegmentationDescriptor(v *types.Scte35SegmentationDescriptor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryRestrictions != nil {
		ok := object.Key("deliveryRestrictions")
		if err := awsRestjson1_serializeDocumentScte35DeliveryRestrictions(v.DeliveryRestrictions, ok); err != nil {
			return err
		}
	}

	if len(v.SegmentationCancelIndicator) > 0 {
		ok := object.Key("segmentationCancelIndicator")
		ok.String(string(v.SegmentationCancelIndicator))
	}

	if v.SegmentationDuration != 0 {
		ok := object.Key("segmentationDuration")
		ok.Long(v.SegmentationDuration)
	}

	{
		ok := object.Key("segmentationEventId")
		ok.Long(v.SegmentationEventId)
	}

	if v.SegmentationTypeId != 0 {
		ok := object.Key("segmentationTypeId")
		ok.Integer(v.SegmentationTypeId)
	}

	if v.SegmentationUpid != nil {
		ok := object.Key("segmentationUpid")
		ok.String(*v.SegmentationUpid)
	}

	if v.SegmentationUpidType != 0 {
		ok := object.Key("segmentationUpidType")
		ok.Integer(v.SegmentationUpidType)
	}

	if v.SegmentNum != 0 {
		ok := object.Key("segmentNum")
		ok.Integer(v.SegmentNum)
	}

	if v.SegmentsExpected != 0 {
		ok := object.Key("segmentsExpected")
		ok.Integer(v.SegmentsExpected)
	}

	if v.SubSegmentNum != 0 {
		ok := object.Key("subSegmentNum")
		ok.Integer(v.SubSegmentNum)
	}

	if v.SubSegmentsExpected != 0 {
		ok := object.Key("subSegmentsExpected")
		ok.Integer(v.SubSegmentsExpected)
	}

	return nil
}

func awsRestjson1_serializeDocumentScte35SpliceInsert(v *types.Scte35SpliceInsert, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdAvailOffset != 0 {
		ok := object.Key("adAvailOffset")
		ok.Integer(v.AdAvailOffset)
	}

	if len(v.NoRegionalBlackoutFlag) > 0 {
		ok := object.Key("noRegionalBlackoutFlag")
		ok.String(string(v.NoRegionalBlackoutFlag))
	}

	if len(v.WebDeliveryAllowedFlag) > 0 {
		ok := object.Key("webDeliveryAllowedFlag")
		ok.String(string(v.WebDeliveryAllowedFlag))
	}

	return nil
}

func awsRestjson1_serializeDocumentScte35SpliceInsertScheduleActionSettings(v *types.Scte35SpliceInsertScheduleActionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Duration != 0 {
		ok := object.Key("duration")
		ok.Long(v.Duration)
	}

	{
		ok := object.Key("spliceEventId")
		ok.Long(v.SpliceEventId)
	}

	return nil
}

func awsRestjson1_serializeDocumentScte35TimeSignalApos(v *types.Scte35TimeSignalApos, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdAvailOffset != 0 {
		ok := object.Key("adAvailOffset")
		ok.Integer(v.AdAvailOffset)
	}

	if len(v.NoRegionalBlackoutFlag) > 0 {
		ok := object.Key("noRegionalBlackoutFlag")
		ok.String(string(v.NoRegionalBlackoutFlag))
	}

	if len(v.WebDeliveryAllowedFlag) > 0 {
		ok := object.Key("webDeliveryAllowedFlag")
		ok.String(string(v.WebDeliveryAllowedFlag))
	}

	return nil
}

func awsRestjson1_serializeDocumentScte35TimeSignalScheduleActionSettings(v *types.Scte35TimeSignalScheduleActionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Scte35Descriptors != nil {
		ok := object.Key("scte35Descriptors")
		if err := awsRestjson1_serializeDocument__listOfScte35Descriptor(v.Scte35Descriptors, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSmpteTtDestinationSettings(v *types.SmpteTtDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentStandardHlsSettings(v *types.StandardHlsSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioRenditionSets != nil {
		ok := object.Key("audioRenditionSets")
		ok.String(*v.AudioRenditionSets)
	}

	if v.M3u8Settings != nil {
		ok := object.Key("m3u8Settings")
		if err := awsRestjson1_serializeDocumentM3u8Settings(v.M3u8Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentStartTimecode(v *types.StartTimecode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Timecode != nil {
		ok := object.Key("timecode")
		ok.String(*v.Timecode)
	}

	return nil
}

func awsRestjson1_serializeDocumentStaticImageActivateScheduleActionSettings(v *types.StaticImageActivateScheduleActionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Duration != 0 {
		ok := object.Key("duration")
		ok.Integer(v.Duration)
	}

	if v.FadeIn != 0 {
		ok := object.Key("fadeIn")
		ok.Integer(v.FadeIn)
	}

	if v.FadeOut != 0 {
		ok := object.Key("fadeOut")
		ok.Integer(v.FadeOut)
	}

	if v.Height != 0 {
		ok := object.Key("height")
		ok.Integer(v.Height)
	}

	if v.Image != nil {
		ok := object.Key("image")
		if err := awsRestjson1_serializeDocumentInputLocation(v.Image, ok); err != nil {
			return err
		}
	}

	if v.ImageX != 0 {
		ok := object.Key("imageX")
		ok.Integer(v.ImageX)
	}

	if v.ImageY != 0 {
		ok := object.Key("imageY")
		ok.Integer(v.ImageY)
	}

	if v.Layer != 0 {
		ok := object.Key("layer")
		ok.Integer(v.Layer)
	}

	if v.Opacity != 0 {
		ok := object.Key("opacity")
		ok.Integer(v.Opacity)
	}

	if v.Width != 0 {
		ok := object.Key("width")
		ok.Integer(v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentStaticImageDeactivateScheduleActionSettings(v *types.StaticImageDeactivateScheduleActionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FadeOut != 0 {
		ok := object.Key("fadeOut")
		ok.Integer(v.FadeOut)
	}

	if v.Layer != 0 {
		ok := object.Key("layer")
		ok.Integer(v.Layer)
	}

	return nil
}

func awsRestjson1_serializeDocumentStaticKeySettings(v *types.StaticKeySettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyProviderServer != nil {
		ok := object.Key("keyProviderServer")
		if err := awsRestjson1_serializeDocumentInputLocation(v.KeyProviderServer, ok); err != nil {
			return err
		}
	}

	if v.StaticKeyValue != nil {
		ok := object.Key("staticKeyValue")
		ok.String(*v.StaticKeyValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentStopTimecode(v *types.StopTimecode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LastFrameClippingBehavior) > 0 {
		ok := object.Key("lastFrameClippingBehavior")
		ok.String(string(v.LastFrameClippingBehavior))
	}

	if v.Timecode != nil {
		ok := object.Key("timecode")
		ok.String(*v.Timecode)
	}

	return nil
}

func awsRestjson1_serializeDocumentTags(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTeletextDestinationSettings(v *types.TeletextDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentTeletextSourceSettings(v *types.TeletextSourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OutputRectangle != nil {
		ok := object.Key("outputRectangle")
		if err := awsRestjson1_serializeDocumentCaptionRectangle(v.OutputRectangle, ok); err != nil {
			return err
		}
	}

	if v.PageNumber != nil {
		ok := object.Key("pageNumber")
		ok.String(*v.PageNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentTemporalFilterSettings(v *types.TemporalFilterSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.PostFilterSharpening) > 0 {
		ok := object.Key("postFilterSharpening")
		ok.String(string(v.PostFilterSharpening))
	}

	if len(v.Strength) > 0 {
		ok := object.Key("strength")
		ok.String(string(v.Strength))
	}

	return nil
}

func awsRestjson1_serializeDocumentTimecodeBurninSettings(v *types.TimecodeBurninSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FontSize) > 0 {
		ok := object.Key("fontSize")
		ok.String(string(v.FontSize))
	}

	if len(v.Position) > 0 {
		ok := object.Key("position")
		ok.String(string(v.Position))
	}

	if v.Prefix != nil {
		ok := object.Key("prefix")
		ok.String(*v.Prefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentTimecodeConfig(v *types.TimecodeConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Source) > 0 {
		ok := object.Key("source")
		ok.String(string(v.Source))
	}

	if v.SyncThreshold != 0 {
		ok := object.Key("syncThreshold")
		ok.Integer(v.SyncThreshold)
	}

	return nil
}

func awsRestjson1_serializeDocumentTtmlDestinationSettings(v *types.TtmlDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.StyleControl) > 0 {
		ok := object.Key("styleControl")
		ok.String(string(v.StyleControl))
	}

	return nil
}

func awsRestjson1_serializeDocumentUdpContainerSettings(v *types.UdpContainerSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.M2tsSettings != nil {
		ok := object.Key("m2tsSettings")
		if err := awsRestjson1_serializeDocumentM2tsSettings(v.M2tsSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUdpGroupSettings(v *types.UdpGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InputLossAction) > 0 {
		ok := object.Key("inputLossAction")
		ok.String(string(v.InputLossAction))
	}

	if len(v.TimedMetadataId3Frame) > 0 {
		ok := object.Key("timedMetadataId3Frame")
		ok.String(string(v.TimedMetadataId3Frame))
	}

	if v.TimedMetadataId3Period != 0 {
		ok := object.Key("timedMetadataId3Period")
		ok.Integer(v.TimedMetadataId3Period)
	}

	return nil
}

func awsRestjson1_serializeDocumentUdpOutputSettings(v *types.UdpOutputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BufferMsec != 0 {
		ok := object.Key("bufferMsec")
		ok.Integer(v.BufferMsec)
	}

	if v.ContainerSettings != nil {
		ok := object.Key("containerSettings")
		if err := awsRestjson1_serializeDocumentUdpContainerSettings(v.ContainerSettings, ok); err != nil {
			return err
		}
	}

	if v.Destination != nil {
		ok := object.Key("destination")
		if err := awsRestjson1_serializeDocumentOutputLocationRef(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.FecOutputSettings != nil {
		ok := object.Key("fecOutputSettings")
		if err := awsRestjson1_serializeDocumentFecOutputSettings(v.FecOutputSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoBlackFailoverSettings(v *types.VideoBlackFailoverSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlackDetectThreshold != 0 {
		ok := object.Key("blackDetectThreshold")
		switch {
		case math.IsNaN(v.BlackDetectThreshold):
			ok.String("NaN")

		case math.IsInf(v.BlackDetectThreshold, 1):
			ok.String("Infinity")

		case math.IsInf(v.BlackDetectThreshold, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.BlackDetectThreshold)

		}
	}

	if v.VideoBlackThresholdMsec != 0 {
		ok := object.Key("videoBlackThresholdMsec")
		ok.Integer(v.VideoBlackThresholdMsec)
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoCodecSettings(v *types.VideoCodecSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FrameCaptureSettings != nil {
		ok := object.Key("frameCaptureSettings")
		if err := awsRestjson1_serializeDocumentFrameCaptureSettings(v.FrameCaptureSettings, ok); err != nil {
			return err
		}
	}

	if v.H264Settings != nil {
		ok := object.Key("h264Settings")
		if err := awsRestjson1_serializeDocumentH264Settings(v.H264Settings, ok); err != nil {
			return err
		}
	}

	if v.H265Settings != nil {
		ok := object.Key("h265Settings")
		if err := awsRestjson1_serializeDocumentH265Settings(v.H265Settings, ok); err != nil {
			return err
		}
	}

	if v.Mpeg2Settings != nil {
		ok := object.Key("mpeg2Settings")
		if err := awsRestjson1_serializeDocumentMpeg2Settings(v.Mpeg2Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoDescription(v *types.VideoDescription, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CodecSettings != nil {
		ok := object.Key("codecSettings")
		if err := awsRestjson1_serializeDocumentVideoCodecSettings(v.CodecSettings, ok); err != nil {
			return err
		}
	}

	if v.Height != 0 {
		ok := object.Key("height")
		ok.Integer(v.Height)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.RespondToAfd) > 0 {
		ok := object.Key("respondToAfd")
		ok.String(string(v.RespondToAfd))
	}

	if len(v.ScalingBehavior) > 0 {
		ok := object.Key("scalingBehavior")
		ok.String(string(v.ScalingBehavior))
	}

	if v.Sharpness != 0 {
		ok := object.Key("sharpness")
		ok.Integer(v.Sharpness)
	}

	if v.Width != 0 {
		ok := object.Key("width")
		ok.Integer(v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoSelector(v *types.VideoSelector, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ColorSpace) > 0 {
		ok := object.Key("colorSpace")
		ok.String(string(v.ColorSpace))
	}

	if v.ColorSpaceSettings != nil {
		ok := object.Key("colorSpaceSettings")
		if err := awsRestjson1_serializeDocumentVideoSelectorColorSpaceSettings(v.ColorSpaceSettings, ok); err != nil {
			return err
		}
	}

	if len(v.ColorSpaceUsage) > 0 {
		ok := object.Key("colorSpaceUsage")
		ok.String(string(v.ColorSpaceUsage))
	}

	if v.SelectorSettings != nil {
		ok := object.Key("selectorSettings")
		if err := awsRestjson1_serializeDocumentVideoSelectorSettings(v.SelectorSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoSelectorColorSpaceSettings(v *types.VideoSelectorColorSpaceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Hdr10Settings != nil {
		ok := object.Key("hdr10Settings")
		if err := awsRestjson1_serializeDocumentHdr10Settings(v.Hdr10Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoSelectorPid(v *types.VideoSelectorPid, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Pid != 0 {
		ok := object.Key("pid")
		ok.Integer(v.Pid)
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoSelectorProgramId(v *types.VideoSelectorProgramId, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProgramId != 0 {
		ok := object.Key("programId")
		ok.Integer(v.ProgramId)
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoSelectorSettings(v *types.VideoSelectorSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VideoSelectorPid != nil {
		ok := object.Key("videoSelectorPid")
		if err := awsRestjson1_serializeDocumentVideoSelectorPid(v.VideoSelectorPid, ok); err != nil {
			return err
		}
	}

	if v.VideoSelectorProgramId != nil {
		ok := object.Key("videoSelectorProgramId")
		if err := awsRestjson1_serializeDocumentVideoSelectorProgramId(v.VideoSelectorProgramId, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVpcOutputSettings(v *types.VpcOutputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PublicAddressAllocationIds != nil {
		ok := object.Key("publicAddressAllocationIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.PublicAddressAllocationIds, ok); err != nil {
			return err
		}
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("subnetIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWavSettings(v *types.WavSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BitDepth != 0 {
		ok := object.Key("bitDepth")
		switch {
		case math.IsNaN(v.BitDepth):
			ok.String("NaN")

		case math.IsInf(v.BitDepth, 1):
			ok.String("Infinity")

		case math.IsInf(v.BitDepth, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.BitDepth)

		}
	}

	if len(v.CodingMode) > 0 {
		ok := object.Key("codingMode")
		ok.String(string(v.CodingMode))
	}

	if v.SampleRate != 0 {
		ok := object.Key("sampleRate")
		switch {
		case math.IsNaN(v.SampleRate):
			ok.String("NaN")

		case math.IsInf(v.SampleRate, 1):
			ok.String("Infinity")

		case math.IsInf(v.SampleRate, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.SampleRate)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWebvttDestinationSettings(v *types.WebvttDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.StyleControl) > 0 {
		ok := object.Key("styleControl")
		ok.String(string(v.StyleControl))
	}

	return nil
}
