// Code generated by smithy-go-codegen DO NOT EDIT.

package iotroborunner

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Grants permission to get a worker fleet
func (c *Client) GetWorkerFleet(ctx context.Context, params *GetWorkerFleetInput, optFns ...func(*Options)) (*GetWorkerFleetOutput, error) {
	if params == nil {
		params = &GetWorkerFleetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetWorkerFleet", params, optFns, c.addOperationGetWorkerFleetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetWorkerFleetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetWorkerFleetInput struct {

	// Full ARN of the worker fleet.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

type GetWorkerFleetOutput struct {

	// Full ARN of the worker fleet.
	//
	// This member is required.
	Arn *string

	// Timestamp at which the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// Filters access by the worker fleet's identifier
	//
	// This member is required.
	Id *string

	// Human friendly name of the resource.
	//
	// This member is required.
	Name *string

	// Site ARN.
	//
	// This member is required.
	Site *string

	// Timestamp at which the resource was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// JSON blob containing additional fixed properties regarding the worker fleet
	AdditionalFixedProperties *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetWorkerFleetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetWorkerFleet{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetWorkerFleet{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetWorkerFleetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetWorkerFleet(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetWorkerFleet(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "iotroborunner",
		OperationName: "GetWorkerFleet",
	}
}
