// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains information on the current access control policies for the bucket.
type AccessControlList struct {

	// A value that indicates whether public read access for the bucket is enabled
	// through an Access Control List (ACL).
	AllowsPublicReadAccess bool

	// A value that indicates whether public write access for the bucket is enabled
	// through an Access Control List (ACL).
	AllowsPublicWriteAccess bool

	noSmithyDocumentSerde
}

// Contains information about the access keys.
type AccessKeyDetails struct {

	// The access key ID of the user.
	AccessKeyId *string

	// The principal ID of the user.
	PrincipalId *string

	// The name of the user.
	UserName *string

	// The type of the user.
	UserType *string

	noSmithyDocumentSerde
}

// Contains information about the account.
type AccountDetail struct {

	// The member account ID.
	//
	// This member is required.
	AccountId *string

	// The email address of the member account.
	//
	// This member is required.
	Email *string

	noSmithyDocumentSerde
}

// Provides details of the GuardDuty member account that uses a free trial service.
type AccountFreeTrialInfo struct {

	// The account identifier of the GuardDuty member account.
	AccountId *string

	// Describes the data source enabled for the GuardDuty member account.
	DataSources *DataSourcesFreeTrial

	noSmithyDocumentSerde
}

// Contains information about the account level permissions on the S3 bucket.
type AccountLevelPermissions struct {

	// Describes the S3 Block Public Access settings of the bucket's parent account.
	BlockPublicAccess *BlockPublicAccess

	noSmithyDocumentSerde
}

// Contains information about actions.
type Action struct {

	// The GuardDuty finding activity type.
	ActionType *string

	// Information about the AWS_API_CALL action described in this finding.
	AwsApiCallAction *AwsApiCallAction

	// Information about the DNS_REQUEST action described in this finding.
	DnsRequestAction *DnsRequestAction

	// Information about the Kubernetes API call action described in this finding.
	KubernetesApiCallAction *KubernetesApiCallAction

	// Information about the NETWORK_CONNECTION action described in this finding.
	NetworkConnectionAction *NetworkConnectionAction

	// Information about the PORT_PROBE action described in this finding.
	PortProbeAction *PortProbeAction

	noSmithyDocumentSerde
}

// The account within the organization specified as the GuardDuty delegated
// administrator.
type AdminAccount struct {

	// The Amazon Web Services account ID for the account.
	AdminAccountId *string

	// Indicates whether the account is enabled as the delegated administrator.
	AdminStatus AdminStatus

	noSmithyDocumentSerde
}

// Contains information about the administrator account and invitation.
type Administrator struct {

	// The ID of the account used as the administrator account.
	AccountId *string

	// The value that is used to validate the administrator account to the member
	// account.
	InvitationId *string

	// The timestamp when the invitation was sent.
	InvitedAt *string

	// The status of the relationship between the administrator and member accounts.
	RelationshipStatus *string

	noSmithyDocumentSerde
}

// Contains information about the API action.
type AwsApiCallAction struct {

	// The details of the Amazon Web Services account that made the API call. This
	// field identifies the resources that were affected by this API call.
	AffectedResources map[string]string

	// The Amazon Web Services API name.
	Api *string

	// The Amazon Web Services API caller type.
	CallerType *string

	// The domain information for the Amazon Web Services API call.
	DomainDetails *DomainDetails

	// The error code of the failed Amazon Web Services API action.
	ErrorCode *string

	// The details of the Amazon Web Services account that made the API call. This
	// field appears if the call was made from outside your account.
	RemoteAccountDetails *RemoteAccountDetails

	// The remote IP information of the connection that initiated the Amazon Web
	// Services API call.
	RemoteIpDetails *RemoteIpDetails

	// The Amazon Web Services service name whose API was invoked.
	ServiceName *string

	// The agent through which the API request was made.
	UserAgent *string

	noSmithyDocumentSerde
}

// Contains information on how the bucker owner's S3 Block Public Access settings
// are being applied to the S3 bucket. See S3 Block Public Access
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
// for more information.
type BlockPublicAccess struct {

	// Indicates if S3 Block Public Access is set to BlockPublicAcls.
	BlockPublicAcls bool

	// Indicates if S3 Block Public Access is set to BlockPublicPolicy.
	BlockPublicPolicy bool

	// Indicates if S3 Block Public Access is set to IgnorePublicAcls.
	IgnorePublicAcls bool

	// Indicates if S3 Block Public Access is set to RestrictPublicBuckets.
	RestrictPublicBuckets bool

	noSmithyDocumentSerde
}

// Contains information about the bucket level permissions for the S3 bucket.
type BucketLevelPermissions struct {

	// Contains information on how Access Control Policies are applied to the bucket.
	AccessControlList *AccessControlList

	// Contains information on which account level S3 Block Public Access settings are
	// applied to the S3 bucket.
	BlockPublicAccess *BlockPublicAccess

	// Contains information on the bucket policies for the S3 bucket.
	BucketPolicy *BucketPolicy

	noSmithyDocumentSerde
}

// Contains information on the current bucket policies for the S3 bucket.
type BucketPolicy struct {

	// A value that indicates whether public read access for the bucket is enabled
	// through a bucket policy.
	AllowsPublicReadAccess bool

	// A value that indicates whether public write access for the bucket is enabled
	// through a bucket policy.
	AllowsPublicWriteAccess bool

	noSmithyDocumentSerde
}

// Contains information about the city associated with the IP address.
type City struct {

	// The city name of the remote IP address.
	CityName *string

	noSmithyDocumentSerde
}

// Contains information on the status of CloudTrail as a data source for the
// detector.
type CloudTrailConfigurationResult struct {

	// Describes whether CloudTrail is enabled as a data source for the detector.
	//
	// This member is required.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Contains information about the condition.
type Condition struct {

	// Represents the equal condition to be applied to a single field when querying for
	// findings.
	//
	// Deprecated: This member has been deprecated.
	Eq []string

	// Represents an equal condition to be applied to a single field when querying for
	// findings.
	Equals []string

	// Represents a greater than condition to be applied to a single field when
	// querying for findings.
	GreaterThan int64

	// Represents a greater than or equal condition to be applied to a single field
	// when querying for findings.
	GreaterThanOrEqual int64

	// Represents a greater than condition to be applied to a single field when
	// querying for findings.
	//
	// Deprecated: This member has been deprecated.
	Gt int32

	// Represents a greater than or equal condition to be applied to a single field
	// when querying for findings.
	//
	// Deprecated: This member has been deprecated.
	Gte int32

	// Represents a less than condition to be applied to a single field when querying
	// for findings.
	LessThan int64

	// Represents a less than or equal condition to be applied to a single field when
	// querying for findings.
	LessThanOrEqual int64

	// Represents a less than condition to be applied to a single field when querying
	// for findings.
	//
	// Deprecated: This member has been deprecated.
	Lt int32

	// Represents a less than or equal condition to be applied to a single field when
	// querying for findings.
	//
	// Deprecated: This member has been deprecated.
	Lte int32

	// Represents the not equal condition to be applied to a single field when querying
	// for findings.
	//
	// Deprecated: This member has been deprecated.
	Neq []string

	// Represents a not equal condition to be applied to a single field when querying
	// for findings.
	NotEquals []string

	noSmithyDocumentSerde
}

// Details of a container.
type Container struct {

	// The container runtime (such as, Docker or containerd) used to run the container.
	ContainerRuntime *string

	// Container ID.
	Id *string

	// Container image.
	Image *string

	// Part of the image name before the last slash. For example, imagePrefix for
	// public.ecr.aws/amazonlinux/amazonlinux:latest would be
	// public.ecr.aws/amazonlinux. If the image name is relative and does not have a
	// slash, this field is empty.
	ImagePrefix *string

	// Container name.
	Name *string

	// Container security context.
	SecurityContext *SecurityContext

	// Container volume mounts.
	VolumeMounts []VolumeMount

	noSmithyDocumentSerde
}

// Contains information about the country where the remote IP address is located.
type Country struct {

	// The country code of the remote IP address.
	CountryCode *string

	// The country name of the remote IP address.
	CountryName *string

	noSmithyDocumentSerde
}

// Contains information about which data sources are enabled.
type DataSourceConfigurations struct {

	// Describes whether any Kubernetes logs are enabled as data sources.
	Kubernetes *KubernetesConfiguration

	// Describes whether Malware Protection is enabled as a data source.
	MalwareProtection *MalwareProtectionConfiguration

	// Describes whether S3 data event logs are enabled as a data source.
	S3Logs *S3LogsConfiguration

	noSmithyDocumentSerde
}

// Contains information on the status of data sources for the detector.
type DataSourceConfigurationsResult struct {

	// An object that contains information on the status of CloudTrail as a data
	// source.
	//
	// This member is required.
	CloudTrail *CloudTrailConfigurationResult

	// An object that contains information on the status of DNS logs as a data source.
	//
	// This member is required.
	DNSLogs *DNSLogsConfigurationResult

	// An object that contains information on the status of VPC flow logs as a data
	// source.
	//
	// This member is required.
	FlowLogs *FlowLogsConfigurationResult

	// An object that contains information on the status of S3 Data event logs as a
	// data source.
	//
	// This member is required.
	S3Logs *S3LogsConfigurationResult

	// An object that contains information on the status of all Kubernetes data
	// sources.
	Kubernetes *KubernetesConfigurationResult

	// Describes the configuration of Malware Protection data sources.
	MalwareProtection *MalwareProtectionConfigurationResult

	noSmithyDocumentSerde
}

// Contains information about which data sources are enabled for the GuardDuty
// member account.
type DataSourceFreeTrial struct {

	// A value that specifies the number of days left to use each enabled data source.
	FreeTrialDaysRemaining int32

	noSmithyDocumentSerde
}

// Contains information about which data sources are enabled for the GuardDuty
// member account.
type DataSourcesFreeTrial struct {

	// Describes whether any Amazon Web Services CloudTrail management event logs are
	// enabled as data sources.
	CloudTrail *DataSourceFreeTrial

	// Describes whether any DNS logs are enabled as data sources.
	DnsLogs *DataSourceFreeTrial

	// Describes whether any VPC Flow logs are enabled as data sources.
	FlowLogs *DataSourceFreeTrial

	// Describes whether any Kubernetes logs are enabled as data sources.
	Kubernetes *KubernetesDataSourceFreeTrial

	// Describes whether Malware Protection is enabled as a data source.
	MalwareProtection *MalwareProtectionDataSourceFreeTrial

	// Describes whether any S3 data event logs are enabled as data sources.
	S3Logs *DataSourceFreeTrial

	noSmithyDocumentSerde
}

// Contains information on the server side encryption method used in the S3 bucket.
// See S3 Server-Side Encryption
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html) for
// more information.
type DefaultServerSideEncryption struct {

	// The type of encryption used for objects within the S3 bucket.
	EncryptionType *string

	// The Amazon Resource Name (ARN) of the KMS encryption key. Only available if the
	// bucket EncryptionType is aws:kms.
	KmsMasterKeyArn *string

	noSmithyDocumentSerde
}

// Contains information about the publishing destination, including the ID, type,
// and status.
type Destination struct {

	// The unique ID of the publishing destination.
	//
	// This member is required.
	DestinationId *string

	// The type of resource used for the publishing destination. Currently, only Amazon
	// S3 buckets are supported.
	//
	// This member is required.
	DestinationType DestinationType

	// The status of the publishing destination.
	//
	// This member is required.
	Status PublishingStatus

	noSmithyDocumentSerde
}

// Contains the Amazon Resource Name (ARN) of the resource to publish to, such as
// an S3 bucket, and the ARN of the KMS key to use to encrypt published findings.
type DestinationProperties struct {

	// The ARN of the resource to publish to. To specify an S3 bucket folder use the
	// following format: arn:aws:s3:::DOC-EXAMPLE-BUCKET/myFolder/
	DestinationArn *string

	// The ARN of the KMS key to use for encryption.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Contains information on the status of DNS logs as a data source.
type DNSLogsConfigurationResult struct {

	// Denotes whether DNS logs is enabled as a data source.
	//
	// This member is required.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Contains information about the DNS_REQUEST action described in this finding.
type DnsRequestAction struct {

	// Indicates whether the targeted port is blocked.
	Blocked bool

	// The domain information for the API request.
	Domain *string

	// The network connection protocol observed in the activity that prompted GuardDuty
	// to generate the finding.
	Protocol *string

	noSmithyDocumentSerde
}

// Contains information about the domain.
type DomainDetails struct {

	// The domain information for the Amazon Web Services API call.
	Domain *string

	noSmithyDocumentSerde
}

// Contains list of scanned and skipped EBS volumes with details.
type EbsVolumeDetails struct {

	// List of EBS volumes that were scanned.
	ScannedVolumeDetails []VolumeDetail

	// List of EBS volumes that were skipped from the malware scan.
	SkippedVolumeDetails []VolumeDetail

	noSmithyDocumentSerde
}

// Contains details from the malware scan that created a finding.
type EbsVolumeScanDetails struct {

	// Returns the completion date and time of the malware scan.
	ScanCompletedAt *time.Time

	// Contains a complete view providing malware scan result details.
	ScanDetections *ScanDetections

	// Unique Id of the malware scan that generated the finding.
	ScanId *string

	// Returns the start date and time of the malware scan.
	ScanStartedAt *time.Time

	// Contains list of threat intelligence sources used to detect threats.
	Sources []string

	// GuardDuty finding ID that triggered a malware scan.
	TriggerFindingId *string

	noSmithyDocumentSerde
}

// Describes the configuration of scanning EBS volumes as a data source.
type EbsVolumesResult struct {

	// Specifies the reason why scanning EBS volumes (Malware Protection) was not
	// enabled as a data source.
	Reason *string

	// Describes whether scanning EBS volumes is enabled as a data source.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Contains information about the details of the ECS Cluster.
type EcsClusterDetails struct {

	// The number of services that are running on the cluster in an ACTIVE state.
	ActiveServicesCount int32

	// The Amazon Resource Name (ARN) that identifies the cluster.
	Arn *string

	// The name of the ECS Cluster.
	Name *string

	// The number of container instances registered into the cluster.
	RegisteredContainerInstancesCount int32

	// The number of tasks in the cluster that are in the RUNNING state.
	RunningTasksCount int32

	// The status of the ECS cluster.
	Status *string

	// The tags of the ECS Cluster.
	Tags []Tag

	// Contains information about the details of the ECS Task.
	TaskDetails *EcsTaskDetails

	noSmithyDocumentSerde
}

// Contains information about the task in an ECS cluster.
type EcsTaskDetails struct {

	// The Amazon Resource Name (ARN) of the task.
	Arn *string

	// The containers that's associated with the task.
	Containers []Container

	// The ARN of the task definition that creates the task.
	DefinitionArn *string

	// The name of the task group that's associated with the task.
	Group *string

	// The Unix timestamp for the time when the task started.
	StartedAt *time.Time

	// Contains the tag specified when a task is started.
	StartedBy *string

	// The tags of the ECS Task.
	Tags []Tag

	// The Unix timestamp for the time when the task was created.
	TaskCreatedAt *time.Time

	// The version counter for the task.
	Version *string

	// The list of data volume definitions for the task.
	Volumes []Volume

	noSmithyDocumentSerde
}

// Details about the EKS cluster involved in a Kubernetes finding.
type EksClusterDetails struct {

	// EKS cluster ARN.
	Arn *string

	// The timestamp when the EKS cluster was created.
	CreatedAt *time.Time

	// EKS cluster name.
	Name *string

	// The EKS cluster status.
	Status *string

	// The EKS cluster tags.
	Tags []Tag

	// The VPC ID to which the EKS cluster is attached.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains information about the reason that the finding was generated.
type Evidence struct {

	// A list of threat intelligence details related to the evidence.
	ThreatIntelligenceDetails []ThreatIntelligenceDetail

	noSmithyDocumentSerde
}

// Contains information about the condition.
type FilterCondition struct {

	// Represents an equal condition to be applied to a single field when querying for
	// scan entries.
	EqualsValue *string

	// Represents a greater than condition to be applied to a single field when
	// querying for scan entries.
	GreaterThan int64

	// Represents a less than condition to be applied to a single field when querying
	// for scan entries.
	LessThan int64

	noSmithyDocumentSerde
}

// Represents the criteria to be used in the filter for describing scan entries.
type FilterCriteria struct {

	// Represents a condition that when matched will be added to the response of the
	// operation.
	FilterCriterion []FilterCriterion

	noSmithyDocumentSerde
}

// Represents a condition that when matched will be added to the response of the
// operation. Irrespective of using any filter criteria, an administrator account
// can view the scan entries for all of its member accounts. However, each member
// account can view the scan entries only for their own account.
type FilterCriterion struct {

	// An enum value representing possible scan properties to match with given scan
	// entries.
	CriterionKey CriterionKey

	// Contains information about the condition.
	FilterCondition *FilterCondition

	noSmithyDocumentSerde
}

// Contains information about the finding, which is generated when abnormal or
// suspicious activity is detected.
type Finding struct {

	// The ID of the account in which the finding was generated.
	//
	// This member is required.
	AccountId *string

	// The ARN of the finding.
	//
	// This member is required.
	Arn *string

	// The time and date when the finding was created.
	//
	// This member is required.
	CreatedAt *string

	// The ID of the finding.
	//
	// This member is required.
	Id *string

	// The Region where the finding was generated.
	//
	// This member is required.
	Region *string

	// Contains information about the Amazon Web Services resource associated with the
	// activity that prompted GuardDuty to generate a finding.
	//
	// This member is required.
	Resource *Resource

	// The version of the schema used for the finding.
	//
	// This member is required.
	SchemaVersion *string

	// The severity of the finding.
	//
	// This member is required.
	Severity float64

	// The type of finding.
	//
	// This member is required.
	Type *string

	// The time and date when the finding was last updated.
	//
	// This member is required.
	UpdatedAt *string

	// The confidence score for the finding.
	Confidence float64

	// The description of the finding.
	Description *string

	// The partition associated with the finding.
	Partition *string

	// Contains additional information about the generated finding.
	Service *Service

	// The title of the finding.
	Title *string

	noSmithyDocumentSerde
}

// Contains information about the criteria used for querying findings.
type FindingCriteria struct {

	// Represents a map of finding properties that match specified conditions and
	// values when querying findings.
	Criterion map[string]Condition

	noSmithyDocumentSerde
}

// Contains information about finding statistics.
type FindingStatistics struct {

	// Represents a map of severity to count statistics for a set of findings.
	CountBySeverity map[string]int32

	noSmithyDocumentSerde
}

// Contains information on the status of VPC flow logs as a data source.
type FlowLogsConfigurationResult struct {

	// Denotes whether VPC flow logs is enabled as a data source.
	//
	// This member is required.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Contains information about the location of the remote IP address.
type GeoLocation struct {

	// The latitude information of the remote IP address.
	Lat float64

	// The longitude information of the remote IP address.
	Lon float64

	noSmithyDocumentSerde
}

// Contains details of the highest severity threat detected during scan and number
// of infected files.
type HighestSeverityThreatDetails struct {

	// Total number of infected files with the highest severity threat detected.
	Count int32

	// Severity level of the highest severity threat detected.
	Severity *string

	// Threat name of the highest severity threat detected as part of the malware scan.
	ThreatName *string

	noSmithyDocumentSerde
}

// Represents a pre-existing file or directory on the host machine that the volume
// maps to.
type HostPath struct {

	// Path of the file or directory on the host that the volume maps to.
	Path *string

	noSmithyDocumentSerde
}

// Contains information about the EC2 instance profile.
type IamInstanceProfile struct {

	// The profile ARN of the EC2 instance.
	Arn *string

	// The profile ID of the EC2 instance.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about the details of an instance.
type InstanceDetails struct {

	// The Availability Zone of the EC2 instance.
	AvailabilityZone *string

	// The profile information of the EC2 instance.
	IamInstanceProfile *IamInstanceProfile

	// The image description of the EC2 instance.
	ImageDescription *string

	// The image ID of the EC2 instance.
	ImageId *string

	// The ID of the EC2 instance.
	InstanceId *string

	// The state of the EC2 instance.
	InstanceState *string

	// The type of the EC2 instance.
	InstanceType *string

	// The launch time of the EC2 instance.
	LaunchTime *string

	// The elastic network interface information of the EC2 instance.
	NetworkInterfaces []NetworkInterface

	// The Amazon Resource Name (ARN) of the Amazon Web Services Outpost. Only
	// applicable to Amazon Web Services Outposts instances.
	OutpostArn *string

	// The platform of the EC2 instance.
	Platform *string

	// The product code of the EC2 instance.
	ProductCodes []ProductCode

	// The tags of the EC2 instance.
	Tags []Tag

	noSmithyDocumentSerde
}

// Contains information about the invitation to become a member account.
type Invitation struct {

	// The ID of the account that the invitation was sent from.
	AccountId *string

	// The ID of the invitation. This value is used to validate the inviter account to
	// the member account.
	InvitationId *string

	// The timestamp when the invitation was sent.
	InvitedAt *string

	// The status of the relationship between the inviter and invitee accounts.
	RelationshipStatus *string

	noSmithyDocumentSerde
}

// Information about the Kubernetes API call action described in this finding.
type KubernetesApiCallAction struct {

	// Parameters related to the Kubernetes API call action.
	Parameters *string

	// Contains information about the remote IP address of the connection.
	RemoteIpDetails *RemoteIpDetails

	// The Kubernetes API request URI.
	RequestUri *string

	// The IP of the Kubernetes API caller and the IPs of any proxies or load balancers
	// between the caller and the API endpoint.
	SourceIps []string

	// The resulting HTTP response code of the Kubernetes API call action.
	StatusCode int32

	// The user agent of the caller of the Kubernetes API.
	UserAgent *string

	// The Kubernetes API request HTTP verb.
	Verb *string

	noSmithyDocumentSerde
}

// Describes whether Kubernetes audit logs are enabled as a data source.
type KubernetesAuditLogsConfiguration struct {

	// The status of Kubernetes audit logs as a data source.
	//
	// This member is required.
	Enable bool

	noSmithyDocumentSerde
}

// Describes whether Kubernetes audit logs are enabled as a data source.
type KubernetesAuditLogsConfigurationResult struct {

	// A value that describes whether Kubernetes audit logs are enabled as a data
	// source.
	//
	// This member is required.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Describes whether any Kubernetes data sources are enabled.
type KubernetesConfiguration struct {

	// The status of Kubernetes audit logs as a data source.
	//
	// This member is required.
	AuditLogs *KubernetesAuditLogsConfiguration

	noSmithyDocumentSerde
}

// Describes whether any Kubernetes logs will be enabled as a data source.
type KubernetesConfigurationResult struct {

	// Describes whether Kubernetes audit logs are enabled as a data source.
	//
	// This member is required.
	AuditLogs *KubernetesAuditLogsConfigurationResult

	noSmithyDocumentSerde
}

// Provides details about the Kubernetes resources when it is enabled as a data
// source.
type KubernetesDataSourceFreeTrial struct {

	// Describes whether Kubernetes audit logs are enabled as a data source.
	AuditLogs *DataSourceFreeTrial

	noSmithyDocumentSerde
}

// Details about Kubernetes resources such as a Kubernetes user or workload
// resource involved in a Kubernetes finding.
type KubernetesDetails struct {

	// Details about the Kubernetes user involved in a Kubernetes finding.
	KubernetesUserDetails *KubernetesUserDetails

	// Details about the Kubernetes workload involved in a Kubernetes finding.
	KubernetesWorkloadDetails *KubernetesWorkloadDetails

	noSmithyDocumentSerde
}

// Details about the Kubernetes user involved in a Kubernetes finding.
type KubernetesUserDetails struct {

	// The groups that include the user who called the Kubernetes API.
	Groups []string

	// The user ID of the user who called the Kubernetes API.
	Uid *string

	// The username of the user who called the Kubernetes API.
	Username *string

	noSmithyDocumentSerde
}

// Details about the Kubernetes workload involved in a Kubernetes finding.
type KubernetesWorkloadDetails struct {

	// Containers running as part of the Kubernetes workload.
	Containers []Container

	// Whether the hostNetwork flag is enabled for the pods included in the workload.
	HostNetwork bool

	// Kubernetes workload name.
	Name *string

	// Kubernetes namespace that the workload is part of.
	Namespace *string

	// Kubernetes workload type (e.g. Pod, Deployment, etc.).
	Type *string

	// Kubernetes workload ID.
	Uid *string

	// Volumes used by the Kubernetes workload.
	Volumes []Volume

	noSmithyDocumentSerde
}

// Contains information about the local IP address of the connection.
type LocalIpDetails struct {

	// The IPv4 local address of the connection.
	IpAddressV4 *string

	noSmithyDocumentSerde
}

// Contains information about the port for the local connection.
type LocalPortDetails struct {

	// The port number of the local connection.
	Port int32

	// The port name of the local connection.
	PortName *string

	noSmithyDocumentSerde
}

// Describes whether Malware Protection will be enabled as a data source.
type MalwareProtectionConfiguration struct {

	// Describes the configuration of Malware Protection for EC2 instances with
	// findings.
	ScanEc2InstanceWithFindings *ScanEc2InstanceWithFindings

	noSmithyDocumentSerde
}

// An object that contains information on the status of all Malware Protection data
// sources.
type MalwareProtectionConfigurationResult struct {

	// Describes the configuration of Malware Protection for EC2 instances with
	// findings.
	ScanEc2InstanceWithFindings *ScanEc2InstanceWithFindingsResult

	// The GuardDuty Malware Protection service role.
	ServiceRole *string

	noSmithyDocumentSerde
}

// Provides details about Malware Protection when it is enabled as a data source.
type MalwareProtectionDataSourceFreeTrial struct {

	// Describes whether Malware Protection for EC2 instances with findings is enabled
	// as a data source.
	ScanEc2InstanceWithFindings *DataSourceFreeTrial

	noSmithyDocumentSerde
}

// Contains information about the administrator account and invitation.
type Master struct {

	// The ID of the account used as the administrator account.
	AccountId *string

	// The value used to validate the administrator account to the member account.
	InvitationId *string

	// The timestamp when the invitation was sent.
	InvitedAt *string

	// The status of the relationship between the administrator and member accounts.
	RelationshipStatus *string

	noSmithyDocumentSerde
}

// Contains information about the member account.
type Member struct {

	// The ID of the member account.
	//
	// This member is required.
	AccountId *string

	// The email address of the member account.
	//
	// This member is required.
	Email *string

	// The administrator account ID.
	//
	// This member is required.
	MasterId *string

	// The status of the relationship between the member and the administrator.
	//
	// This member is required.
	RelationshipStatus *string

	// The last-updated timestamp of the member.
	//
	// This member is required.
	UpdatedAt *string

	// The administrator account ID.
	AdministratorId *string

	// The detector ID of the member account.
	DetectorId *string

	// The timestamp when the invitation was sent.
	InvitedAt *string

	noSmithyDocumentSerde
}

// Contains information on which data sources are enabled for a member account.
type MemberDataSourceConfiguration struct {

	// The account ID for the member account.
	//
	// This member is required.
	AccountId *string

	// Contains information on the status of data sources for the account.
	//
	// This member is required.
	DataSources *DataSourceConfigurationsResult

	noSmithyDocumentSerde
}

// Contains information about the NETWORK_CONNECTION action described in the
// finding.
type NetworkConnectionAction struct {

	// Indicates whether EC2 blocked the network connection to your instance.
	Blocked bool

	// The network connection direction.
	ConnectionDirection *string

	// The local IP information of the connection.
	LocalIpDetails *LocalIpDetails

	// The local port information of the connection.
	LocalPortDetails *LocalPortDetails

	// The network connection protocol.
	Protocol *string

	// The remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails

	// The remote port information of the connection.
	RemotePortDetails *RemotePortDetails

	noSmithyDocumentSerde
}

// Contains information about the elastic network interface of the EC2 instance.
type NetworkInterface struct {

	// A list of IPv6 addresses for the EC2 instance.
	Ipv6Addresses []string

	// The ID of the network interface.
	NetworkInterfaceId *string

	// The private DNS name of the EC2 instance.
	PrivateDnsName *string

	// The private IP address of the EC2 instance.
	PrivateIpAddress *string

	// Other private IP address information of the EC2 instance.
	PrivateIpAddresses []PrivateIpAddressDetails

	// The public DNS name of the EC2 instance.
	PublicDnsName *string

	// The public IP address of the EC2 instance.
	PublicIp *string

	// The security groups associated with the EC2 instance.
	SecurityGroups []SecurityGroup

	// The subnet ID of the EC2 instance.
	SubnetId *string

	// The VPC ID of the EC2 instance.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains information about the ISP organization of the remote IP address.
type Organization struct {

	// The Autonomous System Number (ASN) of the internet provider of the remote IP
	// address.
	Asn *string

	// The organization that registered this ASN.
	AsnOrg *string

	// The ISP information for the internet provider.
	Isp *string

	// The name of the internet provider.
	Org *string

	noSmithyDocumentSerde
}

// An object that contains information on which data sources will be configured to
// be automatically enabled for new members within the organization.
type OrganizationDataSourceConfigurations struct {

	// Describes the configuration of Kubernetes data sources for new members of the
	// organization.
	Kubernetes *OrganizationKubernetesConfiguration

	// Describes the configuration of Malware Protection for new members of the
	// organization.
	MalwareProtection *OrganizationMalwareProtectionConfiguration

	// Describes whether S3 data event logs are enabled for new members of the
	// organization.
	S3Logs *OrganizationS3LogsConfiguration

	noSmithyDocumentSerde
}

// An object that contains information on which data sources are automatically
// enabled for new members within the organization.
type OrganizationDataSourceConfigurationsResult struct {

	// Describes whether S3 data event logs are enabled as a data source.
	//
	// This member is required.
	S3Logs *OrganizationS3LogsConfigurationResult

	// Describes the configuration of Kubernetes data sources.
	Kubernetes *OrganizationKubernetesConfigurationResult

	// Describes the configuration of Malware Protection data source for an
	// organization.
	MalwareProtection *OrganizationMalwareProtectionConfigurationResult

	noSmithyDocumentSerde
}

// Organization-wide EBS volumes scan configuration.
type OrganizationEbsVolumes struct {

	// Whether scanning EBS volumes should be auto-enabled for new members joining the
	// organization.
	AutoEnable bool

	noSmithyDocumentSerde
}

// An object that contains information on the status of whether EBS volumes
// scanning will be enabled as a data source for an organization.
type OrganizationEbsVolumesResult struct {

	// An object that contains the status of whether scanning EBS volumes should be
	// auto-enabled for new members joining the organization.
	AutoEnable bool

	noSmithyDocumentSerde
}

// Organization-wide Kubernetes audit logs configuration.
type OrganizationKubernetesAuditLogsConfiguration struct {

	// A value that contains information on whether Kubernetes audit logs should be
	// enabled automatically as a data source for the organization.
	//
	// This member is required.
	AutoEnable bool

	noSmithyDocumentSerde
}

// The current configuration of Kubernetes audit logs as a data source for the
// organization.
type OrganizationKubernetesAuditLogsConfigurationResult struct {

	// Whether Kubernetes audit logs data source should be auto-enabled for new members
	// joining the organization.
	//
	// This member is required.
	AutoEnable bool

	noSmithyDocumentSerde
}

// Organization-wide Kubernetes data sources configurations.
type OrganizationKubernetesConfiguration struct {

	// Whether Kubernetes audit logs data source should be auto-enabled for new members
	// joining the organization.
	//
	// This member is required.
	AuditLogs *OrganizationKubernetesAuditLogsConfiguration

	noSmithyDocumentSerde
}

// The current configuration of all Kubernetes data sources for the organization.
type OrganizationKubernetesConfigurationResult struct {

	// The current configuration of Kubernetes audit logs as a data source for the
	// organization.
	//
	// This member is required.
	AuditLogs *OrganizationKubernetesAuditLogsConfigurationResult

	noSmithyDocumentSerde
}

// Organization-wide Malware Protection configurations.
type OrganizationMalwareProtectionConfiguration struct {

	// Whether Malware Protection for EC2 instances with findings should be
	// auto-enabled for new members joining the organization.
	ScanEc2InstanceWithFindings *OrganizationScanEc2InstanceWithFindings

	noSmithyDocumentSerde
}

// An object that contains information on the status of all Malware Protection data
// source for an organization.
type OrganizationMalwareProtectionConfigurationResult struct {

	// Describes the configuration for scanning EC2 instances with findings for an
	// organization.
	ScanEc2InstanceWithFindings *OrganizationScanEc2InstanceWithFindingsResult

	noSmithyDocumentSerde
}

// Describes whether S3 data event logs will be automatically enabled for new
// members of the organization.
type OrganizationS3LogsConfiguration struct {

	// A value that contains information on whether S3 data event logs will be enabled
	// automatically as a data source for the organization.
	//
	// This member is required.
	AutoEnable bool

	noSmithyDocumentSerde
}

// The current configuration of S3 data event logs as a data source for the
// organization.
type OrganizationS3LogsConfigurationResult struct {

	// A value that describes whether S3 data event logs are automatically enabled for
	// new members of the organization.
	//
	// This member is required.
	AutoEnable bool

	noSmithyDocumentSerde
}

// Organization-wide EC2 instances with findings scan configuration.
type OrganizationScanEc2InstanceWithFindings struct {

	// Whether scanning EBS volumes should be auto-enabled for new members joining the
	// organization.
	EbsVolumes *OrganizationEbsVolumes

	noSmithyDocumentSerde
}

// An object that contains information on the status of scanning EC2 instances with
// findings for an organization.
type OrganizationScanEc2InstanceWithFindingsResult struct {

	// Describes the configuration for scanning EBS volumes for an organization.
	EbsVolumes *OrganizationEbsVolumesResult

	noSmithyDocumentSerde
}

// Contains information on the owner of the bucket.
type Owner struct {

	// The canonical user ID of the bucket owner. For information about locating your
	// canonical user ID see Finding Your Account Canonical User ID.
	// (https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId)
	Id *string

	noSmithyDocumentSerde
}

// Contains information about how permissions are configured for the S3 bucket.
type PermissionConfiguration struct {

	// Contains information about the account level permissions on the S3 bucket.
	AccountLevelPermissions *AccountLevelPermissions

	// Contains information about the bucket level permissions for the S3 bucket.
	BucketLevelPermissions *BucketLevelPermissions

	noSmithyDocumentSerde
}

// Contains information about the PORT_PROBE action described in the finding.
type PortProbeAction struct {

	// Indicates whether EC2 blocked the port probe to the instance, such as with an
	// ACL.
	Blocked bool

	// A list of objects related to port probe details.
	PortProbeDetails []PortProbeDetail

	noSmithyDocumentSerde
}

// Contains information about the port probe details.
type PortProbeDetail struct {

	// The local IP information of the connection.
	LocalIpDetails *LocalIpDetails

	// The local port information of the connection.
	LocalPortDetails *LocalPortDetails

	// The remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails

	noSmithyDocumentSerde
}

// Contains other private IP address information of the EC2 instance.
type PrivateIpAddressDetails struct {

	// The private DNS name of the EC2 instance.
	PrivateDnsName *string

	// The private IP address of the EC2 instance.
	PrivateIpAddress *string

	noSmithyDocumentSerde
}

// Contains information about the product code for the EC2 instance.
type ProductCode struct {

	// The product code information.
	Code *string

	// The product code type.
	ProductType *string

	noSmithyDocumentSerde
}

// Describes the public access policies that apply to the S3 bucket.
type PublicAccess struct {

	// Describes the effective permission on this bucket after factoring all attached
	// policies.
	EffectivePermission *string

	// Contains information about how permissions are configured for the S3 bucket.
	PermissionConfiguration *PermissionConfiguration

	noSmithyDocumentSerde
}

// Contains details about the remote Amazon Web Services account that made the API
// call.
type RemoteAccountDetails struct {

	// The Amazon Web Services account ID of the remote API caller.
	AccountId *string

	// Details on whether the Amazon Web Services account of the remote API caller is
	// related to your GuardDuty environment. If this value is True the API caller is
	// affiliated to your account in some way. If it is False the API caller is from
	// outside your environment.
	Affiliated bool

	noSmithyDocumentSerde
}

// Contains information about the remote IP address of the connection.
type RemoteIpDetails struct {

	// The city information of the remote IP address.
	City *City

	// The country code of the remote IP address.
	Country *Country

	// The location information of the remote IP address.
	GeoLocation *GeoLocation

	// The IPv4 remote address of the connection.
	IpAddressV4 *string

	// The ISP organization information of the remote IP address.
	Organization *Organization

	noSmithyDocumentSerde
}

// Contains information about the remote port.
type RemotePortDetails struct {

	// The port number of the remote connection.
	Port int32

	// The port name of the remote connection.
	PortName *string

	noSmithyDocumentSerde
}

// Contains information about the Amazon Web Services resource associated with the
// activity that prompted GuardDuty to generate a finding.
type Resource struct {

	// The IAM access key details (IAM user information) of a user that engaged in the
	// activity that prompted GuardDuty to generate a finding.
	AccessKeyDetails *AccessKeyDetails

	// Details of a container.
	ContainerDetails *Container

	// Contains list of scanned and skipped EBS volumes with details.
	EbsVolumeDetails *EbsVolumeDetails

	// Contains information about the details of the ECS Cluster.
	EcsClusterDetails *EcsClusterDetails

	// Details about the EKS cluster involved in a Kubernetes finding.
	EksClusterDetails *EksClusterDetails

	// The information about the EC2 instance associated with the activity that
	// prompted GuardDuty to generate a finding.
	InstanceDetails *InstanceDetails

	// Details about the Kubernetes user and workload involved in a Kubernetes finding.
	KubernetesDetails *KubernetesDetails

	// The type of Amazon Web Services resource.
	ResourceType *string

	// Contains information on the S3 bucket.
	S3BucketDetails []S3BucketDetail

	noSmithyDocumentSerde
}

// Represents the resources that were scanned in the scan entry.
type ResourceDetails struct {

	// InstanceArn that was scanned in the scan entry.
	InstanceArn *string

	noSmithyDocumentSerde
}

// Contains information on the S3 bucket.
type S3BucketDetail struct {

	// The Amazon Resource Name (ARN) of the S3 bucket.
	Arn *string

	// The date and time the bucket was created at.
	CreatedAt *time.Time

	// Describes the server side encryption method used in the S3 bucket.
	DefaultServerSideEncryption *DefaultServerSideEncryption

	// The name of the S3 bucket.
	Name *string

	// The owner of the S3 bucket.
	Owner *Owner

	// Describes the public access policies that apply to the S3 bucket.
	PublicAccess *PublicAccess

	// All tags attached to the S3 bucket
	Tags []Tag

	// Describes whether the bucket is a source or destination bucket.
	Type *string

	noSmithyDocumentSerde
}

// Describes whether S3 data event logs will be enabled as a data source.
type S3LogsConfiguration struct {

	// The status of S3 data event logs as a data source.
	//
	// This member is required.
	Enable bool

	noSmithyDocumentSerde
}

// Describes whether S3 data event logs will be enabled as a data source.
type S3LogsConfigurationResult struct {

	// A value that describes whether S3 data event logs are automatically enabled for
	// new members of the organization.
	//
	// This member is required.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Contains information about a malware scan.
type Scan struct {

	// The ID for the account that belongs to the scan.
	AccountId *string

	// The unique detector ID of the administrator account that the request is
	// associated with. Note that this value will be the same as the one used for
	// DetectorId if the account is an administrator.
	AdminDetectorId *string

	// List of volumes that were attached to the original instance to be scanned.
	AttachedVolumes []VolumeDetail

	// The unique ID of the detector that the request is associated with.
	DetectorId *string

	// Represents the reason for FAILED scan status.
	FailureReason *string

	// Represents the number of files that were scanned.
	FileCount int64

	// Represents the resources that were scanned in the scan entry.
	ResourceDetails *ResourceDetails

	// The timestamp of when the scan was finished.
	ScanEndTime *time.Time

	// The unique scan ID associated with a scan entry.
	ScanId *string

	// Represents the result of the scan.
	ScanResultDetails *ScanResultDetails

	// The timestamp of when the scan was triggered.
	ScanStartTime *time.Time

	// An enum value representing possible scan statuses.
	ScanStatus ScanStatus

	// Represents total bytes that were scanned.
	TotalBytes int64

	// Specifies the reason why the scan was initiated.
	TriggerDetails *TriggerDetails

	noSmithyDocumentSerde
}

// Contains information about the condition.
type ScanCondition struct {

	// Represents an mapEqual condition to be applied to a single field when triggering
	// for malware scan.
	//
	// This member is required.
	MapEquals []ScanConditionPair

	noSmithyDocumentSerde
}

// Represents key, value pair to be matched against given resource property.
type ScanConditionPair struct {

	// Represents key in the map condition.
	//
	// This member is required.
	Key *string

	// Represents optional value in the map condition. If not specified, only key will
	// be matched.
	Value *string

	noSmithyDocumentSerde
}

// Contains a complete view providing malware scan result details.
type ScanDetections struct {

	// Details of the highest severity threat detected during malware scan and number
	// of infected files.
	HighestSeverityThreatDetails *HighestSeverityThreatDetails

	// Total number of scanned files.
	ScannedItemCount *ScannedItemCount

	// Contains details about identified threats organized by threat name.
	ThreatDetectedByName *ThreatDetectedByName

	// Total number of infected files.
	ThreatsDetectedItemCount *ThreatsDetectedItemCount

	noSmithyDocumentSerde
}

// Describes whether Malware Protection for EC2 instances with findings will be
// enabled as a data source.
type ScanEc2InstanceWithFindings struct {

	// Describes the configuration for scanning EBS volumes as data source.
	EbsVolumes bool

	noSmithyDocumentSerde
}

// An object that contains information on the status of whether Malware Protection
// for EC2 instances with findings will be enabled as a data source.
type ScanEc2InstanceWithFindingsResult struct {

	// Describes the configuration of scanning EBS volumes as a data source.
	EbsVolumes *EbsVolumesResult

	noSmithyDocumentSerde
}

// Contains details of infected file including name, file path and hash.
type ScanFilePath struct {

	// File name of the infected file.
	FileName *string

	// The file path of the infected file.
	FilePath *string

	// The hash value of the infected file.
	Hash *string

	// EBS volume Arn details of the infected file.
	VolumeArn *string

	noSmithyDocumentSerde
}

// Total number of scanned files.
type ScannedItemCount struct {

	// Number of files scanned.
	Files int32

	// Total GB of files scanned for malware.
	TotalGb int32

	// Total number of scanned volumes.
	Volumes int32

	noSmithyDocumentSerde
}

// Contains information about criteria used to filter resources before triggering
// malware scan.
type ScanResourceCriteria struct {

	// Represents condition that when matched will prevent a malware scan for a certain
	// resource.
	Exclude map[string]ScanCondition

	// Represents condition that when matched will allow a malware scan for a certain
	// resource.
	Include map[string]ScanCondition

	noSmithyDocumentSerde
}

// Represents the result of the scan.
type ScanResultDetails struct {

	// An enum value representing possible scan results.
	ScanResult ScanResult

	noSmithyDocumentSerde
}

// Contains files infected with the given threat providing details of malware name
// and severity.
type ScanThreatName struct {

	// List of infected files in EBS volume with details.
	FilePaths []ScanFilePath

	// Total number of files infected with given threat.
	ItemCount int32

	// The name of the identified threat.
	Name *string

	// Severity of threat identified as part of the malware scan.
	Severity *string

	noSmithyDocumentSerde
}

// Container security context.
type SecurityContext struct {

	// Whether the container is privileged.
	Privileged bool

	noSmithyDocumentSerde
}

// Contains information about the security groups associated with the EC2 instance.
type SecurityGroup struct {

	// The security group ID of the EC2 instance.
	GroupId *string

	// The security group name of the EC2 instance.
	GroupName *string

	noSmithyDocumentSerde
}

// Contains additional information about the generated finding.
type Service struct {

	// Information about the activity that is described in a finding.
	Action *Action

	// Contains additional information about the generated finding.
	AdditionalInfo *ServiceAdditionalInfo

	// Indicates whether this finding is archived.
	Archived bool

	// The total count of the occurrences of this finding type.
	Count int32

	// The detector ID for the GuardDuty service.
	DetectorId *string

	// Returns details from the malware scan that created a finding.
	EbsVolumeScanDetails *EbsVolumeScanDetails

	// The first-seen timestamp of the activity that prompted GuardDuty to generate
	// this finding.
	EventFirstSeen *string

	// The last-seen timestamp of the activity that prompted GuardDuty to generate this
	// finding.
	EventLastSeen *string

	// An evidence object associated with the service.
	Evidence *Evidence

	// The name of the feature that generated a finding.
	FeatureName *string

	// The resource role information for this finding.
	ResourceRole *string

	// The name of the Amazon Web Services service (GuardDuty) that generated a
	// finding.
	ServiceName *string

	// Feedback that was submitted about the finding.
	UserFeedback *string

	noSmithyDocumentSerde
}

// Additional information about the generated finding.
type ServiceAdditionalInfo struct {

	// Describes the type of the additional information.
	Type *string

	// This field specifies the value of the additional information.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about the criteria used for sorting findings.
type SortCriteria struct {

	// Represents the finding attribute (for example, accountId) to sort findings by.
	AttributeName *string

	// The order by which the sorted findings are to be displayed.
	OrderBy OrderBy

	noSmithyDocumentSerde
}

// Contains information about a tag associated with the EC2 instance.
type Tag struct {

	// The EC2 instance tag key.
	Key *string

	// The EC2 instance tag value.
	Value *string

	noSmithyDocumentSerde
}

// Contains details about identified threats organized by threat name.
type ThreatDetectedByName struct {

	// Total number of infected files identified.
	ItemCount int32

	// Flag to determine if the finding contains every single infected file-path and/or
	// every threat.
	Shortened bool

	// List of identified threats with details, organized by threat name.
	ThreatNames []ScanThreatName

	// Total number of unique threats by name identified, as part of the malware scan.
	UniqueThreatNameCount int32

	noSmithyDocumentSerde
}

// An instance of a threat intelligence detail that constitutes evidence for the
// finding.
type ThreatIntelligenceDetail struct {

	// The name of the threat intelligence list that triggered the finding.
	ThreatListName *string

	// A list of names of the threats in the threat intelligence list that triggered
	// the finding.
	ThreatNames []string

	noSmithyDocumentSerde
}

// Contains total number of infected files.
type ThreatsDetectedItemCount struct {

	// Total number of infected files.
	Files int32

	noSmithyDocumentSerde
}

// Contains the total usage with the corresponding currency unit for that value.
type Total struct {

	// The total usage.
	Amount *string

	// The currency unit that the amount is given in.
	Unit *string

	noSmithyDocumentSerde
}

// Represents the reason the scan was triggered.
type TriggerDetails struct {

	// The description of the scan trigger.
	Description *string

	// The ID of the GuardDuty finding that triggered the BirdDog scan.
	GuardDutyFindingId *string

	noSmithyDocumentSerde
}

// Contains information about the accounts that weren't processed.
type UnprocessedAccount struct {

	// The Amazon Web Services account ID.
	//
	// This member is required.
	AccountId *string

	// A reason why the account hasn't been processed.
	//
	// This member is required.
	Result *string

	noSmithyDocumentSerde
}

// Specifies the names of the data sources that couldn't be enabled.
type UnprocessedDataSourcesResult struct {

	// An object that contains information on the status of all Malware Protection data
	// sources.
	MalwareProtection *MalwareProtectionConfigurationResult

	noSmithyDocumentSerde
}

// Contains information on the total of usage based on account IDs.
type UsageAccountResult struct {

	// The Account ID that generated usage.
	AccountId *string

	// Represents the total of usage for the Account ID.
	Total *Total

	noSmithyDocumentSerde
}

// Contains information about the criteria used to query usage statistics.
type UsageCriteria struct {

	// The data sources to aggregate usage statistics from.
	//
	// This member is required.
	DataSources []DataSource

	// The account IDs to aggregate usage statistics from.
	AccountIds []string

	// The resources to aggregate usage statistics from. Only accepts exact resource
	// names.
	Resources []string

	noSmithyDocumentSerde
}

// Contains information on the result of usage based on data source type.
type UsageDataSourceResult struct {

	// The data source type that generated usage.
	DataSource DataSource

	// Represents the total of usage for the specified data source.
	Total *Total

	noSmithyDocumentSerde
}

// Contains information on the sum of usage based on an Amazon Web Services
// resource.
type UsageResourceResult struct {

	// The Amazon Web Services resource that generated usage.
	Resource *string

	// Represents the sum total of usage for the specified resource type.
	Total *Total

	noSmithyDocumentSerde
}

// Contains the result of GuardDuty usage. If a UsageStatisticType is provided the
// result for other types will be null.
type UsageStatistics struct {

	// The usage statistic sum organized by account ID.
	SumByAccount []UsageAccountResult

	// The usage statistic sum organized by on data source.
	SumByDataSource []UsageDataSourceResult

	// The usage statistic sum organized by resource.
	SumByResource []UsageResourceResult

	// Lists the top 50 resources that have generated the most GuardDuty usage, in
	// order from most to least expensive.
	TopResources []UsageResourceResult

	noSmithyDocumentSerde
}

// Volume used by the Kubernetes workload.
type Volume struct {

	// Represents a pre-existing file or directory on the host machine that the volume
	// maps to.
	HostPath *HostPath

	// Volume name.
	Name *string

	noSmithyDocumentSerde
}

// Contains EBS volume details.
type VolumeDetail struct {

	// The device name for the EBS volume.
	DeviceName *string

	// EBS volume encryption type.
	EncryptionType *string

	// KMS key Arn used to encrypt the EBS volume.
	KmsKeyArn *string

	// Snapshot Arn of the EBS volume.
	SnapshotArn *string

	// EBS volume Arn information.
	VolumeArn *string

	// EBS volume size in GB.
	VolumeSizeInGB int32

	// The EBS volume type.
	VolumeType *string

	noSmithyDocumentSerde
}

// Container volume mount.
type VolumeMount struct {

	// Volume mount path.
	MountPath *string

	// Volume mount name.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
