// Code generated by smithy-go-codegen DO NOT EDIT.

package groundstation

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/groundstation/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpCancelContact struct {
}

func (*awsRestjson1_serializeOpCancelContact) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelContact) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelContactInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/{contactId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelContactInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelContactInput(v *CancelContactInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactId == nil || len(*v.ContactId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member contactId must not be empty")}
	}
	if v.ContactId != nil {
		if err := encoder.SetURI("contactId").String(*v.ContactId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateConfig struct {
}

func (*awsRestjson1_serializeOpCreateConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateConfigInput(v *CreateConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateConfigInput(v *CreateConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigData != nil {
		ok := object.Key("configData")
		if err := awsRestjson1_serializeDocumentConfigTypeData(v.ConfigData, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDataflowEndpointGroup struct {
}

func (*awsRestjson1_serializeOpCreateDataflowEndpointGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDataflowEndpointGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataflowEndpointGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/dataflowEndpointGroup")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDataflowEndpointGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDataflowEndpointGroupInput(v *CreateDataflowEndpointGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDataflowEndpointGroupInput(v *CreateDataflowEndpointGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContactPostPassDurationSeconds != nil {
		ok := object.Key("contactPostPassDurationSeconds")
		ok.Integer(*v.ContactPostPassDurationSeconds)
	}

	if v.ContactPrePassDurationSeconds != nil {
		ok := object.Key("contactPrePassDurationSeconds")
		ok.Integer(*v.ContactPrePassDurationSeconds)
	}

	if v.EndpointDetails != nil {
		ok := object.Key("endpointDetails")
		if err := awsRestjson1_serializeDocumentEndpointDetailsList(v.EndpointDetails, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateEphemeris struct {
}

func (*awsRestjson1_serializeOpCreateEphemeris) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateEphemeris) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateEphemerisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ephemeris")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateEphemerisInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateEphemerisInput(v *CreateEphemerisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateEphemerisInput(v *CreateEphemerisInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.Ephemeris != nil {
		ok := object.Key("ephemeris")
		if err := awsRestjson1_serializeDocumentEphemerisData(v.Ephemeris, ok); err != nil {
			return err
		}
	}

	if v.ExpirationTime != nil {
		ok := object.Key("expirationTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.ExpirationTime))
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("kmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Priority != nil {
		ok := object.Key("priority")
		ok.Integer(*v.Priority)
	}

	if v.SatelliteId != nil {
		ok := object.Key("satelliteId")
		ok.String(*v.SatelliteId)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateMissionProfile struct {
}

func (*awsRestjson1_serializeOpCreateMissionProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateMissionProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMissionProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/missionprofile")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateMissionProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateMissionProfileInput(v *CreateMissionProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateMissionProfileInput(v *CreateMissionProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContactPostPassDurationSeconds != nil {
		ok := object.Key("contactPostPassDurationSeconds")
		ok.Integer(*v.ContactPostPassDurationSeconds)
	}

	if v.ContactPrePassDurationSeconds != nil {
		ok := object.Key("contactPrePassDurationSeconds")
		ok.Integer(*v.ContactPrePassDurationSeconds)
	}

	if v.DataflowEdges != nil {
		ok := object.Key("dataflowEdges")
		if err := awsRestjson1_serializeDocumentDataflowEdgeList(v.DataflowEdges, ok); err != nil {
			return err
		}
	}

	if v.MinimumViableContactDurationSeconds != nil {
		ok := object.Key("minimumViableContactDurationSeconds")
		ok.Integer(*v.MinimumViableContactDurationSeconds)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.StreamsKmsKey != nil {
		ok := object.Key("streamsKmsKey")
		if err := awsRestjson1_serializeDocumentKmsKey(v.StreamsKmsKey, ok); err != nil {
			return err
		}
	}

	if v.StreamsKmsRole != nil {
		ok := object.Key("streamsKmsRole")
		ok.String(*v.StreamsKmsRole)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TrackingConfigArn != nil {
		ok := object.Key("trackingConfigArn")
		ok.String(*v.TrackingConfigArn)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConfig struct {
}

func (*awsRestjson1_serializeOpDeleteConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/config/{configType}/{configId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConfigInput(v *DeleteConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigId == nil || len(*v.ConfigId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configId must not be empty")}
	}
	if v.ConfigId != nil {
		if err := encoder.SetURI("configId").String(*v.ConfigId); err != nil {
			return err
		}
	}

	if len(v.ConfigType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configType must not be empty")}
	}
	if len(v.ConfigType) > 0 {
		if err := encoder.SetURI("configType").String(string(v.ConfigType)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDataflowEndpointGroup struct {
}

func (*awsRestjson1_serializeOpDeleteDataflowEndpointGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDataflowEndpointGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDataflowEndpointGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/dataflowEndpointGroup/{dataflowEndpointGroupId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDataflowEndpointGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDataflowEndpointGroupInput(v *DeleteDataflowEndpointGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DataflowEndpointGroupId == nil || len(*v.DataflowEndpointGroupId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataflowEndpointGroupId must not be empty")}
	}
	if v.DataflowEndpointGroupId != nil {
		if err := encoder.SetURI("dataflowEndpointGroupId").String(*v.DataflowEndpointGroupId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteEphemeris struct {
}

func (*awsRestjson1_serializeOpDeleteEphemeris) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteEphemeris) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteEphemerisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ephemeris/{ephemerisId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteEphemerisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteEphemerisInput(v *DeleteEphemerisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EphemerisId == nil || len(*v.EphemerisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ephemerisId must not be empty")}
	}
	if v.EphemerisId != nil {
		if err := encoder.SetURI("ephemerisId").String(*v.EphemerisId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteMissionProfile struct {
}

func (*awsRestjson1_serializeOpDeleteMissionProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteMissionProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMissionProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/missionprofile/{missionProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteMissionProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteMissionProfileInput(v *DeleteMissionProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MissionProfileId == nil || len(*v.MissionProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member missionProfileId must not be empty")}
	}
	if v.MissionProfileId != nil {
		if err := encoder.SetURI("missionProfileId").String(*v.MissionProfileId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeContact struct {
}

func (*awsRestjson1_serializeOpDescribeContact) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeContact) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeContactInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/{contactId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeContactInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeContactInput(v *DescribeContactInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactId == nil || len(*v.ContactId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member contactId must not be empty")}
	}
	if v.ContactId != nil {
		if err := encoder.SetURI("contactId").String(*v.ContactId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeEphemeris struct {
}

func (*awsRestjson1_serializeOpDescribeEphemeris) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeEphemeris) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEphemerisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ephemeris/{ephemerisId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeEphemerisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeEphemerisInput(v *DescribeEphemerisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EphemerisId == nil || len(*v.EphemerisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ephemerisId must not be empty")}
	}
	if v.EphemerisId != nil {
		if err := encoder.SetURI("ephemerisId").String(*v.EphemerisId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetAgentConfiguration struct {
}

func (*awsRestjson1_serializeOpGetAgentConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAgentConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAgentConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/agent/{agentId}/configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAgentConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAgentConfigurationInput(v *GetAgentConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AgentId == nil || len(*v.AgentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member agentId must not be empty")}
	}
	if v.AgentId != nil {
		if err := encoder.SetURI("agentId").String(*v.AgentId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetConfig struct {
}

func (*awsRestjson1_serializeOpGetConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/config/{configType}/{configId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetConfigInput(v *GetConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigId == nil || len(*v.ConfigId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configId must not be empty")}
	}
	if v.ConfigId != nil {
		if err := encoder.SetURI("configId").String(*v.ConfigId); err != nil {
			return err
		}
	}

	if len(v.ConfigType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configType must not be empty")}
	}
	if len(v.ConfigType) > 0 {
		if err := encoder.SetURI("configType").String(string(v.ConfigType)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDataflowEndpointGroup struct {
}

func (*awsRestjson1_serializeOpGetDataflowEndpointGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDataflowEndpointGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataflowEndpointGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/dataflowEndpointGroup/{dataflowEndpointGroupId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDataflowEndpointGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDataflowEndpointGroupInput(v *GetDataflowEndpointGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DataflowEndpointGroupId == nil || len(*v.DataflowEndpointGroupId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataflowEndpointGroupId must not be empty")}
	}
	if v.DataflowEndpointGroupId != nil {
		if err := encoder.SetURI("dataflowEndpointGroupId").String(*v.DataflowEndpointGroupId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetMinuteUsage struct {
}

func (*awsRestjson1_serializeOpGetMinuteUsage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMinuteUsage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMinuteUsageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/minute-usage")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetMinuteUsageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMinuteUsageInput(v *GetMinuteUsageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetMinuteUsageInput(v *GetMinuteUsageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Month != nil {
		ok := object.Key("month")
		ok.Integer(*v.Month)
	}

	if v.Year != nil {
		ok := object.Key("year")
		ok.Integer(*v.Year)
	}

	return nil
}

type awsRestjson1_serializeOpGetMissionProfile struct {
}

func (*awsRestjson1_serializeOpGetMissionProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMissionProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMissionProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/missionprofile/{missionProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMissionProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMissionProfileInput(v *GetMissionProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MissionProfileId == nil || len(*v.MissionProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member missionProfileId must not be empty")}
	}
	if v.MissionProfileId != nil {
		if err := encoder.SetURI("missionProfileId").String(*v.MissionProfileId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetSatellite struct {
}

func (*awsRestjson1_serializeOpGetSatellite) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSatellite) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSatelliteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/satellite/{satelliteId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSatelliteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSatelliteInput(v *GetSatelliteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SatelliteId == nil || len(*v.SatelliteId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member satelliteId must not be empty")}
	}
	if v.SatelliteId != nil {
		if err := encoder.SetURI("satelliteId").String(*v.SatelliteId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListConfigs struct {
}

func (*awsRestjson1_serializeOpListConfigs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListConfigs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConfigsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListConfigsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListConfigsInput(v *ListConfigsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListContacts struct {
}

func (*awsRestjson1_serializeOpListContacts) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListContacts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListContactsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contacts")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListContactsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListContactsInput(v *ListContactsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListContactsInput(v *ListContactsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("endTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.GroundStation != nil {
		ok := object.Key("groundStation")
		ok.String(*v.GroundStation)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.MissionProfileArn != nil {
		ok := object.Key("missionProfileArn")
		ok.String(*v.MissionProfileArn)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SatelliteArn != nil {
		ok := object.Key("satelliteArn")
		ok.String(*v.SatelliteArn)
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	if v.StatusList != nil {
		ok := object.Key("statusList")
		if err := awsRestjson1_serializeDocumentStatusList(v.StatusList, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListDataflowEndpointGroups struct {
}

func (*awsRestjson1_serializeOpListDataflowEndpointGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDataflowEndpointGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataflowEndpointGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/dataflowEndpointGroup")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDataflowEndpointGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDataflowEndpointGroupsInput(v *ListDataflowEndpointGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListEphemerides struct {
}

func (*awsRestjson1_serializeOpListEphemerides) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEphemerides) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEphemeridesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ephemerides")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListEphemeridesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListEphemeridesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEphemeridesInput(v *ListEphemeridesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListEphemeridesInput(v *ListEphemeridesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("endTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.SatelliteId != nil {
		ok := object.Key("satelliteId")
		ok.String(*v.SatelliteId)
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	if v.StatusList != nil {
		ok := object.Key("statusList")
		if err := awsRestjson1_serializeDocumentEphemerisStatusList(v.StatusList, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListGroundStations struct {
}

func (*awsRestjson1_serializeOpListGroundStations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGroundStations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGroundStationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/groundstation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGroundStationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGroundStationsInput(v *ListGroundStationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.SatelliteId != nil {
		encoder.SetQuery("satelliteId").String(*v.SatelliteId)
	}

	return nil
}

type awsRestjson1_serializeOpListMissionProfiles struct {
}

func (*awsRestjson1_serializeOpListMissionProfiles) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMissionProfiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMissionProfilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/missionprofile")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMissionProfilesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMissionProfilesInput(v *ListMissionProfilesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListSatellites struct {
}

func (*awsRestjson1_serializeOpListSatellites) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSatellites) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSatellitesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/satellite")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSatellitesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSatellitesInput(v *ListSatellitesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRegisterAgent struct {
}

func (*awsRestjson1_serializeOpRegisterAgent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRegisterAgent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterAgentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/agent")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRegisterAgentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRegisterAgentInput(v *RegisterAgentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRegisterAgentInput(v *RegisterAgentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AgentDetails != nil {
		ok := object.Key("agentDetails")
		if err := awsRestjson1_serializeDocumentAgentDetails(v.AgentDetails, ok); err != nil {
			return err
		}
	}

	if v.DiscoveryData != nil {
		ok := object.Key("discoveryData")
		if err := awsRestjson1_serializeDocumentDiscoveryData(v.DiscoveryData, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpReserveContact struct {
}

func (*awsRestjson1_serializeOpReserveContact) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpReserveContact) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReserveContactInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentReserveContactInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsReserveContactInput(v *ReserveContactInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentReserveContactInput(v *ReserveContactInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("endTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.GroundStation != nil {
		ok := object.Key("groundStation")
		ok.String(*v.GroundStation)
	}

	if v.MissionProfileArn != nil {
		ok := object.Key("missionProfileArn")
		ok.String(*v.MissionProfileArn)
	}

	if v.SatelliteArn != nil {
		ok := object.Key("satelliteArn")
		ok.String(*v.SatelliteArn)
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAgentStatus struct {
}

func (*awsRestjson1_serializeOpUpdateAgentStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAgentStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAgentStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/agent/{agentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAgentStatusInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAgentStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAgentStatusInput(v *UpdateAgentStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AgentId == nil || len(*v.AgentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member agentId must not be empty")}
	}
	if v.AgentId != nil {
		if err := encoder.SetURI("agentId").String(*v.AgentId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAgentStatusInput(v *UpdateAgentStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregateStatus != nil {
		ok := object.Key("aggregateStatus")
		if err := awsRestjson1_serializeDocumentAggregateStatus(v.AggregateStatus, ok); err != nil {
			return err
		}
	}

	if v.ComponentStatuses != nil {
		ok := object.Key("componentStatuses")
		if err := awsRestjson1_serializeDocumentComponentStatusList(v.ComponentStatuses, ok); err != nil {
			return err
		}
	}

	if v.TaskId != nil {
		ok := object.Key("taskId")
		ok.String(*v.TaskId)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateConfig struct {
}

func (*awsRestjson1_serializeOpUpdateConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/config/{configType}/{configId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateConfigInput(v *UpdateConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigId == nil || len(*v.ConfigId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configId must not be empty")}
	}
	if v.ConfigId != nil {
		if err := encoder.SetURI("configId").String(*v.ConfigId); err != nil {
			return err
		}
	}

	if len(v.ConfigType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configType must not be empty")}
	}
	if len(v.ConfigType) > 0 {
		if err := encoder.SetURI("configType").String(string(v.ConfigType)); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateConfigInput(v *UpdateConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigData != nil {
		ok := object.Key("configData")
		if err := awsRestjson1_serializeDocumentConfigTypeData(v.ConfigData, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateEphemeris struct {
}

func (*awsRestjson1_serializeOpUpdateEphemeris) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateEphemeris) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateEphemerisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ephemeris/{ephemerisId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateEphemerisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateEphemerisInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateEphemerisInput(v *UpdateEphemerisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EphemerisId == nil || len(*v.EphemerisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ephemerisId must not be empty")}
	}
	if v.EphemerisId != nil {
		if err := encoder.SetURI("ephemerisId").String(*v.EphemerisId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateEphemerisInput(v *UpdateEphemerisInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Priority != nil {
		ok := object.Key("priority")
		ok.Integer(*v.Priority)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateMissionProfile struct {
}

func (*awsRestjson1_serializeOpUpdateMissionProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateMissionProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateMissionProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/missionprofile/{missionProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateMissionProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateMissionProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateMissionProfileInput(v *UpdateMissionProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MissionProfileId == nil || len(*v.MissionProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member missionProfileId must not be empty")}
	}
	if v.MissionProfileId != nil {
		if err := encoder.SetURI("missionProfileId").String(*v.MissionProfileId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateMissionProfileInput(v *UpdateMissionProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContactPostPassDurationSeconds != nil {
		ok := object.Key("contactPostPassDurationSeconds")
		ok.Integer(*v.ContactPostPassDurationSeconds)
	}

	if v.ContactPrePassDurationSeconds != nil {
		ok := object.Key("contactPrePassDurationSeconds")
		ok.Integer(*v.ContactPrePassDurationSeconds)
	}

	if v.DataflowEdges != nil {
		ok := object.Key("dataflowEdges")
		if err := awsRestjson1_serializeDocumentDataflowEdgeList(v.DataflowEdges, ok); err != nil {
			return err
		}
	}

	if v.MinimumViableContactDurationSeconds != nil {
		ok := object.Key("minimumViableContactDurationSeconds")
		ok.Integer(*v.MinimumViableContactDurationSeconds)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.StreamsKmsKey != nil {
		ok := object.Key("streamsKmsKey")
		if err := awsRestjson1_serializeDocumentKmsKey(v.StreamsKmsKey, ok); err != nil {
			return err
		}
	}

	if v.StreamsKmsRole != nil {
		ok := object.Key("streamsKmsRole")
		ok.String(*v.StreamsKmsRole)
	}

	if v.TrackingConfigArn != nil {
		ok := object.Key("trackingConfigArn")
		ok.String(*v.TrackingConfigArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentAgentDetails(v *types.AgentDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AgentVersion != nil {
		ok := object.Key("agentVersion")
		ok.String(*v.AgentVersion)
	}

	if v.ComponentVersions != nil {
		ok := object.Key("componentVersions")
		if err := awsRestjson1_serializeDocumentComponentVersionList(v.ComponentVersions, ok); err != nil {
			return err
		}
	}

	if v.InstanceId != nil {
		ok := object.Key("instanceId")
		ok.String(*v.InstanceId)
	}

	if v.InstanceType != nil {
		ok := object.Key("instanceType")
		ok.String(*v.InstanceType)
	}

	if v.ReservedCpuCores != nil {
		ok := object.Key("reservedCpuCores")
		if err := awsRestjson1_serializeDocumentReservedCpuCoresList(v.ReservedCpuCores, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAggregateStatus(v *types.AggregateStatus, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SignatureMap != nil {
		ok := object.Key("signatureMap")
		if err := awsRestjson1_serializeDocumentSignatureMap(v.SignatureMap, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocumentAntennaDownlinkConfig(v *types.AntennaDownlinkConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SpectrumConfig != nil {
		ok := object.Key("spectrumConfig")
		if err := awsRestjson1_serializeDocumentSpectrumConfig(v.SpectrumConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAntennaDownlinkDemodDecodeConfig(v *types.AntennaDownlinkDemodDecodeConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DecodeConfig != nil {
		ok := object.Key("decodeConfig")
		if err := awsRestjson1_serializeDocumentDecodeConfig(v.DecodeConfig, ok); err != nil {
			return err
		}
	}

	if v.DemodulationConfig != nil {
		ok := object.Key("demodulationConfig")
		if err := awsRestjson1_serializeDocumentDemodulationConfig(v.DemodulationConfig, ok); err != nil {
			return err
		}
	}

	if v.SpectrumConfig != nil {
		ok := object.Key("spectrumConfig")
		if err := awsRestjson1_serializeDocumentSpectrumConfig(v.SpectrumConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAntennaUplinkConfig(v *types.AntennaUplinkConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SpectrumConfig != nil {
		ok := object.Key("spectrumConfig")
		if err := awsRestjson1_serializeDocumentUplinkSpectrumConfig(v.SpectrumConfig, ok); err != nil {
			return err
		}
	}

	if v.TargetEirp != nil {
		ok := object.Key("targetEirp")
		if err := awsRestjson1_serializeDocumentEirp(v.TargetEirp, ok); err != nil {
			return err
		}
	}

	if v.TransmitDisabled != nil {
		ok := object.Key("transmitDisabled")
		ok.Boolean(*v.TransmitDisabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsGroundStationAgentEndpoint(v *types.AwsGroundStationAgentEndpoint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AgentStatus) > 0 {
		ok := object.Key("agentStatus")
		ok.String(string(v.AgentStatus))
	}

	if len(v.AuditResults) > 0 {
		ok := object.Key("auditResults")
		ok.String(string(v.AuditResults))
	}

	if v.EgressAddress != nil {
		ok := object.Key("egressAddress")
		if err := awsRestjson1_serializeDocumentConnectionDetails(v.EgressAddress, ok); err != nil {
			return err
		}
	}

	if v.IngressAddress != nil {
		ok := object.Key("ingressAddress")
		if err := awsRestjson1_serializeDocumentRangedConnectionDetails(v.IngressAddress, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentCapabilityArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentStatusData(v *types.ComponentStatusData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BytesReceived != nil {
		ok := object.Key("bytesReceived")
		ok.Long(*v.BytesReceived)
	}

	if v.BytesSent != nil {
		ok := object.Key("bytesSent")
		ok.Long(*v.BytesSent)
	}

	if v.CapabilityArn != nil {
		ok := object.Key("capabilityArn")
		ok.String(*v.CapabilityArn)
	}

	if len(v.ComponentType) > 0 {
		ok := object.Key("componentType")
		ok.String(string(v.ComponentType))
	}

	if v.DataflowId != nil {
		ok := object.Key("dataflowId")
		ok.String(*v.DataflowId)
	}

	if v.PacketsDropped != nil {
		ok := object.Key("packetsDropped")
		ok.Long(*v.PacketsDropped)
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentStatusList(v []types.ComponentStatusData, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentComponentStatusData(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentVersion(v *types.ComponentVersion, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ComponentType) > 0 {
		ok := object.Key("componentType")
		ok.String(string(v.ComponentType))
	}

	if v.Versions != nil {
		ok := object.Key("versions")
		if err := awsRestjson1_serializeDocumentVersionStringList(v.Versions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentVersionList(v []types.ComponentVersion, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentComponentVersion(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentConfigTypeData(v types.ConfigTypeData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ConfigTypeDataMemberAntennaDownlinkConfig:
		av := object.Key("antennaDownlinkConfig")
		if err := awsRestjson1_serializeDocumentAntennaDownlinkConfig(&uv.Value, av); err != nil {
			return err
		}

	case *types.ConfigTypeDataMemberAntennaDownlinkDemodDecodeConfig:
		av := object.Key("antennaDownlinkDemodDecodeConfig")
		if err := awsRestjson1_serializeDocumentAntennaDownlinkDemodDecodeConfig(&uv.Value, av); err != nil {
			return err
		}

	case *types.ConfigTypeDataMemberAntennaUplinkConfig:
		av := object.Key("antennaUplinkConfig")
		if err := awsRestjson1_serializeDocumentAntennaUplinkConfig(&uv.Value, av); err != nil {
			return err
		}

	case *types.ConfigTypeDataMemberDataflowEndpointConfig:
		av := object.Key("dataflowEndpointConfig")
		if err := awsRestjson1_serializeDocumentDataflowEndpointConfig(&uv.Value, av); err != nil {
			return err
		}

	case *types.ConfigTypeDataMemberS3RecordingConfig:
		av := object.Key("s3RecordingConfig")
		if err := awsRestjson1_serializeDocumentS3RecordingConfig(&uv.Value, av); err != nil {
			return err
		}

	case *types.ConfigTypeDataMemberTrackingConfig:
		av := object.Key("trackingConfig")
		if err := awsRestjson1_serializeDocumentTrackingConfig(&uv.Value, av); err != nil {
			return err
		}

	case *types.ConfigTypeDataMemberUplinkEchoConfig:
		av := object.Key("uplinkEchoConfig")
		if err := awsRestjson1_serializeDocumentUplinkEchoConfig(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentConnectionDetails(v *types.ConnectionDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Mtu != nil {
		ok := object.Key("mtu")
		ok.Integer(*v.Mtu)
	}

	if v.SocketAddress != nil {
		ok := object.Key("socketAddress")
		if err := awsRestjson1_serializeDocumentSocketAddress(v.SocketAddress, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataflowEdge(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDataflowEdgeList(v [][]string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentDataflowEdge(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDataflowEndpoint(v *types.DataflowEndpoint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Address != nil {
		ok := object.Key("address")
		if err := awsRestjson1_serializeDocumentSocketAddress(v.Address, ok); err != nil {
			return err
		}
	}

	if v.Mtu != nil {
		ok := object.Key("mtu")
		ok.Integer(*v.Mtu)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocumentDataflowEndpointConfig(v *types.DataflowEndpointConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataflowEndpointName != nil {
		ok := object.Key("dataflowEndpointName")
		ok.String(*v.DataflowEndpointName)
	}

	if v.DataflowEndpointRegion != nil {
		ok := object.Key("dataflowEndpointRegion")
		ok.String(*v.DataflowEndpointRegion)
	}

	return nil
}

func awsRestjson1_serializeDocumentDecodeConfig(v *types.DecodeConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UnvalidatedJSON != nil {
		ok := object.Key("unvalidatedJSON")
		ok.String(*v.UnvalidatedJSON)
	}

	return nil
}

func awsRestjson1_serializeDocumentDemodulationConfig(v *types.DemodulationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UnvalidatedJSON != nil {
		ok := object.Key("unvalidatedJSON")
		ok.String(*v.UnvalidatedJSON)
	}

	return nil
}

func awsRestjson1_serializeDocumentDiscoveryData(v *types.DiscoveryData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapabilityArns != nil {
		ok := object.Key("capabilityArns")
		if err := awsRestjson1_serializeDocumentCapabilityArnList(v.CapabilityArns, ok); err != nil {
			return err
		}
	}

	if v.PrivateIpAddresses != nil {
		ok := object.Key("privateIpAddresses")
		if err := awsRestjson1_serializeDocumentIpAddressList(v.PrivateIpAddresses, ok); err != nil {
			return err
		}
	}

	if v.PublicIpAddresses != nil {
		ok := object.Key("publicIpAddresses")
		if err := awsRestjson1_serializeDocumentIpAddressList(v.PublicIpAddresses, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEirp(v *types.Eirp, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Units) > 0 {
		ok := object.Key("units")
		ok.String(string(v.Units))
	}

	if v.Value != nil {
		ok := object.Key("value")
		switch {
		case math.IsNaN(*v.Value):
			ok.String("NaN")

		case math.IsInf(*v.Value, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Value, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Value)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEndpointDetails(v *types.EndpointDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsGroundStationAgentEndpoint != nil {
		ok := object.Key("awsGroundStationAgentEndpoint")
		if err := awsRestjson1_serializeDocumentAwsGroundStationAgentEndpoint(v.AwsGroundStationAgentEndpoint, ok); err != nil {
			return err
		}
	}

	if v.Endpoint != nil {
		ok := object.Key("endpoint")
		if err := awsRestjson1_serializeDocumentDataflowEndpoint(v.Endpoint, ok); err != nil {
			return err
		}
	}

	if v.SecurityDetails != nil {
		ok := object.Key("securityDetails")
		if err := awsRestjson1_serializeDocumentSecurityDetails(v.SecurityDetails, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEndpointDetailsList(v []types.EndpointDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEndpointDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEphemerisData(v types.EphemerisData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EphemerisDataMemberOem:
		av := object.Key("oem")
		if err := awsRestjson1_serializeDocumentOEMEphemeris(&uv.Value, av); err != nil {
			return err
		}

	case *types.EphemerisDataMemberTle:
		av := object.Key("tle")
		if err := awsRestjson1_serializeDocumentTLEEphemeris(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentEphemerisStatusList(v []types.EphemerisStatus, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentFrequency(v *types.Frequency, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Units) > 0 {
		ok := object.Key("units")
		ok.String(string(v.Units))
	}

	if v.Value != nil {
		ok := object.Key("value")
		switch {
		case math.IsNaN(*v.Value):
			ok.String("NaN")

		case math.IsInf(*v.Value, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Value, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Value)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFrequencyBandwidth(v *types.FrequencyBandwidth, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Units) > 0 {
		ok := object.Key("units")
		ok.String(string(v.Units))
	}

	if v.Value != nil {
		ok := object.Key("value")
		switch {
		case math.IsNaN(*v.Value):
			ok.String("NaN")

		case math.IsInf(*v.Value, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Value, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Value)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIntegerRange(v *types.IntegerRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Maximum != nil {
		ok := object.Key("maximum")
		ok.Integer(*v.Maximum)
	}

	if v.Minimum != nil {
		ok := object.Key("minimum")
		ok.Integer(*v.Minimum)
	}

	return nil
}

func awsRestjson1_serializeDocumentIpAddressList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentKmsKey(v types.KmsKey, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.KmsKeyMemberKmsAliasArn:
		av := object.Key("kmsAliasArn")
		av.String(uv.Value)

	case *types.KmsKeyMemberKmsKeyArn:
		av := object.Key("kmsKeyArn")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentOEMEphemeris(v *types.OEMEphemeris, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OemData != nil {
		ok := object.Key("oemData")
		ok.String(*v.OemData)
	}

	if v.S3Object != nil {
		ok := object.Key("s3Object")
		if err := awsRestjson1_serializeDocumentS3Object(v.S3Object, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRangedConnectionDetails(v *types.RangedConnectionDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Mtu != nil {
		ok := object.Key("mtu")
		ok.Integer(*v.Mtu)
	}

	if v.SocketAddress != nil {
		ok := object.Key("socketAddress")
		if err := awsRestjson1_serializeDocumentRangedSocketAddress(v.SocketAddress, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRangedSocketAddress(v *types.RangedSocketAddress, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.PortRange != nil {
		ok := object.Key("portRange")
		if err := awsRestjson1_serializeDocumentIntegerRange(v.PortRange, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentReservedCpuCoresList(v []int32, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentS3Object(v *types.S3Object, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.String(*v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3RecordingConfig(v *types.S3RecordingConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketArn != nil {
		ok := object.Key("bucketArn")
		ok.String(*v.BucketArn)
	}

	if v.Prefix != nil {
		ok := object.Key("prefix")
		ok.String(*v.Prefix)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentSecurityDetails(v *types.SecurityDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupIdList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("subnetIds")
		if err := awsRestjson1_serializeDocumentSubnetList(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSignatureMap(v map[string]bool, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.Boolean(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentSocketAddress(v *types.SocketAddress, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentSpectrumConfig(v *types.SpectrumConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bandwidth != nil {
		ok := object.Key("bandwidth")
		if err := awsRestjson1_serializeDocumentFrequencyBandwidth(v.Bandwidth, ok); err != nil {
			return err
		}
	}

	if v.CenterFrequency != nil {
		ok := object.Key("centerFrequency")
		if err := awsRestjson1_serializeDocumentFrequency(v.CenterFrequency, ok); err != nil {
			return err
		}
	}

	if len(v.Polarization) > 0 {
		ok := object.Key("polarization")
		ok.String(string(v.Polarization))
	}

	return nil
}

func awsRestjson1_serializeDocumentStatusList(v []types.ContactStatus, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentSubnetList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagsMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTimeRange(v *types.TimeRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("endTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	return nil
}

func awsRestjson1_serializeDocumentTLEData(v *types.TLEData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TleLine1 != nil {
		ok := object.Key("tleLine1")
		ok.String(*v.TleLine1)
	}

	if v.TleLine2 != nil {
		ok := object.Key("tleLine2")
		ok.String(*v.TleLine2)
	}

	if v.ValidTimeRange != nil {
		ok := object.Key("validTimeRange")
		if err := awsRestjson1_serializeDocumentTimeRange(v.ValidTimeRange, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTLEDataList(v []types.TLEData, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTLEData(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTLEEphemeris(v *types.TLEEphemeris, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Object != nil {
		ok := object.Key("s3Object")
		if err := awsRestjson1_serializeDocumentS3Object(v.S3Object, ok); err != nil {
			return err
		}
	}

	if v.TleData != nil {
		ok := object.Key("tleData")
		if err := awsRestjson1_serializeDocumentTLEDataList(v.TleData, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTrackingConfig(v *types.TrackingConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Autotrack) > 0 {
		ok := object.Key("autotrack")
		ok.String(string(v.Autotrack))
	}

	return nil
}

func awsRestjson1_serializeDocumentUplinkEchoConfig(v *types.UplinkEchoConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AntennaUplinkConfigArn != nil {
		ok := object.Key("antennaUplinkConfigArn")
		ok.String(*v.AntennaUplinkConfigArn)
	}

	if v.Enabled != nil {
		ok := object.Key("enabled")
		ok.Boolean(*v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentUplinkSpectrumConfig(v *types.UplinkSpectrumConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CenterFrequency != nil {
		ok := object.Key("centerFrequency")
		if err := awsRestjson1_serializeDocumentFrequency(v.CenterFrequency, ok); err != nil {
			return err
		}
	}

	if len(v.Polarization) > 0 {
		ok := object.Key("polarization")
		ok.String(string(v.Polarization))
	}

	return nil
}

func awsRestjson1_serializeDocumentVersionStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}
