// Code generated by smithy-go-codegen DO NOT EDIT.

package connectcases

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/connectcases/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a related item (comments, tasks, and contacts) and associates it with a
// case. A Related Item is a resource that is associated with a case. It may or may
// not have an external identifier linking it to an external resource (for example,
// a contactArn). All Related Items have their own internal identifier, the
// relatedItemArn. Examples of related items include comments and contacts.
func (c *Client) CreateRelatedItem(ctx context.Context, params *CreateRelatedItemInput, optFns ...func(*Options)) (*CreateRelatedItemOutput, error) {
	if params == nil {
		params = &CreateRelatedItemInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRelatedItem", params, optFns, c.addOperationCreateRelatedItemMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRelatedItemOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateRelatedItemInput struct {

	// A unique identifier of the case.
	//
	// This member is required.
	CaseId *string

	// The content of a related item to be created.
	//
	// This member is required.
	Content types.RelatedItemInputContent

	// The unique identifier of the Cases domain.
	//
	// This member is required.
	DomainId *string

	// The type of a related item.
	//
	// This member is required.
	Type types.RelatedItemType

	noSmithyDocumentSerde
}

type CreateRelatedItemOutput struct {

	// The Amazon Resource Name (ARN) of the related item.
	//
	// This member is required.
	RelatedItemArn *string

	// The unique identifier of the related item.
	//
	// This member is required.
	RelatedItemId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRelatedItemMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateRelatedItem{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateRelatedItem{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateRelatedItemValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRelatedItem(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateRelatedItem(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "cases",
		OperationName: "CreateRelatedItem",
	}
}
