// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the configuration for a CloudFront distribution. The update process
// includes getting the current distribution configuration, updating it to make
// your changes, and then submitting an UpdateDistribution request to make the
// updates. To update a web distribution using the CloudFront API
//
// * Use
// GetDistributionConfig to get the current configuration, including the version
// identifier (ETag).
//
// * Update the distribution configuration that was returned in
// the response. Note the following important requirements and restrictions:
//
// * You
// must rename the ETag field to IfMatch, leaving the value unchanged. (Set the
// value of IfMatch to the value of ETag, then remove the ETag field.)
//
// * You can't
// change the value of CallerReference.
//
// * Submit an UpdateDistribution request,
// providing the distribution configuration. The new configuration replaces the
// existing configuration. The values that you specify in an UpdateDistribution
// request are not merged into your existing configuration. Make sure to include
// all fields: the ones that you modified and also the ones that you didn't.
func (c *Client) UpdateDistribution(ctx context.Context, params *UpdateDistributionInput, optFns ...func(*Options)) (*UpdateDistributionOutput, error) {
	if params == nil {
		params = &UpdateDistributionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDistribution", params, optFns, c.addOperationUpdateDistributionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDistributionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request to update a distribution.
type UpdateDistributionInput struct {

	// The distribution's configuration information.
	//
	// This member is required.
	DistributionConfig *types.DistributionConfig

	// The distribution's id.
	//
	// This member is required.
	Id *string

	// The value of the ETag header that you received when retrieving the
	// distribution's configuration. For example: E2QWRUHAPOMQZL.
	IfMatch *string

	noSmithyDocumentSerde
}

// The returned result of the corresponding request.
type UpdateDistributionOutput struct {

	// The distribution's information.
	Distribution *types.Distribution

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDistributionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestxml_serializeOpUpdateDistribution{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpUpdateDistribution{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateDistributionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDistribution(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDistribution(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "cloudfront",
		OperationName: "UpdateDistribution",
	}
}
