// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Column in configured table that can be used in aggregate function in query.
type AggregateColumn struct {

	// Column names in configured table of aggregate columns.
	//
	// This member is required.
	ColumnNames []string

	// Aggregation function that can be applied to aggregate column in query.
	//
	// This member is required.
	Function AggregateFunctionName

	noSmithyDocumentSerde
}

// Constraint on query output removing output rows that do not meet a minimum
// number of distinct values of a specified column.
type AggregationConstraint struct {

	// Column in aggregation constraint for which there must be a minimum number of
	// distinct values in an output row for it to be in the query output.
	//
	// This member is required.
	ColumnName *string

	// The minimum number of distinct values that an output row must be an aggregation
	// of. Minimum threshold of distinct values for a specified column that must exist
	// in an output row for it to be in the query output.
	//
	// This member is required.
	Minimum *int32

	// The type of aggregation the constraint allows. The only valid value is currently
	// `COUNT_DISTINCT`.
	//
	// This member is required.
	Type AggregationType

	noSmithyDocumentSerde
}

// A specification about how data from the configured table can be used in a query.
type AnalysisRule struct {

	// The unique ID for the associated collaboration.
	//
	// This member is required.
	CollaborationId *string

	// The time the analysis rule was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The name for the analysis rule.
	//
	// This member is required.
	Name *string

	// A policy that describes the associated data usage limitations.
	//
	// This member is required.
	Policy AnalysisRulePolicy

	// The type of analysis rule. Valid values are `AGGREGATION` and `LIST`.
	//
	// This member is required.
	Type AnalysisRuleType

	// The time the analysis rule was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Enables query structure and specified queries that product aggregate statistics.
type AnalysisRuleAggregation struct {

	// The columns that query runners are allowed to use in aggregation queries.
	//
	// This member is required.
	AggregateColumns []AggregateColumn

	// The columns that query runners are allowed to select, group by, or filter by.
	//
	// This member is required.
	DimensionColumns []string

	// Columns in configured table that can be used in join statements and/or as
	// aggregate columns. They can never be outputted directly.
	//
	// This member is required.
	JoinColumns []string

	// Columns that must meet a specific threshold value (after an aggregation function
	// is applied to it) for each output row to be returned.
	//
	// This member is required.
	OutputConstraints []AggregationConstraint

	// Set of scalar functions that are allowed to be used on dimension columns and the
	// output of aggregation of metrics.
	//
	// This member is required.
	ScalarFunctions []ScalarFunctions

	// Control that requires member who runs query to do a join with their configured
	// table and/or other configured table in query
	JoinRequired JoinRequiredOption

	noSmithyDocumentSerde
}

// A type of analysis rule that enables row-level analysis.
type AnalysisRuleList struct {

	// Columns that can be used to join a configured table with the table of the member
	// who can query and another members' configured tables.
	//
	// This member is required.
	JoinColumns []string

	// Columns that can be listed in the output.
	//
	// This member is required.
	ListColumns []string

	noSmithyDocumentSerde
}

// Controls on the query specifications that can be run on configured table..
//
// The following types satisfy this interface:
//
//	AnalysisRulePolicyMemberV1
type AnalysisRulePolicy interface {
	isAnalysisRulePolicy()
}

// Controls on the query specifications that can be run on configured table..
type AnalysisRulePolicyMemberV1 struct {
	Value AnalysisRulePolicyV1

	noSmithyDocumentSerde
}

func (*AnalysisRulePolicyMemberV1) isAnalysisRulePolicy() {}

// Controls on the query specifications that can be run on configured table..
//
// The following types satisfy this interface:
//
//	AnalysisRulePolicyV1MemberAggregation
//	AnalysisRulePolicyV1MemberList
type AnalysisRulePolicyV1 interface {
	isAnalysisRulePolicyV1()
}

// Analysis rule type that enables only aggregation queries on a configured table.
type AnalysisRulePolicyV1MemberAggregation struct {
	Value AnalysisRuleAggregation

	noSmithyDocumentSerde
}

func (*AnalysisRulePolicyV1MemberAggregation) isAnalysisRulePolicyV1() {}

// Analysis rule type that enables only list queries on a configured table.
type AnalysisRulePolicyV1MemberList struct {
	Value AnalysisRuleList

	noSmithyDocumentSerde
}

func (*AnalysisRulePolicyV1MemberList) isAnalysisRulePolicyV1() {}

// An error describing why a schema could not be fetched.
type BatchGetSchemaError struct {

	// An error code for the error.
	//
	// This member is required.
	Code *string

	// An error message for the error.
	//
	// This member is required.
	Message *string

	// An error name for the error.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The multi-party data share environment. The collaboration contains metadata
// about its purpose and participants.
type Collaboration struct {

	// The unique ARN for the collaboration.
	//
	// This member is required.
	Arn *string

	// The time when the collaboration was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier used to reference members of the collaboration. Currently only
	// supports AWS account ID.
	//
	// This member is required.
	CreatorAccountId *string

	// A display name of the collaboration creator.
	//
	// This member is required.
	CreatorDisplayName *string

	// The unique ID for the collaboration.
	//
	// This member is required.
	Id *string

	// The status of a member in a collaboration.
	//
	// This member is required.
	MemberStatus MemberStatus

	// A human-readable identifier provided by the collaboration owner. Display names
	// are not unique.
	//
	// This member is required.
	Name *string

	// An indicator as to whether query logging has been enabled or disabled for the
	// collaboration.
	//
	// This member is required.
	QueryLogStatus CollaborationQueryLogStatus

	// The time the collaboration metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The settings for client-side encryption for cryptographic computing.
	DataEncryptionMetadata *DataEncryptionMetadata

	// A description of the collaboration provided by the collaboration owner.
	Description *string

	// The unique ARN for your membership within the collaboration.
	MembershipArn *string

	// The unique ID for your membership within the collaboration.
	MembershipId *string

	noSmithyDocumentSerde
}

// The metadata of the collaboration.
type CollaborationSummary struct {

	// The ARN of the collaboration.
	//
	// This member is required.
	Arn *string

	// The time when the collaboration was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier used to reference members of the collaboration. Currently only
	// supports AWS Account ID.
	//
	// This member is required.
	CreatorAccountId *string

	// The display name of the collaboration creator.
	//
	// This member is required.
	CreatorDisplayName *string

	// The identifier for the collaboration.
	//
	// This member is required.
	Id *string

	// The status of a member in a collaboration.
	//
	// This member is required.
	MemberStatus MemberStatus

	// A human-readable identifier provided by the collaboration owner. Display names
	// are not unique.
	//
	// This member is required.
	Name *string

	// The time the collaboration metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The ARN of a member in a collaboration.
	MembershipArn *string

	// The identifier of a member in a collaboration.
	MembershipId *string

	noSmithyDocumentSerde
}

// A column within a schema relation, derived from the underlying AWS Glue table.
type Column struct {

	// The name of the column.
	//
	// This member is required.
	Name *string

	// The type of the column.
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// A table that has been configured for use in a collaboration.
type ConfiguredTable struct {

	// The columns within the underlying AWS Glue table that can be utilized within
	// collaborations.
	//
	// This member is required.
	AllowedColumns []string

	// The analysis method for the configured table. The only valid value is currently
	// `DIRECT_QUERY`.
	//
	// This member is required.
	AnalysisMethod AnalysisMethod

	// The types of analysis rules associated with this configured table. Valid values
	// are `AGGREGATION` and `LIST`. Currently, only one analysis rule may be
	// associated with a configured table.
	//
	// This member is required.
	AnalysisRuleTypes []ConfiguredTableAnalysisRuleType

	// The unique ARN for the configured table.
	//
	// This member is required.
	Arn *string

	// The time the configured table was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID for the configured table.
	//
	// This member is required.
	Id *string

	// A name for the configured table.
	//
	// This member is required.
	Name *string

	// The AWS Glue table that this configured table represents.
	//
	// This member is required.
	TableReference TableReference

	// The time the configured table was last updated
	//
	// This member is required.
	UpdateTime *time.Time

	// A description for the configured table.
	Description *string

	noSmithyDocumentSerde
}

// A configured table analysis rule, which limits how data for this table can be
// used.
type ConfiguredTableAnalysisRule struct {

	// The unique ARN for the configured table.
	//
	// This member is required.
	ConfiguredTableArn *string

	// The unique ID for the configured table.
	//
	// This member is required.
	ConfiguredTableId *string

	// The time the configured table analysis rule was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The policy that controls SQL query rules.
	//
	// This member is required.
	Policy ConfiguredTableAnalysisRulePolicy

	// The type of configured table analysis rule. Valid values are `AGGREGATION` and
	// `LIST`.
	//
	// This member is required.
	Type ConfiguredTableAnalysisRuleType

	// The time the configured table analysis rule was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Controls on the query specifications that can be run on a configured table.
//
// The following types satisfy this interface:
//
//	ConfiguredTableAnalysisRulePolicyMemberV1
type ConfiguredTableAnalysisRulePolicy interface {
	isConfiguredTableAnalysisRulePolicy()
}

// Controls on the query specifications that can be run on a configured table.
type ConfiguredTableAnalysisRulePolicyMemberV1 struct {
	Value ConfiguredTableAnalysisRulePolicyV1

	noSmithyDocumentSerde
}

func (*ConfiguredTableAnalysisRulePolicyMemberV1) isConfiguredTableAnalysisRulePolicy() {}

// Controls on the query specifications that can be run on a configured table.
//
// The following types satisfy this interface:
//
//	ConfiguredTableAnalysisRulePolicyV1MemberAggregation
//	ConfiguredTableAnalysisRulePolicyV1MemberList
type ConfiguredTableAnalysisRulePolicyV1 interface {
	isConfiguredTableAnalysisRulePolicyV1()
}

// Analysis rule type that enables only aggregation queries on a configured table.
type ConfiguredTableAnalysisRulePolicyV1MemberAggregation struct {
	Value AnalysisRuleAggregation

	noSmithyDocumentSerde
}

func (*ConfiguredTableAnalysisRulePolicyV1MemberAggregation) isConfiguredTableAnalysisRulePolicyV1() {
}

// Analysis rule type that enables only list queries on a configured table.
type ConfiguredTableAnalysisRulePolicyV1MemberList struct {
	Value AnalysisRuleList

	noSmithyDocumentSerde
}

func (*ConfiguredTableAnalysisRulePolicyV1MemberList) isConfiguredTableAnalysisRulePolicyV1() {}

// A configured table association links a configured table to a collaboration.
type ConfiguredTableAssociation struct {

	// The unique ARN for the configured table association.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the configured table that the association refers to.
	//
	// This member is required.
	ConfiguredTableArn *string

	// The unique ID for the configured table that the association refers to.
	//
	// This member is required.
	ConfiguredTableId *string

	// The time the configured table association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID for the configured table association.
	//
	// This member is required.
	Id *string

	// The unique ARN for the membership this configured table association belongs to.
	//
	// This member is required.
	MembershipArn *string

	// The unique ID for the membership this configured table association belongs to.
	//
	// This member is required.
	MembershipId *string

	// The name of the configured table association, in lowercase. The table is
	// identified by this name when running protected queries against the underlying
	// data.
	//
	// This member is required.
	Name *string

	// The service will assume this role to access catalog metadata and query the
	// table.
	//
	// This member is required.
	RoleArn *string

	// The time the configured table association was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// A description of the configured table association.
	Description *string

	noSmithyDocumentSerde
}

// The configured table association summary for the objects listed by the request.
type ConfiguredTableAssociationSummary struct {

	// The unique ARN for the configured table association.
	//
	// This member is required.
	Arn *string

	// The unique configured table ID that this configured table association refers to.
	//
	// This member is required.
	ConfiguredTableId *string

	// The time the configured table association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID for the configured table association.
	//
	// This member is required.
	Id *string

	// The unique ARN for the membership that the configured table association belongs
	// to.
	//
	// This member is required.
	MembershipArn *string

	// The unique ID for the membership that the configured table association belongs
	// to.
	//
	// This member is required.
	MembershipId *string

	// The name of the configured table association. The table is identified by this
	// name when running Protected Queries against the underlying data.
	//
	// This member is required.
	Name *string

	// The time the configured table association was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// The configured table summary for the objects listed by the request.
type ConfiguredTableSummary struct {

	// The analysis method for the configured tables. The only valid value is currently
	// `DIRECT_QUERY`.
	//
	// This member is required.
	AnalysisMethod AnalysisMethod

	// The types of analysis rules associated with this configured table.
	//
	// This member is required.
	AnalysisRuleTypes []ConfiguredTableAnalysisRuleType

	// The unique ARN of the configured table.
	//
	// This member is required.
	Arn *string

	// The time the configured table was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID of the configured table.
	//
	// This member is required.
	Id *string

	// The name of the configured table.
	//
	// This member is required.
	Name *string

	// The time the configured table was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// The settings for client-side encryption for cryptographic computing.
type DataEncryptionMetadata struct {

	// Indicates whether encrypted tables can contain cleartext data (true) or are to
	// cryptographically process every column (false).
	//
	// This member is required.
	AllowCleartext *bool

	// Indicates whether Fingerprint columns can contain duplicate entries (true) or
	// are to contain only non-repeated values (false).
	//
	// This member is required.
	AllowDuplicates *bool

	// Indicates whether Fingerprint columns can be joined on any other Fingerprint
	// column with a different name (true) or can only be joined on Fingerprint columns
	// of the same name (false).
	//
	// This member is required.
	AllowJoinsOnColumnsWithDifferentNames *bool

	// Indicates whether NULL values are to be copied as NULL to encrypted tables
	// (true) or cryptographically processed (false).
	//
	// This member is required.
	PreserveNulls *bool

	noSmithyDocumentSerde
}

// A reference to a table within an AWS Glue data catalog.
type GlueTableReference struct {

	// The name of the database the AWS Glue table belongs to.
	//
	// This member is required.
	DatabaseName *string

	// The name of the AWS Glue table.
	//
	// This member is required.
	TableName *string

	noSmithyDocumentSerde
}

// The membership object.
type Membership struct {

	// The unique ARN for the membership.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the membership's associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// The identifier used to reference members of the collaboration. Currently only
	// supports AWS account ID.
	//
	// This member is required.
	CollaborationCreatorAccountId *string

	// The display name of the collaboration creator.
	//
	// This member is required.
	CollaborationCreatorDisplayName *string

	// The unique ID for the membership's collaboration.
	//
	// This member is required.
	CollaborationId *string

	// The name of the membership's collaboration.
	//
	// This member is required.
	CollaborationName *string

	// The time when the membership was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID of the membership.
	//
	// This member is required.
	Id *string

	// The abilities granted to the collaboration member.
	//
	// This member is required.
	MemberAbilities []MemberAbility

	// An indicator as to whether query logging has been enabled or disabled for the
	// collaboration.
	//
	// This member is required.
	QueryLogStatus MembershipQueryLogStatus

	// The status of the membership. Valid values are `ACTIVE`, `REMOVED`, and
	// `COLLABORATION_DELETED`.
	//
	// This member is required.
	Status MembershipStatus

	// The time the membership metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// The membership object listed by the request.
type MembershipSummary struct {

	// The unique ARN for the membership.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the membership's associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// The identifier of the AWS principal that created the collaboration. Currently
	// only supports AWS account ID.
	//
	// This member is required.
	CollaborationCreatorAccountId *string

	// The display name of the collaboration creator.
	//
	// This member is required.
	CollaborationCreatorDisplayName *string

	// The unique ID for the membership's collaboration.
	//
	// This member is required.
	CollaborationId *string

	// The name for the membership's collaboration.
	//
	// This member is required.
	CollaborationName *string

	// The time when the membership was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID for the membership's collaboration.
	//
	// This member is required.
	Id *string

	// The abilities granted to the collaboration member.
	//
	// This member is required.
	MemberAbilities []MemberAbility

	// The status of the membership. Valid values are `ACTIVE`, `REMOVED`, and
	// `COLLABORATION_DELETED`.
	//
	// This member is required.
	Status MembershipStatus

	// The time the membership metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Basic metadata used to construct a new member.
type MemberSpecification struct {

	// The identifier used to reference members of the collaboration. Currently only
	// supports AWS Account ID.
	//
	// This member is required.
	AccountId *string

	// The member's display name.
	//
	// This member is required.
	DisplayName *string

	// The abilities granted to the collaboration member.
	//
	// This member is required.
	MemberAbilities []MemberAbility

	noSmithyDocumentSerde
}

// The member object listed by the request.
type MemberSummary struct {

	// The abilities granted to the collaboration member.
	//
	// This member is required.
	Abilities []MemberAbility

	// The identifier used to reference members of the collaboration. Currently only
	// supports AWS Account ID.
	//
	// This member is required.
	AccountId *string

	// The time when the member was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The member's display name.
	//
	// This member is required.
	DisplayName *string

	// The status of the member. Valid values are `INVITED`, `ACTIVE`, `LEFT`, and
	// `REMOVED`.
	//
	// This member is required.
	Status MemberStatus

	// The time the member metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The unique ARN for the member's associated membership, if present.
	MembershipArn *string

	// The unique ID for the member's associated membership, if present.
	MembershipId *string

	noSmithyDocumentSerde
}

// The parameters for an AWS Clean Rooms protected query.
type ProtectedQuery struct {

	// The time at which the protected query was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier for a protected query instance.
	//
	// This member is required.
	Id *string

	// The ARN of the membership.
	//
	// This member is required.
	MembershipArn *string

	// The identifier for the membership.
	//
	// This member is required.
	MembershipId *string

	// Contains any details needed to write the query results.
	//
	// This member is required.
	ResultConfiguration *ProtectedQueryResultConfiguration

	// The protected query SQL parameters.
	//
	// This member is required.
	SqlParameters *ProtectedQuerySQLParameters

	// The status of the query.
	//
	// This member is required.
	Status ProtectedQueryStatus

	// An error thrown by the protected query.
	Error *ProtectedQueryError

	// The result of the protected query.
	Result *ProtectedQueryResult

	// Statistics about protected query execution.
	Statistics *ProtectedQueryStatistics

	noSmithyDocumentSerde
}

// Details of errors thrown by the protected query.
type ProtectedQueryError struct {

	// An error code for the error.
	//
	// This member is required.
	Code *string

	// A description of why the query failed.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// Contains details about the protected query output.
//
// The following types satisfy this interface:
//
//	ProtectedQueryOutputMemberS3
type ProtectedQueryOutput interface {
	isProtectedQueryOutput()
}

// If present, the output for a protected query with an `S3` output type.
type ProtectedQueryOutputMemberS3 struct {
	Value ProtectedQueryS3Output

	noSmithyDocumentSerde
}

func (*ProtectedQueryOutputMemberS3) isProtectedQueryOutput() {}

// Contains configuration details for protected query output.
//
// The following types satisfy this interface:
//
//	ProtectedQueryOutputConfigurationMemberS3
type ProtectedQueryOutputConfiguration interface {
	isProtectedQueryOutputConfiguration()
}

// Required configuration for a protected query with an `S3` output type.
type ProtectedQueryOutputConfigurationMemberS3 struct {
	Value ProtectedQueryS3OutputConfiguration

	noSmithyDocumentSerde
}

func (*ProtectedQueryOutputConfigurationMemberS3) isProtectedQueryOutputConfiguration() {}

// Details about the query results.
type ProtectedQueryResult struct {

	// The output of the protected query.
	//
	// This member is required.
	Output ProtectedQueryOutput

	noSmithyDocumentSerde
}

// Contains configurations for protected query results.
type ProtectedQueryResultConfiguration struct {

	// Configuration for protected query results.
	//
	// This member is required.
	OutputConfiguration ProtectedQueryOutputConfiguration

	noSmithyDocumentSerde
}

// Contains output information for protected queries with an S3 output type.
type ProtectedQueryS3Output struct {

	// The S3 location of the result.
	//
	// This member is required.
	Location *string

	noSmithyDocumentSerde
}

// Contains the configuration to write the query results to S3.
type ProtectedQueryS3OutputConfiguration struct {

	// The S3 bucket to unload the protected query results.
	//
	// This member is required.
	Bucket *string

	// Intended file format of the result.
	//
	// This member is required.
	ResultFormat ResultFormat

	// The S3 prefix to unload the protected query results.
	KeyPrefix *string

	noSmithyDocumentSerde
}

// The parameters for the SQL type Protected Query.
type ProtectedQuerySQLParameters struct {

	// The query string to be submitted.
	//
	// This member is required.
	QueryString *string

	noSmithyDocumentSerde
}

// Contains statistics about the execution of the protected query.
type ProtectedQueryStatistics struct {

	// The duration of the Protected Query, from creation until query completion.
	TotalDurationInMillis *int64

	noSmithyDocumentSerde
}

// The protected query summary for the objects listed by the request.
type ProtectedQuerySummary struct {

	// The time the protected query was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID of the protected query.
	//
	// This member is required.
	Id *string

	// The unique ARN for the membership that initiated the protected query.
	//
	// This member is required.
	MembershipArn *string

	// The unique ID for the membership that initiated the protected query.
	//
	// This member is required.
	MembershipId *string

	// The status of the protected query. Value values are `SUBMITTED`, `STARTED`,
	// `CANCELLED`, `CANCELLING`, `FAILED`, `SUCCESS`, `TIMED_OUT`.
	//
	// This member is required.
	Status ProtectedQueryStatus

	noSmithyDocumentSerde
}

// A schema is a relation within a collaboration.
type Schema struct {

	// The analysis rule types associated with the schema. Valued values are LIST and
	// AGGREGATION. Currently, only one entry is present.
	//
	// This member is required.
	AnalysisRuleTypes []AnalysisRuleType

	// The unique ARN for the collaboration that the schema belongs to.
	//
	// This member is required.
	CollaborationArn *string

	// The unique ID for the collaboration that the schema belongs to.
	//
	// This member is required.
	CollaborationId *string

	// The columns for the relation this schema represents.
	//
	// This member is required.
	Columns []Column

	// The time the schema was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique account ID for the AWS account that owns the schema.
	//
	// This member is required.
	CreatorAccountId *string

	// A description for the schema.
	//
	// This member is required.
	Description *string

	// A name for the schema. The schema relation is referred to by this name when
	// queried by a protected query.
	//
	// This member is required.
	Name *string

	// The partition keys for the data set underlying this schema.
	//
	// This member is required.
	PartitionKeys []Column

	// The type of schema. The only valid value is currently `TABLE`.
	//
	// This member is required.
	Type SchemaType

	// The time the schema was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The analysis method for the schema. The only valid value is currently
	// DIRECT_QUERY.
	AnalysisMethod AnalysisMethod

	noSmithyDocumentSerde
}

// The schema summary for the objects listed by the request.
type SchemaSummary struct {

	// The types of analysis rules that are associated with this schema object.
	//
	// This member is required.
	AnalysisRuleTypes []AnalysisRuleType

	// The unique ARN for the collaboration that the schema belongs to.
	//
	// This member is required.
	CollaborationArn *string

	// The unique ID for the collaboration that the schema belongs to.
	//
	// This member is required.
	CollaborationId *string

	// The time the schema object was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique account ID for the AWS account that owns the schema.
	//
	// This member is required.
	CreatorAccountId *string

	// The name for the schema object.
	//
	// This member is required.
	Name *string

	// The type of schema object. The only valid schema type is currently `TABLE`.
	//
	// This member is required.
	Type SchemaType

	// The time the schema object was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The analysis method for the associated schema. The only valid value is currently
	// `DIRECT_QUERY`.
	AnalysisMethod AnalysisMethod

	noSmithyDocumentSerde
}

// A pointer to the data set that underlies this table. Currently, this can only be
// an AWS Glue table.
//
// The following types satisfy this interface:
//
//	TableReferenceMemberGlue
type TableReference interface {
	isTableReference()
}

// If present, a reference to the AWS Glue table referred to by this table
// reference.
type TableReferenceMemberGlue struct {
	Value GlueTableReference

	noSmithyDocumentSerde
}

func (*TableReferenceMemberGlue) isTableReference() {}

// Describes validation errors for specific input parameters.
type ValidationExceptionField struct {

	// A message for the input validation error.
	//
	// This member is required.
	Message *string

	// The name of the input parameter.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAnalysisRulePolicy()                  {}
func (*UnknownUnionMember) isAnalysisRulePolicyV1()                {}
func (*UnknownUnionMember) isConfiguredTableAnalysisRulePolicy()   {}
func (*UnknownUnionMember) isConfiguredTableAnalysisRulePolicyV1() {}
func (*UnknownUnionMember) isProtectedQueryOutput()                {}
func (*UnknownUnionMember) isProtectedQueryOutputConfiguration()   {}
func (*UnknownUnionMember) isTableReference()                      {}
