// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An address book with attributes.
type AddressBook struct {

	// The ARN of the address book.
	AddressBookArn *string

	// The description of the address book.
	Description *string

	// The name of the address book.
	Name *string

	noSmithyDocumentSerde
}

// Information related to an address book.
type AddressBookData struct {

	// The ARN of the address book.
	AddressBookArn *string

	// The description of the address book.
	Description *string

	// The name of the address book.
	Name *string

	noSmithyDocumentSerde
}

// The audio message. There is a 1 MB limit on the audio file input and the only
// supported format is MP3. To convert your MP3 audio files to an Alexa-friendly,
// required codec version (MPEG version 2) and bit rate (48 kbps), you might use
// converter software. One option for this is a command-line tool, FFmpeg. For more
// information, see FFmpeg (https://www.ffmpeg.org/). The following command
// converts the provided to an MP3 file that is played in the announcement: ffmpeg
// -i -ac 2 -codec:a libmp3lame -b:a 48k -ar 16000
type Audio struct {

	// The locale of the audio message. Currently, en-US is supported.
	//
	// This member is required.
	Locale Locale

	// The location of the audio file. Currently, S3 URLs are supported. Only S3
	// locations comprised of safe characters are valid. For more information, see Safe
	// Characters
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#Safe%20Characters).
	//
	// This member is required.
	Location *string

	noSmithyDocumentSerde
}

// Usage report with specified parameters.
type BusinessReport struct {

	// The time of report delivery.
	DeliveryTime *time.Time

	// The download link where a user can download the report.
	DownloadUrl *string

	// The failure code.
	FailureCode BusinessReportFailureCode

	// The S3 location of the output reports.
	S3Location *BusinessReportS3Location

	// The status of the report generation execution (RUNNING, SUCCEEDED, or FAILED).
	Status BusinessReportStatus

	noSmithyDocumentSerde
}

// The content range of the report.
type BusinessReportContentRange struct {

	// The interval of the content range.
	//
	// This member is required.
	Interval BusinessReportInterval

	noSmithyDocumentSerde
}

// The recurrence of the reports.
type BusinessReportRecurrence struct {

	// The start date.
	StartDate *string

	noSmithyDocumentSerde
}

// The S3 location of the output reports.
type BusinessReportS3Location struct {

	// The S3 bucket name of the output reports.
	BucketName *string

	// The path of the business report.
	Path *string

	noSmithyDocumentSerde
}

// The schedule of the usage report.
type BusinessReportSchedule struct {

	// The content range of the reports.
	ContentRange *BusinessReportContentRange

	// The format of the generated report (individual CSV files or zipped files of
	// individual files).
	Format BusinessReportFormat

	// The details of the last business report delivery for a specified time interval.
	LastBusinessReport *BusinessReport

	// The recurrence of the reports.
	Recurrence *BusinessReportRecurrence

	// The S3 bucket name of the output reports.
	S3BucketName *string

	// The S3 key where the report is delivered.
	S3KeyPrefix *string

	// The ARN of the business report schedule.
	ScheduleArn *string

	// The name identifier of the schedule.
	ScheduleName *string

	noSmithyDocumentSerde
}

// The skill store category that is shown. Alexa skills are assigned a specific
// skill category during creation, such as News, Social, and Sports.
type Category struct {

	// The ID of the skill store category.
	CategoryId *int64

	// The name of the skill store category.
	CategoryName *string

	noSmithyDocumentSerde
}

// The default conference provider that is used if no other scheduled meetings are
// detected.
type ConferencePreference struct {

	// The ARN of the default conference provider.
	DefaultConferenceProviderArn *string

	noSmithyDocumentSerde
}

// An entity that provides a conferencing solution. Alexa for Business acts as the
// voice interface and mediator that connects users to their preferred conference
// provider. Examples of conference providers include Amazon Chime, Zoom, Cisco,
// and Polycom.
type ConferenceProvider struct {

	// The ARN of the newly created conference provider.
	Arn *string

	// The IP endpoint and protocol for calling.
	IPDialIn *IPDialIn

	// The meeting settings for the conference provider.
	MeetingSetting *MeetingSetting

	// The name of the conference provider.
	Name *string

	// The information for PSTN conferencing.
	PSTNDialIn *PSTNDialIn

	// The type of conference providers.
	Type ConferenceProviderType

	noSmithyDocumentSerde
}

// A contact with attributes.
type Contact struct {

	// The ARN of the contact.
	ContactArn *string

	// The name of the contact to display on the console.
	DisplayName *string

	// The first name of the contact, used to call the contact on the device.
	FirstName *string

	// The last name of the contact, used to call the contact on the device.
	LastName *string

	// The phone number of the contact. The phone number type defaults to WORK. You can
	// either specify PhoneNumber or PhoneNumbers. We recommend that you use
	// PhoneNumbers, which lets you specify the phone number type and multiple numbers.
	PhoneNumber *string

	// The list of phone numbers for the contact.
	PhoneNumbers []PhoneNumber

	// The list of SIP addresses for the contact.
	SipAddresses []SipAddress

	noSmithyDocumentSerde
}

// Information related to a contact.
type ContactData struct {

	// The ARN of the contact.
	ContactArn *string

	// The name of the contact to display on the console.
	DisplayName *string

	// The first name of the contact, used to call the contact on the device.
	FirstName *string

	// The last name of the contact, used to call the contact on the device.
	LastName *string

	// The phone number of the contact. The phone number type defaults to WORK. You can
	// specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers,
	// which lets you specify the phone number type and multiple numbers.
	PhoneNumber *string

	// The list of phone numbers for the contact.
	PhoneNumbers []PhoneNumber

	// The list of SIP addresses for the contact.
	SipAddresses []SipAddress

	noSmithyDocumentSerde
}

// The content definition. This can contain only one text, SSML, or audio list
// object.
type Content struct {

	// The list of audio messages.
	AudioList []Audio

	// The list of SSML messages.
	SsmlList []Ssml

	// The list of text messages.
	TextList []Text

	noSmithyDocumentSerde
}

// Creates settings for the end of meeting reminder feature that are applied to a
// room profile. The end of meeting reminder enables Alexa to remind users when a
// meeting is ending.
type CreateEndOfMeetingReminder struct {

	// Whether an end of meeting reminder is enabled or not.
	//
	// This member is required.
	Enabled *bool

	// A range of 3 to 15 minutes that determines when the reminder begins.
	//
	// This member is required.
	ReminderAtMinutes []int32

	// The type of sound that users hear during the end of meeting reminder.
	//
	// This member is required.
	ReminderType EndOfMeetingReminderType

	noSmithyDocumentSerde
}

// Creates settings for the instant booking feature that are applied to a room
// profile. When users start their meeting with Alexa, Alexa automatically books
// the room for the configured duration if the room is available.
type CreateInstantBooking struct {

	// Duration between 15 and 240 minutes at increments of 15 that determines how long
	// to book an available room when a meeting is started with Alexa.
	//
	// This member is required.
	DurationInMinutes *int32

	// Whether instant booking is enabled or not.
	//
	// This member is required.
	Enabled *bool

	noSmithyDocumentSerde
}

// Creates meeting room settings of a room profile.
type CreateMeetingRoomConfiguration struct {

	// Creates settings for the end of meeting reminder feature that are applied to a
	// room profile. The end of meeting reminder enables Alexa to remind users when a
	// meeting is ending.
	EndOfMeetingReminder *CreateEndOfMeetingReminder

	// Settings to automatically book a room for a configured duration if it's free
	// when joining a meeting with Alexa.
	InstantBooking *CreateInstantBooking

	// Settings for requiring a check in when a room is reserved. Alexa can cancel a
	// room reservation if it's not checked into to make the room available for others.
	// Users can check in by joining the meeting with Alexa or an AVS device, or by
	// saying “Alexa, check in.”
	RequireCheckIn *CreateRequireCheckIn

	// Whether room utilization metrics are enabled or not.
	RoomUtilizationMetricsEnabled *bool

	noSmithyDocumentSerde
}

// Creates settings for the require check in feature that are applied to a room
// profile. Require check in allows a meeting room’s Alexa or AVS device to prompt
// the user to check in; otherwise, the room will be released.
type CreateRequireCheckIn struct {

	// Whether require check in is enabled or not.
	//
	// This member is required.
	Enabled *bool

	// Duration between 5 and 20 minutes to determine when to release the room if it's
	// not checked into.
	//
	// This member is required.
	ReleaseAfterMinutes *int32

	noSmithyDocumentSerde
}

// The details about the developer that published the skill.
type DeveloperInfo struct {

	// The name of the developer.
	DeveloperName *string

	// The email of the developer.
	Email *string

	// The URL of the privacy policy.
	PrivacyPolicy *string

	// The website of the developer.
	Url *string

	noSmithyDocumentSerde
}

// A device with attributes.
type Device struct {

	// The ARN of a device.
	DeviceArn *string

	// The name of a device.
	DeviceName *string

	// The serial number of a device.
	DeviceSerialNumber *string

	// The status of a device. If the status is not READY, check the DeviceStatusInfo
	// value for details.
	DeviceStatus DeviceStatus

	// Detailed information about a device's status.
	DeviceStatusInfo *DeviceStatusInfo

	// The type of a device.
	DeviceType *string

	// The MAC address of a device.
	MacAddress *string

	// Detailed information about a device's network profile.
	NetworkProfileInfo *DeviceNetworkProfileInfo

	// The room ARN of a device.
	RoomArn *string

	// The software version of a device.
	SoftwareVersion *string

	noSmithyDocumentSerde
}

// Device attributes.
type DeviceData struct {

	// The time (in epoch) when the device data was created.
	CreatedTime *time.Time

	// The ARN of a device.
	DeviceArn *string

	// The name of a device.
	DeviceName *string

	// The serial number of a device.
	DeviceSerialNumber *string

	// The status of a device.
	DeviceStatus DeviceStatus

	// Detailed information about a device's status.
	DeviceStatusInfo *DeviceStatusInfo

	// The type of a device.
	DeviceType *string

	// The MAC address of a device.
	MacAddress *string

	// The ARN of the network profile associated with a device.
	NetworkProfileArn *string

	// The name of the network profile associated with a device.
	NetworkProfileName *string

	// The room ARN associated with a device.
	RoomArn *string

	// The name of the room associated with a device.
	RoomName *string

	// The software version of a device.
	SoftwareVersion *string

	noSmithyDocumentSerde
}

// The list of device events.
type DeviceEvent struct {

	// The time (in epoch) when the event occurred.
	Timestamp *time.Time

	// The type of device event.
	Type DeviceEventType

	// The value of the event.
	Value *string

	noSmithyDocumentSerde
}

// Detailed information about a device's network profile.
type DeviceNetworkProfileInfo struct {

	// The ARN of the certificate associated with a device.
	CertificateArn *string

	// The time (in epoch) when the certificate expires.
	CertificateExpirationTime *time.Time

	// The ARN of the network profile associated with a device.
	NetworkProfileArn *string

	noSmithyDocumentSerde
}

// Details of a device’s status.
type DeviceStatusDetail struct {

	// The device status detail code.
	Code DeviceStatusDetailCode

	// The list of available features on the device.
	Feature Feature

	noSmithyDocumentSerde
}

// Detailed information about a device's status.
type DeviceStatusInfo struct {

	// The latest available information about the connection status of a device.
	ConnectionStatus ConnectionStatus

	// The time (in epoch) when the device connection status changed.
	ConnectionStatusUpdatedTime *time.Time

	// One or more device status detail descriptions.
	DeviceStatusDetails []DeviceStatusDetail

	noSmithyDocumentSerde
}

// Settings for the end of meeting reminder feature that are applied to a room
// profile. The end of meeting reminder enables Alexa to remind users when a
// meeting is ending.
type EndOfMeetingReminder struct {

	// Whether an end of meeting reminder is enabled or not.
	Enabled *bool

	// A range of 3 to 15 minutes that determines when the reminder begins.
	ReminderAtMinutes []int32

	// The type of sound that users hear during the end of meeting reminder.
	ReminderType EndOfMeetingReminderType

	noSmithyDocumentSerde
}

// A filter name and value pair that is used to return a more specific list of
// results. Filters can be used to match a set of resources by various criteria.
type Filter struct {

	// The key of a filter.
	//
	// This member is required.
	Key *string

	// The values of a filter.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The details of the gateway.
type Gateway struct {

	// The ARN of the gateway.
	Arn *string

	// The description of the gateway.
	Description *string

	// The ARN of the gateway group that the gateway is associated to.
	GatewayGroupArn *string

	// The name of the gateway.
	Name *string

	// The software version of the gateway. The gateway automatically updates its
	// software version during normal operation.
	SoftwareVersion *string

	noSmithyDocumentSerde
}

// The details of the gateway group.
type GatewayGroup struct {

	// The ARN of the gateway group.
	Arn *string

	// The description of the gateway group.
	Description *string

	// The name of the gateway group.
	Name *string

	noSmithyDocumentSerde
}

// The summary of a gateway group.
type GatewayGroupSummary struct {

	// The ARN of the gateway group.
	Arn *string

	// The description of the gateway group.
	Description *string

	// The name of the gateway group.
	Name *string

	noSmithyDocumentSerde
}

// The summary of a gateway.
type GatewaySummary struct {

	// The ARN of the gateway.
	Arn *string

	// The description of the gateway.
	Description *string

	// The ARN of the gateway group that the gateway is associated to.
	GatewayGroupArn *string

	// The name of the gateway.
	Name *string

	// The software version of the gateway. The gateway automatically updates its
	// software version during normal operation.
	SoftwareVersion *string

	noSmithyDocumentSerde
}

// Settings for the instant booking feature that are applied to a room profile.
// When users start their meeting with Alexa, Alexa automatically books the room
// for the configured duration if the room is available.
type InstantBooking struct {

	// Duration between 15 and 240 minutes at increments of 15 that determines how long
	// to book an available room when a meeting is started with Alexa.
	DurationInMinutes *int32

	// Whether instant booking is enabled or not.
	Enabled *bool

	noSmithyDocumentSerde
}

// The IP endpoint and protocol for calling.
type IPDialIn struct {

	// The protocol, including SIP, SIPS, and H323.
	//
	// This member is required.
	CommsProtocol CommsProtocol

	// The IP address.
	//
	// This member is required.
	Endpoint *string

	noSmithyDocumentSerde
}

// Meeting room settings of a room profile.
type MeetingRoomConfiguration struct {

	// Settings for the end of meeting reminder feature that are applied to a room
	// profile. The end of meeting reminder enables Alexa to remind users when a
	// meeting is ending.
	EndOfMeetingReminder *EndOfMeetingReminder

	// Settings to automatically book the room if available for a configured duration
	// when joining a meeting with Alexa.
	InstantBooking *InstantBooking

	// Settings for requiring a check in when a room is reserved. Alexa can cancel a
	// room reservation if it's not checked into. This makes the room available for
	// others. Users can check in by joining the meeting with Alexa or an AVS device,
	// or by saying “Alexa, check in.”
	RequireCheckIn *RequireCheckIn

	// Whether room utilization metrics are enabled or not.
	RoomUtilizationMetricsEnabled *bool

	noSmithyDocumentSerde
}

// The values that indicate whether a pin is always required (YES), never required
// (NO), or OPTIONAL.
//
// * If YES, Alexa will always ask for a meeting pin.
//
// * If NO,
// Alexa will never ask for a meeting pin.
//
// * If OPTIONAL, Alexa will ask if you
// have a meeting pin and if the customer responds with yes, it will ask for the
// meeting pin.
type MeetingSetting struct {

	// The values that indicate whether the pin is always required.
	//
	// This member is required.
	RequirePin RequirePin

	noSmithyDocumentSerde
}

// The network profile associated with a device.
type NetworkProfile struct {

	// The ARN of the Private Certificate Authority (PCA) created in AWS Certificate
	// Manager (ACM). This is used to issue certificates to the devices.
	CertificateAuthorityArn *string

	// The current password of the Wi-Fi network.
	CurrentPassword *string

	// Detailed information about a device's network profile.
	Description *string

	// The authentication standard that is used in the EAP framework. Currently,
	// EAP_TLS is supported.
	EapMethod NetworkEapMethod

	// The ARN of the network profile associated with a device.
	NetworkProfileArn *string

	// The name of the network profile associated with a device.
	NetworkProfileName *string

	// The next, or subsequent, password of the Wi-Fi network. This password is
	// asynchronously transmitted to the device and is used when the password of the
	// network changes to NextPassword.
	NextPassword *string

	// The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK,
	// WPA_PSK, WEP, or OPEN.
	SecurityType NetworkSecurityType

	// The SSID of the Wi-Fi network.
	Ssid *string

	// The root certificates of your authentication server, which is installed on your
	// devices and used to trust your authentication server during EAP negotiation.
	TrustAnchors []string

	noSmithyDocumentSerde
}

// The data associated with a network profile.
type NetworkProfileData struct {

	// The ARN of the Private Certificate Authority (PCA) created in AWS Certificate
	// Manager (ACM). This is used to issue certificates to the devices.
	CertificateAuthorityArn *string

	// Detailed information about a device's network profile.
	Description *string

	// The authentication standard that is used in the EAP framework. Currently,
	// EAP_TLS is supported.
	EapMethod NetworkEapMethod

	// The ARN of the network profile associated with a device.
	NetworkProfileArn *string

	// The name of the network profile associated with a device.
	NetworkProfileName *string

	// The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK,
	// WPA_PSK, WEP, or OPEN.
	SecurityType NetworkSecurityType

	// The SSID of the Wi-Fi network.
	Ssid *string

	noSmithyDocumentSerde
}

// The phone number for the contact containing the raw number and phone number
// type.
type PhoneNumber struct {

	// The raw value of the phone number.
	//
	// This member is required.
	Number *string

	// The type of the phone number.
	//
	// This member is required.
	Type PhoneNumberType

	noSmithyDocumentSerde
}

// A room profile with attributes.
type Profile struct {

	// The address of a room profile.
	Address *string

	// The ARN of the address book.
	AddressBookArn *string

	// Whether data retention of the profile is enabled.
	DataRetentionOptIn *bool

	// The distance unit of a room profile.
	DistanceUnit DistanceUnit

	// Retrieves if the profile is default or not.
	IsDefault *bool

	// The locale of a room profile. (This is currently available only to a limited
	// preview audience.)
	Locale *string

	// The max volume limit of a room profile.
	MaxVolumeLimit *int32

	// Meeting room settings of a room profile.
	MeetingRoomConfiguration *MeetingRoomConfiguration

	// The PSTN setting of a room profile.
	PSTNEnabled *bool

	// The ARN of a room profile.
	ProfileArn *string

	// The name of a room profile.
	ProfileName *string

	// The setup mode of a room profile.
	SetupModeDisabled *bool

	// The temperature unit of a room profile.
	TemperatureUnit TemperatureUnit

	// The time zone of a room profile.
	Timezone *string

	// The wake word of a room profile.
	WakeWord WakeWord

	noSmithyDocumentSerde
}

// The data of a room profile.
type ProfileData struct {

	// The address of a room profile.
	Address *string

	// The distance unit of a room profile.
	DistanceUnit DistanceUnit

	// Retrieves if the profile data is default or not.
	IsDefault *bool

	// The locale of a room profile. (This is currently available only to a limited
	// preview audience.)
	Locale *string

	// The ARN of a room profile.
	ProfileArn *string

	// The name of a room profile.
	ProfileName *string

	// The temperature unit of a room profile.
	TemperatureUnit TemperatureUnit

	// The time zone of a room profile.
	Timezone *string

	// The wake word of a room profile.
	WakeWord WakeWord

	noSmithyDocumentSerde
}

// The information for public switched telephone network (PSTN) conferencing.
type PSTNDialIn struct {

	// The zip code.
	//
	// This member is required.
	CountryCode *string

	// The delay duration before Alexa enters the conference ID with dual-tone
	// multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone,
	// which is how we send data over the telephone network.
	//
	// This member is required.
	OneClickIdDelay *string

	// The delay duration before Alexa enters the conference pin with dual-tone
	// multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone,
	// which is how we send data over the telephone network.
	//
	// This member is required.
	OneClickPinDelay *string

	// The phone number to call to join the conference.
	//
	// This member is required.
	PhoneNumber *string

	noSmithyDocumentSerde
}

// Settings for the require check in feature that are applied to a room profile.
// Require check in allows a meeting room’s Alexa or AVS device to prompt the user
// to check in; otherwise, the room will be released.
type RequireCheckIn struct {

	// Whether require check in is enabled or not.
	Enabled *bool

	// Duration between 5 and 20 minutes to determine when to release the room if it's
	// not checked into.
	ReleaseAfterMinutes *int32

	noSmithyDocumentSerde
}

// A room with attributes.
type Room struct {

	// The description of a room.
	Description *string

	// The profile ARN of a room.
	ProfileArn *string

	// The provider calendar ARN of a room.
	ProviderCalendarId *string

	// The ARN of a room.
	RoomArn *string

	// The name of a room.
	RoomName *string

	noSmithyDocumentSerde
}

// The data of a room.
type RoomData struct {

	// The description of a room.
	Description *string

	// The profile ARN of a room.
	ProfileArn *string

	// The profile name of a room.
	ProfileName *string

	// The provider calendar ARN of a room.
	ProviderCalendarId *string

	// The ARN of a room.
	RoomArn *string

	// The name of a room.
	RoomName *string

	noSmithyDocumentSerde
}

// A skill parameter associated with a room.
type RoomSkillParameter struct {

	// The parameter key of a room skill parameter. ParameterKey is an enumerated type
	// that only takes “DEFAULT” or “SCOPE” as valid values.
	//
	// This member is required.
	ParameterKey *string

	// The parameter value of a room skill parameter.
	//
	// This member is required.
	ParameterValue *string

	noSmithyDocumentSerde
}

// The SIP address for the contact containing the URI and SIP address type.
type SipAddress struct {

	// The type of the SIP address.
	//
	// This member is required.
	Type SipType

	// The URI for the SIP address.
	//
	// This member is required.
	Uri *string

	noSmithyDocumentSerde
}

// Granular information about the skill.
type SkillDetails struct {

	// The details about what the skill supports organized as bullet points.
	BulletPoints []string

	// The details about the developer that published the skill.
	DeveloperInfo *DeveloperInfo

	// The URL of the end user license agreement.
	EndUserLicenseAgreement *string

	// The generic keywords associated with the skill that can be used to find a skill.
	GenericKeywords []string

	// The phrase used to trigger the skill.
	InvocationPhrase *string

	// The updates added in bullet points.
	NewInThisVersionBulletPoints []string

	// The description of the product.
	ProductDescription *string

	// The date when the skill was released.
	ReleaseDate *string

	// This member has been deprecated. The list of reviews for the skill, including
	// Key and Value pair.
	Reviews map[string]string

	// The types of skills.
	SkillTypes []string

	noSmithyDocumentSerde
}

// A skill group with attributes.
type SkillGroup struct {

	// The description of a skill group.
	Description *string

	// The ARN of a skill group.
	SkillGroupArn *string

	// The name of a skill group.
	SkillGroupName *string

	noSmithyDocumentSerde
}

// The attributes of a skill group.
type SkillGroupData struct {

	// The description of a skill group.
	Description *string

	// The skill group ARN of a skill group.
	SkillGroupArn *string

	// The skill group name of a skill group.
	SkillGroupName *string

	noSmithyDocumentSerde
}

// The detailed information about an Alexa skill.
type SkillsStoreSkill struct {

	// The URL where the skill icon resides.
	IconUrl *string

	// Sample utterances that interact with the skill.
	SampleUtterances []string

	// Short description about the skill.
	ShortDescription *string

	// Information about the skill.
	SkillDetails *SkillDetails

	// The ARN of the skill.
	SkillId *string

	// The name of the skill.
	SkillName *string

	// Linking support for a skill.
	SupportsLinking bool

	noSmithyDocumentSerde
}

// The summary of skills.
type SkillSummary struct {

	// Whether the skill is enabled under the user's account, or if it requires linking
	// to be used.
	EnablementType EnablementType

	// The ARN of the skill summary.
	SkillId *string

	// The name of the skill.
	SkillName *string

	// Whether the skill is publicly available or is a private skill.
	SkillType SkillType

	// Linking support for a skill.
	SupportsLinking bool

	noSmithyDocumentSerde
}

// A smart home appliance that can connect to a central system. Any domestic device
// can be a smart appliance.
type SmartHomeAppliance struct {

	// The description of the smart home appliance.
	Description *string

	// The friendly name of the smart home appliance.
	FriendlyName *string

	// The name of the manufacturer of the smart home appliance.
	ManufacturerName *string

	noSmithyDocumentSerde
}

// An object representing a sort criteria.
type Sort struct {

	// The sort key of a sort object.
	//
	// This member is required.
	Key *string

	// The sort value of a sort object.
	//
	// This member is required.
	Value SortValue

	noSmithyDocumentSerde
}

// The SSML message. For more information, see SSML Reference
// (https://developer.amazon.com/docs/custom-skills/speech-synthesis-markup-language-ssml-reference.html).
type Ssml struct {

	// The locale of the SSML message. Currently, en-US is supported.
	//
	// This member is required.
	Locale Locale

	// The value of the SSML message in the correct SSML format. The audio tag is not
	// supported.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A key-value pair that can be associated with a resource.
type Tag struct {

	// The key of a tag. Tag keys are case-sensitive.
	//
	// This member is required.
	Key *string

	// The value of a tag. Tag values are case sensitive and can be null.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The text message.
type Text struct {

	// The locale of the text message. Currently, en-US is supported.
	//
	// This member is required.
	Locale Locale

	// The value of the text message.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Settings for the end of meeting reminder feature that are applied to a room
// profile. The end of meeting reminder enables Alexa to remind users when a
// meeting is ending.
type UpdateEndOfMeetingReminder struct {

	// Whether an end of meeting reminder is enabled or not.
	Enabled *bool

	// Updates settings for the end of meeting reminder feature that are applied to a
	// room profile. The end of meeting reminder enables Alexa to remind users when a
	// meeting is ending.
	ReminderAtMinutes []int32

	// The type of sound that users hear during the end of meeting reminder.
	ReminderType EndOfMeetingReminderType

	noSmithyDocumentSerde
}

// Updates settings for the instant booking feature that are applied to a room
// profile. If instant booking is enabled, Alexa automatically reserves a room if
// it is free when a user joins a meeting with Alexa.
type UpdateInstantBooking struct {

	// Duration between 15 and 240 minutes at increments of 15 that determines how long
	// to book an available room when a meeting is started with Alexa.
	DurationInMinutes *int32

	// Whether instant booking is enabled or not.
	Enabled *bool

	noSmithyDocumentSerde
}

// Updates meeting room settings of a room profile.
type UpdateMeetingRoomConfiguration struct {

	// Settings for the end of meeting reminder feature that are applied to a room
	// profile. The end of meeting reminder enables Alexa to remind users when a
	// meeting is ending.
	EndOfMeetingReminder *UpdateEndOfMeetingReminder

	// Settings to automatically book an available room available for a configured
	// duration when joining a meeting with Alexa.
	InstantBooking *UpdateInstantBooking

	// Settings for requiring a check in when a room is reserved. Alexa can cancel a
	// room reservation if it's not checked into to make the room available for others.
	// Users can check in by joining the meeting with Alexa or an AVS device, or by
	// saying “Alexa, check in.”
	RequireCheckIn *UpdateRequireCheckIn

	// Whether room utilization metrics are enabled or not.
	RoomUtilizationMetricsEnabled *bool

	noSmithyDocumentSerde
}

// Updates settings for the require check in feature that are applied to a room
// profile. Require check in allows a meeting room’s Alexa or AVS device to prompt
// the user to check in; otherwise, the room will be released.
type UpdateRequireCheckIn struct {

	// Whether require check in is enabled or not.
	Enabled *bool

	// Duration between 5 and 20 minutes to determine when to release the room if it's
	// not checked into.
	ReleaseAfterMinutes *int32

	noSmithyDocumentSerde
}

// Information related to a user.
type UserData struct {

	// The email of a user.
	Email *string

	// The enrollment ARN of a user.
	EnrollmentId *string

	// The enrollment status of a user.
	EnrollmentStatus EnrollmentStatus

	// The first name of a user.
	FirstName *string

	// The last name of a user.
	LastName *string

	// The ARN of a user.
	UserArn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
