// Code generated by smithy-go-codegen DO NOT EDIT.

package securitylake

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/securitylake/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Update the subscription notification for exception notification.
func (c *Client) UpdateDatalakeExceptionsSubscription(ctx context.Context, params *UpdateDatalakeExceptionsSubscriptionInput, optFns ...func(*Options)) (*UpdateDatalakeExceptionsSubscriptionOutput, error) {
	if params == nil {
		params = &UpdateDatalakeExceptionsSubscriptionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDatalakeExceptionsSubscription", params, optFns, c.addOperationUpdateDatalakeExceptionsSubscriptionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDatalakeExceptionsSubscriptionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDatalakeExceptionsSubscriptionInput struct {

	// The account which is subscribed to receive exception notifications.
	//
	// This member is required.
	NotificationEndpoint *string

	// The subscription protocol to which exception messages are posted.
	//
	// This member is required.
	SubscriptionProtocol types.SubscriptionProtocolType

	noSmithyDocumentSerde
}

type UpdateDatalakeExceptionsSubscriptionOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDatalakeExceptionsSubscriptionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateDatalakeExceptionsSubscription{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateDatalakeExceptionsSubscription{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateDatalakeExceptionsSubscriptionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDatalakeExceptionsSubscription(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDatalakeExceptionsSubscription(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "securitylake",
		OperationName: "UpdateDatalakeExceptionsSubscription",
	}
}
