// Code generated by smithy-go-codegen DO NOT EDIT.

package securitylake

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/securitylake/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Adds a third-party custom source in Amazon Security Lake, from the Region where
// you want to create a custom source. Security Lake can collect logs and events
// from third-party custom sources. After creating the appropriate API roles, use
// this API to add a custom source name in Security Lake. This operation creates a
// partition in the Security Lake S3 bucket as the target location for log files
// from the custom source, an associated Glue table, and an Glue crawler.
func (c *Client) CreateCustomLogSource(ctx context.Context, params *CreateCustomLogSourceInput, optFns ...func(*Options)) (*CreateCustomLogSourceOutput, error) {
	if params == nil {
		params = &CreateCustomLogSourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateCustomLogSource", params, optFns, c.addOperationCreateCustomLogSourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateCustomLogSourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateCustomLogSourceInput struct {

	// The custom source name for a third-party custom source.
	//
	// This member is required.
	CustomSourceName *string

	// The Open Cybersecurity Schema Framework (OCSF) event class.
	//
	// This member is required.
	EventClass types.OcsfEventClass

	// The IAM Role ARN to be used by the Glue Crawler. The recommended IAM policies
	// are:
	//
	// * The managed policy AWSGlueServiceRole
	//
	// * A custom policy granting access
	// to your S3 Data Lake
	//
	// This member is required.
	GlueInvocationRoleArn *string

	// The Account ID that will assume the above Role to put logs into the Data Lake.
	//
	// This member is required.
	LogProviderAccountId *string

	noSmithyDocumentSerde
}

type CreateCustomLogSourceOutput struct {

	// The location of the partition in the Security Lake S3 bucket.
	//
	// This member is required.
	CustomDataLocation *string

	// The name of the Glue crawler.
	//
	// This member is required.
	GlueCrawlerName *string

	// The Glue database where results are written, such as:
	// arn:aws:daylight:us-east-1::database/sometable/*.
	//
	// This member is required.
	GlueDatabaseName *string

	// The table name of the Glue crawler.
	//
	// This member is required.
	GlueTableName *string

	// IAM Role ARN to be used by the entity putting logs into your Custom Source
	// partition. Security Lake will apply the correct access policies to this Role,
	// but this Role must have the trust policy created manually. This Role's name must
	// start with the text 'Security Lake'. It must trust the logProviderAccountId to
	// assume it.
	//
	// This member is required.
	LogProviderAccessRoleArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateCustomLogSourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateCustomLogSource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateCustomLogSource{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateCustomLogSourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateCustomLogSource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateCustomLogSource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "securitylake",
		OperationName: "CreateCustomLogSource",
	}
}
