// Code generated by smithy-go-codegen DO NOT EDIT.

package rum

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/rum/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpBatchCreateRumMetricDefinitions struct {
}

func (*awsRestjson1_serializeOpBatchCreateRumMetricDefinitions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchCreateRumMetricDefinitions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchCreateRumMetricDefinitionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/rummetrics/{AppMonitorName}/metrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchCreateRumMetricDefinitionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchCreateRumMetricDefinitionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchCreateRumMetricDefinitionsInput(v *BatchCreateRumMetricDefinitionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppMonitorName == nil || len(*v.AppMonitorName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppMonitorName must not be empty")}
	}
	if v.AppMonitorName != nil {
		if err := encoder.SetURI("AppMonitorName").String(*v.AppMonitorName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchCreateRumMetricDefinitionsInput(v *BatchCreateRumMetricDefinitionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Destination) > 0 {
		ok := object.Key("Destination")
		ok.String(string(v.Destination))
	}

	if v.DestinationArn != nil {
		ok := object.Key("DestinationArn")
		ok.String(*v.DestinationArn)
	}

	if v.MetricDefinitions != nil {
		ok := object.Key("MetricDefinitions")
		if err := awsRestjson1_serializeDocumentMetricDefinitionsRequest(v.MetricDefinitions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchDeleteRumMetricDefinitions struct {
}

func (*awsRestjson1_serializeOpBatchDeleteRumMetricDefinitions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchDeleteRumMetricDefinitions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteRumMetricDefinitionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/rummetrics/{AppMonitorName}/metrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchDeleteRumMetricDefinitionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchDeleteRumMetricDefinitionsInput(v *BatchDeleteRumMetricDefinitionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppMonitorName == nil || len(*v.AppMonitorName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppMonitorName must not be empty")}
	}
	if v.AppMonitorName != nil {
		if err := encoder.SetURI("AppMonitorName").String(*v.AppMonitorName); err != nil {
			return err
		}
	}

	if len(v.Destination) > 0 {
		encoder.SetQuery("destination").String(string(v.Destination))
	}

	if v.DestinationArn != nil {
		encoder.SetQuery("destinationArn").String(*v.DestinationArn)
	}

	if v.MetricDefinitionIds != nil {
		for i := range v.MetricDefinitionIds {
			encoder.AddQuery("metricDefinitionIds").String(v.MetricDefinitionIds[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchGetRumMetricDefinitions struct {
}

func (*awsRestjson1_serializeOpBatchGetRumMetricDefinitions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchGetRumMetricDefinitions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetRumMetricDefinitionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/rummetrics/{AppMonitorName}/metrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchGetRumMetricDefinitionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchGetRumMetricDefinitionsInput(v *BatchGetRumMetricDefinitionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppMonitorName == nil || len(*v.AppMonitorName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppMonitorName must not be empty")}
	}
	if v.AppMonitorName != nil {
		if err := encoder.SetURI("AppMonitorName").String(*v.AppMonitorName); err != nil {
			return err
		}
	}

	if len(v.Destination) > 0 {
		encoder.SetQuery("destination").String(string(v.Destination))
	}

	if v.DestinationArn != nil {
		encoder.SetQuery("destinationArn").String(*v.DestinationArn)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpCreateAppMonitor struct {
}

func (*awsRestjson1_serializeOpCreateAppMonitor) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAppMonitor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAppMonitorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/appmonitor")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAppMonitorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAppMonitorInput(v *CreateAppMonitorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAppMonitorInput(v *CreateAppMonitorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppMonitorConfiguration != nil {
		ok := object.Key("AppMonitorConfiguration")
		if err := awsRestjson1_serializeDocumentAppMonitorConfiguration(v.AppMonitorConfiguration, ok); err != nil {
			return err
		}
	}

	if v.CustomEvents != nil {
		ok := object.Key("CustomEvents")
		if err := awsRestjson1_serializeDocumentCustomEvents(v.CustomEvents, ok); err != nil {
			return err
		}
	}

	if v.CwLogEnabled != nil {
		ok := object.Key("CwLogEnabled")
		ok.Boolean(*v.CwLogEnabled)
	}

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAppMonitor struct {
}

func (*awsRestjson1_serializeOpDeleteAppMonitor) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAppMonitor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAppMonitorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/appmonitor/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAppMonitorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAppMonitorInput(v *DeleteAppMonitorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRumMetricsDestination struct {
}

func (*awsRestjson1_serializeOpDeleteRumMetricsDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRumMetricsDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRumMetricsDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/rummetrics/{AppMonitorName}/metricsdestination")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRumMetricsDestinationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRumMetricsDestinationInput(v *DeleteRumMetricsDestinationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppMonitorName == nil || len(*v.AppMonitorName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppMonitorName must not be empty")}
	}
	if v.AppMonitorName != nil {
		if err := encoder.SetURI("AppMonitorName").String(*v.AppMonitorName); err != nil {
			return err
		}
	}

	if len(v.Destination) > 0 {
		encoder.SetQuery("destination").String(string(v.Destination))
	}

	if v.DestinationArn != nil {
		encoder.SetQuery("destinationArn").String(*v.DestinationArn)
	}

	return nil
}

type awsRestjson1_serializeOpGetAppMonitor struct {
}

func (*awsRestjson1_serializeOpGetAppMonitor) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAppMonitor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAppMonitorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/appmonitor/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAppMonitorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAppMonitorInput(v *GetAppMonitorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetAppMonitorData struct {
}

func (*awsRestjson1_serializeOpGetAppMonitorData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAppMonitorData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAppMonitorDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/appmonitor/{Name}/data")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAppMonitorDataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetAppMonitorDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAppMonitorDataInput(v *GetAppMonitorDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetAppMonitorDataInput(v *GetAppMonitorDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentQueryFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.TimeRange != nil {
		ok := object.Key("TimeRange")
		if err := awsRestjson1_serializeDocumentTimeRange(v.TimeRange, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListAppMonitors struct {
}

func (*awsRestjson1_serializeOpListAppMonitors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAppMonitors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAppMonitorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/appmonitors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAppMonitorsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAppMonitorsInput(v *ListAppMonitorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListRumMetricsDestinations struct {
}

func (*awsRestjson1_serializeOpListRumMetricsDestinations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRumMetricsDestinations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRumMetricsDestinationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/rummetrics/{AppMonitorName}/metricsdestination")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRumMetricsDestinationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRumMetricsDestinationsInput(v *ListRumMetricsDestinationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppMonitorName == nil || len(*v.AppMonitorName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppMonitorName must not be empty")}
	}
	if v.AppMonitorName != nil {
		if err := encoder.SetURI("AppMonitorName").String(*v.AppMonitorName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutRumEvents struct {
}

func (*awsRestjson1_serializeOpPutRumEvents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutRumEvents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutRumEventsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/appmonitors/{Id}/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutRumEventsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutRumEventsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutRumEventsInput(v *PutRumEventsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutRumEventsInput(v *PutRumEventsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppMonitorDetails != nil {
		ok := object.Key("AppMonitorDetails")
		if err := awsRestjson1_serializeDocumentAppMonitorDetails(v.AppMonitorDetails, ok); err != nil {
			return err
		}
	}

	if v.BatchId != nil {
		ok := object.Key("BatchId")
		ok.String(*v.BatchId)
	}

	if v.RumEvents != nil {
		ok := object.Key("RumEvents")
		if err := awsRestjson1_serializeDocumentRumEventList(v.RumEvents, ok); err != nil {
			return err
		}
	}

	if v.UserDetails != nil {
		ok := object.Key("UserDetails")
		if err := awsRestjson1_serializeDocumentUserDetails(v.UserDetails, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutRumMetricsDestination struct {
}

func (*awsRestjson1_serializeOpPutRumMetricsDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutRumMetricsDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutRumMetricsDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/rummetrics/{AppMonitorName}/metricsdestination")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutRumMetricsDestinationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutRumMetricsDestinationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutRumMetricsDestinationInput(v *PutRumMetricsDestinationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppMonitorName == nil || len(*v.AppMonitorName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppMonitorName must not be empty")}
	}
	if v.AppMonitorName != nil {
		if err := encoder.SetURI("AppMonitorName").String(*v.AppMonitorName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutRumMetricsDestinationInput(v *PutRumMetricsDestinationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Destination) > 0 {
		ok := object.Key("Destination")
		ok.String(string(v.Destination))
	}

	if v.DestinationArn != nil {
		ok := object.Key("DestinationArn")
		ok.String(*v.DestinationArn)
	}

	if v.IamRoleArn != nil {
		ok := object.Key("IamRoleArn")
		ok.String(*v.IamRoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAppMonitor struct {
}

func (*awsRestjson1_serializeOpUpdateAppMonitor) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAppMonitor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAppMonitorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/appmonitor/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAppMonitorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAppMonitorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAppMonitorInput(v *UpdateAppMonitorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAppMonitorInput(v *UpdateAppMonitorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppMonitorConfiguration != nil {
		ok := object.Key("AppMonitorConfiguration")
		if err := awsRestjson1_serializeDocumentAppMonitorConfiguration(v.AppMonitorConfiguration, ok); err != nil {
			return err
		}
	}

	if v.CustomEvents != nil {
		ok := object.Key("CustomEvents")
		if err := awsRestjson1_serializeDocumentCustomEvents(v.CustomEvents, ok); err != nil {
			return err
		}
	}

	if v.CwLogEnabled != nil {
		ok := object.Key("CwLogEnabled")
		ok.Boolean(*v.CwLogEnabled)
	}

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRumMetricDefinition struct {
}

func (*awsRestjson1_serializeOpUpdateRumMetricDefinition) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRumMetricDefinition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRumMetricDefinitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/rummetrics/{AppMonitorName}/metrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRumMetricDefinitionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRumMetricDefinitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRumMetricDefinitionInput(v *UpdateRumMetricDefinitionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppMonitorName == nil || len(*v.AppMonitorName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppMonitorName must not be empty")}
	}
	if v.AppMonitorName != nil {
		if err := encoder.SetURI("AppMonitorName").String(*v.AppMonitorName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRumMetricDefinitionInput(v *UpdateRumMetricDefinitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Destination) > 0 {
		ok := object.Key("Destination")
		ok.String(string(v.Destination))
	}

	if v.DestinationArn != nil {
		ok := object.Key("DestinationArn")
		ok.String(*v.DestinationArn)
	}

	if v.MetricDefinition != nil {
		ok := object.Key("MetricDefinition")
		if err := awsRestjson1_serializeDocumentMetricDefinitionRequest(v.MetricDefinition, ok); err != nil {
			return err
		}
	}

	if v.MetricDefinitionId != nil {
		ok := object.Key("MetricDefinitionId")
		ok.String(*v.MetricDefinitionId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAppMonitorConfiguration(v *types.AppMonitorConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowCookies != nil {
		ok := object.Key("AllowCookies")
		ok.Boolean(*v.AllowCookies)
	}

	if v.EnableXRay != nil {
		ok := object.Key("EnableXRay")
		ok.Boolean(*v.EnableXRay)
	}

	if v.ExcludedPages != nil {
		ok := object.Key("ExcludedPages")
		if err := awsRestjson1_serializeDocumentPages(v.ExcludedPages, ok); err != nil {
			return err
		}
	}

	if v.FavoritePages != nil {
		ok := object.Key("FavoritePages")
		if err := awsRestjson1_serializeDocumentFavoritePages(v.FavoritePages, ok); err != nil {
			return err
		}
	}

	if v.GuestRoleArn != nil {
		ok := object.Key("GuestRoleArn")
		ok.String(*v.GuestRoleArn)
	}

	if v.IdentityPoolId != nil {
		ok := object.Key("IdentityPoolId")
		ok.String(*v.IdentityPoolId)
	}

	if v.IncludedPages != nil {
		ok := object.Key("IncludedPages")
		if err := awsRestjson1_serializeDocumentPages(v.IncludedPages, ok); err != nil {
			return err
		}
	}

	if v.SessionSampleRate != 0 {
		ok := object.Key("SessionSampleRate")
		switch {
		case math.IsNaN(v.SessionSampleRate):
			ok.String("NaN")

		case math.IsInf(v.SessionSampleRate, 1):
			ok.String("Infinity")

		case math.IsInf(v.SessionSampleRate, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.SessionSampleRate)

		}
	}

	if v.Telemetries != nil {
		ok := object.Key("Telemetries")
		if err := awsRestjson1_serializeDocumentTelemetries(v.Telemetries, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAppMonitorDetails(v *types.AppMonitorDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.String(*v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomEvents(v *types.CustomEvents, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocumentDimensionKeysMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentFavoritePages(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentMetricDefinitionRequest(v *types.MetricDefinitionRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DimensionKeys != nil {
		ok := object.Key("DimensionKeys")
		if err := awsRestjson1_serializeDocumentDimensionKeysMap(v.DimensionKeys, ok); err != nil {
			return err
		}
	}

	if v.EventPattern != nil {
		ok := object.Key("EventPattern")
		ok.String(*v.EventPattern)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.UnitLabel != nil {
		ok := object.Key("UnitLabel")
		ok.String(*v.UnitLabel)
	}

	if v.ValueKey != nil {
		ok := object.Key("ValueKey")
		ok.String(*v.ValueKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentMetricDefinitionsRequest(v []types.MetricDefinitionRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMetricDefinitionRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPages(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentQueryFilter(v *types.QueryFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentQueryFilterValueList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentQueryFilters(v []types.QueryFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentQueryFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentQueryFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentRumEvent(v *types.RumEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Details != nil {
		ok := object.Key("details")
		ok.String(*v.Details)
	}

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.Metadata != nil {
		ok := object.Key("metadata")
		ok.String(*v.Metadata)
	}

	if v.Timestamp != nil {
		ok := object.Key("timestamp")
		ok.Double(smithytime.FormatEpochSeconds(*v.Timestamp))
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentRumEventList(v []types.RumEvent, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRumEvent(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTelemetries(v []types.Telemetry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentTimeRange(v *types.TimeRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("After")
		ok.Long(v.After)
	}

	if v.Before != 0 {
		ok := object.Key("Before")
		ok.Long(v.Before)
	}

	return nil
}

func awsRestjson1_serializeDocumentUserDetails(v *types.UserDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SessionId != nil {
		ok := object.Key("sessionId")
		ok.String(*v.SessionId)
	}

	if v.UserId != nil {
		ok := object.Key("userId")
		ok.String(*v.UserId)
	}

	return nil
}
