// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Returns information about a specific Elastic DocumentDB cluster.
type Cluster struct {

	// The name of the Elastic DocumentDB cluster administrator.
	//
	// This member is required.
	AdminUserName *string

	// The authentication type for the Elastic DocumentDB cluster.
	//
	// This member is required.
	AuthType Auth

	// The arn of the Elastic DocumentDB cluster.
	//
	// This member is required.
	ClusterArn *string

	// The URL used to connect to the Elastic DocumentDB cluster.
	//
	// This member is required.
	ClusterEndpoint *string

	// The name of the Elastic DocumentDB cluster.
	//
	// This member is required.
	ClusterName *string

	// The time when the Elastic DocumentDB cluster was created in Universal
	// Coordinated Time (UTC).
	//
	// This member is required.
	CreateTime *string

	// The KMS key identifier to use to encrypt the Elastic DocumentDB cluster.
	//
	// This member is required.
	KmsKeyId *string

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC). Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// This member is required.
	PreferredMaintenanceWindow *string

	// The capacity of each shard in the Elastic DocumentDB cluster.
	//
	// This member is required.
	ShardCapacity *int32

	// The number of shards in the Elastic DocumentDB cluster.
	//
	// This member is required.
	ShardCount *int32

	// The status of the Elastic DocumentDB cluster.
	//
	// This member is required.
	Status Status

	// The Amazon EC2 subnet IDs for the Elastic DocumentDB cluster.
	//
	// This member is required.
	SubnetIds []string

	// A list of EC2 VPC security groups associated with this cluster.
	//
	// This member is required.
	VpcSecurityGroupIds []string

	noSmithyDocumentSerde
}

// A list of Elastic DocumentDB cluster.
type ClusterInList struct {

	// The arn of the Elastic DocumentDB cluster.
	//
	// This member is required.
	ClusterArn *string

	// The name of the Elastic DocumentDB cluster.
	//
	// This member is required.
	ClusterName *string

	// The status of the Elastic DocumentDB cluster.
	//
	// This member is required.
	Status Status

	noSmithyDocumentSerde
}

// Returns information about a specific Elastic DocumentDB snapshot.
type ClusterSnapshot struct {

	// The name of the Elastic DocumentDB cluster administrator.
	//
	// This member is required.
	AdminUserName *string

	// The arn of the Elastic DocumentDB cluster.
	//
	// This member is required.
	ClusterArn *string

	// The time when the Elastic DocumentDB cluster was created in Universal
	// Coordinated Time (UTC).
	//
	// This member is required.
	ClusterCreationTime *string

	// The KMS key identifier to use to encrypt the Elastic DocumentDB cluster.
	//
	// This member is required.
	KmsKeyId *string

	// The arn of the Elastic DocumentDB snapshot
	//
	// This member is required.
	SnapshotArn *string

	// The time when the Elastic DocumentDB snapshot was created in Universal
	// Coordinated Time (UTC).
	//
	// This member is required.
	SnapshotCreationTime *string

	// The name of the Elastic DocumentDB snapshot.
	//
	// This member is required.
	SnapshotName *string

	// The status of the Elastic DocumentDB snapshot.
	//
	// This member is required.
	Status Status

	// A list of the IDs of subnets associated with the DB cluster snapshot.
	//
	// This member is required.
	SubnetIds []string

	// A list of the IDs of the VPC security groups associated with the cluster
	// snapshot.
	//
	// This member is required.
	VpcSecurityGroupIds []string

	noSmithyDocumentSerde
}

// A list of Elastic DocumentDB snapshots.
type ClusterSnapshotInList struct {

	// The arn of the Elastic DocumentDB cluster.
	//
	// This member is required.
	ClusterArn *string

	// The arn of the Elastic DocumentDB snapshot
	//
	// This member is required.
	SnapshotArn *string

	// The time when the Elastic DocumentDB snapshot was created in Universal
	// Coordinated Time (UTC).
	//
	// This member is required.
	SnapshotCreationTime *string

	// The name of the Elastic DocumentDB snapshot.
	//
	// This member is required.
	SnapshotName *string

	// The status of the Elastic DocumentDB snapshot.
	//
	// This member is required.
	Status Status

	noSmithyDocumentSerde
}

// A specific field in which a given validation exception occurred.
type ValidationExceptionField struct {

	// An error message describing the validation exception in this field.
	//
	// This member is required.
	Message *string

	// The name of the field where the validation exception occurred.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
