// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An entity that defines the scope of audit evidence collected by Audit Manager.
// An Audit Manager assessment is an implementation of an Audit Manager framework.
type Assessment struct {

	// The Amazon Resource Name (ARN) of the assessment.
	Arn *string

	// The Amazon Web Services account that's associated with the assessment.
	AwsAccount *AWSAccount

	// The framework that the assessment was created from.
	Framework *AssessmentFramework

	// The metadata for the assessment.
	Metadata *AssessmentMetadata

	// The tags that are associated with the assessment.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The control entity that represents a standard control or a custom control in an
// Audit Manager assessment.
type AssessmentControl struct {

	// The amount of evidence in the assessment report.
	AssessmentReportEvidenceCount int32

	// The list of comments that's attached to the control.
	Comments []ControlComment

	// The description of the control.
	Description *string

	// The amount of evidence that's generated for the control.
	EvidenceCount int32

	// The list of data sources for the evidence.
	EvidenceSources []string

	// The identifier for the control.
	Id *string

	// The name of the control.
	Name *string

	// The response of the control.
	Response ControlResponse

	// The status of the control.
	Status ControlStatus

	noSmithyDocumentSerde
}

// Represents a set of controls in an Audit Manager assessment.
type AssessmentControlSet struct {

	// The list of controls that's contained with the control set.
	Controls []AssessmentControl

	// The delegations that are associated with the control set.
	Delegations []Delegation

	// The description for the control set.
	Description *string

	// The identifier of the control set in the assessment. This is the control set
	// name in a plain string format.
	Id *string

	// The total number of evidence objects that are uploaded manually to the control
	// set.
	ManualEvidenceCount int32

	// The roles that are associated with the control set.
	Roles []Role

	// Specifies the current status of the control set.
	Status ControlSetStatus

	// The total number of evidence objects that are retrieved automatically for the
	// control set.
	SystemEvidenceCount int32

	noSmithyDocumentSerde
}

// The folder where Audit Manager stores evidence for an assessment.
type AssessmentEvidenceFolder struct {

	// The identifier for the assessment.
	AssessmentId *string

	// The total count of evidence that's included in the assessment report.
	AssessmentReportSelectionCount int32

	// The name of the user who created the evidence folder.
	Author *string

	// The unique identifier for the control.
	ControlId *string

	// The name of the control.
	ControlName *string

	// The identifier for the control set.
	ControlSetId *string

	// The Amazon Web Service that the evidence was collected from.
	DataSource *string

	// The date when the first evidence was added to the evidence folder.
	Date *time.Time

	// The total number of Amazon Web Services resources that were assessed to generate
	// the evidence.
	EvidenceAwsServiceSourceCount int32

	// The number of evidence that falls under the compliance check category. This
	// evidence is collected from Config or Security Hub.
	EvidenceByTypeComplianceCheckCount int32

	// The total number of issues that were reported directly from Security Hub,
	// Config, or both.
	EvidenceByTypeComplianceCheckIssuesCount int32

	// The number of evidence that falls under the configuration data category. This
	// evidence is collected from configuration snapshots of other Amazon Web Services
	// such as Amazon EC2, Amazon S3, or IAM.
	EvidenceByTypeConfigurationDataCount int32

	// The number of evidence that falls under the manual category. This evidence is
	// imported manually.
	EvidenceByTypeManualCount int32

	// The number of evidence that falls under the user activity category. This
	// evidence is collected from CloudTrail logs.
	EvidenceByTypeUserActivityCount int32

	// The amount of evidence that's included in the evidence folder.
	EvidenceResourcesIncludedCount int32

	// The identifier for the folder that the evidence is stored in.
	Id *string

	// The name of the evidence folder.
	Name *string

	// The total amount of evidence in the evidence folder.
	TotalEvidence int32

	noSmithyDocumentSerde
}

// The file used to structure and automate Audit Manager assessments for a given
// compliance standard.
type AssessmentFramework struct {

	// The Amazon Resource Name (ARN) of the framework.
	Arn *string

	// The control sets that are associated with the framework.
	ControlSets []AssessmentControlSet

	// The unique identifier for the framework.
	Id *string

	// The metadata of a framework, such as the name, ID, or description.
	Metadata *FrameworkMetadata

	noSmithyDocumentSerde
}

// The metadata that's associated with a standard framework or a custom framework.
type AssessmentFrameworkMetadata struct {

	// The Amazon Resource Name (ARN) of the framework.
	Arn *string

	// The compliance type that the new custom framework supports, such as CIS or
	// HIPAA.
	ComplianceType *string

	// The number of control sets that are associated with the framework.
	ControlSetsCount int32

	// The number of controls that are associated with the framework.
	ControlsCount int32

	// Specifies when the framework was created.
	CreatedAt *time.Time

	// The description of the framework.
	Description *string

	// The unique identifier for the framework.
	Id *string

	// Specifies when the framework was most recently updated.
	LastUpdatedAt *time.Time

	// The logo that's associated with the framework.
	Logo *string

	// The name of the framework.
	Name *string

	// The framework type, such as a standard framework or a custom framework.
	Type FrameworkType

	noSmithyDocumentSerde
}

// Represents a share request for a custom framework in Audit Manager.
type AssessmentFrameworkShareRequest struct {

	// An optional comment from the sender about the share request.
	Comment *string

	// The compliance type that the shared custom framework supports, such as CIS or
	// HIPAA.
	ComplianceType *string

	// The time when the share request was created.
	CreationTime *time.Time

	// The number of custom controls that are part of the shared custom framework.
	CustomControlsCount *int32

	// The Amazon Web Services account of the recipient.
	DestinationAccount *string

	// The Amazon Web Services Region of the recipient.
	DestinationRegion *string

	// The time when the share request expires.
	ExpirationTime *time.Time

	// The description of the shared custom framework.
	FrameworkDescription *string

	// The unique identifier for the shared custom framework.
	FrameworkId *string

	// The name of the custom framework that the share request is for.
	FrameworkName *string

	// The unique identifier for the share request.
	Id *string

	// Specifies when the share request was last updated.
	LastUpdated *time.Time

	// The Amazon Web Services account of the sender.
	SourceAccount *string

	// The number of standard controls that are part of the shared custom framework.
	StandardControlsCount *int32

	// The status of the share request.
	Status ShareRequestStatus

	noSmithyDocumentSerde
}

// The metadata that's associated with the specified assessment.
type AssessmentMetadata struct {

	// The destination that evidence reports are stored in for the assessment.
	AssessmentReportsDestination *AssessmentReportsDestination

	// The name of the compliance standard that's related to the assessment, such as
	// PCI-DSS.
	ComplianceType *string

	// Specifies when the assessment was created.
	CreationTime *time.Time

	// The delegations that are associated with the assessment.
	Delegations []Delegation

	// The description of the assessment.
	Description *string

	// The unique identifier for the assessment.
	Id *string

	// The time of the most recent update.
	LastUpdated *time.Time

	// The name of the assessment.
	Name *string

	// The roles that are associated with the assessment.
	Roles []Role

	// The wrapper of Amazon Web Services accounts and services that are in scope for
	// the assessment.
	Scope *Scope

	// The overall status of the assessment.
	Status AssessmentStatus

	noSmithyDocumentSerde
}

// A metadata object that's associated with an assessment in Audit Manager.
type AssessmentMetadataItem struct {

	// The name of the compliance standard that's related to the assessment, such as
	// PCI-DSS.
	ComplianceType *string

	// Specifies when the assessment was created.
	CreationTime *time.Time

	// The delegations that are associated with the assessment.
	Delegations []Delegation

	// The unique identifier for the assessment.
	Id *string

	// The time of the most recent update.
	LastUpdated *time.Time

	// The name of the assessment.
	Name *string

	// The roles that are associated with the assessment.
	Roles []Role

	// The current status of the assessment.
	Status AssessmentStatus

	noSmithyDocumentSerde
}

// A finalized document that's generated from an Audit Manager assessment. These
// reports summarize the relevant evidence that was collected for your audit, and
// link to the relevant evidence folders. These evidence folders are named and
// organized according to the controls that are specified in your assessment.
type AssessmentReport struct {

	// The identifier for the specified assessment.
	AssessmentId *string

	// The name of the associated assessment.
	AssessmentName *string

	// The name of the user who created the assessment report.
	Author *string

	// The identifier for the specified Amazon Web Services account.
	AwsAccountId *string

	// Specifies when the assessment report was created.
	CreationTime *time.Time

	// The description of the specified assessment report.
	Description *string

	// The unique identifier for the assessment report.
	Id *string

	// The name that's given to the assessment report.
	Name *string

	// The current status of the specified assessment report.
	Status AssessmentReportStatus

	noSmithyDocumentSerde
}

// An error entity for assessment report evidence errors. This is used to provide
// more meaningful errors than a simple string message.
type AssessmentReportEvidenceError struct {

	// The error code that was returned.
	ErrorCode *string

	// The error message that was returned.
	ErrorMessage *string

	// The identifier for the evidence.
	EvidenceId *string

	noSmithyDocumentSerde
}

// The metadata objects that are associated with the specified assessment report.
type AssessmentReportMetadata struct {

	// The unique identifier for the associated assessment.
	AssessmentId *string

	// The name of the associated assessment.
	AssessmentName *string

	// The name of the user who created the assessment report.
	Author *string

	// Specifies when the assessment report was created.
	CreationTime *time.Time

	// The description of the assessment report.
	Description *string

	// The unique identifier for the assessment report.
	Id *string

	// The name of the assessment report.
	Name *string

	// The current status of the assessment report.
	Status AssessmentReportStatus

	noSmithyDocumentSerde
}

// The location where Audit Manager saves assessment reports for the given
// assessment.
type AssessmentReportsDestination struct {

	// The destination of the assessment report.
	Destination *string

	// The destination type, such as Amazon S3.
	DestinationType AssessmentReportDestinationType

	noSmithyDocumentSerde
}

// The wrapper of Amazon Web Services account details, such as account ID or email
// address.
type AWSAccount struct {

	// The email address that's associated with the Amazon Web Services account.
	EmailAddress *string

	// The identifier for the Amazon Web Services account.
	Id *string

	// The name of the Amazon Web Services account.
	Name *string

	noSmithyDocumentSerde
}

// An Amazon Web Service such as Amazon S3 or CloudTrail.
type AWSService struct {

	// The name of the Amazon Web Service.
	ServiceName *string

	noSmithyDocumentSerde
}

// An error entity for the BatchCreateDelegationByAssessment API. This is used to
// provide more meaningful errors than a simple string message.
type BatchCreateDelegationByAssessmentError struct {

	// The API request to batch create delegations in Audit Manager.
	CreateDelegationRequest *CreateDelegationRequest

	// The error code that the BatchCreateDelegationByAssessment API returned.
	ErrorCode *string

	// The error message that the BatchCreateDelegationByAssessment API returned.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// An error entity for the BatchDeleteDelegationByAssessment API. This is used to
// provide more meaningful errors than a simple string message.
type BatchDeleteDelegationByAssessmentError struct {

	// The identifier for the delegation.
	DelegationId *string

	// The error code that the BatchDeleteDelegationByAssessment API returned.
	ErrorCode *string

	// The error message that the BatchDeleteDelegationByAssessment API returned.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// An error entity for the BatchImportEvidenceToAssessmentControl API. This is used
// to provide more meaningful errors than a simple string message.
type BatchImportEvidenceToAssessmentControlError struct {

	// The error code that the BatchImportEvidenceToAssessmentControl API returned.
	ErrorCode *string

	// The error message that the BatchImportEvidenceToAssessmentControl API returned.
	ErrorMessage *string

	// Manual evidence that can't be collected automatically by Audit Manager.
	ManualEvidence *ManualEvidence

	noSmithyDocumentSerde
}

// The record of a change within Audit Manager. For example, this could be the
// status change of an assessment or the delegation of a control set.
type ChangeLog struct {

	// The action that was performed.
	Action ActionEnum

	// The time when the action was performed and the changelog record was created.
	CreatedAt *time.Time

	// The IAM user or role that performed the action.
	CreatedBy *string

	// The name of the object that changed. This could be the name of an assessment,
	// control, or control set.
	ObjectName *string

	// The object that was changed, such as an assessment, control, or control set.
	ObjectType ObjectTypeEnum

	noSmithyDocumentSerde
}

// A control in Audit Manager.
type Control struct {

	// The recommended actions to carry out if the control isn't fulfilled.
	ActionPlanInstructions *string

	// The title of the action plan for remediating the control.
	ActionPlanTitle *string

	// The Amazon Resource Name (ARN) of the control.
	Arn *string

	// The data mapping sources for the control.
	ControlMappingSources []ControlMappingSource

	// The data source types that determine where Audit Manager collects evidence from
	// for the control.
	ControlSources *string

	// Specifies when the control was created.
	CreatedAt *time.Time

	// The IAM user or role that created the control.
	CreatedBy *string

	// The description of the control.
	Description *string

	// The unique identifier for the control.
	Id *string

	// Specifies when the control was most recently updated.
	LastUpdatedAt *time.Time

	// The IAM user or role that most recently updated the control.
	LastUpdatedBy *string

	// The name of the control.
	Name *string

	// The tags associated with the control.
	Tags map[string]string

	// The steps that you should follow to determine if the control has been satisfied.
	TestingInformation *string

	// The type of control, such as a custom control or a standard control.
	Type ControlType

	noSmithyDocumentSerde
}

// A comment that's posted by a user on a control. This includes the author's name,
// the comment text, and a timestamp.
type ControlComment struct {

	// The name of the user who authored the comment.
	AuthorName *string

	// The body text of a control comment.
	CommentBody *string

	// The time when the comment was posted.
	PostedDate *time.Time

	noSmithyDocumentSerde
}

// A summary of the latest analytics data for a specific control domain. Control
// domain insights are grouped by control domain, and ranked by the highest total
// count of non-compliant evidence.
type ControlDomainInsights struct {

	// The number of controls in the control domain that collected non-compliant
	// evidence on the lastUpdated date.
	ControlsCountByNoncompliantEvidence *int32

	// A breakdown of the compliance check status for the evidence that’s associated
	// with the control domain.
	EvidenceInsights *EvidenceInsights

	// The unique identifier for the control domain.
	Id *string

	// The time when the control domain insights were last updated.
	LastUpdated *time.Time

	// The name of the control domain.
	Name *string

	// The total number of controls in the control domain.
	TotalControlsCount *int32

	noSmithyDocumentSerde
}

// A summary of the latest analytics data for a specific control in a specific
// active assessment. Control insights are grouped by control domain, and ranked by
// the highest total count of non-compliant evidence.
type ControlInsightsMetadataByAssessmentItem struct {

	// The name of the control set that the assessment control belongs to.
	ControlSetName *string

	// A breakdown of the compliance check status for the evidence that’s associated
	// with the assessment control.
	EvidenceInsights *EvidenceInsights

	// The unique identifier for the assessment control.
	Id *string

	// The time when the assessment control insights were last updated.
	LastUpdated *time.Time

	// The name of the assessment control.
	Name *string

	noSmithyDocumentSerde
}

// A summary of the latest analytics data for a specific control. This data
// reflects the total counts for the specified control across all active
// assessments. Control insights are grouped by control domain, and ranked by the
// highest total count of non-compliant evidence.
type ControlInsightsMetadataItem struct {

	// A breakdown of the compliance check status for the evidence that’s associated
	// with the control.
	EvidenceInsights *EvidenceInsights

	// The unique identifier for the control.
	Id *string

	// The time when the control insights were last updated.
	LastUpdated *time.Time

	// The name of the control.
	Name *string

	noSmithyDocumentSerde
}

// The data source that determines where Audit Manager collects evidence from for
// the control.
type ControlMappingSource struct {

	// The description of the source.
	SourceDescription *string

	// The frequency of evidence collection for the control mapping source.
	SourceFrequency SourceFrequency

	// The unique identifier for the source.
	SourceId *string

	// The keyword to search for in CloudTrail logs, Config rules, Security Hub checks,
	// and Amazon Web Services API names. To learn more about the supported keywords
	// that you can use when mapping a control data source, see the following pages in
	// the Audit Manager User Guide:
	//
	// * Config rules supported by Audit Manager
	// (https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-ash.html)
	//
	// *
	// Security Hub controls supported by Audit Manager
	// (https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-config.html)
	//
	// *
	// API calls supported by Audit Manager
	// (https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-api.html)
	//
	// *
	// CloudTrail event names supported by Audit Manager
	// (https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-cloudtrail.html)
	SourceKeyword *SourceKeyword

	// The name of the source.
	SourceName *string

	// The setup option for the data source. This option reflects if the evidence
	// collection is automated or manual.
	SourceSetUpOption SourceSetUpOption

	// Specifies one of the five types of data sources for evidence collection.
	SourceType SourceType

	// The instructions for troubleshooting the control.
	TroubleshootingText *string

	noSmithyDocumentSerde
}

// The metadata that's associated with the standard control or custom control.
type ControlMetadata struct {

	// The Amazon Resource Name (ARN) of the control.
	Arn *string

	// The data source that determines where Audit Manager collects evidence from for
	// the control.
	ControlSources *string

	// Specifies when the control was created.
	CreatedAt *time.Time

	// The unique identifier for the control.
	Id *string

	// Specifies when the control was most recently updated.
	LastUpdatedAt *time.Time

	// The name of the control.
	Name *string

	noSmithyDocumentSerde
}

// A set of controls in Audit Manager.
type ControlSet struct {

	// The list of controls within the control set.
	Controls []Control

	// The identifier of the control set in the assessment. This is the control set
	// name in a plain string format.
	Id *string

	// The name of the control set.
	Name *string

	noSmithyDocumentSerde
}

// The control entity attributes that uniquely identify an existing control to be
// added to a framework in Audit Manager.
type CreateAssessmentFrameworkControl struct {

	// The unique identifier of the control.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// A controlSet entity that represents a collection of controls in Audit Manager.
// This doesn't contain the control set ID.
type CreateAssessmentFrameworkControlSet struct {

	// The name of the control set.
	//
	// This member is required.
	Name *string

	// The list of controls within the control set. This doesn't contain the control
	// set ID.
	Controls []CreateAssessmentFrameworkControl

	noSmithyDocumentSerde
}

// The control mapping fields that represent the source for evidence collection,
// along with related parameters and metadata. This doesn't contain mappingID.
type CreateControlMappingSource struct {

	// The description of the data source that determines where Audit Manager collects
	// evidence from for the control.
	SourceDescription *string

	// The frequency of evidence collection for the control mapping source.
	SourceFrequency SourceFrequency

	// The keyword to search for in CloudTrail logs, Config rules, Security Hub checks,
	// and Amazon Web Services API names. To learn more about the supported keywords
	// that you can use when mapping a control data source, see the following pages in
	// the Audit Manager User Guide:
	//
	// * Config rules supported by Audit Manager
	// (https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-ash.html)
	//
	// *
	// Security Hub controls supported by Audit Manager
	// (https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-config.html)
	//
	// *
	// API calls supported by Audit Manager
	// (https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-api.html)
	//
	// *
	// CloudTrail event names supported by Audit Manager
	// (https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-cloudtrail.html)
	SourceKeyword *SourceKeyword

	// The name of the control mapping data source.
	SourceName *string

	// The setup option for the data source, which reflects if the evidence collection
	// is automated or manual.
	SourceSetUpOption SourceSetUpOption

	// Specifies one of the five types of data sources for evidence collection.
	SourceType SourceType

	// The instructions for troubleshooting the control.
	TroubleshootingText *string

	noSmithyDocumentSerde
}

// A collection of attributes that's used to create a delegation for an assessment
// in Audit Manager.
type CreateDelegationRequest struct {

	// A comment that's related to the delegation request.
	Comment *string

	// The unique identifier for the control set.
	ControlSetId *string

	// The Amazon Resource Name (ARN) of the IAM role.
	RoleArn *string

	// The type of customer persona. In CreateAssessment, roleType can only be
	// PROCESS_OWNER. In UpdateSettings, roleType can only be PROCESS_OWNER. In
	// BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
	RoleType RoleType

	noSmithyDocumentSerde
}

// The assignment of a control set to a delegate for review.
type Delegation struct {

	// The identifier for the assessment that's associated with the delegation.
	AssessmentId *string

	// The name of the assessment that's associated with the delegation.
	AssessmentName *string

	// The comment that's related to the delegation.
	Comment *string

	// The identifier for the control set that's associated with the delegation.
	ControlSetId *string

	// The IAM user or role that created the delegation.
	CreatedBy *string

	// Specifies when the delegation was created.
	CreationTime *time.Time

	// The unique identifier for the delegation.
	Id *string

	// Specifies when the delegation was last updated.
	LastUpdated *time.Time

	// The Amazon Resource Name (ARN) of the IAM role.
	RoleArn *string

	// The type of customer persona. In CreateAssessment, roleType can only be
	// PROCESS_OWNER. In UpdateSettings, roleType can only be PROCESS_OWNER. In
	// BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
	RoleType RoleType

	// The status of the delegation.
	Status DelegationStatus

	noSmithyDocumentSerde
}

// The metadata that's associated with the delegation.
type DelegationMetadata struct {

	// The unique identifier for the assessment.
	AssessmentId *string

	// The name of the associated assessment.
	AssessmentName *string

	// Specifies the name of the control set that was delegated for review.
	ControlSetName *string

	// Specifies when the delegation was created.
	CreationTime *time.Time

	// The unique identifier for the delegation.
	Id *string

	// The Amazon Resource Name (ARN) of the IAM role.
	RoleArn *string

	// The current status of the delegation.
	Status DelegationStatus

	noSmithyDocumentSerde
}

// A record that contains the information needed to demonstrate compliance with the
// requirements specified by a control. Examples of evidence include change
// activity triggered by a user, or a system configuration snapshot.
type Evidence struct {

	// Specifies whether the evidence is included in the assessment report.
	AssessmentReportSelection *string

	// The names and values that are used by the evidence event. This includes an
	// attribute name (such as allowUsersToChangePassword) and value (such as true or
	// false).
	Attributes map[string]string

	// The identifier for the Amazon Web Services account.
	AwsAccountId *string

	// The Amazon Web Services account that the evidence is collected from, and its
	// organization path.
	AwsOrganization *string

	// The evaluation status for automated evidence that falls under the compliance
	// check category.
	//
	// * Audit Manager classes evidence as non-compliant if Security
	// Hub reports a Fail result, or if Config reports a Non-compliant result.
	//
	// * Audit
	// Manager classes evidence as compliant if Security Hub reports a Pass result, or
	// if Config reports a Compliant result.
	//
	// * If a compliance check isn't available
	// or applicable, then no compliance evaluation can be made for that evidence. This
	// is the case if the evidence uses Config or Security Hub as the underlying data
	// source type, but those services aren't enabled. This is also the case if the
	// evidence uses an underlying data source type that doesn't support compliance
	// checks (such as manual evidence, Amazon Web Services API calls, or CloudTrail).
	ComplianceCheck *string

	// The data source where the evidence was collected from.
	DataSource *string

	// The name of the evidence event.
	EventName *string

	// The Amazon Web Service that the evidence is collected from.
	EventSource *string

	// The identifier for the Amazon Web Services account.
	EvidenceAwsAccountId *string

	// The type of automated evidence.
	EvidenceByType *string

	// The identifier for the folder that the evidence is stored in.
	EvidenceFolderId *string

	// The unique identifier for the IAM user or role that's associated with the
	// evidence.
	IamId *string

	// The identifier for the evidence.
	Id *string

	// The list of resources that are assessed to generate the evidence.
	ResourcesIncluded []Resource

	// The timestamp that represents when the evidence was collected.
	Time *time.Time

	noSmithyDocumentSerde
}

// The settings object that specifies whether evidence finder is enabled. This
// object also describes the related event data store, and the backfill status for
// populating the event data store with evidence data.
type EvidenceFinderEnablement struct {

	// The current status of the evidence data backfill process. The backfill starts
	// after you enable evidence finder. During this task, Audit Manager populates an
	// event data store with your past evidence data so that your evidence can be
	// queried.
	//
	// * NOT_STARTED means that the backfill hasn’t started yet.
	//
	// *
	// IN_PROGRESS means that the backfill is in progress. This can take up to 24 hours
	// to complete, depending on the amount of evidence data.
	//
	// * COMPLETED means that
	// the backfill is complete. All of your past evidence is now queryable.
	BackfillStatus EvidenceFinderBackfillStatus

	// The current status of the evidence finder feature and the related event data
	// store.
	//
	// * ENABLE_IN_PROGRESS means that you requested to enable evidence finder.
	// An event data store is currently being created to support evidence finder
	// queries.
	//
	// * ENABLED means that an event data store was successfully created and
	// evidence finder is enabled. We recommend that you wait 24 hours until the event
	// data store is backfilled with your past evidence data. You can use evidence
	// finder in the meantime, but not all data might be available until the backfill
	// is complete.
	//
	// * DISABLE_IN_PROGRESS means that you requested to disable evidence
	// finder, and your request is pending the deletion of the event data store.
	//
	// *
	// DISABLED means that you have permanently disabled evidence finder and the event
	// data store has been deleted. You can't re-enable evidence finder after this
	// point.
	EnablementStatus EvidenceFinderEnablementStatus

	// Represents any errors that occurred when enabling or disabling evidence finder.
	Error *string

	// The Amazon Resource Name (ARN) of the CloudTrail Lake event data store that’s
	// used by evidence finder. The event data store is the lake of evidence data that
	// evidence finder runs queries against.
	EventDataStoreArn *string

	noSmithyDocumentSerde
}

// A breakdown of the latest compliance check status for the evidence in your Audit
// Manager assessments.
type EvidenceInsights struct {

	// The number of compliance check evidence that Audit Manager classified as
	// compliant. This includes evidence that was collected from Security Hub with a
	// Pass ruling, or collected from Config with a Compliant ruling.
	CompliantEvidenceCount *int32

	// The number of evidence that a compliance check ruling isn't available for.
	// Evidence is inconclusive when the associated control uses Security Hub or Config
	// as a data source but you didn't enable those services. This is also the case
	// when a control uses a data source that doesn’t support compliance checks (for
	// example, manual evidence, API calls, or CloudTrail). If evidence has a
	// compliance check status of not applicable in the console, it's classified as
	// inconclusive in EvidenceInsights data.
	InconclusiveEvidenceCount *int32

	// The number of compliance check evidence that Audit Manager classified as
	// non-compliant. This includes evidence that was collected from Security Hub with
	// a Fail ruling, or collected from Config with a Non-compliant ruling.
	NoncompliantEvidenceCount *int32

	noSmithyDocumentSerde
}

// The file that's used to structure and automate Audit Manager assessments for a
// given compliance standard.
type Framework struct {

	// The Amazon Resource Name (ARN) of the framework.
	Arn *string

	// The compliance type that the new custom framework supports, such as CIS or
	// HIPAA.
	ComplianceType *string

	// The control sets that are associated with the framework.
	ControlSets []ControlSet

	// The sources that Audit Manager collects evidence from for the control.
	ControlSources *string

	// Specifies when the framework was created.
	CreatedAt *time.Time

	// The IAM user or role that created the framework.
	CreatedBy *string

	// The description of the framework.
	Description *string

	// The unique identifier for the framework.
	Id *string

	// Specifies when the framework was most recently updated.
	LastUpdatedAt *time.Time

	// The IAM user or role that most recently updated the framework.
	LastUpdatedBy *string

	// The logo that's associated with the framework.
	Logo *string

	// The name of the framework.
	Name *string

	// The tags that are associated with the framework.
	Tags map[string]string

	// The framework type, such as a custom framework or a standard framework.
	Type FrameworkType

	noSmithyDocumentSerde
}

// The metadata of a framework, such as the name, ID, or description.
type FrameworkMetadata struct {

	// The compliance standard that's associated with the framework. For example, this
	// could be PCI DSS or HIPAA.
	ComplianceType *string

	// The description of the framework.
	Description *string

	// The logo that's associated with the framework.
	Logo *string

	// The name of the framework.
	Name *string

	noSmithyDocumentSerde
}

// A summary of the latest analytics data for all your active assessments. This
// summary is a snapshot of the data that your active assessments collected on the
// lastUpdated date. It’s important to understand that the following totals are
// daily counts based on this date — they aren’t a total sum to date. The Insights
// data is eventually consistent. This means that, when you read data from
// Insights, the response might not instantly reflect the results of a recently
// completed write or update operation. If you repeat your read request after a few
// hours, the response should return the latest data. If you delete an assessment
// or change its status to inactive, InsightsByAssessment includes data for that
// assessment as follows.
//
// * Inactive assessments - If Audit Manager collected
// evidence for your assessment before you changed it inactive, that evidence is
// included in the InsightsByAssessment counts for that day.
//
// * Deleted assessments
// - If Audit Manager collected evidence for your assessment before you deleted it,
// that evidence isn't included in the InsightsByAssessment counts for that day.
type Insights struct {

	// The number of active assessments in Audit Manager.
	ActiveAssessmentsCount *int32

	// The number of assessment controls that collected non-compliant evidence on the
	// lastUpdated date.
	AssessmentControlsCountByNoncompliantEvidence *int32

	// The number of compliance check evidence that Audit Manager classified as
	// compliant on the lastUpdated date. This includes evidence that was collected
	// from Security Hub with a Pass ruling, or collected from Config with a Compliant
	// ruling.
	CompliantEvidenceCount *int32

	// The number of evidence without a compliance check ruling. Evidence is
	// inconclusive when the associated control uses Security Hub or Config as a data
	// source but you didn't enable those services. This is also the case when a
	// control uses a data source that doesn’t support compliance checks (for example:
	// manual evidence, API calls, or CloudTrail). If evidence has a compliance check
	// status of not applicable, it's classed as inconclusive in Insights data.
	InconclusiveEvidenceCount *int32

	// The time when the cross-assessment insights were last updated.
	LastUpdated *time.Time

	// The number of compliance check evidence that Audit Manager classified as
	// non-compliant on the lastUpdated date. This includes evidence that was collected
	// from Security Hub with a Fail ruling, or collected from Config with a
	// Non-compliant ruling.
	NoncompliantEvidenceCount *int32

	// The total number of controls across all active assessments.
	TotalAssessmentControlsCount *int32

	noSmithyDocumentSerde
}

// A summary of the latest analytics data for a specific active assessment. This
// summary is a snapshot of the data that was collected on the lastUpdated date.
// It’s important to understand that the totals in InsightsByAssessment are daily
// counts based on this date — they aren’t a total sum to date. The
// InsightsByAssessment data is eventually consistent. This means that when you
// read data from InsightsByAssessment, the response might not instantly reflect
// the results of a recently completed write or update operation. If you repeat
// your read request after a few hours, the response returns the latest data. If
// you delete an assessment or change its status to inactive, InsightsByAssessment
// includes data for that assessment as follows.
//
// * Inactive assessments - If Audit
// Manager collected evidence for your assessment before you changed it inactive,
// that evidence is included in the InsightsByAssessment counts for that day.
//
// *
// Deleted assessments - If Audit Manager collected evidence for your assessment
// before you deleted it, that evidence isn't included in the InsightsByAssessment
// counts for that day.
type InsightsByAssessment struct {

	// The number of assessment controls that collected non-compliant evidence on the
	// lastUpdated date.
	AssessmentControlsCountByNoncompliantEvidence *int32

	// The number of compliance check evidence that Audit Manager classified as
	// compliant. This includes evidence that was collected from Security Hub with a
	// Pass ruling, or collected from Config with a Compliant ruling.
	CompliantEvidenceCount *int32

	// The amount of evidence without a compliance check ruling. Evidence is
	// inconclusive if the associated control uses Security Hub or Config as a data
	// source and you didn't enable those services. This is also the case if a control
	// uses a data source that doesn’t support compliance checks (for example, manual
	// evidence, API calls, or CloudTrail). If evidence has a compliance check status
	// of not applicable, it's classified as inconclusive in InsightsByAssessment data.
	InconclusiveEvidenceCount *int32

	// The time when the assessment insights were last updated.
	LastUpdated *time.Time

	// The number of compliance check evidence that Audit Manager classified as
	// non-compliant. This includes evidence that was collected from Security Hub with
	// a Fail ruling, or collected from Config with a Non-compliant ruling.
	NoncompliantEvidenceCount *int32

	// The total number of controls in the assessment.
	TotalAssessmentControlsCount *int32

	noSmithyDocumentSerde
}

// Evidence that's uploaded to Audit Manager manually.
type ManualEvidence struct {

	// The Amazon S3 URL that points to a manual evidence object.
	S3ResourcePath *string

	noSmithyDocumentSerde
}

// The notification that informs a user of an update in Audit Manager. For example,
// this includes the notification that's sent when a control set is delegated for
// review.
type Notification struct {

	// The identifier for the assessment.
	AssessmentId *string

	// The name of the related assessment.
	AssessmentName *string

	// The identifier for the control set.
	ControlSetId *string

	// Specifies the name of the control set that the notification is about.
	ControlSetName *string

	// The description of the notification.
	Description *string

	// The time when the notification was sent.
	EventTime *time.Time

	// The unique identifier for the notification.
	Id *string

	// The sender of the notification.
	Source *string

	noSmithyDocumentSerde
}

// A system asset that's evaluated in an Audit Manager assessment.
type Resource struct {

	// The Amazon Resource Name (ARN) for the resource.
	Arn *string

	// The evaluation status for a resource that was assessed when collecting
	// compliance check evidence.
	//
	// * Audit Manager classes the resource as
	// non-compliant if Security Hub reports a Fail result, or if Config reports a
	// Non-compliant result.
	//
	// * Audit Manager classes the resource as compliant if
	// Security Hub reports a Pass result, or if Config reports a Compliant result.
	//
	// *
	// If a compliance check isn't available or applicable, then no compliance
	// evaluation can be made for that resource. This is the case if a resource
	// assessment uses Config or Security Hub as the underlying data source type, but
	// those services aren't enabled. This is also the case if the resource assessment
	// uses an underlying data source type that doesn't support compliance checks (such
	// as manual evidence, Amazon Web Services API calls, or CloudTrail).
	ComplianceCheck *string

	// The value of the resource.
	Value *string

	noSmithyDocumentSerde
}

// The wrapper that contains the Audit Manager role information of the current
// user. This includes the role type and IAM Amazon Resource Name (ARN).
type Role struct {

	// The Amazon Resource Name (ARN) of the IAM role.
	//
	// This member is required.
	RoleArn *string

	// The type of customer persona. In CreateAssessment, roleType can only be
	// PROCESS_OWNER. In UpdateSettings, roleType can only be PROCESS_OWNER. In
	// BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
	//
	// This member is required.
	RoleType RoleType

	noSmithyDocumentSerde
}

// The wrapper that contains the Amazon Web Services accounts and services that are
// in scope for the assessment.
type Scope struct {

	// The Amazon Web Services accounts that are included in the scope of the
	// assessment.
	AwsAccounts []AWSAccount

	// The Amazon Web Services services that are included in the scope of the
	// assessment.
	AwsServices []AWSService

	noSmithyDocumentSerde
}

// The metadata that's associated with the Amazon Web Service.
type ServiceMetadata struct {

	// The category that the Amazon Web Service belongs to, such as compute, storage,
	// or database.
	Category *string

	// The description of the Amazon Web Service.
	Description *string

	// The display name of the Amazon Web Service.
	DisplayName *string

	// The name of the Amazon Web Service.
	Name *string

	noSmithyDocumentSerde
}

// The settings object that holds all supported Audit Manager settings.
type Settings struct {

	// The default storage destination for assessment reports.
	DefaultAssessmentReportsDestination *AssessmentReportsDestination

	// The designated default audit owners.
	DefaultProcessOwners []Role

	// The current evidence finder status and event data store details.
	EvidenceFinderEnablement *EvidenceFinderEnablement

	// Specifies whether Organizations is enabled.
	IsAwsOrgEnabled *bool

	// The KMS key details.
	KmsKey *string

	// The designated Amazon Simple Notification Service (Amazon SNS) topic.
	SnsTopic *string

	noSmithyDocumentSerde
}

// The keyword to search for in CloudTrail logs, Config rules, Security Hub checks,
// and Amazon Web Services API names. To learn more about the supported keywords
// that you can use when mapping a control data source, see the following pages in
// the Audit Manager User Guide:
//
// * Config rules supported by Audit Manager
// (https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-ash.html)
//
// *
// Security Hub controls supported by Audit Manager
// (https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-config.html)
//
// *
// API calls supported by Audit Manager
// (https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-api.html)
//
// *
// CloudTrail event names supported by Audit Manager
// (https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-cloudtrail.html)
type SourceKeyword struct {

	// The input method for the keyword.
	KeywordInputType KeywordInputType

	// The value of the keyword that's used when mapping a control data source. For
	// example, this can be a CloudTrail event name, a rule name for Config, a Security
	// Hub control, or the name of an Amazon Web Services API call. If you’re mapping a
	// data source to a rule in Config, the keywordValue that you specify depends on
	// the type of rule:
	//
	// * For managed rules
	// (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html),
	// you can use the rule identifier as the keywordValue. You can find the rule
	// identifier from the list of Config managed rules
	// (https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html).
	//
	// *
	// Managed rule name: s3-bucket-acl-prohibited
	// (https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-acl-prohibited.html)keywordValue:
	// S3_BUCKET_ACL_PROHIBITED
	//
	// * For custom rules
	// (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html),
	// you form the keywordValue by adding the Custom_ prefix to the rule name. This
	// prefix distinguishes the rule from a managed rule.
	//
	// * Custom rule name:
	// my-custom-config-rule keywordValue: Custom_my-custom-config-rule
	//
	// * For
	// service-linked rules
	// (https://docs.aws.amazon.com/config/latest/developerguide/service-linked-awsconfig-rules.html),
	// you form the keywordValue by adding the Custom_ prefix to the rule name. In
	// addition, you remove the suffix ID that appears at the end of the rule name.
	//
	// *
	// Service-linked rule name: CustomRuleForAccount-conformance-pack-szsm1uv0w
	// keywordValue: Custom_CustomRuleForAccount-conformance-pack
	//
	// * Service-linked
	// rule name: OrgConfigRule-s3-bucket-versioning-enabled-dbgzf8ba keywordValue:
	// Custom_OrgConfigRule-s3-bucket-versioning-enabled
	KeywordValue *string

	noSmithyDocumentSerde
}

// A controlSet entity that represents a collection of controls in Audit Manager.
// This doesn't contain the control set ID.
type UpdateAssessmentFrameworkControlSet struct {

	// The list of controls that are contained within the control set.
	//
	// This member is required.
	Controls []CreateAssessmentFrameworkControl

	// The name of the control set.
	//
	// This member is required.
	Name *string

	// The unique identifier for the control set.
	Id *string

	noSmithyDocumentSerde
}

// Short for uniform resource locator. A URL is used as a unique identifier to
// locate a resource on the internet.
type URL struct {

	// The name or word that's used as a hyperlink to the URL.
	HyperlinkName *string

	// The unique identifier for the internet resource.
	Link *string

	noSmithyDocumentSerde
}

// Indicates that the request has invalid or missing parameters for the field.
type ValidationExceptionField struct {

	// The body of the error message.
	//
	// This member is required.
	Message *string

	// The name of the validation error.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
