// Code generated by smithy-go-codegen DO NOT EDIT.

package wellarchitected

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/wellarchitected/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpAssociateLenses struct {
}

func (*awsRestjson1_serializeOpAssociateLenses) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateLenses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateLensesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/associateLenses")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateLensesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateLensesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateLensesInput(v *AssociateLensesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateLensesInput(v *AssociateLensesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LensAliases != nil {
		ok := object.Key("LensAliases")
		if err := awsRestjson1_serializeDocumentLensAliases(v.LensAliases, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateLensShare struct {
}

func (*awsRestjson1_serializeOpCreateLensShare) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateLensShare) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLensShareInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/lenses/{LensAlias}/shares")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateLensShareInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateLensShareInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateLensShareInput(v *CreateLensShareInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateLensShareInput(v *CreateLensShareInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.SharedWith != nil {
		ok := object.Key("SharedWith")
		ok.String(*v.SharedWith)
	}

	return nil
}

type awsRestjson1_serializeOpCreateLensVersion struct {
}

func (*awsRestjson1_serializeOpCreateLensVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateLensVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLensVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/lenses/{LensAlias}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateLensVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateLensVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateLensVersionInput(v *CreateLensVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateLensVersionInput(v *CreateLensVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.IsMajorVersion {
		ok := object.Key("IsMajorVersion")
		ok.Boolean(v.IsMajorVersion)
	}

	if v.LensVersion != nil {
		ok := object.Key("LensVersion")
		ok.String(*v.LensVersion)
	}

	return nil
}

type awsRestjson1_serializeOpCreateMilestone struct {
}

func (*awsRestjson1_serializeOpCreateMilestone) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateMilestone) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMilestoneInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/milestones")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateMilestoneInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateMilestoneInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateMilestoneInput(v *CreateMilestoneInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateMilestoneInput(v *CreateMilestoneInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.MilestoneName != nil {
		ok := object.Key("MilestoneName")
		ok.String(*v.MilestoneName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateWorkload struct {
}

func (*awsRestjson1_serializeOpCreateWorkload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateWorkload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWorkloadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateWorkloadInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateWorkloadInput(v *CreateWorkloadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateWorkloadInput(v *CreateWorkloadInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("AccountIds")
		if err := awsRestjson1_serializeDocumentWorkloadAccountIds(v.AccountIds, ok); err != nil {
			return err
		}
	}

	if v.ArchitecturalDesign != nil {
		ok := object.Key("ArchitecturalDesign")
		ok.String(*v.ArchitecturalDesign)
	}

	if v.AwsRegions != nil {
		ok := object.Key("AwsRegions")
		if err := awsRestjson1_serializeDocumentWorkloadAwsRegions(v.AwsRegions, ok); err != nil {
			return err
		}
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if len(v.Environment) > 0 {
		ok := object.Key("Environment")
		ok.String(string(v.Environment))
	}

	if v.Industry != nil {
		ok := object.Key("Industry")
		ok.String(*v.Industry)
	}

	if v.IndustryType != nil {
		ok := object.Key("IndustryType")
		ok.String(*v.IndustryType)
	}

	if v.Lenses != nil {
		ok := object.Key("Lenses")
		if err := awsRestjson1_serializeDocumentWorkloadLenses(v.Lenses, ok); err != nil {
			return err
		}
	}

	if v.NonAwsRegions != nil {
		ok := object.Key("NonAwsRegions")
		if err := awsRestjson1_serializeDocumentWorkloadNonAwsRegions(v.NonAwsRegions, ok); err != nil {
			return err
		}
	}

	if v.Notes != nil {
		ok := object.Key("Notes")
		ok.String(*v.Notes)
	}

	if v.PillarPriorities != nil {
		ok := object.Key("PillarPriorities")
		if err := awsRestjson1_serializeDocumentWorkloadPillarPriorities(v.PillarPriorities, ok); err != nil {
			return err
		}
	}

	if v.ReviewOwner != nil {
		ok := object.Key("ReviewOwner")
		ok.String(*v.ReviewOwner)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.WorkloadName != nil {
		ok := object.Key("WorkloadName")
		ok.String(*v.WorkloadName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateWorkloadShare struct {
}

func (*awsRestjson1_serializeOpCreateWorkloadShare) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateWorkloadShare) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWorkloadShareInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/shares")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateWorkloadShareInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateWorkloadShareInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateWorkloadShareInput(v *CreateWorkloadShareInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateWorkloadShareInput(v *CreateWorkloadShareInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if len(v.PermissionType) > 0 {
		ok := object.Key("PermissionType")
		ok.String(string(v.PermissionType))
	}

	if v.SharedWith != nil {
		ok := object.Key("SharedWith")
		ok.String(*v.SharedWith)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteLens struct {
}

func (*awsRestjson1_serializeOpDeleteLens) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteLens) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLensInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/lenses/{LensAlias}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteLensInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteLensInput(v *DeleteLensInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientRequestToken != nil {
		encoder.SetQuery("ClientRequestToken").String(*v.ClientRequestToken)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	if len(v.LensStatus) > 0 {
		encoder.SetQuery("LensStatus").String(string(v.LensStatus))
	}

	return nil
}

type awsRestjson1_serializeOpDeleteLensShare struct {
}

func (*awsRestjson1_serializeOpDeleteLensShare) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteLensShare) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLensShareInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/lenses/{LensAlias}/shares/{ShareId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteLensShareInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteLensShareInput(v *DeleteLensShareInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientRequestToken != nil {
		encoder.SetQuery("ClientRequestToken").String(*v.ClientRequestToken)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	if v.ShareId == nil || len(*v.ShareId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ShareId must not be empty")}
	}
	if v.ShareId != nil {
		if err := encoder.SetURI("ShareId").String(*v.ShareId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteWorkload struct {
}

func (*awsRestjson1_serializeOpDeleteWorkload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteWorkload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWorkloadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteWorkloadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteWorkloadInput(v *DeleteWorkloadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientRequestToken != nil {
		encoder.SetQuery("ClientRequestToken").String(*v.ClientRequestToken)
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteWorkloadShare struct {
}

func (*awsRestjson1_serializeOpDeleteWorkloadShare) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteWorkloadShare) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWorkloadShareInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/shares/{ShareId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteWorkloadShareInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteWorkloadShareInput(v *DeleteWorkloadShareInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientRequestToken != nil {
		encoder.SetQuery("ClientRequestToken").String(*v.ClientRequestToken)
	}

	if v.ShareId == nil || len(*v.ShareId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ShareId must not be empty")}
	}
	if v.ShareId != nil {
		if err := encoder.SetURI("ShareId").String(*v.ShareId); err != nil {
			return err
		}
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateLenses struct {
}

func (*awsRestjson1_serializeOpDisassociateLenses) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateLenses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateLensesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/disassociateLenses")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateLensesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDisassociateLensesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateLensesInput(v *DisassociateLensesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDisassociateLensesInput(v *DisassociateLensesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LensAliases != nil {
		ok := object.Key("LensAliases")
		if err := awsRestjson1_serializeDocumentLensAliases(v.LensAliases, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpExportLens struct {
}

func (*awsRestjson1_serializeOpExportLens) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpExportLens) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportLensInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/lenses/{LensAlias}/export")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsExportLensInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsExportLensInput(v *ExportLensInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	if v.LensVersion != nil {
		encoder.SetQuery("LensVersion").String(*v.LensVersion)
	}

	return nil
}

type awsRestjson1_serializeOpGetAnswer struct {
}

func (*awsRestjson1_serializeOpGetAnswer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAnswer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAnswerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers/{QuestionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAnswerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAnswerInput(v *GetAnswerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	if v.MilestoneNumber != 0 {
		encoder.SetQuery("MilestoneNumber").Integer(v.MilestoneNumber)
	}

	if v.QuestionId == nil || len(*v.QuestionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QuestionId must not be empty")}
	}
	if v.QuestionId != nil {
		if err := encoder.SetURI("QuestionId").String(*v.QuestionId); err != nil {
			return err
		}
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetLens struct {
}

func (*awsRestjson1_serializeOpGetLens) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLens) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLensInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/lenses/{LensAlias}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetLensInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLensInput(v *GetLensInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	if v.LensVersion != nil {
		encoder.SetQuery("LensVersion").String(*v.LensVersion)
	}

	return nil
}

type awsRestjson1_serializeOpGetLensReview struct {
}

func (*awsRestjson1_serializeOpGetLensReview) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLensReview) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLensReviewInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/lensReviews/{LensAlias}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetLensReviewInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLensReviewInput(v *GetLensReviewInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	if v.MilestoneNumber != 0 {
		encoder.SetQuery("MilestoneNumber").Integer(v.MilestoneNumber)
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetLensReviewReport struct {
}

func (*awsRestjson1_serializeOpGetLensReviewReport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLensReviewReport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLensReviewReportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/lensReviews/{LensAlias}/report")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetLensReviewReportInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLensReviewReportInput(v *GetLensReviewReportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	if v.MilestoneNumber != 0 {
		encoder.SetQuery("MilestoneNumber").Integer(v.MilestoneNumber)
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetLensVersionDifference struct {
}

func (*awsRestjson1_serializeOpGetLensVersionDifference) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLensVersionDifference) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLensVersionDifferenceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/lenses/{LensAlias}/versionDifference")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetLensVersionDifferenceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLensVersionDifferenceInput(v *GetLensVersionDifferenceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BaseLensVersion != nil {
		encoder.SetQuery("BaseLensVersion").String(*v.BaseLensVersion)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	if v.TargetLensVersion != nil {
		encoder.SetQuery("TargetLensVersion").String(*v.TargetLensVersion)
	}

	return nil
}

type awsRestjson1_serializeOpGetMilestone struct {
}

func (*awsRestjson1_serializeOpGetMilestone) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMilestone) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMilestoneInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/milestones/{MilestoneNumber}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMilestoneInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMilestoneInput(v *GetMilestoneInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	{
		if err := encoder.SetURI("MilestoneNumber").Integer(v.MilestoneNumber); err != nil {
			return err
		}
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetWorkload struct {
}

func (*awsRestjson1_serializeOpGetWorkload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetWorkload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWorkloadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetWorkloadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetWorkloadInput(v *GetWorkloadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpImportLens struct {
}

func (*awsRestjson1_serializeOpImportLens) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpImportLens) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportLensInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/importLens")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentImportLensInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsImportLensInput(v *ImportLensInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentImportLensInput(v *ImportLensInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.JSONString != nil {
		ok := object.Key("JSONString")
		ok.String(*v.JSONString)
	}

	if v.LensAlias != nil {
		ok := object.Key("LensAlias")
		ok.String(*v.LensAlias)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListAnswers struct {
}

func (*awsRestjson1_serializeOpListAnswers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAnswers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAnswersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAnswersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAnswersInput(v *ListAnswersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("MaxResults").Integer(v.MaxResults)
	}

	if v.MilestoneNumber != 0 {
		encoder.SetQuery("MilestoneNumber").Integer(v.MilestoneNumber)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.PillarId != nil {
		encoder.SetQuery("PillarId").String(*v.PillarId)
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListLenses struct {
}

func (*awsRestjson1_serializeOpListLenses) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListLenses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLensesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/lenses")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListLensesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListLensesInput(v *ListLensesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensName != nil {
		encoder.SetQuery("LensName").String(*v.LensName)
	}

	if len(v.LensStatus) > 0 {
		encoder.SetQuery("LensStatus").String(string(v.LensStatus))
	}

	if len(v.LensType) > 0 {
		encoder.SetQuery("LensType").String(string(v.LensType))
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("MaxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListLensReviewImprovements struct {
}

func (*awsRestjson1_serializeOpListLensReviewImprovements) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListLensReviewImprovements) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLensReviewImprovementsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/lensReviews/{LensAlias}/improvements")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListLensReviewImprovementsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListLensReviewImprovementsInput(v *ListLensReviewImprovementsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("MaxResults").Integer(v.MaxResults)
	}

	if v.MilestoneNumber != 0 {
		encoder.SetQuery("MilestoneNumber").Integer(v.MilestoneNumber)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.PillarId != nil {
		encoder.SetQuery("PillarId").String(*v.PillarId)
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListLensReviews struct {
}

func (*awsRestjson1_serializeOpListLensReviews) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListLensReviews) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLensReviewsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/lensReviews")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListLensReviewsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListLensReviewsInput(v *ListLensReviewsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("MaxResults").Integer(v.MaxResults)
	}

	if v.MilestoneNumber != 0 {
		encoder.SetQuery("MilestoneNumber").Integer(v.MilestoneNumber)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListLensShares struct {
}

func (*awsRestjson1_serializeOpListLensShares) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListLensShares) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLensSharesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/lenses/{LensAlias}/shares")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListLensSharesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListLensSharesInput(v *ListLensSharesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("MaxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.SharedWithPrefix != nil {
		encoder.SetQuery("SharedWithPrefix").String(*v.SharedWithPrefix)
	}

	return nil
}

type awsRestjson1_serializeOpListMilestones struct {
}

func (*awsRestjson1_serializeOpListMilestones) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMilestones) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMilestonesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/milestonesSummaries")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMilestonesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListMilestonesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMilestonesInput(v *ListMilestonesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListMilestonesInput(v *ListMilestonesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListNotifications struct {
}

func (*awsRestjson1_serializeOpListNotifications) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListNotifications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListNotificationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/notifications")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListNotificationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListNotificationsInput(v *ListNotificationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListNotificationsInput(v *ListNotificationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.WorkloadId != nil {
		ok := object.Key("WorkloadId")
		ok.String(*v.WorkloadId)
	}

	return nil
}

type awsRestjson1_serializeOpListShareInvitations struct {
}

func (*awsRestjson1_serializeOpListShareInvitations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListShareInvitations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListShareInvitationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/shareInvitations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListShareInvitationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListShareInvitationsInput(v *ListShareInvitationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensNamePrefix != nil {
		encoder.SetQuery("LensNamePrefix").String(*v.LensNamePrefix)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("MaxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if len(v.ShareResourceType) > 0 {
		encoder.SetQuery("ShareResourceType").String(string(v.ShareResourceType))
	}

	if v.WorkloadNamePrefix != nil {
		encoder.SetQuery("WorkloadNamePrefix").String(*v.WorkloadNamePrefix)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{WorkloadArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkloadArn == nil || len(*v.WorkloadArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadArn must not be empty")}
	}
	if v.WorkloadArn != nil {
		if err := encoder.SetURI("WorkloadArn").String(*v.WorkloadArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListWorkloads struct {
}

func (*awsRestjson1_serializeOpListWorkloads) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListWorkloads) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWorkloadsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloadsSummaries")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListWorkloadsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListWorkloadsInput(v *ListWorkloadsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListWorkloadsInput(v *ListWorkloadsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.WorkloadNamePrefix != nil {
		ok := object.Key("WorkloadNamePrefix")
		ok.String(*v.WorkloadNamePrefix)
	}

	return nil
}

type awsRestjson1_serializeOpListWorkloadShares struct {
}

func (*awsRestjson1_serializeOpListWorkloadShares) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListWorkloadShares) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWorkloadSharesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/shares")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListWorkloadSharesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListWorkloadSharesInput(v *ListWorkloadSharesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("MaxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.SharedWithPrefix != nil {
		encoder.SetQuery("SharedWithPrefix").String(*v.SharedWithPrefix)
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{WorkloadArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkloadArn == nil || len(*v.WorkloadArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadArn must not be empty")}
	}
	if v.WorkloadArn != nil {
		if err := encoder.SetURI("WorkloadArn").String(*v.WorkloadArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{WorkloadArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	if v.WorkloadArn == nil || len(*v.WorkloadArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadArn must not be empty")}
	}
	if v.WorkloadArn != nil {
		if err := encoder.SetURI("WorkloadArn").String(*v.WorkloadArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAnswer struct {
}

func (*awsRestjson1_serializeOpUpdateAnswer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAnswer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAnswerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers/{QuestionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAnswerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAnswerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAnswerInput(v *UpdateAnswerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	if v.QuestionId == nil || len(*v.QuestionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QuestionId must not be empty")}
	}
	if v.QuestionId != nil {
		if err := encoder.SetURI("QuestionId").String(*v.QuestionId); err != nil {
			return err
		}
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAnswerInput(v *UpdateAnswerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChoiceUpdates != nil {
		ok := object.Key("ChoiceUpdates")
		if err := awsRestjson1_serializeDocumentChoiceUpdates(v.ChoiceUpdates, ok); err != nil {
			return err
		}
	}

	if v.IsApplicable {
		ok := object.Key("IsApplicable")
		ok.Boolean(v.IsApplicable)
	}

	if v.Notes != nil {
		ok := object.Key("Notes")
		ok.String(*v.Notes)
	}

	if len(v.Reason) > 0 {
		ok := object.Key("Reason")
		ok.String(string(v.Reason))
	}

	if v.SelectedChoices != nil {
		ok := object.Key("SelectedChoices")
		if err := awsRestjson1_serializeDocumentSelectedChoices(v.SelectedChoices, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateLensReview struct {
}

func (*awsRestjson1_serializeOpUpdateLensReview) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateLensReview) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateLensReviewInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/lensReviews/{LensAlias}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateLensReviewInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateLensReviewInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateLensReviewInput(v *UpdateLensReviewInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateLensReviewInput(v *UpdateLensReviewInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LensNotes != nil {
		ok := object.Key("LensNotes")
		ok.String(*v.LensNotes)
	}

	if v.PillarNotes != nil {
		ok := object.Key("PillarNotes")
		if err := awsRestjson1_serializeDocumentPillarNotes(v.PillarNotes, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateShareInvitation struct {
}

func (*awsRestjson1_serializeOpUpdateShareInvitation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateShareInvitation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateShareInvitationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/shareInvitations/{ShareInvitationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateShareInvitationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateShareInvitationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateShareInvitationInput(v *UpdateShareInvitationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ShareInvitationId == nil || len(*v.ShareInvitationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ShareInvitationId must not be empty")}
	}
	if v.ShareInvitationId != nil {
		if err := encoder.SetURI("ShareInvitationId").String(*v.ShareInvitationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateShareInvitationInput(v *UpdateShareInvitationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ShareInvitationAction) > 0 {
		ok := object.Key("ShareInvitationAction")
		ok.String(string(v.ShareInvitationAction))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateWorkload struct {
}

func (*awsRestjson1_serializeOpUpdateWorkload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateWorkload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateWorkloadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateWorkloadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateWorkloadInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateWorkloadInput(v *UpdateWorkloadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateWorkloadInput(v *UpdateWorkloadInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("AccountIds")
		if err := awsRestjson1_serializeDocumentWorkloadAccountIds(v.AccountIds, ok); err != nil {
			return err
		}
	}

	if v.ArchitecturalDesign != nil {
		ok := object.Key("ArchitecturalDesign")
		ok.String(*v.ArchitecturalDesign)
	}

	if v.AwsRegions != nil {
		ok := object.Key("AwsRegions")
		if err := awsRestjson1_serializeDocumentWorkloadAwsRegions(v.AwsRegions, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if len(v.Environment) > 0 {
		ok := object.Key("Environment")
		ok.String(string(v.Environment))
	}

	if len(v.ImprovementStatus) > 0 {
		ok := object.Key("ImprovementStatus")
		ok.String(string(v.ImprovementStatus))
	}

	if v.Industry != nil {
		ok := object.Key("Industry")
		ok.String(*v.Industry)
	}

	if v.IndustryType != nil {
		ok := object.Key("IndustryType")
		ok.String(*v.IndustryType)
	}

	if v.IsReviewOwnerUpdateAcknowledged {
		ok := object.Key("IsReviewOwnerUpdateAcknowledged")
		ok.Boolean(v.IsReviewOwnerUpdateAcknowledged)
	}

	if v.NonAwsRegions != nil {
		ok := object.Key("NonAwsRegions")
		if err := awsRestjson1_serializeDocumentWorkloadNonAwsRegions(v.NonAwsRegions, ok); err != nil {
			return err
		}
	}

	if v.Notes != nil {
		ok := object.Key("Notes")
		ok.String(*v.Notes)
	}

	if v.PillarPriorities != nil {
		ok := object.Key("PillarPriorities")
		if err := awsRestjson1_serializeDocumentWorkloadPillarPriorities(v.PillarPriorities, ok); err != nil {
			return err
		}
	}

	if v.ReviewOwner != nil {
		ok := object.Key("ReviewOwner")
		ok.String(*v.ReviewOwner)
	}

	if v.WorkloadName != nil {
		ok := object.Key("WorkloadName")
		ok.String(*v.WorkloadName)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateWorkloadShare struct {
}

func (*awsRestjson1_serializeOpUpdateWorkloadShare) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateWorkloadShare) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateWorkloadShareInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/shares/{ShareId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateWorkloadShareInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateWorkloadShareInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateWorkloadShareInput(v *UpdateWorkloadShareInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ShareId == nil || len(*v.ShareId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ShareId must not be empty")}
	}
	if v.ShareId != nil {
		if err := encoder.SetURI("ShareId").String(*v.ShareId); err != nil {
			return err
		}
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateWorkloadShareInput(v *UpdateWorkloadShareInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.PermissionType) > 0 {
		ok := object.Key("PermissionType")
		ok.String(string(v.PermissionType))
	}

	return nil
}

type awsRestjson1_serializeOpUpgradeLensReview struct {
}

func (*awsRestjson1_serializeOpUpgradeLensReview) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpgradeLensReview) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpgradeLensReviewInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workloads/{WorkloadId}/lensReviews/{LensAlias}/upgrade")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpgradeLensReviewInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpgradeLensReviewInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpgradeLensReviewInput(v *UpgradeLensReviewInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LensAlias == nil || len(*v.LensAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LensAlias must not be empty")}
	}
	if v.LensAlias != nil {
		if err := encoder.SetURI("LensAlias").String(*v.LensAlias); err != nil {
			return err
		}
	}

	if v.WorkloadId == nil || len(*v.WorkloadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkloadId must not be empty")}
	}
	if v.WorkloadId != nil {
		if err := encoder.SetURI("WorkloadId").String(*v.WorkloadId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpgradeLensReviewInput(v *UpgradeLensReviewInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.MilestoneName != nil {
		ok := object.Key("MilestoneName")
		ok.String(*v.MilestoneName)
	}

	return nil
}

func awsRestjson1_serializeDocumentChoiceUpdate(v *types.ChoiceUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Notes != nil {
		ok := object.Key("Notes")
		ok.String(*v.Notes)
	}

	if len(v.Reason) > 0 {
		ok := object.Key("Reason")
		ok.String(string(v.Reason))
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocumentChoiceUpdates(v map[string]types.ChoiceUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentChoiceUpdate(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLensAliases(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentPillarNotes(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentSelectedChoices(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentWorkloadAccountIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentWorkloadAwsRegions(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentWorkloadLenses(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentWorkloadNonAwsRegions(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentWorkloadPillarPriorities(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}
