// Code generated by smithy-go-codegen DO NOT EDIT.

package transcribe

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/transcribe/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing vocabulary with new values. The UpdateVocabulary operation
// overwrites all of the existing information with the values that you provide in
// the request.
func (c *Client) UpdateVocabulary(ctx context.Context, params *UpdateVocabularyInput, optFns ...func(*Options)) (*UpdateVocabularyOutput, error) {
	if params == nil {
		params = &UpdateVocabularyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateVocabulary", params, optFns, c.addOperationUpdateVocabularyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateVocabularyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateVocabularyInput struct {

	// The language code of the vocabulary entries. For a list of languages and their
	// corresponding language codes, see Supported languages
	// (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html).
	//
	// This member is required.
	LanguageCode types.LanguageCode

	// The name of the vocabulary to update. The name is case sensitive. If you try to
	// update a vocabulary with the same name as a previous vocabulary you will receive
	// a ConflictException error.
	//
	// This member is required.
	VocabularyName *string

	// An array of strings containing the vocabulary entries.
	Phrases []string

	// The S3 location of the text file that contains the definition of the custom
	// vocabulary. The URI must be in the same region as the API endpoint that you are
	// calling. The general form is: https://s3..amazonaws.com/// For example:
	// https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt For more
	// information about S3 object names, see Object Keys
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
	// in the Amazon S3 Developer Guide. For more information about custom
	// vocabularies, see Custom Vocabularies
	// (https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
	VocabularyFileUri *string

	noSmithyDocumentSerde
}

type UpdateVocabularyOutput struct {

	// The language code of the vocabulary entries.
	LanguageCode types.LanguageCode

	// The date and time that the vocabulary was updated.
	LastModifiedTime *time.Time

	// The name of the vocabulary that was updated.
	VocabularyName *string

	// The processing state of the vocabulary. When the VocabularyState field contains
	// READY the vocabulary is ready to be used in a StartTranscriptionJob request.
	VocabularyState types.VocabularyState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateVocabularyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateVocabulary{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateVocabulary{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateVocabularyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateVocabulary(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateVocabulary(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "transcribe",
		OperationName: "UpdateVocabulary",
	}
}
