// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Represents a Amazon Web Services Service Catalog AppRegistry application that is
// the top-level node in a hierarchy of related cloud resource abstractions.
type Application struct {

	// The Amazon resource name (ARN) that specifies the application across services.
	Arn *string

	// The ISO-8601 formatted timestamp of the moment when the application was created.
	CreationTime *time.Time

	// The description of the application.
	Description *string

	// The identifier of the application.
	Id *string

	// The ISO-8601 formatted timestamp of the moment when the application was last
	// updated.
	LastUpdateTime *time.Time

	// The name of the application. The name must be unique in the region in which you
	// are creating the application.
	Name *string

	// Key-value pairs you can use to associate with the application.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Summary of a Amazon Web Services Service Catalog AppRegistry application.
type ApplicationSummary struct {

	// The Amazon resource name (ARN) that specifies the application across services.
	Arn *string

	// The ISO-8601 formatted timestamp of the moment when the application was created.
	CreationTime *time.Time

	// The description of the application.
	Description *string

	// The identifier of the application.
	Id *string

	// The ISO-8601 formatted timestamp of the moment when the application was last
	// updated.
	LastUpdateTime *time.Time

	// The name of the application. The name must be unique in the region in which you
	// are creating the application.
	Name *string

	noSmithyDocumentSerde
}

// Represents a Amazon Web Services Service Catalog AppRegistry attribute group
// that is rich metadata which describes an application and its components.
type AttributeGroup struct {

	// The Amazon resource name (ARN) that specifies the attribute group across
	// services.
	Arn *string

	// The ISO-8601 formatted timestamp of the moment the attribute group was created.
	CreationTime *time.Time

	// The description of the attribute group that the user provides.
	Description *string

	// The globally unique attribute group identifier of the attribute group.
	Id *string

	// The ISO-8601 formatted timestamp of the moment the attribute group was last
	// updated. This time is the same as the creationTime for a newly created attribute
	// group.
	LastUpdateTime *time.Time

	// The name of the attribute group.
	Name *string

	// Key-value pairs you can use to associate with the attribute group.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Summary of a Amazon Web Services Service Catalog AppRegistry attribute group.
type AttributeGroupSummary struct {

	// The Amazon resource name (ARN) that specifies the attribute group across
	// services.
	Arn *string

	// The ISO-8601 formatted timestamp of the moment the attribute group was created.
	CreationTime *time.Time

	// The description of the attribute group that the user provides.
	Description *string

	// The globally unique attribute group identifier of the attribute group.
	Id *string

	// The ISO-8601 formatted timestamp of the moment the attribute group was last
	// updated. This time is the same as the creationTime for a newly created attribute
	// group.
	LastUpdateTime *time.Time

	// The name of the attribute group.
	Name *string

	noSmithyDocumentSerde
}

// The information about the service integration.
type Integrations struct {

	// The information about the resource group integration.
	ResourceGroup *ResourceGroup

	noSmithyDocumentSerde
}

// The information about the resource.
type Resource struct {

	// The Amazon resource name (ARN) of the resource.
	Arn *string

	// The time the resource was associated with the application.
	AssociationTime *time.Time

	// The service integration information about the resource.
	Integrations *ResourceIntegrations

	// The name of the resource.
	Name *string

	noSmithyDocumentSerde
}

// The information about the resource group integration.
type ResourceGroup struct {

	// The Amazon resource name (ARN) of the resource group.
	Arn *string

	// The error message that generates when the propagation process for the resource
	// group fails.
	ErrorMessage *string

	// The state of the propagation process for the resource group. The states
	// includes: CREATING if the resource group is in the process of being created.
	// CREATE_COMPLETE if the resource group was created successfully. CREATE_FAILED if
	// the resource group failed to be created. UPDATING if the resource group is in
	// the process of being updated. UPDATE_COMPLETE if the resource group updated
	// successfully. UPDATE_FAILED if the resource group could not update successfully.
	State ResourceGroupState

	noSmithyDocumentSerde
}

// The information about the resource.
type ResourceInfo struct {

	// The Amazon resource name (ARN) that specifies the resource across services.
	Arn *string

	// The name of the resource.
	Name *string

	noSmithyDocumentSerde
}

// The service integration information about the resource.
type ResourceIntegrations struct {

	// The information about the integration of Resource Groups.
	ResourceGroup *ResourceGroup

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
