// Code generated by smithy-go-codegen DO NOT EDIT.

package rum

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/rum/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Sends telemetry events about your application performance and user behavior to
// CloudWatch RUM. The code snippet that RUM generates for you to add to your
// application includes PutRumEvents operations to send this data to RUM. Each
// PutRumEvents operation can send a batch of events from one user session.
func (c *Client) PutRumEvents(ctx context.Context, params *PutRumEventsInput, optFns ...func(*Options)) (*PutRumEventsOutput, error) {
	if params == nil {
		params = &PutRumEventsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutRumEvents", params, optFns, c.addOperationPutRumEventsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutRumEventsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutRumEventsInput struct {

	// A structure that contains information about the app monitor that collected this
	// telemetry information.
	//
	// This member is required.
	AppMonitorDetails *types.AppMonitorDetails

	// A unique identifier for this batch of RUM event data.
	//
	// This member is required.
	BatchId *string

	// The ID of the app monitor that is sending this data.
	//
	// This member is required.
	Id *string

	// An array of structures that contain the telemetry event data.
	//
	// This member is required.
	RumEvents []types.RumEvent

	// A structure that contains information about the user session that this batch of
	// events was collected from.
	//
	// This member is required.
	UserDetails *types.UserDetails

	noSmithyDocumentSerde
}

type PutRumEventsOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutRumEventsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutRumEvents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutRumEvents{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opPutRumEventsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPutRumEventsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutRumEvents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opPutRumEventsMiddleware struct {
}

func (*endpointPrefix_opPutRumEventsMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opPutRumEventsMiddleware) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleSerialize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "dataplane." + req.URL.Host

	return next.HandleSerialize(ctx, in)
}
func addEndpointPrefix_opPutRumEventsMiddleware(stack *middleware.Stack) error {
	return stack.Serialize.Insert(&endpointPrefix_opPutRumEventsMiddleware{}, `OperationSerializer`, middleware.After)
}

func newServiceMetadataMiddleware_opPutRumEvents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "rum",
		OperationName: "PutRumEvents",
	}
}
