// Code generated by smithy-go-codegen DO NOT EDIT.

package lookoutmetrics

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/lookoutmetrics/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpActivateAnomalyDetector struct {
}

func (*awsRestjson1_serializeOpActivateAnomalyDetector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpActivateAnomalyDetector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ActivateAnomalyDetectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ActivateAnomalyDetector")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentActivateAnomalyDetectorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsActivateAnomalyDetectorInput(v *ActivateAnomalyDetectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentActivateAnomalyDetectorInput(v *ActivateAnomalyDetectorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	return nil
}

type awsRestjson1_serializeOpBackTestAnomalyDetector struct {
}

func (*awsRestjson1_serializeOpBackTestAnomalyDetector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBackTestAnomalyDetector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BackTestAnomalyDetectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/BackTestAnomalyDetector")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBackTestAnomalyDetectorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBackTestAnomalyDetectorInput(v *BackTestAnomalyDetectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBackTestAnomalyDetectorInput(v *BackTestAnomalyDetectorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	return nil
}

type awsRestjson1_serializeOpCreateAlert struct {
}

func (*awsRestjson1_serializeOpCreateAlert) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAlert) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAlertInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/CreateAlert")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAlertInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAlertInput(v *CreateAlertInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAlertInput(v *CreateAlertInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("Action")
		if err := awsRestjson1_serializeDocumentAction(v.Action, ok); err != nil {
			return err
		}
	}

	if v.AlertDescription != nil {
		ok := object.Key("AlertDescription")
		ok.String(*v.AlertDescription)
	}

	if v.AlertName != nil {
		ok := object.Key("AlertName")
		ok.String(*v.AlertName)
	}

	{
		ok := object.Key("AlertSensitivityThreshold")
		ok.Integer(v.AlertSensitivityThreshold)
	}

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateAnomalyDetector struct {
}

func (*awsRestjson1_serializeOpCreateAnomalyDetector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAnomalyDetector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAnomalyDetectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/CreateAnomalyDetector")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAnomalyDetectorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAnomalyDetectorInput(v *CreateAnomalyDetectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAnomalyDetectorInput(v *CreateAnomalyDetectorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorConfig != nil {
		ok := object.Key("AnomalyDetectorConfig")
		if err := awsRestjson1_serializeDocumentAnomalyDetectorConfig(v.AnomalyDetectorConfig, ok); err != nil {
			return err
		}
	}

	if v.AnomalyDetectorDescription != nil {
		ok := object.Key("AnomalyDetectorDescription")
		ok.String(*v.AnomalyDetectorDescription)
	}

	if v.AnomalyDetectorName != nil {
		ok := object.Key("AnomalyDetectorName")
		ok.String(*v.AnomalyDetectorName)
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("KmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateMetricSet struct {
}

func (*awsRestjson1_serializeOpCreateMetricSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateMetricSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMetricSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/CreateMetricSet")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateMetricSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateMetricSetInput(v *CreateMetricSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateMetricSetInput(v *CreateMetricSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	if v.DimensionList != nil {
		ok := object.Key("DimensionList")
		if err := awsRestjson1_serializeDocumentDimensionList(v.DimensionList, ok); err != nil {
			return err
		}
	}

	if v.MetricList != nil {
		ok := object.Key("MetricList")
		if err := awsRestjson1_serializeDocumentMetricList(v.MetricList, ok); err != nil {
			return err
		}
	}

	if v.MetricSetDescription != nil {
		ok := object.Key("MetricSetDescription")
		ok.String(*v.MetricSetDescription)
	}

	if len(v.MetricSetFrequency) > 0 {
		ok := object.Key("MetricSetFrequency")
		ok.String(string(v.MetricSetFrequency))
	}

	if v.MetricSetName != nil {
		ok := object.Key("MetricSetName")
		ok.String(*v.MetricSetName)
	}

	if v.MetricSource != nil {
		ok := object.Key("MetricSource")
		if err := awsRestjson1_serializeDocumentMetricSource(v.MetricSource, ok); err != nil {
			return err
		}
	}

	if v.Offset != 0 {
		ok := object.Key("Offset")
		ok.Integer(v.Offset)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TimestampColumn != nil {
		ok := object.Key("TimestampColumn")
		if err := awsRestjson1_serializeDocumentTimestampColumn(v.TimestampColumn, ok); err != nil {
			return err
		}
	}

	if v.Timezone != nil {
		ok := object.Key("Timezone")
		ok.String(*v.Timezone)
	}

	return nil
}

type awsRestjson1_serializeOpDeactivateAnomalyDetector struct {
}

func (*awsRestjson1_serializeOpDeactivateAnomalyDetector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeactivateAnomalyDetector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeactivateAnomalyDetectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/DeactivateAnomalyDetector")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeactivateAnomalyDetectorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeactivateAnomalyDetectorInput(v *DeactivateAnomalyDetectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeactivateAnomalyDetectorInput(v *DeactivateAnomalyDetectorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAlert struct {
}

func (*awsRestjson1_serializeOpDeleteAlert) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAlert) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAlertInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/DeleteAlert")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteAlertInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAlertInput(v *DeleteAlertInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteAlertInput(v *DeleteAlertInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AlertArn != nil {
		ok := object.Key("AlertArn")
		ok.String(*v.AlertArn)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAnomalyDetector struct {
}

func (*awsRestjson1_serializeOpDeleteAnomalyDetector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAnomalyDetector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAnomalyDetectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/DeleteAnomalyDetector")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteAnomalyDetectorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAnomalyDetectorInput(v *DeleteAnomalyDetectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteAnomalyDetectorInput(v *DeleteAnomalyDetectorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAlert struct {
}

func (*awsRestjson1_serializeOpDescribeAlert) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAlert) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAlertInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/DescribeAlert")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeAlertInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAlertInput(v *DescribeAlertInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeAlertInput(v *DescribeAlertInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AlertArn != nil {
		ok := object.Key("AlertArn")
		ok.String(*v.AlertArn)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAnomalyDetectionExecutions struct {
}

func (*awsRestjson1_serializeOpDescribeAnomalyDetectionExecutions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAnomalyDetectionExecutions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAnomalyDetectionExecutionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/DescribeAnomalyDetectionExecutions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeAnomalyDetectionExecutionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAnomalyDetectionExecutionsInput(v *DescribeAnomalyDetectionExecutionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeAnomalyDetectionExecutionsInput(v *DescribeAnomalyDetectionExecutionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Timestamp != nil {
		ok := object.Key("Timestamp")
		ok.String(*v.Timestamp)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAnomalyDetector struct {
}

func (*awsRestjson1_serializeOpDescribeAnomalyDetector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAnomalyDetector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAnomalyDetectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/DescribeAnomalyDetector")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeAnomalyDetectorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAnomalyDetectorInput(v *DescribeAnomalyDetectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeAnomalyDetectorInput(v *DescribeAnomalyDetectorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeMetricSet struct {
}

func (*awsRestjson1_serializeOpDescribeMetricSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeMetricSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMetricSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/DescribeMetricSet")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeMetricSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeMetricSetInput(v *DescribeMetricSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeMetricSetInput(v *DescribeMetricSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MetricSetArn != nil {
		ok := object.Key("MetricSetArn")
		ok.String(*v.MetricSetArn)
	}

	return nil
}

type awsRestjson1_serializeOpGetAnomalyGroup struct {
}

func (*awsRestjson1_serializeOpGetAnomalyGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAnomalyGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAnomalyGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/GetAnomalyGroup")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetAnomalyGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAnomalyGroupInput(v *GetAnomalyGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetAnomalyGroupInput(v *GetAnomalyGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	if v.AnomalyGroupId != nil {
		ok := object.Key("AnomalyGroupId")
		ok.String(*v.AnomalyGroupId)
	}

	return nil
}

type awsRestjson1_serializeOpGetFeedback struct {
}

func (*awsRestjson1_serializeOpGetFeedback) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFeedback) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFeedbackInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/GetFeedback")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetFeedbackInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFeedbackInput(v *GetFeedbackInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetFeedbackInput(v *GetFeedbackInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	if v.AnomalyGroupTimeSeriesFeedback != nil {
		ok := object.Key("AnomalyGroupTimeSeriesFeedback")
		if err := awsRestjson1_serializeDocumentAnomalyGroupTimeSeries(v.AnomalyGroupTimeSeriesFeedback, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetSampleData struct {
}

func (*awsRestjson1_serializeOpGetSampleData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSampleData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSampleDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/GetSampleData")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetSampleDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSampleDataInput(v *GetSampleDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetSampleDataInput(v *GetSampleDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3SourceConfig != nil {
		ok := object.Key("S3SourceConfig")
		if err := awsRestjson1_serializeDocumentSampleDataS3SourceConfig(v.S3SourceConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListAlerts struct {
}

func (*awsRestjson1_serializeOpListAlerts) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAlerts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAlertsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ListAlerts")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListAlertsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAlertsInput(v *ListAlertsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListAlertsInput(v *ListAlertsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListAnomalyDetectors struct {
}

func (*awsRestjson1_serializeOpListAnomalyDetectors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAnomalyDetectors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAnomalyDetectorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ListAnomalyDetectors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListAnomalyDetectorsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAnomalyDetectorsInput(v *ListAnomalyDetectorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListAnomalyDetectorsInput(v *ListAnomalyDetectorsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListAnomalyGroupRelatedMetrics struct {
}

func (*awsRestjson1_serializeOpListAnomalyGroupRelatedMetrics) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAnomalyGroupRelatedMetrics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAnomalyGroupRelatedMetricsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ListAnomalyGroupRelatedMetrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListAnomalyGroupRelatedMetricsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAnomalyGroupRelatedMetricsInput(v *ListAnomalyGroupRelatedMetricsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListAnomalyGroupRelatedMetricsInput(v *ListAnomalyGroupRelatedMetricsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	if v.AnomalyGroupId != nil {
		ok := object.Key("AnomalyGroupId")
		ok.String(*v.AnomalyGroupId)
	}

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.RelationshipTypeFilter) > 0 {
		ok := object.Key("RelationshipTypeFilter")
		ok.String(string(v.RelationshipTypeFilter))
	}

	return nil
}

type awsRestjson1_serializeOpListAnomalyGroupSummaries struct {
}

func (*awsRestjson1_serializeOpListAnomalyGroupSummaries) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAnomalyGroupSummaries) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAnomalyGroupSummariesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ListAnomalyGroupSummaries")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListAnomalyGroupSummariesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAnomalyGroupSummariesInput(v *ListAnomalyGroupSummariesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListAnomalyGroupSummariesInput(v *ListAnomalyGroupSummariesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	{
		ok := object.Key("SensitivityThreshold")
		ok.Integer(v.SensitivityThreshold)
	}

	return nil
}

type awsRestjson1_serializeOpListAnomalyGroupTimeSeries struct {
}

func (*awsRestjson1_serializeOpListAnomalyGroupTimeSeries) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAnomalyGroupTimeSeries) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAnomalyGroupTimeSeriesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ListAnomalyGroupTimeSeries")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListAnomalyGroupTimeSeriesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAnomalyGroupTimeSeriesInput(v *ListAnomalyGroupTimeSeriesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListAnomalyGroupTimeSeriesInput(v *ListAnomalyGroupTimeSeriesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	if v.AnomalyGroupId != nil {
		ok := object.Key("AnomalyGroupId")
		ok.String(*v.AnomalyGroupId)
	}

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.MetricName != nil {
		ok := object.Key("MetricName")
		ok.String(*v.MetricName)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListMetricSets struct {
}

func (*awsRestjson1_serializeOpListMetricSets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMetricSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMetricSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ListMetricSets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListMetricSetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMetricSetsInput(v *ListMetricSetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListMetricSetsInput(v *ListMetricSetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutFeedback struct {
}

func (*awsRestjson1_serializeOpPutFeedback) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutFeedback) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutFeedbackInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/PutFeedback")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutFeedbackInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutFeedbackInput(v *PutFeedbackInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutFeedbackInput(v *PutFeedbackInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	if v.AnomalyGroupTimeSeriesFeedback != nil {
		ok := object.Key("AnomalyGroupTimeSeriesFeedback")
		if err := awsRestjson1_serializeDocumentAnomalyGroupTimeSeriesFeedback(v.AnomalyGroupTimeSeriesFeedback, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAnomalyDetector struct {
}

func (*awsRestjson1_serializeOpUpdateAnomalyDetector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAnomalyDetector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAnomalyDetectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/UpdateAnomalyDetector")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAnomalyDetectorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAnomalyDetectorInput(v *UpdateAnomalyDetectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAnomalyDetectorInput(v *UpdateAnomalyDetectorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyDetectorArn != nil {
		ok := object.Key("AnomalyDetectorArn")
		ok.String(*v.AnomalyDetectorArn)
	}

	if v.AnomalyDetectorConfig != nil {
		ok := object.Key("AnomalyDetectorConfig")
		if err := awsRestjson1_serializeDocumentAnomalyDetectorConfig(v.AnomalyDetectorConfig, ok); err != nil {
			return err
		}
	}

	if v.AnomalyDetectorDescription != nil {
		ok := object.Key("AnomalyDetectorDescription")
		ok.String(*v.AnomalyDetectorDescription)
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("KmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateMetricSet struct {
}

func (*awsRestjson1_serializeOpUpdateMetricSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateMetricSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateMetricSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/UpdateMetricSet")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateMetricSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateMetricSetInput(v *UpdateMetricSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateMetricSetInput(v *UpdateMetricSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DimensionList != nil {
		ok := object.Key("DimensionList")
		if err := awsRestjson1_serializeDocumentDimensionList(v.DimensionList, ok); err != nil {
			return err
		}
	}

	if v.MetricList != nil {
		ok := object.Key("MetricList")
		if err := awsRestjson1_serializeDocumentMetricList(v.MetricList, ok); err != nil {
			return err
		}
	}

	if v.MetricSetArn != nil {
		ok := object.Key("MetricSetArn")
		ok.String(*v.MetricSetArn)
	}

	if v.MetricSetDescription != nil {
		ok := object.Key("MetricSetDescription")
		ok.String(*v.MetricSetDescription)
	}

	if len(v.MetricSetFrequency) > 0 {
		ok := object.Key("MetricSetFrequency")
		ok.String(string(v.MetricSetFrequency))
	}

	if v.MetricSource != nil {
		ok := object.Key("MetricSource")
		if err := awsRestjson1_serializeDocumentMetricSource(v.MetricSource, ok); err != nil {
			return err
		}
	}

	if v.Offset != 0 {
		ok := object.Key("Offset")
		ok.Integer(v.Offset)
	}

	if v.TimestampColumn != nil {
		ok := object.Key("TimestampColumn")
		if err := awsRestjson1_serializeDocumentTimestampColumn(v.TimestampColumn, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAction(v *types.Action, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LambdaConfiguration != nil {
		ok := object.Key("LambdaConfiguration")
		if err := awsRestjson1_serializeDocumentLambdaConfiguration(v.LambdaConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SNSConfiguration != nil {
		ok := object.Key("SNSConfiguration")
		if err := awsRestjson1_serializeDocumentSNSConfiguration(v.SNSConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnomalyDetectorConfig(v *types.AnomalyDetectorConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AnomalyDetectorFrequency) > 0 {
		ok := object.Key("AnomalyDetectorFrequency")
		ok.String(string(v.AnomalyDetectorFrequency))
	}

	return nil
}

func awsRestjson1_serializeDocumentAnomalyGroupTimeSeries(v *types.AnomalyGroupTimeSeries, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyGroupId != nil {
		ok := object.Key("AnomalyGroupId")
		ok.String(*v.AnomalyGroupId)
	}

	if v.TimeSeriesId != nil {
		ok := object.Key("TimeSeriesId")
		ok.String(*v.TimeSeriesId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAnomalyGroupTimeSeriesFeedback(v *types.AnomalyGroupTimeSeriesFeedback, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnomalyGroupId != nil {
		ok := object.Key("AnomalyGroupId")
		ok.String(*v.AnomalyGroupId)
	}

	if v.IsAnomaly != nil {
		ok := object.Key("IsAnomaly")
		ok.Boolean(*v.IsAnomaly)
	}

	if v.TimeSeriesId != nil {
		ok := object.Key("TimeSeriesId")
		ok.String(*v.TimeSeriesId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAppFlowConfig(v *types.AppFlowConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowName != nil {
		ok := object.Key("FlowName")
		ok.String(*v.FlowName)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentCloudWatchConfig(v *types.CloudWatchConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentCsvFormatDescriptor(v *types.CsvFormatDescriptor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Charset != nil {
		ok := object.Key("Charset")
		ok.String(*v.Charset)
	}

	if v.ContainsHeader != nil {
		ok := object.Key("ContainsHeader")
		ok.Boolean(*v.ContainsHeader)
	}

	if v.Delimiter != nil {
		ok := object.Key("Delimiter")
		ok.String(*v.Delimiter)
	}

	if len(v.FileCompression) > 0 {
		ok := object.Key("FileCompression")
		ok.String(string(v.FileCompression))
	}

	if v.HeaderList != nil {
		ok := object.Key("HeaderList")
		if err := awsRestjson1_serializeDocumentHeaderList(v.HeaderList, ok); err != nil {
			return err
		}
	}

	if v.QuoteSymbol != nil {
		ok := object.Key("QuoteSymbol")
		ok.String(*v.QuoteSymbol)
	}

	return nil
}

func awsRestjson1_serializeDocumentDimensionList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFileFormatDescriptor(v *types.FileFormatDescriptor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CsvFormatDescriptor != nil {
		ok := object.Key("CsvFormatDescriptor")
		if err := awsRestjson1_serializeDocumentCsvFormatDescriptor(v.CsvFormatDescriptor, ok); err != nil {
			return err
		}
	}

	if v.JsonFormatDescriptor != nil {
		ok := object.Key("JsonFormatDescriptor")
		if err := awsRestjson1_serializeDocumentJsonFormatDescriptor(v.JsonFormatDescriptor, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHeaderList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentHistoricalDataPathList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentJsonFormatDescriptor(v *types.JsonFormatDescriptor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Charset != nil {
		ok := object.Key("Charset")
		ok.String(*v.Charset)
	}

	if len(v.FileCompression) > 0 {
		ok := object.Key("FileCompression")
		ok.String(string(v.FileCompression))
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaConfiguration(v *types.LambdaConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LambdaArn != nil {
		ok := object.Key("LambdaArn")
		ok.String(*v.LambdaArn)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentMetric(v *types.Metric, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AggregationFunction) > 0 {
		ok := object.Key("AggregationFunction")
		ok.String(string(v.AggregationFunction))
	}

	if v.MetricName != nil {
		ok := object.Key("MetricName")
		ok.String(*v.MetricName)
	}

	if v.Namespace != nil {
		ok := object.Key("Namespace")
		ok.String(*v.Namespace)
	}

	return nil
}

func awsRestjson1_serializeDocumentMetricList(v []types.Metric, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMetric(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMetricSource(v *types.MetricSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppFlowConfig != nil {
		ok := object.Key("AppFlowConfig")
		if err := awsRestjson1_serializeDocumentAppFlowConfig(v.AppFlowConfig, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchConfig != nil {
		ok := object.Key("CloudWatchConfig")
		if err := awsRestjson1_serializeDocumentCloudWatchConfig(v.CloudWatchConfig, ok); err != nil {
			return err
		}
	}

	if v.RDSSourceConfig != nil {
		ok := object.Key("RDSSourceConfig")
		if err := awsRestjson1_serializeDocumentRDSSourceConfig(v.RDSSourceConfig, ok); err != nil {
			return err
		}
	}

	if v.RedshiftSourceConfig != nil {
		ok := object.Key("RedshiftSourceConfig")
		if err := awsRestjson1_serializeDocumentRedshiftSourceConfig(v.RedshiftSourceConfig, ok); err != nil {
			return err
		}
	}

	if v.S3SourceConfig != nil {
		ok := object.Key("S3SourceConfig")
		if err := awsRestjson1_serializeDocumentS3SourceConfig(v.S3SourceConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRDSSourceConfig(v *types.RDSSourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatabaseHost != nil {
		ok := object.Key("DatabaseHost")
		ok.String(*v.DatabaseHost)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.DatabasePort != 0 {
		ok := object.Key("DatabasePort")
		ok.Integer(v.DatabasePort)
	}

	if v.DBInstanceIdentifier != nil {
		ok := object.Key("DBInstanceIdentifier")
		ok.String(*v.DBInstanceIdentifier)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecretManagerArn != nil {
		ok := object.Key("SecretManagerArn")
		ok.String(*v.SecretManagerArn)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	if v.VpcConfiguration != nil {
		ok := object.Key("VpcConfiguration")
		if err := awsRestjson1_serializeDocumentVpcConfiguration(v.VpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRedshiftSourceConfig(v *types.RedshiftSourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterIdentifier != nil {
		ok := object.Key("ClusterIdentifier")
		ok.String(*v.ClusterIdentifier)
	}

	if v.DatabaseHost != nil {
		ok := object.Key("DatabaseHost")
		ok.String(*v.DatabaseHost)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.DatabasePort != 0 {
		ok := object.Key("DatabasePort")
		ok.Integer(v.DatabasePort)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecretManagerArn != nil {
		ok := object.Key("SecretManagerArn")
		ok.String(*v.SecretManagerArn)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	if v.VpcConfiguration != nil {
		ok := object.Key("VpcConfiguration")
		if err := awsRestjson1_serializeDocumentVpcConfiguration(v.VpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentS3SourceConfig(v *types.S3SourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FileFormatDescriptor != nil {
		ok := object.Key("FileFormatDescriptor")
		if err := awsRestjson1_serializeDocumentFileFormatDescriptor(v.FileFormatDescriptor, ok); err != nil {
			return err
		}
	}

	if v.HistoricalDataPathList != nil {
		ok := object.Key("HistoricalDataPathList")
		if err := awsRestjson1_serializeDocumentHistoricalDataPathList(v.HistoricalDataPathList, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.TemplatedPathList != nil {
		ok := object.Key("TemplatedPathList")
		if err := awsRestjson1_serializeDocumentTemplatedPathList(v.TemplatedPathList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSampleDataS3SourceConfig(v *types.SampleDataS3SourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FileFormatDescriptor != nil {
		ok := object.Key("FileFormatDescriptor")
		if err := awsRestjson1_serializeDocumentFileFormatDescriptor(v.FileFormatDescriptor, ok); err != nil {
			return err
		}
	}

	if v.HistoricalDataPathList != nil {
		ok := object.Key("HistoricalDataPathList")
		if err := awsRestjson1_serializeDocumentHistoricalDataPathList(v.HistoricalDataPathList, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.TemplatedPathList != nil {
		ok := object.Key("TemplatedPathList")
		if err := awsRestjson1_serializeDocumentTemplatedPathList(v.TemplatedPathList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSNSConfiguration(v *types.SNSConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.SnsTopicArn != nil {
		ok := object.Key("SnsTopicArn")
		ok.String(*v.SnsTopicArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentSubnetIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTemplatedPathList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTimestampColumn(v *types.TimestampColumn, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnFormat != nil {
		ok := object.Key("ColumnFormat")
		ok.String(*v.ColumnFormat)
	}

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	return nil
}

func awsRestjson1_serializeDocumentVpcConfiguration(v *types.VpcConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIdList != nil {
		ok := object.Key("SecurityGroupIdList")
		if err := awsRestjson1_serializeDocumentSecurityGroupIdList(v.SecurityGroupIdList, ok); err != nil {
			return err
		}
	}

	if v.SubnetIdList != nil {
		ok := object.Key("SubnetIdList")
		if err := awsRestjson1_serializeDocumentSubnetIdList(v.SubnetIdList, ok); err != nil {
			return err
		}
	}

	return nil
}
