// Code generated by smithy-go-codegen DO NOT EDIT.

package grafana

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/grafana/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAssociateLicense struct {
}

func (*validateOpAssociateLicense) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociateLicense) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociateLicenseInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociateLicenseInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateWorkspace struct {
}

func (*validateOpCreateWorkspace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateWorkspace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateWorkspaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateWorkspaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteWorkspace struct {
}

func (*validateOpDeleteWorkspace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteWorkspace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteWorkspaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteWorkspaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeWorkspaceAuthentication struct {
}

func (*validateOpDescribeWorkspaceAuthentication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeWorkspaceAuthentication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeWorkspaceAuthenticationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeWorkspaceAuthenticationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeWorkspace struct {
}

func (*validateOpDescribeWorkspace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeWorkspace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeWorkspaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeWorkspaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisassociateLicense struct {
}

func (*validateOpDisassociateLicense) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisassociateLicense) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisassociateLicenseInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisassociateLicenseInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListPermissions struct {
}

func (*validateOpListPermissions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListPermissions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListPermissionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListPermissionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdatePermissions struct {
}

func (*validateOpUpdatePermissions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdatePermissions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdatePermissionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdatePermissionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateWorkspaceAuthentication struct {
}

func (*validateOpUpdateWorkspaceAuthentication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateWorkspaceAuthentication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateWorkspaceAuthenticationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateWorkspaceAuthenticationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateWorkspace struct {
}

func (*validateOpUpdateWorkspace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateWorkspace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateWorkspaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateWorkspaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAssociateLicenseValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociateLicense{}, middleware.After)
}

func addOpCreateWorkspaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateWorkspace{}, middleware.After)
}

func addOpDeleteWorkspaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteWorkspace{}, middleware.After)
}

func addOpDescribeWorkspaceAuthenticationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeWorkspaceAuthentication{}, middleware.After)
}

func addOpDescribeWorkspaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeWorkspace{}, middleware.After)
}

func addOpDisassociateLicenseValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisassociateLicense{}, middleware.After)
}

func addOpListPermissionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListPermissions{}, middleware.After)
}

func addOpUpdatePermissionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdatePermissions{}, middleware.After)
}

func addOpUpdateWorkspaceAuthenticationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateWorkspaceAuthentication{}, middleware.After)
}

func addOpUpdateWorkspaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateWorkspace{}, middleware.After)
}

func validateSamlConfiguration(v *types.SamlConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SamlConfiguration"}
	if v.IdpMetadata == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IdpMetadata"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpdateInstruction(v *types.UpdateInstruction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateInstruction"}
	if len(v.Action) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	}
	if len(v.Role) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Role"))
	}
	if v.Users == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Users"))
	} else if v.Users != nil {
		if err := validateUserList(v.Users); err != nil {
			invalidParams.AddNested("Users", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpdateInstructionBatch(v []types.UpdateInstruction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateInstructionBatch"}
	for i := range v {
		if err := validateUpdateInstruction(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUser(v *types.User) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "User"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUserList(v []types.User) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UserList"}
	for i := range v {
		if err := validateUser(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociateLicenseInput(v *AssociateLicenseInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociateLicenseInput"}
	if v.WorkspaceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkspaceId"))
	}
	if len(v.LicenseType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateWorkspaceInput(v *CreateWorkspaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateWorkspaceInput"}
	if len(v.AccountAccessType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AccountAccessType"))
	}
	if len(v.PermissionType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PermissionType"))
	}
	if v.AuthenticationProviders == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AuthenticationProviders"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteWorkspaceInput(v *DeleteWorkspaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteWorkspaceInput"}
	if v.WorkspaceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkspaceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeWorkspaceAuthenticationInput(v *DescribeWorkspaceAuthenticationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeWorkspaceAuthenticationInput"}
	if v.WorkspaceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkspaceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeWorkspaceInput(v *DescribeWorkspaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeWorkspaceInput"}
	if v.WorkspaceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkspaceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisassociateLicenseInput(v *DisassociateLicenseInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisassociateLicenseInput"}
	if v.WorkspaceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkspaceId"))
	}
	if len(v.LicenseType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListPermissionsInput(v *ListPermissionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListPermissionsInput"}
	if v.WorkspaceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkspaceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdatePermissionsInput(v *UpdatePermissionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdatePermissionsInput"}
	if v.UpdateInstructionBatch == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UpdateInstructionBatch"))
	} else if v.UpdateInstructionBatch != nil {
		if err := validateUpdateInstructionBatch(v.UpdateInstructionBatch); err != nil {
			invalidParams.AddNested("UpdateInstructionBatch", err.(smithy.InvalidParamsError))
		}
	}
	if v.WorkspaceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkspaceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateWorkspaceAuthenticationInput(v *UpdateWorkspaceAuthenticationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateWorkspaceAuthenticationInput"}
	if v.WorkspaceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkspaceId"))
	}
	if v.AuthenticationProviders == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AuthenticationProviders"))
	}
	if v.SamlConfiguration != nil {
		if err := validateSamlConfiguration(v.SamlConfiguration); err != nil {
			invalidParams.AddNested("SamlConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateWorkspaceInput(v *UpdateWorkspaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateWorkspaceInput"}
	if v.WorkspaceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkspaceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
