// Code generated by smithy-go-codegen DO NOT EDIT.

package drs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/drs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all Source Servers or multiple Source Servers filtered by ID.
func (c *Client) DescribeSourceServers(ctx context.Context, params *DescribeSourceServersInput, optFns ...func(*Options)) (*DescribeSourceServersOutput, error) {
	if params == nil {
		params = &DescribeSourceServersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeSourceServers", params, optFns, c.addOperationDescribeSourceServersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeSourceServersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeSourceServersInput struct {

	// A set of filters by which to return Source Servers.
	//
	// This member is required.
	Filters *types.DescribeSourceServersRequestFilters

	// Maximum number of Source Servers to retrieve.
	MaxResults int32

	// The token of the next Source Server to retrieve.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeSourceServersOutput struct {

	// An array of Source Servers.
	Items []types.SourceServer

	// The token of the next Source Server to retrieve.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeSourceServersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeSourceServers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeSourceServers{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeSourceServersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeSourceServers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeSourceServersAPIClient is a client that implements the
// DescribeSourceServers operation.
type DescribeSourceServersAPIClient interface {
	DescribeSourceServers(context.Context, *DescribeSourceServersInput, ...func(*Options)) (*DescribeSourceServersOutput, error)
}

var _ DescribeSourceServersAPIClient = (*Client)(nil)

// DescribeSourceServersPaginatorOptions is the paginator options for
// DescribeSourceServers
type DescribeSourceServersPaginatorOptions struct {
	// Maximum number of Source Servers to retrieve.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeSourceServersPaginator is a paginator for DescribeSourceServers
type DescribeSourceServersPaginator struct {
	options   DescribeSourceServersPaginatorOptions
	client    DescribeSourceServersAPIClient
	params    *DescribeSourceServersInput
	nextToken *string
	firstPage bool
}

// NewDescribeSourceServersPaginator returns a new DescribeSourceServersPaginator
func NewDescribeSourceServersPaginator(client DescribeSourceServersAPIClient, params *DescribeSourceServersInput, optFns ...func(*DescribeSourceServersPaginatorOptions)) *DescribeSourceServersPaginator {
	if params == nil {
		params = &DescribeSourceServersInput{}
	}

	options := DescribeSourceServersPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeSourceServersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeSourceServersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeSourceServers page.
func (p *DescribeSourceServersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeSourceServersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.DescribeSourceServers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeSourceServers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "drs",
		OperationName: "DescribeSourceServers",
	}
}
