// Code generated by smithy-go-codegen DO NOT EDIT.

package dataexchange

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/dataexchange/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCancelJob struct {
}

func (*validateOpCancelJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateDataSet struct {
}

func (*validateOpCreateDataSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateDataSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateDataSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateDataSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateEventAction struct {
}

func (*validateOpCreateEventAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateEventAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateEventActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateEventActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateJob struct {
}

func (*validateOpCreateJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateRevision struct {
}

func (*validateOpCreateRevision) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateRevision) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateRevisionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateRevisionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAsset struct {
}

func (*validateOpDeleteAsset) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAsset) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAssetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAssetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDataSet struct {
}

func (*validateOpDeleteDataSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDataSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDataSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDataSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteEventAction struct {
}

func (*validateOpDeleteEventAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteEventAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteEventActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteEventActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteRevision struct {
}

func (*validateOpDeleteRevision) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteRevision) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteRevisionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteRevisionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAsset struct {
}

func (*validateOpGetAsset) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAsset) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAssetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAssetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDataSet struct {
}

func (*validateOpGetDataSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDataSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDataSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDataSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetEventAction struct {
}

func (*validateOpGetEventAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetEventAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetEventActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetEventActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetJob struct {
}

func (*validateOpGetJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetRevision struct {
}

func (*validateOpGetRevision) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetRevision) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetRevisionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetRevisionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListDataSetRevisions struct {
}

func (*validateOpListDataSetRevisions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListDataSetRevisions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListDataSetRevisionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListDataSetRevisionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListRevisionAssets struct {
}

func (*validateOpListRevisionAssets) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListRevisionAssets) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListRevisionAssetsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListRevisionAssetsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSendApiAsset struct {
}

func (*validateOpSendApiAsset) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSendApiAsset) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SendApiAssetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSendApiAssetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartJob struct {
}

func (*validateOpStartJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateAsset struct {
}

func (*validateOpUpdateAsset) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateAsset) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateAssetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateAssetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateDataSet struct {
}

func (*validateOpUpdateDataSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateDataSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateDataSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateDataSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateEventAction struct {
}

func (*validateOpUpdateEventAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateEventAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateEventActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateEventActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateRevision struct {
}

func (*validateOpUpdateRevision) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateRevision) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateRevisionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateRevisionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCancelJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelJob{}, middleware.After)
}

func addOpCreateDataSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateDataSet{}, middleware.After)
}

func addOpCreateEventActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateEventAction{}, middleware.After)
}

func addOpCreateJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateJob{}, middleware.After)
}

func addOpCreateRevisionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateRevision{}, middleware.After)
}

func addOpDeleteAssetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAsset{}, middleware.After)
}

func addOpDeleteDataSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDataSet{}, middleware.After)
}

func addOpDeleteEventActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteEventAction{}, middleware.After)
}

func addOpDeleteRevisionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteRevision{}, middleware.After)
}

func addOpGetAssetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAsset{}, middleware.After)
}

func addOpGetDataSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDataSet{}, middleware.After)
}

func addOpGetEventActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetEventAction{}, middleware.After)
}

func addOpGetJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetJob{}, middleware.After)
}

func addOpGetRevisionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetRevision{}, middleware.After)
}

func addOpListDataSetRevisionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListDataSetRevisions{}, middleware.After)
}

func addOpListRevisionAssetsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListRevisionAssets{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpSendApiAssetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSendApiAsset{}, middleware.After)
}

func addOpStartJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartJob{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateAssetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateAsset{}, middleware.After)
}

func addOpUpdateDataSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateDataSet{}, middleware.After)
}

func addOpUpdateEventActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateEventAction{}, middleware.After)
}

func addOpUpdateRevisionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateRevision{}, middleware.After)
}

func validateAction(v *types.Action) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Action"}
	if v.ExportRevisionToS3 != nil {
		if err := validateAutoExportRevisionToS3RequestDetails(v.ExportRevisionToS3); err != nil {
			invalidParams.AddNested("ExportRevisionToS3", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAssetDestinationEntry(v *types.AssetDestinationEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssetDestinationEntry"}
	if v.AssetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetId"))
	}
	if v.Bucket == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Bucket"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAssetSourceEntry(v *types.AssetSourceEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssetSourceEntry"}
	if v.Bucket == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Bucket"))
	}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAutoExportRevisionDestinationEntry(v *types.AutoExportRevisionDestinationEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AutoExportRevisionDestinationEntry"}
	if v.Bucket == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Bucket"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAutoExportRevisionToS3RequestDetails(v *types.AutoExportRevisionToS3RequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AutoExportRevisionToS3RequestDetails"}
	if v.Encryption != nil {
		if err := validateExportServerSideEncryption(v.Encryption); err != nil {
			invalidParams.AddNested("Encryption", err.(smithy.InvalidParamsError))
		}
	}
	if v.RevisionDestination == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionDestination"))
	} else if v.RevisionDestination != nil {
		if err := validateAutoExportRevisionDestinationEntry(v.RevisionDestination); err != nil {
			invalidParams.AddNested("RevisionDestination", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEvent(v *types.Event) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Event"}
	if v.RevisionPublished != nil {
		if err := validateRevisionPublished(v.RevisionPublished); err != nil {
			invalidParams.AddNested("RevisionPublished", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExportAssetsToS3RequestDetails(v *types.ExportAssetsToS3RequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExportAssetsToS3RequestDetails"}
	if v.AssetDestinations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetDestinations"))
	} else if v.AssetDestinations != nil {
		if err := validateListOfAssetDestinationEntry(v.AssetDestinations); err != nil {
			invalidParams.AddNested("AssetDestinations", err.(smithy.InvalidParamsError))
		}
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.Encryption != nil {
		if err := validateExportServerSideEncryption(v.Encryption); err != nil {
			invalidParams.AddNested("Encryption", err.(smithy.InvalidParamsError))
		}
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExportAssetToSignedUrlRequestDetails(v *types.ExportAssetToSignedUrlRequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExportAssetToSignedUrlRequestDetails"}
	if v.AssetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetId"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExportRevisionsToS3RequestDetails(v *types.ExportRevisionsToS3RequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExportRevisionsToS3RequestDetails"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.Encryption != nil {
		if err := validateExportServerSideEncryption(v.Encryption); err != nil {
			invalidParams.AddNested("Encryption", err.(smithy.InvalidParamsError))
		}
	}
	if v.RevisionDestinations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionDestinations"))
	} else if v.RevisionDestinations != nil {
		if err := validateListOfRevisionDestinationEntry(v.RevisionDestinations); err != nil {
			invalidParams.AddNested("RevisionDestinations", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExportServerSideEncryption(v *types.ExportServerSideEncryption) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExportServerSideEncryption"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImportAssetFromApiGatewayApiRequestDetails(v *types.ImportAssetFromApiGatewayApiRequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImportAssetFromApiGatewayApiRequestDetails"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.ApiName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiName"))
	}
	if v.ApiSpecificationMd5Hash == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiSpecificationMd5Hash"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if len(v.ProtocolType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ProtocolType"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if v.Stage == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Stage"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImportAssetFromSignedUrlRequestDetails(v *types.ImportAssetFromSignedUrlRequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImportAssetFromSignedUrlRequestDetails"}
	if v.AssetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetName"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.Md5Hash == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Md5Hash"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImportAssetsFromRedshiftDataSharesRequestDetails(v *types.ImportAssetsFromRedshiftDataSharesRequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImportAssetsFromRedshiftDataSharesRequestDetails"}
	if v.AssetSources == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetSources"))
	} else if v.AssetSources != nil {
		if err := validateListOfRedshiftDataShareAssetSourceEntry(v.AssetSources); err != nil {
			invalidParams.AddNested("AssetSources", err.(smithy.InvalidParamsError))
		}
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImportAssetsFromS3RequestDetails(v *types.ImportAssetsFromS3RequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImportAssetsFromS3RequestDetails"}
	if v.AssetSources == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetSources"))
	} else if v.AssetSources != nil {
		if err := validateListOfAssetSourceEntry(v.AssetSources); err != nil {
			invalidParams.AddNested("AssetSources", err.(smithy.InvalidParamsError))
		}
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListOfAssetDestinationEntry(v []types.AssetDestinationEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOfAssetDestinationEntry"}
	for i := range v {
		if err := validateAssetDestinationEntry(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListOfAssetSourceEntry(v []types.AssetSourceEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOfAssetSourceEntry"}
	for i := range v {
		if err := validateAssetSourceEntry(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListOfRedshiftDataShareAssetSourceEntry(v []types.RedshiftDataShareAssetSourceEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOfRedshiftDataShareAssetSourceEntry"}
	for i := range v {
		if err := validateRedshiftDataShareAssetSourceEntry(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListOfRevisionDestinationEntry(v []types.RevisionDestinationEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOfRevisionDestinationEntry"}
	for i := range v {
		if err := validateRevisionDestinationEntry(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRedshiftDataShareAssetSourceEntry(v *types.RedshiftDataShareAssetSourceEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RedshiftDataShareAssetSourceEntry"}
	if v.DataShareArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataShareArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRequestDetails(v *types.RequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RequestDetails"}
	if v.ExportAssetToSignedUrl != nil {
		if err := validateExportAssetToSignedUrlRequestDetails(v.ExportAssetToSignedUrl); err != nil {
			invalidParams.AddNested("ExportAssetToSignedUrl", err.(smithy.InvalidParamsError))
		}
	}
	if v.ExportAssetsToS3 != nil {
		if err := validateExportAssetsToS3RequestDetails(v.ExportAssetsToS3); err != nil {
			invalidParams.AddNested("ExportAssetsToS3", err.(smithy.InvalidParamsError))
		}
	}
	if v.ExportRevisionsToS3 != nil {
		if err := validateExportRevisionsToS3RequestDetails(v.ExportRevisionsToS3); err != nil {
			invalidParams.AddNested("ExportRevisionsToS3", err.(smithy.InvalidParamsError))
		}
	}
	if v.ImportAssetFromSignedUrl != nil {
		if err := validateImportAssetFromSignedUrlRequestDetails(v.ImportAssetFromSignedUrl); err != nil {
			invalidParams.AddNested("ImportAssetFromSignedUrl", err.(smithy.InvalidParamsError))
		}
	}
	if v.ImportAssetsFromS3 != nil {
		if err := validateImportAssetsFromS3RequestDetails(v.ImportAssetsFromS3); err != nil {
			invalidParams.AddNested("ImportAssetsFromS3", err.(smithy.InvalidParamsError))
		}
	}
	if v.ImportAssetsFromRedshiftDataShares != nil {
		if err := validateImportAssetsFromRedshiftDataSharesRequestDetails(v.ImportAssetsFromRedshiftDataShares); err != nil {
			invalidParams.AddNested("ImportAssetsFromRedshiftDataShares", err.(smithy.InvalidParamsError))
		}
	}
	if v.ImportAssetFromApiGatewayApi != nil {
		if err := validateImportAssetFromApiGatewayApiRequestDetails(v.ImportAssetFromApiGatewayApi); err != nil {
			invalidParams.AddNested("ImportAssetFromApiGatewayApi", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRevisionDestinationEntry(v *types.RevisionDestinationEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RevisionDestinationEntry"}
	if v.Bucket == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Bucket"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRevisionPublished(v *types.RevisionPublished) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RevisionPublished"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelJobInput(v *CancelJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateDataSetInput(v *CreateDataSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateDataSetInput"}
	if len(v.AssetType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AssetType"))
	}
	if v.Description == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Description"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateEventActionInput(v *CreateEventActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateEventActionInput"}
	if v.Action == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	} else if v.Action != nil {
		if err := validateAction(v.Action); err != nil {
			invalidParams.AddNested("Action", err.(smithy.InvalidParamsError))
		}
	}
	if v.Event == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Event"))
	} else if v.Event != nil {
		if err := validateEvent(v.Event); err != nil {
			invalidParams.AddNested("Event", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateJobInput(v *CreateJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateJobInput"}
	if v.Details == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Details"))
	} else if v.Details != nil {
		if err := validateRequestDetails(v.Details); err != nil {
			invalidParams.AddNested("Details", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateRevisionInput(v *CreateRevisionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateRevisionInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAssetInput(v *DeleteAssetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAssetInput"}
	if v.AssetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetId"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDataSetInput(v *DeleteDataSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDataSetInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteEventActionInput(v *DeleteEventActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteEventActionInput"}
	if v.EventActionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventActionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteRevisionInput(v *DeleteRevisionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteRevisionInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAssetInput(v *GetAssetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAssetInput"}
	if v.AssetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetId"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDataSetInput(v *GetDataSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDataSetInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetEventActionInput(v *GetEventActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetEventActionInput"}
	if v.EventActionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventActionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetJobInput(v *GetJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetRevisionInput(v *GetRevisionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetRevisionInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListDataSetRevisionsInput(v *ListDataSetRevisionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListDataSetRevisionsInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListRevisionAssetsInput(v *ListRevisionAssetsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListRevisionAssetsInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSendApiAssetInput(v *SendApiAssetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SendApiAssetInput"}
	if v.AssetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetId"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartJobInput(v *StartJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateAssetInput(v *UpdateAssetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateAssetInput"}
	if v.AssetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetId"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateDataSetInput(v *UpdateDataSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateDataSetInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateEventActionInput(v *UpdateEventActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateEventActionInput"}
	if v.Action != nil {
		if err := validateAction(v.Action); err != nil {
			invalidParams.AddNested("Action", err.(smithy.InvalidParamsError))
		}
	}
	if v.EventActionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventActionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateRevisionInput(v *UpdateRevisionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateRevisionInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
