// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Information about the agent who accepted the contact.
type AgentInfo struct {

	// The timestamp when the contact was connected to the agent.
	ConnectedToAgentTimestamp *time.Time

	// The identifier of the agent who accepted the contact.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about an agent status.
type AgentStatus struct {

	// The Amazon Resource Name (ARN) of the agent status.
	AgentStatusARN *string

	// The identifier of the agent status.
	AgentStatusId *string

	// The description of the agent status.
	Description *string

	// The display order of the agent status.
	DisplayOrder *int32

	// The name of the agent status.
	Name *string

	// The state of the agent status.
	State AgentStatusState

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	// The type of agent status.
	Type AgentStatusType

	noSmithyDocumentSerde
}

// Summary information for an agent status.
type AgentStatusSummary struct {

	// The Amazon Resource Name (ARN) for the agent status.
	Arn *string

	// The identifier for an agent status.
	Id *string

	// The name of the agent status.
	Name *string

	// The type of the agent status.
	Type AgentStatusType

	noSmithyDocumentSerde
}

// Configuration of the answering machine detection.
type AnswerMachineDetectionConfig struct {

	// Wait for the answering machine prompt.
	AwaitAnswerMachinePrompt bool

	// The flag to indicate if answer machine detection analysis needs to be performed
	// for a voice call. If set to true, TrafficType must be set as CAMPAIGN.
	EnableAnswerMachineDetection bool

	noSmithyDocumentSerde
}

// Information about the attachment reference if the referenceType is ATTACHMENT.
// Otherwise, null.
type AttachmentReference struct {

	// Identifier of the attachment reference.
	Name *string

	// Status of an attachment reference type.
	Status ReferenceStatus

	// Contains the location path of the attachment reference.
	Value *string

	noSmithyDocumentSerde
}

// A toggle for an individual feature at the instance level.
type Attribute struct {

	// The type of attribute.
	AttributeType InstanceAttributeType

	// The value of the attribute.
	Value *string

	noSmithyDocumentSerde
}

// A chat message.
type ChatMessage struct {

	// The content of the chat message.
	//
	// This member is required.
	Content *string

	// The type of the content. Supported types are text and plain.
	//
	// This member is required.
	ContentType *string

	noSmithyDocumentSerde
}

// The streaming configuration, such as the Amazon SNS streaming endpoint.
type ChatStreamingConfiguration struct {

	// The Amazon Resource Name (ARN) of the standard Amazon SNS topic. The Amazon
	// Resource Name (ARN) of the streaming endpoint that is used to publish real-time
	// message streaming for chat conversations.
	//
	// This member is required.
	StreamingEndpointArn *string

	noSmithyDocumentSerde
}

// Contains information about a contact.
type Contact struct {

	// Information about the agent who accepted the contact.
	AgentInfo *AgentInfo

	// The Amazon Resource Name (ARN) for the contact.
	Arn *string

	// How the contact reached your contact center.
	Channel Channel

	// The description of the contact.
	Description *string

	// The timestamp when the customer endpoint disconnected from Amazon Connect.
	DisconnectTimestamp *time.Time

	// The identifier for the contact.
	Id *string

	// If this contact is related to other contacts, this is the ID of the initial
	// contact.
	InitialContactId *string

	// Indicates how the contact was initiated.
	InitiationMethod ContactInitiationMethod

	// The date and time this contact was initiated, in UTC time. For INBOUND, this is
	// when the contact arrived. For OUTBOUND, this is when the agent began dialing.
	// For CALLBACK, this is when the callback contact was created. For TRANSFER and
	// QUEUE_TRANSFER, this is when the transfer was initiated. For API, this is when
	// the request arrived.
	InitiationTimestamp *time.Time

	// The timestamp when contact was last updated.
	LastUpdateTimestamp *time.Time

	// The name of the contact.
	Name *string

	// If this contact is not the first contact, this is the ID of the previous
	// contact.
	PreviousContactId *string

	// If this contact was queued, this contains information about the queue.
	QueueInfo *QueueInfo

	// The timestamp, in Unix epoch time format, at which to start running the inbound
	// flow.
	ScheduledTimestamp *time.Time

	noSmithyDocumentSerde
}

// Contains information about a contact flow.
type ContactFlow struct {

	// The Amazon Resource Name (ARN) of the contact flow.
	Arn *string

	// The content of the contact flow.
	Content *string

	// The description of the contact flow.
	Description *string

	// The identifier of the contact flow.
	Id *string

	// The name of the contact flow.
	Name *string

	// The type of contact flow.
	State ContactFlowState

	// One or more tags.
	Tags map[string]string

	// The type of the contact flow. For descriptions of the available types, see
	// Choose a Contact Flow Type
	// (https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types)
	// in the Amazon Connect Administrator Guide.
	Type ContactFlowType

	noSmithyDocumentSerde
}

// Contains information about a contact flow module.
type ContactFlowModule struct {

	// The Amazon Resource Name (ARN).
	Arn *string

	// The content of the contact flow module.
	Content *string

	// The description of the contact flow module.
	Description *string

	// The identifier of the contact flow module.
	Id *string

	// The name of the contact flow module.
	Name *string

	// The type of contact flow module.
	State ContactFlowModuleState

	// The status of the contact flow module.
	Status ContactFlowModuleStatus

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains summary information about a contact flow.
type ContactFlowModuleSummary struct {

	// The Amazon Resource Name (ARN) of the contact flow module.
	Arn *string

	// The identifier of the contact flow module.
	Id *string

	// The name of the contact flow module.
	Name *string

	// The type of contact flow module.
	State ContactFlowModuleState

	noSmithyDocumentSerde
}

// Contains summary information about a contact flow. You can also create and
// update contact flows using the Amazon Connect Flow language
// (https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html).
type ContactFlowSummary struct {

	// The Amazon Resource Name (ARN) of the contact flow.
	Arn *string

	// The type of contact flow.
	ContactFlowState ContactFlowState

	// The type of contact flow.
	ContactFlowType ContactFlowType

	// The identifier of the contact flow.
	Id *string

	// The name of the contact flow.
	Name *string

	noSmithyDocumentSerde
}

// Contains credentials to use for federation.
type Credentials struct {

	// An access token generated for a federated user to access Amazon Connect.
	AccessToken *string

	// A token generated with an expiration time for the session a user is logged in to
	// Amazon Connect.
	AccessTokenExpiration *time.Time

	// Renews a token generated for a user to access the Amazon Connect instance.
	RefreshToken *string

	// Renews the expiration timer for a generated token.
	RefreshTokenExpiration *time.Time

	noSmithyDocumentSerde
}

// Contains information about a real-time metric. For a description of each metric,
// see Real-time Metrics Definitions
// (https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html)
// in the Amazon Connect Administrator Guide.
type CurrentMetric struct {

	// The name of the metric.
	Name CurrentMetricName

	// The unit for the metric.
	Unit Unit

	noSmithyDocumentSerde
}

// Contains the data for a real-time metric.
type CurrentMetricData struct {

	// Information about the metric.
	Metric *CurrentMetric

	// The value of the metric.
	Value *float64

	noSmithyDocumentSerde
}

// Contains information about a set of real-time metrics.
type CurrentMetricResult struct {

	// The set of metrics.
	Collections []CurrentMetricData

	// The dimensions for the metrics.
	Dimensions *Dimensions

	noSmithyDocumentSerde
}

// Contains information about a default vocabulary.
type DefaultVocabulary struct {

	// The identifier of the Amazon Connect instance. You can find the instanceId in
	// the ARN of the instance.
	//
	// This member is required.
	InstanceId *string

	// The language code of the vocabulary entries. For a list of languages and their
	// corresponding language codes, see What is Amazon Transcribe?
	// (https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html)
	//
	// This member is required.
	LanguageCode VocabularyLanguageCode

	// The identifier of the custom vocabulary.
	//
	// This member is required.
	VocabularyId *string

	// A unique name of the custom vocabulary.
	//
	// This member is required.
	VocabularyName *string

	noSmithyDocumentSerde
}

// Contains information about the dimensions for a set of metrics.
type Dimensions struct {

	// The channel used for grouping and filters.
	Channel Channel

	// Information about the queue for which metrics are returned.
	Queue *QueueReference

	noSmithyDocumentSerde
}

// The encryption configuration.
type EncryptionConfig struct {

	// The type of encryption.
	//
	// This member is required.
	EncryptionType EncryptionType

	// The full ARN of the encryption key. Be sure to provide the full ARN of the
	// encryption key, not just the ID.
	//
	// This member is required.
	KeyId *string

	noSmithyDocumentSerde
}

// Contains the filter to apply when retrieving metrics.
type Filters struct {

	// The channel to use to filter the metrics.
	Channels []Channel

	// The queues to use to filter the metrics. You should specify at least one queue,
	// and can specify up to 100 queues per request. The GetCurrentMetricsData API in
	// particular requires a queue when you include a Filter in your request.
	Queues []string

	noSmithyDocumentSerde
}

// Contains information about a hierarchy group.
type HierarchyGroup struct {

	// The Amazon Resource Name (ARN) of the hierarchy group.
	Arn *string

	// Information about the levels in the hierarchy group.
	HierarchyPath *HierarchyPath

	// The identifier of the hierarchy group.
	Id *string

	// The identifier of the level in the hierarchy group.
	LevelId *string

	// The name of the hierarchy group.
	Name *string

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains summary information about a hierarchy group.
type HierarchyGroupSummary struct {

	// The Amazon Resource Name (ARN) of the hierarchy group.
	Arn *string

	// The identifier of the hierarchy group.
	Id *string

	// The name of the hierarchy group.
	Name *string

	noSmithyDocumentSerde
}

// Contains information about a hierarchy level.
type HierarchyLevel struct {

	// The Amazon Resource Name (ARN) of the hierarchy level.
	Arn *string

	// The identifier of the hierarchy level.
	Id *string

	// The name of the hierarchy level.
	Name *string

	noSmithyDocumentSerde
}

// Contains information about the hierarchy level to update.
type HierarchyLevelUpdate struct {

	// The name of the user hierarchy level. Must not be more than 50 characters.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Contains information about the levels of a hierarchy group.
type HierarchyPath struct {

	// Information about level five.
	LevelFive *HierarchyGroupSummary

	// Information about level four.
	LevelFour *HierarchyGroupSummary

	// Information about level one.
	LevelOne *HierarchyGroupSummary

	// Information about level three.
	LevelThree *HierarchyGroupSummary

	// Information about level two.
	LevelTwo *HierarchyGroupSummary

	noSmithyDocumentSerde
}

// Contains information about a hierarchy structure.
type HierarchyStructure struct {

	// Information about level five.
	LevelFive *HierarchyLevel

	// Information about level four.
	LevelFour *HierarchyLevel

	// Information about level one.
	LevelOne *HierarchyLevel

	// Information about level three.
	LevelThree *HierarchyLevel

	// Information about level two.
	LevelTwo *HierarchyLevel

	noSmithyDocumentSerde
}

// Contains information about the level hierarchy to update.
type HierarchyStructureUpdate struct {

	// The update for level five.
	LevelFive *HierarchyLevelUpdate

	// The update for level four.
	LevelFour *HierarchyLevelUpdate

	// The update for level one.
	LevelOne *HierarchyLevelUpdate

	// The update for level three.
	LevelThree *HierarchyLevelUpdate

	// The update for level two.
	LevelTwo *HierarchyLevelUpdate

	noSmithyDocumentSerde
}

// Contains information about a historical metric. For a description of each
// metric, see Historical Metrics Definitions
// (https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html)
// in the Amazon Connect Administrator Guide.
type HistoricalMetric struct {

	// The name of the metric.
	Name HistoricalMetricName

	// The statistic for the metric.
	Statistic Statistic

	// The threshold for the metric, used with service level metrics.
	Threshold *Threshold

	// The unit for the metric.
	Unit Unit

	noSmithyDocumentSerde
}

// Contains the data for a historical metric.
type HistoricalMetricData struct {

	// Information about the metric.
	Metric *HistoricalMetric

	// The value of the metric.
	Value *float64

	noSmithyDocumentSerde
}

// Contains information about the historical metrics retrieved.
type HistoricalMetricResult struct {

	// The set of metrics.
	Collections []HistoricalMetricData

	// The dimension for the metrics.
	Dimensions *Dimensions

	noSmithyDocumentSerde
}

// Information about of the hours of operation.
type HoursOfOperation struct {

	// Configuration information for the hours of operation.
	Config []HoursOfOperationConfig

	// The description for the hours of operation.
	Description *string

	// The Amazon Resource Name (ARN) for the hours of operation.
	HoursOfOperationArn *string

	// The identifier for the hours of operation.
	HoursOfOperationId *string

	// The name for the hours of operation.
	Name *string

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	// The time zone for the hours of operation.
	TimeZone *string

	noSmithyDocumentSerde
}

// Contains information about the hours of operation.
type HoursOfOperationConfig struct {

	// The day that the hours of operation applies to.
	//
	// This member is required.
	Day HoursOfOperationDays

	// The end time that your contact center closes.
	//
	// This member is required.
	EndTime *HoursOfOperationTimeSlice

	// The start time that your contact center opens.
	//
	// This member is required.
	StartTime *HoursOfOperationTimeSlice

	noSmithyDocumentSerde
}

// Contains summary information about hours of operation for a contact center.
type HoursOfOperationSummary struct {

	// The Amazon Resource Name (ARN) of the hours of operation.
	Arn *string

	// The identifier of the hours of operation.
	Id *string

	// The name of the hours of operation.
	Name *string

	noSmithyDocumentSerde
}

// The start time or end time for an hours of operation.
type HoursOfOperationTimeSlice struct {

	// The hours.
	//
	// This member is required.
	Hours int32

	// The minutes.
	//
	// This member is required.
	Minutes int32

	noSmithyDocumentSerde
}

// The Amazon Connect instance.
type Instance struct {

	// The Amazon Resource Name (ARN) of the instance.
	Arn *string

	// When the instance was created.
	CreatedTime *time.Time

	// The identifier of the Amazon Connect instance. You can find the instanceId in
	// the ARN of the instance.
	Id *string

	// The identity management type.
	IdentityManagementType DirectoryType

	// Whether inbound calls are enabled.
	InboundCallsEnabled *bool

	// The alias of instance.
	InstanceAlias *string

	// The state of the instance.
	InstanceStatus InstanceStatus

	// Whether outbound calls are enabled.
	OutboundCallsEnabled *bool

	// The service role of the instance.
	ServiceRole *string

	// Relevant details why the instance was not successfully created.
	StatusReason *InstanceStatusReason

	noSmithyDocumentSerde
}

// Relevant details why the instance was not successfully created.
type InstanceStatusReason struct {

	// The message.
	Message *string

	noSmithyDocumentSerde
}

// The storage configuration for the instance.
type InstanceStorageConfig struct {

	// A valid storage type.
	//
	// This member is required.
	StorageType StorageType

	// The existing association identifier that uniquely identifies the resource type
	// and storage config for the given instance ID.
	AssociationId *string

	// The configuration of the Kinesis Firehose delivery stream.
	KinesisFirehoseConfig *KinesisFirehoseConfig

	// The configuration of the Kinesis data stream.
	KinesisStreamConfig *KinesisStreamConfig

	// The configuration of the Kinesis video stream.
	KinesisVideoStreamConfig *KinesisVideoStreamConfig

	// The S3 bucket configuration.
	S3Config *S3Config

	noSmithyDocumentSerde
}

// Information about the instance.
type InstanceSummary struct {

	// The Amazon Resource Name (ARN) of the instance.
	Arn *string

	// When the instance was created.
	CreatedTime *time.Time

	// The identifier of the instance.
	Id *string

	// The identity management type of the instance.
	IdentityManagementType DirectoryType

	// Whether inbound calls are enabled.
	InboundCallsEnabled *bool

	// The alias of the instance.
	InstanceAlias *string

	// The state of the instance.
	InstanceStatus InstanceStatus

	// Whether outbound calls are enabled.
	OutboundCallsEnabled *bool

	// The service role of the instance.
	ServiceRole *string

	noSmithyDocumentSerde
}

// Contains summary information about the associated AppIntegrations.
type IntegrationAssociationSummary struct {

	// The identifier of the Amazon Connect instance. You can find the instanceId in
	// the ARN of the instance.
	InstanceId *string

	// The Amazon Resource Name (ARN) for the AppIntegration.
	IntegrationArn *string

	// The Amazon Resource Name (ARN) for the AppIntegration association.
	IntegrationAssociationArn *string

	// The identifier for the AppIntegration association.
	IntegrationAssociationId *string

	// The integration type.
	IntegrationType IntegrationType

	// The user-provided, friendly name for the external application.
	SourceApplicationName *string

	// The URL for the external application.
	SourceApplicationUrl *string

	// The name of the source.
	SourceType SourceType

	noSmithyDocumentSerde
}

// Configuration information of a Kinesis Data Firehose delivery stream.
type KinesisFirehoseConfig struct {

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// This member is required.
	FirehoseArn *string

	noSmithyDocumentSerde
}

// Configuration information of a Kinesis data stream.
type KinesisStreamConfig struct {

	// The Amazon Resource Name (ARN) of the data stream.
	//
	// This member is required.
	StreamArn *string

	noSmithyDocumentSerde
}

// Configuration information of a Kinesis video stream.
type KinesisVideoStreamConfig struct {

	// The encryption configuration.
	//
	// This member is required.
	EncryptionConfig *EncryptionConfig

	// The prefix of the video stream.
	//
	// This member is required.
	Prefix *string

	// The number of hours data is retained in the stream. Kinesis Video Streams
	// retains the data in a data store that is associated with the stream. The default
	// value is 0, indicating that the stream does not persist data.
	//
	// This member is required.
	RetentionPeriodHours int32

	noSmithyDocumentSerde
}

// Configuration information of an Amazon Lex bot.
type LexBot struct {

	// The Region that the Amazon Lex bot was created in.
	LexRegion *string

	// The name of the Amazon Lex bot.
	Name *string

	noSmithyDocumentSerde
}

// Configuration information of an Amazon Lex or Amazon Lex V2 bot.
type LexBotConfig struct {

	// Configuration information of an Amazon Lex bot.
	LexBot *LexBot

	// Configuration information of an Amazon Lex V2 bot.
	LexV2Bot *LexV2Bot

	noSmithyDocumentSerde
}

// Configuration information of an Amazon Lex V2 bot.
type LexV2Bot struct {

	// The Amazon Resource Name (ARN) of the Amazon Lex V2 bot.
	AliasArn *string

	noSmithyDocumentSerde
}

// Contains information about which channels are supported, and how many contacts
// an agent can have on a channel simultaneously.
type MediaConcurrency struct {

	// The channels that agents can handle in the Contact Control Panel (CCP).
	//
	// This member is required.
	Channel Channel

	// The number of contacts an agent can have on a channel simultaneously. Valid
	// Range for VOICE: Minimum value of 1. Maximum value of 1. Valid Range for CHAT:
	// Minimum value of 1. Maximum value of 10. Valid Range for TASK: Minimum value of
	// 1. Maximum value of 10.
	//
	// This member is required.
	Concurrency int32

	noSmithyDocumentSerde
}

// The outbound caller ID name, number, and outbound whisper flow.
type OutboundCallerConfig struct {

	// The caller ID name.
	OutboundCallerIdName *string

	// The caller ID number.
	OutboundCallerIdNumberId *string

	// The outbound whisper flow to be used during an outbound call.
	OutboundFlowId *string

	noSmithyDocumentSerde
}

// The customer's details.
type ParticipantDetails struct {

	// Display name of the participant.
	//
	// This member is required.
	DisplayName *string

	noSmithyDocumentSerde
}

// Contains information about a phone number for a quick connect.
type PhoneNumberQuickConnectConfig struct {

	// The phone number in E.164 format.
	//
	// This member is required.
	PhoneNumber *string

	noSmithyDocumentSerde
}

// Contains summary information about a phone number for a contact center.
type PhoneNumberSummary struct {

	// The Amazon Resource Name (ARN) of the phone number.
	Arn *string

	// The identifier of the phone number.
	Id *string

	// The phone number.
	PhoneNumber *string

	// The ISO country code.
	PhoneNumberCountryCode PhoneNumberCountryCode

	// The type of phone number.
	PhoneNumberType PhoneNumberType

	noSmithyDocumentSerde
}

// Information about a problem detail.
type ProblemDetail struct {

	// The problem detail's message.
	Message *string

	noSmithyDocumentSerde
}

// Contains information about the prompt.
type PromptSummary struct {

	// The Amazon Resource Name (ARN) of the prompt.
	Arn *string

	// The identifier of the prompt.
	Id *string

	// The name of the prompt.
	Name *string

	noSmithyDocumentSerde
}

// Contains information about a queue.
type Queue struct {

	// The description of the queue.
	Description *string

	// The identifier for the hours of operation.
	HoursOfOperationId *string

	// The maximum number of contacts that can be in the queue before it is considered
	// full.
	MaxContacts int32

	// The name of the queue.
	Name *string

	// The outbound caller ID name, number, and outbound whisper flow.
	OutboundCallerConfig *OutboundCallerConfig

	// The Amazon Resource Name (ARN) for the queue.
	QueueArn *string

	// The identifier for the queue.
	QueueId *string

	// The status of the queue.
	Status QueueStatus

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// If this contact was queued, this contains information about the queue.
type QueueInfo struct {

	// The timestamp when the contact was added to the queue.
	EnqueueTimestamp *time.Time

	// The identifier of the agent who accepted the contact.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about a queue for a quick connect. The contact flow must be
// of type Transfer to Queue.
type QueueQuickConnectConfig struct {

	// The identifier of the contact flow.
	//
	// This member is required.
	ContactFlowId *string

	// The identifier for the queue.
	//
	// This member is required.
	QueueId *string

	noSmithyDocumentSerde
}

// Contains information about a queue resource for which metrics are returned.
type QueueReference struct {

	// The Amazon Resource Name (ARN) of the queue.
	Arn *string

	// The identifier of the queue.
	Id *string

	noSmithyDocumentSerde
}

// Contains summary information about a queue.
type QueueSummary struct {

	// The Amazon Resource Name (ARN) of the queue.
	Arn *string

	// The identifier of the queue.
	Id *string

	// The name of the queue.
	Name *string

	// The type of queue.
	QueueType QueueType

	noSmithyDocumentSerde
}

// Contains information about a quick connect.
type QuickConnect struct {

	// The description.
	Description *string

	// The name of the quick connect.
	Name *string

	// The Amazon Resource Name (ARN) of the quick connect.
	QuickConnectARN *string

	// Contains information about the quick connect.
	QuickConnectConfig *QuickConnectConfig

	// The identifier for the quick connect.
	QuickConnectId *string

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains configuration settings for a quick connect.
type QuickConnectConfig struct {

	// The type of quick connect. In the Amazon Connect console, when you create a
	// quick connect, you are prompted to assign one of the following types: Agent
	// (USER), External (PHONE_NUMBER), or Queue (QUEUE).
	//
	// This member is required.
	QuickConnectType QuickConnectType

	// The phone configuration. This is required only if QuickConnectType is
	// PHONE_NUMBER.
	PhoneConfig *PhoneNumberQuickConnectConfig

	// The queue configuration. This is required only if QuickConnectType is QUEUE.
	QueueConfig *QueueQuickConnectConfig

	// The user configuration. This is required only if QuickConnectType is USER.
	UserConfig *UserQuickConnectConfig

	noSmithyDocumentSerde
}

// Contains summary information about a quick connect.
type QuickConnectSummary struct {

	// The Amazon Resource Name (ARN) of the quick connect.
	Arn *string

	// The identifier for the quick connect.
	Id *string

	// The name of the quick connect.
	Name *string

	// The type of quick connect. In the Amazon Connect console, when you create a
	// quick connect, you are prompted to assign one of the following types: Agent
	// (USER), External (PHONE_NUMBER), or Queue (QUEUE).
	QuickConnectType QuickConnectType

	noSmithyDocumentSerde
}

// A link that an agent selects to complete a given task. You can have up to 4,096
// UTF-8 bytes across all references for a contact.
type Reference struct {

	// The type of the reference. Only URL type can be added or updated on a contact.
	//
	// This member is required.
	Type ReferenceType

	// A valid value for the reference. For example, for a URL reference, a formatted
	// URL that is displayed to an agent in the Contact Control Panel (CCP).
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Contains summary information about a reference. ReferenceSummary contains only
// one non null field between the URL and attachment based on the reference type.
//
// The following types satisfy this interface:
//  ReferenceSummaryMemberAttachment
//  ReferenceSummaryMemberUrl
type ReferenceSummary interface {
	isReferenceSummary()
}

// Information about the attachment reference if the referenceType is ATTACHMENT.
// Otherwise, null.
type ReferenceSummaryMemberAttachment struct {
	Value AttachmentReference

	noSmithyDocumentSerde
}

func (*ReferenceSummaryMemberAttachment) isReferenceSummary() {}

// Information about the URL reference if the referenceType is URL. Otherwise,
// null.
type ReferenceSummaryMemberUrl struct {
	Value UrlReference

	noSmithyDocumentSerde
}

func (*ReferenceSummaryMemberUrl) isReferenceSummary() {}

// Contains information about a routing profile.
type RoutingProfile struct {

	// The identifier of the default outbound queue for this routing profile.
	DefaultOutboundQueueId *string

	// The description of the routing profile.
	Description *string

	// The identifier of the Amazon Connect instance. You can find the instanceId in
	// the ARN of the instance.
	InstanceId *string

	// The channels agents can handle in the Contact Control Panel (CCP) for this
	// routing profile.
	MediaConcurrencies []MediaConcurrency

	// The name of the routing profile.
	Name *string

	// The Amazon Resource Name (ARN) of the routing profile.
	RoutingProfileArn *string

	// The identifier of the routing profile.
	RoutingProfileId *string

	// One or more tags.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains information about the queue and channel for which priority and delay
// can be set.
type RoutingProfileQueueConfig struct {

	// The delay, in seconds, a contact should be in the queue before they are routed
	// to an available agent. For more information, see Queues: priority and delay
	// (https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html)
	// in the Amazon Connect Administrator Guide.
	//
	// This member is required.
	Delay int32

	// The order in which contacts are to be handled for the queue. For more
	// information, see Queues: priority and delay
	// (https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html).
	//
	// This member is required.
	Priority int32

	// Contains information about a queue resource.
	//
	// This member is required.
	QueueReference *RoutingProfileQueueReference

	noSmithyDocumentSerde
}

// Contains summary information about a routing profile queue.
type RoutingProfileQueueConfigSummary struct {

	// The channels this queue supports.
	//
	// This member is required.
	Channel Channel

	// The delay, in seconds, that a contact should be in the queue before they are
	// routed to an available agent. For more information, see Queues: priority and
	// delay
	// (https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html)
	// in the Amazon Connect Administrator Guide.
	//
	// This member is required.
	Delay int32

	// The order in which contacts are to be handled for the queue. For more
	// information, see Queues: priority and delay
	// (https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html).
	//
	// This member is required.
	Priority int32

	// The Amazon Resource Name (ARN) of the queue.
	//
	// This member is required.
	QueueArn *string

	// The identifier for the queue.
	//
	// This member is required.
	QueueId *string

	// The name of the queue.
	//
	// This member is required.
	QueueName *string

	noSmithyDocumentSerde
}

// Contains the channel and queue identifier for a routing profile.
type RoutingProfileQueueReference struct {

	// The channels agents can handle in the Contact Control Panel (CCP) for this
	// routing profile.
	//
	// This member is required.
	Channel Channel

	// The identifier for the queue.
	//
	// This member is required.
	QueueId *string

	noSmithyDocumentSerde
}

// Contains summary information about a routing profile.
type RoutingProfileSummary struct {

	// The Amazon Resource Name (ARN) of the routing profile.
	Arn *string

	// The identifier of the routing profile.
	Id *string

	// The name of the routing profile.
	Name *string

	noSmithyDocumentSerde
}

// Information about the Amazon Simple Storage Service (Amazon S3) storage type.
type S3Config struct {

	// The S3 bucket name.
	//
	// This member is required.
	BucketName *string

	// The S3 bucket prefix.
	//
	// This member is required.
	BucketPrefix *string

	// The Amazon S3 encryption configuration.
	EncryptionConfig *EncryptionConfig

	noSmithyDocumentSerde
}

// Configuration information of the security key.
type SecurityKey struct {

	// The existing association identifier that uniquely identifies the resource type
	// and storage config for the given instance ID.
	AssociationId *string

	// When the security key was created.
	CreationTime *time.Time

	// The key of the security key.
	Key *string

	noSmithyDocumentSerde
}

// Contains information about a security profile.
type SecurityProfile struct {

	// The Amazon Resource Name (ARN) for the secruity profile.
	Arn *string

	// The description of the security profile.
	Description *string

	// The identifier for the security profile.
	Id *string

	// The organization resource identifier for the security profile.
	OrganizationResourceId *string

	// The name for the security profile.
	SecurityProfileName *string

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains information about a security profile.
type SecurityProfileSummary struct {

	// The Amazon Resource Name (ARN) of the security profile.
	Arn *string

	// The identifier of the security profile.
	Id *string

	// The name of the security profile.
	Name *string

	noSmithyDocumentSerde
}

// Contains information about the threshold for service level metrics.
type Threshold struct {

	// The type of comparison. Only "less than" (LT) comparisons are supported.
	Comparison Comparison

	// The threshold value to compare.
	ThresholdValue *float64

	noSmithyDocumentSerde
}

// The URL reference.
type UrlReference struct {

	// Identifier of the URL reference.
	Name *string

	// A valid URL.
	Value *string

	noSmithyDocumentSerde
}

// Contains the use case.
type UseCase struct {

	// The Amazon Resource Name (ARN) for the use case.
	UseCaseArn *string

	// The identifier for the use case.
	UseCaseId *string

	// The type of use case to associate to the integration association. Each
	// integration association can have only one of each use case type.
	UseCaseType UseCaseType

	noSmithyDocumentSerde
}

// Contains information about a user account for a Amazon Connect instance.
type User struct {

	// The Amazon Resource Name (ARN) of the user account.
	Arn *string

	// The identifier of the user account in the directory used for identity
	// management.
	DirectoryUserId *string

	// The identifier of the hierarchy group for the user.
	HierarchyGroupId *string

	// The identifier of the user account.
	Id *string

	// Information about the user identity.
	IdentityInfo *UserIdentityInfo

	// Information about the phone configuration for the user.
	PhoneConfig *UserPhoneConfig

	// The identifier of the routing profile for the user.
	RoutingProfileId *string

	// The identifiers of the security profiles for the user.
	SecurityProfileIds []string

	// The tags.
	Tags map[string]string

	// The user name assigned to the user account.
	Username *string

	noSmithyDocumentSerde
}

// Contains information about the identity of a user.
type UserIdentityInfo struct {

	// The email address. If you are using SAML for identity management and include
	// this parameter, an error is returned.
	Email *string

	// The first name. This is required if you are using Amazon Connect or SAML for
	// identity management.
	FirstName *string

	// The last name. This is required if you are using Amazon Connect or SAML for
	// identity management.
	LastName *string

	noSmithyDocumentSerde
}

// Contains information about the phone configuration settings for a user.
type UserPhoneConfig struct {

	// The phone type.
	//
	// This member is required.
	PhoneType PhoneType

	// The After Call Work (ACW) timeout setting, in seconds.
	AfterContactWorkTimeLimit int32

	// The Auto accept setting.
	AutoAccept bool

	// The phone number for the user's desk phone.
	DeskPhoneNumber *string

	noSmithyDocumentSerde
}

// Contains information about the quick connect configuration settings for a user.
// The contact flow must be of type Transfer to Agent.
type UserQuickConnectConfig struct {

	// The identifier of the contact flow.
	//
	// This member is required.
	ContactFlowId *string

	// The identifier of the user.
	//
	// This member is required.
	UserId *string

	noSmithyDocumentSerde
}

// Contains summary information about a user.
type UserSummary struct {

	// The Amazon Resource Name (ARN) of the user account.
	Arn *string

	// The identifier of the user account.
	Id *string

	// The Amazon Connect user name of the user account.
	Username *string

	noSmithyDocumentSerde
}

// Contains information about a custom vocabulary.
type Vocabulary struct {

	// The Amazon Resource Name (ARN) of the custom vocabulary.
	//
	// This member is required.
	Arn *string

	// The identifier of the custom vocabulary.
	//
	// This member is required.
	Id *string

	// The language code of the vocabulary entries. For a list of languages and their
	// corresponding language codes, see What is Amazon Transcribe?
	// (https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html)
	//
	// This member is required.
	LanguageCode VocabularyLanguageCode

	// The timestamp when the custom vocabulary was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// A unique name of the custom vocabulary.
	//
	// This member is required.
	Name *string

	// The current state of the custom vocabulary.
	//
	// This member is required.
	State VocabularyState

	// The content of the custom vocabulary in plain-text format with a table of
	// values. Each row in the table represents a word or a phrase, described with
	// Phrase, IPA, SoundsLike, and DisplayAs fields. Separate the fields with TAB
	// characters. For more information, see Create a custom vocabulary using a table
	// (https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table).
	Content *string

	// The reason why the custom vocabulary was not created.
	FailureReason *string

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains summary information about the custom vocabulary.
type VocabularySummary struct {

	// The Amazon Resource Name (ARN) of the custom vocabulary.
	//
	// This member is required.
	Arn *string

	// The identifier of the custom vocabulary.
	//
	// This member is required.
	Id *string

	// The language code of the vocabulary entries. For a list of languages and their
	// corresponding language codes, see What is Amazon Transcribe?
	// (https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html)
	//
	// This member is required.
	LanguageCode VocabularyLanguageCode

	// The timestamp when the custom vocabulary was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// A unique name of the custom vocabulary.
	//
	// This member is required.
	Name *string

	// The current state of the custom vocabulary.
	//
	// This member is required.
	State VocabularyState

	// The reason why the custom vocabulary was not created.
	FailureReason *string

	noSmithyDocumentSerde
}

// Contains information about the recording configuration settings.
type VoiceRecordingConfiguration struct {

	// Identifies which track is being recorded.
	VoiceRecordingTrack VoiceRecordingTrack

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isReferenceSummary() {}
