// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The data type for AccountRecoverySetting.
type AccountRecoverySettingType struct {

	// The list of RecoveryOptionTypes.
	RecoveryMechanisms []RecoveryOptionType

	noSmithyDocumentSerde
}

// Account takeover actions type.
type AccountTakeoverActionsType struct {

	// Action to take for a high risk.
	HighAction *AccountTakeoverActionType

	// Action to take for a low risk.
	LowAction *AccountTakeoverActionType

	// Action to take for a medium risk.
	MediumAction *AccountTakeoverActionType

	noSmithyDocumentSerde
}

// Account takeover action type.
type AccountTakeoverActionType struct {

	// The event action.
	//
	// * BLOCK Choosing this action will block the request.
	//
	// *
	// MFA_IF_CONFIGURED Present an MFA challenge if user has configured it, else allow
	// the request.
	//
	// * MFA_REQUIRED Present an MFA challenge if user has configured it,
	// else block the request.
	//
	// * NO_ACTION Allow the user to sign in.
	//
	// This member is required.
	EventAction AccountTakeoverEventActionType

	// Flag specifying whether to send a notification.
	//
	// This member is required.
	Notify bool

	noSmithyDocumentSerde
}

// Configuration for mitigation actions and notification for different levels of
// risk detected for a potential account takeover.
type AccountTakeoverRiskConfigurationType struct {

	// Account takeover risk configuration actions.
	//
	// This member is required.
	Actions *AccountTakeoverActionsType

	// The notify configuration used to construct email notifications.
	NotifyConfiguration *NotifyConfigurationType

	noSmithyDocumentSerde
}

// The configuration for creating a new user profile.
type AdminCreateUserConfigType struct {

	// Set to True if only the administrator is allowed to create user profiles. Set to
	// False if users can sign themselves up via an app.
	AllowAdminCreateUserOnly bool

	// The message template to be used for the welcome message to new users. See also
	// Customizing User Invitation Messages
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization).
	InviteMessageTemplate *MessageTemplateType

	// The user account expiration limit, in days, after which the account is no longer
	// usable. To reset the account after that time limit, you must call
	// AdminCreateUser again, specifying "RESEND" for the MessageAction parameter. The
	// default value for this parameter is 7. If you set a value for
	// TemporaryPasswordValidityDays in PasswordPolicy, that value will be used, and
	// UnusedAccountValidityDays will be no longer be an available parameter for that
	// user pool.
	UnusedAccountValidityDays int32

	noSmithyDocumentSerde
}

// The Amazon Pinpoint analytics configuration for collecting metrics for a user
// pool. In Regions where Pinpoint isn't available, User Pools only supports
// sending events to Amazon Pinpoint projects in us-east-1. In Regions where
// Pinpoint is available, User Pools will support sending events to Amazon Pinpoint
// projects within that same Region.
type AnalyticsConfigurationType struct {

	// The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the
	// Amazon Pinpoint project for integration with the chosen User Pool Client. Amazon
	// Cognito publishes events to the Amazon Pinpointproject declared by the app ARN.
	ApplicationArn *string

	// The application ID for an Amazon Pinpoint application.
	ApplicationId *string

	// The external ID.
	ExternalId *string

	// The ARN of an Identity and Access Management role that authorizes Amazon Cognito
	// to publish events to Amazon Pinpoint analytics.
	RoleArn *string

	// If UserDataShared is true, Amazon Cognito will include user data in the events
	// it publishes to Amazon Pinpoint analytics.
	UserDataShared bool

	noSmithyDocumentSerde
}

// An Amazon Pinpoint analytics endpoint. An endpoint uniquely identifies a mobile
// device, email address, or phone number that can receive messages from Amazon
// Pinpoint analytics. Amazon Cognito User Pools only supports sending events to
// Amazon Pinpoint projects in the US East (N. Virginia) us-east-1 Region,
// regardless of the Region in which the user pool resides.
type AnalyticsMetadataType struct {

	// The endpoint ID.
	AnalyticsEndpointId *string

	noSmithyDocumentSerde
}

// Specifies whether the attribute is standard or custom.
type AttributeType struct {

	// The name of the attribute.
	//
	// This member is required.
	Name *string

	// The value of the attribute.
	Value *string

	noSmithyDocumentSerde
}

// The authentication result.
type AuthenticationResultType struct {

	// The access token.
	AccessToken *string

	// The expiration period of the authentication result in seconds.
	ExpiresIn int32

	// The ID token.
	IdToken *string

	// The new device metadata from an authentication result.
	NewDeviceMetadata *NewDeviceMetadataType

	// The refresh token.
	RefreshToken *string

	// The token type.
	TokenType *string

	noSmithyDocumentSerde
}

// The authentication event type.
type AuthEventType struct {

	// The challenge responses.
	ChallengeResponses []ChallengeResponseType

	// The creation date
	CreationDate *time.Time

	// The user context data captured at the time of an event request. This value
	// provides additional information about the client from which event the request is
	// received.
	EventContextData *EventContextDataType

	// A flag specifying the user feedback captured at the time of an event request is
	// good or bad.
	EventFeedback *EventFeedbackType

	// The event ID.
	EventId *string

	// The event response.
	EventResponse EventResponseType

	// The event risk.
	EventRisk *EventRiskType

	// The event type.
	EventType EventType

	noSmithyDocumentSerde
}

// The challenge response type.
type ChallengeResponseType struct {

	// The challenge name.
	ChallengeName ChallengeName

	// The challenge response.
	ChallengeResponse ChallengeResponse

	noSmithyDocumentSerde
}

// The code delivery details being returned from the server.
type CodeDeliveryDetailsType struct {

	// The attribute name.
	AttributeName *string

	// The delivery medium (email message or phone number).
	DeliveryMedium DeliveryMediumType

	// The destination for the code delivery details.
	Destination *string

	noSmithyDocumentSerde
}

// The compromised credentials actions type.
type CompromisedCredentialsActionsType struct {

	// The event action.
	//
	// This member is required.
	EventAction CompromisedCredentialsEventActionType

	noSmithyDocumentSerde
}

// The compromised credentials risk configuration type.
type CompromisedCredentialsRiskConfigurationType struct {

	// The compromised credentials risk configuration actions.
	//
	// This member is required.
	Actions *CompromisedCredentialsActionsType

	// Perform the action for these events. The default is to perform all events if no
	// event filter is specified.
	EventFilter []EventFilterType

	noSmithyDocumentSerde
}

// Contextual user data type used for evaluating the risk of an unexpected event by
// Amazon Cognito advanced security.
type ContextDataType struct {

	// HttpHeaders received on your server in same order.
	//
	// This member is required.
	HttpHeaders []HttpHeader

	// Source IP address of your user.
	//
	// This member is required.
	IpAddress *string

	// Your server endpoint where this API is invoked.
	//
	// This member is required.
	ServerName *string

	// Your server path where this API is invoked.
	//
	// This member is required.
	ServerPath *string

	// Encoded data containing device fingerprinting details collected using the Amazon
	// Cognito context data collection library.
	EncodedData *string

	noSmithyDocumentSerde
}

// The configuration for a custom domain that hosts the sign-up and sign-in
// webpages for your application.
type CustomDomainConfigType struct {

	// The Amazon Resource Name (ARN) of an Certificate Manager SSL certificate. You
	// use this certificate for the subdomain of your custom domain.
	//
	// This member is required.
	CertificateArn *string

	noSmithyDocumentSerde
}

// A custom email sender Lambda configuration type.
type CustomEmailLambdaVersionConfigType struct {

	// The Amazon Resource Name (ARN) of the Lambda function that Amazon Cognito
	// activates to send email notifications to users.
	//
	// This member is required.
	LambdaArn *string

	// Signature of the "request" attribute in the "event" information Amazon Cognito
	// passes to your custom email Lambda function. The only supported value is V1_0.
	//
	// This member is required.
	LambdaVersion CustomEmailSenderLambdaVersionType

	noSmithyDocumentSerde
}

// A custom SMS sender Lambda configuration type.
type CustomSMSLambdaVersionConfigType struct {

	// The Amazon Resource Name (ARN) of the Lambda function that Amazon Cognito
	// activates to send SMS notifications to users.
	//
	// This member is required.
	LambdaArn *string

	// Signature of the "request" attribute in the "event" information that Amazon
	// Cognito passes to your custom SMS Lambda function. The only supported value is
	// V1_0.
	//
	// This member is required.
	LambdaVersion CustomSMSSenderLambdaVersionType

	noSmithyDocumentSerde
}

// The device tracking configuration for a user pool. A user pool with device
// tracking deactivated returns a null value. When you provide values for any
// DeviceConfiguration field, you activate device tracking.
type DeviceConfigurationType struct {

	// When true, device authentication can replace SMS and time-based one-time
	// password (TOTP) factors for multi-factor authentication (MFA). Users that sign
	// in with devices that have not been confirmed or remembered will still have to
	// provide a second factor, whether or not ChallengeRequiredOnNewDevice is true,
	// when your user pool requires MFA.
	ChallengeRequiredOnNewDevice bool

	// When true, users can opt in to remembering their device. Your app code must use
	// callback functions to return the user's choice.
	DeviceOnlyRememberedOnUserPrompt bool

	noSmithyDocumentSerde
}

// The device verifier against which it is authenticated.
type DeviceSecretVerifierConfigType struct {

	// The password verifier.
	PasswordVerifier *string

	// The salt.
	Salt *string

	noSmithyDocumentSerde
}

// The device type.
type DeviceType struct {

	// The device attributes.
	DeviceAttributes []AttributeType

	// The creation date of the device.
	DeviceCreateDate *time.Time

	// The device key.
	DeviceKey *string

	// The date when the device was last authenticated.
	DeviceLastAuthenticatedDate *time.Time

	// The last modified date of the device.
	DeviceLastModifiedDate *time.Time

	noSmithyDocumentSerde
}

// A container for information about a domain.
type DomainDescriptionType struct {

	// The Amazon Web Services ID for the user pool owner.
	AWSAccountId *string

	// The Amazon Resource Name (ARN) of the Amazon CloudFront distribution.
	CloudFrontDistribution *string

	// The configuration for a custom domain that hosts the sign-up and sign-in
	// webpages for your application.
	CustomDomainConfig *CustomDomainConfigType

	// The domain string. For custom domains, this is the fully-qualified domain name,
	// such as auth.example.com. For Amazon Cognito prefix domains, this is the prefix
	// alone, such as auth.
	Domain *string

	// The Amazon S3 bucket where the static files for this domain are stored.
	S3Bucket *string

	// The domain status.
	Status DomainStatusType

	// The user pool ID.
	UserPoolId *string

	// The app version.
	Version *string

	noSmithyDocumentSerde
}

// The email configuration type. Amazon Cognito has specific Regions for use with
// Amazon Simple Email Service. For more information on the supported Regions, see
// Email settings for Amazon Cognito user pools
// (https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html).
type EmailConfigurationType struct {

	// The set of configuration rules that can be applied to emails sent using Amazon
	// Simple Email Service. A configuration set is applied to an email by including a
	// reference to the configuration set in the headers of the email. Once applied,
	// all of the rules in that configuration set are applied to the email.
	// Configuration sets can be used to apply the following types of rules to
	// emails:
	//
	// * Event publishing – Amazon Simple Email Service can track the number
	// of send, delivery, open, click, bounce, and complaint events for each email
	// sent. Use event publishing to send information about these events to other
	// Amazon Web Services services such as and Amazon CloudWatch.
	//
	// * IP pool
	// management – When leasing dedicated IP addresses with Amazon Simple Email
	// Service, you can create groups of IP addresses, called dedicated IP pools. You
	// can then associate the dedicated IP pools with configuration sets.
	ConfigurationSet *string

	// Specifies whether Amazon Cognito emails your users by using its built-in email
	// functionality or your Amazon Simple Email Service email configuration. Specify
	// one of the following values: COGNITO_DEFAULT When Amazon Cognito emails your
	// users, it uses its built-in email functionality. When you use the default
	// option, Amazon Cognito allows only a limited number of emails each day for your
	// user pool. For typical production environments, the default email limit is less
	// than the required delivery volume. To achieve a higher delivery volume, specify
	// DEVELOPER to use your Amazon SES email configuration. To look up the email
	// delivery limit for the default option, see Limits in
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html) in the
	// Developer Guide. The default FROM address is no-reply@verificationemail.com. To
	// customize the FROM address, provide the Amazon Resource Name (ARN) of an Amazon
	// SES verified email address for the SourceArn parameter. If EmailSendingAccount
	// is COGNITO_DEFAULT, you can't use the following parameters:
	//
	// *
	// EmailVerificationMessage
	//
	// * EmailVerificationSubject
	//
	// *
	// InviteMessageTemplate.EmailMessage
	//
	// * InviteMessageTemplate.EmailSubject
	//
	// *
	// VerificationMessageTemplate.EmailMessage
	//
	// *
	// VerificationMessageTemplate.EmailMessageByLink
	//
	// *
	// VerificationMessageTemplate.EmailSubject,
	//
	// *
	// VerificationMessageTemplate.EmailSubjectByLink
	//
	// DEVELOPER EmailSendingAccount is
	// required. DEVELOPER When Amazon Cognito emails your users, it uses your Amazon
	// SES configuration. Amazon Cognito calls Amazon SES on your behalf to send email
	// from your verified email address. When you use this option, the email delivery
	// limits are the same limits that apply to your Amazon SES verified email address
	// in your Amazon Web Services account. If you use this option, you must provide
	// the ARN of an Amazon SES verified email address for the SourceArn parameter.
	// Before Amazon Cognito can email your users, it requires additional permissions
	// to call Amazon SES on your behalf. When you update your user pool with this
	// option, Amazon Cognito creates a service-linked role, which is a type of role,
	// in your Amazon Web Services account. This role contains the permissions that
	// allow to access Amazon SES and send email messages with your address. For more
	// information about the service-linked role that Amazon Cognito creates, see Using
	// Service-Linked Roles for Amazon Cognito
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html)
	// in the Amazon Cognito Developer Guide.
	EmailSendingAccount EmailSendingAccountType

	// Either the sender’s email address or the sender’s name with their email address.
	// For example, testuser@example.com or Test User . This address appears before the
	// body of the email.
	From *string

	// The destination to which the receiver of the email should reply.
	ReplyToEmailAddress *string

	// The ARN of a verified email address in Amazon SES. Amazon Cognito uses this
	// email address in one of the following ways, depending on the value that you
	// specify for the EmailSendingAccount parameter:
	//
	// * If you specify
	// COGNITO_DEFAULT, Amazon Cognito uses this address as the custom FROM address
	// when it emails your users using its built-in email account.
	//
	// * If you specify
	// DEVELOPER, Amazon Cognito emails your users with this address by calling Amazon
	// SES on your behalf.
	SourceArn *string

	noSmithyDocumentSerde
}

// Specifies the user context data captured at the time of an event request.
type EventContextDataType struct {

	// The user's city.
	City *string

	// The user's country.
	Country *string

	// The user's device name.
	DeviceName *string

	// The user's IP address.
	IpAddress *string

	// The user's time zone.
	Timezone *string

	noSmithyDocumentSerde
}

// Specifies the event feedback type.
type EventFeedbackType struct {

	// The event feedback value.
	//
	// This member is required.
	FeedbackValue FeedbackValueType

	// The provider.
	//
	// This member is required.
	Provider *string

	// The event feedback date.
	FeedbackDate *time.Time

	noSmithyDocumentSerde
}

// The event risk type.
type EventRiskType struct {

	// Indicates whether compromised credentials were detected during an authentication
	// event.
	CompromisedCredentialsDetected *bool

	// The risk decision.
	RiskDecision RiskDecisionType

	// The risk level.
	RiskLevel RiskLevelType

	noSmithyDocumentSerde
}

// The group type.
type GroupType struct {

	// The date the group was created.
	CreationDate *time.Time

	// A string containing the description of the group.
	Description *string

	// The name of the group.
	GroupName *string

	// The date the group was last modified.
	LastModifiedDate *time.Time

	// A non-negative integer value that specifies the precedence of this group
	// relative to the other groups that a user can belong to in the user pool. Zero is
	// the highest precedence value. Groups with lower Precedence values take
	// precedence over groups with higher ornull Precedence values. If a user belongs
	// to two or more groups, it is the group with the lowest precedence value whose
	// role ARN is given in the user's tokens for the cognito:roles and
	// cognito:preferred_role claims. Two groups can have the same Precedence value. If
	// this happens, neither group takes precedence over the other. If two groups with
	// the same Precedence have the same role ARN, that role is used in the
	// cognito:preferred_role claim in tokens for users in each group. If the two
	// groups have different role ARNs, the cognito:preferred_role claim isn't set in
	// users' tokens. The default Precedence value is null.
	Precedence *int32

	// The role Amazon Resource Name (ARN) for the group.
	RoleArn *string

	// The user pool ID for the user pool.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The HTTP header.
type HttpHeader struct {

	// The header name.
	HeaderName *string

	// The header value.
	HeaderValue *string

	noSmithyDocumentSerde
}

// A container for information about an identity provider.
type IdentityProviderType struct {

	// A mapping of identity provider attributes to standard and custom user pool
	// attributes.
	AttributeMapping map[string]string

	// The date the identity provider was created.
	CreationDate *time.Time

	// A list of identity provider identifiers.
	IdpIdentifiers []string

	// The date the identity provider was last modified.
	LastModifiedDate *time.Time

	// The identity provider details. The following list describes the provider detail
	// keys for each identity provider type.
	//
	// * For Google and Login with Amazon:
	//
	// *
	// client_id
	//
	// * client_secret
	//
	// * authorize_scopes
	//
	// * For Facebook:
	//
	// * client_id
	//
	// *
	// client_secret
	//
	// * authorize_scopes
	//
	// * api_version
	//
	// * For Sign in with Apple:
	//
	// *
	// client_id
	//
	// * team_id
	//
	// * key_id
	//
	// * private_key
	//
	// * authorize_scopes
	//
	// * For OIDC
	// providers:
	//
	// * client_id
	//
	// * client_secret
	//
	// * attributes_request_method
	//
	// *
	// oidc_issuer
	//
	// * authorize_scopes
	//
	// * authorize_url if not available from discovery
	// URL specified by oidc_issuer key
	//
	// * token_url if not available from discovery
	// URL specified by oidc_issuer key
	//
	// * attributes_url if not available from
	// discovery URL specified by oidc_issuer key
	//
	// * jwks_uri if not available from
	// discovery URL specified by oidc_issuer key
	//
	// * attributes_url_add_attributes a
	// read-only property that is set automatically
	//
	// * For SAML providers:
	//
	// *
	// MetadataFile or MetadataURL
	//
	// * IDPSignOut optional
	ProviderDetails map[string]string

	// The identity provider name.
	ProviderName *string

	// The identity provider type.
	ProviderType IdentityProviderTypeType

	// The user pool ID.
	UserPoolId *string

	noSmithyDocumentSerde
}

// Specifies the configuration for Lambda triggers.
type LambdaConfigType struct {

	// Creates an authentication challenge.
	CreateAuthChallenge *string

	// A custom email sender Lambda trigger.
	CustomEmailSender *CustomEmailLambdaVersionConfigType

	// A custom Message Lambda trigger.
	CustomMessage *string

	// A custom SMS sender Lambda trigger.
	CustomSMSSender *CustomSMSLambdaVersionConfigType

	// Defines the authentication challenge.
	DefineAuthChallenge *string

	// The Amazon Resource Name (ARN) of an KMS key. Amazon Cognito uses the key to
	// encrypt codes and temporary passwords sent to CustomEmailSender and
	// CustomSMSSender.
	KMSKeyID *string

	// A post-authentication Lambda trigger.
	PostAuthentication *string

	// A post-confirmation Lambda trigger.
	PostConfirmation *string

	// A pre-authentication Lambda trigger.
	PreAuthentication *string

	// A pre-registration Lambda trigger.
	PreSignUp *string

	// A Lambda trigger that is invoked before token generation.
	PreTokenGeneration *string

	// The user migration Lambda config type.
	UserMigration *string

	// Verifies the authentication challenge response.
	VerifyAuthChallengeResponse *string

	noSmithyDocumentSerde
}

// The message template structure.
type MessageTemplateType struct {

	// The message template for email messages. EmailMessage is allowed only if
	// EmailSendingAccount
	// (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER.
	EmailMessage *string

	// The subject line for email messages. EmailSubject is allowed only if
	// EmailSendingAccount
	// (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER.
	EmailSubject *string

	// The message template for SMS messages.
	SMSMessage *string

	noSmithyDocumentSerde
}

// This data type is no longer supported. You can use it only for SMS multi-factor
// authentication (MFA) configurations. You can't use it for time-based one-time
// password (TOTP) software token MFA configurations.
type MFAOptionType struct {

	// The attribute name of the MFA option type. The only valid value is phone_number.
	AttributeName *string

	// The delivery medium to send the MFA code. You can use this parameter to set only
	// the SMS delivery medium value.
	DeliveryMedium DeliveryMediumType

	noSmithyDocumentSerde
}

// The new device metadata type.
type NewDeviceMetadataType struct {

	// The device group key.
	DeviceGroupKey *string

	// The device key.
	DeviceKey *string

	noSmithyDocumentSerde
}

// The notify configuration type.
type NotifyConfigurationType struct {

	// The Amazon Resource Name (ARN) of the identity that is associated with the
	// sending authorization policy. This identity permits Amazon Cognito to send for
	// the email address specified in the From parameter.
	//
	// This member is required.
	SourceArn *string

	// Email template used when a detected risk event is blocked.
	BlockEmail *NotifyEmailType

	// The email address that is sending the email. The address must be either
	// individually verified with Amazon Simple Email Service, or from a domain that
	// has been verified with Amazon SES.
	From *string

	// The multi-factor authentication (MFA) email template used when MFA is challenged
	// as part of a detected risk.
	MfaEmail *NotifyEmailType

	// The email template used when a detected risk event is allowed.
	NoActionEmail *NotifyEmailType

	// The destination to which the receiver of an email should reply to.
	ReplyTo *string

	noSmithyDocumentSerde
}

// The notify email type.
type NotifyEmailType struct {

	// The email subject.
	//
	// This member is required.
	Subject *string

	// The email HTML body.
	HtmlBody *string

	// The email text body.
	TextBody *string

	noSmithyDocumentSerde
}

// The minimum and maximum values of an attribute that is of the number data type.
type NumberAttributeConstraintsType struct {

	// The maximum value of an attribute that is of the number data type.
	MaxValue *string

	// The minimum value of an attribute that is of the number data type.
	MinValue *string

	noSmithyDocumentSerde
}

// The password policy type.
type PasswordPolicyType struct {

	// The minimum length of the password in the policy that you have set. This value
	// can't be less than 6.
	MinimumLength int32

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one lowercase letter in their password.
	RequireLowercase bool

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one number in their password.
	RequireNumbers bool

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one symbol in their password.
	RequireSymbols bool

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one uppercase letter in their password.
	RequireUppercase bool

	// The number of days a temporary password is valid in the password policy. If the
	// user doesn't sign in during this time, an administrator must reset their
	// password. When you set TemporaryPasswordValidityDays for a user pool, you can no
	// longer set the deprecated UnusedAccountValidityDays value for that user pool.
	TemporaryPasswordValidityDays int32

	noSmithyDocumentSerde
}

// A container for identity provider details.
type ProviderDescription struct {

	// The date the provider was added to the user pool.
	CreationDate *time.Time

	// The date the provider was last modified.
	LastModifiedDate *time.Time

	// The identity provider name.
	ProviderName *string

	// The identity provider type.
	ProviderType IdentityProviderTypeType

	noSmithyDocumentSerde
}

// A container for information about an identity provider for a user pool.
type ProviderUserIdentifierType struct {

	// The name of the provider attribute to link to, such as NameID.
	ProviderAttributeName *string

	// The value of the provider attribute to link to, such as xxxxx_account.
	ProviderAttributeValue *string

	// The name of the provider, such as Facebook, Google, or Login with Amazon.
	ProviderName *string

	noSmithyDocumentSerde
}

// A map containing a priority as a key, and recovery method name as a value.
type RecoveryOptionType struct {

	// The recovery method for a user.
	//
	// This member is required.
	Name RecoveryOptionNameType

	// A positive integer specifying priority of a method with 1 being the highest
	// priority.
	//
	// This member is required.
	Priority int32

	noSmithyDocumentSerde
}

// A resource server scope.
type ResourceServerScopeType struct {

	// A description of the scope.
	//
	// This member is required.
	ScopeDescription *string

	// The name of the scope.
	//
	// This member is required.
	ScopeName *string

	noSmithyDocumentSerde
}

// A container for information about a resource server for a user pool.
type ResourceServerType struct {

	// The identifier for the resource server.
	Identifier *string

	// The name of the resource server.
	Name *string

	// A list of scopes that are defined for the resource server.
	Scopes []ResourceServerScopeType

	// The user pool ID for the user pool that hosts the resource server.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The risk configuration type.
type RiskConfigurationType struct {

	// The account takeover risk configuration object, including the
	// NotifyConfiguration object and Actions to take if there is an account takeover.
	AccountTakeoverRiskConfiguration *AccountTakeoverRiskConfigurationType

	// The app client ID.
	ClientId *string

	// The compromised credentials risk configuration object, including the EventFilter
	// and the EventAction.
	CompromisedCredentialsRiskConfiguration *CompromisedCredentialsRiskConfigurationType

	// The last modified date.
	LastModifiedDate *time.Time

	// The configuration to override the risk decision.
	RiskExceptionConfiguration *RiskExceptionConfigurationType

	// The user pool ID.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The type of the configuration to override the risk decision.
type RiskExceptionConfigurationType struct {

	// Overrides the risk decision to always block the pre-authentication requests. The
	// IP range is in CIDR notation, a compact representation of an IP address and its
	// routing prefix.
	BlockedIPRangeList []string

	// Risk detection isn't performed on the IP addresses in this range list. The IP
	// range is in CIDR notation.
	SkippedIPRangeList []string

	noSmithyDocumentSerde
}

// Contains information about the schema attribute.
type SchemaAttributeType struct {

	// The attribute data type.
	AttributeDataType AttributeDataType

	// You should use WriteAttributes
	// (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes)
	// in the user pool client to control how attributes can be mutated for new use
	// cases instead of using DeveloperOnlyAttribute. Specifies whether the attribute
	// type is developer only. This attribute can only be modified by an administrator.
	// Users won't be able to modify this attribute using their access token. For
	// example, DeveloperOnlyAttribute can be modified using AdminUpdateUserAttributes
	// but can't be updated using UpdateUserAttributes.
	DeveloperOnlyAttribute bool

	// Specifies whether the value of the attribute can be changed. For any user pool
	// attribute that is mapped to an identity provider attribute, you must set this
	// parameter to true. Amazon Cognito updates mapped attributes when users sign in
	// to your application through an identity provider. If an attribute is immutable,
	// Amazon Cognito throws an error when it attempts to update the attribute. For
	// more information, see Specifying Identity Provider Attribute Mappings for Your
	// User Pool
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html).
	Mutable bool

	// A schema attribute of the name type.
	Name *string

	// Specifies the constraints for an attribute of the number type.
	NumberAttributeConstraints *NumberAttributeConstraintsType

	// Specifies whether a user pool attribute is required. If the attribute is
	// required and the user doesn't provide a value, registration or sign-in will
	// fail.
	Required bool

	// Specifies the constraints for an attribute of the string type.
	StringAttributeConstraints *StringAttributeConstraintsType

	noSmithyDocumentSerde
}

// The SMS configuration type that includes the settings the Amazon Cognito User
// Pool must call for the Amazon Simple Notification Service service to send an SMS
// message from your Amazon Web Services account. The Amazon Cognito User Pool
// makes the request to the Amazon SNS Service by using an Identity and Access
// Management role that you provide for your Amazon Web Services account.
type SmsConfigurationType struct {

	// The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the
	// IAM role in your Amazon Web Services account that Amazon Cognito will use to
	// send SMS messages. SMS messages are subject to a spending limit
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html).
	//
	// This member is required.
	SnsCallerArn *string

	// The external ID is a value that you should use to add security to your IAM role
	// that is used to call Amazon SNS to send SMS messages for your user pool. If you
	// provide an ExternalId, the Amazon Cognito User Pool will include it when
	// attempting to assume your IAM role so that you can set your roles trust policy
	// to require the ExternalID. If you use the Amazon Cognito Management Console to
	// create a role for SMS multi-factor authentication (MFA), Amazon Cognito will
	// create a role with the required permissions and a trust policy that demonstrates
	// use of the ExternalId. For more information about the ExternalId of a role, see
	// How to use an external ID when granting access to your Amazon Web Services
	// resources to a third party
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html)
	ExternalId *string

	noSmithyDocumentSerde
}

// The SMS text message multi-factor authentication (MFA) configuration type.
type SmsMfaConfigType struct {

	// The SMS authentication message that will be sent to users with the code they
	// must sign in. The message must contain the ‘{####}’ placeholder, which is
	// replaced with the code. If the message isn't included, and default message will
	// be used.
	SmsAuthenticationMessage *string

	// The SMS configuration.
	SmsConfiguration *SmsConfigurationType

	noSmithyDocumentSerde
}

// The type used for enabling SMS multi-factor authentication (MFA) at the user
// level. Phone numbers don't need to be verified to be used for SMS MFA. If an MFA
// type is activated for a user, the user will be prompted for MFA during all
// sign-in attempts, unless device tracking is turned on and the device has been
// trusted. If you would like MFA to be applied selectively based on the assessed
// risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive
// Authentication for the user pool.
type SMSMfaSettingsType struct {

	// Specifies whether SMS text message MFA is activated. If an MFA type is activated
	// for a user, the user will be prompted for MFA during all sign-in attempts,
	// unless device tracking is turned on and the device has been trusted.
	Enabled bool

	// Specifies whether SMS is the preferred MFA method.
	PreferredMfa bool

	noSmithyDocumentSerde
}

// The type used for enabling software token MFA at the user pool level.
type SoftwareTokenMfaConfigType struct {

	// Specifies whether software token MFA is activated.
	Enabled bool

	noSmithyDocumentSerde
}

// The type used for enabling software token MFA at the user level. If an MFA type
// is activated for a user, the user will be prompted for MFA during all sign-in
// attempts, unless device tracking is turned on and the device has been trusted.
// If you want MFA to be applied selectively based on the assessed risk level of
// sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication
// for the user pool.
type SoftwareTokenMfaSettingsType struct {

	// Specifies whether software token MFA is activated. If an MFA type is activated
	// for a user, the user will be prompted for MFA during all sign-in attempts,
	// unless device tracking is turned on and the device has been trusted.
	Enabled bool

	// Specifies whether software token MFA is the preferred MFA method.
	PreferredMfa bool

	noSmithyDocumentSerde
}

// The constraints associated with a string attribute.
type StringAttributeConstraintsType struct {

	// The maximum length.
	MaxLength *string

	// The minimum length.
	MinLength *string

	noSmithyDocumentSerde
}

// The data type for TokenValidityUnits that specifics the time measurements for
// token validity.
type TokenValidityUnitsType struct {

	// A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in
	// AccessTokenValidity, defaulting to hours.
	AccessToken TimeUnitsType

	// A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in
	// IdTokenValidity, defaulting to hours.
	IdToken TimeUnitsType

	// A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in
	// RefreshTokenValidity, defaulting to days.
	RefreshToken TimeUnitsType

	noSmithyDocumentSerde
}

// A container for the UI customization information for a user pool's built-in app
// UI.
type UICustomizationType struct {

	// The CSS values in the UI customization.
	CSS *string

	// The CSS version number.
	CSSVersion *string

	// The client ID for the client app.
	ClientId *string

	// The creation date for the UI customization.
	CreationDate *time.Time

	// The logo image for the UI customization.
	ImageUrl *string

	// The last-modified date for the UI customization.
	LastModifiedDate *time.Time

	// The user pool ID for the user pool.
	UserPoolId *string

	noSmithyDocumentSerde
}

// Contextual data, such as the user's device fingerprint, IP address, or location,
// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
// security.
type UserContextDataType struct {

	// Contextual data, such as the user's device fingerprint, IP address, or location,
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	EncodedData *string

	noSmithyDocumentSerde
}

// The user import job type.
type UserImportJobType struct {

	// The role Amazon Resource Name (ARN) for the Amazon CloudWatch Logging role for
	// the user import job. For more information, see "Creating the CloudWatch Logs IAM
	// Role" in the Amazon Cognito Developer Guide.
	CloudWatchLogsRoleArn *string

	// The date when the user import job was completed.
	CompletionDate *time.Time

	// The message returned when the user import job is completed.
	CompletionMessage *string

	// The date the user import job was created.
	CreationDate *time.Time

	// The number of users that couldn't be imported.
	FailedUsers int64

	// The number of users that were successfully imported.
	ImportedUsers int64

	// The job ID for the user import job.
	JobId *string

	// The job name for the user import job.
	JobName *string

	// The pre-signed URL to be used to upload the .csv file.
	PreSignedUrl *string

	// The number of users that were skipped.
	SkippedUsers int64

	// The date when the user import job was started.
	StartDate *time.Time

	// The status of the user import job. One of the following:
	//
	// * Created - The job
	// was created but not started.
	//
	// * Pending - A transition state. You have started
	// the job, but it has not begun importing users yet.
	//
	// * InProgress - The job has
	// started, and users are being imported.
	//
	// * Stopping - You have stopped the job,
	// but the job has not stopped importing users yet.
	//
	// * Stopped - You have stopped
	// the job, and the job has stopped importing users.
	//
	// * Succeeded - The job has
	// completed successfully.
	//
	// * Failed - The job has stopped due to an error.
	//
	// *
	// Expired - You created a job, but did not start the job within 24-48 hours. All
	// data associated with the job was deleted, and the job can't be started.
	Status UserImportJobStatusType

	// The user pool ID for the user pool that the users are being imported into.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The username configuration type.
type UsernameConfigurationType struct {

	// Specifies whether username case sensitivity will be applied for all users in the
	// user pool through Amazon Cognito APIs. Valid values include:
	//
	// * True : Enables
	// case sensitivity for all username input. When this option is set to True, users
	// must sign in using the exact capitalization of their given username, such as
	// “UserName”. This is the default value.
	//
	// * False : Enables case insensitivity for
	// all username input. For example, when this option is set to False, users can
	// sign in using either "username" or "Username". This option also enables both
	// preferred_username and email alias to be case insensitive, in addition to the
	// username attribute.
	//
	// This member is required.
	CaseSensitive *bool

	noSmithyDocumentSerde
}

// The user pool add-ons type.
type UserPoolAddOnsType struct {

	// The advanced security mode.
	//
	// This member is required.
	AdvancedSecurityMode AdvancedSecurityModeType

	noSmithyDocumentSerde
}

// The description of the user pool client.
type UserPoolClientDescription struct {

	// The ID of the client associated with the user pool.
	ClientId *string

	// The client name from the user pool client description.
	ClientName *string

	// The user pool ID for the user pool where you want to describe the user pool
	// client.
	UserPoolId *string

	noSmithyDocumentSerde
}

// Contains information about a user pool client.
type UserPoolClientType struct {

	// The time limit, specified by tokenValidityUnits, defaulting to hours, after
	// which the access token is no longer valid and can't be used.
	AccessTokenValidity *int32

	// The allowed OAuth flows. Set to code to initiate a code grant flow, which
	// provides an authorization code as the response. This code can be exchanged for
	// access tokens with the token endpoint. Set to implicit to specify that the
	// client should get the access token (and, optionally, ID token, based on scopes)
	// directly. Set to client_credentials to specify that the client should get the
	// access token (and, optionally, ID token, based on scopes) from the token
	// endpoint using a combination of client and client_secret.
	AllowedOAuthFlows []OAuthFlowType

	// Set to true if the client is allowed to follow the OAuth protocol when
	// interacting with Amazon Cognito user pools.
	AllowedOAuthFlowsUserPoolClient bool

	// The allowed OAuth scopes. Possible values provided by OAuth are: phone, email,
	// openid, and profile. Possible values provided by Amazon Web Services are:
	// aws.cognito.signin.user.admin. Custom scopes created in Resource Servers are
	// also supported.
	AllowedOAuthScopes []string

	// The Amazon Pinpoint analytics configuration for the user pool client. Amazon
	// Cognito User Pools only supports sending events to Amazon Pinpoint projects in
	// the US East (N. Virginia) us-east-1 Region, regardless of the Region in which
	// the user pool resides.
	AnalyticsConfiguration *AnalyticsConfigurationType

	// A list of allowed redirect (callback) URLs for the identity providers. A
	// redirect URI must:
	//
	// * Be an absolute URI.
	//
	// * Be registered with the
	// authorization server.
	//
	// * Not include a fragment component.
	//
	// See OAuth 2.0 -
	// Redirection Endpoint (https://tools.ietf.org/html/rfc6749#section-3.1.2). Amazon
	// Cognito requires HTTPS over HTTP except for http://localhost for testing
	// purposes only. App callback URLs such as myapp://example are also supported.
	CallbackURLs []string

	// The ID of the client associated with the user pool.
	ClientId *string

	// The client name from the user pool request of the client type.
	ClientName *string

	// The client secret from the user pool request of the client type.
	ClientSecret *string

	// The date the user pool client was created.
	CreationDate *time.Time

	// The default redirect URI. Must be in the CallbackURLs list. A redirect URI
	// must:
	//
	// * Be an absolute URI.
	//
	// * Be registered with the authorization server.
	//
	// *
	// Not include a fragment component.
	//
	// See OAuth 2.0 - Redirection Endpoint
	// (https://tools.ietf.org/html/rfc6749#section-3.1.2). Amazon Cognito requires
	// HTTPS over HTTP except for http://localhost for testing purposes only. App
	// callback URLs such as myapp://example are also supported.
	DefaultRedirectURI *string

	// Indicates whether token revocation is activated for the user pool client. When
	// you create a new user pool client, token revocation is activated by default. For
	// more information about revoking tokens, see RevokeToken
	// (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
	EnableTokenRevocation *bool

	// The authentication flows that are supported by the user pool clients. Flow names
	// without the ALLOW_ prefix are no longer supported in favor of new names with the
	// ALLOW_ prefix. Note that values with ALLOW_ prefix must be used only along with
	// values including the ALLOW_ prefix. Valid values include:
	//
	// *
	// ALLOW_ADMIN_USER_PASSWORD_AUTH: Enable admin based user password authentication
	// flow ADMIN_USER_PASSWORD_AUTH. This setting replaces the ADMIN_NO_SRP_AUTH
	// setting. With this authentication flow, Amazon Cognito receives the password in
	// the request instead of using the Secure Remote Password (SRP) protocol to verify
	// passwords.
	//
	// * ALLOW_CUSTOM_AUTH: Enable Lambda trigger based authentication.
	//
	// *
	// ALLOW_USER_PASSWORD_AUTH: Enable user password-based authentication. In this
	// flow, Amazon Cognito receives the password in the request instead of using the
	// SRP protocol to verify passwords.
	//
	// * ALLOW_USER_SRP_AUTH: Enable SRP-based
	// authentication.
	//
	// * ALLOW_REFRESH_TOKEN_AUTH: Enable authflow to refresh tokens.
	ExplicitAuthFlows []ExplicitAuthFlowsType

	// The time limit specified by tokenValidityUnits, defaulting to hours, after which
	// the refresh token is no longer valid and can't be used.
	IdTokenValidity *int32

	// The date the user pool client was last modified.
	LastModifiedDate *time.Time

	// A list of allowed logout URLs for the identity providers.
	LogoutURLs []string

	// Errors and responses that you want Amazon Cognito APIs to return during
	// authentication, account confirmation, and password recovery when the user
	// doesn't exist in the user pool. When set to ENABLED and the user doesn't exist,
	// authentication returns an error indicating either the username or password was
	// incorrect. Account confirmation and password recovery return a response
	// indicating a code was sent to a simulated destination. When set to LEGACY, those
	// APIs return a UserNotFoundException exception if the user doesn't exist in the
	// user pool. Valid values include:
	//
	// * ENABLED - This prevents user
	// existence-related errors.
	//
	// * LEGACY - This represents the old behavior of
	// Cognito where user existence related errors aren't prevented.
	PreventUserExistenceErrors PreventUserExistenceErrorTypes

	// The Read-only attributes.
	ReadAttributes []string

	// The time limit, in days, after which the refresh token is no longer valid and
	// can't be used.
	RefreshTokenValidity int32

	// A list of provider names for the identity providers that are supported on this
	// client.
	SupportedIdentityProviders []string

	// The time units used to specify the token validity times of their respective
	// token.
	TokenValidityUnits *TokenValidityUnitsType

	// The user pool ID for the user pool client.
	UserPoolId *string

	// The writeable attributes.
	WriteAttributes []string

	noSmithyDocumentSerde
}

// A user pool description.
type UserPoolDescriptionType struct {

	// The date the user pool description was created.
	CreationDate *time.Time

	// The ID in a user pool description.
	Id *string

	// The Lambda configuration information in a user pool description.
	LambdaConfig *LambdaConfigType

	// The date the user pool description was last modified.
	LastModifiedDate *time.Time

	// The name in a user pool description.
	Name *string

	// The user pool status in a user pool description.
	Status StatusType

	noSmithyDocumentSerde
}

// The policy associated with a user pool.
type UserPoolPolicyType struct {

	// The password policy.
	PasswordPolicy *PasswordPolicyType

	noSmithyDocumentSerde
}

// A container for information about the user pool.
type UserPoolType struct {

	// The available verified method a user can use to recover their password when they
	// call ForgotPassword. You can use this setting to define a preferred method when
	// a user has more than one method available. With this setting, SMS doesn't
	// qualify for a valid password recovery mechanism if the user also has SMS
	// multi-factor authentication (MFA) activated. In the absence of this setting,
	// Amazon Cognito uses the legacy behavior to determine the recovery method where
	// SMS is preferred through email.
	AccountRecoverySetting *AccountRecoverySettingType

	// The configuration for AdminCreateUser requests.
	AdminCreateUserConfig *AdminCreateUserConfigType

	// The attributes that are aliased in a user pool.
	AliasAttributes []AliasAttributeType

	// The Amazon Resource Name (ARN) for the user pool.
	Arn *string

	// The attributes that are auto-verified in a user pool.
	AutoVerifiedAttributes []VerifiedAttributeType

	// The date the user pool was created.
	CreationDate *time.Time

	// A custom domain name that you provide to Amazon Cognito. This parameter applies
	// only if you use a custom domain to host the sign-up and sign-in pages for your
	// application. An example of a custom domain name might be auth.example.com. For
	// more information about adding a custom domain to your user pool, see Using Your
	// Own Domain for the Hosted UI
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html).
	CustomDomain *string

	// The device configuration.
	DeviceConfiguration *DeviceConfigurationType

	// The domain prefix, if the user pool has a domain associated with it.
	Domain *string

	// The email configuration.
	EmailConfiguration *EmailConfigurationType

	// The reason why the email configuration can't send the messages to your users.
	EmailConfigurationFailure *string

	// The contents of the email verification message.
	EmailVerificationMessage *string

	// The subject of the email verification message.
	EmailVerificationSubject *string

	// A number estimating the size of the user pool.
	EstimatedNumberOfUsers int32

	// The ID of the user pool.
	Id *string

	// The Lambda triggers associated with the user pool.
	LambdaConfig *LambdaConfigType

	// The date the user pool was last modified.
	LastModifiedDate *time.Time

	// Can be one of the following values:
	//
	// * OFF - MFA tokens aren't required and
	// can't be specified during user registration.
	//
	// * ON - MFA tokens are required for
	// all user registrations. You can only specify required when you're initially
	// creating a user pool.
	//
	// * OPTIONAL - Users have the option when registering to
	// create an MFA token.
	MfaConfiguration UserPoolMfaType

	// The name of the user pool.
	Name *string

	// The policies associated with the user pool.
	Policies *UserPoolPolicyType

	// A container with the schema attributes of a user pool.
	SchemaAttributes []SchemaAttributeType

	// The contents of the SMS authentication message.
	SmsAuthenticationMessage *string

	// The SMS configuration.
	SmsConfiguration *SmsConfigurationType

	// The reason why the SMS configuration can't send the messages to your users. This
	// message might include comma-separated values to describe why your SMS
	// configuration can't send messages to user pool end users.
	//
	// *
	// InvalidSmsRoleAccessPolicyException - The Identity and Access Management role
	// that Amazon Cognito uses to send SMS messages isn't properly configured. For
	// more information, see SmsConfigurationType
	// (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SmsConfigurationType.html).
	//
	// *
	// SNSSandbox - The Amazon Web Services account is in SNS Sandbox and messages will
	// only reach verified end users. This parameter won’t get populated with
	// SNSSandbox if the IAM user creating the user pool doesn’t have SNS permissions.
	// To learn how to move your Amazon Web Services account out of the sandbox, see
	// Moving out of the SMS sandbox
	// (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox-moving-to-production.html).
	SmsConfigurationFailure *string

	// The contents of the SMS verification message.
	SmsVerificationMessage *string

	// The status of a user pool.
	Status StatusType

	// The user pool add-ons.
	UserPoolAddOns *UserPoolAddOnsType

	// The tags that are assigned to the user pool. A tag is a label that you can apply
	// to user pools to categorize and manage them in different ways, such as by
	// purpose, owner, environment, or other criteria.
	UserPoolTags map[string]string

	// Specifies whether a user can use an email address or phone number as a username
	// when they sign up.
	UsernameAttributes []UsernameAttributeType

	// Case sensitivity of the username input for the selected sign-in option. For
	// example, when case sensitivity is set to False, users can sign in using either
	// "username" or "Username". This configuration is immutable once it has been set.
	// For more information, see UsernameConfigurationType
	// (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html).
	UsernameConfiguration *UsernameConfigurationType

	// The template for verification messages.
	VerificationMessageTemplate *VerificationMessageTemplateType

	noSmithyDocumentSerde
}

// The user type.
type UserType struct {

	// A container with information about the user type attributes.
	Attributes []AttributeType

	// Specifies whether the user is enabled.
	Enabled bool

	// The MFA options for the user.
	MFAOptions []MFAOptionType

	// The creation date of the user.
	UserCreateDate *time.Time

	// The last modified date of the user.
	UserLastModifiedDate *time.Time

	// The user status. This can be one of the following:
	//
	// * UNCONFIRMED - User has
	// been created but not confirmed.
	//
	// * CONFIRMED - User has been confirmed.
	//
	// *
	// ARCHIVED - User is no longer active.
	//
	// * COMPROMISED - User is disabled due to a
	// potential security threat.
	//
	// * UNKNOWN - User status isn't known.
	//
	// *
	// RESET_REQUIRED - User is confirmed, but the user must request a code and reset
	// their password before they can sign in.
	//
	// * FORCE_CHANGE_PASSWORD - The user is
	// confirmed and the user can sign in using a temporary password, but on first
	// sign-in, the user must change their password to a new value before doing
	// anything else.
	UserStatus UserStatusType

	// The user name of the user you want to describe.
	Username *string

	noSmithyDocumentSerde
}

// The template for verification messages.
type VerificationMessageTemplateType struct {

	// The default email option.
	DefaultEmailOption DefaultEmailOptionType

	// The email message template. EmailMessage is allowed only if  EmailSendingAccount
	// (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER.
	EmailMessage *string

	// The email message template for sending a confirmation link to the user.
	// EmailMessageByLink is allowed only if  EmailSendingAccount
	// (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER.
	EmailMessageByLink *string

	// The subject line for the email message template. EmailSubject is allowed only if
	// EmailSendingAccount
	// (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER.
	EmailSubject *string

	// The subject line for the email message template for sending a confirmation link
	// to the user. EmailSubjectByLink is allowed only  EmailSendingAccount
	// (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER.
	EmailSubjectByLink *string

	// The SMS message template.
	SmsMessage *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
