// Code generated by smithy-go-codegen DO NOT EDIT.

package codegurureviewer

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/codegurureviewer/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpAssociateRepository struct {
}

func (*awsRestjson1_serializeOpAssociateRepository) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateRepository) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateRepositoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/associations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateRepositoryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateRepositoryInput(v *AssociateRepositoryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateRepositoryInput(v *AssociateRepositoryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.KMSKeyDetails != nil {
		ok := object.Key("KMSKeyDetails")
		if err := awsRestjson1_serializeDocumentKMSKeyDetails(v.KMSKeyDetails, ok); err != nil {
			return err
		}
	}

	if v.Repository != nil {
		ok := object.Key("Repository")
		if err := awsRestjson1_serializeDocumentRepository(v.Repository, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateCodeReview struct {
}

func (*awsRestjson1_serializeOpCreateCodeReview) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateCodeReview) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCodeReviewInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/codereviews")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateCodeReviewInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateCodeReviewInput(v *CreateCodeReviewInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateCodeReviewInput(v *CreateCodeReviewInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RepositoryAssociationArn != nil {
		ok := object.Key("RepositoryAssociationArn")
		ok.String(*v.RepositoryAssociationArn)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		if err := awsRestjson1_serializeDocumentCodeReviewType(v.Type, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeCodeReview struct {
}

func (*awsRestjson1_serializeOpDescribeCodeReview) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeCodeReview) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCodeReviewInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/codereviews/{CodeReviewArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeCodeReviewInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeCodeReviewInput(v *DescribeCodeReviewInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CodeReviewArn == nil || len(*v.CodeReviewArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CodeReviewArn must not be empty")}
	}
	if v.CodeReviewArn != nil {
		if err := encoder.SetURI("CodeReviewArn").String(*v.CodeReviewArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeRecommendationFeedback struct {
}

func (*awsRestjson1_serializeOpDescribeRecommendationFeedback) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeRecommendationFeedback) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRecommendationFeedbackInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/feedback/{CodeReviewArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeRecommendationFeedbackInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeRecommendationFeedbackInput(v *DescribeRecommendationFeedbackInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CodeReviewArn == nil || len(*v.CodeReviewArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CodeReviewArn must not be empty")}
	}
	if v.CodeReviewArn != nil {
		if err := encoder.SetURI("CodeReviewArn").String(*v.CodeReviewArn); err != nil {
			return err
		}
	}

	if v.RecommendationId != nil {
		encoder.SetQuery("RecommendationId").String(*v.RecommendationId)
	}

	if v.UserId != nil {
		encoder.SetQuery("UserId").String(*v.UserId)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeRepositoryAssociation struct {
}

func (*awsRestjson1_serializeOpDescribeRepositoryAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeRepositoryAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRepositoryAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/associations/{AssociationArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeRepositoryAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeRepositoryAssociationInput(v *DescribeRepositoryAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssociationArn == nil || len(*v.AssociationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AssociationArn must not be empty")}
	}
	if v.AssociationArn != nil {
		if err := encoder.SetURI("AssociationArn").String(*v.AssociationArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateRepository struct {
}

func (*awsRestjson1_serializeOpDisassociateRepository) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateRepository) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateRepositoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/associations/{AssociationArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateRepositoryInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateRepositoryInput(v *DisassociateRepositoryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssociationArn == nil || len(*v.AssociationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AssociationArn must not be empty")}
	}
	if v.AssociationArn != nil {
		if err := encoder.SetURI("AssociationArn").String(*v.AssociationArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListCodeReviews struct {
}

func (*awsRestjson1_serializeOpListCodeReviews) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCodeReviews) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCodeReviewsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/codereviews")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCodeReviewsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCodeReviewsInput(v *ListCodeReviewsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.ProviderTypes != nil {
		for i := range v.ProviderTypes {
			encoder.AddQuery("ProviderTypes").String(string(v.ProviderTypes[i]))
		}
	}

	if v.RepositoryNames != nil {
		for i := range v.RepositoryNames {
			encoder.AddQuery("RepositoryNames").String(v.RepositoryNames[i])
		}
	}

	if v.States != nil {
		for i := range v.States {
			encoder.AddQuery("States").String(string(v.States[i]))
		}
	}

	if len(v.Type) > 0 {
		encoder.SetQuery("Type").String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpListRecommendationFeedback struct {
}

func (*awsRestjson1_serializeOpListRecommendationFeedback) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRecommendationFeedback) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRecommendationFeedbackInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/feedback/{CodeReviewArn}/RecommendationFeedback")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRecommendationFeedbackInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRecommendationFeedbackInput(v *ListRecommendationFeedbackInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CodeReviewArn == nil || len(*v.CodeReviewArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CodeReviewArn must not be empty")}
	}
	if v.CodeReviewArn != nil {
		if err := encoder.SetURI("CodeReviewArn").String(*v.CodeReviewArn); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.RecommendationIds != nil {
		for i := range v.RecommendationIds {
			encoder.AddQuery("RecommendationIds").String(v.RecommendationIds[i])
		}
	}

	if v.UserIds != nil {
		for i := range v.UserIds {
			encoder.AddQuery("UserIds").String(v.UserIds[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpListRecommendations struct {
}

func (*awsRestjson1_serializeOpListRecommendations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRecommendations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRecommendationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/codereviews/{CodeReviewArn}/Recommendations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRecommendationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRecommendationsInput(v *ListRecommendationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CodeReviewArn == nil || len(*v.CodeReviewArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CodeReviewArn must not be empty")}
	}
	if v.CodeReviewArn != nil {
		if err := encoder.SetURI("CodeReviewArn").String(*v.CodeReviewArn); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListRepositoryAssociations struct {
}

func (*awsRestjson1_serializeOpListRepositoryAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRepositoryAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRepositoryAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/associations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRepositoryAssociationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRepositoryAssociationsInput(v *ListRepositoryAssociationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.Names != nil {
		for i := range v.Names {
			encoder.AddQuery("Name").String(v.Names[i])
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.Owners != nil {
		for i := range v.Owners {
			encoder.AddQuery("Owner").String(v.Owners[i])
		}
	}

	if v.ProviderTypes != nil {
		for i := range v.ProviderTypes {
			encoder.AddQuery("ProviderType").String(string(v.ProviderTypes[i]))
		}
	}

	if v.States != nil {
		for i := range v.States {
			encoder.AddQuery("State").String(string(v.States[i]))
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutRecommendationFeedback struct {
}

func (*awsRestjson1_serializeOpPutRecommendationFeedback) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutRecommendationFeedback) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutRecommendationFeedbackInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/feedback")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutRecommendationFeedbackInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutRecommendationFeedbackInput(v *PutRecommendationFeedbackInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutRecommendationFeedbackInput(v *PutRecommendationFeedbackInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CodeReviewArn != nil {
		ok := object.Key("CodeReviewArn")
		ok.String(*v.CodeReviewArn)
	}

	if v.Reactions != nil {
		ok := object.Key("Reactions")
		if err := awsRestjson1_serializeDocumentReactions(v.Reactions, ok); err != nil {
			return err
		}
	}

	if v.RecommendationId != nil {
		ok := object.Key("RecommendationId")
		ok.String(*v.RecommendationId)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalysisTypes(v []types.AnalysisType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentBranchDiffSourceCodeType(v *types.BranchDiffSourceCodeType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationBranchName != nil {
		ok := object.Key("DestinationBranchName")
		ok.String(*v.DestinationBranchName)
	}

	if v.SourceBranchName != nil {
		ok := object.Key("SourceBranchName")
		ok.String(*v.SourceBranchName)
	}

	return nil
}

func awsRestjson1_serializeDocumentCodeArtifacts(v *types.CodeArtifacts, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BuildArtifactsObjectKey != nil {
		ok := object.Key("BuildArtifactsObjectKey")
		ok.String(*v.BuildArtifactsObjectKey)
	}

	if v.SourceCodeArtifactsObjectKey != nil {
		ok := object.Key("SourceCodeArtifactsObjectKey")
		ok.String(*v.SourceCodeArtifactsObjectKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentCodeCommitRepository(v *types.CodeCommitRepository, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentCodeReviewType(v *types.CodeReviewType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalysisTypes != nil {
		ok := object.Key("AnalysisTypes")
		if err := awsRestjson1_serializeDocumentAnalysisTypes(v.AnalysisTypes, ok); err != nil {
			return err
		}
	}

	if v.RepositoryAnalysis != nil {
		ok := object.Key("RepositoryAnalysis")
		if err := awsRestjson1_serializeDocumentRepositoryAnalysis(v.RepositoryAnalysis, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCommitDiffSourceCodeType(v *types.CommitDiffSourceCodeType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationCommit != nil {
		ok := object.Key("DestinationCommit")
		ok.String(*v.DestinationCommit)
	}

	if v.MergeBaseCommit != nil {
		ok := object.Key("MergeBaseCommit")
		ok.String(*v.MergeBaseCommit)
	}

	if v.SourceCommit != nil {
		ok := object.Key("SourceCommit")
		ok.String(*v.SourceCommit)
	}

	return nil
}

func awsRestjson1_serializeDocumentEventInfo(v *types.EventInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.State != nil {
		ok := object.Key("State")
		ok.String(*v.State)
	}

	return nil
}

func awsRestjson1_serializeDocumentKMSKeyDetails(v *types.KMSKeyDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EncryptionOption) > 0 {
		ok := object.Key("EncryptionOption")
		ok.String(string(v.EncryptionOption))
	}

	if v.KMSKeyId != nil {
		ok := object.Key("KMSKeyId")
		ok.String(*v.KMSKeyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentReactions(v []types.Reaction, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentRepository(v *types.Repository, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bitbucket != nil {
		ok := object.Key("Bitbucket")
		if err := awsRestjson1_serializeDocumentThirdPartySourceRepository(v.Bitbucket, ok); err != nil {
			return err
		}
	}

	if v.CodeCommit != nil {
		ok := object.Key("CodeCommit")
		if err := awsRestjson1_serializeDocumentCodeCommitRepository(v.CodeCommit, ok); err != nil {
			return err
		}
	}

	if v.GitHubEnterpriseServer != nil {
		ok := object.Key("GitHubEnterpriseServer")
		if err := awsRestjson1_serializeDocumentThirdPartySourceRepository(v.GitHubEnterpriseServer, ok); err != nil {
			return err
		}
	}

	if v.S3Bucket != nil {
		ok := object.Key("S3Bucket")
		if err := awsRestjson1_serializeDocumentS3Repository(v.S3Bucket, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRepositoryAnalysis(v *types.RepositoryAnalysis, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RepositoryHead != nil {
		ok := object.Key("RepositoryHead")
		if err := awsRestjson1_serializeDocumentRepositoryHeadSourceCodeType(v.RepositoryHead, ok); err != nil {
			return err
		}
	}

	if v.SourceCodeType != nil {
		ok := object.Key("SourceCodeType")
		if err := awsRestjson1_serializeDocumentSourceCodeType(v.SourceCodeType, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRepositoryHeadSourceCodeType(v *types.RepositoryHeadSourceCodeType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BranchName != nil {
		ok := object.Key("BranchName")
		ok.String(*v.BranchName)
	}

	return nil
}

func awsRestjson1_serializeDocumentRequestMetadata(v *types.RequestMetadata, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventInfo != nil {
		ok := object.Key("EventInfo")
		if err := awsRestjson1_serializeDocumentEventInfo(v.EventInfo, ok); err != nil {
			return err
		}
	}

	if v.Requester != nil {
		ok := object.Key("Requester")
		ok.String(*v.Requester)
	}

	if v.RequestId != nil {
		ok := object.Key("RequestId")
		ok.String(*v.RequestId)
	}

	if len(v.VendorName) > 0 {
		ok := object.Key("VendorName")
		ok.String(string(v.VendorName))
	}

	return nil
}

func awsRestjson1_serializeDocumentS3BucketRepository(v *types.S3BucketRepository, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Details != nil {
		ok := object.Key("Details")
		if err := awsRestjson1_serializeDocumentS3RepositoryDetails(v.Details, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3Repository(v *types.S3Repository, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("BucketName")
		ok.String(*v.BucketName)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3RepositoryDetails(v *types.S3RepositoryDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("BucketName")
		ok.String(*v.BucketName)
	}

	if v.CodeArtifacts != nil {
		ok := object.Key("CodeArtifacts")
		if err := awsRestjson1_serializeDocumentCodeArtifacts(v.CodeArtifacts, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSourceCodeType(v *types.SourceCodeType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BranchDiff != nil {
		ok := object.Key("BranchDiff")
		if err := awsRestjson1_serializeDocumentBranchDiffSourceCodeType(v.BranchDiff, ok); err != nil {
			return err
		}
	}

	if v.CommitDiff != nil {
		ok := object.Key("CommitDiff")
		if err := awsRestjson1_serializeDocumentCommitDiffSourceCodeType(v.CommitDiff, ok); err != nil {
			return err
		}
	}

	if v.RepositoryHead != nil {
		ok := object.Key("RepositoryHead")
		if err := awsRestjson1_serializeDocumentRepositoryHeadSourceCodeType(v.RepositoryHead, ok); err != nil {
			return err
		}
	}

	if v.RequestMetadata != nil {
		ok := object.Key("RequestMetadata")
		if err := awsRestjson1_serializeDocumentRequestMetadata(v.RequestMetadata, ok); err != nil {
			return err
		}
	}

	if v.S3BucketRepository != nil {
		ok := object.Key("S3BucketRepository")
		if err := awsRestjson1_serializeDocumentS3BucketRepository(v.S3BucketRepository, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentThirdPartySourceRepository(v *types.ThirdPartySourceRepository, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionArn != nil {
		ok := object.Key("ConnectionArn")
		ok.String(*v.ConnectionArn)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Owner != nil {
		ok := object.Key("Owner")
		ok.String(*v.Owner)
	}

	return nil
}
