// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudtrail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/cloudtrail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists trails that are in the current account.
func (c *Client) ListTrails(ctx context.Context, params *ListTrailsInput, optFns ...func(*Options)) (*ListTrailsOutput, error) {
	if params == nil {
		params = &ListTrailsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTrails", params, optFns, c.addOperationListTrailsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTrailsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTrailsInput struct {

	// The token to use to get the next page of results after a previous API call. This
	// token must be passed in with the same parameters that were specified in the the
	// original call. For example, if the original call specified an AttributeKey of
	// 'Username' with a value of 'root', the call with NextToken should include those
	// same parameters.
	NextToken *string

	noSmithyDocumentSerde
}

type ListTrailsOutput struct {

	// The token to use to get the next page of results after a previous API call. If
	// the token does not appear, there are no more results to return. The token must
	// be passed in with the same parameters as the previous call. For example, if the
	// original call specified an AttributeKey of 'Username' with a value of 'root',
	// the call with NextToken should include those same parameters.
	NextToken *string

	// Returns the name, ARN, and home region of trails in the current account.
	Trails []types.TrailInfo

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTrailsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListTrails{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListTrails{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTrails(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTrailsAPIClient is a client that implements the ListTrails operation.
type ListTrailsAPIClient interface {
	ListTrails(context.Context, *ListTrailsInput, ...func(*Options)) (*ListTrailsOutput, error)
}

var _ ListTrailsAPIClient = (*Client)(nil)

// ListTrailsPaginatorOptions is the paginator options for ListTrails
type ListTrailsPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTrailsPaginator is a paginator for ListTrails
type ListTrailsPaginator struct {
	options   ListTrailsPaginatorOptions
	client    ListTrailsAPIClient
	params    *ListTrailsInput
	nextToken *string
	firstPage bool
}

// NewListTrailsPaginator returns a new ListTrailsPaginator
func NewListTrailsPaginator(client ListTrailsAPIClient, params *ListTrailsInput, optFns ...func(*ListTrailsPaginatorOptions)) *ListTrailsPaginator {
	if params == nil {
		params = &ListTrailsInput{}
	}

	options := ListTrailsPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTrailsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTrailsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTrails page.
func (p *ListTrailsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTrailsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	result, err := p.client.ListTrails(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListTrails(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "cloudtrail",
		OperationName: "ListTrails",
	}
}
