// Code generated by smithy-go-codegen DO NOT EDIT.

package transcribe

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/transcribe/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists transcription jobs with the specified status.
func (c *Client) ListTranscriptionJobs(ctx context.Context, params *ListTranscriptionJobsInput, optFns ...func(*Options)) (*ListTranscriptionJobsOutput, error) {
	if params == nil {
		params = &ListTranscriptionJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTranscriptionJobs", params, optFns, c.addOperationListTranscriptionJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTranscriptionJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTranscriptionJobsInput struct {

	// When specified, the jobs returned in the list are limited to jobs whose name
	// contains the specified string.
	JobNameContains *string

	// The maximum number of jobs to return in each page of results. If there are fewer
	// results than the value you specify, only the actual results are returned. If you
	// do not specify a value, the default of 5 is used.
	MaxResults *int32

	// If the result of the previous request to ListTranscriptionJobs is truncated,
	// include the NextToken to fetch the next set of jobs.
	NextToken *string

	// When specified, returns only transcription jobs with the specified status. Jobs
	// are ordered by creation date, with the newest jobs returned first. If you don’t
	// specify a status, Amazon Transcribe returns all transcription jobs ordered by
	// creation date.
	Status types.TranscriptionJobStatus

	noSmithyDocumentSerde
}

type ListTranscriptionJobsOutput struct {

	// The ListTranscriptionJobs operation returns a page of jobs at a time. The
	// maximum size of the page is set by the MaxResults parameter. If there are more
	// jobs in the list than the page size, Amazon Transcribe returns the NextPage
	// token. Include the token in the next request to the ListTranscriptionJobs
	// operation to return in the next page of jobs.
	NextToken *string

	// The requested status of the jobs returned.
	Status types.TranscriptionJobStatus

	// A list of objects containing summary information for a transcription job.
	TranscriptionJobSummaries []types.TranscriptionJobSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTranscriptionJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListTranscriptionJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListTranscriptionJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTranscriptionJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTranscriptionJobsAPIClient is a client that implements the
// ListTranscriptionJobs operation.
type ListTranscriptionJobsAPIClient interface {
	ListTranscriptionJobs(context.Context, *ListTranscriptionJobsInput, ...func(*Options)) (*ListTranscriptionJobsOutput, error)
}

var _ ListTranscriptionJobsAPIClient = (*Client)(nil)

// ListTranscriptionJobsPaginatorOptions is the paginator options for
// ListTranscriptionJobs
type ListTranscriptionJobsPaginatorOptions struct {
	// The maximum number of jobs to return in each page of results. If there are fewer
	// results than the value you specify, only the actual results are returned. If you
	// do not specify a value, the default of 5 is used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTranscriptionJobsPaginator is a paginator for ListTranscriptionJobs
type ListTranscriptionJobsPaginator struct {
	options   ListTranscriptionJobsPaginatorOptions
	client    ListTranscriptionJobsAPIClient
	params    *ListTranscriptionJobsInput
	nextToken *string
	firstPage bool
}

// NewListTranscriptionJobsPaginator returns a new ListTranscriptionJobsPaginator
func NewListTranscriptionJobsPaginator(client ListTranscriptionJobsAPIClient, params *ListTranscriptionJobsInput, optFns ...func(*ListTranscriptionJobsPaginatorOptions)) *ListTranscriptionJobsPaginator {
	if params == nil {
		params = &ListTranscriptionJobsInput{}
	}

	options := ListTranscriptionJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTranscriptionJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTranscriptionJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTranscriptionJobs page.
func (p *ListTranscriptionJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTranscriptionJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListTranscriptionJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListTranscriptionJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "transcribe",
		OperationName: "ListTranscriptionJobs",
	}
}
