// Code generated by smithy-go-codegen DO NOT EDIT.

package snowball

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/snowball/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This action returns a list of the different Amazon EC2 Amazon Machine Images
// (AMIs) that are owned by your Amazon Web Services accountthat would be supported
// for use on a Snow device. Currently, supported AMIs are based on the CentOS 7
// (x86_64) - with Updates HVM, Ubuntu Server 14.04 LTS (HVM), and Ubuntu 16.04 LTS
// - Xenial (HVM) images, available on the Amazon Web Services Marketplace.
func (c *Client) ListCompatibleImages(ctx context.Context, params *ListCompatibleImagesInput, optFns ...func(*Options)) (*ListCompatibleImagesOutput, error) {
	if params == nil {
		params = &ListCompatibleImagesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCompatibleImages", params, optFns, c.addOperationListCompatibleImagesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCompatibleImagesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCompatibleImagesInput struct {

	// The maximum number of results for the list of compatible images. Currently, a
	// Snowball Edge device can store 10 AMIs.
	MaxResults *int32

	// HTTP requests are stateless. To identify what object comes "next" in the list of
	// compatible images, you can specify a value for NextToken as the starting point
	// for your list of returned images.
	NextToken *string

	noSmithyDocumentSerde
}

type ListCompatibleImagesOutput struct {

	// A JSON-formatted object that describes a compatible AMI, including the ID and
	// name for a Snow device AMI.
	CompatibleImages []types.CompatibleImage

	// Because HTTP requests are stateless, this is the starting point for your next
	// list of returned images.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCompatibleImagesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListCompatibleImages{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListCompatibleImages{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCompatibleImages(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListCompatibleImages(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "snowball",
		OperationName: "ListCompatibleImages",
	}
}
