// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The details of an Amazon Web Services account.
type AccountDetails struct {

	// The ID of an Amazon Web Services account.
	//
	// This member is required.
	AccountId *string

	// The email of an Amazon Web Services account.
	Email *string

	noSmithyDocumentSerde
}

// Provides details about one of the following actions that affects or that was
// taken on a resource:
//
// * A remote IP address issued an Amazon Web Services API
// call
//
// * A DNS request was received
//
// * A remote IP address attempted to connect
// to an EC2 instance
//
// * A remote IP address attempted a port probe on an EC2
// instance
type Action struct {

	// The type of action that was detected. The possible action types are:
	//
	// *
	// NETWORK_CONNECTION
	//
	// * AWS_API_CALL
	//
	// * DNS_REQUEST
	//
	// * PORT_PROBE
	ActionType *string

	// Included if ActionType is AWS_API_CALL. Provides details about the API call that
	// was detected.
	AwsApiCallAction *AwsApiCallAction

	// Included if ActionType is DNS_REQUEST. Provides details about the DNS request
	// that was detected.
	DnsRequestAction *DnsRequestAction

	// Included if ActionType is NETWORK_CONNECTION. Provides details about the network
	// connection that was detected.
	NetworkConnectionAction *NetworkConnectionAction

	// Included if ActionType is PORT_PROBE. Provides details about the port probe that
	// was detected.
	PortProbeAction *PortProbeAction

	noSmithyDocumentSerde
}

// Provides information about the IP address where the scanned port is located.
type ActionLocalIpDetails struct {

	// The IP address.
	IpAddressV4 *string

	noSmithyDocumentSerde
}

// For NetworkConnectionAction and PortProbeDetails, LocalPortDetails provides
// information about the local port that was involved in the action.
type ActionLocalPortDetails struct {

	// The number of the port.
	Port int32

	// The port name of the local connection.
	PortName *string

	noSmithyDocumentSerde
}

// For AwsApiAction, NetworkConnectionAction, and PortProbeAction, RemoteIpDetails
// provides information about the remote IP address that was involved in the
// action.
type ActionRemoteIpDetails struct {

	// The city where the remote IP address is located.
	City *City

	// The country where the remote IP address is located.
	Country *Country

	// The coordinates of the location of the remote IP address.
	GeoLocation *GeoLocation

	// The IP address.
	IpAddressV4 *string

	// The internet service provider (ISP) organization associated with the remote IP
	// address.
	Organization *IpOrganizationDetails

	noSmithyDocumentSerde
}

// Provides information about the remote port that was involved in an attempted
// network connection.
type ActionRemotePortDetails struct {

	// The number of the port.
	Port int32

	// The port name of the remote connection.
	PortName *string

	noSmithyDocumentSerde
}

// An ActionTarget object.
type ActionTarget struct {

	// The ARN for the target action.
	//
	// This member is required.
	ActionTargetArn *string

	// The description of the target action.
	//
	// This member is required.
	Description *string

	// The name of the action target.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// An adjustment to the CVSS metric.
type Adjustment struct {

	// The metric to adjust.
	Metric *string

	// The reason for the adjustment.
	Reason *string

	noSmithyDocumentSerde
}

// Represents a Security Hub administrator account designated by an organization
// management account.
type AdminAccount struct {

	// The Amazon Web Services account identifier of the Security Hub administrator
	// account.
	AccountId *string

	// The current status of the Security Hub administrator account. Indicates whether
	// the account is currently enabled as a Security Hub administrator.
	Status AdminStatus

	noSmithyDocumentSerde
}

// Information about an Availability Zone.
type AvailabilityZone struct {

	// The ID of the subnet. You can specify one subnet per Availability Zone.
	SubnetId *string

	// The name of the Availability Zone.
	ZoneName *string

	noSmithyDocumentSerde
}

// Provided if ActionType is AWS_API_CALL. It provides details about the API call
// that was detected.
type AwsApiCallAction struct {

	// Identifies the resources that were affected by the API call.
	AffectedResources map[string]string

	// The name of the API method that was issued.
	Api *string

	// Indicates whether the API call originated from a remote IP address (remoteip) or
	// from a DNS domain (domain).
	CallerType *string

	// Provided if CallerType is domain. Provides information about the DNS domain that
	// the API call originated from.
	DomainDetails *AwsApiCallActionDomainDetails

	// An ISO8601-formatted timestamp that indicates when the API call was first
	// observed.
	FirstSeen *string

	// An ISO8601-formatted timestamp that indicates when the API call was most
	// recently observed.
	LastSeen *string

	// Provided if CallerType is remoteIp. Provides information about the remote IP
	// address that the API call originated from.
	RemoteIpDetails *ActionRemoteIpDetails

	// The name of the Amazon Web Services service that the API method belongs to.
	ServiceName *string

	noSmithyDocumentSerde
}

// Provided if CallerType is domain. It provides information about the DNS domain
// that issued the API call.
type AwsApiCallActionDomainDetails struct {

	// The name of the DNS domain that issued the API call.
	Domain *string

	noSmithyDocumentSerde
}

// Contains information about settings for logging access for the stage.
type AwsApiGatewayAccessLogSettings struct {

	// The ARN of the CloudWatch Logs log group that receives the access logs.
	DestinationArn *string

	// A single-line format of the access logs of data, as specified by selected
	// $context variables. The format must include at least $context.requestId.
	Format *string

	noSmithyDocumentSerde
}

// Contains information about settings for canary deployment in the stage.
type AwsApiGatewayCanarySettings struct {

	// The deployment identifier for the canary deployment.
	DeploymentId *string

	// The percentage of traffic that is diverted to a canary deployment.
	PercentTraffic float64

	// Stage variables that are overridden in the canary release deployment. The
	// variables include new stage variables that are introduced in the canary. Each
	// variable is represented as a string-to-string map between the stage variable
	// name and the variable value.
	StageVariableOverrides map[string]string

	// Indicates whether the canary deployment uses the stage cache.
	UseStageCache bool

	noSmithyDocumentSerde
}

// Contains information about the endpoints for the API.
type AwsApiGatewayEndpointConfiguration struct {

	// A list of endpoint types for the REST API. For an edge-optimized API, the
	// endpoint type is EDGE. For a Regional API, the endpoint type is REGIONAL. For a
	// private API, the endpoint type is PRIVATE.
	Types []string

	noSmithyDocumentSerde
}

// Defines settings for a method for the stage.
type AwsApiGatewayMethodSettings struct {

	// Indicates whether the cached responses are encrypted.
	CacheDataEncrypted bool

	// Specifies the time to live (TTL), in seconds, for cached responses. The higher
	// the TTL, the longer the response is cached.
	CacheTtlInSeconds int32

	// Indicates whether responses are cached and returned for requests. For responses
	// to be cached, a cache cluster must be enabled on the stage.
	CachingEnabled bool

	// Indicates whether data trace logging is enabled for the method. Data trace
	// logging affects the log entries that are pushed to CloudWatch Logs.
	DataTraceEnabled bool

	// The HTTP method. You can use an asterisk (*) as a wildcard to apply method
	// settings to multiple methods.
	HttpMethod *string

	// The logging level for this method. The logging level affects the log entries
	// that are pushed to CloudWatch Logs. If the logging level is ERROR, then the logs
	// only include error-level entries. If the logging level is INFO, then the logs
	// include both ERROR events and extra informational events. Valid values: OFF |
	// ERROR | INFO
	LoggingLevel *string

	// Indicates whether CloudWatch metrics are enabled for the method.
	MetricsEnabled bool

	// Indicates whether authorization is required for a cache invalidation request.
	RequireAuthorizationForCacheControl bool

	// The resource path for this method. Forward slashes (/) are encoded as ~1 . The
	// initial slash must include a forward slash. For example, the path value
	// /resource/subresource must be encoded as /~1resource~1subresource. To specify
	// the root path, use only a slash (/). You can use an asterisk (*) as a wildcard
	// to apply method settings to multiple methods.
	ResourcePath *string

	// The throttling burst limit for the method.
	ThrottlingBurstLimit int32

	// The throttling rate limit for the method.
	ThrottlingRateLimit float64

	// Indicates how to handle unauthorized requests for cache invalidation. Valid
	// values: FAIL_WITH_403 | SUCCEED_WITH_RESPONSE_HEADER |
	// SUCCEED_WITHOUT_RESPONSE_HEADER
	UnauthorizedCacheControlHeaderStrategy *string

	noSmithyDocumentSerde
}

// Contains information about a REST API in version 1 of Amazon API Gateway.
type AwsApiGatewayRestApiDetails struct {

	// The source of the API key for metering requests according to a usage plan.
	// HEADER indicates whether to read the API key from the X-API-Key header of a
	// request. AUTHORIZER indicates whether to read the API key from the
	// UsageIdentifierKey from a custom authorizer.
	ApiKeySource *string

	// The list of binary media types supported by the REST API.
	BinaryMediaTypes []string

	// Indicates when the API was created. Uses the date-time format specified in RFC
	// 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string

	// A description of the REST API.
	Description *string

	// The endpoint configuration of the REST API.
	EndpointConfiguration *AwsApiGatewayEndpointConfiguration

	// The identifier of the REST API.
	Id *string

	// The minimum size in bytes of a payload before compression is enabled. If null,
	// then compression is disabled. If 0, then all payloads are compressed.
	MinimumCompressionSize int32

	// The name of the REST API.
	Name *string

	// The version identifier for the REST API.
	Version *string

	noSmithyDocumentSerde
}

// Provides information about a version 1 Amazon API Gateway stage.
type AwsApiGatewayStageDetails struct {

	// Settings for logging access for the stage.
	AccessLogSettings *AwsApiGatewayAccessLogSettings

	// Indicates whether a cache cluster is enabled for the stage.
	CacheClusterEnabled bool

	// If a cache cluster is enabled, the size of the cache cluster.
	CacheClusterSize *string

	// If a cache cluster is enabled, the status of the cache cluster.
	CacheClusterStatus *string

	// Information about settings for canary deployment in the stage.
	CanarySettings *AwsApiGatewayCanarySettings

	// The identifier of the client certificate for the stage.
	ClientCertificateId *string

	// Indicates when the stage was created. Uses the date-time format specified in RFC
	// 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string

	// The identifier of the deployment that the stage points to.
	DeploymentId *string

	// A description of the stage.
	Description *string

	// The version of the API documentation that is associated with the stage.
	DocumentationVersion *string

	// Indicates when the stage was most recently updated. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	LastUpdatedDate *string

	// Defines the method settings for the stage.
	MethodSettings []AwsApiGatewayMethodSettings

	// The name of the stage.
	StageName *string

	// Indicates whether active tracing with X-Ray is enabled for the stage.
	TracingEnabled bool

	// A map that defines the stage variables for the stage. Variable names can have
	// alphanumeric and underscore characters. Variable values can contain the
	// following characters:
	//
	// * Uppercase and lowercase letters
	//
	// * Numbers
	//
	// * Special
	// characters -._~:/?#&=,
	Variables map[string]string

	// The ARN of the web ACL associated with the stage.
	WebAclArn *string

	noSmithyDocumentSerde
}

// Contains information about a version 2 API in Amazon API Gateway.
type AwsApiGatewayV2ApiDetails struct {

	// The URI of the API. Uses the format  .execute-api..amazonaws.com The stage name
	// is typically appended to the URI to form a complete path to a deployed API
	// stage.
	ApiEndpoint *string

	// The identifier of the API.
	ApiId *string

	// An API key selection expression. Supported only for WebSocket APIs.
	ApiKeySelectionExpression *string

	// A cross-origin resource sharing (CORS) configuration. Supported only for HTTP
	// APIs.
	CorsConfiguration *AwsCorsConfiguration

	// Indicates when the API was created. Uses the date-time format specified in RFC
	// 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string

	// A description of the API.
	Description *string

	// The name of the API.
	Name *string

	// The API protocol for the API. Valid values: WEBSOCKET | HTTP
	ProtocolType *string

	// The route selection expression for the API. For HTTP APIs, must be
	// ${request.method} ${request.path}. This is the default value for HTTP APIs. For
	// WebSocket APIs, there is no default value.
	RouteSelectionExpression *string

	// The version identifier for the API.
	Version *string

	noSmithyDocumentSerde
}

// Contains route settings for a stage.
type AwsApiGatewayV2RouteSettings struct {

	// Indicates whether data trace logging is enabled. Data trace logging affects the
	// log entries that are pushed to CloudWatch Logs. Supported only for WebSocket
	// APIs.
	DataTraceEnabled bool

	// Indicates whether detailed metrics are enabled.
	DetailedMetricsEnabled bool

	// The logging level. The logging level affects the log entries that are pushed to
	// CloudWatch Logs. Supported only for WebSocket APIs. If the logging level is
	// ERROR, then the logs only include error-level entries. If the logging level is
	// INFO, then the logs include both ERROR events and extra informational events.
	// Valid values: OFF | ERROR | INFO
	LoggingLevel *string

	// The throttling burst limit.
	ThrottlingBurstLimit int32

	// The throttling rate limit.
	ThrottlingRateLimit float64

	noSmithyDocumentSerde
}

// Contains information about a version 2 stage for Amazon API Gateway.
type AwsApiGatewayV2StageDetails struct {

	// Information about settings for logging access for the stage.
	AccessLogSettings *AwsApiGatewayAccessLogSettings

	// Indicates whether the stage is managed by API Gateway.
	ApiGatewayManaged bool

	// Indicates whether updates to an API automatically trigger a new deployment.
	AutoDeploy bool

	// The identifier of a client certificate for a stage. Supported only for WebSocket
	// API calls.
	ClientCertificateId *string

	// Indicates when the stage was created. Uses the date-time format specified in RFC
	// 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string

	// Default route settings for the stage.
	DefaultRouteSettings *AwsApiGatewayV2RouteSettings

	// The identifier of the deployment that the stage is associated with.
	DeploymentId *string

	// The description of the stage.
	Description *string

	// The status of the last deployment of a stage. Supported only if the stage has
	// automatic deployment enabled.
	LastDeploymentStatusMessage *string

	// Indicates when the stage was most recently updated. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	LastUpdatedDate *string

	// The route settings for the stage.
	RouteSettings *AwsApiGatewayV2RouteSettings

	// The name of the stage.
	StageName *string

	// A map that defines the stage variables for the stage. Variable names can have
	// alphanumeric and underscore characters. Variable values can contain the
	// following characters:
	//
	// * Uppercase and lowercase letters
	//
	// * Numbers
	//
	// * Special
	// characters -._~:/?#&=,
	StageVariables map[string]string

	noSmithyDocumentSerde
}

// An Availability Zone for the automatic scaling group.
type AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails struct {

	// The name of the Availability Zone.
	Value *string

	noSmithyDocumentSerde
}

// Provides details about an auto scaling group.
type AwsAutoScalingAutoScalingGroupDetails struct {

	// The list of Availability Zones for the automatic scaling group.
	AvailabilityZones []AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails

	// Indicates when the auto scaling group was created. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedTime *string

	// The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it
	// checks the health status of an EC2 instance that has come into service.
	HealthCheckGracePeriod int32

	// The service to use for the health checks.
	HealthCheckType *string

	// The name of the launch configuration.
	LaunchConfigurationName *string

	// The list of load balancers associated with the group.
	LoadBalancerNames []string

	// The mixed instances policy for the automatic scaling group.
	MixedInstancesPolicy *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails

	noSmithyDocumentSerde
}

// The mixed instances policy for the automatic scaling group.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails struct {

	// The instances distribution. The instances distribution specifies the
	// distribution of On-Demand Instances and Spot Instances, the maximum price to pay
	// for Spot Instances, and how the Auto Scaling group allocates instance types to
	// fulfill On-Demand and Spot capacity.
	InstancesDistribution *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails

	// The launch template to use and the instance types (overrides) to use to
	// provision EC2 instances to fulfill On-Demand and Spot capacities.
	LaunchTemplate *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails

	noSmithyDocumentSerde
}

// Information about the instances distribution.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails struct {

	// How to allocate instance types to fulfill On-Demand capacity.
	OnDemandAllocationStrategy *string

	// The minimum amount of the Auto Scaling group's capacity that must be fulfilled
	// by On-Demand Instances.
	OnDemandBaseCapacity int32

	// The percentage of On-Demand Instances and Spot Instances for additional capacity
	// beyond OnDemandBaseCapacity.
	OnDemandPercentageAboveBaseCapacity int32

	// How to allocate instances across Spot Instance pools.
	SpotAllocationStrategy *string

	// The number of Spot Instance pools across which to allocate your Spot Instances.
	SpotInstancePools int32

	// The maximum price per unit hour that you are willing to pay for a Spot Instance.
	SpotMaxPrice *string

	noSmithyDocumentSerde
}

// Describes a launch template and overrides for a mixed instances policy.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails struct {

	// The launch template to use.
	LaunchTemplateSpecification *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification

	// Property values to use to override the values in the launch template.
	Overrides []AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails

	noSmithyDocumentSerde
}

// Details about the launch template to use.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification struct {

	// The identifier of the launch template. You must specify either LaunchTemplateId
	// or LaunchTemplateName.
	LaunchTemplateId *string

	// The name of the launch template. You must specify either LaunchTemplateId or
	// LaunchTemplateName.
	LaunchTemplateName *string

	// Identifies the version of the launch template. You can specify a version
	// identifier, or use the values $Latest or $Default.
	Version *string

	noSmithyDocumentSerde
}

// Property values to use to override the values in the launch template.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails struct {

	// The instance type. For example, m3.xlarge.
	InstanceType *string

	// The number of capacity units provided by the specified instance type in terms of
	// virtual CPUs, memory, storage, throughput, or other relative performance
	// characteristic.
	WeightedCapacity *string

	noSmithyDocumentSerde
}

// A block device for the instance.
type AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails struct {

	// The device name that is exposed to the EC2 instance. For example, /dev/sdh or
	// xvdh.
	DeviceName *string

	// Parameters that are used to automatically set up Amazon EBS volumes when an
	// instance is launched.
	Ebs *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails

	// Whether to suppress the device that is included in the block device mapping of
	// the Amazon Machine Image (AMI). If NoDevice is true, then you cannot specify
	// Ebs.>
	NoDevice bool

	// The name of the virtual device (for example, ephemeral0). You can provide either
	// VirtualName or Ebs, but not both.
	VirtualName *string

	noSmithyDocumentSerde
}

// Parameters that are used to automatically set up EBS volumes when an instance is
// launched.
type AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails struct {

	// Whether to delete the volume when the instance is terminated.
	DeleteOnTermination bool

	// Whether to encrypt the volume.
	Encrypted bool

	// The number of input/output (I/O) operations per second (IOPS) to provision for
	// the volume. Only supported for gp3 or io1 volumes. Required for io1 volumes. Not
	// used with standard, gp2, st1, or sc1 volumes.
	Iops int32

	// The snapshot ID of the volume to use. You must specify either VolumeSize or
	// SnapshotId.
	SnapshotId *string

	// The volume size, in GiBs. The following are the supported volumes sizes for each
	// volume type:
	//
	// * gp2 and gp3: 1-16,384
	//
	// * io1: 4-16,384
	//
	// * st1 and sc1:
	// 125-16,384
	//
	// * standard: 1-1,024
	//
	// You must specify either SnapshotId or
	// VolumeSize. If you specify both SnapshotId and VolumeSize, the volume size must
	// be equal or greater than the size of the snapshot.
	VolumeSize int32

	// The volume type.
	VolumeType *string

	noSmithyDocumentSerde
}

// Details about a launch configuration.
type AwsAutoScalingLaunchConfigurationDetails struct {

	// For Auto Scaling groups that run in a VPC, specifies whether to assign a public
	// IP address to the group's instances.
	AssociatePublicIpAddress bool

	// Specifies the block devices for the instance.
	BlockDeviceMappings []AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails

	// The identifier of a ClassicLink-enabled VPC that EC2-Classic instances are
	// linked to.
	ClassicLinkVpcId *string

	// The identifiers of one or more security groups for the VPC that is specified in
	// ClassicLinkVPCId.
	ClassicLinkVpcSecurityGroups []string

	// The creation date and time for the launch configuration. Uses the date-time
	// format specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedTime *string

	// Whether the launch configuration is optimized for Amazon EBS I/O.
	EbsOptimized bool

	// The name or the ARN of the instance profile associated with the IAM role for the
	// instance. The instance profile contains the IAM role.
	IamInstanceProfile *string

	// The identifier of the Amazon Machine Image (AMI) that is used to launch EC2
	// instances.
	ImageId *string

	// Indicates the type of monitoring for instances in the group.
	InstanceMonitoring *AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails

	// The instance type for the instances.
	InstanceType *string

	// The identifier of the kernel associated with the AMI.
	KernelId *string

	// The name of the key pair.
	KeyName *string

	// The name of the launch configuration.
	LaunchConfigurationName *string

	// The metadata options for the instances.
	MetadataOptions *AwsAutoScalingLaunchConfigurationMetadataOptions

	// The tenancy of the instance. An instance with dedicated tenancy runs on
	// isolated, single-tenant hardware and can only be launched into a VPC.
	PlacementTenancy *string

	// The identifier of the RAM disk associated with the AMI.
	RamdiskId *string

	// The security groups to assign to the instances in the Auto Scaling group.
	SecurityGroups []string

	// The maximum hourly price to be paid for any Spot Instance that is launched to
	// fulfill the request.
	SpotPrice *string

	// The user data to make available to the launched EC2 instances. Must be
	// base64-encoded text.
	UserData *string

	noSmithyDocumentSerde
}

// Information about the type of monitoring for instances in the group.
type AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails struct {

	// If set to true, then instances in the group launch with detailed monitoring. If
	// set to false, then instances in the group launch with basic monitoring.
	Enabled bool

	noSmithyDocumentSerde
}

// The metadata options for the instances.
type AwsAutoScalingLaunchConfigurationMetadataOptions struct {

	// Enables or disables the HTTP metadata endpoint on your instances. By default,
	// the metadata endpoint is enabled.
	HttpEndpoint *string

	// The HTTP PUT response hop limit for instance metadata requests. The larger the
	// number, the further instance metadata requests can travel.
	HttpPutResponseHopLimit int32

	// Indicates whether token usage is required or optional for metadata requests. By
	// default, token usage is optional.
	HttpTokens *string

	noSmithyDocumentSerde
}

// Provides details about an Certificate Manager certificate.
type AwsCertificateManagerCertificateDetails struct {

	// The ARN of the private certificate authority (CA) that will be used to issue the
	// certificate.
	CertificateAuthorityArn *string

	// Indicates when the certificate was requested. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedAt *string

	// The fully qualified domain name (FQDN), such as www.example.com, that is secured
	// by the certificate.
	DomainName *string

	// Contains information about the initial validation of each domain name that
	// occurs as a result of the RequestCertificate request. Only provided if the
	// certificate type is AMAZON_ISSUED.
	DomainValidationOptions []AwsCertificateManagerCertificateDomainValidationOption

	// Contains a list of Extended Key Usage X.509 v3 extension objects. Each object
	// specifies a purpose for which the certificate public key can be used and
	// consists of a name and an object identifier (OID).
	ExtendedKeyUsages []AwsCertificateManagerCertificateExtendedKeyUsage

	// For a failed certificate request, the reason for the failure. Valid values:
	// NO_AVAILABLE_CONTACTS | ADDITIONAL_VERIFICATION_REQUIRED | DOMAIN_NOT_ALLOWED |
	// INVALID_PUBLIC_DOMAIN | DOMAIN_VALIDATION_DENIED | CAA_ERROR |
	// PCA_LIMIT_EXCEEDED | PCA_INVALID_ARN | PCA_INVALID_STATE | PCA_REQUEST_FAILED |
	// PCA_NAME_CONSTRAINTS_VALIDATION | PCA_RESOURCE_NOT_FOUND | PCA_INVALID_ARGS |
	// PCA_INVALID_DURATION | PCA_ACCESS_DENIED | SLR_NOT_FOUND | OTHER
	FailureReason *string

	// Indicates when the certificate was imported. Provided if the certificate type is
	// IMPORTED. Uses the date-time format specified in RFC 3339 section 5.6, Internet
	// Date/Time Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value
	// cannot contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ImportedAt *string

	// The list of ARNs for the Amazon Web Services resources that use the certificate.
	InUseBy []string

	// Indicates when the certificate was issued. Provided if the certificate type is
	// AMAZON_ISSUED. Uses the date-time format specified in RFC 3339 section 5.6,
	// Internet Date/Time Format (https://tools.ietf.org/html/rfc3339#section-5.6). The
	// value cannot contain spaces. For example, 2020-03-22T13:22:13.933Z.
	IssuedAt *string

	// The name of the certificate authority that issued and signed the certificate.
	Issuer *string

	// The algorithm that was used to generate the public-private key pair. Valid
	// values: RSA_2048 | RSA_1024 | RSA_4096 | EC_prime256v1 | EC_secp384r1 |
	// EC_secp521r1
	KeyAlgorithm *string

	// A list of key usage X.509 v3 extension objects.
	KeyUsages []AwsCertificateManagerCertificateKeyUsage

	// The time after which the certificate becomes invalid. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	NotAfter *string

	// The time before which the certificate is not valid. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	NotBefore *string

	// Provides a value that specifies whether to add the certificate to a transparency
	// log.
	Options *AwsCertificateManagerCertificateOptions

	// Whether the certificate is eligible for renewal. Valid values: ELIGIBLE |
	// INELIGIBLE
	RenewalEligibility *string

	// Information about the status of the Certificate Manager managed renewal for the
	// certificate. Provided only when the certificate type is AMAZON_ISSUED.
	RenewalSummary *AwsCertificateManagerCertificateRenewalSummary

	// The serial number of the certificate.
	Serial *string

	// The algorithm that was used to sign the certificate.
	SignatureAlgorithm *string

	// The status of the certificate. Valid values: PENDING_VALIDATION | ISSUED |
	// INACTIVE | EXPIRED | VALIDATION_TIMED_OUT | REVOKED | FAILED
	Status *string

	// The name of the entity that is associated with the public key contained in the
	// certificate.
	Subject *string

	// One or more domain names (subject alternative names) included in the
	// certificate. This list contains the domain names that are bound to the public
	// key that is contained in the certificate. The subject alternative names include
	// the canonical domain name (CN) of the certificate and additional domain names
	// that can be used to connect to the website.
	SubjectAlternativeNames []string

	// The source of the certificate. For certificates that Certificate Manager
	// provides, Type is AMAZON_ISSUED. For certificates that are imported with
	// ImportCertificate, Type is IMPORTED. Valid values: IMPORTED | AMAZON_ISSUED |
	// PRIVATE
	Type *string

	noSmithyDocumentSerde
}

// Contains information about one of the following:
//
// * The initial validation of
// each domain name that occurs as a result of the RequestCertificate request
//
// *
// The validation of each domain name in the certificate, as it pertains to
// Certificate Manager managed renewal
type AwsCertificateManagerCertificateDomainValidationOption struct {

	// A fully qualified domain name (FQDN) in the certificate.
	DomainName *string

	// The CNAME record that is added to the DNS database for domain validation.
	ResourceRecord *AwsCertificateManagerCertificateResourceRecord

	// The domain name that Certificate Manager uses to send domain validation emails.
	ValidationDomain *string

	// A list of email addresses that Certificate Manager uses to send domain
	// validation emails.
	ValidationEmails []string

	// The method used to validate the domain name.
	ValidationMethod *string

	// The validation status of the domain name.
	ValidationStatus *string

	noSmithyDocumentSerde
}

// Contains information about an extended key usage X.509 v3 extension object.
type AwsCertificateManagerCertificateExtendedKeyUsage struct {

	// The name of an extension value. Indicates the purpose for which the certificate
	// public key can be used.
	Name *string

	// An object identifier (OID) for the extension value. The format is numbers
	// separated by periods.
	OId *string

	noSmithyDocumentSerde
}

// Contains information about a key usage X.509 v3 extension object.
type AwsCertificateManagerCertificateKeyUsage struct {

	// The key usage extension name.
	Name *string

	noSmithyDocumentSerde
}

// Contains other options for the certificate.
type AwsCertificateManagerCertificateOptions struct {

	// Whether to add the certificate to a transparency log. Valid values: DISABLED |
	// ENABLED
	CertificateTransparencyLoggingPreference *string

	noSmithyDocumentSerde
}

// Contains information about the Certificate Manager managed renewal for an
// AMAZON_ISSUED certificate.
type AwsCertificateManagerCertificateRenewalSummary struct {

	// Information about the validation of each domain name in the certificate, as it
	// pertains to Certificate Manager managed renewal. Provided only when the
	// certificate type is AMAZON_ISSUED.
	DomainValidationOptions []AwsCertificateManagerCertificateDomainValidationOption

	// The status of the Certificate Manager managed renewal of the certificate. Valid
	// values: PENDING_AUTO_RENEWAL | PENDING_VALIDATION | SUCCESS | FAILED
	RenewalStatus *string

	// The reason that a renewal request was unsuccessful. Valid values:
	// NO_AVAILABLE_CONTACTS | ADDITIONAL_VERIFICATION_REQUIRED | DOMAIN_NOT_ALLOWED |
	// INVALID_PUBLIC_DOMAIN | DOMAIN_VALIDATION_DENIED | CAA_ERROR |
	// PCA_LIMIT_EXCEEDED | PCA_INVALID_ARN | PCA_INVALID_STATE | PCA_REQUEST_FAILED |
	// PCA_NAME_CONSTRAINTS_VALIDATION | PCA_RESOURCE_NOT_FOUND | PCA_INVALID_ARGS |
	// PCA_INVALID_DURATION | PCA_ACCESS_DENIED | SLR_NOT_FOUND | OTHER
	RenewalStatusReason *string

	// Indicates when the renewal summary was last updated. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	UpdatedAt *string

	noSmithyDocumentSerde
}

// Provides details about the CNAME record that is added to the DNS database for
// domain validation.
type AwsCertificateManagerCertificateResourceRecord struct {

	// The name of the resource.
	Name *string

	// The type of resource.
	Type *string

	// The value of the resource.
	Value *string

	noSmithyDocumentSerde
}

// Information about a cache behavior for the distribution.
type AwsCloudFrontDistributionCacheBehavior struct {

	// The protocol that viewers can use to access the files in an origin. You can
	// specify the following options:
	//
	// * allow-all - Viewers can use HTTP or HTTPS.
	//
	// *
	// redirect-to-https - CloudFront responds to HTTP requests with an HTTP status
	// code of 301 (Moved Permanently) and the HTTPS URL. The viewer then uses the new
	// URL to resubmit.
	//
	// * https-only - CloudFront responds to HTTP request with an
	// HTTP status code of 403 (Forbidden).
	ViewerProtocolPolicy *string

	noSmithyDocumentSerde
}

// Provides information about caching for the distribution.
type AwsCloudFrontDistributionCacheBehaviors struct {

	// The cache behaviors for the distribution.
	Items []AwsCloudFrontDistributionCacheBehavior

	noSmithyDocumentSerde
}

// Contains information about the default cache configuration for the distribution.
type AwsCloudFrontDistributionDefaultCacheBehavior struct {

	// The protocol that viewers can use to access the files in an origin. You can
	// specify the following options:
	//
	// * allow-all - Viewers can use HTTP or HTTPS.
	//
	// *
	// redirect-to-https - CloudFront responds to HTTP requests with an HTTP status
	// code of 301 (Moved Permanently) and the HTTPS URL. The viewer then uses the new
	// URL to resubmit.
	//
	// * https-only - CloudFront responds to HTTP request with an
	// HTTP status code of 403 (Forbidden).
	ViewerProtocolPolicy *string

	noSmithyDocumentSerde
}

// A distribution configuration.
type AwsCloudFrontDistributionDetails struct {

	// Provides information about the cache configuration for the distribution.
	CacheBehaviors *AwsCloudFrontDistributionCacheBehaviors

	// The default cache behavior for the configuration.
	DefaultCacheBehavior *AwsCloudFrontDistributionDefaultCacheBehavior

	// The object that CloudFront sends in response to requests from the origin (for
	// example, index.html) when a viewer requests the root URL for the distribution
	// (http://www.example.com) instead of an object in your distribution
	// (http://www.example.com/product-description.html).
	DefaultRootObject *string

	// The domain name corresponding to the distribution.
	DomainName *string

	// The entity tag is a hash of the object.
	ETag *string

	// Indicates when that the distribution was last modified. Uses the date-time
	// format specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	LastModifiedTime *string

	// A complex type that controls whether access logs are written for the
	// distribution.
	Logging *AwsCloudFrontDistributionLogging

	// Provides information about the origin groups in the distribution.
	OriginGroups *AwsCloudFrontDistributionOriginGroups

	// A complex type that contains information about origins for this distribution.
	Origins *AwsCloudFrontDistributionOrigins

	// Indicates the current status of the distribution.
	Status *string

	// Provides information about the TLS/SSL configuration that the distribution uses
	// to communicate with viewers.
	ViewerCertificate *AwsCloudFrontDistributionViewerCertificate

	// A unique identifier that specifies the WAF web ACL, if any, to associate with
	// this distribution.
	WebAclId *string

	noSmithyDocumentSerde
}

// A complex type that controls whether access logs are written for the
// distribution.
type AwsCloudFrontDistributionLogging struct {

	// The S3 bucket to store the access logs in.
	Bucket *string

	// With this field, you can enable or disable the selected distribution.
	Enabled bool

	// Specifies whether you want CloudFront to include cookies in access logs.
	IncludeCookies bool

	// An optional string that you want CloudFront to use as a prefix to the access log
	// filenames for this distribution.
	Prefix *string

	noSmithyDocumentSerde
}

// Information about an origin group for the distribution.
type AwsCloudFrontDistributionOriginGroup struct {

	// Provides the criteria for an origin group to fail over.
	FailoverCriteria *AwsCloudFrontDistributionOriginGroupFailover

	noSmithyDocumentSerde
}

// Provides information about when an origin group fails over.
type AwsCloudFrontDistributionOriginGroupFailover struct {

	// Information about the status codes that cause an origin group to fail over.
	StatusCodes *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes

	noSmithyDocumentSerde
}

// The status codes that cause an origin group to fail over.
type AwsCloudFrontDistributionOriginGroupFailoverStatusCodes struct {

	// The list of status code values that can cause a failover to the next origin.
	Items []int32

	// The number of status codes that can cause a failover.
	Quantity int32

	noSmithyDocumentSerde
}

// Provides information about origin groups that are associated with the
// distribution.
type AwsCloudFrontDistributionOriginGroups struct {

	// The list of origin groups.
	Items []AwsCloudFrontDistributionOriginGroup

	noSmithyDocumentSerde
}

// A complex type that describes the S3 bucket, HTTP server (for example, a web
// server), AWS Elemental MediaStore, or other server from which CloudFront gets
// your files.
type AwsCloudFrontDistributionOriginItem struct {

	// Amazon S3 origins: The DNS name of the S3 bucket from which you want CloudFront
	// to get objects for this origin.
	DomainName *string

	// A unique identifier for the origin or origin group.
	Id *string

	// An optional element that causes CloudFront to request your content from a
	// directory in your Amazon S3 bucket or your custom origin.
	OriginPath *string

	// An origin that is an S3 bucket that is not configured with static website
	// hosting.
	S3OriginConfig *AwsCloudFrontDistributionOriginS3OriginConfig

	noSmithyDocumentSerde
}

// A complex type that contains information about origins and origin groups for
// this distribution.
type AwsCloudFrontDistributionOrigins struct {

	// A complex type that contains origins or origin groups for this distribution.
	Items []AwsCloudFrontDistributionOriginItem

	noSmithyDocumentSerde
}

// Information about an origin that is an S3 bucket that is not configured with
// static website hosting.
type AwsCloudFrontDistributionOriginS3OriginConfig struct {

	// The CloudFront origin access identity to associate with the origin.
	OriginAccessIdentity *string

	noSmithyDocumentSerde
}

// Provides information about the TLS/SSL configuration that the distribution uses
// to communicate with viewers.
type AwsCloudFrontDistributionViewerCertificate struct {

	// The ARN of the ACM certificate. Used if the certificate is stored in ACM. If you
	// provide an ACM certificate ARN, you must also provide MinimumCertificateVersion
	// and SslSupportMethod.
	AcmCertificateArn *string

	// The identifier of the certificate. Note that in CloudFront, this attribute is
	// deprecated.
	Certificate *string

	// The source of the certificate identified by Certificate. Note that in
	// CloudFront, this attribute is deprecated.
	CertificateSource *string

	// Whether the distribution uses the CloudFront domain name. If set to false, then
	// you provide either AcmCertificateArn or IamCertificateId.
	CloudFrontDefaultCertificate bool

	// The identifier of the IAM certificate. Used if the certificate is stored in IAM.
	// If you provide IamCertificateId, then you also must provide
	// MinimumProtocolVersion and SslSupportMethod.
	IamCertificateId *string

	// The security policy that CloudFront uses for HTTPS connections with viewers. If
	// SslSupportMethod is sni-only, then MinimumProtocolVersion must be TLSv1 or
	// higher.
	MinimumProtocolVersion *string

	// The viewers that the distribution accepts HTTPS connections from.
	SslSupportMethod *string

	noSmithyDocumentSerde
}

// Provides details about a CloudTrail trail.
type AwsCloudTrailTrailDetails struct {

	// The ARN of the log group that CloudTrail logs are delivered to.
	CloudWatchLogsLogGroupArn *string

	// The ARN of the role that the CloudWatch Events endpoint assumes when it writes
	// to the log group.
	CloudWatchLogsRoleArn *string

	// Indicates whether the trail has custom event selectors.
	HasCustomEventSelectors bool

	// The Region where the trail was created.
	HomeRegion *string

	// Indicates whether the trail publishes events from global services such as IAM to
	// the log files.
	IncludeGlobalServiceEvents bool

	// Indicates whether the trail applies only to the current Region or to all
	// Regions.
	IsMultiRegionTrail bool

	// Whether the trail is created for all accounts in an organization in
	// Organizations, or only for the current Amazon Web Services account.
	IsOrganizationTrail bool

	// The KMS key ID to use to encrypt the logs.
	KmsKeyId *string

	// Indicates whether CloudTrail log file validation is enabled.
	LogFileValidationEnabled bool

	// The name of the trail.
	Name *string

	// The name of the S3 bucket where the log files are published.
	S3BucketName *string

	// The S3 key prefix. The key prefix is added after the name of the S3 bucket where
	// the log files are published.
	S3KeyPrefix *string

	// The ARN of the SNS topic that is used for notifications of log file delivery.
	SnsTopicArn *string

	// The name of the SNS topic that is used for notifications of log file delivery.
	SnsTopicName *string

	// The ARN of the trail.
	TrailArn *string

	noSmithyDocumentSerde
}

// Information about the build artifacts for the CodeBuild project.
type AwsCodeBuildProjectArtifactsDetails struct {

	// An identifier for the artifact definition.
	ArtifactIdentifier *string

	// Indicates whether to disable encryption on the artifact. Only valid when Type is
	// S3.
	EncryptionDisabled bool

	// Only used when Type is S3. The name of the S3 bucket where the artifact is
	// located.
	Location *string

	// Only used when Type is S3. The name of the artifact. Used with NamepaceType and
	// Path to determine the pattern for storing the artifact.
	Name *string

	// Only used when Type is S3. The value to use for the namespace. Used with Name
	// and Path to determine the pattern for storing the artifact.
	NamespaceType *string

	// Whether the name specified in the buildspec file overrides the artifact name.
	OverrideArtifactName bool

	// Only used when Type is S3. The type of output artifact to create.
	Packaging *string

	// Only used when Type is S3. The path to the artifact. Used with Name and
	// NamespaceType to determine the pattern for storing the artifact.
	Path *string

	// The type of build artifact.
	Type *string

	noSmithyDocumentSerde
}

// Information about an CodeBuild project.
type AwsCodeBuildProjectDetails struct {

	// Information about the build artifacts for the CodeBuild project.
	Artifacts []AwsCodeBuildProjectArtifactsDetails

	// The KMS key used to encrypt the build output artifacts. You can specify either
	// the ARN of the KMS key or, if available, the KMS key alias (using the format
	// alias/alias-name).
	EncryptionKey *string

	// Information about the build environment for this build project.
	Environment *AwsCodeBuildProjectEnvironment

	// Information about logs for the build project.
	LogsConfig *AwsCodeBuildProjectLogsConfigDetails

	// The name of the build project.
	Name *string

	// The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon
	// Web Services services on behalf of the Amazon Web Services account.
	ServiceRole *string

	// Information about the build input source code for this build project.
	Source *AwsCodeBuildProjectSource

	// Information about the VPC configuration that CodeBuild accesses.
	VpcConfig *AwsCodeBuildProjectVpcConfig

	noSmithyDocumentSerde
}

// Information about the build environment for this build project.
type AwsCodeBuildProjectEnvironment struct {

	// The certificate to use with this build project.
	Certificate *string

	// A set of environment variables to make available to builds for the build
	// project.
	EnvironmentVariables []AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails

	// The type of credentials CodeBuild uses to pull images in your build. Valid
	// values:
	//
	// * CODEBUILD specifies that CodeBuild uses its own credentials. This
	// requires that you modify your ECR repository policy to trust the CodeBuild
	// service principal.
	//
	// * SERVICE_ROLE specifies that CodeBuild uses your build
	// project's service role.
	//
	// When you use a cross-account or private registry image,
	// you must use SERVICE_ROLE credentials. When you use an CodeBuild curated image,
	// you must use CODEBUILD credentials.
	ImagePullCredentialsType *string

	// Whether to allow the Docker daemon to run inside a Docker container. Set to true
	// if the build project is used to build Docker images.
	PrivilegedMode bool

	// The credentials for access to a private registry.
	RegistryCredential *AwsCodeBuildProjectEnvironmentRegistryCredential

	// The type of build environment to use for related builds. The environment type
	// ARM_CONTAINER is available only in Regions US East (N. Virginia), US East
	// (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific (Mumbai), Asia Pacific
	// (Tokyo), Asia Pacific (Sydney), and Europe (Frankfurt). The environment type
	// LINUX_CONTAINER with compute type build.general1.2xlarge is available only in
	// Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada
	// (Central), Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific
	// (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney),
	// China (Beijing), and China (Ningxia). The environment type LINUX_GPU_CONTAINER
	// is available only in Regions US East (N. Virginia), US East (N. Virginia), US
	// West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe
	// (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific
	// (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia). Valid
	// values: WINDOWS_CONTAINER | LINUX_CONTAINER | LINUX_GPU_CONTAINER |
	// ARM_CONTAINER
	Type *string

	noSmithyDocumentSerde
}

// Information about an environment variable that is available to builds for the
// build project.
type AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails struct {

	// The name of the environment variable.
	Name *string

	// The type of environment variable.
	Type *string

	// The value of the environment variable.
	Value *string

	noSmithyDocumentSerde
}

// The credentials for access to a private registry.
type AwsCodeBuildProjectEnvironmentRegistryCredential struct {

	// The ARN or name of credentials created using Secrets Manager. The credential can
	// use the name of the credentials only if they exist in your current Amazon Web
	// Services Region.
	Credential *string

	// The service that created the credentials to access a private Docker registry.
	// The valid value, SECRETS_MANAGER, is for Secrets Manager.
	CredentialProvider *string

	noSmithyDocumentSerde
}

// Information about CloudWatch Logs for the build project.
type AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails struct {

	// The group name of the logs in CloudWatch Logs.
	GroupName *string

	// The current status of the logs in CloudWatch Logs for a build project.
	Status *string

	// The prefix of the stream name of the CloudWatch Logs.
	StreamName *string

	noSmithyDocumentSerde
}

// Information about logs for the build project.
type AwsCodeBuildProjectLogsConfigDetails struct {

	// Information about CloudWatch Logs for the build project.
	CloudWatchLogs *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails

	// Information about logs built to an S3 bucket for a build project.
	S3Logs *AwsCodeBuildProjectLogsConfigS3LogsDetails

	noSmithyDocumentSerde
}

// Information about logs built to an S3 bucket for a build project.
type AwsCodeBuildProjectLogsConfigS3LogsDetails struct {

	// Whether to disable encryption of the S3 build log output.
	EncryptionDisabled bool

	// The ARN of the S3 bucket and the path prefix for S3 logs.
	Location *string

	// The current status of the S3 build logs.
	Status *string

	noSmithyDocumentSerde
}

// Information about the build input source code for this build project.
type AwsCodeBuildProjectSource struct {

	// Information about the Git clone depth for the build project.
	GitCloneDepth int32

	// Whether to ignore SSL warnings while connecting to the project source code.
	InsecureSsl bool

	// Information about the location of the source code to be built. Valid values
	// include:
	//
	// * For source code settings that are specified in the source action of
	// a pipeline in CodePipeline, location should not be specified. If it is
	// specified, CodePipeline ignores it. This is because CodePipeline uses the
	// settings in a pipeline's source action instead of this value.
	//
	// * For source code
	// in an CodeCommit repository, the HTTPS clone URL to the repository that contains
	// the source code and the build spec file (for example,
	// https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name ).
	//
	// * For
	// source code in an S3 input bucket, one of the following.
	//
	// * The path to the ZIP
	// file that contains the source code (for example,
	// bucket-name/path/to/object-name.zip).
	//
	// * The path to the folder that contains
	// the source code (for example, bucket-name/path/to/source-code/folder/).
	//
	// * For
	// source code in a GitHub repository, the HTTPS clone URL to the repository that
	// contains the source and the build spec file.
	//
	// * For source code in a Bitbucket
	// repository, the HTTPS clone URL to the repository that contains the source and
	// the build spec file.
	Location *string

	// The type of repository that contains the source code to be built. Valid values
	// are:
	//
	// * BITBUCKET - The source code is in a Bitbucket repository.
	//
	// * CODECOMMIT
	// - The source code is in an CodeCommit repository.
	//
	// * CODEPIPELINE - The source
	// code settings are specified in the source action of a pipeline in
	// CodePipeline.
	//
	// * GITHUB - The source code is in a GitHub repository.
	//
	// *
	// GITHUB_ENTERPRISE - The source code is in a GitHub Enterprise repository.
	//
	// *
	// NO_SOURCE - The project does not have input source code.
	//
	// * S3 - The source code
	// is in an S3 input bucket.
	Type *string

	noSmithyDocumentSerde
}

// Information about the VPC configuration that CodeBuild accesses.
type AwsCodeBuildProjectVpcConfig struct {

	// A list of one or more security group IDs in your VPC.
	SecurityGroupIds []string

	// A list of one or more subnet IDs in your VPC.
	Subnets []string

	// The ID of the VPC.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains the cross-origin resource sharing (CORS) configuration for the API.
// CORS is only supported for HTTP APIs.
type AwsCorsConfiguration struct {

	// Indicates whether the CORS request includes credentials.
	AllowCredentials bool

	// The allowed headers for CORS requests.
	AllowHeaders []string

	// The allowed methods for CORS requests.
	AllowMethods []string

	// The allowed origins for CORS requests.
	AllowOrigins []string

	// The exposed headers for CORS requests.
	ExposeHeaders []string

	// The number of seconds for which the browser caches preflight request results.
	MaxAge int32

	noSmithyDocumentSerde
}

// Contains a definition of an attribute for the table.
type AwsDynamoDbTableAttributeDefinition struct {

	// The name of the attribute.
	AttributeName *string

	// The type of the attribute.
	AttributeType *string

	noSmithyDocumentSerde
}

// Provides information about the billing for read/write capacity on the table.
type AwsDynamoDbTableBillingModeSummary struct {

	// The method used to charge for read and write throughput and to manage capacity.
	BillingMode *string

	// If the billing mode is PAY_PER_REQUEST, indicates when the billing mode was set
	// to that value. Uses the date-time format specified in RFC 3339 section 5.6,
	// Internet Date/Time Format (https://tools.ietf.org/html/rfc3339#section-5.6). The
	// value cannot contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastUpdateToPayPerRequestDateTime *string

	noSmithyDocumentSerde
}

// Provides details about a DynamoDB table.
type AwsDynamoDbTableDetails struct {

	// A list of attribute definitions for the table.
	AttributeDefinitions []AwsDynamoDbTableAttributeDefinition

	// Information about the billing for read/write capacity on the table.
	BillingModeSummary *AwsDynamoDbTableBillingModeSummary

	// Indicates when the table was created. Uses the date-time format specified in RFC
	// 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreationDateTime *string

	// List of global secondary indexes for the table.
	GlobalSecondaryIndexes []AwsDynamoDbTableGlobalSecondaryIndex

	// The version of global tables being used.
	GlobalTableVersion *string

	// The number of items in the table.
	ItemCount int32

	// The primary key structure for the table.
	KeySchema []AwsDynamoDbTableKeySchema

	// The ARN of the latest stream for the table.
	LatestStreamArn *string

	// The label of the latest stream. The label is not a unique identifier.
	LatestStreamLabel *string

	// The list of local secondary indexes for the table.
	LocalSecondaryIndexes []AwsDynamoDbTableLocalSecondaryIndex

	// Information about the provisioned throughput for the table.
	ProvisionedThroughput *AwsDynamoDbTableProvisionedThroughput

	// The list of replicas of this table.
	Replicas []AwsDynamoDbTableReplica

	// Information about the restore for the table.
	RestoreSummary *AwsDynamoDbTableRestoreSummary

	// Information about the server-side encryption for the table.
	SseDescription *AwsDynamoDbTableSseDescription

	// The current DynamoDB Streams configuration for the table.
	StreamSpecification *AwsDynamoDbTableStreamSpecification

	// The identifier of the table.
	TableId *string

	// The name of the table.
	TableName *string

	// The total size of the table in bytes.
	TableSizeBytes int64

	// The current status of the table.
	TableStatus *string

	noSmithyDocumentSerde
}

// Information abut a global secondary index for the table.
type AwsDynamoDbTableGlobalSecondaryIndex struct {

	// Whether the index is currently backfilling.
	Backfilling bool

	// The ARN of the index.
	IndexArn *string

	// The name of the index.
	IndexName *string

	// The total size in bytes of the index.
	IndexSizeBytes int64

	// The current status of the index.
	IndexStatus *string

	// The number of items in the index.
	ItemCount int32

	// The key schema for the index.
	KeySchema []AwsDynamoDbTableKeySchema

	// Attributes that are copied from the table into an index.
	Projection *AwsDynamoDbTableProjection

	// Information about the provisioned throughput settings for the indexes.
	ProvisionedThroughput *AwsDynamoDbTableProvisionedThroughput

	noSmithyDocumentSerde
}

// A component of the key schema for the DynamoDB table, a global secondary index,
// or a local secondary index.
type AwsDynamoDbTableKeySchema struct {

	// The name of the key schema attribute.
	AttributeName *string

	// The type of key used for the key schema attribute.
	KeyType *string

	noSmithyDocumentSerde
}

// Information about a local secondary index for a DynamoDB table.
type AwsDynamoDbTableLocalSecondaryIndex struct {

	// The ARN of the index.
	IndexArn *string

	// The name of the index.
	IndexName *string

	// The complete key schema for the index.
	KeySchema []AwsDynamoDbTableKeySchema

	// Attributes that are copied from the table into the index. These are in addition
	// to the primary key attributes and index key attributes, which are automatically
	// projected.
	Projection *AwsDynamoDbTableProjection

	noSmithyDocumentSerde
}

// For global and local secondary indexes, identifies the attributes that are
// copied from the table into the index.
type AwsDynamoDbTableProjection struct {

	// The nonkey attributes that are projected into the index. For each attribute,
	// provide the attribute name.
	NonKeyAttributes []string

	// The types of attributes that are projected into the index.
	ProjectionType *string

	noSmithyDocumentSerde
}

// Information about the provisioned throughput for the table or for a global
// secondary index.
type AwsDynamoDbTableProvisionedThroughput struct {

	// Indicates when the provisioned throughput was last decreased. Uses the date-time
	// format specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	LastDecreaseDateTime *string

	// Indicates when the provisioned throughput was last increased. Uses the date-time
	// format specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	LastIncreaseDateTime *string

	// The number of times during the current UTC calendar day that the provisioned
	// throughput was decreased.
	NumberOfDecreasesToday int32

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException.
	ReadCapacityUnits int32

	// The maximum number of writes consumed per second before DynamoDB returns a
	// ThrottlingException.
	WriteCapacityUnits int32

	noSmithyDocumentSerde
}

// Replica-specific configuration for the provisioned throughput.
type AwsDynamoDbTableProvisionedThroughputOverride struct {

	// The read capacity units for the replica.
	ReadCapacityUnits int32

	noSmithyDocumentSerde
}

// Information about a replica of a DynamoDB table.
type AwsDynamoDbTableReplica struct {

	// List of global secondary indexes for the replica.
	GlobalSecondaryIndexes []AwsDynamoDbTableReplicaGlobalSecondaryIndex

	// The identifier of the KMS key that will be used for KMS encryption for the
	// replica.
	KmsMasterKeyId *string

	// Replica-specific configuration for the provisioned throughput.
	ProvisionedThroughputOverride *AwsDynamoDbTableProvisionedThroughputOverride

	// The name of the Region where the replica is located.
	RegionName *string

	// The current status of the replica.
	ReplicaStatus *string

	// Detailed information about the replica status.
	ReplicaStatusDescription *string

	noSmithyDocumentSerde
}

// Information about a global secondary index for a DynamoDB table replica.
type AwsDynamoDbTableReplicaGlobalSecondaryIndex struct {

	// The name of the index.
	IndexName *string

	// Replica-specific configuration for the provisioned throughput for the index.
	ProvisionedThroughputOverride *AwsDynamoDbTableProvisionedThroughputOverride

	noSmithyDocumentSerde
}

// Information about the restore for the table.
type AwsDynamoDbTableRestoreSummary struct {

	// Indicates the point in time that the table was restored to. Uses the date-time
	// format specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	RestoreDateTime *string

	// Whether a restore is currently in progress.
	RestoreInProgress bool

	// The ARN of the source backup from which the table was restored.
	SourceBackupArn *string

	// The ARN of the source table for the backup.
	SourceTableArn *string

	noSmithyDocumentSerde
}

// Information about the server-side encryption for the table.
type AwsDynamoDbTableSseDescription struct {

	// If the key is inaccessible, the date and time when DynamoDB detected that the
	// key was inaccessible. Uses the date-time format specified in RFC 3339 section
	// 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	InaccessibleEncryptionDateTime *string

	// The ARN of the KMS key that is used for the KMS encryption.
	KmsMasterKeyArn *string

	// The type of server-side encryption.
	SseType *string

	// The status of the server-side encryption.
	Status *string

	noSmithyDocumentSerde
}

// The current DynamoDB Streams configuration for the table.
type AwsDynamoDbTableStreamSpecification struct {

	// Indicates whether DynamoDB Streams is enabled on the table.
	StreamEnabled bool

	// Determines the information that is written to the table.
	StreamViewType *string

	noSmithyDocumentSerde
}

// Information about an Elastic IP address.
type AwsEc2EipDetails struct {

	// The identifier that Amazon Web Services assigns to represent the allocation of
	// the Elastic IP address for use with Amazon VPC.
	AllocationId *string

	// The identifier that represents the association of the Elastic IP address with an
	// EC2 instance.
	AssociationId *string

	// The domain in which to allocate the address. If the address is for use with EC2
	// instances in a VPC, then Domain is vpc. Otherwise, Domain is standard.
	Domain *string

	// The identifier of the EC2 instance.
	InstanceId *string

	// The name of the location from which the Elastic IP address is advertised.
	NetworkBorderGroup *string

	// The identifier of the network interface.
	NetworkInterfaceId *string

	// The Amazon Web Services account ID of the owner of the network interface.
	NetworkInterfaceOwnerId *string

	// The private IP address that is associated with the Elastic IP address.
	PrivateIpAddress *string

	// A public IP address that is associated with the EC2 instance.
	PublicIp *string

	// The identifier of an IP address pool. This parameter allows Amazon EC2 to select
	// an IP address from the address pool.
	PublicIpv4Pool *string

	noSmithyDocumentSerde
}

// The details of an EC2 instance.
type AwsEc2InstanceDetails struct {

	// The IAM profile ARN of the instance.
	IamInstanceProfileArn *string

	// The Amazon Machine Image (AMI) ID of the instance.
	ImageId *string

	// The IPv4 addresses associated with the instance.
	IpV4Addresses []string

	// The IPv6 addresses associated with the instance.
	IpV6Addresses []string

	// The key name associated with the instance.
	KeyName *string

	// Indicates when the instance was launched. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	LaunchedAt *string

	// The identifiers of the network interfaces for the EC2 instance. The details for
	// each network interface are in a corresponding AwsEc2NetworkInterfacesDetails
	// object.
	NetworkInterfaces []AwsEc2InstanceNetworkInterfacesDetails

	// The identifier of the subnet that the instance was launched in.
	SubnetId *string

	// The instance type of the instance.
	Type *string

	// The identifier of the VPC that the instance was launched in.
	VpcId *string

	noSmithyDocumentSerde
}

// Identifies a network interface for the EC2 instance.
type AwsEc2InstanceNetworkInterfacesDetails struct {

	// The identifier of the network interface. The details are in a corresponding
	// AwsEc2NetworkInterfacesDetails object.
	NetworkInterfaceId *string

	noSmithyDocumentSerde
}

// An association between the network ACL and a subnet.
type AwsEc2NetworkAclAssociation struct {

	// The identifier of the association between the network ACL and the subnet.
	NetworkAclAssociationId *string

	// The identifier of the network ACL.
	NetworkAclId *string

	// The identifier of the subnet that is associated with the network ACL.
	SubnetId *string

	noSmithyDocumentSerde
}

// Contains details about an EC2 network access control list (ACL).
type AwsEc2NetworkAclDetails struct {

	// Associations between the network ACL and subnets.
	Associations []AwsEc2NetworkAclAssociation

	// The set of rules in the network ACL.
	Entries []AwsEc2NetworkAclEntry

	// Whether this is the default network ACL for the VPC.
	IsDefault bool

	// The identifier of the network ACL.
	NetworkAclId *string

	// The identifier of the Amazon Web Services account that owns the network ACL.
	OwnerId *string

	// The identifier of the VPC for the network ACL.
	VpcId *string

	noSmithyDocumentSerde
}

// A rule for the network ACL. Each rule allows or denies access based on the IP
// address, traffic direction, port, and protocol.
type AwsEc2NetworkAclEntry struct {

	// The IPV4 network range for which to deny or allow access.
	CidrBlock *string

	// Whether the rule is an egress rule. An egress rule is a rule that applies to
	// traffic that leaves the subnet.
	Egress bool

	// The Internet Control Message Protocol (ICMP) type and code for which to deny or
	// allow access.
	IcmpTypeCode *IcmpTypeCode

	// The IPV6 network range for which to deny or allow access.
	Ipv6CidrBlock *string

	// For TCP or UDP protocols, the range of ports that the rule applies to.
	PortRange *PortRangeFromTo

	// The protocol that the rule applies to. To deny or allow access to all protocols,
	// use the value -1.
	Protocol *string

	// Whether the rule is used to allow access or deny access.
	RuleAction *string

	// The rule number. The rules are processed in order by their number.
	RuleNumber int32

	noSmithyDocumentSerde
}

// Information about the network interface attachment.
type AwsEc2NetworkInterfaceAttachment struct {

	// Indicates when the attachment initiated. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	AttachTime *string

	// The identifier of the network interface attachment
	AttachmentId *string

	// Indicates whether the network interface is deleted when the instance is
	// terminated.
	DeleteOnTermination bool

	// The device index of the network interface attachment on the instance.
	DeviceIndex int32

	// The ID of the instance.
	InstanceId *string

	// The Amazon Web Services account ID of the owner of the instance.
	InstanceOwnerId *string

	// The attachment state. Valid values: attaching | attached | detaching | detached
	Status *string

	noSmithyDocumentSerde
}

// Details about the network interface
type AwsEc2NetworkInterfaceDetails struct {

	// The network interface attachment.
	Attachment *AwsEc2NetworkInterfaceAttachment

	// The IPv6 addresses associated with the network interface.
	IpV6Addresses []AwsEc2NetworkInterfaceIpV6AddressDetail

	// The ID of the network interface.
	NetworkInterfaceId *string

	// The private IPv4 addresses associated with the network interface.
	PrivateIpAddresses []AwsEc2NetworkInterfacePrivateIpAddressDetail

	// The public DNS name of the network interface.
	PublicDnsName *string

	// The address of the Elastic IP address bound to the network interface.
	PublicIp *string

	// Security groups for the network interface.
	SecurityGroups []AwsEc2NetworkInterfaceSecurityGroup

	// Indicates whether traffic to or from the instance is validated.
	SourceDestCheck bool

	noSmithyDocumentSerde
}

// Provides information about an IPV6 address that is associated with the network
// interface.
type AwsEc2NetworkInterfaceIpV6AddressDetail struct {

	// The IPV6 address.
	IpV6Address *string

	noSmithyDocumentSerde
}

// Provides information about a private IPv4 address that is with the network
// interface.
type AwsEc2NetworkInterfacePrivateIpAddressDetail struct {

	// The private DNS name for the IP address.
	PrivateDnsName *string

	// The IP address.
	PrivateIpAddress *string

	noSmithyDocumentSerde
}

// A security group associated with the network interface.
type AwsEc2NetworkInterfaceSecurityGroup struct {

	// The ID of the security group.
	GroupId *string

	// The name of the security group.
	GroupName *string

	noSmithyDocumentSerde
}

// Details about an EC2 security group.
type AwsEc2SecurityGroupDetails struct {

	// The ID of the security group.
	GroupId *string

	// The name of the security group.
	GroupName *string

	// The inbound rules associated with the security group.
	IpPermissions []AwsEc2SecurityGroupIpPermission

	// [VPC only] The outbound rules associated with the security group.
	IpPermissionsEgress []AwsEc2SecurityGroupIpPermission

	// The Amazon Web Services account ID of the owner of the security group.
	OwnerId *string

	// [VPC only] The ID of the VPC for the security group.
	VpcId *string

	noSmithyDocumentSerde
}

// An IP permission for an EC2 security group.
type AwsEc2SecurityGroupIpPermission struct {

	// The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// type number. A value of -1 indicates all ICMP/ICMPv6 types. If you specify all
	// ICMP/ICMPv6 types, you must specify all codes.
	FromPort int32

	// The IP protocol name (tcp, udp, icmp, icmpv6) or number. [VPC only] Use -1 to
	// specify all protocols. When authorizing security group rules, specifying -1 or a
	// protocol number other than tcp, udp, icmp, or icmpv6 allows traffic on all
	// ports, regardless of any port range you specify. For tcp, udp, and icmp, you
	// must specify a port range. For icmpv6, the port range is optional. If you omit
	// the port range, traffic for all types and codes is allowed.
	IpProtocol *string

	// The IPv4 ranges.
	IpRanges []AwsEc2SecurityGroupIpRange

	// The IPv6 ranges.
	Ipv6Ranges []AwsEc2SecurityGroupIpv6Range

	// [VPC only] The prefix list IDs for an Amazon Web Services service. With outbound
	// rules, this is the Amazon Web Services service to access through a VPC endpoint
	// from instances associated with the security group.
	PrefixListIds []AwsEc2SecurityGroupPrefixListId

	// The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
	// A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6
	// types, you must specify all codes.
	ToPort int32

	// The security group and Amazon Web Services account ID pairs.
	UserIdGroupPairs []AwsEc2SecurityGroupUserIdGroupPair

	noSmithyDocumentSerde
}

// A range of IPv4 addresses.
type AwsEc2SecurityGroupIpRange struct {

	// The IPv4 CIDR range. You can specify either a CIDR range or a source security
	// group, but not both. To specify a single IPv4 address, use the /32 prefix
	// length.
	CidrIp *string

	noSmithyDocumentSerde
}

// A range of IPv6 addresses.
type AwsEc2SecurityGroupIpv6Range struct {

	// The IPv6 CIDR range. You can specify either a CIDR range or a source security
	// group, but not both. To specify a single IPv6 address, use the /128 prefix
	// length.
	CidrIpv6 *string

	noSmithyDocumentSerde
}

// A prefix list ID.
type AwsEc2SecurityGroupPrefixListId struct {

	// The ID of the prefix.
	PrefixListId *string

	noSmithyDocumentSerde
}

// A relationship between a security group and a user.
type AwsEc2SecurityGroupUserIdGroupPair struct {

	// The ID of the security group.
	GroupId *string

	// The name of the security group.
	GroupName *string

	// The status of a VPC peering connection, if applicable.
	PeeringStatus *string

	// The ID of an Amazon Web Services account. For a referenced security group in
	// another VPC, the account ID of the referenced security group is returned in the
	// response. If the referenced security group is deleted, this value is not
	// returned. [EC2-Classic] Required when adding or removing rules that reference a
	// security group in another VPC.
	UserId *string

	// The ID of the VPC for the referenced security group, if applicable.
	VpcId *string

	// The ID of the VPC peering connection, if applicable.
	VpcPeeringConnectionId *string

	noSmithyDocumentSerde
}

// Contains information about a subnet in Amazon EC2.
type AwsEc2SubnetDetails struct {

	// Whether to assign an IPV6 address to a network interface that is created in this
	// subnet.
	AssignIpv6AddressOnCreation bool

	// The Availability Zone for the subnet.
	AvailabilityZone *string

	// The identifier of the Availability Zone for the subnet.
	AvailabilityZoneId *string

	// The number of available IPV4 addresses in the subnet. Does not include addresses
	// for stopped instances.
	AvailableIpAddressCount int32

	// The IPV4 CIDR block that is assigned to the subnet.
	CidrBlock *string

	// Whether this subnet is the default subnet for the Availability Zone.
	DefaultForAz bool

	// The IPV6 CIDR blocks that are associated with the subnet.
	Ipv6CidrBlockAssociationSet []Ipv6CidrBlockAssociation

	// Whether instances in this subnet receive a public IP address.
	MapPublicIpOnLaunch bool

	// The identifier of the Amazon Web Services account that owns the subnet.
	OwnerId *string

	// The current state of the subnet.
	State *string

	// The ARN of the subnet.
	SubnetArn *string

	// The identifier of the subnet.
	SubnetId *string

	// The identifier of the VPC that contains the subnet.
	VpcId *string

	noSmithyDocumentSerde
}

// An attachment to an Amazon EC2 volume.
type AwsEc2VolumeAttachment struct {

	// The datetime when the attachment initiated.
	AttachTime *string

	// Whether the EBS volume is deleted when the EC2 instance is terminated.
	DeleteOnTermination bool

	// The identifier of the EC2 instance.
	InstanceId *string

	// The attachment state of the volume.
	Status *string

	noSmithyDocumentSerde
}

// Details about an EC2 volume.
type AwsEc2VolumeDetails struct {

	// The volume attachments.
	Attachments []AwsEc2VolumeAttachment

	// Indicates when the volume was created. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateTime *string

	// Whether the volume is encrypted.
	Encrypted bool

	// The ARN of the KMS key that was used to protect the volume encryption key for
	// the volume.
	KmsKeyId *string

	// The size of the volume, in GiBs.
	Size int32

	// The snapshot from which the volume was created.
	SnapshotId *string

	// The volume state.
	Status *string

	noSmithyDocumentSerde
}

// Details about an EC2 VPC.
type AwsEc2VpcDetails struct {

	// Information about the IPv4 CIDR blocks associated with the VPC.
	CidrBlockAssociationSet []CidrBlockAssociation

	// The identifier of the set of Dynamic Host Configuration Protocol (DHCP) options
	// that are associated with the VPC. If the default options are associated with the
	// VPC, then this is default.
	DhcpOptionsId *string

	// Information about the IPv6 CIDR blocks associated with the VPC.
	Ipv6CidrBlockAssociationSet []Ipv6CidrBlockAssociation

	// The current state of the VPC.
	State *string

	noSmithyDocumentSerde
}

// Contains details about the service configuration for a VPC endpoint service.
type AwsEc2VpcEndpointServiceDetails struct {

	// Whether requests from other Amazon Web Services accounts to create an endpoint
	// to the service must first be accepted.
	AcceptanceRequired bool

	// The Availability Zones where the service is available.
	AvailabilityZones []string

	// The DNS names for the service.
	BaseEndpointDnsNames []string

	// The ARNs of the Gateway Load Balancers for the service.
	GatewayLoadBalancerArns []string

	// Whether the service manages its VPC endpoints.
	ManagesVpcEndpoints bool

	// The ARNs of the Network Load Balancers for the service.
	NetworkLoadBalancerArns []string

	// The private DNS name for the service.
	PrivateDnsName *string

	// The identifier of the service.
	ServiceId *string

	// The name of the service.
	ServiceName *string

	// The current state of the service.
	ServiceState *string

	// The types for the service.
	ServiceType []AwsEc2VpcEndpointServiceServiceTypeDetails

	noSmithyDocumentSerde
}

// The service type information for a VPC endpoint service.
type AwsEc2VpcEndpointServiceServiceTypeDetails struct {

	// The type of service.
	ServiceType *string

	noSmithyDocumentSerde
}

// Details about an Amazon EC2 VPN connection.
type AwsEc2VpnConnectionDetails struct {

	// The category of the VPN connection. VPN indicates an Amazon Web Services VPN
	// connection. VPN-Classic indicates an Amazon Web Services Classic VPN connection.
	Category *string

	// The configuration information for the VPN connection's customer gateway, in the
	// native XML format.
	CustomerGatewayConfiguration *string

	// The identifier of the customer gateway that is at your end of the VPN
	// connection.
	CustomerGatewayId *string

	// The VPN connection options.
	Options *AwsEc2VpnConnectionOptionsDetails

	// The static routes that are associated with the VPN connection.
	Routes []AwsEc2VpnConnectionRoutesDetails

	// The current state of the VPN connection.
	State *string

	// The identifier of the transit gateway that is associated with the VPN
	// connection.
	TransitGatewayId *string

	// The type of VPN connection.
	Type *string

	// Information about the VPN tunnel.
	VgwTelemetry []AwsEc2VpnConnectionVgwTelemetryDetails

	// The identifier of the VPN connection.
	VpnConnectionId *string

	// The identifier of the virtual private gateway that is at the Amazon Web Services
	// side of the VPN connection.
	VpnGatewayId *string

	noSmithyDocumentSerde
}

// VPN connection options.
type AwsEc2VpnConnectionOptionsDetails struct {

	// Whether the VPN connection uses static routes only.
	StaticRoutesOnly bool

	// The VPN tunnel options.
	TunnelOptions []AwsEc2VpnConnectionOptionsTunnelOptionsDetails

	noSmithyDocumentSerde
}

// The VPN tunnel options.
type AwsEc2VpnConnectionOptionsTunnelOptionsDetails struct {

	// The number of seconds after which a Dead Peer Detection (DPD) timeout occurs.
	DpdTimeoutSeconds int32

	// The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.
	IkeVersions []string

	// The external IP address of the VPN tunnel.
	OutsideIpAddress *string

	// The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE
	// negotiations.
	Phase1DhGroupNumbers []int32

	// The permitted encryption algorithms for the VPN tunnel for phase 1 IKE
	// negotiations.
	Phase1EncryptionAlgorithms []string

	// The permitted integrity algorithms for the VPN tunnel for phase 1 IKE
	// negotiations.
	Phase1IntegrityAlgorithms []string

	// The lifetime for phase 1 of the IKE negotiation, in seconds.
	Phase1LifetimeSeconds int32

	// The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE
	// negotiations.
	Phase2DhGroupNumbers []int32

	// The permitted encryption algorithms for the VPN tunnel for phase 2 IKE
	// negotiations.
	Phase2EncryptionAlgorithms []string

	// The permitted integrity algorithms for the VPN tunnel for phase 2 IKE
	// negotiations.
	Phase2IntegrityAlgorithms []string

	// The lifetime for phase 2 of the IKE negotiation, in seconds.
	Phase2LifetimeSeconds int32

	// The preshared key to establish initial authentication between the virtual
	// private gateway and the customer gateway.
	PreSharedKey *string

	// The percentage of the rekey window, which is determined by
	// RekeyMarginTimeSeconds during which the rekey time is randomly selected.
	RekeyFuzzPercentage int32

	// The margin time, in seconds, before the phase 2 lifetime expires, during which
	// the Amazon Web Services side of the VPN connection performs an IKE rekey.
	RekeyMarginTimeSeconds int32

	// The number of packets in an IKE replay window.
	ReplayWindowSize int32

	// The range of inside IPv4 addresses for the tunnel.
	TunnelInsideCidr *string

	noSmithyDocumentSerde
}

// A static routes associated with the VPN connection.
type AwsEc2VpnConnectionRoutesDetails struct {

	// The CIDR block associated with the local subnet of the customer data center.
	DestinationCidrBlock *string

	// The current state of the static route.
	State *string

	noSmithyDocumentSerde
}

// Information about the VPN tunnel.
type AwsEc2VpnConnectionVgwTelemetryDetails struct {

	// The number of accepted routes.
	AcceptedRouteCount int32

	// The ARN of the VPN tunnel endpoint certificate.
	CertificateArn *string

	// The date and time of the last change in status. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	LastStatusChange *string

	// The Internet-routable IP address of the virtual private gateway's outside
	// interface.
	OutsideIpAddress *string

	// The status of the VPN tunnel.
	Status *string

	// If an error occurs, a description of the error.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Information about an Amazon ECR image.
type AwsEcrContainerImageDetails struct {

	// The architecture of the image.
	Architecture *string

	// The sha256 digest of the image manifest.
	ImageDigest *string

	// The date and time when the image was pushed to the repository. Uses the
	// date-time format specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	ImagePublishedAt *string

	// The list of tags that are associated with the image.
	ImageTags []string

	// The Amazon Web Services account identifier that is associated with the registry
	// that the image belongs to.
	RegistryId *string

	// The name of the repository that the image belongs to.
	RepositoryName *string

	noSmithyDocumentSerde
}

// Provides information about an Amazon Elastic Container Registry repository.
type AwsEcrRepositoryDetails struct {

	// The ARN of the repository.
	Arn *string

	// The image scanning configuration for a repository.
	ImageScanningConfiguration *AwsEcrRepositoryImageScanningConfigurationDetails

	// The tag mutability setting for the repository.
	ImageTagMutability *string

	// Information about the lifecycle policy for the repository.
	LifecyclePolicy *AwsEcrRepositoryLifecyclePolicyDetails

	// The name of the repository.
	RepositoryName *string

	// The text of the repository policy.
	RepositoryPolicyText *string

	noSmithyDocumentSerde
}

// The image scanning configuration for a repository.
type AwsEcrRepositoryImageScanningConfigurationDetails struct {

	// Whether to scan images after they are pushed to a repository.
	ScanOnPush bool

	noSmithyDocumentSerde
}

// Information about the lifecycle policy for the repository.
type AwsEcrRepositoryLifecyclePolicyDetails struct {

	// The text of the lifecycle policy.
	LifecyclePolicyText *string

	// The Amazon Web Services account identifier that is associated with the registry
	// that contains the repository.
	RegistryId *string

	noSmithyDocumentSerde
}

// Indicates whether to enable CloudWatch Container Insights for the ECS cluster.
type AwsEcsClusterClusterSettingsDetails struct {

	// The name of the setting.
	Name *string

	// The value of the setting.
	Value *string

	noSmithyDocumentSerde
}

// The run command configuration for the cluster.
type AwsEcsClusterConfigurationDetails struct {

	// Contains the run command configuration for the cluster.
	ExecuteCommandConfiguration *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails

	noSmithyDocumentSerde
}

// Contains the run command configuration for the cluster.
type AwsEcsClusterConfigurationExecuteCommandConfigurationDetails struct {

	// The identifier of the KMS key that is used to encrypt the data between the local
	// client and the container.
	KmsKeyId *string

	// The log configuration for the results of the run command actions. Required if
	// Logging is NONE.
	LogConfiguration *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails

	// The log setting to use for redirecting logs for run command results.
	Logging *string

	noSmithyDocumentSerde
}

// The log configuration for the results of the run command actions.
type AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails struct {

	// Whether to enable encryption on the CloudWatch logs.
	CloudWatchEncryptionEnabled bool

	// The name of the CloudWatch log group to send the logs to.
	CloudWatchLogGroupName *string

	// The name of the S3 bucket to send logs to.
	S3BucketName *string

	// Whether to encrypt the logs that are sent to the S3 bucket.
	S3EncryptionEnabled bool

	// Identifies the folder in the S3 bucket to send the logs to.
	S3KeyPrefix *string

	noSmithyDocumentSerde
}

// The default capacity provider strategy for the cluster. The default capacity
// provider strategy is used when services or tasks are run without a specified
// launch type or capacity provider strategy.
type AwsEcsClusterDefaultCapacityProviderStrategyDetails struct {

	// The minimum number of tasks to run on the specified capacity provider.
	Base int32

	// The name of the capacity provider.
	CapacityProvider *string

	// The relative percentage of the total number of tasks launched that should use
	// the capacity provider.
	Weight int32

	noSmithyDocumentSerde
}

// provides details about an ECS cluster.
type AwsEcsClusterDetails struct {

	// The short name of one or more capacity providers to associate with the cluster.
	CapacityProviders []string

	// The setting to use to create the cluster. Specifically used to configure whether
	// to enable CloudWatch Container Insights for the cluster.
	ClusterSettings []AwsEcsClusterClusterSettingsDetails

	// The run command configuration for the cluster.
	Configuration *AwsEcsClusterConfigurationDetails

	// The default capacity provider strategy for the cluster. The default capacity
	// provider strategy is used when services or tasks are run without a specified
	// launch type or capacity provider strategy.
	DefaultCapacityProviderStrategy []AwsEcsClusterDefaultCapacityProviderStrategyDetails

	noSmithyDocumentSerde
}

// Strategy item for the capacity provider strategy that the service uses.
type AwsEcsServiceCapacityProviderStrategyDetails struct {

	// The minimum number of tasks to run on the capacity provider. Only one strategy
	// item can specify a value for Base. The value must be between 0 and 100000.
	Base int32

	// The short name of the capacity provider.
	CapacityProvider *string

	// The relative percentage of the total number of tasks that should use the
	// capacity provider. If no weight is specified, the default value is 0. At least
	// one capacity provider must have a weight greater than 0. The value can be
	// between 0 and 1000.
	Weight int32

	noSmithyDocumentSerde
}

// Determines whether a service deployment fails if a service cannot reach a steady
// state.
type AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails struct {

	// Whether to enable the deployment circuit breaker logic for the service.
	Enable bool

	// Whether to roll back the service if a service deployment fails. If rollback is
	// enabled, when a service deployment fails, the service is rolled back to the last
	// deployment that completed successfully.
	Rollback bool

	noSmithyDocumentSerde
}

// Optional deployment parameters for the service.
type AwsEcsServiceDeploymentConfigurationDetails struct {

	// Determines whether a service deployment fails if a service cannot reach a steady
	// state.
	DeploymentCircuitBreaker *AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails

	// For a service that uses the rolling update (ECS) deployment type, the maximum
	// number of tasks in a service that are allowed in the RUNNING or PENDING state
	// during a deployment, and for tasks that use the EC2 launch type, when any
	// container instances are in the DRAINING state. Provided as a percentage of the
	// desired number of tasks. The default value is 200%. For a service that uses the
	// blue/green (CODE_DEPLOY) or EXTERNAL deployment types, and tasks that use the
	// EC2 launch type, the maximum number of tasks in the service that remain in the
	// RUNNING state while the container instances are in the DRAINING state. For the
	// Fargate launch type, the maximum percent value is not used.
	MaximumPercent int32

	// For a service that uses the rolling update (ECS) deployment type, the minimum
	// number of tasks in a service that must remain in the RUNNING state during a
	// deployment, and while any container instances are in the DRAINING state if the
	// service contains tasks using the EC2 launch type. Expressed as a percentage of
	// the desired number of tasks. The default value is 100%. For a service that uses
	// the blue/green (CODE_DEPLOY) or EXTERNAL deployment types and tasks that use the
	// EC2 launch type, the minimum number of the tasks in the service that remain in
	// the RUNNING state while the container instances are in the DRAINING state. For
	// the Fargate launch type, the minimum healthy percent value is not used.
	MinimumHealthyPercent int32

	noSmithyDocumentSerde
}

// Information about the deployment controller type that the service uses.
type AwsEcsServiceDeploymentControllerDetails struct {

	// The rolling update (ECS) deployment type replaces the current running version of
	// the container with the latest version. The blue/green (CODE_DEPLOY) deployment
	// type uses the blue/green deployment model that is powered by CodeDeploy. This
	// deployment model a new deployment of a service can be verified before production
	// traffic is sent to it. The external (EXTERNAL) deployment type allows the use of
	// any third-party deployment controller for full control over the deployment
	// process for an Amazon ECS service. Valid values: ECS | CODE_DEPLOY | EXTERNAL
	Type *string

	noSmithyDocumentSerde
}

// Provides details about a service within an ECS cluster.
type AwsEcsServiceDetails struct {

	// The capacity provider strategy that the service uses.
	CapacityProviderStrategy []AwsEcsServiceCapacityProviderStrategyDetails

	// The ARN of the cluster that hosts the service.
	Cluster *string

	// Deployment parameters for the service. Includes the number of tasks that run and
	// the order in which to start and stop tasks.
	DeploymentConfiguration *AwsEcsServiceDeploymentConfigurationDetails

	// Contains the deployment controller type that the service uses.
	DeploymentController *AwsEcsServiceDeploymentControllerDetails

	// The number of instantiations of the task definition to run on the service.
	DesiredCount int32

	// Whether to enable Amazon ECS managed tags for the tasks in the service.
	EnableEcsManagedTags bool

	// Whether the execute command functionality is enabled for the service.
	EnableExecuteCommand bool

	// After a task starts, the amount of time in seconds that the Amazon ECS service
	// scheduler ignores unhealthy Elastic Load Balancing target health checks.
	HealthCheckGracePeriodSeconds int32

	// The launch type that the service uses. Valid values: EC2 | FARGATE | EXTERNAL
	LaunchType *string

	// Information about the load balancers that the service uses.
	LoadBalancers []AwsEcsServiceLoadBalancersDetails

	// The name of the service.
	Name *string

	// For tasks that use the awsvpc networking mode, the VPC subnet and security group
	// configuration.
	NetworkConfiguration *AwsEcsServiceNetworkConfigurationDetails

	// The placement constraints for the tasks in the service.
	PlacementConstraints []AwsEcsServicePlacementConstraintsDetails

	// Information about how tasks for the service are placed.
	PlacementStrategies []AwsEcsServicePlacementStrategiesDetails

	// The platform version on which to run the service. Only specified for tasks that
	// are hosted on Fargate. If a platform version is not specified, the LATEST
	// platform version is used by default.
	PlatformVersion *string

	// Indicates whether to propagate the tags from the task definition to the task or
	// from the service to the task. If no value is provided, then tags are not
	// propagated. Valid values: TASK_DEFINITION | SERVICE
	PropagateTags *string

	// The ARN of the IAM role that is associated with the service. The role allows the
	// Amazon ECS container agent to register container instances with an Elastic Load
	// Balancing load balancer.
	Role *string

	// The scheduling strategy to use for the service. The REPLICA scheduling strategy
	// places and maintains the desired number of tasks across the cluster. By default,
	// the service scheduler spreads tasks across Availability Zones. Task placement
	// strategies and constraints are used to customize task placement decisions. The
	// DAEMON scheduling strategy deploys exactly one task on each active container
	// instance that meets all of the task placement constraints that are specified in
	// the cluster. The service scheduler also evaluates the task placement constraints
	// for running tasks and stops tasks that do not meet the placement constraints.
	// Valid values: REPLICA | DAEMON
	SchedulingStrategy *string

	// The ARN of the service.
	ServiceArn *string

	// The name of the service. The name can contain up to 255 characters. It can use
	// letters, numbers, underscores, and hyphens.
	ServiceName *string

	// Information about the service discovery registries to assign to the service.
	ServiceRegistries []AwsEcsServiceServiceRegistriesDetails

	// The task definition to use for tasks in the service.
	TaskDefinition *string

	noSmithyDocumentSerde
}

// Information about a load balancer that the service uses.
type AwsEcsServiceLoadBalancersDetails struct {

	// The name of the container to associate with the load balancer.
	ContainerName *string

	// The port on the container to associate with the load balancer. This port must
	// correspond to a containerPort in the task definition the tasks in the service
	// are using. For tasks that use the EC2 launch type, the container instance they
	// are launched on must allow ingress traffic on the hostPort of the port mapping.
	ContainerPort int32

	// The name of the load balancer to associate with the Amazon ECS service or task
	// set. Only specified when using a Classic Load Balancer. For an Application Load
	// Balancer or a Network Load Balancer, the load balancer name is omitted.
	LoadBalancerName *string

	// The ARN of the Elastic Load Balancing target group or groups associated with a
	// service or task set. Only specified when using an Application Load Balancer or a
	// Network Load Balancer. For a Classic Load Balancer, the target group ARN is
	// omitted.
	TargetGroupArn *string

	noSmithyDocumentSerde
}

// For tasks that use the awsvpc networking mode, the VPC subnet and security group
// configuration.
type AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails struct {

	// Whether the task's elastic network interface receives a public IP address. The
	// default value is DISABLED. Valid values: ENABLED | DISABLED
	AssignPublicIp *string

	// The IDs of the security groups associated with the task or service. You can
	// provide up to five security groups.
	SecurityGroups []string

	// The IDs of the subnets associated with the task or service. You can provide up
	// to 16 subnets.
	Subnets []string

	noSmithyDocumentSerde
}

// For tasks that use the awsvpc networking mode, the VPC subnet and security group
// configuration.
type AwsEcsServiceNetworkConfigurationDetails struct {

	// The VPC subnet and security group configuration.
	AwsVpcConfiguration *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails

	noSmithyDocumentSerde
}

// A placement constraint for the tasks in the service.
type AwsEcsServicePlacementConstraintsDetails struct {

	// A cluster query language expression to apply to the constraint. You cannot
	// specify an expression if the constraint type is distinctInstance.
	Expression *string

	// The type of constraint. Use distinctInstance to run each task in a particular
	// group on a different container instance. Use memberOf to restrict the selection
	// to a group of valid candidates. Valid values: distinctInstance | memberOf
	Type *string

	noSmithyDocumentSerde
}

// A placement strategy that determines how to place the tasks for the service.
type AwsEcsServicePlacementStrategiesDetails struct {

	// The field to apply the placement strategy against. For the spread placement
	// strategy, valid values are instanceId (or host, which has the same effect), or
	// any platform or custom attribute that is applied to a container instance, such
	// as attribute:ecs.availability-zone. For the binpack placement strategy, valid
	// values are cpu and memory. For the random placement strategy, this attribute is
	// not used.
	Field *string

	// The type of placement strategy. The random placement strategy randomly places
	// tasks on available candidates. The spread placement strategy spreads placement
	// across available candidates evenly based on the value of Field. The binpack
	// strategy places tasks on available candidates that have the least available
	// amount of the resource that is specified in Field. Valid values: random | spread
	// | binpack
	Type *string

	noSmithyDocumentSerde
}

// Information about a service discovery registry to assign to the service.
type AwsEcsServiceServiceRegistriesDetails struct {

	// The container name value to use for the service discovery service. If the task
	// definition uses the bridge or host network mode, you must specify ContainerName
	// and ContainerPort. If the task definition uses the awsvpc network mode and a
	// type SRV DNS record, you must specify either ContainerName and ContainerPort, or
	// Port , but not both.
	ContainerName *string

	// The port value to use for the service discovery service. If the task definition
	// uses the bridge or host network mode, you must specify ContainerName and
	// ContainerPort. If the task definition uses the awsvpc network mode and a type
	// SRV DNS record, you must specify either ContainerName and ContainerPort, or Port
	// , but not both.
	ContainerPort int32

	// The port value to use for a service discovery service that specifies an SRV
	// record. This field can be used if both the awsvpcawsvpc network mode and SRV
	// records are used.
	Port int32

	// The ARN of the service registry.
	RegistryArn *string

	noSmithyDocumentSerde
}

// A dependency that is defined for container startup and shutdown.
type AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails struct {

	// The dependency condition of the dependent container. Indicates the required
	// status of the dependent container before the current container can start.
	Condition *string

	// The name of the dependent container.
	ContainerName *string

	noSmithyDocumentSerde
}

// A container definition that describes a container in the task.
type AwsEcsTaskDefinitionContainerDefinitionsDetails struct {

	// The command that is passed to the container.
	Command []string

	// The number of CPU units reserved for the container.
	Cpu int32

	// The dependencies that are defined for container startup and shutdown.
	DependsOn []AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails

	// Whether to disable networking within the container.
	DisableNetworking bool

	// A list of DNS search domains that are presented to the container.
	DnsSearchDomains []string

	// A list of DNS servers that are presented to the container.
	DnsServers []string

	// A key-value map of labels to add to the container.
	DockerLabels map[string]string

	// A list of strings to provide custom labels for SELinux and AppArmor multi-level
	// security systems.
	DockerSecurityOptions []string

	// The entry point that is passed to the container.
	EntryPoint []string

	// The environment variables to pass to a container.
	Environment []AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails

	// A list of files containing the environment variables to pass to a container.
	EnvironmentFiles []AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails

	// Whether the container is essential. All tasks must have at least one essential
	// container.
	Essential bool

	// A list of hostnames and IP address mappings to append to the /etc/hosts file on
	// the container.
	ExtraHosts []AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails

	// The FireLens configuration for the container. Specifies and configures a log
	// router for container logs.
	FirelensConfiguration *AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails

	// The container health check command and associated configuration parameters for
	// the container.
	HealthCheck *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails

	// The hostname to use for the container.
	Hostname *string

	// The image used to start the container.
	Image *string

	// If set to true, then containerized applications can be deployed that require
	// stdin or a tty to be allocated.
	Interactive bool

	// A list of links for the container in the form  container_name:alias . Allows
	// containers to communicate with each other without the need for port mappings.
	Links []string

	// Linux-specific modifications that are applied to the container, such as Linux
	// kernel capabilities.
	LinuxParameters *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails

	// The log configuration specification for the container.
	LogConfiguration *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails

	// The amount (in MiB) of memory to present to the container. If the container
	// attempts to exceed the memory specified here, the container is shut down. The
	// total amount of memory reserved for all containers within a task must be lower
	// than the task memory value, if one is specified.
	Memory int32

	// The soft limit (in MiB) of memory to reserve for the container.
	MemoryReservation int32

	// The mount points for the data volumes in the container.
	MountPoints []AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails

	// The name of the container.
	Name *string

	// The list of port mappings for the container.
	PortMappings []AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails

	// Whether the container is given elevated privileges on the host container
	// instance. The elevated privileges are similar to the root user.
	Privileged bool

	// Whether to allocate a TTY to the container.
	PseudoTerminal bool

	// Whether the container is given read-only access to its root file system.
	ReadonlyRootFilesystem bool

	// The private repository authentication credentials to use.
	RepositoryCredentials *AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails

	// The type and amount of a resource to assign to a container. The only supported
	// resource is a GPU.
	ResourceRequirements []AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails

	// The secrets to pass to the container.
	Secrets []AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails

	// The number of seconds to wait before giving up on resolving dependencies for a
	// container.
	StartTimeout int32

	// The number of seconds to wait before the container is stopped if it doesn't shut
	// down normally on its own.
	StopTimeout int32

	// A list of namespaced kernel parameters to set in the container.
	SystemControls []AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails

	// A list of ulimits to set in the container.
	Ulimits []AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails

	// The user to use inside the container. The value can use one of the following
	// formats.
	//
	// * user
	//
	// * user : group
	//
	// * uid
	//
	// * uid : gid
	//
	// * user : gid
	//
	// * uid :
	// group
	User *string

	// Data volumes to mount from another container.
	VolumesFrom []AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails

	// The working directory in which to run commands inside the container.
	WorkingDirectory *string

	noSmithyDocumentSerde
}

// An environment variable to pass to the container.
type AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails struct {

	// The name of the environment variable.
	Name *string

	// The value of the environment variable.
	Value *string

	noSmithyDocumentSerde
}

// A file that contain environment variables to pass to a container.
type AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails struct {

	// The type of environment file.
	Type *string

	// The ARN of the S3 object that contains the environment variable file.
	Value *string

	noSmithyDocumentSerde
}

// A hostname and IP address mapping to append to the /etc/hosts file on the
// container.
type AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails struct {

	// The hostname to use in the /etc/hosts entry.
	Hostname *string

	// The IP address to use in the /etc/hosts entry.
	IpAddress *string

	noSmithyDocumentSerde
}

// The FireLens configuration for the container. The configuration specifies and
// configures a log router for container logs.
type AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails struct {

	// The options to use to configure the log router. The valid option keys are as
	// follows:
	//
	// * enable-ecs-log-metadata. The value can be true or false.
	//
	// *
	// config-file-type. The value can be s3 or file.
	//
	// * config-file-value. The value
	// is either an S3 ARN or a file path.
	Options map[string]string

	// The log router to use.
	Type *string

	noSmithyDocumentSerde
}

// The container health check command and associated configuration parameters for
// the container.
type AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails struct {

	// The command that the container runs to determine whether it is healthy.
	Command []string

	// The time period in seconds between each health check execution. The default
	// value is 30 seconds.
	Interval int32

	// The number of times to retry a failed health check before the container is
	// considered unhealthy. The default value is 3.
	Retries int32

	// The optional grace period in seconds that allows containers time to bootstrap
	// before failed health checks count towards the maximum number of retries.
	StartPeriod int32

	// The time period in seconds to wait for a health check to succeed before it is
	// considered a failure. The default value is 5.
	Timeout int32

	noSmithyDocumentSerde
}

// The Linux capabilities for the container that are added to or dropped from the
// default configuration provided by Docker.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails struct {

	// The Linux capabilities for the container that are added to the default
	// configuration provided by Docker.
	Add []string

	// The Linux capabilities for the container that are dropped from the default
	// configuration provided by Docker.
	Drop []string

	noSmithyDocumentSerde
}

// >Linux-specific modifications that are applied to the container, such as Linux
// kernel capabilities.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails struct {

	// The Linux capabilities for the container that are added to or dropped from the
	// default configuration provided by Docker.
	Capabilities *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails

	// The host devices to expose to the container.
	Devices []AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails

	// Whether to run an init process inside the container that forwards signals and
	// reaps processes.
	InitProcessEnabled bool

	// The total amount of swap memory (in MiB) that a container can use.
	MaxSwap int32

	// The value for the size (in MiB) of the /dev/shm volume.
	SharedMemorySize int32

	// Configures the container's memory swappiness behavior. Determines how
	// aggressively pages are swapped. The higher the value, the more aggressive the
	// swappiness. The default is 60.
	Swappiness int32

	// The container path, mount options, and size (in MiB) of the tmpfs mount.
	Tmpfs []AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails

	noSmithyDocumentSerde
}

// A host device to expose to the container.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails struct {

	// The path inside the container at which to expose the host device.
	ContainerPath *string

	// The path for the device on the host container instance.
	HostPath *string

	// The explicit permissions to provide to the container for the device. By default,
	// the container has permissions for read, write, and mknod for the device.
	Permissions []string

	noSmithyDocumentSerde
}

// The container path, mount options, and size (in MiB) of a tmpfs mount.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails struct {

	// The absolute file path where the tmpfs volume is to be mounted.
	ContainerPath *string

	// The list of tmpfs volume mount options.
	MountOptions []string

	// The maximum size (in MiB) of the tmpfs volume.
	Size int32

	noSmithyDocumentSerde
}

// The log configuration specification for the container.
type AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails struct {

	// The log driver to use for the container.
	LogDriver *string

	// The configuration options to send to the log driver. Requires version 1.19 of
	// the Docker Remote API or greater on your container instance.
	Options map[string]string

	// The secrets to pass to the log configuration.
	SecretOptions []AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails

	noSmithyDocumentSerde
}

// A secret to pass to the log configuration.
type AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails struct {

	// The name of the secret.
	Name *string

	// The secret to expose to the container. The value is either the full ARN of the
	// Secrets Manager secret or the full ARN of the parameter in the Systems Manager
	// Parameter Store.
	ValueFrom *string

	noSmithyDocumentSerde
}

// A mount point for the data volumes in the container.
type AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails struct {

	// The path on the container to mount the host volume at.
	ContainerPath *string

	// Whether the container has read-only access to the volume.
	ReadOnly bool

	// The name of the volume to mount. Must match the name of a volume listed in
	// VolumeDetails for the task definition.
	SourceVolume *string

	noSmithyDocumentSerde
}

// A port mapping for the container.
type AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails struct {

	// The port number on the container that is bound to the user-specified or
	// automatically assigned host port.
	ContainerPort int32

	// The port number on the container instance to reserve for the container.
	HostPort int32

	// The protocol used for the port mapping. The default is tcp.
	Protocol *string

	noSmithyDocumentSerde
}

// The private repository authentication credentials to use.
type AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails struct {

	// The ARN of the secret that contains the private repository credentials.
	CredentialsParameter *string

	noSmithyDocumentSerde
}

// A resource to assign to a container.
type AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails struct {

	// The type of resource to assign to a container.
	Type *string

	// The value for the specified resource type. For GPU, the value is the number of
	// physical GPUs the Amazon ECS container agent reserves for the container. For
	// InferenceAccelerator, the value should match the DeviceName attribute of an
	// entry in InferenceAccelerators.
	Value *string

	noSmithyDocumentSerde
}

// A secret to pass to the container.
type AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails struct {

	// The name of the secret.
	Name *string

	// The secret to expose to the container. The value is either the full ARN of the
	// Secrets Manager secret or the full ARN of the parameter in the Systems Manager
	// Parameter Store.
	ValueFrom *string

	noSmithyDocumentSerde
}

// A namespaced kernel parameter to set in the container.
type AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails struct {

	// The namespaced kernel parameter for which to set a value.
	Namespace *string

	// The value of the parameter.
	Value *string

	noSmithyDocumentSerde
}

// A ulimit to set in the container.
type AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails struct {

	// The hard limit for the ulimit type.
	HardLimit int32

	// The type of the ulimit.
	Name *string

	// The soft limit for the ulimit type.
	SoftLimit int32

	noSmithyDocumentSerde
}

// A data volume to mount from another container.
type AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails struct {

	// Whether the container has read-only access to the volume.
	ReadOnly bool

	// The name of another container within the same task definition from which to
	// mount volumes.
	SourceContainer *string

	noSmithyDocumentSerde
}

// details about a task definition. A task definition describes the container and
// volume definitions of an Amazon Elastic Container Service task.
type AwsEcsTaskDefinitionDetails struct {

	// The container definitions that describe the containers that make up the task.
	ContainerDefinitions []AwsEcsTaskDefinitionContainerDefinitionsDetails

	// The number of CPU units used by the task.
	Cpu *string

	// The ARN of the task execution role that grants the container agent permission to
	// make API calls on behalf of the container user.
	ExecutionRoleArn *string

	// The name of a family that this task definition is registered to.
	Family *string

	// The Elastic Inference accelerators to use for the containers in the task.
	InferenceAccelerators []AwsEcsTaskDefinitionInferenceAcceleratorsDetails

	// The IPC resource namespace to use for the containers in the task.
	IpcMode *string

	// The amount (in MiB) of memory used by the task.
	Memory *string

	// The Docker networking mode to use for the containers in the task.
	NetworkMode *string

	// The process namespace to use for the containers in the task.
	PidMode *string

	// The placement constraint objects to use for tasks.
	PlacementConstraints []AwsEcsTaskDefinitionPlacementConstraintsDetails

	// The configuration details for the App Mesh proxy.
	ProxyConfiguration *AwsEcsTaskDefinitionProxyConfigurationDetails

	// The task launch types that the task definition was validated against.
	RequiresCompatibilities []string

	// The short name or ARN of the IAM role that grants containers in the task
	// permission to call Amazon Web Services API operations on your behalf.
	TaskRoleArn *string

	// The data volume definitions for the task.
	Volumes []AwsEcsTaskDefinitionVolumesDetails

	noSmithyDocumentSerde
}

// An Elastic Inference accelerator to use for the containers in the task.
type AwsEcsTaskDefinitionInferenceAcceleratorsDetails struct {

	// The Elastic Inference accelerator device name.
	DeviceName *string

	// The Elastic Inference accelerator type to use.
	DeviceType *string

	noSmithyDocumentSerde
}

// A placement constraint object to use for tasks.
type AwsEcsTaskDefinitionPlacementConstraintsDetails struct {

	// A cluster query language expression to apply to the constraint.
	Expression *string

	// The type of constraint.
	Type *string

	noSmithyDocumentSerde
}

// The configuration details for the App Mesh proxy.
type AwsEcsTaskDefinitionProxyConfigurationDetails struct {

	// The name of the container that will serve as the App Mesh proxy.
	ContainerName *string

	// The set of network configuration parameters to provide to the Container Network
	// Interface (CNI) plugin, specified as key-value pairs.
	ProxyConfigurationProperties []AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails

	// The proxy type.
	Type *string

	noSmithyDocumentSerde
}

// A network configuration parameter to provide to the Container Network Interface
// (CNI) plugin.
type AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails struct {

	// The name of the property.
	Name *string

	// The value of the property.
	Value *string

	noSmithyDocumentSerde
}

// A data volume to mount from another container.
type AwsEcsTaskDefinitionVolumesDetails struct {

	// Information about a Docker volume.
	DockerVolumeConfiguration *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails

	// Information about the Amazon Elastic File System file system that is used for
	// task storage.
	EfsVolumeConfiguration *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails

	// Information about a bind mount host volume.
	Host *AwsEcsTaskDefinitionVolumesHostDetails

	// The name of the data volume.
	Name *string

	noSmithyDocumentSerde
}

// Information about a Docker volume.
type AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails struct {

	// Whether to create the Docker volume automatically if it does not already exist.
	Autoprovision bool

	// The Docker volume driver to use.
	Driver *string

	// A map of Docker driver-specific options that are passed through.
	DriverOpts map[string]string

	// Custom metadata to add to the Docker volume.
	Labels map[string]string

	// The scope for the Docker volume that determines its lifecycle. Docker volumes
	// that are scoped to a task are provisioned automatically when the task starts and
	// destroyed when the task stops. Docker volumes that are shared persist after the
	// task stops.
	Scope *string

	noSmithyDocumentSerde
}

//
type AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails struct {

	// The Amazon EFS access point identifier to use.
	AccessPointId *string

	// Whether to use the Amazon ECS task IAM role defined in a task definition when
	// mounting the Amazon EFS file system.
	Iam *string

	noSmithyDocumentSerde
}

// Information about the Amazon Elastic File System file system that is used for
// task storage.
type AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails struct {

	// The authorization configuration details for the Amazon EFS file system.
	AuthorizationConfig *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails

	// The Amazon EFS file system identifier to use.
	FilesystemId *string

	// The directory within the Amazon EFS file system to mount as the root directory
	// inside the host.
	RootDirectory *string

	// Whether to enable encryption for Amazon EFS data in transit between the Amazon
	// ECS host and the Amazon EFS server.
	TransitEncryption *string

	// The port to use when sending encrypted data between the Amazon ECS host and the
	// Amazon EFS server.
	TransitEncryptionPort int32

	noSmithyDocumentSerde
}

// Information about a bind mount host volume.
type AwsEcsTaskDefinitionVolumesHostDetails struct {

	// The path on the host container instance that is presented to the container.
	SourcePath *string

	noSmithyDocumentSerde
}

// Provides details about an Amazon EKS cluster.
type AwsEksClusterDetails struct {

	// The ARN of the cluster.
	Arn *string

	// The certificate authority data for the cluster.
	CertificateAuthorityData *string

	// The status of the cluster.
	ClusterStatus *string

	// The endpoint for the Amazon EKS API server.
	Endpoint *string

	// The logging configuration for the cluster.
	Logging *AwsEksClusterLoggingDetails

	// The name of the cluster.
	Name *string

	// The VPC configuration used by the cluster control plane.
	ResourcesVpcConfig *AwsEksClusterResourcesVpcConfigDetails

	// The ARN of the IAM role that provides permissions for the Amazon EKS control
	// plane to make calls to Amazon Web Services API operations on your behalf.
	RoleArn *string

	// The Amazon EKS server version for the cluster.
	Version *string

	noSmithyDocumentSerde
}

// Details for a cluster logging configuration.
type AwsEksClusterLoggingClusterLoggingDetails struct {

	// Whether the logging types that are listed in Types are enabled.
	Enabled bool

	// A list of logging types.
	Types []string

	noSmithyDocumentSerde
}

// The logging configuration for an Amazon EKS cluster.
type AwsEksClusterLoggingDetails struct {

	// Cluster logging configurations.
	ClusterLogging []AwsEksClusterLoggingClusterLoggingDetails

	noSmithyDocumentSerde
}

// Information about the VPC configuration used by the cluster control plane.
type AwsEksClusterResourcesVpcConfigDetails struct {

	// The security groups that are associated with the cross-account elastic network
	// interfaces that are used to allow communication between your nodes and the
	// Amazon EKS control plane.
	SecurityGroupIds []string

	// The subnets that are associated with the cluster.
	SubnetIds []string

	noSmithyDocumentSerde
}

// Contains details about an Elastic Beanstalk environment.
type AwsElasticBeanstalkEnvironmentDetails struct {

	// The name of the application that is associated with the environment.
	ApplicationName *string

	// The URL to the CNAME for this environment.
	Cname *string

	// The creation date for this environment.
	DateCreated *string

	// The date when this environment was last modified.
	DateUpdated *string

	// A description of the environment.
	Description *string

	// For load-balanced, autoscaling environments, the URL to the load balancer. For
	// single-instance environments, the IP address of the instance.
	EndpointUrl *string

	// The ARN of the environment.
	EnvironmentArn *string

	// The identifier of the environment.
	EnvironmentId *string

	// Links to other environments in the same group.
	EnvironmentLinks []AwsElasticBeanstalkEnvironmentEnvironmentLink

	// The name of the environment.
	EnvironmentName *string

	// The configuration setting for the environment.
	OptionSettings []AwsElasticBeanstalkEnvironmentOptionSetting

	// The ARN of the platform version for the environment.
	PlatformArn *string

	// The name of the solution stack that is deployed with the environment.
	SolutionStackName *string

	// The current operational status of the environment.
	Status *string

	// The tier of the environment.
	Tier *AwsElasticBeanstalkEnvironmentTier

	// The application version of the environment.
	VersionLabel *string

	noSmithyDocumentSerde
}

// Contains information about a link to another environment that is in the same
// group.
type AwsElasticBeanstalkEnvironmentEnvironmentLink struct {

	// The name of the linked environment.
	EnvironmentName *string

	// The name of the environment link.
	LinkName *string

	noSmithyDocumentSerde
}

// A configuration option setting for the environment.
type AwsElasticBeanstalkEnvironmentOptionSetting struct {

	// The type of resource that the configuration option is associated with.
	Namespace *string

	// The name of the option.
	OptionName *string

	// The name of the resource.
	ResourceName *string

	// The value of the configuration setting.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about the tier of the environment.
type AwsElasticBeanstalkEnvironmentTier struct {

	// The name of the environment tier.
	Name *string

	// The type of environment tier.
	Type *string

	// The version of the environment tier.
	Version *string

	noSmithyDocumentSerde
}

// Information about an Elasticsearch domain.
type AwsElasticsearchDomainDetails struct {

	// IAM policy document specifying the access policies for the new Elasticsearch
	// domain.
	AccessPolicies *string

	// Additional options for the domain endpoint.
	DomainEndpointOptions *AwsElasticsearchDomainDomainEndpointOptions

	// Unique identifier for an Elasticsearch domain.
	DomainId *string

	// Name of an Elasticsearch domain. Domain names are unique across all domains
	// owned by the same account within an Amazon Web Services Region. Domain names
	// must start with a lowercase letter and must be between 3 and 28 characters.
	// Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
	DomainName *string

	// Information about an OpenSearch cluster configuration.
	ElasticsearchClusterConfig *AwsElasticsearchDomainElasticsearchClusterConfigDetails

	// OpenSearch version.
	ElasticsearchVersion *string

	// Details about the configuration for encryption at rest.
	EncryptionAtRestOptions *AwsElasticsearchDomainEncryptionAtRestOptions

	// Domain-specific endpoint used to submit index, search, and data upload requests
	// to an Elasticsearch domain. The endpoint is a service URL.
	Endpoint *string

	// The key-value pair that exists if the Elasticsearch domain uses VPC endpoints.
	Endpoints map[string]string

	// Configures the CloudWatch Logs to publish for the Elasticsearch domain.
	LogPublishingOptions *AwsElasticsearchDomainLogPublishingOptions

	// Details about the configuration for node-to-node encryption.
	NodeToNodeEncryptionOptions *AwsElasticsearchDomainNodeToNodeEncryptionOptions

	// Information about the status of a domain relative to the latest service
	// software.
	ServiceSoftwareOptions *AwsElasticsearchDomainServiceSoftwareOptions

	// Information that OpenSearch derives based on VPCOptions for the domain.
	VPCOptions *AwsElasticsearchDomainVPCOptions

	noSmithyDocumentSerde
}

// Additional options for the domain endpoint, such as whether to require HTTPS for
// all traffic.
type AwsElasticsearchDomainDomainEndpointOptions struct {

	// Whether to require that all traffic to the domain arrive over HTTPS.
	EnforceHTTPS bool

	// The TLS security policy to apply to the HTTPS endpoint of the OpenSearch domain.
	// Valid values:
	//
	// * Policy-Min-TLS-1-0-2019-07, which supports TLSv1.0 and
	// higher
	//
	// * Policy-Min-TLS-1-2-2019-07, which only supports TLSv1.2
	TLSSecurityPolicy *string

	noSmithyDocumentSerde
}

// details about the configuration of an OpenSearch cluster.
type AwsElasticsearchDomainElasticsearchClusterConfigDetails struct {

	// The number of instances to use for the master node. If this attribute is
	// specified, then DedicatedMasterEnabled must be true.
	DedicatedMasterCount int32

	// Whether to use a dedicated master node for the Elasticsearch domain. A dedicated
	// master node performs cluster management tasks, but doesn't hold data or respond
	// to data upload requests.
	DedicatedMasterEnabled bool

	// The hardware configuration of the computer that hosts the dedicated master node.
	// For example, m3.medium.elasticsearch. If this attribute is specified, then
	// DedicatedMasterEnabled must be true.
	DedicatedMasterType *string

	// The number of data nodes to use in the Elasticsearch domain.
	InstanceCount int32

	// The instance type for your data nodes. For example, m3.medium.elasticsearch.
	InstanceType *string

	// Configuration options for zone awareness. Provided if ZoneAwarenessEnabled is
	// true.
	ZoneAwarenessConfig *AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails

	// Whether to enable zone awareness for the Elasticsearch domain. When zone
	// awareness is enabled, OpenSearch allocates the cluster's nodes and replica index
	// shards across Availability Zones in the same Region. This prevents data loss and
	// minimizes downtime if a node or data center fails.
	ZoneAwarenessEnabled bool

	noSmithyDocumentSerde
}

// Configuration options for zone awareness.
type AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails struct {

	// he number of Availability Zones that the domain uses. Valid values are 2 and 3.
	// The default is 2.
	AvailabilityZoneCount int32

	noSmithyDocumentSerde
}

// Details about the configuration for encryption at rest.
type AwsElasticsearchDomainEncryptionAtRestOptions struct {

	// Whether encryption at rest is enabled.
	Enabled bool

	// The KMS key ID. Takes the form 1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// configures the CloudWatch Logs to publish for the Elasticsearch domain.
type AwsElasticsearchDomainLogPublishingOptions struct {

	// The log configuration.
	AuditLogs *AwsElasticsearchDomainLogPublishingOptionsLogConfig

	// Configures the OpenSearch index logs publishing.
	IndexSlowLogs *AwsElasticsearchDomainLogPublishingOptionsLogConfig

	// Configures the OpenSearch search slow log publishing.
	SearchSlowLogs *AwsElasticsearchDomainLogPublishingOptionsLogConfig

	noSmithyDocumentSerde
}

// The log configuration.
type AwsElasticsearchDomainLogPublishingOptionsLogConfig struct {

	// The ARN of the CloudWatch Logs group to publish the logs to.
	CloudWatchLogsLogGroupArn *string

	// Whether the log publishing is enabled.
	Enabled bool

	noSmithyDocumentSerde
}

// Details about the configuration for node-to-node encryption.
type AwsElasticsearchDomainNodeToNodeEncryptionOptions struct {

	// Whether node-to-node encryption is enabled.
	Enabled bool

	noSmithyDocumentSerde
}

// Information about the state of the domain relative to the latest service
// software.
type AwsElasticsearchDomainServiceSoftwareOptions struct {

	// The epoch time when the deployment window closes for required updates. After
	// this time, Amazon OpenSearch Service schedules the software upgrade
	// automatically.
	AutomatedUpdateDate *string

	// Whether a request to update the domain can be canceled.
	Cancellable bool

	// The version of the service software that is currently installed on the domain.
	CurrentVersion *string

	// A more detailed description of the service software status.
	Description *string

	// The most recent version of the service software.
	NewVersion *string

	// Whether a service software update is available for the domain.
	UpdateAvailable bool

	// The status of the service software update.
	UpdateStatus *string

	noSmithyDocumentSerde
}

// Information that OpenSearch derives based on VPCOptions for the domain.
type AwsElasticsearchDomainVPCOptions struct {

	// The list of Availability Zones associated with the VPC subnets.
	AvailabilityZones []string

	// The list of security group IDs associated with the VPC endpoints for the domain.
	SecurityGroupIds []string

	// A list of subnet IDs associated with the VPC endpoints for the domain.
	SubnetIds []string

	// ID for the VPC.
	VPCId *string

	noSmithyDocumentSerde
}

// Contains information about a stickiness policy that was created using
// CreateAppCookieStickinessPolicy.
type AwsElbAppCookieStickinessPolicy struct {

	// The name of the application cookie used for stickiness.
	CookieName *string

	// The mnemonic name for the policy being created. The name must be unique within
	// the set of policies for the load balancer.
	PolicyName *string

	noSmithyDocumentSerde
}

// Contains information about a stickiness policy that was created using
// CreateLBCookieStickinessPolicy.
type AwsElbLbCookieStickinessPolicy struct {

	// The amount of time, in seconds, after which the cookie is considered stale. If
	// an expiration period is not specified, the stickiness session lasts for the
	// duration of the browser session.
	CookieExpirationPeriod int64

	// The name of the policy. The name must be unique within the set of policies for
	// the load balancer.
	PolicyName *string

	noSmithyDocumentSerde
}

// Contains information about the access log configuration for the load balancer.
type AwsElbLoadBalancerAccessLog struct {

	// The interval in minutes for publishing the access logs. You can publish access
	// logs either every 5 minutes or every 60 minutes.
	EmitInterval int32

	// Indicates whether access logs are enabled for the load balancer.
	Enabled bool

	// The name of the S3 bucket where the access logs are stored.
	S3BucketName *string

	// The logical hierarchy that was created for the S3 bucket. If a prefix is not
	// provided, the log is placed at the root level of the bucket.
	S3BucketPrefix *string

	noSmithyDocumentSerde
}

// Contains attributes for the load balancer.
type AwsElbLoadBalancerAttributes struct {

	// Information about the access log configuration for the load balancer. If the
	// access log is enabled, the load balancer captures detailed information about all
	// requests. It delivers the information to a specified S3 bucket.
	AccessLog *AwsElbLoadBalancerAccessLog

	// Information about the connection draining configuration for the load balancer.
	// If connection draining is enabled, the load balancer allows existing requests to
	// complete before it shifts traffic away from a deregistered or unhealthy
	// instance.
	ConnectionDraining *AwsElbLoadBalancerConnectionDraining

	// Connection settings for the load balancer. If an idle timeout is configured, the
	// load balancer allows connections to remain idle for the specified duration. When
	// a connection is idle, no data is sent over the connection.
	ConnectionSettings *AwsElbLoadBalancerConnectionSettings

	// Cross-zone load balancing settings for the load balancer. If cross-zone load
	// balancing is enabled, the load balancer routes the request traffic evenly across
	// all instances regardless of the Availability Zones.
	CrossZoneLoadBalancing *AwsElbLoadBalancerCrossZoneLoadBalancing

	noSmithyDocumentSerde
}

// Provides information about the configuration of an EC2 instance for the load
// balancer.
type AwsElbLoadBalancerBackendServerDescription struct {

	// The port on which the EC2 instance is listening.
	InstancePort int32

	// The names of the policies that are enabled for the EC2 instance.
	PolicyNames []string

	noSmithyDocumentSerde
}

// Contains information about the connection draining configuration for the load
// balancer.
type AwsElbLoadBalancerConnectionDraining struct {

	// Indicates whether connection draining is enabled for the load balancer.
	Enabled bool

	// The maximum time, in seconds, to keep the existing connections open before
	// deregistering the instances.
	Timeout int32

	noSmithyDocumentSerde
}

// Contains connection settings for the load balancer.
type AwsElbLoadBalancerConnectionSettings struct {

	// The time, in seconds, that the connection can be idle (no data is sent over the
	// connection) before it is closed by the load balancer.
	IdleTimeout int32

	noSmithyDocumentSerde
}

// Contains cross-zone load balancing settings for the load balancer.
type AwsElbLoadBalancerCrossZoneLoadBalancing struct {

	// Indicates whether cross-zone load balancing is enabled for the load balancer.
	Enabled bool

	noSmithyDocumentSerde
}

// Contains details about a Classic Load Balancer.
type AwsElbLoadBalancerDetails struct {

	// The list of Availability Zones for the load balancer.
	AvailabilityZones []string

	// Information about the configuration of the EC2 instances.
	BackendServerDescriptions []AwsElbLoadBalancerBackendServerDescription

	// The name of the Amazon Route 53 hosted zone for the load balancer.
	CanonicalHostedZoneName *string

	// The ID of the Amazon Route 53 hosted zone for the load balancer.
	CanonicalHostedZoneNameID *string

	// Indicates when the load balancer was created. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedTime *string

	// The DNS name of the load balancer.
	DnsName *string

	// Information about the health checks that are conducted on the load balancer.
	HealthCheck *AwsElbLoadBalancerHealthCheck

	// List of EC2 instances for the load balancer.
	Instances []AwsElbLoadBalancerInstance

	// The policies that are enabled for the load balancer listeners.
	ListenerDescriptions []AwsElbLoadBalancerListenerDescription

	// The attributes for a load balancer.
	LoadBalancerAttributes *AwsElbLoadBalancerAttributes

	// The name of the load balancer.
	LoadBalancerName *string

	// The policies for a load balancer.
	Policies *AwsElbLoadBalancerPolicies

	// The type of load balancer. Only provided if the load balancer is in a VPC. If
	// Scheme is internet-facing, the load balancer has a public DNS name that resolves
	// to a public IP address. If Scheme is internal, the load balancer has a public
	// DNS name that resolves to a private IP address.
	Scheme *string

	// The security groups for the load balancer. Only provided if the load balancer is
	// in a VPC.
	SecurityGroups []string

	// Information about the security group for the load balancer. This is the security
	// group that is used for inbound rules.
	SourceSecurityGroup *AwsElbLoadBalancerSourceSecurityGroup

	// The list of subnet identifiers for the load balancer.
	Subnets []string

	// The identifier of the VPC for the load balancer.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains information about the health checks that are conducted on the load
// balancer.
type AwsElbLoadBalancerHealthCheck struct {

	// The number of consecutive health check successes required before the instance is
	// moved to the Healthy state.
	HealthyThreshold int32

	// The approximate interval, in seconds, between health checks of an individual
	// instance.
	Interval int32

	// The instance that is being checked. The target specifies the protocol and port.
	// The available protocols are TCP, SSL, HTTP, and HTTPS. The range of valid ports
	// is 1 through 65535. For the HTTP and HTTPS protocols, the target also specifies
	// the ping path. For the TCP protocol, the target is specified as TCP: . For the
	// SSL protocol, the target is specified as SSL. . For the HTTP and HTTPS
	// protocols, the target is specified as  :/ .
	Target *string

	// The amount of time, in seconds, during which no response means a failed health
	// check.
	Timeout int32

	// The number of consecutive health check failures that must occur before the
	// instance is moved to the Unhealthy state.
	UnhealthyThreshold int32

	noSmithyDocumentSerde
}

// Provides information about an EC2 instance for a load balancer.
type AwsElbLoadBalancerInstance struct {

	// The instance identifier.
	InstanceId *string

	noSmithyDocumentSerde
}

// Information about a load balancer listener.
type AwsElbLoadBalancerListener struct {

	// The port on which the instance is listening.
	InstancePort int32

	// The protocol to use to route traffic to instances. Valid values: HTTP | HTTPS |
	// TCP | SSL
	InstanceProtocol *string

	// The port on which the load balancer is listening. On EC2-VPC, you can specify
	// any port from the range 1-65535. On EC2-Classic, you can specify any port from
	// the following list: 25, 80, 443, 465, 587, 1024-65535.
	LoadBalancerPort int32

	// The load balancer transport protocol to use for routing. Valid values: HTTP |
	// HTTPS | TCP | SSL
	Protocol *string

	// The ARN of the server certificate.
	SslCertificateId *string

	noSmithyDocumentSerde
}

// Lists the policies that are enabled for a load balancer listener.
type AwsElbLoadBalancerListenerDescription struct {

	// Information about the listener.
	Listener *AwsElbLoadBalancerListener

	// The policies enabled for the listener.
	PolicyNames []string

	noSmithyDocumentSerde
}

// Contains information about the policies for a load balancer.
type AwsElbLoadBalancerPolicies struct {

	// The stickiness policies that are created using CreateAppCookieStickinessPolicy.
	AppCookieStickinessPolicies []AwsElbAppCookieStickinessPolicy

	// The stickiness policies that are created using CreateLBCookieStickinessPolicy.
	LbCookieStickinessPolicies []AwsElbLbCookieStickinessPolicy

	// The policies other than the stickiness policies.
	OtherPolicies []string

	noSmithyDocumentSerde
}

// Contains information about the security group for the load balancer.
type AwsElbLoadBalancerSourceSecurityGroup struct {

	// The name of the security group.
	GroupName *string

	// The owner of the security group.
	OwnerAlias *string

	noSmithyDocumentSerde
}

// A load balancer attribute.
type AwsElbv2LoadBalancerAttribute struct {

	// The name of the load balancer attribute.
	Key *string

	// The value of the load balancer attribute.
	Value *string

	noSmithyDocumentSerde
}

// Information about a load balancer.
type AwsElbv2LoadBalancerDetails struct {

	// The Availability Zones for the load balancer.
	AvailabilityZones []AvailabilityZone

	// The ID of the Amazon Route 53 hosted zone associated with the load balancer.
	CanonicalHostedZoneId *string

	// Indicates when the load balancer was created. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedTime *string

	// The public DNS name of the load balancer.
	DNSName *string

	// The type of IP addresses used by the subnets for your load balancer. The
	// possible values are ipv4 (for IPv4 addresses) and dualstack (for IPv4 and IPv6
	// addresses).
	IpAddressType *string

	// Attributes of the load balancer.
	LoadBalancerAttributes []AwsElbv2LoadBalancerAttribute

	// The nodes of an Internet-facing load balancer have public IP addresses.
	Scheme *string

	// The IDs of the security groups for the load balancer.
	SecurityGroups []string

	// The state of the load balancer.
	State *LoadBalancerState

	// The type of load balancer.
	Type *string

	// The ID of the VPC for the load balancer.
	VpcId *string

	noSmithyDocumentSerde
}

// IAM access key details related to a finding.
type AwsIamAccessKeyDetails struct {

	// The identifier of the access key.
	AccessKeyId *string

	// The Amazon Web Services account ID of the account for the key.
	AccountId *string

	// Indicates when the IAM access key was created. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedAt *string

	// The ID of the principal associated with an access key.
	PrincipalId *string

	// The name of the principal.
	PrincipalName *string

	// The type of principal associated with an access key.
	PrincipalType *string

	// Information about the session that the key was used for.
	SessionContext *AwsIamAccessKeySessionContext

	// The status of the IAM access key related to a finding.
	Status AwsIamAccessKeyStatus

	// The user associated with the IAM access key related to a finding. The UserName
	// parameter has been replaced with the PrincipalName parameter because access keys
	// can also be assigned to principals that are not IAM users.
	//
	// Deprecated: This filter is deprecated. Instead, use PrincipalName.
	UserName *string

	noSmithyDocumentSerde
}

// Provides information about the session that the key was used for.
type AwsIamAccessKeySessionContext struct {

	// Attributes of the session that the key was used for.
	Attributes *AwsIamAccessKeySessionContextAttributes

	// Information about the entity that created the session.
	SessionIssuer *AwsIamAccessKeySessionContextSessionIssuer

	noSmithyDocumentSerde
}

// Attributes of the session that the key was used for.
type AwsIamAccessKeySessionContextAttributes struct {

	// Indicates when the session was created. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreationDate *string

	// Indicates whether the session used multi-factor authentication (MFA).
	MfaAuthenticated bool

	noSmithyDocumentSerde
}

// Information about the entity that created the session.
type AwsIamAccessKeySessionContextSessionIssuer struct {

	// The identifier of the Amazon Web Services account that created the session.
	AccountId *string

	// The ARN of the session.
	Arn *string

	// The principal ID of the principal (user, role, or group) that created the
	// session.
	PrincipalId *string

	// The type of principal (user, role, or group) that created the session.
	Type *string

	// The name of the principal that created the session.
	UserName *string

	noSmithyDocumentSerde
}

// A managed policy that is attached to an IAM principal.
type AwsIamAttachedManagedPolicy struct {

	// The ARN of the policy.
	PolicyArn *string

	// The name of the policy.
	PolicyName *string

	noSmithyDocumentSerde
}

// Contains details about an IAM group.
type AwsIamGroupDetails struct {

	// A list of the managed policies that are attached to the IAM group.
	AttachedManagedPolicies []AwsIamAttachedManagedPolicy

	// Indicates when the IAM group was created. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string

	// The identifier of the IAM group.
	GroupId *string

	// The name of the IAM group.
	GroupName *string

	// The list of inline policies that are embedded in the group.
	GroupPolicyList []AwsIamGroupPolicy

	// The path to the group.
	Path *string

	noSmithyDocumentSerde
}

// A managed policy that is attached to the IAM group.
type AwsIamGroupPolicy struct {

	// The name of the policy.
	PolicyName *string

	noSmithyDocumentSerde
}

// Information about an instance profile.
type AwsIamInstanceProfile struct {

	// The ARN of the instance profile.
	Arn *string

	// Indicates when the instance profile was created. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string

	// The identifier of the instance profile.
	InstanceProfileId *string

	// The name of the instance profile.
	InstanceProfileName *string

	// The path to the instance profile.
	Path *string

	// The roles associated with the instance profile.
	Roles []AwsIamInstanceProfileRole

	noSmithyDocumentSerde
}

// Information about a role associated with an instance profile.
type AwsIamInstanceProfileRole struct {

	// The ARN of the role.
	Arn *string

	// The policy that grants an entity permission to assume the role.
	AssumeRolePolicyDocument *string

	// Indicates when the role was created. Uses the date-time format specified in RFC
	// 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string

	// The path to the role.
	Path *string

	// The identifier of the role.
	RoleId *string

	// The name of the role.
	RoleName *string

	noSmithyDocumentSerde
}

// Information about the policy used to set the permissions boundary for an IAM
// principal.
type AwsIamPermissionsBoundary struct {

	// The ARN of the policy used to set the permissions boundary.
	PermissionsBoundaryArn *string

	// The usage type for the permissions boundary.
	PermissionsBoundaryType *string

	noSmithyDocumentSerde
}

// Represents an IAM permissions policy.
type AwsIamPolicyDetails struct {

	// The number of users, groups, and roles that the policy is attached to.
	AttachmentCount int32

	// When the policy was created. Uses the date-time format specified in RFC 3339
	// section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string

	// The identifier of the default version of the policy.
	DefaultVersionId *string

	// A description of the policy.
	Description *string

	// Whether the policy can be attached to a user, group, or role.
	IsAttachable bool

	// The path to the policy.
	Path *string

	// The number of users and roles that use the policy to set the permissions
	// boundary.
	PermissionsBoundaryUsageCount int32

	// The unique identifier of the policy.
	PolicyId *string

	// The name of the policy.
	PolicyName *string

	// List of versions of the policy.
	PolicyVersionList []AwsIamPolicyVersion

	// When the policy was most recently updated. Uses the date-time format specified
	// in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	UpdateDate *string

	noSmithyDocumentSerde
}

// A version of an IAM policy.
type AwsIamPolicyVersion struct {

	// Indicates when the version was created. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string

	// Whether the version is the default version.
	IsDefaultVersion bool

	// The identifier of the policy version.
	VersionId *string

	noSmithyDocumentSerde
}

// Contains information about an IAM role, including all of the role's policies.
type AwsIamRoleDetails struct {

	// The trust policy that grants permission to assume the role.
	AssumeRolePolicyDocument *string

	// The list of the managed policies that are attached to the role.
	AttachedManagedPolicies []AwsIamAttachedManagedPolicy

	// Indicates when the role was created. Uses the date-time format specified in RFC
	// 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string

	// The list of instance profiles that contain this role.
	InstanceProfileList []AwsIamInstanceProfile

	// The maximum session duration (in seconds) that you want to set for the specified
	// role.
	MaxSessionDuration int32

	// The path to the role.
	Path *string

	// Information about the policy used to set the permissions boundary for an IAM
	// principal.
	PermissionsBoundary *AwsIamPermissionsBoundary

	// The stable and unique string identifying the role.
	RoleId *string

	// The friendly name that identifies the role.
	RoleName *string

	// The list of inline policies that are embedded in the role.
	RolePolicyList []AwsIamRolePolicy

	noSmithyDocumentSerde
}

// An inline policy that is embedded in the role.
type AwsIamRolePolicy struct {

	// The name of the policy.
	PolicyName *string

	noSmithyDocumentSerde
}

// Information about an IAM user.
type AwsIamUserDetails struct {

	// A list of the managed policies that are attached to the user.
	AttachedManagedPolicies []AwsIamAttachedManagedPolicy

	// Indicates when the user was created. Uses the date-time format specified in RFC
	// 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string

	// A list of IAM groups that the user belongs to.
	GroupList []string

	// The path to the user.
	Path *string

	// The permissions boundary for the user.
	PermissionsBoundary *AwsIamPermissionsBoundary

	// The unique identifier for the user.
	UserId *string

	// The name of the user.
	UserName *string

	// The list of inline policies that are embedded in the user.
	UserPolicyList []AwsIamUserPolicy

	noSmithyDocumentSerde
}

// Information about an inline policy that is embedded in the user.
type AwsIamUserPolicy struct {

	// The name of the policy.
	PolicyName *string

	noSmithyDocumentSerde
}

// Contains metadata about an KMS key.
type AwsKmsKeyDetails struct {

	// The twelve-digit account ID of the Amazon Web Services account that owns the KMS
	// key.
	AWSAccountId *string

	// Indicates when the KMS key was created. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreationDate float64

	// A description of the key.
	Description *string

	// The globally unique identifier for the KMS key.
	KeyId *string

	// The manager of the KMS key. KMS keys in your Amazon Web Services account are
	// either customer managed or Amazon Web Services managed.
	KeyManager *string

	// Whether the key has key rotation enabled.
	KeyRotationStatus bool

	// The state of the KMS key.
	KeyState *string

	// The source of the KMS key material. When this value is AWS_KMS, KMS created the
	// key material. When this value is EXTERNAL, the key material was imported from
	// your existing key management infrastructure or the KMS key lacks key material.
	// When this value is AWS_CLOUDHSM, the key material was created in the CloudHSM
	// cluster associated with a custom key store.
	Origin *string

	noSmithyDocumentSerde
}

// The code for the Lambda function. You can specify either an object in Amazon S3,
// or upload a deployment package directly.
type AwsLambdaFunctionCode struct {

	// An Amazon S3 bucket in the same Amazon Web Services Region as your function. The
	// bucket can be in a different Amazon Web Services account.
	S3Bucket *string

	// The Amazon S3 key of the deployment package.
	S3Key *string

	// For versioned objects, the version of the deployment package object to use.
	S3ObjectVersion *string

	// The base64-encoded contents of the deployment package. Amazon Web Services SDK
	// and Amazon Web Services CLI clients handle the encoding for you.
	ZipFile *string

	noSmithyDocumentSerde
}

// The dead-letter queue for failed asynchronous invocations.
type AwsLambdaFunctionDeadLetterConfig struct {

	// The ARN of an SQS queue or SNS topic.
	TargetArn *string

	noSmithyDocumentSerde
}

// Details about a function's configuration.
type AwsLambdaFunctionDetails struct {

	// An AwsLambdaFunctionCode object.
	Code *AwsLambdaFunctionCode

	// The SHA256 hash of the function's deployment package.
	CodeSha256 *string

	// The function's dead letter queue.
	DeadLetterConfig *AwsLambdaFunctionDeadLetterConfig

	// The function's environment variables.
	Environment *AwsLambdaFunctionEnvironment

	// The name of the function.
	FunctionName *string

	// The function that Lambda calls to begin executing your function.
	Handler *string

	// The KMS key that is used to encrypt the function's environment variables. This
	// key is only returned if you've configured a customer managed customer managed
	// key.
	KmsKeyArn *string

	// Indicates when the function was last updated. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	LastModified *string

	// The function's layers.
	Layers []AwsLambdaFunctionLayer

	// For Lambda@Edge functions, the ARN of the master function.
	MasterArn *string

	// The memory that is allocated to the function.
	MemorySize int32

	// The latest updated revision of the function or alias.
	RevisionId *string

	// The function's execution role.
	Role *string

	// The runtime environment for the Lambda function.
	Runtime *string

	// The amount of time that Lambda allows a function to run before stopping it.
	Timeout int32

	// The function's X-Ray tracing configuration.
	TracingConfig *AwsLambdaFunctionTracingConfig

	// The version of the Lambda function.
	Version *string

	// The function's networking configuration.
	VpcConfig *AwsLambdaFunctionVpcConfig

	noSmithyDocumentSerde
}

// A function's environment variable settings.
type AwsLambdaFunctionEnvironment struct {

	// An AwsLambdaFunctionEnvironmentError object.
	Error *AwsLambdaFunctionEnvironmentError

	// Environment variable key-value pairs.
	Variables map[string]string

	noSmithyDocumentSerde
}

// Error messages for environment variables that could not be applied.
type AwsLambdaFunctionEnvironmentError struct {

	// The error code.
	ErrorCode *string

	// The error message.
	Message *string

	noSmithyDocumentSerde
}

// An Lambda layer.
type AwsLambdaFunctionLayer struct {

	// The ARN of the function layer.
	Arn *string

	// The size of the layer archive in bytes.
	CodeSize int32

	noSmithyDocumentSerde
}

// The function's X-Ray tracing configuration.
type AwsLambdaFunctionTracingConfig struct {

	// The tracing mode.
	Mode *string

	noSmithyDocumentSerde
}

// The VPC security groups and subnets that are attached to a Lambda function.
type AwsLambdaFunctionVpcConfig struct {

	// A list of VPC security groups IDs.
	SecurityGroupIds []string

	// A list of VPC subnet IDs.
	SubnetIds []string

	// The ID of the VPC.
	VpcId *string

	noSmithyDocumentSerde
}

// Details about a Lambda layer version.
type AwsLambdaLayerVersionDetails struct {

	// The layer's compatible runtimes. Maximum number of five items. Valid values:
	// nodejs10.x | nodejs12.x | java8 | java11 | python2.7 | python3.6 | python3.7 |
	// python3.8 | dotnetcore1.0 | dotnetcore2.1 | go1.x | ruby2.5 | provided
	CompatibleRuntimes []string

	// Indicates when the version was created. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string

	// The version number.
	Version int64

	noSmithyDocumentSerde
}

// Details about an Network Firewall firewall.
type AwsNetworkFirewallFirewallDetails struct {

	// Whether the firewall is protected from deletion. If set to true, then the
	// firewall cannot be deleted.
	DeleteProtection bool

	// A description of the firewall.
	Description *string

	// The ARN of the firewall.
	FirewallArn *string

	// The identifier of the firewall.
	FirewallId *string

	// A descriptive name of the firewall.
	FirewallName *string

	// The ARN of the firewall policy.
	FirewallPolicyArn *string

	// Whether the firewall is protected from a change to the firewall policy. If set
	// to true, you cannot associate a different policy with the firewall.
	FirewallPolicyChangeProtection bool

	// Whether the firewall is protected from a change to the subnet associations. If
	// set to true, you cannot map different subnets to the firewall.
	SubnetChangeProtection bool

	// The public subnets that Network Firewall uses for the firewall. Each subnet must
	// belong to a different Availability Zone.
	SubnetMappings []AwsNetworkFirewallFirewallSubnetMappingsDetails

	// The identifier of the VPC where the firewall is used.
	VpcId *string

	noSmithyDocumentSerde
}

// Details about a firewall policy. A firewall policy defines the behavior of a
// network firewall.
type AwsNetworkFirewallFirewallPolicyDetails struct {

	// A description of the firewall policy.
	Description *string

	// The firewall policy configuration.
	FirewallPolicy *FirewallPolicyDetails

	// The ARN of the firewall policy.
	FirewallPolicyArn *string

	// The identifier of the firewall policy.
	FirewallPolicyId *string

	// The name of the firewall policy.
	FirewallPolicyName *string

	noSmithyDocumentSerde
}

// A public subnet that Network Firewall uses for the firewall.
type AwsNetworkFirewallFirewallSubnetMappingsDetails struct {

	// The identifier of the subnet
	SubnetId *string

	noSmithyDocumentSerde
}

// Details about an Network Firewall rule group. Rule groups are used to inspect
// and control network traffic. Stateless rule groups apply to individual packets.
// Stateful rule groups apply to packets in the context of their traffic flow. Rule
// groups are referenced in firewall policies.
type AwsNetworkFirewallRuleGroupDetails struct {

	// The maximum number of operating resources that this rule group can use.
	Capacity int32

	// A description of the rule group.
	Description *string

	// Details about the rule group.
	RuleGroup *RuleGroupDetails

	// The ARN of the rule group.
	RuleGroupArn *string

	// The identifier of the rule group.
	RuleGroupId *string

	// The descriptive name of the rule group.
	RuleGroupName *string

	// The type of rule group. A rule group can be stateful or stateless.
	Type *string

	noSmithyDocumentSerde
}

// Details about the configuration of an OpenSearch cluster.
type AwsOpenSearchServiceDomainClusterConfigDetails struct {

	// The number of instances to use for the master node. If this attribute is
	// specified, then DedicatedMasterEnabled must be true.
	DedicatedMasterCount int32

	// Whether to use a dedicated master node for the OpenSearch domain. A dedicated
	// master node performs cluster management tasks, but does not hold data or respond
	// to data upload requests.
	DedicatedMasterEnabled bool

	// The hardware configuration of the computer that hosts the dedicated master node.
	// If this attribute is specified, then DedicatedMasterEnabled must be true.
	DedicatedMasterType *string

	// The number of data nodes to use in the OpenSearch domain.
	InstanceCount int32

	// The instance type for your data nodes.
	InstanceType *string

	// The number of UltraWarm instances.
	WarmCount int32

	// Whether UltraWarm is enabled.
	WarmEnabled bool

	// The type of UltraWarm instance.
	WarmType *string

	// Configuration options for zone awareness. Provided if ZoneAwarenessEnabled is
	// true.
	ZoneAwarenessConfig *AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails

	// Whether to enable zone awareness for the OpenSearch domain. When zone awareness
	// is enabled, OpenSearch Service allocates the cluster's nodes and replica index
	// shards across Availability Zones (AZs) in the same Region. This prevents data
	// loss and minimizes downtime if a node or data center fails.
	ZoneAwarenessEnabled bool

	noSmithyDocumentSerde
}

// Configuration options for zone awareness.
type AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails struct {

	// The number of Availability Zones that the domain uses. Valid values are 2 and 3.
	// The default is 2.
	AvailabilityZoneCount int32

	noSmithyDocumentSerde
}

// Information about an Amazon OpenSearch Service domain.
type AwsOpenSearchServiceDomainDetails struct {

	// IAM policy document that specifies the access policies for the OpenSearch
	// Service domain.
	AccessPolicies *string

	// The ARN of the OpenSearch Service domain.
	Arn *string

	// Details about the configuration of an OpenSearch cluster.
	ClusterConfig *AwsOpenSearchServiceDomainClusterConfigDetails

	// The domain endpoint.
	DomainEndpoint *string

	// Additional options for the domain endpoint.
	DomainEndpointOptions *AwsOpenSearchServiceDomainDomainEndpointOptionsDetails

	// The domain endpoints. Used if the OpenSearch domain resides in a VPC. This is a
	// map of key-value pairs. The key is always vpc. The value is the endpoint.
	DomainEndpoints map[string]string

	// The name of the endpoint.
	DomainName *string

	// Details about the configuration for encryption at rest.
	EncryptionAtRestOptions *AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails

	// The version of the domain engine.
	EngineVersion *string

	// The identifier of the domain.
	Id *string

	// Configures the CloudWatch Logs to publish for the OpenSearch domain.
	LogPublishingOptions *AwsOpenSearchServiceDomainLogPublishingOptionsDetails

	// Details about the configuration for node-to-node encryption.
	NodeToNodeEncryptionOptions *AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails

	// Information about the status of a domain relative to the latest service
	// software.
	ServiceSoftwareOptions *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails

	// Information that OpenSearch Service derives based on VPCOptions for the domain.
	VpcOptions *AwsOpenSearchServiceDomainVpcOptionsDetails

	noSmithyDocumentSerde
}

// Information about additional options for the domain endpoint.
type AwsOpenSearchServiceDomainDomainEndpointOptionsDetails struct {

	// The fully qualified URL for the custom endpoint.
	CustomEndpoint *string

	// The ARN for the security certificate. The certificate is managed in ACM.
	CustomEndpointCertificateArn *string

	// Whether to enable a custom endpoint for the domain.
	CustomEndpointEnabled bool

	// Whether to require that all traffic to the domain arrive over HTTPS.
	EnforceHTTPS bool

	// The TLS security policy to apply to the HTTPS endpoint of the OpenSearch domain.
	TLSSecurityPolicy *string

	noSmithyDocumentSerde
}

// Details about the configuration for encryption at rest for the OpenSearch
// domain.
type AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails struct {

	// Whether encryption at rest is enabled.
	Enabled bool

	// The KMS key ID.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Configuration details for a log publishing option.
type AwsOpenSearchServiceDomainLogPublishingOption struct {

	// The ARN of the CloudWatch Logs group to publish the logs to.
	CloudWatchLogsLogGroupArn *string

	// Whether the log publishing is enabled.
	Enabled bool

	noSmithyDocumentSerde
}

// Configures the CloudWatch Logs to publish for the OpenSearch domain.
type AwsOpenSearchServiceDomainLogPublishingOptionsDetails struct {

	// Configures the OpenSearch audit logs publishing.
	AuditLogs *AwsOpenSearchServiceDomainLogPublishingOption

	// Configures the OpenSearch index logs publishing.
	IndexSlowLogs *AwsOpenSearchServiceDomainLogPublishingOption

	// Configures the OpenSearch search slow log publishing.
	SearchSlowLogs *AwsOpenSearchServiceDomainLogPublishingOption

	noSmithyDocumentSerde
}

// Provides details about the configuration for node-to-node encryption.
type AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails struct {

	// Whether node-to-node encryption is enabled.
	Enabled bool

	noSmithyDocumentSerde
}

// Provides information about the state of the domain relative to the latest
// service software.
type AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails struct {

	// The epoch time when the deployment window closes for required updates. After
	// this time, OpenSearch Service schedules the software upgrade automatically.
	AutomatedUpdateDate *string

	// Whether a request to update the domain can be canceled.
	Cancellable bool

	// The version of the service software that is currently installed on the domain.
	CurrentVersion *string

	// A more detailed description of the service software status.
	Description *string

	// The most recent version of the service software.
	NewVersion *string

	// Whether the service software update is optional.
	OptionalDeployment bool

	// Whether a service software update is available for the domain.
	UpdateAvailable bool

	// The status of the service software update.
	UpdateStatus *string

	noSmithyDocumentSerde
}

// Contains information that OpenSearch Service derives based on the VPCOptions for
// the domain.
type AwsOpenSearchServiceDomainVpcOptionsDetails struct {

	// The list of security group IDs that are associated with the VPC endpoints for
	// the domain.
	SecurityGroupIds []string

	// A list of subnet IDs that are associated with the VPC endpoints for the domain.
	SubnetIds []string

	noSmithyDocumentSerde
}

// An IAM role that is associated with the Amazon RDS DB cluster.
type AwsRdsDbClusterAssociatedRole struct {

	// The ARN of the IAM role.
	RoleArn *string

	// The status of the association between the IAM role and the DB cluster.
	Status *string

	noSmithyDocumentSerde
}

// Information about an Amazon RDS DB cluster.
type AwsRdsDbClusterDetails struct {

	// The status of the database activity stream.
	ActivityStreamStatus *string

	// For all database engines except Aurora, specifies the allocated storage size in
	// gibibytes (GiB).
	AllocatedStorage int32

	// A list of the IAM roles that are associated with the DB cluster.
	AssociatedRoles []AwsRdsDbClusterAssociatedRole

	// A list of Availability Zones (AZs) where instances in the DB cluster can be
	// created.
	AvailabilityZones []string

	// The number of days for which automated backups are retained.
	BackupRetentionPeriod int32

	// Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ClusterCreateTime *string

	// Whether tags are copied from the DB cluster to snapshots of the DB cluster.
	CopyTagsToSnapshot bool

	// Whether the DB cluster is a clone of a DB cluster owned by a different Amazon
	// Web Services account.
	CrossAccountClone bool

	// A list of custom endpoints for the DB cluster.
	CustomEndpoints []string

	// The name of the database.
	DatabaseName *string

	// The DB cluster identifier that the user assigned to the cluster. This identifier
	// is the unique key that identifies a DB cluster.
	DbClusterIdentifier *string

	// The list of instances that make up the DB cluster.
	DbClusterMembers []AwsRdsDbClusterMember

	// The list of option group memberships for this DB cluster.
	DbClusterOptionGroupMemberships []AwsRdsDbClusterOptionGroupMembership

	// The name of the DB cluster parameter group for the DB cluster.
	DbClusterParameterGroup *string

	// The identifier of the DB cluster. The identifier must be unique within each
	// Amazon Web Services Region and is immutable.
	DbClusterResourceId *string

	// The subnet group that is associated with the DB cluster, including the name,
	// description, and subnets in the subnet group.
	DbSubnetGroup *string

	// Whether the DB cluster has deletion protection enabled.
	DeletionProtection bool

	// The Active Directory domain membership records that are associated with the DB
	// cluster.
	DomainMemberships []AwsRdsDbDomainMembership

	// A list of log types that this DB cluster is configured to export to CloudWatch
	// Logs.
	EnabledCloudWatchLogsExports []string

	// The connection endpoint for the primary instance of the DB cluster.
	Endpoint *string

	// The name of the database engine to use for this DB cluster.
	Engine *string

	// The database engine mode of the DB cluster.
	EngineMode *string

	// The version number of the database engine to use.
	EngineVersion *string

	// Specifies the identifier that Amazon Route 53 assigns when you create a hosted
	// zone.
	HostedZoneId *string

	// Whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.
	HttpEndpointEnabled bool

	// Whether the mapping of IAM accounts to database accounts is enabled.
	IamDatabaseAuthenticationEnabled bool

	// The ARN of the KMS master key that is used to encrypt the database instances in
	// the DB cluster.
	KmsKeyId *string

	// The name of the master user for the DB cluster.
	MasterUsername *string

	// Whether the DB cluster has instances in multiple Availability Zones.
	MultiAz bool

	// The port number on which the DB instances in the DB cluster accept connections.
	Port int32

	// The range of time each day when automated backups are created, if automated
	// backups are enabled. Uses the format HH:MM-HH:MM. For example, 04:52-05:22.
	PreferredBackupWindow *string

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC). Uses the format :HH:MM-:HH:MM. For the day values, use
	// mon|tue|wed|thu|fri|sat|sun. For example, sun:09:32-sun:10:02.
	PreferredMaintenanceWindow *string

	// The identifiers of the read replicas that are associated with this DB cluster.
	ReadReplicaIdentifiers []string

	// The reader endpoint for the DB cluster.
	ReaderEndpoint *string

	// The current status of this DB cluster.
	Status *string

	// Whether the DB cluster is encrypted.
	StorageEncrypted bool

	// A list of VPC security groups that the DB cluster belongs to.
	VpcSecurityGroups []AwsRdsDbInstanceVpcSecurityGroup

	noSmithyDocumentSerde
}

// Information about an instance in the DB cluster.
type AwsRdsDbClusterMember struct {

	// The status of the DB cluster parameter group for this member of the DB cluster.
	DbClusterParameterGroupStatus *string

	// The instance identifier for this member of the DB cluster.
	DbInstanceIdentifier *string

	// Whether the cluster member is the primary instance for the DB cluster.
	IsClusterWriter bool

	// Specifies the order in which an Aurora replica is promoted to the primary
	// instance when the existing primary instance fails.
	PromotionTier int32

	noSmithyDocumentSerde
}

// Information about an option group membership for a DB cluster.
type AwsRdsDbClusterOptionGroupMembership struct {

	// The name of the DB cluster option group.
	DbClusterOptionGroupName *string

	// The status of the DB cluster option group.
	Status *string

	noSmithyDocumentSerde
}

// Information about an Amazon RDS DB cluster snapshot.
type AwsRdsDbClusterSnapshotDetails struct {

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage int32

	// A list of Availability Zones where instances in the DB cluster can be created.
	AvailabilityZones []string

	// Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ClusterCreateTime *string

	// The DB cluster identifier.
	DbClusterIdentifier *string

	// The identifier of the DB cluster snapshot.
	DbClusterSnapshotIdentifier *string

	// The name of the database engine that you want to use for this DB instance.
	Engine *string

	// The version of the database engine to use.
	EngineVersion *string

	// Whether mapping of IAM accounts to database accounts is enabled.
	IamDatabaseAuthenticationEnabled bool

	// The ARN of the KMS master key that is used to encrypt the database instances in
	// the DB cluster.
	KmsKeyId *string

	// The license model information for this DB cluster snapshot.
	LicenseModel *string

	// The name of the master user for the DB cluster.
	MasterUsername *string

	// Specifies the percentage of the estimated data that has been transferred.
	PercentProgress int32

	// The port number on which the DB instances in the DB cluster accept connections.
	Port int32

	// Indicates when the snapshot was taken. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	SnapshotCreateTime *string

	// The type of DB cluster snapshot.
	SnapshotType *string

	// The status of this DB cluster snapshot.
	Status *string

	// Whether the DB cluster is encrypted.
	StorageEncrypted bool

	// The VPC ID that is associated with the DB cluster snapshot.
	VpcId *string

	noSmithyDocumentSerde
}

// Information about an Active Directory domain membership record associated with
// the DB instance.
type AwsRdsDbDomainMembership struct {

	// The identifier of the Active Directory domain.
	Domain *string

	// The fully qualified domain name of the Active Directory domain.
	Fqdn *string

	// The name of the IAM role to use when making API calls to the Directory Service.
	IamRoleName *string

	// The status of the Active Directory Domain membership for the DB instance.
	Status *string

	noSmithyDocumentSerde
}

// An IAM role associated with the DB instance.
type AwsRdsDbInstanceAssociatedRole struct {

	// The name of the feature associated with the IAM role.
	FeatureName *string

	// The ARN of the IAM role that is associated with the DB instance.
	RoleArn *string

	// Describes the state of the association between the IAM role and the DB instance.
	// The Status property returns one of the following values:
	//
	// * ACTIVE - The IAM
	// role ARN is associated with the DB instance and can be used to access other
	// Amazon Web Services services on your behalf.
	//
	// * PENDING - The IAM role ARN is
	// being associated with the DB instance.
	//
	// * INVALID - The IAM role ARN is
	// associated with the DB instance. But the DB instance is unable to assume the IAM
	// role in order to access other Amazon Web Services services on your behalf.
	Status *string

	noSmithyDocumentSerde
}

// Contains the details of an Amazon RDS DB instance.
type AwsRdsDbInstanceDetails struct {

	// The amount of storage (in gigabytes) to initially allocate for the DB instance.
	AllocatedStorage int32

	// The IAM roles associated with the DB instance.
	AssociatedRoles []AwsRdsDbInstanceAssociatedRole

	// Indicates whether minor version patches are applied automatically.
	AutoMinorVersionUpgrade bool

	// The Availability Zone where the DB instance will be created.
	AvailabilityZone *string

	// The number of days for which to retain automated backups.
	BackupRetentionPeriod int32

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string

	// The name of the character set that this DB instance is associated with.
	CharacterSetName *string

	// Whether to copy resource tags to snapshots of the DB instance.
	CopyTagsToSnapshot bool

	// If the DB instance is a member of a DB cluster, contains the name of the DB
	// cluster that the DB instance is a member of.
	DBClusterIdentifier *string

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string

	// Contains a user-supplied database identifier. This identifier is the unique key
	// that identifies a DB instance.
	DBInstanceIdentifier *string

	// The meaning of this parameter differs according to the database engine you use.
	// MySQL, MariaDB, SQL Server, PostgreSQL Contains the name of the initial database
	// of this instance that was provided at create time, if one was specified when the
	// DB instance was created. This same name is returned for the life of the DB
	// instance. Oracle Contains the Oracle System ID (SID) of the created DB instance.
	// Not shown when the returned parameters do not apply to an Oracle DB instance.
	DBName *string

	// Specifies the port that the DB instance listens on. If the DB instance is part
	// of a DB cluster, this can be a different port than the DB cluster port.
	DbInstancePort int32

	// The current status of the DB instance.
	DbInstanceStatus *string

	// A list of the DB parameter groups to assign to the DB instance.
	DbParameterGroups []AwsRdsDbParameterGroup

	// A list of the DB security groups to assign to the DB instance.
	DbSecurityGroups []string

	// Information about the subnet group that is associated with the DB instance.
	DbSubnetGroup *AwsRdsDbSubnetGroup

	// The Amazon Web Services Region-unique, immutable identifier for the DB instance.
	// This identifier is found in CloudTrail log entries whenever the KMS key for the
	// DB instance is accessed.
	DbiResourceId *string

	// Indicates whether the DB instance has deletion protection enabled. When deletion
	// protection is enabled, the database cannot be deleted.
	DeletionProtection bool

	// The Active Directory domain membership records associated with the DB instance.
	DomainMemberships []AwsRdsDbDomainMembership

	// A list of log types that this DB instance is configured to export to CloudWatch
	// Logs.
	EnabledCloudWatchLogsExports []string

	// Specifies the connection endpoint.
	Endpoint *AwsRdsDbInstanceEndpoint

	// Provides the name of the database engine to use for this DB instance.
	Engine *string

	// Indicates the database engine version.
	EngineVersion *string

	// The ARN of the CloudWatch Logs log stream that receives the enhanced monitoring
	// metrics data for the DB instance.
	EnhancedMonitoringResourceArn *string

	// True if mapping of IAM accounts to database accounts is enabled, and otherwise
	// false. IAM database authentication can be enabled for the following database
	// engines.
	//
	// * For MySQL 5.6, minor version 5.6.34 or higher
	//
	// * For MySQL 5.7,
	// minor version 5.7.16 or higher
	//
	// * Aurora 5.6 or higher
	IAMDatabaseAuthenticationEnabled bool

	// Indicates when the DB instance was created. Uses the date-time format specified
	// in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	InstanceCreateTime *string

	// Specifies the provisioned IOPS (I/O operations per second) for this DB instance.
	Iops int32

	// If StorageEncrypted is true, the KMS key identifier for the encrypted DB
	// instance.
	KmsKeyId *string

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore. Uses the date-time format specified in RFC 3339 section 5.6, Internet
	// Date/Time Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value
	// cannot contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LatestRestorableTime *string

	// License model information for this DB instance.
	LicenseModel *string

	// Specifies the connection endpoint.
	ListenerEndpoint *AwsRdsDbInstanceEndpoint

	// The master user name of the DB instance.
	MasterUsername *string

	// The upper limit to which Amazon RDS can automatically scale the storage of the
	// DB instance.
	MaxAllocatedStorage int32

	// The interval, in seconds, between points when enhanced monitoring metrics are
	// collected for the DB instance.
	MonitoringInterval int32

	// The ARN for the IAM role that permits Amazon RDS to send enhanced monitoring
	// metrics to CloudWatch Logs.
	MonitoringRoleArn *string

	// Whether the DB instance is a multiple Availability Zone deployment.
	MultiAz bool

	// The list of option group memberships for this DB instance.
	OptionGroupMemberships []AwsRdsDbOptionGroupMembership

	// Changes to the DB instance that are currently pending.
	PendingModifiedValues *AwsRdsDbPendingModifiedValues

	// Indicates whether Performance Insights is enabled for the DB instance.
	PerformanceInsightsEnabled bool

	// The identifier of the KMS key used to encrypt the Performance Insights data.
	PerformanceInsightsKmsKeyId *string

	// The number of days to retain Performance Insights data.
	PerformanceInsightsRetentionPeriod int32

	// The range of time each day when automated backups are created, if automated
	// backups are enabled. Uses the format HH:MM-HH:MM. For example, 04:52-05:22.
	PreferredBackupWindow *string

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC). Uses the format :HH:MM-:HH:MM. For the day values, use
	// mon|tue|wed|thu|fri|sat|sun. For example, sun:09:32-sun:10:02.
	PreferredMaintenanceWindow *string

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	ProcessorFeatures []AwsRdsDbProcessorFeature

	// The order in which to promote an Aurora replica to the primary instance after a
	// failure of the existing primary instance.
	PromotionTier int32

	// Specifies the accessibility options for the DB instance. A value of true
	// specifies an Internet-facing instance with a publicly resolvable DNS name, which
	// resolves to a public IP address. A value of false specifies an internal instance
	// with a DNS name that resolves to a private IP address.
	PubliclyAccessible bool

	// List of identifiers of Aurora DB clusters to which the RDS DB instance is
	// replicated as a read replica.
	ReadReplicaDBClusterIdentifiers []string

	// List of identifiers of the read replicas associated with this DB instance.
	ReadReplicaDBInstanceIdentifiers []string

	// If this DB instance is a read replica, contains the identifier of the source DB
	// instance.
	ReadReplicaSourceDBInstanceIdentifier *string

	// For a DB instance with multi-Availability Zone support, the name of the
	// secondary Availability Zone.
	SecondaryAvailabilityZone *string

	// The status of a read replica. If the instance isn't a read replica, this is
	// empty.
	StatusInfos []AwsRdsDbStatusInfo

	// Specifies whether the DB instance is encrypted.
	StorageEncrypted bool

	// The storage type for the DB instance.
	StorageType *string

	// The ARN from the key store with which the instance is associated for TDE
	// encryption.
	TdeCredentialArn *string

	// The time zone of the DB instance.
	Timezone *string

	// A list of VPC security groups that the DB instance belongs to.
	VpcSecurityGroups []AwsRdsDbInstanceVpcSecurityGroup

	noSmithyDocumentSerde
}

// Specifies the connection endpoint.
type AwsRdsDbInstanceEndpoint struct {

	// Specifies the DNS address of the DB instance.
	Address *string

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string

	// Specifies the port that the database engine is listening on.
	Port int32

	noSmithyDocumentSerde
}

// A VPC security groups that the DB instance belongs to.
type AwsRdsDbInstanceVpcSecurityGroup struct {

	// The status of the VPC security group.
	Status *string

	// The name of the VPC security group.
	VpcSecurityGroupId *string

	noSmithyDocumentSerde
}

// An option group membership.
type AwsRdsDbOptionGroupMembership struct {

	// The name of the option group.
	OptionGroupName *string

	// The status of the option group membership.
	Status *string

	noSmithyDocumentSerde
}

// Provides information about a parameter group for a DB instance.
type AwsRdsDbParameterGroup struct {

	// The name of the parameter group.
	DbParameterGroupName *string

	// The status of parameter updates.
	ParameterApplyStatus *string

	noSmithyDocumentSerde
}

// Changes to a DB instance that are currently pending.
type AwsRdsDbPendingModifiedValues struct {

	// The new value of the allocated storage for the DB instance.
	AllocatedStorage int32

	// The new backup retention period for the DB instance.
	BackupRetentionPeriod int32

	// The new CA certificate identifier for the DB instance.
	CaCertificateIdentifier *string

	// The new DB instance class for the DB instance.
	DbInstanceClass *string

	// The new DB instance identifier for the DB instance.
	DbInstanceIdentifier *string

	// The name of the new subnet group for the DB instance.
	DbSubnetGroupName *string

	// The new engine version for the DB instance.
	EngineVersion *string

	// The new provisioned IOPS value for the DB instance.
	Iops int32

	// The new license model value for the DB instance.
	LicenseModel *string

	// The new master user password for the DB instance.
	MasterUserPassword *string

	// Indicates that a single Availability Zone DB instance is changing to a multiple
	// Availability Zone deployment.
	MultiAZ bool

	// A list of log types that are being enabled or disabled.
	PendingCloudWatchLogsExports *AwsRdsPendingCloudWatchLogsExports

	// The new port for the DB instance.
	Port int32

	// Processor features that are being updated.
	ProcessorFeatures []AwsRdsDbProcessorFeature

	// The new storage type for the DB instance.
	StorageType *string

	noSmithyDocumentSerde
}

// A processor feature.
type AwsRdsDbProcessorFeature struct {

	// The name of the processor feature.
	Name *string

	// The value of the processor feature.
	Value *string

	noSmithyDocumentSerde
}

// Provides details about an Amazon RDS DB cluster snapshot.
type AwsRdsDbSnapshotDetails struct {

	// The amount of storage (in gigabytes) to be initially allocated for the database
	// instance.
	AllocatedStorage int32

	// Specifies the name of the Availability Zone in which the DB instance was located
	// at the time of the DB snapshot.
	AvailabilityZone *string

	// A name for the DB instance.
	DbInstanceIdentifier *string

	// The name or ARN of the DB snapshot that is used to restore the DB instance.
	DbSnapshotIdentifier *string

	// The identifier for the source DB instance.
	DbiResourceId *string

	// Whether the DB snapshot is encrypted.
	Encrypted bool

	// The name of the database engine to use for this DB instance.
	Engine *string

	// The version of the database engine.
	EngineVersion *string

	// Whether mapping of IAM accounts to database accounts is enabled.
	IamDatabaseAuthenticationEnabled bool

	// Specifies the time in Coordinated Universal Time (UTC) when the DB instance,
	// from which the snapshot was taken, was created.
	InstanceCreateTime *string

	// The provisioned IOPS (I/O operations per second) value of the DB instance at the
	// time of the snapshot.
	Iops int32

	// If Encrypted is true, the KMS key identifier for the encrypted DB snapshot.
	KmsKeyId *string

	// License model information for the restored DB instance.
	LicenseModel *string

	// The master user name for the DB snapshot.
	MasterUsername *string

	// The option group name for the DB snapshot.
	OptionGroupName *string

	// The percentage of the estimated data that has been transferred.
	PercentProgress int32

	// The port that the database engine was listening on at the time of the snapshot.
	Port int32

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	ProcessorFeatures []AwsRdsDbProcessorFeature

	// When the snapshot was taken in Coordinated Universal Time (UTC).
	SnapshotCreateTime *string

	// The type of the DB snapshot.
	SnapshotType *string

	// The DB snapshot ARN that the DB snapshot was copied from.
	SourceDbSnapshotIdentifier *string

	// The Amazon Web Services Region that the DB snapshot was created in or copied
	// from.
	SourceRegion *string

	// The status of this DB snapshot.
	Status *string

	// The storage type associated with the DB snapshot.
	StorageType *string

	// The ARN from the key store with which to associate the instance for TDE
	// encryption.
	TdeCredentialArn *string

	// The time zone of the DB snapshot.
	Timezone *string

	// The VPC ID associated with the DB snapshot.
	VpcId *string

	noSmithyDocumentSerde
}

// Information about the status of a read replica.
type AwsRdsDbStatusInfo struct {

	// If the read replica is currently in an error state, provides the error details.
	Message *string

	// Whether the read replica instance is operating normally.
	Normal bool

	// The status of the read replica instance.
	Status *string

	// The type of status. For a read replica, the status type is read replication.
	StatusType *string

	noSmithyDocumentSerde
}

// Information about the subnet group for the database instance.
type AwsRdsDbSubnetGroup struct {

	// The ARN of the subnet group.
	DbSubnetGroupArn *string

	// The description of the subnet group.
	DbSubnetGroupDescription *string

	// The name of the subnet group.
	DbSubnetGroupName *string

	// The status of the subnet group.
	SubnetGroupStatus *string

	// A list of subnets in the subnet group.
	Subnets []AwsRdsDbSubnetGroupSubnet

	// The VPC ID of the subnet group.
	VpcId *string

	noSmithyDocumentSerde
}

// Information about a subnet in a subnet group.
type AwsRdsDbSubnetGroupSubnet struct {

	// Information about the Availability Zone for a subnet in the subnet group.
	SubnetAvailabilityZone *AwsRdsDbSubnetGroupSubnetAvailabilityZone

	// The identifier of a subnet in the subnet group.
	SubnetIdentifier *string

	// The status of a subnet in the subnet group.
	SubnetStatus *string

	noSmithyDocumentSerde
}

// An Availability Zone for a subnet in a subnet group.
type AwsRdsDbSubnetGroupSubnetAvailabilityZone struct {

	// The name of the Availability Zone for a subnet in the subnet group.
	Name *string

	noSmithyDocumentSerde
}

// Details about an Amazon RDS event notification subscription. The subscription
// allows Amazon RDS to post events to an SNS topic.
type AwsRdsEventSubscriptionDetails struct {

	// The identifier of the account that is associated with the event notification
	// subscription.
	CustSubscriptionId *string

	// The identifier of the event notification subscription.
	CustomerAwsId *string

	// Whether the event notification subscription is enabled.
	Enabled bool

	// The list of event categories for the event notification subscription.
	EventCategoriesList []string

	// The ARN of the event notification subscription.
	EventSubscriptionArn *string

	// The ARN of the SNS topic to post the event notifications to.
	SnsTopicArn *string

	// A list of source identifiers for the event notification subscription.
	SourceIdsList []string

	// The source type for the event notification subscription.
	SourceType *string

	// The status of the event notification subscription. Valid values: creating |
	// modifying | deleting | active | no-permission | topic-not-exist
	Status *string

	// The datetime when the event notification subscription was created. Uses the
	// date-time format specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	SubscriptionCreationTime *string

	noSmithyDocumentSerde
}

// Identifies the log types to enable and disable.
type AwsRdsPendingCloudWatchLogsExports struct {

	// A list of log types that are being disabled.
	LogTypesToDisable []string

	// A list of log types that are being enabled.
	LogTypesToEnable []string

	noSmithyDocumentSerde
}

// A node in an Amazon Redshift cluster.
type AwsRedshiftClusterClusterNode struct {

	// The role of the node. A node might be a leader node or a compute node.
	NodeRole *string

	// The private IP address of the node.
	PrivateIpAddress *string

	// The public IP address of the node.
	PublicIpAddress *string

	noSmithyDocumentSerde
}

// A cluster parameter group that is associated with an Amazon Redshift cluster.
type AwsRedshiftClusterClusterParameterGroup struct {

	// The list of parameter statuses.
	ClusterParameterStatusList []AwsRedshiftClusterClusterParameterStatus

	// The status of updates to the parameters.
	ParameterApplyStatus *string

	// The name of the parameter group.
	ParameterGroupName *string

	noSmithyDocumentSerde
}

// The status of a parameter in a cluster parameter group for an Amazon Redshift
// cluster.
type AwsRedshiftClusterClusterParameterStatus struct {

	// The error that prevented the parameter from being applied to the database.
	ParameterApplyErrorDescription *string

	// The status of the parameter. Indicates whether the parameter is in sync with the
	// database, waiting for a cluster reboot, or encountered an error when it was
	// applied. Valid values: in-sync | pending-reboot | applying | invalid-parameter |
	// apply-deferred | apply-error | unknown-error
	ParameterApplyStatus *string

	// The name of the parameter.
	ParameterName *string

	noSmithyDocumentSerde
}

// A security group that is associated with the cluster.
type AwsRedshiftClusterClusterSecurityGroup struct {

	// The name of the cluster security group.
	ClusterSecurityGroupName *string

	// The status of the cluster security group.
	Status *string

	noSmithyDocumentSerde
}

// Information about a cross-Region snapshot copy.
type AwsRedshiftClusterClusterSnapshotCopyStatus struct {

	// The destination Region that snapshots are automatically copied to when
	// cross-Region snapshot copy is enabled.
	DestinationRegion *string

	// The number of days that manual snapshots are retained in the destination region
	// after they are copied from a source region. If the value is -1, then the manual
	// snapshot is retained indefinitely. Valid values: Either -1 or an integer between
	// 1 and 3,653
	ManualSnapshotRetentionPeriod int32

	// The number of days to retain automated snapshots in the destination Region after
	// they are copied from a source Region.
	RetentionPeriod int32

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string

	noSmithyDocumentSerde
}

// A time windows during which maintenance was deferred for an Amazon Redshift
// cluster.
type AwsRedshiftClusterDeferredMaintenanceWindow struct {

	// The end of the time window for which maintenance was deferred. Uses the
	// date-time format specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	DeferMaintenanceEndTime *string

	// The identifier of the maintenance window.
	DeferMaintenanceIdentifier *string

	// The start of the time window for which maintenance was deferred. Uses the
	// date-time format specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	DeferMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// Details about an Amazon Redshift cluster.
type AwsRedshiftClusterDetails struct {

	// Indicates whether major version upgrades are applied automatically to the
	// cluster during the maintenance window.
	AllowVersionUpgrade bool

	// The number of days that automatic cluster snapshots are retained.
	AutomatedSnapshotRetentionPeriod int32

	// The name of the Availability Zone in which the cluster is located.
	AvailabilityZone *string

	// The availability status of the cluster for queries. Possible values are the
	// following:
	//
	// * Available - The cluster is available for queries.
	//
	// * Unavailable -
	// The cluster is not available for queries.
	//
	// * Maintenance - The cluster is
	// intermittently available for queries due to maintenance activities.
	//
	// * Modifying
	// -The cluster is intermittently available for queries due to changes that modify
	// the cluster.
	//
	// * Failed - The cluster failed and is not available for queries.
	ClusterAvailabilityStatus *string

	// Indicates when the cluster was created. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	ClusterCreateTime *string

	// The unique identifier of the cluster.
	ClusterIdentifier *string

	// The nodes in the cluster.
	ClusterNodes []AwsRedshiftClusterClusterNode

	// The list of cluster parameter groups that are associated with this cluster.
	ClusterParameterGroups []AwsRedshiftClusterClusterParameterGroup

	// The public key for the cluster.
	ClusterPublicKey *string

	// The specific revision number of the database in the cluster.
	ClusterRevisionNumber *string

	// A list of cluster security groups that are associated with the cluster.
	ClusterSecurityGroups []AwsRedshiftClusterClusterSecurityGroup

	// Information about the destination Region and retention period for the
	// cross-Region snapshot copy.
	ClusterSnapshotCopyStatus *AwsRedshiftClusterClusterSnapshotCopyStatus

	// The current status of the cluster. Valid values: available | available,
	// prep-for-resize | available, resize-cleanup | cancelling-resize | creating |
	// deleting | final-snapshot | hardware-failure | incompatible-hsm |
	// incompatible-network | incompatible-parameters | incompatible-restore |
	// modifying | paused | rebooting | renaming | resizing | rotating-keys |
	// storage-full | updating-hsm
	ClusterStatus *string

	// The name of the subnet group that is associated with the cluster. This parameter
	// is valid only when the cluster is in a VPC.
	ClusterSubnetGroupName *string

	// The version ID of the Amazon Redshift engine that runs on the cluster.
	ClusterVersion *string

	// The name of the initial database that was created when the cluster was created.
	// The same name is returned for the life of the cluster. If an initial database is
	// not specified, a database named devdev is created by default.
	DBName *string

	// List of time windows during which maintenance was deferred.
	DeferredMaintenanceWindows []AwsRedshiftClusterDeferredMaintenanceWindow

	// Information about the status of the Elastic IP (EIP) address.
	ElasticIpStatus *AwsRedshiftClusterElasticIpStatus

	// The number of nodes that you can use the elastic resize method to resize the
	// cluster to.
	ElasticResizeNumberOfNodeOptions *string

	// Indicates whether the data in the cluster is encrypted at rest.
	Encrypted bool

	// The connection endpoint.
	Endpoint *AwsRedshiftClusterEndpoint

	// Indicates whether to create the cluster with enhanced VPC routing enabled.
	EnhancedVpcRouting bool

	// Indicates when the next snapshot is expected to be taken. The cluster must have
	// a valid snapshot schedule and have backups enabled. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	ExpectedNextSnapshotScheduleTime *string

	// The status of the next expected snapshot. Valid values: OnTrack | Pending
	ExpectedNextSnapshotScheduleTimeStatus *string

	// Information about whether the Amazon Redshift cluster finished applying any
	// changes to hardware security module (HSM) settings that were specified in a
	// modify cluster command.
	HsmStatus *AwsRedshiftClusterHsmStatus

	// A list of IAM roles that the cluster can use to access other Amazon Web Services
	// services.
	IamRoles []AwsRedshiftClusterIamRole

	// The identifier of the KMS encryption key that is used to encrypt data in the
	// cluster.
	KmsKeyId *string

	// The name of the maintenance track for the cluster.
	MaintenanceTrackName *string

	// The default number of days to retain a manual snapshot. If the value is -1, the
	// snapshot is retained indefinitely. This setting doesn't change the retention
	// period of existing snapshots. Valid values: Either -1 or an integer between 1
	// and 3,653
	ManualSnapshotRetentionPeriod int32

	// The master user name for the cluster. This name is used to connect to the
	// database that is specified in as the value of DBName.
	MasterUsername *string

	// Indicates the start of the next maintenance window. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	NextMaintenanceWindowStartTime *string

	// The node type for the nodes in the cluster.
	NodeType *string

	// The number of compute nodes in the cluster.
	NumberOfNodes int32

	// A list of cluster operations that are waiting to start.
	PendingActions []string

	// A list of changes to the cluster that are currently pending.
	PendingModifiedValues *AwsRedshiftClusterPendingModifiedValues

	// The weekly time range, in Universal Coordinated Time (UTC), during which system
	// maintenance can occur. Format:  :HH:MM-:HH:MM For the day values, use mon | tue
	// | wed | thu | fri | sat | sun For example, sun:09:32-sun:10:02
	PreferredMaintenanceWindow *string

	// Whether the cluster can be accessed from a public network.
	PubliclyAccessible bool

	// Information about the resize operation for the cluster.
	ResizeInfo *AwsRedshiftClusterResizeInfo

	// Information about the status of a cluster restore action. Only applies to a
	// cluster that was created by restoring a snapshot.
	RestoreStatus *AwsRedshiftClusterRestoreStatus

	// A unique identifier for the cluster snapshot schedule.
	SnapshotScheduleIdentifier *string

	// The current state of the cluster snapshot schedule. Valid values: MODIFYING |
	// ACTIVE | FAILED
	SnapshotScheduleState *string

	// The identifier of the VPC that the cluster is in, if the cluster is in a VPC.
	VpcId *string

	// The list of VPC security groups that the cluster belongs to, if the cluster is
	// in a VPC.
	VpcSecurityGroups []AwsRedshiftClusterVpcSecurityGroup

	noSmithyDocumentSerde
}

// The status of the elastic IP (EIP) address for an Amazon Redshift cluster.
type AwsRedshiftClusterElasticIpStatus struct {

	// The elastic IP address for the cluster.
	ElasticIp *string

	// The status of the elastic IP address.
	Status *string

	noSmithyDocumentSerde
}

// The connection endpoint for an Amazon Redshift cluster.
type AwsRedshiftClusterEndpoint struct {

	// The DNS address of the cluster.
	Address *string

	// The port that the database engine listens on.
	Port int32

	noSmithyDocumentSerde
}

// Information about whether an Amazon Redshift cluster finished applying any
// hardware changes to security module (HSM) settings that were specified in a
// modify cluster command.
type AwsRedshiftClusterHsmStatus struct {

	// The name of the HSM client certificate that the Amazon Redshift cluster uses to
	// retrieve the data encryption keys that are stored in an HSM.
	HsmClientCertificateIdentifier *string

	// The name of the HSM configuration that contains the information that the Amazon
	// Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string

	// Indicates whether the Amazon Redshift cluster has finished applying any HSM
	// settings changes specified in a modify cluster command. Type: String Valid
	// values: active | applying
	Status *string

	noSmithyDocumentSerde
}

// An IAM role that the cluster can use to access other Amazon Web Services
// services.
type AwsRedshiftClusterIamRole struct {

	// The status of the IAM role's association with the cluster. Valid values: in-sync
	// | adding | removing
	ApplyStatus *string

	// The ARN of the IAM role.
	IamRoleArn *string

	noSmithyDocumentSerde
}

// Changes to the Amazon Redshift cluster that are currently pending.
type AwsRedshiftClusterPendingModifiedValues struct {

	// The pending or in-progress change to the automated snapshot retention period.
	AutomatedSnapshotRetentionPeriod int32

	// The pending or in-progress change to the identifier for the cluster.
	ClusterIdentifier *string

	// The pending or in-progress change to the cluster type.
	ClusterType *string

	// The pending or in-progress change to the service version.
	ClusterVersion *string

	// The encryption type for a cluster.
	EncryptionType *string

	// Indicates whether to create the cluster with enhanced VPC routing enabled.
	EnhancedVpcRouting bool

	// The name of the maintenance track that the cluster changes to during the next
	// maintenance window.
	MaintenanceTrackName *string

	// The pending or in-progress change to the master user password for the cluster.
	MasterUserPassword *string

	// The pending or in-progress change to the cluster's node type.
	NodeType *string

	// The pending or in-progress change to the number of nodes in the cluster.
	NumberOfNodes int32

	// The pending or in-progress change to whether the cluster can be connected to
	// from the public network.
	PubliclyAccessible bool

	noSmithyDocumentSerde
}

// Information about the resize operation for the cluster.
type AwsRedshiftClusterResizeInfo struct {

	// Indicates whether the resize operation can be canceled.
	AllowCancelResize bool

	// The type of resize operation. Valid values: ClassicResize
	ResizeType *string

	noSmithyDocumentSerde
}

// Information about the status of a cluster restore action. It only applies if the
// cluster was created by restoring a snapshot.
type AwsRedshiftClusterRestoreStatus struct {

	// The number of megabytes per second being transferred from the backup storage.
	// Returns the average rate for a completed backup. This field is only updated when
	// you restore to DC2 and DS2 node types.
	CurrentRestoreRateInMegaBytesPerSecond float64

	// The amount of time an in-progress restore has been running, or the amount of
	// time it took a completed restore to finish. This field is only updated when you
	// restore to DC2 and DS2 node types.
	ElapsedTimeInSeconds int64

	// The estimate of the time remaining before the restore is complete. Returns 0 for
	// a completed restore. This field is only updated when you restore to DC2 and DS2
	// node types.
	EstimatedTimeToCompletionInSeconds int64

	// The number of megabytes that were transferred from snapshot storage. This field
	// is only updated when you restore to DC2 and DS2 node types.
	ProgressInMegaBytes int64

	// The size of the set of snapshot data that was used to restore the cluster. This
	// field is only updated when you restore to DC2 and DS2 node types.
	SnapshotSizeInMegaBytes int64

	// The status of the restore action. Valid values: starting | restoring | completed
	// | failed
	Status *string

	noSmithyDocumentSerde
}

// A VPC security group that the cluster belongs to, if the cluster is in a VPC.
type AwsRedshiftClusterVpcSecurityGroup struct {

	// The status of the VPC security group.
	Status *string

	// The identifier of the VPC security group.
	VpcSecurityGroupId *string

	noSmithyDocumentSerde
}

// provides information about the Amazon S3 Public Access Block configuration for
// accounts.
type AwsS3AccountPublicAccessBlockDetails struct {

	// Indicates whether to reject calls to update an S3 bucket if the calls include a
	// public access control list (ACL).
	BlockPublicAcls bool

	// Indicates whether to reject calls to update the access policy for an S3 bucket
	// or access point if the policy allows public access.
	BlockPublicPolicy bool

	// Indicates whether Amazon S3 ignores public ACLs that are associated with an S3
	// bucket.
	IgnorePublicAcls bool

	// Indicates whether to restrict access to an access point or S3 bucket that has a
	// public policy to only Amazon Web Services service principals and authorized
	// users within the S3 bucket owner's account.
	RestrictPublicBuckets bool

	noSmithyDocumentSerde
}

// The lifecycle configuration for the objects in the S3 bucket.
type AwsS3BucketBucketLifecycleConfigurationDetails struct {

	// The lifecycle rules.
	Rules []AwsS3BucketBucketLifecycleConfigurationRulesDetails

	noSmithyDocumentSerde
}

// Information about what Amazon S3 does when a multipart upload is incomplete.
type AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails struct {

	// The number of days after which Amazon S3 cancels an incomplete multipart upload.
	DaysAfterInitiation int32

	noSmithyDocumentSerde
}

// Configuration for a lifecycle rule.
type AwsS3BucketBucketLifecycleConfigurationRulesDetails struct {

	// How Amazon S3 responds when a multipart upload is incomplete. Specifically,
	// provides a number of days before Amazon S3 cancels the entire upload.
	AbortIncompleteMultipartUpload *AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails

	// The date when objects are moved or deleted. Uses the date-time format specified
	// in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	ExpirationDate *string

	// The length in days of the lifetime for objects that are subject to the rule.
	ExpirationInDays int32

	// Whether Amazon S3 removes a delete marker that has no noncurrent versions. If
	// set to true, the delete marker is expired. If set to false, the policy takes no
	// action. If you provide ExpiredObjectDeleteMarker, you cannot provide
	// ExpirationInDays or ExpirationDate.
	ExpiredObjectDeleteMarker bool

	// Identifies the objects that a rule applies to.
	Filter *AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails

	// The unique identifier of the rule.
	ID *string

	// The number of days that an object is noncurrent before Amazon S3 can perform the
	// associated action.
	NoncurrentVersionExpirationInDays int32

	// Transition rules that describe when noncurrent objects transition to a specified
	// storage class.
	NoncurrentVersionTransitions []AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails

	// A prefix that identifies one or more objects that the rule applies to.
	Prefix *string

	// The current status of the rule. Indicates whether the rule is currently being
	// applied.
	Status *string

	// Transition rules that indicate when objects transition to a specified storage
	// class.
	Transitions []AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails

	noSmithyDocumentSerde
}

// Identifies the objects that a rule applies to.
type AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails struct {

	// The configuration for the filter.
	Predicate *AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails

	noSmithyDocumentSerde
}

// The configuration for the filter.
type AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails struct {

	// The values to use for the filter.
	Operands []AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails

	// A prefix filter.
	Prefix *string

	// A tag filter.
	Tag *AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails

	// Whether to use AND or OR to join the operands.
	Type *string

	noSmithyDocumentSerde
}

// A value to use for the filter.
type AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails struct {

	// Prefix text for matching objects.
	Prefix *string

	// A tag that is assigned to matching objects.
	Tag *AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails

	// The type of filter value.
	Type *string

	noSmithyDocumentSerde
}

// A tag that is assigned to matching objects.
type AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails struct {

	// The tag key.
	Key *string

	// The tag value.
	Value *string

	noSmithyDocumentSerde
}

// A tag filter.
type AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails struct {

	// The tag key.
	Key *string

	// The tag value
	Value *string

	noSmithyDocumentSerde
}

// A transition rule that describes when noncurrent objects transition to a
// specified storage class.
type AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails struct {

	// The number of days that an object is noncurrent before Amazon S3 can perform the
	// associated action.
	Days int32

	// The class of storage to change the object to after the object is noncurrent for
	// the specified number of days.
	StorageClass *string

	noSmithyDocumentSerde
}

// A rule for when objects transition to specific storage classes.
type AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails struct {

	// A date on which to transition objects to the specified storage class. If you
	// provide Date, you cannot provide Days. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	Date *string

	// The number of days after which to transition the object to the specified storage
	// class. If you provide Days, you cannot provide Date.
	Days int32

	// The storage class to transition the object to.
	StorageClass *string

	noSmithyDocumentSerde
}

// Describes the versioning state of an S3 bucket.
type AwsS3BucketBucketVersioningConfiguration struct {

	// Specifies whether MFA delete is currently enabled in the S3 bucket versioning
	// configuration. If the S3 bucket was never configured with MFA delete, then this
	// attribute is not included.
	IsMfaDeleteEnabled bool

	// The versioning status of the S3 bucket.
	Status *string

	noSmithyDocumentSerde
}

// The details of an Amazon S3 bucket.
type AwsS3BucketDetails struct {

	// The access control list for the S3 bucket.
	AccessControlList *string

	// The lifecycle configuration for objects in the S3 bucket.
	BucketLifecycleConfiguration *AwsS3BucketBucketLifecycleConfigurationDetails

	// The logging configuration for the S3 bucket.
	BucketLoggingConfiguration *AwsS3BucketLoggingConfiguration

	// The notification configuration for the S3 bucket.
	BucketNotificationConfiguration *AwsS3BucketNotificationConfiguration

	// The versioning state of an S3 bucket.
	BucketVersioningConfiguration *AwsS3BucketBucketVersioningConfiguration

	// The website configuration parameters for the S3 bucket.
	BucketWebsiteConfiguration *AwsS3BucketWebsiteConfiguration

	// Indicates when the S3 bucket was created. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedAt *string

	// The Amazon Web Services account identifier of the account that owns the S3
	// bucket.
	OwnerAccountId *string

	// The canonical user ID of the owner of the S3 bucket.
	OwnerId *string

	// The display name of the owner of the S3 bucket.
	OwnerName *string

	// Provides information about the Amazon S3 Public Access Block configuration for
	// the S3 bucket.
	PublicAccessBlockConfiguration *AwsS3AccountPublicAccessBlockDetails

	// The encryption rules that are applied to the S3 bucket.
	ServerSideEncryptionConfiguration *AwsS3BucketServerSideEncryptionConfiguration

	noSmithyDocumentSerde
}

// Information about logging for the S3 bucket
type AwsS3BucketLoggingConfiguration struct {

	// The name of the S3 bucket where log files for the S3 bucket are stored.
	DestinationBucketName *string

	// The prefix added to log files for the S3 bucket.
	LogFilePrefix *string

	noSmithyDocumentSerde
}

// The notification configuration for the S3 bucket.
type AwsS3BucketNotificationConfiguration struct {

	// Configurations for S3 bucket notifications.
	Configurations []AwsS3BucketNotificationConfigurationDetail

	noSmithyDocumentSerde
}

// Details for an S3 bucket notification configuration.
type AwsS3BucketNotificationConfigurationDetail struct {

	// The ARN of the Lambda function, Amazon SQS queue, or Amazon SNS topic that
	// generates the notification.
	Destination *string

	// The list of events that trigger a notification.
	Events []string

	// The filters that determine which S3 buckets generate notifications.
	Filter *AwsS3BucketNotificationConfigurationFilter

	// Indicates the type of notification. Notifications can be generated using Lambda
	// functions, Amazon SQS queues or Amazon SNS topics.
	Type *string

	noSmithyDocumentSerde
}

// Filtering information for the notifications. The filtering is based on Amazon S3
// key names.
type AwsS3BucketNotificationConfigurationFilter struct {

	// Details for an Amazon S3 filter.
	S3KeyFilter *AwsS3BucketNotificationConfigurationS3KeyFilter

	noSmithyDocumentSerde
}

// Details for an Amazon S3 filter.
type AwsS3BucketNotificationConfigurationS3KeyFilter struct {

	// The filter rules for the filter.
	FilterRules []AwsS3BucketNotificationConfigurationS3KeyFilterRule

	noSmithyDocumentSerde
}

// Details for a filter rule.
type AwsS3BucketNotificationConfigurationS3KeyFilterRule struct {

	// Indicates whether the filter is based on the prefix or suffix of the Amazon S3
	// key.
	Name AwsS3BucketNotificationConfigurationS3KeyFilterRuleName

	// The filter value.
	Value *string

	noSmithyDocumentSerde
}

// Specifies the default server-side encryption to apply to new objects in the
// bucket.
type AwsS3BucketServerSideEncryptionByDefault struct {

	// KMS key ID to use for the default encryption.
	KMSMasterKeyID *string

	// Server-side encryption algorithm to use for the default encryption.
	SSEAlgorithm *string

	noSmithyDocumentSerde
}

// The encryption configuration for the S3 bucket.
type AwsS3BucketServerSideEncryptionConfiguration struct {

	// The encryption rules that are applied to the S3 bucket.
	Rules []AwsS3BucketServerSideEncryptionRule

	noSmithyDocumentSerde
}

// An encryption rule to apply to the S3 bucket.
type AwsS3BucketServerSideEncryptionRule struct {

	// Specifies the default server-side encryption to apply to new objects in the
	// bucket. If a PUT object request doesn't specify any server-side encryption, this
	// default encryption is applied.
	ApplyServerSideEncryptionByDefault *AwsS3BucketServerSideEncryptionByDefault

	noSmithyDocumentSerde
}

// Website parameters for the S3 bucket.
type AwsS3BucketWebsiteConfiguration struct {

	// The name of the error document for the website.
	ErrorDocument *string

	// The name of the index document for the website.
	IndexDocumentSuffix *string

	// The redirect behavior for requests to the website.
	RedirectAllRequestsTo *AwsS3BucketWebsiteConfigurationRedirectTo

	// The rules for applying redirects for requests to the website.
	RoutingRules []AwsS3BucketWebsiteConfigurationRoutingRule

	noSmithyDocumentSerde
}

// The redirect behavior for requests to the website.
type AwsS3BucketWebsiteConfigurationRedirectTo struct {

	// The name of the host to redirect requests to.
	Hostname *string

	// The protocol to use when redirecting requests. By default, uses the same
	// protocol as the original request.
	Protocol *string

	noSmithyDocumentSerde
}

// A rule for redirecting requests to the website.
type AwsS3BucketWebsiteConfigurationRoutingRule struct {

	// Provides the condition that must be met in order to apply the routing rule.
	Condition *AwsS3BucketWebsiteConfigurationRoutingRuleCondition

	// Provides the rules to redirect the request if the condition in Condition is met.
	Redirect *AwsS3BucketWebsiteConfigurationRoutingRuleRedirect

	noSmithyDocumentSerde
}

// The condition that must be met in order to apply the routing rule.
type AwsS3BucketWebsiteConfigurationRoutingRuleCondition struct {

	// Indicates to redirect the request if the HTTP error code matches this value.
	HttpErrorCodeReturnedEquals *string

	// Indicates to redirect the request if the key prefix matches this value.
	KeyPrefixEquals *string

	noSmithyDocumentSerde
}

// The rules to redirect the request if the condition in Condition is met.
type AwsS3BucketWebsiteConfigurationRoutingRuleRedirect struct {

	// The host name to use in the redirect request.
	Hostname *string

	// The HTTP redirect code to use in the response.
	HttpRedirectCode *string

	// The protocol to use to redirect the request. By default, uses the protocol from
	// the original request.
	Protocol *string

	// The object key prefix to use in the redirect request. Cannot be provided if
	// ReplaceKeyWith is present.
	ReplaceKeyPrefixWith *string

	// The specific object key to use in the redirect request. Cannot be provided if
	// ReplaceKeyPrefixWith is present.
	ReplaceKeyWith *string

	noSmithyDocumentSerde
}

// Details about an Amazon S3 object.
type AwsS3ObjectDetails struct {

	// A standard MIME type describing the format of the object data.
	ContentType *string

	// The opaque identifier assigned by a web server to a specific version of a
	// resource found at a URL.
	ETag *string

	// Indicates when the object was last modified. Uses the date-time format specified
	// in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	LastModified *string

	// The identifier of the KMS symmetric customer managed key that was used for the
	// object.
	SSEKMSKeyId *string

	// If the object is stored using server-side encryption, the value of the
	// server-side encryption algorithm used when storing this object in Amazon S3.
	ServerSideEncryption *string

	// The version of the object.
	VersionId *string

	noSmithyDocumentSerde
}

// Details about an Secrets Manager secret.
type AwsSecretsManagerSecretDetails struct {

	// Whether the secret is deleted.
	Deleted bool

	// The user-provided description of the secret.
	Description *string

	// The ARN, Key ID, or alias of the KMS key used to encrypt the SecretString or
	// SecretBinary values for versions of this secret.
	KmsKeyId *string

	// The name of the secret.
	Name *string

	// Whether rotation is enabled.
	RotationEnabled bool

	// The ARN of the Lambda function that rotates the secret.
	RotationLambdaArn *string

	// Whether the rotation occurred within the specified rotation frequency.
	RotationOccurredWithinFrequency bool

	// Defines the rotation schedule for the secret.
	RotationRules *AwsSecretsManagerSecretRotationRules

	noSmithyDocumentSerde
}

// Defines the rotation schedule for the secret.
type AwsSecretsManagerSecretRotationRules struct {

	// The number of days after the previous rotation to rotate the secret.
	AutomaticallyAfterDays int32

	noSmithyDocumentSerde
}

// Provides consistent format for the contents of the Security Hub-aggregated
// findings. AwsSecurityFinding format enables you to share findings between Amazon
// Web Services security services and third-party solutions, and security standards
// checks. A finding is a potential security issue generated either by Amazon Web
// Services services or by the integrated third-party solutions and standards
// checks.
type AwsSecurityFinding struct {

	// The Amazon Web Services account ID that a finding is generated in.
	//
	// This member is required.
	AwsAccountId *string

	// Indicates when the security-findings provider created the potential security
	// issue that a finding captured. Uses the date-time format specified in RFC 3339
	// section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	//
	// This member is required.
	CreatedAt *string

	// A finding's description. In this release, Description is a required property.
	//
	// This member is required.
	Description *string

	// The identifier for the solution-specific component (a discrete unit of logic)
	// that generated a finding. In various security-findings providers' solutions,
	// this generator can be called a rule, a check, a detector, a plugin, etc.
	//
	// This member is required.
	GeneratorId *string

	// The security findings provider-specific identifier for a finding.
	//
	// This member is required.
	Id *string

	// The ARN generated by Security Hub that uniquely identifies a product that
	// generates findings. This can be the ARN for a third-party product that is
	// integrated with Security Hub, or the ARN for a custom integration.
	//
	// This member is required.
	ProductArn *string

	// A set of resource data types that describe the resources that the finding refers
	// to.
	//
	// This member is required.
	Resources []Resource

	// The schema version that a finding is formatted for.
	//
	// This member is required.
	SchemaVersion *string

	// A finding's title. In this release, Title is a required property.
	//
	// This member is required.
	Title *string

	// Indicates when the security-findings provider last updated the finding record.
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	//
	// This member is required.
	UpdatedAt *string

	// Provides details about an action that affects or that was taken on a resource.
	Action *Action

	// The name of the company for the product that generated the finding. Security Hub
	// populates this attribute automatically for each finding. You cannot be updated
	// using BatchImportFindings or BatchUpdateFindings. The exception to this is when
	// you use a custom integration. When you use the Security Hub console to filter
	// findings by company name, you use this attribute. When you use the Security Hub
	// API to filter findings by company name, you use the aws/securityhub/CompanyName
	// attribute under ProductFields. Security Hub does not synchronize those two
	// attributes.
	CompanyName *string

	// This data type is exclusive to findings that are generated as the result of a
	// check run against a specific rule in a supported security standard, such as CIS
	// Amazon Web Services Foundations. Contains security standard-related finding
	// details.
	Compliance *Compliance

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero
	// percent confidence and 100 means 100 percent confidence.
	Confidence int32

	// The level of importance assigned to the resources associated with the finding. A
	// score of 0 means that the underlying resources have no criticality, and a score
	// of 100 is reserved for the most critical resources.
	Criticality int32

	// In a BatchImportFindings request, finding providers use FindingProviderFields to
	// provide and update their own values for confidence, criticality, related
	// findings, severity, and types.
	FindingProviderFields *FindingProviderFields

	// Indicates when the security-findings provider first observed the potential
	// security issue that a finding captured. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	FirstObservedAt *string

	// Indicates when the security-findings provider most recently observed the
	// potential security issue that a finding captured. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	LastObservedAt *string

	// A list of malware related to a finding.
	Malware []Malware

	// The details of network-related information about a finding.
	Network *Network

	// Provides information about a network path that is relevant to a finding. Each
	// entry under NetworkPath represents a component of that path.
	NetworkPath []NetworkPathComponent

	// A user-defined note added to a finding.
	Note *Note

	// Provides an overview of the patch compliance status for an instance against a
	// selected compliance standard.
	PatchSummary *PatchSummary

	// The details of process-related information about a finding.
	Process *ProcessDetails

	// A data type where security-findings providers can include additional
	// solution-specific details that aren't part of the defined AwsSecurityFinding
	// format. Can contain up to 50 key-value pairs. For each key-value pair, the key
	// can contain up to 128 characters, and the value can contain up to 2048
	// characters.
	ProductFields map[string]string

	// The name of the product that generated the finding. Security Hub populates this
	// attribute automatically for each finding. You cannot update it using
	// BatchImportFindings or BatchUpdateFindings. The exception to this is when you
	// use a custom integration. When you use the Security Hub console to filter
	// findings by product name, you use this attribute. When you use the Security Hub
	// API to filter findings by product name, you use the aws/securityhub/ProductName
	// attribute under ProductFields. Security Hub does not synchronize those two
	// attributes.
	ProductName *string

	// The record state of a finding.
	RecordState RecordState

	// The Region from which the finding was generated. Security Hub populates this
	// attribute automatically for each finding. You cannot update it using
	// BatchImportFindings or BatchUpdateFindings.
	Region *string

	// A list of related findings.
	RelatedFindings []RelatedFinding

	// A data type that describes the remediation options for a finding.
	Remediation *Remediation

	// A finding's severity.
	Severity *Severity

	// A URL that links to a page about the current finding in the security-findings
	// provider's solution.
	SourceUrl *string

	// Threat intelligence details related to a finding.
	ThreatIntelIndicators []ThreatIntelIndicator

	// One or more finding types in the format of namespace/category/classifier that
	// classify a finding. Valid namespace values are: Software and Configuration
	// Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications
	Types []string

	// A list of name/value string pairs associated with the finding. These are custom,
	// user-defined fields added to a finding.
	UserDefinedFields map[string]string

	// Indicates the veracity of a finding.
	VerificationState VerificationState

	// Provides a list of vulnerabilities associated with the findings.
	Vulnerabilities []Vulnerability

	// Provides information about the status of the investigation into a finding.
	Workflow *Workflow

	// The workflow state of a finding.
	//
	// Deprecated: This filter is deprecated. Instead, use SeverityLabel or
	// FindingProviderFieldsSeverityLabel.
	WorkflowState WorkflowState

	noSmithyDocumentSerde
}

// A collection of attributes that are applied to all active Security
// Hub-aggregated findings and that result in a subset of findings that are
// included in this insight. You can filter by up to 10 finding attributes. For
// each attribute, you can provide up to 20 filter values.
type AwsSecurityFindingFilters struct {

	// The Amazon Web Services account ID that a finding is generated in.
	AwsAccountId []StringFilter

	// The name of the findings provider (company) that owns the solution (product)
	// that generates findings. Note that this is a filter against the
	// aws/securityhub/CompanyName field in ProductFields. It is not a filter for the
	// top-level CompanyName field.
	CompanyName []StringFilter

	// Exclusive to findings that are generated as the result of a check run against a
	// specific rule in a supported standard, such as CIS Amazon Web Services
	// Foundations. Contains security standard-related finding details.
	ComplianceStatus []StringFilter

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero
	// percent confidence and 100 means 100 percent confidence.
	Confidence []NumberFilter

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider captured the potential security issue that a finding captured.
	CreatedAt []DateFilter

	// The level of importance assigned to the resources associated with the finding. A
	// score of 0 means that the underlying resources have no criticality, and a score
	// of 100 is reserved for the most critical resources.
	Criticality []NumberFilter

	// A finding's description.
	Description []StringFilter

	// The finding provider value for the finding confidence. Confidence is defined as
	// the likelihood that a finding accurately identifies the behavior or issue that
	// it was intended to identify. Confidence is scored on a 0-100 basis using a ratio
	// scale, where 0 means zero percent confidence and 100 means 100 percent
	// confidence.
	FindingProviderFieldsConfidence []NumberFilter

	// The finding provider value for the level of importance assigned to the resources
	// associated with the findings. A score of 0 means that the underlying resources
	// have no criticality, and a score of 100 is reserved for the most critical
	// resources.
	FindingProviderFieldsCriticality []NumberFilter

	// The finding identifier of a related finding that is identified by the finding
	// provider.
	FindingProviderFieldsRelatedFindingsId []StringFilter

	// The ARN of the solution that generated a related finding that is identified by
	// the finding provider.
	FindingProviderFieldsRelatedFindingsProductArn []StringFilter

	// The finding provider value for the severity label.
	FindingProviderFieldsSeverityLabel []StringFilter

	// The finding provider's original value for the severity.
	FindingProviderFieldsSeverityOriginal []StringFilter

	// One or more finding types that the finding provider assigned to the finding.
	// Uses the format of namespace/category/classifier that classify a finding. Valid
	// namespace values are: Software and Configuration Checks | TTPs | Effects |
	// Unusual Behaviors | Sensitive Data Identifications
	FindingProviderFieldsTypes []StringFilter

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider first observed the potential security issue that a finding captured.
	FirstObservedAt []DateFilter

	// The identifier for the solution-specific component (a discrete unit of logic)
	// that generated a finding. In various security-findings providers' solutions,
	// this generator can be called a rule, a check, a detector, a plugin, etc.
	GeneratorId []StringFilter

	// The security findings provider-specific identifier for a finding.
	Id []StringFilter

	// A keyword for a finding.
	//
	// Deprecated: The Keyword property is deprecated.
	Keyword []KeywordFilter

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider most recently observed the potential security issue that a finding
	// captured.
	LastObservedAt []DateFilter

	// The name of the malware that was observed.
	MalwareName []StringFilter

	// The filesystem path of the malware that was observed.
	MalwarePath []StringFilter

	// The state of the malware that was observed.
	MalwareState []StringFilter

	// The type of the malware that was observed.
	MalwareType []StringFilter

	// The destination domain of network-related information about a finding.
	NetworkDestinationDomain []StringFilter

	// The destination IPv4 address of network-related information about a finding.
	NetworkDestinationIpV4 []IpFilter

	// The destination IPv6 address of network-related information about a finding.
	NetworkDestinationIpV6 []IpFilter

	// The destination port of network-related information about a finding.
	NetworkDestinationPort []NumberFilter

	// Indicates the direction of network traffic associated with a finding.
	NetworkDirection []StringFilter

	// The protocol of network-related information about a finding.
	NetworkProtocol []StringFilter

	// The source domain of network-related information about a finding.
	NetworkSourceDomain []StringFilter

	// The source IPv4 address of network-related information about a finding.
	NetworkSourceIpV4 []IpFilter

	// The source IPv6 address of network-related information about a finding.
	NetworkSourceIpV6 []IpFilter

	// The source media access control (MAC) address of network-related information
	// about a finding.
	NetworkSourceMac []StringFilter

	// The source port of network-related information about a finding.
	NetworkSourcePort []NumberFilter

	// The text of a note.
	NoteText []StringFilter

	// The timestamp of when the note was updated.
	NoteUpdatedAt []DateFilter

	// The principal that created a note.
	NoteUpdatedBy []StringFilter

	// The date/time that the process was launched.
	ProcessLaunchedAt []DateFilter

	// The name of the process.
	ProcessName []StringFilter

	// The parent process ID.
	ProcessParentPid []NumberFilter

	// The path to the process executable.
	ProcessPath []StringFilter

	// The process ID.
	ProcessPid []NumberFilter

	// The date/time that the process was terminated.
	ProcessTerminatedAt []DateFilter

	// The ARN generated by Security Hub that uniquely identifies a third-party company
	// (security findings provider) after this provider's product (solution that
	// generates findings) is registered with Security Hub.
	ProductArn []StringFilter

	// A data type where security-findings providers can include additional
	// solution-specific details that aren't part of the defined AwsSecurityFinding
	// format.
	ProductFields []MapFilter

	// The name of the solution (product) that generates findings. Note that this is a
	// filter against the aws/securityhub/ProductName field in ProductFields. It is not
	// a filter for the top-level ProductName field.
	ProductName []StringFilter

	// The recommendation of what to do about the issue described in a finding.
	RecommendationText []StringFilter

	// The updated record state for the finding.
	RecordState []StringFilter

	// The Region from which the finding was generated.
	Region []StringFilter

	// The solution-generated identifier for a related finding.
	RelatedFindingsId []StringFilter

	// The ARN of the solution that generated a related finding.
	RelatedFindingsProductArn []StringFilter

	// The IAM profile ARN of the instance.
	ResourceAwsEc2InstanceIamInstanceProfileArn []StringFilter

	// The Amazon Machine Image (AMI) ID of the instance.
	ResourceAwsEc2InstanceImageId []StringFilter

	// The IPv4 addresses associated with the instance.
	ResourceAwsEc2InstanceIpV4Addresses []IpFilter

	// The IPv6 addresses associated with the instance.
	ResourceAwsEc2InstanceIpV6Addresses []IpFilter

	// The key name associated with the instance.
	ResourceAwsEc2InstanceKeyName []StringFilter

	// The date and time the instance was launched.
	ResourceAwsEc2InstanceLaunchedAt []DateFilter

	// The identifier of the subnet that the instance was launched in.
	ResourceAwsEc2InstanceSubnetId []StringFilter

	// The instance type of the instance.
	ResourceAwsEc2InstanceType []StringFilter

	// The identifier of the VPC that the instance was launched in.
	ResourceAwsEc2InstanceVpcId []StringFilter

	// The creation date/time of the IAM access key related to a finding.
	ResourceAwsIamAccessKeyCreatedAt []DateFilter

	// The name of the principal that is associated with an IAM access key.
	ResourceAwsIamAccessKeyPrincipalName []StringFilter

	// The status of the IAM access key related to a finding.
	ResourceAwsIamAccessKeyStatus []StringFilter

	// The user associated with the IAM access key related to a finding.
	//
	// Deprecated: This filter is deprecated. Instead, use
	// ResourceAwsIamAccessKeyPrincipalName.
	ResourceAwsIamAccessKeyUserName []StringFilter

	// The name of an IAM user.
	ResourceAwsIamUserUserName []StringFilter

	// The canonical user ID of the owner of the S3 bucket.
	ResourceAwsS3BucketOwnerId []StringFilter

	// The display name of the owner of the S3 bucket.
	ResourceAwsS3BucketOwnerName []StringFilter

	// The identifier of the image related to a finding.
	ResourceContainerImageId []StringFilter

	// The name of the image related to a finding.
	ResourceContainerImageName []StringFilter

	// The date/time that the container was started.
	ResourceContainerLaunchedAt []DateFilter

	// The name of the container related to a finding.
	ResourceContainerName []StringFilter

	// The details of a resource that doesn't have a specific subfield for the resource
	// type defined.
	ResourceDetailsOther []MapFilter

	// The canonical identifier for the given resource type.
	ResourceId []StringFilter

	// The canonical Amazon Web Services partition name that the Region is assigned to.
	ResourcePartition []StringFilter

	// The canonical Amazon Web Services external Region name where this resource is
	// located.
	ResourceRegion []StringFilter

	// A list of Amazon Web Services tags associated with a resource at the time the
	// finding was processed.
	ResourceTags []MapFilter

	// Specifies the type of the resource that details are provided for.
	ResourceType []StringFilter

	// The label of a finding's severity.
	SeverityLabel []StringFilter

	// The normalized severity of a finding.
	//
	// Deprecated: This filter is deprecated. Instead, use SeverityLabel or
	// FindingProviderFieldsSeverityLabel.
	SeverityNormalized []NumberFilter

	// The native severity as defined by the security-findings provider's solution that
	// generated the finding.
	//
	// Deprecated: This filter is deprecated. Instead, use
	// FindingProviderSeverityOriginal.
	SeverityProduct []NumberFilter

	// A URL that links to a page about the current finding in the security-findings
	// provider's solution.
	SourceUrl []StringFilter

	// The category of a threat intelligence indicator.
	ThreatIntelIndicatorCategory []StringFilter

	// The date/time of the last observation of a threat intelligence indicator.
	ThreatIntelIndicatorLastObservedAt []DateFilter

	// The source of the threat intelligence.
	ThreatIntelIndicatorSource []StringFilter

	// The URL for more details from the source of the threat intelligence.
	ThreatIntelIndicatorSourceUrl []StringFilter

	// The type of a threat intelligence indicator.
	ThreatIntelIndicatorType []StringFilter

	// The value of a threat intelligence indicator.
	ThreatIntelIndicatorValue []StringFilter

	// A finding's title.
	Title []StringFilter

	// A finding type in the format of namespace/category/classifier that classifies a
	// finding.
	Type []StringFilter

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider last updated the finding record.
	UpdatedAt []DateFilter

	// A list of name/value string pairs associated with the finding. These are custom,
	// user-defined fields added to a finding.
	UserDefinedFields []MapFilter

	// The veracity of a finding.
	VerificationState []StringFilter

	// The workflow state of a finding. Note that this field is deprecated. To search
	// for a finding based on its workflow status, use WorkflowStatus.
	WorkflowState []StringFilter

	// The status of the investigation into a finding. Allowed values are the
	// following.
	//
	// * NEW - The initial state of a finding, before it is reviewed.
	// Security Hub also resets the workflow status from NOTIFIED or RESOLVED to NEW in
	// the following cases:
	//
	// * RecordState changes from ARCHIVED to ACTIVE.
	//
	// *
	// Compliance.Status changes from PASSED to either WARNING, FAILED, or
	// NOT_AVAILABLE.
	//
	// * NOTIFIED - Indicates that the resource owner has been notified
	// about the security issue. Used when the initial reviewer is not the resource
	// owner, and needs intervention from the resource owner. If one of the following
	// occurs, the workflow status is changed automatically from NOTIFIED to NEW:
	//
	// *
	// RecordState changes from ARCHIVED to ACTIVE.
	//
	// * Compliance.Status changes from
	// PASSED to FAILED, WARNING, or NOT_AVAILABLE.
	//
	// * SUPPRESSED - Indicates that you
	// reviewed the finding and do not believe that any action is needed. The workflow
	// status of a SUPPRESSED finding does not change if RecordState changes from
	// ARCHIVED to ACTIVE.
	//
	// * RESOLVED - The finding was reviewed and remediated and is
	// now considered resolved. The finding remains RESOLVED unless one of the
	// following occurs:
	//
	// * RecordState changes from ARCHIVED to ACTIVE.
	//
	// *
	// Compliance.Status changes from PASSED to FAILED, WARNING, or NOT_AVAILABLE.
	//
	// In
	// those cases, the workflow status is automatically reset to NEW. For findings
	// from controls, if Compliance.Status is PASSED, then Security Hub automatically
	// sets the workflow status to RESOLVED.
	WorkflowStatus []StringFilter

	noSmithyDocumentSerde
}

// Identifies a finding to update using BatchUpdateFindings.
type AwsSecurityFindingIdentifier struct {

	// The identifier of the finding that was specified by the finding provider.
	//
	// This member is required.
	Id *string

	// The ARN generated by Security Hub that uniquely identifies a product that
	// generates findings. This can be the ARN for a third-party product that is
	// integrated with Security Hub, or the ARN for a custom integration.
	//
	// This member is required.
	ProductArn *string

	noSmithyDocumentSerde
}

// A wrapper type for the topic's ARN.
type AwsSnsTopicDetails struct {

	// The ID of an Amazon Web Services managed key for Amazon SNS or a customer
	// managed key.
	KmsMasterKeyId *string

	// The subscription's owner.
	Owner *string

	// Subscription is an embedded property that describes the subscription endpoints
	// of an SNS topic.
	Subscription []AwsSnsTopicSubscription

	// The name of the topic.
	TopicName *string

	noSmithyDocumentSerde
}

// A wrapper type for the attributes of an Amazon SNS subscription.
type AwsSnsTopicSubscription struct {

	// The subscription's endpoint (format depends on the protocol).
	Endpoint *string

	// The subscription's protocol.
	Protocol *string

	noSmithyDocumentSerde
}

// Data about a queue.
type AwsSqsQueueDetails struct {

	// The ARN of the dead-letter queue to which Amazon SQS moves messages after the
	// value of maxReceiveCount is exceeded.
	DeadLetterTargetArn *string

	// The length of time, in seconds, for which Amazon SQS can reuse a data key to
	// encrypt or decrypt messages before calling KMS again.
	KmsDataKeyReusePeriodSeconds int32

	// The ID of an Amazon Web Services managed key for Amazon SQS or a custom KMS key.
	KmsMasterKeyId *string

	// The name of the new queue.
	QueueName *string

	noSmithyDocumentSerde
}

// Provides the details about the compliance status for a patch.
type AwsSsmComplianceSummary struct {

	// The type of resource for which the compliance was determined. For
	// AwsSsmPatchCompliance, ComplianceType is Patch.
	ComplianceType *string

	// For the patches that are compliant, the number that have a severity of CRITICAL.
	CompliantCriticalCount int32

	// For the patches that are compliant, the number that have a severity of HIGH.
	CompliantHighCount int32

	// For the patches that are compliant, the number that have a severity of
	// INFORMATIONAL.
	CompliantInformationalCount int32

	// For the patches that are compliant, the number that have a severity of LOW.
	CompliantLowCount int32

	// For the patches that are compliant, the number that have a severity of MEDIUM.
	CompliantMediumCount int32

	// For the patches that are compliant, the number that have a severity of
	// UNSPECIFIED.
	CompliantUnspecifiedCount int32

	// The type of execution that was used determine compliance.
	ExecutionType *string

	// For the patch items that are noncompliant, the number of items that have a
	// severity of CRITICAL.
	NonCompliantCriticalCount int32

	// For the patches that are noncompliant, the number that have a severity of HIGH.
	NonCompliantHighCount int32

	// For the patches that are noncompliant, the number that have a severity of
	// INFORMATIONAL.
	NonCompliantInformationalCount int32

	// For the patches that are noncompliant, the number that have a severity of LOW.
	NonCompliantLowCount int32

	// For the patches that are noncompliant, the number that have a severity of
	// MEDIUM.
	NonCompliantMediumCount int32

	// For the patches that are noncompliant, the number that have a severity of
	// UNSPECIFIED.
	NonCompliantUnspecifiedCount int32

	// The highest severity for the patches.
	OverallSeverity *string

	// The identifier of the patch baseline. The patch baseline lists the patches that
	// are approved for installation.
	PatchBaselineId *string

	// The identifier of the patch group for which compliance was determined. A patch
	// group uses tags to group EC2 instances that should have the same patch
	// compliance.
	PatchGroup *string

	// The current patch compliance status. The possible status values are:
	//
	// *
	// COMPLIANT
	//
	// * NON_COMPLIANT
	//
	// * UNSPECIFIED_DATA
	Status *string

	noSmithyDocumentSerde
}

// Provides details about the compliance for a patch.
type AwsSsmPatch struct {

	// The compliance status details for the patch.
	ComplianceSummary *AwsSsmComplianceSummary

	noSmithyDocumentSerde
}

// Provides information about the state of a patch on an instance based on the
// patch baseline that was used to patch the instance.
type AwsSsmPatchComplianceDetails struct {

	// Information about the status of a patch.
	Patch *AwsSsmPatch

	noSmithyDocumentSerde
}

// Details about a rate-based rule for global resources. A rate-based rule provides
// settings to indicate when to allow, block, or count a request. Rate-based rules
// include the number of requests that arrive over a specified period of time.
type AwsWafRateBasedRuleDetails struct {

	// The predicates to include in the rate-based rule.
	MatchPredicates []AwsWafRateBasedRuleMatchPredicate

	// The name of the metrics for the rate-based rule.
	MetricName *string

	// The name of the rate-based rule.
	Name *string

	// The field that WAF uses to determine whether requests are likely arriving from
	// single source and are subject to rate monitoring.
	RateKey *string

	// The maximum number of requests that have an identical value for the field
	// specified in RateKey that are allowed within a five-minute period. If the number
	// of requests exceeds RateLimit and the other predicates specified in the rule are
	// met, WAF triggers the action for the rule.
	RateLimit int64

	// The unique identifier for the rate-based rule.
	RuleId *string

	noSmithyDocumentSerde
}

// A match predicate. A predicate might look for characteristics such as specific
// IP addresses, geographic locations, or sizes.
type AwsWafRateBasedRuleMatchPredicate struct {

	// The unique identifier for the predicate.
	DataId *string

	// If set to true, then the rule actions are performed on requests that match the
	// predicate settings. If set to false, then the rule actions are performed on all
	// requests except those that match the predicate settings.
	Negated bool

	// The type of predicate.
	Type *string

	noSmithyDocumentSerde
}

// contains details about a rate-based rule for Regional resources. A rate-based
// rule provides settings to indicate when to allow, block, or count a request.
// Rate-based rules include the number of requests that arrive over a specified
// period of time.
type AwsWafRegionalRateBasedRuleDetails struct {

	// The predicates to include in the rate-based rule.
	MatchPredicates []AwsWafRegionalRateBasedRuleMatchPredicate

	// The name of the metrics for the rate-based rule.
	MetricName *string

	// The name of the rate-based rule.
	Name *string

	// The field that WAF uses to determine whether requests are likely arriving from
	// single source and are subject to rate monitoring.
	RateKey *string

	// The maximum number of requests that have an identical value for the field
	// specified in RateKey that are allowed within a five-minute period. If the number
	// of requests exceeds RateLimit and the other predicates specified in the rule are
	// met, WAF triggers the action for the rule.
	RateLimit int64

	// The unique identifier for the rate-based rule.
	RuleId *string

	noSmithyDocumentSerde
}

// Details for a match predicate. A predicate might look for characteristics such
// as specific IP addresses, geographic locations, or sizes.
type AwsWafRegionalRateBasedRuleMatchPredicate struct {

	// The unique identifier for the predicate.
	DataId *string

	// If set to true, then the rule actions are performed on requests that match the
	// predicate settings. If set to false, then the rule actions are performed on all
	// requests except those that match the predicate settings.
	Negated bool

	// The type of predicate.
	Type *string

	noSmithyDocumentSerde
}

// Details about an WAF WebACL.
type AwsWafWebAclDetails struct {

	// The action to perform if none of the rules contained in the WebACL match.
	DefaultAction *string

	// A friendly name or description of the WebACL. You can't change the name of a
	// WebACL after you create it.
	Name *string

	// An array that contains the action for each rule in a WebACL, the priority of the
	// rule, and the ID of the rule.
	Rules []AwsWafWebAclRule

	// A unique identifier for a WebACL.
	WebAclId *string

	noSmithyDocumentSerde
}

// Details for a rule in an WAF WebACL.
type AwsWafWebAclRule struct {

	// Specifies the action that CloudFront or WAF takes when a web request matches the
	// conditions in the rule.
	Action *WafAction

	// Rules to exclude from a rule group.
	ExcludedRules []WafExcludedRule

	// Use the OverrideAction to test your RuleGroup. Any rule in a RuleGroup can
	// potentially block a request. If you set the OverrideAction to None, the
	// RuleGroup blocks a request if any individual rule in the RuleGroup matches the
	// request and is configured to block that request. However, if you first want to
	// test the RuleGroup, set the OverrideAction to Count. The RuleGroup then
	// overrides any block action specified by individual rules contained within the
	// group. Instead of blocking matching requests, those requests are counted.
	// ActivatedRule|OverrideAction applies only when updating or adding a RuleGroup to
	// a WebACL. In this case you do not use ActivatedRule|Action. For all other update
	// requests, ActivatedRule|Action is used instead of ActivatedRule|OverrideAction.
	OverrideAction *WafOverrideAction

	// Specifies the order in which the rules in a WebACL are evaluated. Rules with a
	// lower value for Priority are evaluated before rules with a higher value. The
	// value must be a unique integer. If you add multiple rules to a WebACL, the
	// values do not need to be consecutive.
	Priority int32

	// The identifier for a rule.
	RuleId *string

	// The rule type. Valid values: REGULAR | RATE_BASED | GROUP The default is
	// REGULAR.
	Type *string

	noSmithyDocumentSerde
}

// Information about the encryption configuration for X-Ray.
type AwsXrayEncryptionConfigDetails struct {

	// The identifier of the KMS key that is used for encryption. Provided if Type is
	// KMS.
	KeyId *string

	// The current status of the encryption configuration. When Status is UPDATING,
	// X-Ray might use both the old and new encryption.
	Status *string

	// The type of encryption. KMS indicates that the encryption uses KMS keys. NONE
	// indicates to use the default encryption.
	Type *string

	noSmithyDocumentSerde
}

// A finding from a BatchUpdateFindings request that Security Hub was unable to
// update.
type BatchUpdateFindingsUnprocessedFinding struct {

	// The code associated with the error.
	//
	// This member is required.
	ErrorCode *string

	// The message associated with the error.
	//
	// This member is required.
	ErrorMessage *string

	// The identifier of the finding that was not updated.
	//
	// This member is required.
	FindingIdentifier *AwsSecurityFindingIdentifier

	noSmithyDocumentSerde
}

// An occurrence of sensitive data detected in a Microsoft Excel workbook,
// comma-separated value (CSV) file, or tab-separated value (TSV) file.
type Cell struct {

	// For a Microsoft Excel workbook, provides the location of the cell, as an
	// absolute cell reference, that contains the data. For example, Sheet2!C5 for cell
	// C5 on Sheet2.
	CellReference *string

	// The column number of the column that contains the data. For a Microsoft Excel
	// workbook, the column number corresponds to the alphabetical column identifiers.
	// For example, a value of 1 for Column corresponds to the A column in the
	// workbook.
	Column int64

	// The name of the column that contains the data.
	ColumnName *string

	// The row number of the row that contains the data.
	Row int64

	noSmithyDocumentSerde
}

// An IPv4 CIDR block association.
type CidrBlockAssociation struct {

	// The association ID for the IPv4 CIDR block.
	AssociationId *string

	// The IPv4 CIDR block.
	CidrBlock *string

	// Information about the state of the IPv4 CIDR block.
	CidrBlockState *string

	noSmithyDocumentSerde
}

// Information about a city.
type City struct {

	// The name of the city.
	CityName *string

	noSmithyDocumentSerde
}

// Details about the sensitive data that was detected on the resource.
type ClassificationResult struct {

	// Indicates whether there are additional occurrences of sensitive data that are
	// not included in the finding. This occurs when the number of occurrences exceeds
	// the maximum that can be included.
	AdditionalOccurrences bool

	// Provides details about sensitive data that was identified based on
	// customer-defined configuration.
	CustomDataIdentifiers *CustomDataIdentifiersResult

	// The type of content that the finding applies to.
	MimeType *string

	// Provides details about sensitive data that was identified based on built-in
	// configuration.
	SensitiveData []SensitiveDataResult

	// The total size in bytes of the affected data.
	SizeClassified int64

	// The current status of the sensitive data detection.
	Status *ClassificationStatus

	noSmithyDocumentSerde
}

// Provides details about the current status of the sensitive data detection.
type ClassificationStatus struct {

	// The code that represents the status of the sensitive data detection.
	Code *string

	// A longer description of the current status of the sensitive data detection.
	Reason *string

	noSmithyDocumentSerde
}

// Contains finding details that are specific to control-based findings. Only
// returned for findings generated from controls.
type Compliance struct {

	// For a control, the industry or regulatory framework requirements that are
	// related to the control. The check for that control is aligned with these
	// requirements.
	RelatedRequirements []string

	// The result of a standards check. The valid values for Status are as follows.
	//
	// *
	// PASSED - Standards check passed for all evaluated resources.
	//
	// * WARNING - Some
	// information is missing or this check is not supported for your configuration.
	//
	// *
	// FAILED - Standards check failed for at least one evaluated resource.
	//
	// *
	// NOT_AVAILABLE - Check could not be performed due to a service outage, API error,
	// or because the result of the Config evaluation was NOT_APPLICABLE. If the Config
	// evaluation result was NOT_APPLICABLE, then after 3 days, Security Hub
	// automatically archives the finding.
	Status ComplianceStatus

	// For findings generated from controls, a list of reasons behind the value of
	// Status. For the list of status reason codes and their meanings, see
	// Standards-related information in the ASFF
	// (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff)
	// in the Security Hub User Guide.
	StatusReasons []StatusReason

	noSmithyDocumentSerde
}

// Container details related to a finding.
type ContainerDetails struct {

	// The identifier of the image related to a finding.
	ImageId *string

	// The name of the image related to a finding.
	ImageName *string

	// Indicates when the container started. Uses the date-time format specified in RFC
	// 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	LaunchedAt *string

	// The name of the container related to a finding.
	Name *string

	noSmithyDocumentSerde
}

// Information about a country.
type Country struct {

	// The 2-letter ISO 3166 country code for the country.
	CountryCode *string

	// The name of the country.
	CountryName *string

	noSmithyDocumentSerde
}

// The list of detected instances of sensitive data.
type CustomDataIdentifiersDetections struct {

	// The ARN of the custom identifier that was used to detect the sensitive data.
	Arn *string

	// The total number of occurrences of sensitive data that were detected.
	Count int64

	// he name of the custom identifier that detected the sensitive data.
	Name *string

	// Details about the sensitive data that was detected.
	Occurrences *Occurrences

	noSmithyDocumentSerde
}

// Contains an instance of sensitive data that was detected by a customer-defined
// identifier.
type CustomDataIdentifiersResult struct {

	// The list of detected instances of sensitive data.
	Detections []CustomDataIdentifiersDetections

	// The total number of occurrences of sensitive data.
	TotalCount int64

	noSmithyDocumentSerde
}

// CVSS scores from the advisory related to the vulnerability.
type Cvss struct {

	// Adjustments to the CVSS metrics.
	Adjustments []Adjustment

	// The base CVSS score.
	BaseScore float64

	// The base scoring vector for the CVSS score.
	BaseVector *string

	// The origin of the original CVSS score and vector.
	Source *string

	// The version of CVSS for the CVSS score.
	Version *string

	noSmithyDocumentSerde
}

// Provides details about sensitive data that was detected on a resource.
type DataClassificationDetails struct {

	// The path to the folder or file that contains the sensitive data.
	DetailedResultsLocation *string

	// The details about the sensitive data that was detected on the resource.
	Result *ClassificationResult

	noSmithyDocumentSerde
}

// A date filter for querying findings.
type DateFilter struct {

	// A date range for the date filter.
	DateRange *DateRange

	// An end date for the date filter.
	End *string

	// A start date for the date filter.
	Start *string

	noSmithyDocumentSerde
}

// A date range for the date filter.
type DateRange struct {

	// A date range unit for the date filter.
	Unit DateRangeUnit

	// A date range value for the date filter.
	Value int32

	noSmithyDocumentSerde
}

// Provided if ActionType is DNS_REQUEST. It provides details about the DNS request
// that was detected.
type DnsRequestAction struct {

	// Indicates whether the DNS request was blocked.
	Blocked bool

	// The DNS domain that is associated with the DNS request.
	Domain *string

	// The protocol that was used for the DNS request.
	Protocol *string

	noSmithyDocumentSerde
}

// A finding aggregator. A finding aggregator contains the configuration for
// finding aggregation.
type FindingAggregator struct {

	// The ARN of the finding aggregator. You use the finding aggregator ARN to
	// retrieve details for, update, and delete the finding aggregator.
	FindingAggregatorArn *string

	noSmithyDocumentSerde
}

// In a BatchImportFindings request, finding providers use FindingProviderFields to
// provide and update values for confidence, criticality, related findings,
// severity, and types.
type FindingProviderFields struct {

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero
	// percent confidence and 100 means 100 percent confidence.
	Confidence int32

	// The level of importance assigned to the resources associated with the finding. A
	// score of 0 means that the underlying resources have no criticality, and a score
	// of 100 is reserved for the most critical resources.
	Criticality int32

	// A list of findings that are related to the current finding.
	RelatedFindings []RelatedFinding

	// The severity of a finding.
	Severity *FindingProviderSeverity

	// One or more finding types in the format of namespace/category/classifier that
	// classify a finding. Valid namespace values are: Software and Configuration
	// Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications
	Types []string

	noSmithyDocumentSerde
}

// The severity assigned to the finding by the finding provider.
type FindingProviderSeverity struct {

	// The severity label assigned to the finding by the finding provider.
	Label SeverityLabel

	// The finding provider's original value for the severity.
	Original *string

	noSmithyDocumentSerde
}

// Defines the behavior of the firewall.
type FirewallPolicyDetails struct {

	// The stateful rule groups that are used in the firewall policy.
	StatefulRuleGroupReferences []FirewallPolicyStatefulRuleGroupReferencesDetails

	// The custom action definitions that are available to use in the firewall policy's
	// StatelessDefaultActions setting.
	StatelessCustomActions []FirewallPolicyStatelessCustomActionsDetails

	// The actions to take on a packet if it doesn't match any of the stateless rules
	// in the policy. You must specify a standard action (aws:pass, aws:drop,
	// aws:forward_to_sfe), and can optionally include a custom action from
	// StatelessCustomActions.
	StatelessDefaultActions []string

	// The actions to take on a fragmented UDP packet if it doesn't match any of the
	// stateless rules in the policy. You must specify a standard action (aws:pass,
	// aws:drop, aws:forward_to_sfe), and can optionally include a custom action from
	// StatelessCustomActions.
	StatelessFragmentDefaultActions []string

	// The stateless rule groups that are used in the firewall policy.
	StatelessRuleGroupReferences []FirewallPolicyStatelessRuleGroupReferencesDetails

	noSmithyDocumentSerde
}

// A stateful rule group that is used by the firewall policy.
type FirewallPolicyStatefulRuleGroupReferencesDetails struct {

	// The ARN of the stateful rule group.
	ResourceArn *string

	noSmithyDocumentSerde
}

// A custom action that can be used for stateless packet handling.
type FirewallPolicyStatelessCustomActionsDetails struct {

	// The definition of the custom action.
	ActionDefinition *StatelessCustomActionDefinition

	// The name of the custom action.
	ActionName *string

	noSmithyDocumentSerde
}

// A stateless rule group that is used by the firewall policy.
type FirewallPolicyStatelessRuleGroupReferencesDetails struct {

	// The order in which to run the stateless rule group.
	Priority int32

	// The ARN of the stateless rule group.
	ResourceArn *string

	noSmithyDocumentSerde
}

// Provides the latitude and longitude coordinates of a location.
type GeoLocation struct {

	// The latitude of the location.
	Lat float64

	// The longitude of the location.
	Lon float64

	noSmithyDocumentSerde
}

// An Internet Control Message Protocol (ICMP) type and code.
type IcmpTypeCode struct {

	// The ICMP code for which to deny or allow access. To deny or allow all codes, use
	// the value -1.
	Code int32

	// The ICMP type for which to deny or allow access. To deny or allow all types, use
	// the value -1.
	Type int32

	noSmithyDocumentSerde
}

// The list of the findings that cannot be imported. For each finding, the list
// provides the error.
type ImportFindingsError struct {

	// The code of the error returned by the BatchImportFindings operation.
	//
	// This member is required.
	ErrorCode *string

	// The message of the error returned by the BatchImportFindings operation.
	//
	// This member is required.
	ErrorMessage *string

	// The identifier of the finding that could not be updated.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about a Security Hub insight.
type Insight struct {

	// One or more attributes used to filter the findings included in the insight. The
	// insight only includes findings that match the criteria defined in the filters.
	//
	// This member is required.
	Filters *AwsSecurityFindingFilters

	// The grouping attribute for the insight's findings. Indicates how to group the
	// matching findings, and identifies the type of item that the insight applies to.
	// For example, if an insight is grouped by resource identifier, then the insight
	// produces a list of resource identifiers.
	//
	// This member is required.
	GroupByAttribute *string

	// The ARN of a Security Hub insight.
	//
	// This member is required.
	InsightArn *string

	// The name of a Security Hub insight.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The insight results returned by the GetInsightResults operation.
type InsightResults struct {

	// The attribute that the findings are grouped by for the insight whose results are
	// returned by the GetInsightResults operation.
	//
	// This member is required.
	GroupByAttribute *string

	// The ARN of the insight whose results are returned by the GetInsightResults
	// operation.
	//
	// This member is required.
	InsightArn *string

	// The list of insight result values returned by the GetInsightResults operation.
	//
	// This member is required.
	ResultValues []InsightResultValue

	noSmithyDocumentSerde
}

// The insight result values returned by the GetInsightResults operation.
type InsightResultValue struct {

	// The number of findings returned for each GroupByAttributeValue.
	//
	// This member is required.
	Count int32

	// The value of the attribute that the findings are grouped by for the insight
	// whose results are returned by the GetInsightResults operation.
	//
	// This member is required.
	GroupByAttributeValue *string

	noSmithyDocumentSerde
}

// Details about an invitation.
type Invitation struct {

	// The account ID of the Security Hub administrator account that the invitation was
	// sent from.
	AccountId *string

	// The ID of the invitation sent to the member account.
	InvitationId *string

	// The timestamp of when the invitation was sent.
	InvitedAt *time.Time

	// The current status of the association between the member and administrator
	// accounts.
	MemberStatus *string

	noSmithyDocumentSerde
}

// The IP filter for querying findings.
type IpFilter struct {

	// A finding's CIDR value.
	Cidr *string

	noSmithyDocumentSerde
}

// Provides information about an internet provider.
type IpOrganizationDetails struct {

	// The Autonomous System Number (ASN) of the internet provider
	Asn int32

	// The name of the organization that registered the ASN.
	AsnOrg *string

	// The ISP information for the internet provider.
	Isp *string

	// The name of the internet provider.
	Org *string

	noSmithyDocumentSerde
}

// An IPV6 CIDR block association.
type Ipv6CidrBlockAssociation struct {

	// The association ID for the IPv6 CIDR block.
	AssociationId *string

	// Information about the state of the CIDR block.
	CidrBlockState *string

	// The IPv6 CIDR block.
	Ipv6CidrBlock *string

	noSmithyDocumentSerde
}

// A keyword filter for querying findings.
type KeywordFilter struct {

	// A value for the keyword.
	Value *string

	noSmithyDocumentSerde
}

// Information about the state of the load balancer.
type LoadBalancerState struct {

	// The state code. The initial state of the load balancer is provisioning. After
	// the load balancer is fully set up and ready to route traffic, its state is
	// active. If the load balancer could not be set up, its state is failed.
	Code *string

	// A description of the state.
	Reason *string

	noSmithyDocumentSerde
}

// A list of malware related to a finding.
type Malware struct {

	// The name of the malware that was observed.
	//
	// This member is required.
	Name *string

	// The file system path of the malware that was observed.
	Path *string

	// The state of the malware that was observed.
	State MalwareState

	// The type of the malware that was observed.
	Type MalwareType

	noSmithyDocumentSerde
}

// A map filter for querying findings. Each map filter provides the field to check,
// the value to look for, and the comparison operator.
type MapFilter struct {

	// The condition to apply to the key value when querying for findings with a map
	// filter. To search for values that exactly match the filter value, use EQUALS.
	// For example, for the ResourceTags field, the filter Department EQUALS Security
	// matches findings that have the value Security for the tag Department. To search
	// for values other than the filter value, use NOT_EQUALS. For example, for the
	// ResourceTags field, the filter Department NOT_EQUALS Finance matches findings
	// that do not have the value Finance for the tag Department. EQUALS filters on the
	// same field are joined by OR. A finding matches if it matches any one of those
	// filters. NOT_EQUALS filters on the same field are joined by AND. A finding
	// matches only if it matches all of those filters. You cannot have both an EQUALS
	// filter and a NOT_EQUALS filter on the same field.
	Comparison MapFilterComparison

	// The key of the map filter. For example, for ResourceTags, Key identifies the
	// name of the tag. For UserDefinedFields, Key is the name of the field.
	Key *string

	// The value for the key in the map filter. Filter values are case sensitive. For
	// example, one of the values for a tag called Department might be Security. If you
	// provide security as the filter value, then there is no match.
	Value *string

	noSmithyDocumentSerde
}

// The details about a member account.
type Member struct {

	// The Amazon Web Services account ID of the member account.
	AccountId *string

	// The Amazon Web Services account ID of the Security Hub administrator account
	// associated with this member account.
	AdministratorId *string

	// The email address of the member account.
	Email *string

	// A timestamp for the date and time when the invitation was sent to the member
	// account.
	InvitedAt *time.Time

	// This is replaced by AdministratorID. The Amazon Web Services account ID of the
	// Security Hub administrator account associated with this member account.
	//
	// Deprecated: This field is deprecated, use AdministratorId instead.
	MasterId *string

	// The status of the relationship between the member account and its administrator
	// account. The status can have one of the following values:
	//
	// * CREATED - Indicates
	// that the administrator account added the member account, but has not yet invited
	// the member account.
	//
	// * INVITED - Indicates that the administrator account
	// invited the member account. The member account has not yet responded to the
	// invitation.
	//
	// * ENABLED - Indicates that the member account is currently active.
	// For manually invited member accounts, indicates that the member account accepted
	// the invitation.
	//
	// * REMOVED - Indicates that the administrator account
	// disassociated the member account.
	//
	// * RESIGNED - Indicates that the member
	// account disassociated themselves from the administrator account.
	//
	// * DELETED -
	// Indicates that the administrator account deleted the member account.
	//
	// *
	// ACCOUNT_SUSPENDED - Indicates that an organization account was suspended from
	// Amazon Web Services at the same time that the administrator account tried to
	// enable the organization account as a member account.
	MemberStatus *string

	// The timestamp for the date and time when the member account was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The details of network-related information about a finding.
type Network struct {

	// The destination domain of network-related information about a finding.
	DestinationDomain *string

	// The destination IPv4 address of network-related information about a finding.
	DestinationIpV4 *string

	// The destination IPv6 address of network-related information about a finding.
	DestinationIpV6 *string

	// The destination port of network-related information about a finding.
	DestinationPort int32

	// The direction of network traffic associated with a finding.
	Direction NetworkDirection

	// The range of open ports that is present on the network.
	OpenPortRange *PortRange

	// The protocol of network-related information about a finding.
	Protocol *string

	// The source domain of network-related information about a finding.
	SourceDomain *string

	// The source IPv4 address of network-related information about a finding.
	SourceIpV4 *string

	// The source IPv6 address of network-related information about a finding.
	SourceIpV6 *string

	// The source media access control (MAC) address of network-related information
	// about a finding.
	SourceMac *string

	// The source port of network-related information about a finding.
	SourcePort int32

	noSmithyDocumentSerde
}

// Provided if ActionType is NETWORK_CONNECTION. It provides details about the
// attempted network connection that was detected.
type NetworkConnectionAction struct {

	// Indicates whether the network connection attempt was blocked.
	Blocked bool

	// The direction of the network connection request (IN or OUT).
	ConnectionDirection *string

	// Information about the port on the EC2 instance.
	LocalPortDetails *ActionLocalPortDetails

	// The protocol used to make the network connection request.
	Protocol *string

	// Information about the remote IP address that issued the network connection
	// request.
	RemoteIpDetails *ActionRemoteIpDetails

	// Information about the port on the remote IP address.
	RemotePortDetails *ActionRemotePortDetails

	noSmithyDocumentSerde
}

// Details about a network path component that occurs before or after the current
// component.
type NetworkHeader struct {

	// Information about the destination of the component.
	Destination *NetworkPathComponentDetails

	// The protocol used for the component.
	Protocol *string

	// Information about the origin of the component.
	Source *NetworkPathComponentDetails

	noSmithyDocumentSerde
}

// Information about a network path component.
type NetworkPathComponent struct {

	// The identifier of a component in the network path.
	ComponentId *string

	// The type of component.
	ComponentType *string

	// Information about the component that comes after the current component in the
	// network path.
	Egress *NetworkHeader

	// Information about the component that comes before the current node in the
	// network path.
	Ingress *NetworkHeader

	noSmithyDocumentSerde
}

// Information about the destination of the next component in the network path.
type NetworkPathComponentDetails struct {

	// The IP addresses of the destination.
	Address []string

	// A list of port ranges for the destination.
	PortRanges []PortRange

	noSmithyDocumentSerde
}

// A user-defined note added to a finding.
type Note struct {

	// The text of a note.
	//
	// This member is required.
	Text *string

	// The timestamp of when the note was updated. Uses the date-time format specified
	// in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	//
	// This member is required.
	UpdatedAt *string

	// The principal that created a note.
	//
	// This member is required.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The updated note.
type NoteUpdate struct {

	// The updated note text.
	//
	// This member is required.
	Text *string

	// The principal that updated the note.
	//
	// This member is required.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// A number filter for querying findings.
type NumberFilter struct {

	// The equal-to condition to be applied to a single field when querying for
	// findings.
	Eq float64

	// The greater-than-equal condition to be applied to a single field when querying
	// for findings.
	Gte float64

	// The less-than-equal condition to be applied to a single field when querying for
	// findings.
	Lte float64

	noSmithyDocumentSerde
}

// The detected occurrences of sensitive data.
type Occurrences struct {

	// Occurrences of sensitive data detected in Microsoft Excel workbooks,
	// comma-separated value (CSV) files, or tab-separated value (TSV) files.
	Cells []Cell

	// Occurrences of sensitive data detected in a non-binary text file or a Microsoft
	// Word file. Non-binary text files include files such as HTML, XML, JSON, and TXT
	// files.
	LineRanges []Range

	// Occurrences of sensitive data detected in a binary text file.
	OffsetRanges []Range

	// Occurrences of sensitive data in an Adobe Portable Document Format (PDF) file.
	Pages []Page

	// Occurrences of sensitive data in an Apache Avro object container or an Apache
	// Parquet file.
	Records []Record

	noSmithyDocumentSerde
}

// An occurrence of sensitive data in an Adobe Portable Document Format (PDF) file.
type Page struct {

	// An occurrence of sensitive data detected in a non-binary text file or a
	// Microsoft Word file. Non-binary text files include files such as HTML, XML,
	// JSON, and TXT files.
	LineRange *Range

	// An occurrence of sensitive data detected in a binary text file.
	OffsetRange *Range

	// The page number of the page that contains the sensitive data.
	PageNumber int64

	noSmithyDocumentSerde
}

// Provides an overview of the patch compliance status for an instance against a
// selected compliance standard.
type PatchSummary struct {

	// The identifier of the compliance standard that was used to determine the patch
	// compliance status.
	//
	// This member is required.
	Id *string

	// The number of patches from the compliance standard that failed to install.
	FailedCount int32

	// The number of patches from the compliance standard that were installed
	// successfully.
	InstalledCount int32

	// The number of installed patches that are not part of the compliance standard.
	InstalledOtherCount int32

	// The number of patches that were applied, but that require the instance to be
	// rebooted in order to be marked as installed.
	InstalledPendingReboot int32

	// The number of patches that are installed but are also on a list of patches that
	// the customer rejected.
	InstalledRejectedCount int32

	// The number of patches that are part of the compliance standard but are not
	// installed. The count includes patches that failed to install.
	MissingCount int32

	// The type of patch operation performed. For Patch Manager, the values are SCAN
	// and INSTALL.
	Operation *string

	// Indicates when the operation completed. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	OperationEndTime *string

	// Indicates when the operation started. Uses the date-time format specified in RFC
	// 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	OperationStartTime *string

	// The reboot option specified for the instance.
	RebootOption *string

	noSmithyDocumentSerde
}

// Provided if ActionType is PORT_PROBE. It provides details about the attempted
// port probe that was detected.
type PortProbeAction struct {

	// Indicates whether the port probe was blocked.
	Blocked bool

	// Information about the ports affected by the port probe.
	PortProbeDetails []PortProbeDetail

	noSmithyDocumentSerde
}

// A port scan that was part of the port probe. For each scan, PortProbeDetails
// provides information about the local IP address and port that were scanned, and
// the remote IP address that the scan originated from.
type PortProbeDetail struct {

	// Provides information about the IP address where the scanned port is located.
	LocalIpDetails *ActionLocalIpDetails

	// Provides information about the port that was scanned.
	LocalPortDetails *ActionLocalPortDetails

	// Provides information about the remote IP address that performed the scan.
	RemoteIpDetails *ActionRemoteIpDetails

	noSmithyDocumentSerde
}

// A range of ports.
type PortRange struct {

	// The first port in the port range.
	Begin int32

	// The last port in the port range.
	End int32

	noSmithyDocumentSerde
}

// A range of ports.
type PortRangeFromTo struct {

	// The first port in the port range.
	From int32

	// The last port in the port range.
	To int32

	noSmithyDocumentSerde
}

// The details of process-related information about a finding.
type ProcessDetails struct {

	// Indicates when the process was launched. Uses the date-time format specified in
	// RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	LaunchedAt *string

	// The name of the process.
	Name *string

	// The parent process ID.
	ParentPid int32

	// The path to the process executable.
	Path *string

	// The process ID.
	Pid int32

	// Indicates when the process was terminated. Uses the date-time format specified
	// in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	TerminatedAt *string

	noSmithyDocumentSerde
}

// Contains details about a product.
type Product struct {

	// The ARN assigned to the product.
	//
	// This member is required.
	ProductArn *string

	// The URL to the service or product documentation about the integration with
	// Security Hub, including how to activate the integration.
	ActivationUrl *string

	// The categories assigned to the product.
	Categories []string

	// The name of the company that provides the product.
	CompanyName *string

	// A description of the product.
	Description *string

	// The types of integration that the product supports. Available values are the
	// following.
	//
	// * SEND_FINDINGS_TO_SECURITY_HUB - The integration sends findings to
	// Security Hub.
	//
	// * RECEIVE_FINDINGS_FROM_SECURITY_HUB - The integration receives
	// findings from Security Hub.
	//
	// * UPDATE_FINDINGS_IN_SECURITY_HUB - The integration
	// does not send new findings to Security Hub, but does make updates to the
	// findings that it receives from Security Hub.
	IntegrationTypes []IntegrationType

	// For integrations with Amazon Web Services services, the Amazon Web Services
	// Console URL from which to activate the service. For integrations with
	// third-party products, the Amazon Web Services Marketplace URL from which to
	// subscribe to or purchase the product.
	MarketplaceUrl *string

	// The name of the product.
	ProductName *string

	// The resource policy associated with the product.
	ProductSubscriptionResourcePolicy *string

	noSmithyDocumentSerde
}

// Identifies where the sensitive data begins and ends.
type Range struct {

	// The number of lines (for a line range) or characters (for an offset range) from
	// the beginning of the file to the end of the sensitive data.
	End int64

	// The number of lines (for a line range) or characters (for an offset range) from
	// the beginning of the file to the end of the sensitive data.
	Start int64

	// In the line where the sensitive data starts, the column within the line where
	// the sensitive data starts.
	StartColumn int64

	noSmithyDocumentSerde
}

// A recommendation on how to remediate the issue identified in a finding.
type Recommendation struct {

	// Describes the recommended steps to take to remediate an issue identified in a
	// finding.
	Text *string

	// A URL to a page or site that contains information about how to remediate a
	// finding.
	Url *string

	noSmithyDocumentSerde
}

// An occurrence of sensitive data in an Apache Avro object container or an Apache
// Parquet file.
type Record struct {

	// The path, as a JSONPath expression, to the field in the record that contains the
	// data. If the field name is longer than 20 characters, it is truncated. If the
	// path is longer than 250 characters, it is truncated.
	JsonPath *string

	// The record index, starting from 0, for the record that contains the data.
	RecordIndex int64

	noSmithyDocumentSerde
}

// Details about a related finding.
type RelatedFinding struct {

	// The product-generated identifier for a related finding.
	//
	// This member is required.
	Id *string

	// The ARN of the product that generated a related finding.
	//
	// This member is required.
	ProductArn *string

	noSmithyDocumentSerde
}

// Details about the remediation steps for a finding.
type Remediation struct {

	// A recommendation on the steps to take to remediate the issue identified by a
	// finding.
	Recommendation *Recommendation

	noSmithyDocumentSerde
}

// A resource related to a finding.
type Resource struct {

	// The canonical identifier for the given resource type.
	//
	// This member is required.
	Id *string

	// The type of the resource that details are provided for. If possible, set Type to
	// one of the supported resource types. For example, if the resource is an EC2
	// instance, then set Type to AwsEc2Instance. If the resource does not match any of
	// the provided types, then set Type to Other.
	//
	// This member is required.
	Type *string

	// Contains information about sensitive data that was detected on the resource.
	DataClassification *DataClassificationDetails

	// Additional details about the resource related to a finding.
	Details *ResourceDetails

	// The canonical Amazon Web Services partition name that the Region is assigned to.
	Partition Partition

	// The canonical Amazon Web Services external Region name where this resource is
	// located.
	Region *string

	// Identifies the role of the resource in the finding. A resource is either the
	// actor or target of the finding activity,
	ResourceRole *string

	// A list of Amazon Web Services tags associated with a resource at the time the
	// finding was processed.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Additional details about a resource related to a finding. To provide the
// details, use the object that corresponds to the resource type. For example, if
// the resource type is AwsEc2Instance, then you use the AwsEc2Instance object to
// provide the details. If the type-specific object does not contain all of the
// fields you want to populate, then you use the Other object to populate those
// additional fields. You also use the Other object to populate the details when
// the selected type does not have a corresponding object.
type ResourceDetails struct {

	// Provides information about a REST API in version 1 of Amazon API Gateway.
	AwsApiGatewayRestApi *AwsApiGatewayRestApiDetails

	// Provides information about a version 1 Amazon API Gateway stage.
	AwsApiGatewayStage *AwsApiGatewayStageDetails

	// Provides information about a version 2 API in Amazon API Gateway.
	AwsApiGatewayV2Api *AwsApiGatewayV2ApiDetails

	// Provides information about a version 2 stage for Amazon API Gateway.
	AwsApiGatewayV2Stage *AwsApiGatewayV2StageDetails

	// Details for an autoscaling group.
	AwsAutoScalingAutoScalingGroup *AwsAutoScalingAutoScalingGroupDetails

	// Provides details about a launch configuration.
	AwsAutoScalingLaunchConfiguration *AwsAutoScalingLaunchConfigurationDetails

	// Provides details about an Certificate Manager certificate.
	AwsCertificateManagerCertificate *AwsCertificateManagerCertificateDetails

	// Details about a CloudFront distribution.
	AwsCloudFrontDistribution *AwsCloudFrontDistributionDetails

	// Provides details about a CloudTrail trail.
	AwsCloudTrailTrail *AwsCloudTrailTrailDetails

	// Details for an CodeBuild project.
	AwsCodeBuildProject *AwsCodeBuildProjectDetails

	// Details about a DynamoDB table.
	AwsDynamoDbTable *AwsDynamoDbTableDetails

	// Details about an Elastic IP address.
	AwsEc2Eip *AwsEc2EipDetails

	// Details about an EC2 instance related to a finding.
	AwsEc2Instance *AwsEc2InstanceDetails

	// Details about an EC2 network access control list (ACL).
	AwsEc2NetworkAcl *AwsEc2NetworkAclDetails

	// Details for an EC2 network interface.
	AwsEc2NetworkInterface *AwsEc2NetworkInterfaceDetails

	// Details for an EC2 security group.
	AwsEc2SecurityGroup *AwsEc2SecurityGroupDetails

	// Details about a subnet in Amazon EC2.
	AwsEc2Subnet *AwsEc2SubnetDetails

	// Details for an EC2 volume.
	AwsEc2Volume *AwsEc2VolumeDetails

	// Details for an EC2 VPC.
	AwsEc2Vpc *AwsEc2VpcDetails

	// Details about the service configuration for a VPC endpoint service.
	AwsEc2VpcEndpointService *AwsEc2VpcEndpointServiceDetails

	// Details about an EC2 VPN connection.
	AwsEc2VpnConnection *AwsEc2VpnConnectionDetails

	// Information about an Amazon ECR image.
	AwsEcrContainerImage *AwsEcrContainerImageDetails

	// Information about an Amazon Elastic Container Registry repository.
	AwsEcrRepository *AwsEcrRepositoryDetails

	// Details about an ECS cluster.
	AwsEcsCluster *AwsEcsClusterDetails

	// Details about a service within an ECS cluster.
	AwsEcsService *AwsEcsServiceDetails

	// Details about a task definition. A task definition describes the container and
	// volume definitions of an Amazon Elastic Container Service task.
	AwsEcsTaskDefinition *AwsEcsTaskDefinitionDetails

	// Details about an Amazon EKS cluster.
	AwsEksCluster *AwsEksClusterDetails

	// Details about an Elastic Beanstalk environment.
	AwsElasticBeanstalkEnvironment *AwsElasticBeanstalkEnvironmentDetails

	// Details for an Elasticsearch domain.
	AwsElasticsearchDomain *AwsElasticsearchDomainDetails

	// Contains details about a Classic Load Balancer.
	AwsElbLoadBalancer *AwsElbLoadBalancerDetails

	// Details about a load balancer.
	AwsElbv2LoadBalancer *AwsElbv2LoadBalancerDetails

	// Details about an IAM access key related to a finding.
	AwsIamAccessKey *AwsIamAccessKeyDetails

	// Contains details about an IAM group.
	AwsIamGroup *AwsIamGroupDetails

	// Details about an IAM permissions policy.
	AwsIamPolicy *AwsIamPolicyDetails

	// Details about an IAM role.
	AwsIamRole *AwsIamRoleDetails

	// Details about an IAM user.
	AwsIamUser *AwsIamUserDetails

	// Details about an KMS key.
	AwsKmsKey *AwsKmsKeyDetails

	// Details about a Lambda function.
	AwsLambdaFunction *AwsLambdaFunctionDetails

	// Details for a Lambda layer version.
	AwsLambdaLayerVersion *AwsLambdaLayerVersionDetails

	// Details about an Network Firewall firewall.
	AwsNetworkFirewallFirewall *AwsNetworkFirewallFirewallDetails

	// Details about an Network Firewall firewall policy.
	AwsNetworkFirewallFirewallPolicy *AwsNetworkFirewallFirewallPolicyDetails

	// Details about an Network Firewall rule group.
	AwsNetworkFirewallRuleGroup *AwsNetworkFirewallRuleGroupDetails

	// Details about an Amazon OpenSearch Service domain.
	AwsOpenSearchServiceDomain *AwsOpenSearchServiceDomainDetails

	// Details about an Amazon RDS database cluster.
	AwsRdsDbCluster *AwsRdsDbClusterDetails

	// Details about an Amazon RDS database cluster snapshot.
	AwsRdsDbClusterSnapshot *AwsRdsDbClusterSnapshotDetails

	// Details about an Amazon RDS database instance.
	AwsRdsDbInstance *AwsRdsDbInstanceDetails

	// Details about an Amazon RDS database snapshot.
	AwsRdsDbSnapshot *AwsRdsDbSnapshotDetails

	// Details about an RDS event notification subscription.
	AwsRdsEventSubscription *AwsRdsEventSubscriptionDetails

	// Contains details about an Amazon Redshift cluster.
	AwsRedshiftCluster *AwsRedshiftClusterDetails

	// Details about the Amazon S3 Public Access Block configuration for an account.
	AwsS3AccountPublicAccessBlock *AwsS3AccountPublicAccessBlockDetails

	// Details about an S3 bucket related to a finding.
	AwsS3Bucket *AwsS3BucketDetails

	// Details about an S3 object related to a finding.
	AwsS3Object *AwsS3ObjectDetails

	// Details about a Secrets Manager secret.
	AwsSecretsManagerSecret *AwsSecretsManagerSecretDetails

	// Details about an SNS topic.
	AwsSnsTopic *AwsSnsTopicDetails

	// Details about an SQS queue.
	AwsSqsQueue *AwsSqsQueueDetails

	// Provides information about the state of a patch on an instance based on the
	// patch baseline that was used to patch the instance.
	AwsSsmPatchCompliance *AwsSsmPatchComplianceDetails

	// Details about a rate-based rule for global resources.
	AwsWafRateBasedRule *AwsWafRateBasedRuleDetails

	// Details about a rate-based rule for Regional resources.
	AwsWafRegionalRateBasedRule *AwsWafRegionalRateBasedRuleDetails

	// Details for an WAF WebACL.
	AwsWafWebAcl *AwsWafWebAclDetails

	// Information about the encryption configuration for X-Ray.
	AwsXrayEncryptionConfig *AwsXrayEncryptionConfigDetails

	// Details about a container resource related to a finding.
	Container *ContainerDetails

	// Details about a resource that are not available in a type-specific details
	// object. Use the Other object in the following cases.
	//
	// * The type-specific object
	// does not contain all of the fields that you want to populate. In this case,
	// first use the type-specific object to populate those fields. Use the Other
	// object to populate the fields that are missing from the type-specific object.
	//
	// *
	// The resource type does not have a corresponding object. This includes resources
	// for which the type is Other.
	Other map[string]string

	noSmithyDocumentSerde
}

// Details about the account that was not processed.
type Result struct {

	// An Amazon Web Services account ID of the account that was not processed.
	AccountId *string

	// The reason that the account was not processed.
	ProcessingResult *string

	noSmithyDocumentSerde
}

// Details about the rule group.
type RuleGroupDetails struct {

	// Additional settings to use in the specified rules.
	RuleVariables *RuleGroupVariables

	// The rules and actions for the rule group. For stateful rule groups, can contain
	// RulesString, RulesSourceList, or StatefulRules. For stateless rule groups,
	// contains StatelessRulesAndCustomActions.
	RulesSource *RuleGroupSource

	noSmithyDocumentSerde
}

// The rules and actions for the rule group.
type RuleGroupSource struct {

	// Stateful inspection criteria for a domain list rule group. A domain list rule
	// group determines access by specific protocols to specific domains.
	RulesSourceList *RuleGroupSourceListDetails

	// Stateful inspection criteria, provided in Suricata compatible intrusion
	// prevention system (IPS) rules.
	RulesString *string

	// Suricata rule specifications.
	StatefulRules []RuleGroupSourceStatefulRulesDetails

	// The stateless rules and custom actions used by a stateless rule group.
	StatelessRulesAndCustomActions *RuleGroupSourceStatelessRulesAndCustomActionsDetails

	noSmithyDocumentSerde
}

// A custom action definition. A custom action is an optional, non-standard action
// to use for stateless packet handling.
type RuleGroupSourceCustomActionsDetails struct {

	// The definition of a custom action.
	ActionDefinition *StatelessCustomActionDefinition

	// A descriptive name of the custom action.
	ActionName *string

	noSmithyDocumentSerde
}

// Stateful inspection criteria for a domain list rule group.
type RuleGroupSourceListDetails struct {

	// Indicates whether to allow or deny access to the domains listed in Targets.
	GeneratedRulesType *string

	// The protocols that you want to inspect. Specify LS_SNI for HTTPS. Specify
	// HTTP_HOST for HTTP. You can specify either or both.
	TargetTypes []string

	// The domains that you want to inspect for in your traffic flows. You can provide
	// full domain names, or use the '.' prefix as a wildcard. For example,
	// .example.com matches all domains that end with example.com.
	Targets []string

	noSmithyDocumentSerde
}

// A Suricata rule specification.
type RuleGroupSourceStatefulRulesDetails struct {

	// Defines what Network Firewall should do with the packets in a traffic flow when
	// the flow matches the stateful rule criteria.
	Action *string

	// The stateful inspection criteria for the rule.
	Header *RuleGroupSourceStatefulRulesHeaderDetails

	// Additional options for the rule.
	RuleOptions []RuleGroupSourceStatefulRulesOptionsDetails

	noSmithyDocumentSerde
}

// The inspection criteria for a stateful rule.
type RuleGroupSourceStatefulRulesHeaderDetails struct {

	// The destination IP address or address range to inspect for, in CIDR notation. To
	// match with any address, specify ANY.
	Destination *string

	// The destination port to inspect for. You can specify an individual port, such as
	// 1994. You also can specify a port range, such as 1990:1994. To match with any
	// port, specify ANY.
	DestinationPort *string

	// The direction of traffic flow to inspect. If set to ANY, the inspection matches
	// bidirectional traffic, both from the source to the destination and from the
	// destination to the source. If set to FORWARD, the inspection only matches
	// traffic going from the source to the destination.
	Direction *string

	// The protocol to inspect for. To inspector for all protocols, use IP.
	Protocol *string

	// The source IP address or address range to inspect for, in CIDR notation. To
	// match with any address, specify ANY.
	Source *string

	// The source port to inspect for. You can specify an individual port, such as
	// 1994. You also can specify a port range, such as 1990:1994. To match with any
	// port, specify ANY.
	SourcePort *string

	noSmithyDocumentSerde
}

// A rule option for a stateful rule.
type RuleGroupSourceStatefulRulesOptionsDetails struct {

	// A keyword to look for.
	Keyword *string

	// A list of settings.
	Settings []string

	noSmithyDocumentSerde
}

// The definition of the stateless rule.
type RuleGroupSourceStatelessRuleDefinition struct {

	// The actions to take on a packet that matches one of the stateless rule
	// definition's match attributes. You must specify a standard action (aws:pass,
	// aws:drop, or aws:forward_to_sfe). You can then add custom actions.
	Actions []string

	// The criteria for Network Firewall to use to inspect an individual packet in a
	// stateless rule inspection.
	MatchAttributes *RuleGroupSourceStatelessRuleMatchAttributes

	noSmithyDocumentSerde
}

// Criteria for the stateless rule.
type RuleGroupSourceStatelessRuleMatchAttributes struct {

	// A list of port ranges to specify the destination ports to inspect for.
	DestinationPorts []RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts

	// The destination IP addresses and address ranges to inspect for, in CIDR
	// notation.
	Destinations []RuleGroupSourceStatelessRuleMatchAttributesDestinations

	// The protocols to inspect for.
	Protocols []int32

	// A list of port ranges to specify the source ports to inspect for.
	SourcePorts []RuleGroupSourceStatelessRuleMatchAttributesSourcePorts

	// The source IP addresses and address ranges to inspect for, in CIDR notation.
	Sources []RuleGroupSourceStatelessRuleMatchAttributesSources

	// The TCP flags and masks to inspect for.
	TcpFlags []RuleGroupSourceStatelessRuleMatchAttributesTcpFlags

	noSmithyDocumentSerde
}

// A port range to specify the destination ports to inspect for.
type RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts struct {

	// The starting port value for the port range.
	FromPort int32

	// The ending port value for the port range.
	ToPort int32

	noSmithyDocumentSerde
}

// A destination IP address or range.
type RuleGroupSourceStatelessRuleMatchAttributesDestinations struct {

	// An IP address or a block of IP addresses.
	AddressDefinition *string

	noSmithyDocumentSerde
}

// A port range to specify the source ports to inspect for.
type RuleGroupSourceStatelessRuleMatchAttributesSourcePorts struct {

	// The starting port value for the port range.
	FromPort int32

	// The ending port value for the port range.
	ToPort int32

	noSmithyDocumentSerde
}

// A source IP addresses and address range to inspect for.
type RuleGroupSourceStatelessRuleMatchAttributesSources struct {

	// An IP address or a block of IP addresses.
	AddressDefinition *string

	noSmithyDocumentSerde
}

// A set of TCP flags and masks to inspect for.
type RuleGroupSourceStatelessRuleMatchAttributesTcpFlags struct {

	// Defines the flags from the Masks setting that must be set in order for the
	// packet to match. Flags that are listed must be set. Flags that are not listed
	// must not be set.
	Flags []string

	// The set of flags to consider in the inspection. If not specified, then all flags
	// are inspected.
	Masks []string

	noSmithyDocumentSerde
}

// Stateless rules and custom actions for a stateless rule group.
type RuleGroupSourceStatelessRulesAndCustomActionsDetails struct {

	// Custom actions for the rule group.
	CustomActions []RuleGroupSourceCustomActionsDetails

	// Stateless rules for the rule group.
	StatelessRules []RuleGroupSourceStatelessRulesDetails

	noSmithyDocumentSerde
}

// A stateless rule in the rule group.
type RuleGroupSourceStatelessRulesDetails struct {

	// Indicates the order in which to run this rule relative to all of the rules in
	// the stateless rule group.
	Priority int32

	// Provides the definition of the stateless rule.
	RuleDefinition *RuleGroupSourceStatelessRuleDefinition

	noSmithyDocumentSerde
}

// Additional settings to use in the specified rules.
type RuleGroupVariables struct {

	// A list of IP addresses and address ranges, in CIDR notation.
	IpSets *RuleGroupVariablesIpSetsDetails

	// A list of port ranges.
	PortSets *RuleGroupVariablesPortSetsDetails

	noSmithyDocumentSerde
}

// A list of IP addresses and address ranges, in CIDR notation.
type RuleGroupVariablesIpSetsDetails struct {

	// The list of IP addresses and ranges.
	Definition []string

	noSmithyDocumentSerde
}

// A list of port ranges.
type RuleGroupVariablesPortSetsDetails struct {

	// The list of port ranges.
	Definition []string

	noSmithyDocumentSerde
}

// The list of detected instances of sensitive data.
type SensitiveDataDetections struct {

	// The total number of occurrences of sensitive data that were detected.
	Count int64

	// Details about the sensitive data that was detected.
	Occurrences *Occurrences

	// The type of sensitive data that was detected. For example, the type might
	// indicate that the data is an email address.
	Type *string

	noSmithyDocumentSerde
}

// Contains a detected instance of sensitive data that are based on built-in
// identifiers.
type SensitiveDataResult struct {

	// The category of sensitive data that was detected. For example, the category can
	// indicate that the sensitive data involved credentials, financial information, or
	// personal information.
	Category *string

	// The list of detected instances of sensitive data.
	Detections []SensitiveDataDetections

	// The total number of occurrences of sensitive data.
	TotalCount int64

	noSmithyDocumentSerde
}

// The severity of the finding. The finding provider can provide the initial
// severity. The finding provider can only update the severity if it has not been
// updated using BatchUpdateFindings. The finding must have either Label or
// Normalized populated. If only one of these attributes is populated, then
// Security Hub automatically populates the other one. If neither attribute is
// populated, then the finding is invalid. Label is the preferred attribute.
type Severity struct {

	// The severity value of the finding. The allowed values are the following.
	//
	// *
	// INFORMATIONAL - No issue was found.
	//
	// * LOW - The issue does not require action
	// on its own.
	//
	// * MEDIUM - The issue must be addressed but not urgently.
	//
	// * HIGH -
	// The issue must be addressed as a priority.
	//
	// * CRITICAL - The issue must be
	// remediated immediately to avoid it escalating.
	//
	// If you provide Normalized and do
	// not provide Label, then Label is set automatically as follows.
	//
	// * 0 -
	// INFORMATIONAL
	//
	// * 1–39 - LOW
	//
	// * 40–69 - MEDIUM
	//
	// * 70–89 - HIGH
	//
	// * 90–100 -
	// CRITICAL
	Label SeverityLabel

	// Deprecated. The normalized severity of a finding. This attribute is being
	// deprecated. Instead of providing Normalized, provide Label. If you provide Label
	// and do not provide Normalized, then Normalized is set automatically as
	// follows.
	//
	// * INFORMATIONAL - 0
	//
	// * LOW - 1
	//
	// * MEDIUM - 40
	//
	// * HIGH - 70
	//
	// * CRITICAL
	// - 90
	Normalized int32

	// The native severity from the finding product that generated the finding.
	Original *string

	// Deprecated. This attribute is being deprecated. Instead of providing Product,
	// provide Original. The native severity as defined by the Amazon Web Services
	// service or integrated partner product that generated the finding.
	Product float64

	noSmithyDocumentSerde
}

// Updates to the severity information for a finding.
type SeverityUpdate struct {

	// The severity value of the finding. The allowed values are the following.
	//
	// *
	// INFORMATIONAL - No issue was found.
	//
	// * LOW - The issue does not require action
	// on its own.
	//
	// * MEDIUM - The issue must be addressed but not urgently.
	//
	// * HIGH -
	// The issue must be addressed as a priority.
	//
	// * CRITICAL - The issue must be
	// remediated immediately to avoid it escalating.
	Label SeverityLabel

	// The normalized severity for the finding. This attribute is to be deprecated in
	// favor of Label. If you provide Normalized and do not provide Label, Label is set
	// automatically as follows.
	//
	// * 0 - INFORMATIONAL
	//
	// * 1–39 - LOW
	//
	// * 40–69 -
	// MEDIUM
	//
	// * 70–89 - HIGH
	//
	// * 90–100 - CRITICAL
	Normalized int32

	// The native severity as defined by the Amazon Web Services service or integrated
	// partner product that generated the finding.
	Product float64

	noSmithyDocumentSerde
}

// Information about a software package.
type SoftwarePackage struct {

	// The architecture used for the software package.
	Architecture *string

	// The epoch of the software package.
	Epoch *string

	// The file system path to the package manager inventory file.
	FilePath *string

	// The name of the software package.
	Name *string

	// The source of the package.
	PackageManager *string

	// The release of the software package.
	Release *string

	// The version of the software package.
	Version *string

	noSmithyDocumentSerde
}

// A collection of finding attributes used to sort findings.
type SortCriterion struct {

	// The finding attribute used to sort findings.
	Field *string

	// The order used to sort findings.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// Provides information about a specific standard.
type Standard struct {

	// A description of the standard.
	Description *string

	// Whether the standard is enabled by default. When Security Hub is enabled from
	// the console, if a standard is enabled by default, the check box for that
	// standard is selected by default. When Security Hub is enabled using the
	// EnableSecurityHub API operation, the standard is enabled by default unless
	// EnableDefaultStandards is set to false.
	EnabledByDefault bool

	// The name of the standard.
	Name *string

	// The ARN of a standard.
	StandardsArn *string

	noSmithyDocumentSerde
}

// Details for an individual security standard control.
type StandardsControl struct {

	// The identifier of the security standard control.
	ControlId *string

	// The current status of the security standard control. Indicates whether the
	// control is enabled or disabled. Security Hub does not check against disabled
	// controls.
	ControlStatus ControlStatus

	// The date and time that the status of the security standard control was most
	// recently updated.
	ControlStatusUpdatedAt *time.Time

	// The longer description of the security standard control. Provides information
	// about what the control is checking for.
	Description *string

	// The reason provided for the most recent change in status for the control.
	DisabledReason *string

	// The list of requirements that are related to this control.
	RelatedRequirements []string

	// A link to remediation information for the control in the Security Hub user
	// documentation.
	RemediationUrl *string

	// The severity of findings generated from this security standard control. The
	// finding severity is based on an assessment of how easy it would be to compromise
	// Amazon Web Services resources if the issue is detected.
	SeverityRating SeverityRating

	// The ARN of the security standard control.
	StandardsControlArn *string

	// The title of the security standard control.
	Title *string

	noSmithyDocumentSerde
}

// The reason for the current status of a standard subscription.
type StandardsStatusReason struct {

	// The reason code that represents the reason for the current status of a standard
	// subscription.
	//
	// This member is required.
	StatusReasonCode StatusReasonCode

	noSmithyDocumentSerde
}

// A resource that represents your subscription to a supported standard.
type StandardsSubscription struct {

	// The ARN of a standard.
	//
	// This member is required.
	StandardsArn *string

	// A key-value pair of input for the standard.
	//
	// This member is required.
	StandardsInput map[string]string

	// The status of the standard subscription. The status values are as follows:
	//
	// *
	// PENDING - Standard is in the process of being enabled.
	//
	// * READY - Standard is
	// enabled.
	//
	// * INCOMPLETE - Standard could not be enabled completely. Some controls
	// may not be available.
	//
	// * DELETING - Standard is in the process of being
	// disabled.
	//
	// * FAILED - Standard could not be disabled.
	//
	// This member is required.
	StandardsStatus StandardsStatus

	// The ARN of a resource that represents your subscription to a supported standard.
	//
	// This member is required.
	StandardsSubscriptionArn *string

	// The reason for the current status.
	StandardsStatusReason *StandardsStatusReason

	noSmithyDocumentSerde
}

// The standard that you want to enable.
type StandardsSubscriptionRequest struct {

	// The ARN of the standard that you want to enable. To view the list of available
	// standards and their ARNs, use the DescribeStandards operation.
	//
	// This member is required.
	StandardsArn *string

	// A key-value pair of input for the standard.
	StandardsInput map[string]string

	noSmithyDocumentSerde
}

// The definition of a custom action that can be used for stateless packet
// handling.
type StatelessCustomActionDefinition struct {

	// Information about metrics to publish to CloudWatch.
	PublishMetricAction *StatelessCustomPublishMetricAction

	noSmithyDocumentSerde
}

// Information about metrics to publish to CloudWatch.
type StatelessCustomPublishMetricAction struct {

	// Defines CloudWatch dimension values to publish.
	Dimensions []StatelessCustomPublishMetricActionDimension

	noSmithyDocumentSerde
}

// Defines a CloudWatch dimension value to publish.
type StatelessCustomPublishMetricActionDimension struct {

	// The value to use for the custom metric dimension.
	Value *string

	noSmithyDocumentSerde
}

// Provides additional context for the value of Compliance.Status.
type StatusReason struct {

	// A code that represents a reason for the control status. For the list of status
	// reason codes and their meanings, see Standards-related information in the ASFF
	// (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff)
	// in the Security Hub User Guide.
	//
	// This member is required.
	ReasonCode *string

	// The corresponding description for the status reason code.
	Description *string

	noSmithyDocumentSerde
}

// A string filter for querying findings.
type StringFilter struct {

	// The condition to apply to a string value when querying for findings. To search
	// for values that contain the filter criteria value, use one of the following
	// comparison operators:
	//
	// * To search for values that exactly match the filter
	// value, use EQUALS. For example, the filter ResourceType EQUALS
	// AwsEc2SecurityGroup only matches findings that have a resource type of
	// AwsEc2SecurityGroup.
	//
	// * To search for values that start with the filter value,
	// use PREFIX. For example, the filter ResourceType PREFIX AwsIam matches findings
	// that have a resource type that starts with AwsIam. Findings with a resource type
	// of AwsIamPolicy, AwsIamRole, or AwsIamUser would all match.
	//
	// EQUALS and PREFIX
	// filters on the same field are joined by OR. A finding matches if it matches any
	// one of those filters. To search for values that do not contain the filter
	// criteria value, use one of the following comparison operators:
	//
	// * To search for
	// values that do not exactly match the filter value, use NOT_EQUALS. For example,
	// the filter ResourceType NOT_EQUALS AwsIamPolicy matches findings that have a
	// resource type other than AwsIamPolicy.
	//
	// * To search for values that do not start
	// with the filter value, use PREFIX_NOT_EQUALS. For example, the filter
	// ResourceType PREFIX_NOT_EQUALS AwsIam matches findings that have a resource type
	// that does not start with AwsIam. Findings with a resource type of AwsIamPolicy,
	// AwsIamRole, or AwsIamUser would all be excluded from the results.
	//
	// NOT_EQUALS
	// and PREFIX_NOT_EQUALS filters on the same field are joined by AND. A finding
	// matches only if it matches all of those filters. For filters on the same field,
	// you cannot provide both an EQUALS filter and a NOT_EQUALS or PREFIX_NOT_EQUALS
	// filter. Combining filters in this way always returns an error, even if the
	// provided filter values would return valid results. You can combine PREFIX
	// filters with NOT_EQUALS or PREFIX_NOT_EQUALS filters for the same field.
	// Security Hub first processes the PREFIX filters, then the NOT_EQUALS or
	// PREFIX_NOT_EQUALS filters. For example, for the following filter, Security Hub
	// first identifies findings that have resource types that start with either AwsIAM
	// or AwsEc2. It then excludes findings that have a resource type of AwsIamPolicy
	// and findings that have a resource type of AwsEc2NetworkInterface.
	//
	// *
	// ResourceType PREFIX AwsIam
	//
	// * ResourceType PREFIX AwsEc2
	//
	// * ResourceType
	// NOT_EQUALS AwsIamPolicy
	//
	// * ResourceType NOT_EQUALS AwsEc2NetworkInterface
	Comparison StringFilterComparison

	// The string filter value. Filter values are case sensitive. For example, the
	// product name for control-based findings is Security Hub. If you provide security
	// hub as the filter text, then there is no match.
	Value *string

	noSmithyDocumentSerde
}

// Details about the threat intelligence related to a finding.
type ThreatIntelIndicator struct {

	// The category of a threat intelligence indicator.
	Category ThreatIntelIndicatorCategory

	// Indicates when the most recent instance of a threat intelligence indicator was
	// observed. Uses the date-time format specified in RFC 3339 section 5.6, Internet
	// Date/Time Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value
	// cannot contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastObservedAt *string

	// The source of the threat intelligence indicator.
	Source *string

	// The URL to the page or site where you can get more information about the threat
	// intelligence indicator.
	SourceUrl *string

	// The type of threat intelligence indicator.
	Type ThreatIntelIndicatorType

	// The value of a threat intelligence indicator.
	Value *string

	noSmithyDocumentSerde
}

// A vulnerability associated with a finding.
type Vulnerability struct {

	// The identifier of the vulnerability.
	//
	// This member is required.
	Id *string

	// CVSS scores from the advisory related to the vulnerability.
	Cvss []Cvss

	// A list of URLs that provide additional information about the vulnerability.
	ReferenceUrls []string

	// List of vulnerabilities that are related to this vulnerability.
	RelatedVulnerabilities []string

	// Information about the vendor that generates the vulnerability report.
	Vendor *VulnerabilityVendor

	// List of software packages that have the vulnerability.
	VulnerablePackages []SoftwarePackage

	noSmithyDocumentSerde
}

// A vendor that generates a vulnerability report.
type VulnerabilityVendor struct {

	// The name of the vendor.
	//
	// This member is required.
	Name *string

	// The URL of the vulnerability advisory.
	Url *string

	// Indicates when the vulnerability advisory was created. Uses the date-time format
	// specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	VendorCreatedAt *string

	// The severity that the vendor assigned to the vulnerability.
	VendorSeverity *string

	// Indicates when the vulnerability advisory was last updated. Uses the date-time
	// format specified in RFC 3339 section 5.6, Internet Date/Time Format
	// (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain
	// spaces. For example, 2020-03-22T13:22:13.933Z.
	VendorUpdatedAt *string

	noSmithyDocumentSerde
}

// Details about the action that CloudFront or WAF takes when a web request matches
// the conditions in the rule.
type WafAction struct {

	// Specifies how you want WAF to respond to requests that match the settings in a
	// rule. Valid settings include the following:
	//
	// * ALLOW - WAF allows requests
	//
	// *
	// BLOCK - WAF blocks requests
	//
	// * COUNT - WAF increments a counter of the requests
	// that match all of the conditions in the rule. WAF then continues to inspect the
	// web request based on the remaining rules in the web ACL. You can't specify COUNT
	// for the default action for a WebACL.
	Type *string

	noSmithyDocumentSerde
}

// Details about a rule to exclude from a rule group.
type WafExcludedRule struct {

	// The unique identifier for the rule to exclude from the rule group.
	RuleId *string

	noSmithyDocumentSerde
}

// Details about an override action for a rule.
type WafOverrideAction struct {

	// COUNT overrides the action specified by the individual rule within a RuleGroup .
	// If set to NONE, the rule's action takes place.
	Type *string

	noSmithyDocumentSerde
}

// Provides information about the status of the investigation into a finding.
type Workflow struct {

	// The status of the investigation into the finding. The workflow status is
	// specific to an individual finding. It does not affect the generation of new
	// findings. For example, setting the workflow status to SUPPRESSED or RESOLVED
	// does not prevent a new finding for the same issue. The allowed values are the
	// following.
	//
	// * NEW - The initial state of a finding, before it is reviewed.
	// Security Hub also resets the workflow status from NOTIFIED or RESOLVED to NEW in
	// the following cases:
	//
	// * RecordState changes from ARCHIVED to ACTIVE.
	//
	// *
	// ComplianceStatus changes from PASSED to either WARNING, FAILED, or
	// NOT_AVAILABLE.
	//
	// * NOTIFIED - Indicates that you notified the resource owner
	// about the security issue. Used when the initial reviewer is not the resource
	// owner, and needs intervention from the resource owner.
	//
	// * SUPPRESSED - Indicates
	// that you reviewed the finding and do not believe that any action is needed. The
	// finding is no longer updated.
	//
	// * RESOLVED - The finding was reviewed and
	// remediated and is now considered resolved.
	Status WorkflowStatus

	noSmithyDocumentSerde
}

// Used to update information about the investigation into the finding.
type WorkflowUpdate struct {

	// The status of the investigation into the finding. The workflow status is
	// specific to an individual finding. It does not affect the generation of new
	// findings. For example, setting the workflow status to SUPPRESSED or RESOLVED
	// does not prevent a new finding for the same issue. The allowed values are the
	// following.
	//
	// * NEW - The initial state of a finding, before it is reviewed.
	// Security Hub also resets WorkFlowStatus from NOTIFIED or RESOLVED to NEW in the
	// following cases:
	//
	// * The record state changes from ARCHIVED to ACTIVE.
	//
	// * The
	// compliance status changes from PASSED to either WARNING, FAILED, or
	// NOT_AVAILABLE.
	//
	// * NOTIFIED - Indicates that you notified the resource owner
	// about the security issue. Used when the initial reviewer is not the resource
	// owner, and needs intervention from the resource owner.
	//
	// * RESOLVED - The finding
	// was reviewed and remediated and is now considered resolved.
	//
	// * SUPPRESSED -
	// Indicates that you reviewed the finding and do not believe that any action is
	// needed. The finding is no longer updated.
	Status WorkflowStatus

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
