// Code generated by smithy-go-codegen DO NOT EDIT.

package route53recoveryreadiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/route53recoveryreadiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns detailed information about the status of an individual resource within a
// Readiness Check's Resource Set.
func (c *Client) GetReadinessCheckResourceStatus(ctx context.Context, params *GetReadinessCheckResourceStatusInput, optFns ...func(*Options)) (*GetReadinessCheckResourceStatusOutput, error) {
	if params == nil {
		params = &GetReadinessCheckResourceStatusInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetReadinessCheckResourceStatus", params, optFns, c.addOperationGetReadinessCheckResourceStatusMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetReadinessCheckResourceStatusOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetReadinessCheckResourceStatusInput struct {

	// The ReadinessCheck to get
	//
	// This member is required.
	ReadinessCheckName *string

	// The resource ARN or component Id to get
	//
	// This member is required.
	ResourceIdentifier *string

	// Upper bound on number of records to return.
	MaxResults int32

	// A token used to resume pagination from the end of a previous request.
	NextToken *string

	noSmithyDocumentSerde
}

type GetReadinessCheckResourceStatusOutput struct {

	// A token that can be used to resume pagination from the end of the collection.
	NextToken *string

	// The readiness at rule level.
	Readiness types.Readiness

	// Details of the rules's results
	Rules []types.RuleResult

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetReadinessCheckResourceStatusMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetReadinessCheckResourceStatus{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetReadinessCheckResourceStatus{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetReadinessCheckResourceStatusValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetReadinessCheckResourceStatus(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// GetReadinessCheckResourceStatusAPIClient is a client that implements the
// GetReadinessCheckResourceStatus operation.
type GetReadinessCheckResourceStatusAPIClient interface {
	GetReadinessCheckResourceStatus(context.Context, *GetReadinessCheckResourceStatusInput, ...func(*Options)) (*GetReadinessCheckResourceStatusOutput, error)
}

var _ GetReadinessCheckResourceStatusAPIClient = (*Client)(nil)

// GetReadinessCheckResourceStatusPaginatorOptions is the paginator options for
// GetReadinessCheckResourceStatus
type GetReadinessCheckResourceStatusPaginatorOptions struct {
	// Upper bound on number of records to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetReadinessCheckResourceStatusPaginator is a paginator for
// GetReadinessCheckResourceStatus
type GetReadinessCheckResourceStatusPaginator struct {
	options   GetReadinessCheckResourceStatusPaginatorOptions
	client    GetReadinessCheckResourceStatusAPIClient
	params    *GetReadinessCheckResourceStatusInput
	nextToken *string
	firstPage bool
}

// NewGetReadinessCheckResourceStatusPaginator returns a new
// GetReadinessCheckResourceStatusPaginator
func NewGetReadinessCheckResourceStatusPaginator(client GetReadinessCheckResourceStatusAPIClient, params *GetReadinessCheckResourceStatusInput, optFns ...func(*GetReadinessCheckResourceStatusPaginatorOptions)) *GetReadinessCheckResourceStatusPaginator {
	if params == nil {
		params = &GetReadinessCheckResourceStatusInput{}
	}

	options := GetReadinessCheckResourceStatusPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetReadinessCheckResourceStatusPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetReadinessCheckResourceStatusPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetReadinessCheckResourceStatus page.
func (p *GetReadinessCheckResourceStatusPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetReadinessCheckResourceStatusOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.GetReadinessCheckResourceStatus(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opGetReadinessCheckResourceStatus(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "route53-recovery-readiness",
		OperationName: "GetReadinessCheckResourceStatus",
	}
}
