// Code generated by smithy-go-codegen DO NOT EDIT.

package redshift

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/query"
	"github.com/aws/aws-sdk-go-v2/service/redshift/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsquery_serializeOpAcceptReservedNodeExchange struct {
}

func (*awsAwsquery_serializeOpAcceptReservedNodeExchange) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAcceptReservedNodeExchange) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcceptReservedNodeExchangeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AcceptReservedNodeExchange")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentAcceptReservedNodeExchangeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpAddPartner struct {
}

func (*awsAwsquery_serializeOpAddPartner) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAddPartner) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddPartnerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AddPartner")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentAddPartnerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpAssociateDataShareConsumer struct {
}

func (*awsAwsquery_serializeOpAssociateDataShareConsumer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAssociateDataShareConsumer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateDataShareConsumerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateDataShareConsumer")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentAssociateDataShareConsumerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpAuthorizeClusterSecurityGroupIngress struct {
}

func (*awsAwsquery_serializeOpAuthorizeClusterSecurityGroupIngress) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAuthorizeClusterSecurityGroupIngress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AuthorizeClusterSecurityGroupIngressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AuthorizeClusterSecurityGroupIngress")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentAuthorizeClusterSecurityGroupIngressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpAuthorizeDataShare struct {
}

func (*awsAwsquery_serializeOpAuthorizeDataShare) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAuthorizeDataShare) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AuthorizeDataShareInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AuthorizeDataShare")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentAuthorizeDataShareInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpAuthorizeEndpointAccess struct {
}

func (*awsAwsquery_serializeOpAuthorizeEndpointAccess) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAuthorizeEndpointAccess) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AuthorizeEndpointAccessInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AuthorizeEndpointAccess")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentAuthorizeEndpointAccessInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpAuthorizeSnapshotAccess struct {
}

func (*awsAwsquery_serializeOpAuthorizeSnapshotAccess) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAuthorizeSnapshotAccess) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AuthorizeSnapshotAccessInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AuthorizeSnapshotAccess")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentAuthorizeSnapshotAccessInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpBatchDeleteClusterSnapshots struct {
}

func (*awsAwsquery_serializeOpBatchDeleteClusterSnapshots) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpBatchDeleteClusterSnapshots) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteClusterSnapshotsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("BatchDeleteClusterSnapshots")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentBatchDeleteClusterSnapshotsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpBatchModifyClusterSnapshots struct {
}

func (*awsAwsquery_serializeOpBatchModifyClusterSnapshots) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpBatchModifyClusterSnapshots) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchModifyClusterSnapshotsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("BatchModifyClusterSnapshots")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentBatchModifyClusterSnapshotsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCancelResize struct {
}

func (*awsAwsquery_serializeOpCancelResize) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCancelResize) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelResizeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CancelResize")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCancelResizeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCopyClusterSnapshot struct {
}

func (*awsAwsquery_serializeOpCopyClusterSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCopyClusterSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CopyClusterSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CopyClusterSnapshot")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCopyClusterSnapshotInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateAuthenticationProfile struct {
}

func (*awsAwsquery_serializeOpCreateAuthenticationProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateAuthenticationProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAuthenticationProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateAuthenticationProfile")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateAuthenticationProfileInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateCluster struct {
}

func (*awsAwsquery_serializeOpCreateCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateCluster")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateClusterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateClusterParameterGroup struct {
}

func (*awsAwsquery_serializeOpCreateClusterParameterGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateClusterParameterGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateClusterParameterGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateClusterParameterGroup")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateClusterParameterGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateClusterSecurityGroup struct {
}

func (*awsAwsquery_serializeOpCreateClusterSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateClusterSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateClusterSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateClusterSecurityGroup")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateClusterSecurityGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateClusterSnapshot struct {
}

func (*awsAwsquery_serializeOpCreateClusterSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateClusterSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateClusterSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateClusterSnapshot")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateClusterSnapshotInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateClusterSubnetGroup struct {
}

func (*awsAwsquery_serializeOpCreateClusterSubnetGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateClusterSubnetGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateClusterSubnetGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateClusterSubnetGroup")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateClusterSubnetGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateEndpointAccess struct {
}

func (*awsAwsquery_serializeOpCreateEndpointAccess) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateEndpointAccess) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateEndpointAccessInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateEndpointAccess")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateEndpointAccessInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateEventSubscription struct {
}

func (*awsAwsquery_serializeOpCreateEventSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateEventSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateEventSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateEventSubscription")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateEventSubscriptionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateHsmClientCertificate struct {
}

func (*awsAwsquery_serializeOpCreateHsmClientCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateHsmClientCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateHsmClientCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateHsmClientCertificate")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateHsmClientCertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateHsmConfiguration struct {
}

func (*awsAwsquery_serializeOpCreateHsmConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateHsmConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateHsmConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateHsmConfiguration")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateHsmConfigurationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateScheduledAction struct {
}

func (*awsAwsquery_serializeOpCreateScheduledAction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateScheduledAction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateScheduledActionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateScheduledAction")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateScheduledActionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateSnapshotCopyGrant struct {
}

func (*awsAwsquery_serializeOpCreateSnapshotCopyGrant) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateSnapshotCopyGrant) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSnapshotCopyGrantInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateSnapshotCopyGrant")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateSnapshotCopyGrantInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateSnapshotSchedule struct {
}

func (*awsAwsquery_serializeOpCreateSnapshotSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateSnapshotSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSnapshotScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateSnapshotSchedule")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateSnapshotScheduleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateTags struct {
}

func (*awsAwsquery_serializeOpCreateTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTags")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateUsageLimit struct {
}

func (*awsAwsquery_serializeOpCreateUsageLimit) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateUsageLimit) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateUsageLimitInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateUsageLimit")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateUsageLimitInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeauthorizeDataShare struct {
}

func (*awsAwsquery_serializeOpDeauthorizeDataShare) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeauthorizeDataShare) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeauthorizeDataShareInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeauthorizeDataShare")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeauthorizeDataShareInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteAuthenticationProfile struct {
}

func (*awsAwsquery_serializeOpDeleteAuthenticationProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteAuthenticationProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAuthenticationProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteAuthenticationProfile")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteAuthenticationProfileInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteCluster struct {
}

func (*awsAwsquery_serializeOpDeleteCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteCluster")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteClusterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteClusterParameterGroup struct {
}

func (*awsAwsquery_serializeOpDeleteClusterParameterGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteClusterParameterGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteClusterParameterGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteClusterParameterGroup")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteClusterParameterGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteClusterSecurityGroup struct {
}

func (*awsAwsquery_serializeOpDeleteClusterSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteClusterSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteClusterSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteClusterSecurityGroup")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteClusterSecurityGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteClusterSnapshot struct {
}

func (*awsAwsquery_serializeOpDeleteClusterSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteClusterSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteClusterSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteClusterSnapshot")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteClusterSnapshotInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteClusterSubnetGroup struct {
}

func (*awsAwsquery_serializeOpDeleteClusterSubnetGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteClusterSubnetGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteClusterSubnetGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteClusterSubnetGroup")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteClusterSubnetGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteEndpointAccess struct {
}

func (*awsAwsquery_serializeOpDeleteEndpointAccess) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteEndpointAccess) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteEndpointAccessInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteEndpointAccess")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteEndpointAccessInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteEventSubscription struct {
}

func (*awsAwsquery_serializeOpDeleteEventSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteEventSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteEventSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteEventSubscription")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteEventSubscriptionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteHsmClientCertificate struct {
}

func (*awsAwsquery_serializeOpDeleteHsmClientCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteHsmClientCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteHsmClientCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteHsmClientCertificate")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteHsmClientCertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteHsmConfiguration struct {
}

func (*awsAwsquery_serializeOpDeleteHsmConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteHsmConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteHsmConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteHsmConfiguration")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteHsmConfigurationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeletePartner struct {
}

func (*awsAwsquery_serializeOpDeletePartner) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeletePartner) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePartnerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeletePartner")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeletePartnerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteScheduledAction struct {
}

func (*awsAwsquery_serializeOpDeleteScheduledAction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteScheduledAction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteScheduledActionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteScheduledAction")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteScheduledActionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteSnapshotCopyGrant struct {
}

func (*awsAwsquery_serializeOpDeleteSnapshotCopyGrant) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteSnapshotCopyGrant) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSnapshotCopyGrantInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteSnapshotCopyGrant")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteSnapshotCopyGrantInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteSnapshotSchedule struct {
}

func (*awsAwsquery_serializeOpDeleteSnapshotSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteSnapshotSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSnapshotScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteSnapshotSchedule")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteSnapshotScheduleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteTags struct {
}

func (*awsAwsquery_serializeOpDeleteTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTags")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteUsageLimit struct {
}

func (*awsAwsquery_serializeOpDeleteUsageLimit) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteUsageLimit) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUsageLimitInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteUsageLimit")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteUsageLimitInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAccountAttributes struct {
}

func (*awsAwsquery_serializeOpDescribeAccountAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAccountAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAccountAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAccountAttributes")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeAccountAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAuthenticationProfiles struct {
}

func (*awsAwsquery_serializeOpDescribeAuthenticationProfiles) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAuthenticationProfiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAuthenticationProfilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAuthenticationProfiles")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeAuthenticationProfilesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeClusterDbRevisions struct {
}

func (*awsAwsquery_serializeOpDescribeClusterDbRevisions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeClusterDbRevisions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClusterDbRevisionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClusterDbRevisions")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeClusterDbRevisionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeClusterParameterGroups struct {
}

func (*awsAwsquery_serializeOpDescribeClusterParameterGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeClusterParameterGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClusterParameterGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClusterParameterGroups")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeClusterParameterGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeClusterParameters struct {
}

func (*awsAwsquery_serializeOpDescribeClusterParameters) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeClusterParameters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClusterParametersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClusterParameters")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeClusterParametersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeClusters struct {
}

func (*awsAwsquery_serializeOpDescribeClusters) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeClusters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClustersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClusters")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeClustersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeClusterSecurityGroups struct {
}

func (*awsAwsquery_serializeOpDescribeClusterSecurityGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeClusterSecurityGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClusterSecurityGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClusterSecurityGroups")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeClusterSecurityGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeClusterSnapshots struct {
}

func (*awsAwsquery_serializeOpDescribeClusterSnapshots) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeClusterSnapshots) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClusterSnapshotsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClusterSnapshots")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeClusterSnapshotsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeClusterSubnetGroups struct {
}

func (*awsAwsquery_serializeOpDescribeClusterSubnetGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeClusterSubnetGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClusterSubnetGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClusterSubnetGroups")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeClusterSubnetGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeClusterTracks struct {
}

func (*awsAwsquery_serializeOpDescribeClusterTracks) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeClusterTracks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClusterTracksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClusterTracks")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeClusterTracksInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeClusterVersions struct {
}

func (*awsAwsquery_serializeOpDescribeClusterVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeClusterVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClusterVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClusterVersions")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeClusterVersionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeDataShares struct {
}

func (*awsAwsquery_serializeOpDescribeDataShares) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeDataShares) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataSharesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeDataShares")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeDataSharesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeDataSharesForConsumer struct {
}

func (*awsAwsquery_serializeOpDescribeDataSharesForConsumer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeDataSharesForConsumer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataSharesForConsumerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeDataSharesForConsumer")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeDataSharesForConsumerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeDataSharesForProducer struct {
}

func (*awsAwsquery_serializeOpDescribeDataSharesForProducer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeDataSharesForProducer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataSharesForProducerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeDataSharesForProducer")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeDataSharesForProducerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeDefaultClusterParameters struct {
}

func (*awsAwsquery_serializeOpDescribeDefaultClusterParameters) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeDefaultClusterParameters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDefaultClusterParametersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeDefaultClusterParameters")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeDefaultClusterParametersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeEndpointAccess struct {
}

func (*awsAwsquery_serializeOpDescribeEndpointAccess) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeEndpointAccess) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEndpointAccessInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeEndpointAccess")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeEndpointAccessInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeEndpointAuthorization struct {
}

func (*awsAwsquery_serializeOpDescribeEndpointAuthorization) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeEndpointAuthorization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEndpointAuthorizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeEndpointAuthorization")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeEndpointAuthorizationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeEventCategories struct {
}

func (*awsAwsquery_serializeOpDescribeEventCategories) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeEventCategories) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEventCategoriesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeEventCategories")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeEventCategoriesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeEvents struct {
}

func (*awsAwsquery_serializeOpDescribeEvents) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeEvents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEventsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeEvents")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeEventsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeEventSubscriptions struct {
}

func (*awsAwsquery_serializeOpDescribeEventSubscriptions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeEventSubscriptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEventSubscriptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeEventSubscriptions")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeEventSubscriptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeHsmClientCertificates struct {
}

func (*awsAwsquery_serializeOpDescribeHsmClientCertificates) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeHsmClientCertificates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeHsmClientCertificatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeHsmClientCertificates")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeHsmClientCertificatesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeHsmConfigurations struct {
}

func (*awsAwsquery_serializeOpDescribeHsmConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeHsmConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeHsmConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeHsmConfigurations")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeHsmConfigurationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeLoggingStatus struct {
}

func (*awsAwsquery_serializeOpDescribeLoggingStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeLoggingStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLoggingStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLoggingStatus")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeLoggingStatusInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeNodeConfigurationOptions struct {
}

func (*awsAwsquery_serializeOpDescribeNodeConfigurationOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeNodeConfigurationOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeNodeConfigurationOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeNodeConfigurationOptions")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeNodeConfigurationOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeOrderableClusterOptions struct {
}

func (*awsAwsquery_serializeOpDescribeOrderableClusterOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeOrderableClusterOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeOrderableClusterOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeOrderableClusterOptions")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeOrderableClusterOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribePartners struct {
}

func (*awsAwsquery_serializeOpDescribePartners) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribePartners) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribePartnersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribePartners")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribePartnersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeReservedNodeExchangeStatus struct {
}

func (*awsAwsquery_serializeOpDescribeReservedNodeExchangeStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeReservedNodeExchangeStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReservedNodeExchangeStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeReservedNodeExchangeStatus")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeReservedNodeExchangeStatusInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeReservedNodeOfferings struct {
}

func (*awsAwsquery_serializeOpDescribeReservedNodeOfferings) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeReservedNodeOfferings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReservedNodeOfferingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeReservedNodeOfferings")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeReservedNodeOfferingsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeReservedNodes struct {
}

func (*awsAwsquery_serializeOpDescribeReservedNodes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeReservedNodes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReservedNodesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeReservedNodes")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeReservedNodesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeResize struct {
}

func (*awsAwsquery_serializeOpDescribeResize) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeResize) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeResizeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeResize")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeResizeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeScheduledActions struct {
}

func (*awsAwsquery_serializeOpDescribeScheduledActions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeScheduledActions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeScheduledActionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeScheduledActions")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeScheduledActionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeSnapshotCopyGrants struct {
}

func (*awsAwsquery_serializeOpDescribeSnapshotCopyGrants) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeSnapshotCopyGrants) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSnapshotCopyGrantsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSnapshotCopyGrants")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeSnapshotCopyGrantsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeSnapshotSchedules struct {
}

func (*awsAwsquery_serializeOpDescribeSnapshotSchedules) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeSnapshotSchedules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSnapshotSchedulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSnapshotSchedules")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeSnapshotSchedulesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeStorage struct {
}

func (*awsAwsquery_serializeOpDescribeStorage) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeStorage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeStorageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeStorage")
	body.Key("Version").String("2012-12-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeTableRestoreStatus struct {
}

func (*awsAwsquery_serializeOpDescribeTableRestoreStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeTableRestoreStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTableRestoreStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTableRestoreStatus")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeTableRestoreStatusInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeTags struct {
}

func (*awsAwsquery_serializeOpDescribeTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTags")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeUsageLimits struct {
}

func (*awsAwsquery_serializeOpDescribeUsageLimits) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeUsageLimits) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeUsageLimitsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeUsageLimits")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeUsageLimitsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDisableLogging struct {
}

func (*awsAwsquery_serializeOpDisableLogging) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDisableLogging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableLoggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisableLogging")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDisableLoggingInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDisableSnapshotCopy struct {
}

func (*awsAwsquery_serializeOpDisableSnapshotCopy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDisableSnapshotCopy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableSnapshotCopyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisableSnapshotCopy")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDisableSnapshotCopyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDisassociateDataShareConsumer struct {
}

func (*awsAwsquery_serializeOpDisassociateDataShareConsumer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDisassociateDataShareConsumer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateDataShareConsumerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisassociateDataShareConsumer")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentDisassociateDataShareConsumerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpEnableLogging struct {
}

func (*awsAwsquery_serializeOpEnableLogging) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpEnableLogging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableLoggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("EnableLogging")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentEnableLoggingInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpEnableSnapshotCopy struct {
}

func (*awsAwsquery_serializeOpEnableSnapshotCopy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpEnableSnapshotCopy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableSnapshotCopyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("EnableSnapshotCopy")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentEnableSnapshotCopyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetClusterCredentials struct {
}

func (*awsAwsquery_serializeOpGetClusterCredentials) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetClusterCredentials) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetClusterCredentialsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetClusterCredentials")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentGetClusterCredentialsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetReservedNodeExchangeConfigurationOptions struct {
}

func (*awsAwsquery_serializeOpGetReservedNodeExchangeConfigurationOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetReservedNodeExchangeConfigurationOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetReservedNodeExchangeConfigurationOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetReservedNodeExchangeConfigurationOptions")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentGetReservedNodeExchangeConfigurationOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetReservedNodeExchangeOfferings struct {
}

func (*awsAwsquery_serializeOpGetReservedNodeExchangeOfferings) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetReservedNodeExchangeOfferings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetReservedNodeExchangeOfferingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetReservedNodeExchangeOfferings")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentGetReservedNodeExchangeOfferingsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyAquaConfiguration struct {
}

func (*awsAwsquery_serializeOpModifyAquaConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyAquaConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyAquaConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyAquaConfiguration")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyAquaConfigurationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyAuthenticationProfile struct {
}

func (*awsAwsquery_serializeOpModifyAuthenticationProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyAuthenticationProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyAuthenticationProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyAuthenticationProfile")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyAuthenticationProfileInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyCluster struct {
}

func (*awsAwsquery_serializeOpModifyCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyCluster")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyClusterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyClusterDbRevision struct {
}

func (*awsAwsquery_serializeOpModifyClusterDbRevision) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyClusterDbRevision) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyClusterDbRevisionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyClusterDbRevision")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyClusterDbRevisionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyClusterIamRoles struct {
}

func (*awsAwsquery_serializeOpModifyClusterIamRoles) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyClusterIamRoles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyClusterIamRolesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyClusterIamRoles")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyClusterIamRolesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyClusterMaintenance struct {
}

func (*awsAwsquery_serializeOpModifyClusterMaintenance) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyClusterMaintenance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyClusterMaintenanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyClusterMaintenance")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyClusterMaintenanceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyClusterParameterGroup struct {
}

func (*awsAwsquery_serializeOpModifyClusterParameterGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyClusterParameterGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyClusterParameterGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyClusterParameterGroup")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyClusterParameterGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyClusterSnapshot struct {
}

func (*awsAwsquery_serializeOpModifyClusterSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyClusterSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyClusterSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyClusterSnapshot")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyClusterSnapshotInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyClusterSnapshotSchedule struct {
}

func (*awsAwsquery_serializeOpModifyClusterSnapshotSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyClusterSnapshotSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyClusterSnapshotScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyClusterSnapshotSchedule")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyClusterSnapshotScheduleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyClusterSubnetGroup struct {
}

func (*awsAwsquery_serializeOpModifyClusterSubnetGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyClusterSubnetGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyClusterSubnetGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyClusterSubnetGroup")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyClusterSubnetGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyEndpointAccess struct {
}

func (*awsAwsquery_serializeOpModifyEndpointAccess) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyEndpointAccess) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyEndpointAccessInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyEndpointAccess")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyEndpointAccessInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyEventSubscription struct {
}

func (*awsAwsquery_serializeOpModifyEventSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyEventSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyEventSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyEventSubscription")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyEventSubscriptionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyScheduledAction struct {
}

func (*awsAwsquery_serializeOpModifyScheduledAction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyScheduledAction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyScheduledActionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyScheduledAction")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyScheduledActionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifySnapshotCopyRetentionPeriod struct {
}

func (*awsAwsquery_serializeOpModifySnapshotCopyRetentionPeriod) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifySnapshotCopyRetentionPeriod) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifySnapshotCopyRetentionPeriodInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifySnapshotCopyRetentionPeriod")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifySnapshotCopyRetentionPeriodInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifySnapshotSchedule struct {
}

func (*awsAwsquery_serializeOpModifySnapshotSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifySnapshotSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifySnapshotScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifySnapshotSchedule")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifySnapshotScheduleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyUsageLimit struct {
}

func (*awsAwsquery_serializeOpModifyUsageLimit) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyUsageLimit) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyUsageLimitInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyUsageLimit")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyUsageLimitInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPauseCluster struct {
}

func (*awsAwsquery_serializeOpPauseCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPauseCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PauseClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PauseCluster")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentPauseClusterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPurchaseReservedNodeOffering struct {
}

func (*awsAwsquery_serializeOpPurchaseReservedNodeOffering) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPurchaseReservedNodeOffering) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PurchaseReservedNodeOfferingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PurchaseReservedNodeOffering")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentPurchaseReservedNodeOfferingInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRebootCluster struct {
}

func (*awsAwsquery_serializeOpRebootCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRebootCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RebootClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RebootCluster")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentRebootClusterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRejectDataShare struct {
}

func (*awsAwsquery_serializeOpRejectDataShare) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRejectDataShare) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RejectDataShareInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RejectDataShare")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentRejectDataShareInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpResetClusterParameterGroup struct {
}

func (*awsAwsquery_serializeOpResetClusterParameterGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpResetClusterParameterGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResetClusterParameterGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ResetClusterParameterGroup")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentResetClusterParameterGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpResizeCluster struct {
}

func (*awsAwsquery_serializeOpResizeCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpResizeCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResizeClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ResizeCluster")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentResizeClusterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRestoreFromClusterSnapshot struct {
}

func (*awsAwsquery_serializeOpRestoreFromClusterSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRestoreFromClusterSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RestoreFromClusterSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RestoreFromClusterSnapshot")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentRestoreFromClusterSnapshotInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRestoreTableFromClusterSnapshot struct {
}

func (*awsAwsquery_serializeOpRestoreTableFromClusterSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRestoreTableFromClusterSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RestoreTableFromClusterSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RestoreTableFromClusterSnapshot")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentRestoreTableFromClusterSnapshotInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpResumeCluster struct {
}

func (*awsAwsquery_serializeOpResumeCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpResumeCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResumeClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ResumeCluster")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentResumeClusterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRevokeClusterSecurityGroupIngress struct {
}

func (*awsAwsquery_serializeOpRevokeClusterSecurityGroupIngress) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRevokeClusterSecurityGroupIngress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RevokeClusterSecurityGroupIngressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RevokeClusterSecurityGroupIngress")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentRevokeClusterSecurityGroupIngressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRevokeEndpointAccess struct {
}

func (*awsAwsquery_serializeOpRevokeEndpointAccess) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRevokeEndpointAccess) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RevokeEndpointAccessInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RevokeEndpointAccess")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentRevokeEndpointAccessInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRevokeSnapshotAccess struct {
}

func (*awsAwsquery_serializeOpRevokeSnapshotAccess) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRevokeSnapshotAccess) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RevokeSnapshotAccessInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RevokeSnapshotAccess")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentRevokeSnapshotAccessInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRotateEncryptionKey struct {
}

func (*awsAwsquery_serializeOpRotateEncryptionKey) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRotateEncryptionKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RotateEncryptionKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RotateEncryptionKey")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentRotateEncryptionKeyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUpdatePartnerStatus struct {
}

func (*awsAwsquery_serializeOpUpdatePartnerStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUpdatePartnerStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePartnerStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdatePartnerStatus")
	body.Key("Version").String("2012-12-01")

	if err := awsAwsquery_serializeOpDocumentUpdatePartnerStatusInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsquery_serializeDocumentAttributeNameList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("AttributeName")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentClusterSecurityGroupNameList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ClusterSecurityGroupName")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentDbGroupList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("DbGroup")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentDeleteClusterSnapshotMessage(v *types.DeleteClusterSnapshotMessage, value query.Value) error {
	object := value.Object()
	_ = object

	if v.SnapshotClusterIdentifier != nil {
		objectKey := object.Key("SnapshotClusterIdentifier")
		objectKey.String(*v.SnapshotClusterIdentifier)
	}

	if v.SnapshotIdentifier != nil {
		objectKey := object.Key("SnapshotIdentifier")
		objectKey.String(*v.SnapshotIdentifier)
	}

	return nil
}

func awsAwsquery_serializeDocumentDeleteClusterSnapshotMessageList(v []types.DeleteClusterSnapshotMessage, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("DeleteClusterSnapshotMessage")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentDeleteClusterSnapshotMessage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentEventCategoriesList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("EventCategory")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentIamRoleArnList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("IamRoleArn")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentNodeConfigurationOptionsFilter(v *types.NodeConfigurationOptionsFilter, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		objectKey := object.Key("Operator")
		objectKey.String(string(v.Operator))
	}

	if v.Values != nil {
		objectKey := object.Key("Value")
		if err := awsAwsquery_serializeDocumentValueStringList(v.Values, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentNodeConfigurationOptionsFilterList(v []types.NodeConfigurationOptionsFilter, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("NodeConfigurationOptionsFilter")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentNodeConfigurationOptionsFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentParameter(v *types.Parameter, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AllowedValues != nil {
		objectKey := object.Key("AllowedValues")
		objectKey.String(*v.AllowedValues)
	}

	if len(v.ApplyType) > 0 {
		objectKey := object.Key("ApplyType")
		objectKey.String(string(v.ApplyType))
	}

	if v.DataType != nil {
		objectKey := object.Key("DataType")
		objectKey.String(*v.DataType)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.IsModifiable {
		objectKey := object.Key("IsModifiable")
		objectKey.Boolean(v.IsModifiable)
	}

	if v.MinimumEngineVersion != nil {
		objectKey := object.Key("MinimumEngineVersion")
		objectKey.String(*v.MinimumEngineVersion)
	}

	if v.ParameterName != nil {
		objectKey := object.Key("ParameterName")
		objectKey.String(*v.ParameterName)
	}

	if v.ParameterValue != nil {
		objectKey := object.Key("ParameterValue")
		objectKey.String(*v.ParameterValue)
	}

	if v.Source != nil {
		objectKey := object.Key("Source")
		objectKey.String(*v.Source)
	}

	return nil
}

func awsAwsquery_serializeDocumentParametersList(v []types.Parameter, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Parameter")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentPauseClusterMessage(v *types.PauseClusterMessage, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	return nil
}

func awsAwsquery_serializeDocumentResizeClusterMessage(v *types.ResizeClusterMessage, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Classic != nil {
		objectKey := object.Key("Classic")
		objectKey.Boolean(*v.Classic)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.ClusterType != nil {
		objectKey := object.Key("ClusterType")
		objectKey.String(*v.ClusterType)
	}

	if v.NodeType != nil {
		objectKey := object.Key("NodeType")
		objectKey.String(*v.NodeType)
	}

	if v.NumberOfNodes != nil {
		objectKey := object.Key("NumberOfNodes")
		objectKey.Integer(*v.NumberOfNodes)
	}

	if v.ReservedNodeId != nil {
		objectKey := object.Key("ReservedNodeId")
		objectKey.String(*v.ReservedNodeId)
	}

	if v.TargetReservedNodeOfferingId != nil {
		objectKey := object.Key("TargetReservedNodeOfferingId")
		objectKey.String(*v.TargetReservedNodeOfferingId)
	}

	return nil
}

func awsAwsquery_serializeDocumentResumeClusterMessage(v *types.ResumeClusterMessage, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	return nil
}

func awsAwsquery_serializeDocumentScheduledActionFilter(v *types.ScheduledActionFilter, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	if v.Values != nil {
		objectKey := object.Key("Values")
		if err := awsAwsquery_serializeDocumentValueStringList(v.Values, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentScheduledActionFilterList(v []types.ScheduledActionFilter, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ScheduledActionFilter")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentScheduledActionFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentScheduledActionType(v *types.ScheduledActionType, value query.Value) error {
	object := value.Object()
	_ = object

	if v.PauseCluster != nil {
		objectKey := object.Key("PauseCluster")
		if err := awsAwsquery_serializeDocumentPauseClusterMessage(v.PauseCluster, objectKey); err != nil {
			return err
		}
	}

	if v.ResizeCluster != nil {
		objectKey := object.Key("ResizeCluster")
		if err := awsAwsquery_serializeDocumentResizeClusterMessage(v.ResizeCluster, objectKey); err != nil {
			return err
		}
	}

	if v.ResumeCluster != nil {
		objectKey := object.Key("ResumeCluster")
		if err := awsAwsquery_serializeDocumentResumeClusterMessage(v.ResumeCluster, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentScheduleDefinitionList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ScheduleDefinition")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentSnapshotIdentifierList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("String")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentSnapshotSortingEntity(v *types.SnapshotSortingEntity, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Attribute) > 0 {
		objectKey := object.Key("Attribute")
		objectKey.String(string(v.Attribute))
	}

	if len(v.SortOrder) > 0 {
		objectKey := object.Key("SortOrder")
		objectKey.String(string(v.SortOrder))
	}

	return nil
}

func awsAwsquery_serializeDocumentSnapshotSortingEntityList(v []types.SnapshotSortingEntity, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("SnapshotSortingEntity")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentSnapshotSortingEntity(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentSourceIdsList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("SourceId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentSubnetIdentifierList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("SubnetIdentifier")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentTag(v *types.Tag, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Key != nil {
		objectKey := object.Key("Key")
		objectKey.String(*v.Key)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsAwsquery_serializeDocumentTagKeyList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("TagKey")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentTagList(v []types.Tag, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Tag")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentTagValueList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("TagValue")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentValueStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentVpcIdentifierList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("VpcIdentifier")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentVpcSecurityGroupIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("VpcSecurityGroupId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeOpDocumentAcceptReservedNodeExchangeInput(v *AcceptReservedNodeExchangeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ReservedNodeId != nil {
		objectKey := object.Key("ReservedNodeId")
		objectKey.String(*v.ReservedNodeId)
	}

	if v.TargetReservedNodeOfferingId != nil {
		objectKey := object.Key("TargetReservedNodeOfferingId")
		objectKey.String(*v.TargetReservedNodeOfferingId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentAddPartnerInput(v *AddPartnerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AccountId != nil {
		objectKey := object.Key("AccountId")
		objectKey.String(*v.AccountId)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.DatabaseName != nil {
		objectKey := object.Key("DatabaseName")
		objectKey.String(*v.DatabaseName)
	}

	if v.PartnerName != nil {
		objectKey := object.Key("PartnerName")
		objectKey.String(*v.PartnerName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentAssociateDataShareConsumerInput(v *AssociateDataShareConsumerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AssociateEntireAccount != nil {
		objectKey := object.Key("AssociateEntireAccount")
		objectKey.Boolean(*v.AssociateEntireAccount)
	}

	if v.ConsumerArn != nil {
		objectKey := object.Key("ConsumerArn")
		objectKey.String(*v.ConsumerArn)
	}

	if v.DataShareArn != nil {
		objectKey := object.Key("DataShareArn")
		objectKey.String(*v.DataShareArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentAuthorizeClusterSecurityGroupIngressInput(v *AuthorizeClusterSecurityGroupIngressInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CIDRIP != nil {
		objectKey := object.Key("CIDRIP")
		objectKey.String(*v.CIDRIP)
	}

	if v.ClusterSecurityGroupName != nil {
		objectKey := object.Key("ClusterSecurityGroupName")
		objectKey.String(*v.ClusterSecurityGroupName)
	}

	if v.EC2SecurityGroupName != nil {
		objectKey := object.Key("EC2SecurityGroupName")
		objectKey.String(*v.EC2SecurityGroupName)
	}

	if v.EC2SecurityGroupOwnerId != nil {
		objectKey := object.Key("EC2SecurityGroupOwnerId")
		objectKey.String(*v.EC2SecurityGroupOwnerId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentAuthorizeDataShareInput(v *AuthorizeDataShareInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConsumerIdentifier != nil {
		objectKey := object.Key("ConsumerIdentifier")
		objectKey.String(*v.ConsumerIdentifier)
	}

	if v.DataShareArn != nil {
		objectKey := object.Key("DataShareArn")
		objectKey.String(*v.DataShareArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentAuthorizeEndpointAccessInput(v *AuthorizeEndpointAccessInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Account != nil {
		objectKey := object.Key("Account")
		objectKey.String(*v.Account)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.VpcIds != nil {
		objectKey := object.Key("VpcIds")
		if err := awsAwsquery_serializeDocumentVpcIdentifierList(v.VpcIds, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentAuthorizeSnapshotAccessInput(v *AuthorizeSnapshotAccessInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AccountWithRestoreAccess != nil {
		objectKey := object.Key("AccountWithRestoreAccess")
		objectKey.String(*v.AccountWithRestoreAccess)
	}

	if v.SnapshotClusterIdentifier != nil {
		objectKey := object.Key("SnapshotClusterIdentifier")
		objectKey.String(*v.SnapshotClusterIdentifier)
	}

	if v.SnapshotIdentifier != nil {
		objectKey := object.Key("SnapshotIdentifier")
		objectKey.String(*v.SnapshotIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentBatchDeleteClusterSnapshotsInput(v *BatchDeleteClusterSnapshotsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identifiers != nil {
		objectKey := object.Key("Identifiers")
		if err := awsAwsquery_serializeDocumentDeleteClusterSnapshotMessageList(v.Identifiers, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentBatchModifyClusterSnapshotsInput(v *BatchModifyClusterSnapshotsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Force {
		objectKey := object.Key("Force")
		objectKey.Boolean(v.Force)
	}

	if v.ManualSnapshotRetentionPeriod != nil {
		objectKey := object.Key("ManualSnapshotRetentionPeriod")
		objectKey.Integer(*v.ManualSnapshotRetentionPeriod)
	}

	if v.SnapshotIdentifierList != nil {
		objectKey := object.Key("SnapshotIdentifierList")
		if err := awsAwsquery_serializeDocumentSnapshotIdentifierList(v.SnapshotIdentifierList, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCancelResizeInput(v *CancelResizeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCopyClusterSnapshotInput(v *CopyClusterSnapshotInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ManualSnapshotRetentionPeriod != nil {
		objectKey := object.Key("ManualSnapshotRetentionPeriod")
		objectKey.Integer(*v.ManualSnapshotRetentionPeriod)
	}

	if v.SourceSnapshotClusterIdentifier != nil {
		objectKey := object.Key("SourceSnapshotClusterIdentifier")
		objectKey.String(*v.SourceSnapshotClusterIdentifier)
	}

	if v.SourceSnapshotIdentifier != nil {
		objectKey := object.Key("SourceSnapshotIdentifier")
		objectKey.String(*v.SourceSnapshotIdentifier)
	}

	if v.TargetSnapshotIdentifier != nil {
		objectKey := object.Key("TargetSnapshotIdentifier")
		objectKey.String(*v.TargetSnapshotIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateAuthenticationProfileInput(v *CreateAuthenticationProfileInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AuthenticationProfileContent != nil {
		objectKey := object.Key("AuthenticationProfileContent")
		objectKey.String(*v.AuthenticationProfileContent)
	}

	if v.AuthenticationProfileName != nil {
		objectKey := object.Key("AuthenticationProfileName")
		objectKey.String(*v.AuthenticationProfileName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateClusterInput(v *CreateClusterInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AdditionalInfo != nil {
		objectKey := object.Key("AdditionalInfo")
		objectKey.String(*v.AdditionalInfo)
	}

	if v.AllowVersionUpgrade != nil {
		objectKey := object.Key("AllowVersionUpgrade")
		objectKey.Boolean(*v.AllowVersionUpgrade)
	}

	if len(v.AquaConfigurationStatus) > 0 {
		objectKey := object.Key("AquaConfigurationStatus")
		objectKey.String(string(v.AquaConfigurationStatus))
	}

	if v.AutomatedSnapshotRetentionPeriod != nil {
		objectKey := object.Key("AutomatedSnapshotRetentionPeriod")
		objectKey.Integer(*v.AutomatedSnapshotRetentionPeriod)
	}

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if v.AvailabilityZoneRelocation != nil {
		objectKey := object.Key("AvailabilityZoneRelocation")
		objectKey.Boolean(*v.AvailabilityZoneRelocation)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.ClusterParameterGroupName != nil {
		objectKey := object.Key("ClusterParameterGroupName")
		objectKey.String(*v.ClusterParameterGroupName)
	}

	if v.ClusterSecurityGroups != nil {
		objectKey := object.Key("ClusterSecurityGroups")
		if err := awsAwsquery_serializeDocumentClusterSecurityGroupNameList(v.ClusterSecurityGroups, objectKey); err != nil {
			return err
		}
	}

	if v.ClusterSubnetGroupName != nil {
		objectKey := object.Key("ClusterSubnetGroupName")
		objectKey.String(*v.ClusterSubnetGroupName)
	}

	if v.ClusterType != nil {
		objectKey := object.Key("ClusterType")
		objectKey.String(*v.ClusterType)
	}

	if v.ClusterVersion != nil {
		objectKey := object.Key("ClusterVersion")
		objectKey.String(*v.ClusterVersion)
	}

	if v.DBName != nil {
		objectKey := object.Key("DBName")
		objectKey.String(*v.DBName)
	}

	if v.DefaultIamRoleArn != nil {
		objectKey := object.Key("DefaultIamRoleArn")
		objectKey.String(*v.DefaultIamRoleArn)
	}

	if v.ElasticIp != nil {
		objectKey := object.Key("ElasticIp")
		objectKey.String(*v.ElasticIp)
	}

	if v.Encrypted != nil {
		objectKey := object.Key("Encrypted")
		objectKey.Boolean(*v.Encrypted)
	}

	if v.EnhancedVpcRouting != nil {
		objectKey := object.Key("EnhancedVpcRouting")
		objectKey.Boolean(*v.EnhancedVpcRouting)
	}

	if v.HsmClientCertificateIdentifier != nil {
		objectKey := object.Key("HsmClientCertificateIdentifier")
		objectKey.String(*v.HsmClientCertificateIdentifier)
	}

	if v.HsmConfigurationIdentifier != nil {
		objectKey := object.Key("HsmConfigurationIdentifier")
		objectKey.String(*v.HsmConfigurationIdentifier)
	}

	if v.IamRoles != nil {
		objectKey := object.Key("IamRoles")
		if err := awsAwsquery_serializeDocumentIamRoleArnList(v.IamRoles, objectKey); err != nil {
			return err
		}
	}

	if v.KmsKeyId != nil {
		objectKey := object.Key("KmsKeyId")
		objectKey.String(*v.KmsKeyId)
	}

	if v.MaintenanceTrackName != nil {
		objectKey := object.Key("MaintenanceTrackName")
		objectKey.String(*v.MaintenanceTrackName)
	}

	if v.ManualSnapshotRetentionPeriod != nil {
		objectKey := object.Key("ManualSnapshotRetentionPeriod")
		objectKey.Integer(*v.ManualSnapshotRetentionPeriod)
	}

	if v.MasterUsername != nil {
		objectKey := object.Key("MasterUsername")
		objectKey.String(*v.MasterUsername)
	}

	if v.MasterUserPassword != nil {
		objectKey := object.Key("MasterUserPassword")
		objectKey.String(*v.MasterUserPassword)
	}

	if v.NodeType != nil {
		objectKey := object.Key("NodeType")
		objectKey.String(*v.NodeType)
	}

	if v.NumberOfNodes != nil {
		objectKey := object.Key("NumberOfNodes")
		objectKey.Integer(*v.NumberOfNodes)
	}

	if v.Port != nil {
		objectKey := object.Key("Port")
		objectKey.Integer(*v.Port)
	}

	if v.PreferredMaintenanceWindow != nil {
		objectKey := object.Key("PreferredMaintenanceWindow")
		objectKey.String(*v.PreferredMaintenanceWindow)
	}

	if v.PubliclyAccessible != nil {
		objectKey := object.Key("PubliclyAccessible")
		objectKey.Boolean(*v.PubliclyAccessible)
	}

	if v.SnapshotScheduleIdentifier != nil {
		objectKey := object.Key("SnapshotScheduleIdentifier")
		objectKey.String(*v.SnapshotScheduleIdentifier)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	if v.VpcSecurityGroupIds != nil {
		objectKey := object.Key("VpcSecurityGroupIds")
		if err := awsAwsquery_serializeDocumentVpcSecurityGroupIdList(v.VpcSecurityGroupIds, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateClusterParameterGroupInput(v *CreateClusterParameterGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.ParameterGroupFamily != nil {
		objectKey := object.Key("ParameterGroupFamily")
		objectKey.String(*v.ParameterGroupFamily)
	}

	if v.ParameterGroupName != nil {
		objectKey := object.Key("ParameterGroupName")
		objectKey.String(*v.ParameterGroupName)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateClusterSecurityGroupInput(v *CreateClusterSecurityGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterSecurityGroupName != nil {
		objectKey := object.Key("ClusterSecurityGroupName")
		objectKey.String(*v.ClusterSecurityGroupName)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateClusterSnapshotInput(v *CreateClusterSnapshotInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.ManualSnapshotRetentionPeriod != nil {
		objectKey := object.Key("ManualSnapshotRetentionPeriod")
		objectKey.Integer(*v.ManualSnapshotRetentionPeriod)
	}

	if v.SnapshotIdentifier != nil {
		objectKey := object.Key("SnapshotIdentifier")
		objectKey.String(*v.SnapshotIdentifier)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateClusterSubnetGroupInput(v *CreateClusterSubnetGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterSubnetGroupName != nil {
		objectKey := object.Key("ClusterSubnetGroupName")
		objectKey.String(*v.ClusterSubnetGroupName)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.SubnetIds != nil {
		objectKey := object.Key("SubnetIds")
		if err := awsAwsquery_serializeDocumentSubnetIdentifierList(v.SubnetIds, objectKey); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateEndpointAccessInput(v *CreateEndpointAccessInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.EndpointName != nil {
		objectKey := object.Key("EndpointName")
		objectKey.String(*v.EndpointName)
	}

	if v.ResourceOwner != nil {
		objectKey := object.Key("ResourceOwner")
		objectKey.String(*v.ResourceOwner)
	}

	if v.SubnetGroupName != nil {
		objectKey := object.Key("SubnetGroupName")
		objectKey.String(*v.SubnetGroupName)
	}

	if v.VpcSecurityGroupIds != nil {
		objectKey := object.Key("VpcSecurityGroupIds")
		if err := awsAwsquery_serializeDocumentVpcSecurityGroupIdList(v.VpcSecurityGroupIds, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateEventSubscriptionInput(v *CreateEventSubscriptionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enabled != nil {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(*v.Enabled)
	}

	if v.EventCategories != nil {
		objectKey := object.Key("EventCategories")
		if err := awsAwsquery_serializeDocumentEventCategoriesList(v.EventCategories, objectKey); err != nil {
			return err
		}
	}

	if v.Severity != nil {
		objectKey := object.Key("Severity")
		objectKey.String(*v.Severity)
	}

	if v.SnsTopicArn != nil {
		objectKey := object.Key("SnsTopicArn")
		objectKey.String(*v.SnsTopicArn)
	}

	if v.SourceIds != nil {
		objectKey := object.Key("SourceIds")
		if err := awsAwsquery_serializeDocumentSourceIdsList(v.SourceIds, objectKey); err != nil {
			return err
		}
	}

	if v.SourceType != nil {
		objectKey := object.Key("SourceType")
		objectKey.String(*v.SourceType)
	}

	if v.SubscriptionName != nil {
		objectKey := object.Key("SubscriptionName")
		objectKey.String(*v.SubscriptionName)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateHsmClientCertificateInput(v *CreateHsmClientCertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HsmClientCertificateIdentifier != nil {
		objectKey := object.Key("HsmClientCertificateIdentifier")
		objectKey.String(*v.HsmClientCertificateIdentifier)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateHsmConfigurationInput(v *CreateHsmConfigurationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.HsmConfigurationIdentifier != nil {
		objectKey := object.Key("HsmConfigurationIdentifier")
		objectKey.String(*v.HsmConfigurationIdentifier)
	}

	if v.HsmIpAddress != nil {
		objectKey := object.Key("HsmIpAddress")
		objectKey.String(*v.HsmIpAddress)
	}

	if v.HsmPartitionName != nil {
		objectKey := object.Key("HsmPartitionName")
		objectKey.String(*v.HsmPartitionName)
	}

	if v.HsmPartitionPassword != nil {
		objectKey := object.Key("HsmPartitionPassword")
		objectKey.String(*v.HsmPartitionPassword)
	}

	if v.HsmServerPublicCertificate != nil {
		objectKey := object.Key("HsmServerPublicCertificate")
		objectKey.String(*v.HsmServerPublicCertificate)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateScheduledActionInput(v *CreateScheduledActionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enable != nil {
		objectKey := object.Key("Enable")
		objectKey.Boolean(*v.Enable)
	}

	if v.EndTime != nil {
		objectKey := object.Key("EndTime")
		objectKey.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.IamRole != nil {
		objectKey := object.Key("IamRole")
		objectKey.String(*v.IamRole)
	}

	if v.Schedule != nil {
		objectKey := object.Key("Schedule")
		objectKey.String(*v.Schedule)
	}

	if v.ScheduledActionDescription != nil {
		objectKey := object.Key("ScheduledActionDescription")
		objectKey.String(*v.ScheduledActionDescription)
	}

	if v.ScheduledActionName != nil {
		objectKey := object.Key("ScheduledActionName")
		objectKey.String(*v.ScheduledActionName)
	}

	if v.StartTime != nil {
		objectKey := object.Key("StartTime")
		objectKey.String(smithytime.FormatDateTime(*v.StartTime))
	}

	if v.TargetAction != nil {
		objectKey := object.Key("TargetAction")
		if err := awsAwsquery_serializeDocumentScheduledActionType(v.TargetAction, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateSnapshotCopyGrantInput(v *CreateSnapshotCopyGrantInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.KmsKeyId != nil {
		objectKey := object.Key("KmsKeyId")
		objectKey.String(*v.KmsKeyId)
	}

	if v.SnapshotCopyGrantName != nil {
		objectKey := object.Key("SnapshotCopyGrantName")
		objectKey.String(*v.SnapshotCopyGrantName)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateSnapshotScheduleInput(v *CreateSnapshotScheduleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DryRun != nil {
		objectKey := object.Key("DryRun")
		objectKey.Boolean(*v.DryRun)
	}

	if v.NextInvocations != nil {
		objectKey := object.Key("NextInvocations")
		objectKey.Integer(*v.NextInvocations)
	}

	if v.ScheduleDefinitions != nil {
		objectKey := object.Key("ScheduleDefinitions")
		if err := awsAwsquery_serializeDocumentScheduleDefinitionList(v.ScheduleDefinitions, objectKey); err != nil {
			return err
		}
	}

	if v.ScheduleDescription != nil {
		objectKey := object.Key("ScheduleDescription")
		objectKey.String(*v.ScheduleDescription)
	}

	if v.ScheduleIdentifier != nil {
		objectKey := object.Key("ScheduleIdentifier")
		objectKey.String(*v.ScheduleIdentifier)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateTagsInput(v *CreateTagsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ResourceName != nil {
		objectKey := object.Key("ResourceName")
		objectKey.String(*v.ResourceName)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateUsageLimitInput(v *CreateUsageLimitInput, value query.Value) error {
	object := value.Object()
	_ = object

	{
		objectKey := object.Key("Amount")
		objectKey.Long(v.Amount)
	}

	if len(v.BreachAction) > 0 {
		objectKey := object.Key("BreachAction")
		objectKey.String(string(v.BreachAction))
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if len(v.FeatureType) > 0 {
		objectKey := object.Key("FeatureType")
		objectKey.String(string(v.FeatureType))
	}

	if len(v.LimitType) > 0 {
		objectKey := object.Key("LimitType")
		objectKey.String(string(v.LimitType))
	}

	if len(v.Period) > 0 {
		objectKey := object.Key("Period")
		objectKey.String(string(v.Period))
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeauthorizeDataShareInput(v *DeauthorizeDataShareInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConsumerIdentifier != nil {
		objectKey := object.Key("ConsumerIdentifier")
		objectKey.String(*v.ConsumerIdentifier)
	}

	if v.DataShareArn != nil {
		objectKey := object.Key("DataShareArn")
		objectKey.String(*v.DataShareArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteAuthenticationProfileInput(v *DeleteAuthenticationProfileInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AuthenticationProfileName != nil {
		objectKey := object.Key("AuthenticationProfileName")
		objectKey.String(*v.AuthenticationProfileName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteClusterInput(v *DeleteClusterInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.FinalClusterSnapshotIdentifier != nil {
		objectKey := object.Key("FinalClusterSnapshotIdentifier")
		objectKey.String(*v.FinalClusterSnapshotIdentifier)
	}

	if v.FinalClusterSnapshotRetentionPeriod != nil {
		objectKey := object.Key("FinalClusterSnapshotRetentionPeriod")
		objectKey.Integer(*v.FinalClusterSnapshotRetentionPeriod)
	}

	if v.SkipFinalClusterSnapshot {
		objectKey := object.Key("SkipFinalClusterSnapshot")
		objectKey.Boolean(v.SkipFinalClusterSnapshot)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteClusterParameterGroupInput(v *DeleteClusterParameterGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ParameterGroupName != nil {
		objectKey := object.Key("ParameterGroupName")
		objectKey.String(*v.ParameterGroupName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteClusterSecurityGroupInput(v *DeleteClusterSecurityGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterSecurityGroupName != nil {
		objectKey := object.Key("ClusterSecurityGroupName")
		objectKey.String(*v.ClusterSecurityGroupName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteClusterSnapshotInput(v *DeleteClusterSnapshotInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.SnapshotClusterIdentifier != nil {
		objectKey := object.Key("SnapshotClusterIdentifier")
		objectKey.String(*v.SnapshotClusterIdentifier)
	}

	if v.SnapshotIdentifier != nil {
		objectKey := object.Key("SnapshotIdentifier")
		objectKey.String(*v.SnapshotIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteClusterSubnetGroupInput(v *DeleteClusterSubnetGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterSubnetGroupName != nil {
		objectKey := object.Key("ClusterSubnetGroupName")
		objectKey.String(*v.ClusterSubnetGroupName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteEndpointAccessInput(v *DeleteEndpointAccessInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EndpointName != nil {
		objectKey := object.Key("EndpointName")
		objectKey.String(*v.EndpointName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteEventSubscriptionInput(v *DeleteEventSubscriptionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.SubscriptionName != nil {
		objectKey := object.Key("SubscriptionName")
		objectKey.String(*v.SubscriptionName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteHsmClientCertificateInput(v *DeleteHsmClientCertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HsmClientCertificateIdentifier != nil {
		objectKey := object.Key("HsmClientCertificateIdentifier")
		objectKey.String(*v.HsmClientCertificateIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteHsmConfigurationInput(v *DeleteHsmConfigurationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HsmConfigurationIdentifier != nil {
		objectKey := object.Key("HsmConfigurationIdentifier")
		objectKey.String(*v.HsmConfigurationIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeletePartnerInput(v *DeletePartnerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AccountId != nil {
		objectKey := object.Key("AccountId")
		objectKey.String(*v.AccountId)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.DatabaseName != nil {
		objectKey := object.Key("DatabaseName")
		objectKey.String(*v.DatabaseName)
	}

	if v.PartnerName != nil {
		objectKey := object.Key("PartnerName")
		objectKey.String(*v.PartnerName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteScheduledActionInput(v *DeleteScheduledActionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ScheduledActionName != nil {
		objectKey := object.Key("ScheduledActionName")
		objectKey.String(*v.ScheduledActionName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteSnapshotCopyGrantInput(v *DeleteSnapshotCopyGrantInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.SnapshotCopyGrantName != nil {
		objectKey := object.Key("SnapshotCopyGrantName")
		objectKey.String(*v.SnapshotCopyGrantName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteSnapshotScheduleInput(v *DeleteSnapshotScheduleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ScheduleIdentifier != nil {
		objectKey := object.Key("ScheduleIdentifier")
		objectKey.String(*v.ScheduleIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteTagsInput(v *DeleteTagsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ResourceName != nil {
		objectKey := object.Key("ResourceName")
		objectKey.String(*v.ResourceName)
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteUsageLimitInput(v *DeleteUsageLimitInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.UsageLimitId != nil {
		objectKey := object.Key("UsageLimitId")
		objectKey.String(*v.UsageLimitId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeAccountAttributesInput(v *DescribeAccountAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AttributeNames != nil {
		objectKey := object.Key("AttributeNames")
		if err := awsAwsquery_serializeDocumentAttributeNameList(v.AttributeNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeAuthenticationProfilesInput(v *DescribeAuthenticationProfilesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AuthenticationProfileName != nil {
		objectKey := object.Key("AuthenticationProfileName")
		objectKey.String(*v.AuthenticationProfileName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeClusterDbRevisionsInput(v *DescribeClusterDbRevisionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeClusterParameterGroupsInput(v *DescribeClusterParameterGroupsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.ParameterGroupName != nil {
		objectKey := object.Key("ParameterGroupName")
		objectKey.String(*v.ParameterGroupName)
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	if v.TagValues != nil {
		objectKey := object.Key("TagValues")
		if err := awsAwsquery_serializeDocumentTagValueList(v.TagValues, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeClusterParametersInput(v *DescribeClusterParametersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.ParameterGroupName != nil {
		objectKey := object.Key("ParameterGroupName")
		objectKey.String(*v.ParameterGroupName)
	}

	if v.Source != nil {
		objectKey := object.Key("Source")
		objectKey.String(*v.Source)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeClusterSecurityGroupsInput(v *DescribeClusterSecurityGroupsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterSecurityGroupName != nil {
		objectKey := object.Key("ClusterSecurityGroupName")
		objectKey.String(*v.ClusterSecurityGroupName)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	if v.TagValues != nil {
		objectKey := object.Key("TagValues")
		if err := awsAwsquery_serializeDocumentTagValueList(v.TagValues, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeClustersInput(v *DescribeClustersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	if v.TagValues != nil {
		objectKey := object.Key("TagValues")
		if err := awsAwsquery_serializeDocumentTagValueList(v.TagValues, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeClusterSnapshotsInput(v *DescribeClusterSnapshotsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterExists != nil {
		objectKey := object.Key("ClusterExists")
		objectKey.Boolean(*v.ClusterExists)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.EndTime != nil {
		objectKey := object.Key("EndTime")
		objectKey.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.OwnerAccount != nil {
		objectKey := object.Key("OwnerAccount")
		objectKey.String(*v.OwnerAccount)
	}

	if v.SnapshotIdentifier != nil {
		objectKey := object.Key("SnapshotIdentifier")
		objectKey.String(*v.SnapshotIdentifier)
	}

	if v.SnapshotType != nil {
		objectKey := object.Key("SnapshotType")
		objectKey.String(*v.SnapshotType)
	}

	if v.SortingEntities != nil {
		objectKey := object.Key("SortingEntities")
		if err := awsAwsquery_serializeDocumentSnapshotSortingEntityList(v.SortingEntities, objectKey); err != nil {
			return err
		}
	}

	if v.StartTime != nil {
		objectKey := object.Key("StartTime")
		objectKey.String(smithytime.FormatDateTime(*v.StartTime))
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	if v.TagValues != nil {
		objectKey := object.Key("TagValues")
		if err := awsAwsquery_serializeDocumentTagValueList(v.TagValues, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeClusterSubnetGroupsInput(v *DescribeClusterSubnetGroupsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterSubnetGroupName != nil {
		objectKey := object.Key("ClusterSubnetGroupName")
		objectKey.String(*v.ClusterSubnetGroupName)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	if v.TagValues != nil {
		objectKey := object.Key("TagValues")
		if err := awsAwsquery_serializeDocumentTagValueList(v.TagValues, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeClusterTracksInput(v *DescribeClusterTracksInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MaintenanceTrackName != nil {
		objectKey := object.Key("MaintenanceTrackName")
		objectKey.String(*v.MaintenanceTrackName)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeClusterVersionsInput(v *DescribeClusterVersionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterParameterGroupFamily != nil {
		objectKey := object.Key("ClusterParameterGroupFamily")
		objectKey.String(*v.ClusterParameterGroupFamily)
	}

	if v.ClusterVersion != nil {
		objectKey := object.Key("ClusterVersion")
		objectKey.String(*v.ClusterVersion)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeDataSharesForConsumerInput(v *DescribeDataSharesForConsumerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConsumerArn != nil {
		objectKey := object.Key("ConsumerArn")
		objectKey.String(*v.ConsumerArn)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if len(v.Status) > 0 {
		objectKey := object.Key("Status")
		objectKey.String(string(v.Status))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeDataSharesForProducerInput(v *DescribeDataSharesForProducerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.ProducerArn != nil {
		objectKey := object.Key("ProducerArn")
		objectKey.String(*v.ProducerArn)
	}

	if len(v.Status) > 0 {
		objectKey := object.Key("Status")
		objectKey.String(string(v.Status))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeDataSharesInput(v *DescribeDataSharesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DataShareArn != nil {
		objectKey := object.Key("DataShareArn")
		objectKey.String(*v.DataShareArn)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeDefaultClusterParametersInput(v *DescribeDefaultClusterParametersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.ParameterGroupFamily != nil {
		objectKey := object.Key("ParameterGroupFamily")
		objectKey.String(*v.ParameterGroupFamily)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeEndpointAccessInput(v *DescribeEndpointAccessInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.EndpointName != nil {
		objectKey := object.Key("EndpointName")
		objectKey.String(*v.EndpointName)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.ResourceOwner != nil {
		objectKey := object.Key("ResourceOwner")
		objectKey.String(*v.ResourceOwner)
	}

	if v.VpcId != nil {
		objectKey := object.Key("VpcId")
		objectKey.String(*v.VpcId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeEndpointAuthorizationInput(v *DescribeEndpointAuthorizationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Account != nil {
		objectKey := object.Key("Account")
		objectKey.String(*v.Account)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.Grantee != nil {
		objectKey := object.Key("Grantee")
		objectKey.Boolean(*v.Grantee)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeEventCategoriesInput(v *DescribeEventCategoriesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.SourceType != nil {
		objectKey := object.Key("SourceType")
		objectKey.String(*v.SourceType)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeEventsInput(v *DescribeEventsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Duration != nil {
		objectKey := object.Key("Duration")
		objectKey.Integer(*v.Duration)
	}

	if v.EndTime != nil {
		objectKey := object.Key("EndTime")
		objectKey.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.SourceIdentifier != nil {
		objectKey := object.Key("SourceIdentifier")
		objectKey.String(*v.SourceIdentifier)
	}

	if len(v.SourceType) > 0 {
		objectKey := object.Key("SourceType")
		objectKey.String(string(v.SourceType))
	}

	if v.StartTime != nil {
		objectKey := object.Key("StartTime")
		objectKey.String(smithytime.FormatDateTime(*v.StartTime))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeEventSubscriptionsInput(v *DescribeEventSubscriptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.SubscriptionName != nil {
		objectKey := object.Key("SubscriptionName")
		objectKey.String(*v.SubscriptionName)
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	if v.TagValues != nil {
		objectKey := object.Key("TagValues")
		if err := awsAwsquery_serializeDocumentTagValueList(v.TagValues, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeHsmClientCertificatesInput(v *DescribeHsmClientCertificatesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HsmClientCertificateIdentifier != nil {
		objectKey := object.Key("HsmClientCertificateIdentifier")
		objectKey.String(*v.HsmClientCertificateIdentifier)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	if v.TagValues != nil {
		objectKey := object.Key("TagValues")
		if err := awsAwsquery_serializeDocumentTagValueList(v.TagValues, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeHsmConfigurationsInput(v *DescribeHsmConfigurationsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HsmConfigurationIdentifier != nil {
		objectKey := object.Key("HsmConfigurationIdentifier")
		objectKey.String(*v.HsmConfigurationIdentifier)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	if v.TagValues != nil {
		objectKey := object.Key("TagValues")
		if err := awsAwsquery_serializeDocumentTagValueList(v.TagValues, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeLoggingStatusInput(v *DescribeLoggingStatusInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeNodeConfigurationOptionsInput(v *DescribeNodeConfigurationOptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.ActionType) > 0 {
		objectKey := object.Key("ActionType")
		objectKey.String(string(v.ActionType))
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.Filters != nil {
		objectKey := object.Key("Filter")
		if err := awsAwsquery_serializeDocumentNodeConfigurationOptionsFilterList(v.Filters, objectKey); err != nil {
			return err
		}
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.OwnerAccount != nil {
		objectKey := object.Key("OwnerAccount")
		objectKey.String(*v.OwnerAccount)
	}

	if v.SnapshotIdentifier != nil {
		objectKey := object.Key("SnapshotIdentifier")
		objectKey.String(*v.SnapshotIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeOrderableClusterOptionsInput(v *DescribeOrderableClusterOptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterVersion != nil {
		objectKey := object.Key("ClusterVersion")
		objectKey.String(*v.ClusterVersion)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NodeType != nil {
		objectKey := object.Key("NodeType")
		objectKey.String(*v.NodeType)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribePartnersInput(v *DescribePartnersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AccountId != nil {
		objectKey := object.Key("AccountId")
		objectKey.String(*v.AccountId)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.DatabaseName != nil {
		objectKey := object.Key("DatabaseName")
		objectKey.String(*v.DatabaseName)
	}

	if v.PartnerName != nil {
		objectKey := object.Key("PartnerName")
		objectKey.String(*v.PartnerName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeReservedNodeExchangeStatusInput(v *DescribeReservedNodeExchangeStatusInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.ReservedNodeExchangeRequestId != nil {
		objectKey := object.Key("ReservedNodeExchangeRequestId")
		objectKey.String(*v.ReservedNodeExchangeRequestId)
	}

	if v.ReservedNodeId != nil {
		objectKey := object.Key("ReservedNodeId")
		objectKey.String(*v.ReservedNodeId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeReservedNodeOfferingsInput(v *DescribeReservedNodeOfferingsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.ReservedNodeOfferingId != nil {
		objectKey := object.Key("ReservedNodeOfferingId")
		objectKey.String(*v.ReservedNodeOfferingId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeReservedNodesInput(v *DescribeReservedNodesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.ReservedNodeId != nil {
		objectKey := object.Key("ReservedNodeId")
		objectKey.String(*v.ReservedNodeId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeResizeInput(v *DescribeResizeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeScheduledActionsInput(v *DescribeScheduledActionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Active != nil {
		objectKey := object.Key("Active")
		objectKey.Boolean(*v.Active)
	}

	if v.EndTime != nil {
		objectKey := object.Key("EndTime")
		objectKey.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.Filters != nil {
		objectKey := object.Key("Filters")
		if err := awsAwsquery_serializeDocumentScheduledActionFilterList(v.Filters, objectKey); err != nil {
			return err
		}
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.ScheduledActionName != nil {
		objectKey := object.Key("ScheduledActionName")
		objectKey.String(*v.ScheduledActionName)
	}

	if v.StartTime != nil {
		objectKey := object.Key("StartTime")
		objectKey.String(smithytime.FormatDateTime(*v.StartTime))
	}

	if len(v.TargetActionType) > 0 {
		objectKey := object.Key("TargetActionType")
		objectKey.String(string(v.TargetActionType))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeSnapshotCopyGrantsInput(v *DescribeSnapshotCopyGrantsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.SnapshotCopyGrantName != nil {
		objectKey := object.Key("SnapshotCopyGrantName")
		objectKey.String(*v.SnapshotCopyGrantName)
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	if v.TagValues != nil {
		objectKey := object.Key("TagValues")
		if err := awsAwsquery_serializeDocumentTagValueList(v.TagValues, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeSnapshotSchedulesInput(v *DescribeSnapshotSchedulesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.ScheduleIdentifier != nil {
		objectKey := object.Key("ScheduleIdentifier")
		objectKey.String(*v.ScheduleIdentifier)
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	if v.TagValues != nil {
		objectKey := object.Key("TagValues")
		if err := awsAwsquery_serializeDocumentTagValueList(v.TagValues, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeTableRestoreStatusInput(v *DescribeTableRestoreStatusInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.TableRestoreRequestId != nil {
		objectKey := object.Key("TableRestoreRequestId")
		objectKey.String(*v.TableRestoreRequestId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeTagsInput(v *DescribeTagsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.ResourceName != nil {
		objectKey := object.Key("ResourceName")
		objectKey.String(*v.ResourceName)
	}

	if v.ResourceType != nil {
		objectKey := object.Key("ResourceType")
		objectKey.String(*v.ResourceType)
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	if v.TagValues != nil {
		objectKey := object.Key("TagValues")
		if err := awsAwsquery_serializeDocumentTagValueList(v.TagValues, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeUsageLimitsInput(v *DescribeUsageLimitsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if len(v.FeatureType) > 0 {
		objectKey := object.Key("FeatureType")
		objectKey.String(string(v.FeatureType))
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	if v.TagValues != nil {
		objectKey := object.Key("TagValues")
		if err := awsAwsquery_serializeDocumentTagValueList(v.TagValues, objectKey); err != nil {
			return err
		}
	}

	if v.UsageLimitId != nil {
		objectKey := object.Key("UsageLimitId")
		objectKey.String(*v.UsageLimitId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDisableLoggingInput(v *DisableLoggingInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDisableSnapshotCopyInput(v *DisableSnapshotCopyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDisassociateDataShareConsumerInput(v *DisassociateDataShareConsumerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConsumerArn != nil {
		objectKey := object.Key("ConsumerArn")
		objectKey.String(*v.ConsumerArn)
	}

	if v.DataShareArn != nil {
		objectKey := object.Key("DataShareArn")
		objectKey.String(*v.DataShareArn)
	}

	if v.DisassociateEntireAccount != nil {
		objectKey := object.Key("DisassociateEntireAccount")
		objectKey.Boolean(*v.DisassociateEntireAccount)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentEnableLoggingInput(v *EnableLoggingInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BucketName != nil {
		objectKey := object.Key("BucketName")
		objectKey.String(*v.BucketName)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.S3KeyPrefix != nil {
		objectKey := object.Key("S3KeyPrefix")
		objectKey.String(*v.S3KeyPrefix)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentEnableSnapshotCopyInput(v *EnableSnapshotCopyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.DestinationRegion != nil {
		objectKey := object.Key("DestinationRegion")
		objectKey.String(*v.DestinationRegion)
	}

	if v.ManualSnapshotRetentionPeriod != nil {
		objectKey := object.Key("ManualSnapshotRetentionPeriod")
		objectKey.Integer(*v.ManualSnapshotRetentionPeriod)
	}

	if v.RetentionPeriod != nil {
		objectKey := object.Key("RetentionPeriod")
		objectKey.Integer(*v.RetentionPeriod)
	}

	if v.SnapshotCopyGrantName != nil {
		objectKey := object.Key("SnapshotCopyGrantName")
		objectKey.String(*v.SnapshotCopyGrantName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetClusterCredentialsInput(v *GetClusterCredentialsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoCreate != nil {
		objectKey := object.Key("AutoCreate")
		objectKey.Boolean(*v.AutoCreate)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.DbGroups != nil {
		objectKey := object.Key("DbGroups")
		if err := awsAwsquery_serializeDocumentDbGroupList(v.DbGroups, objectKey); err != nil {
			return err
		}
	}

	if v.DbName != nil {
		objectKey := object.Key("DbName")
		objectKey.String(*v.DbName)
	}

	if v.DbUser != nil {
		objectKey := object.Key("DbUser")
		objectKey.String(*v.DbUser)
	}

	if v.DurationSeconds != nil {
		objectKey := object.Key("DurationSeconds")
		objectKey.Integer(*v.DurationSeconds)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetReservedNodeExchangeConfigurationOptionsInput(v *GetReservedNodeExchangeConfigurationOptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.ActionType) > 0 {
		objectKey := object.Key("ActionType")
		objectKey.String(string(v.ActionType))
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.SnapshotIdentifier != nil {
		objectKey := object.Key("SnapshotIdentifier")
		objectKey.String(*v.SnapshotIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetReservedNodeExchangeOfferingsInput(v *GetReservedNodeExchangeOfferingsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.ReservedNodeId != nil {
		objectKey := object.Key("ReservedNodeId")
		objectKey.String(*v.ReservedNodeId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyAquaConfigurationInput(v *ModifyAquaConfigurationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AquaConfigurationStatus) > 0 {
		objectKey := object.Key("AquaConfigurationStatus")
		objectKey.String(string(v.AquaConfigurationStatus))
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyAuthenticationProfileInput(v *ModifyAuthenticationProfileInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AuthenticationProfileContent != nil {
		objectKey := object.Key("AuthenticationProfileContent")
		objectKey.String(*v.AuthenticationProfileContent)
	}

	if v.AuthenticationProfileName != nil {
		objectKey := object.Key("AuthenticationProfileName")
		objectKey.String(*v.AuthenticationProfileName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyClusterDbRevisionInput(v *ModifyClusterDbRevisionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.RevisionTarget != nil {
		objectKey := object.Key("RevisionTarget")
		objectKey.String(*v.RevisionTarget)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyClusterIamRolesInput(v *ModifyClusterIamRolesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AddIamRoles != nil {
		objectKey := object.Key("AddIamRoles")
		if err := awsAwsquery_serializeDocumentIamRoleArnList(v.AddIamRoles, objectKey); err != nil {
			return err
		}
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.DefaultIamRoleArn != nil {
		objectKey := object.Key("DefaultIamRoleArn")
		objectKey.String(*v.DefaultIamRoleArn)
	}

	if v.RemoveIamRoles != nil {
		objectKey := object.Key("RemoveIamRoles")
		if err := awsAwsquery_serializeDocumentIamRoleArnList(v.RemoveIamRoles, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyClusterInput(v *ModifyClusterInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AllowVersionUpgrade != nil {
		objectKey := object.Key("AllowVersionUpgrade")
		objectKey.Boolean(*v.AllowVersionUpgrade)
	}

	if v.AutomatedSnapshotRetentionPeriod != nil {
		objectKey := object.Key("AutomatedSnapshotRetentionPeriod")
		objectKey.Integer(*v.AutomatedSnapshotRetentionPeriod)
	}

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if v.AvailabilityZoneRelocation != nil {
		objectKey := object.Key("AvailabilityZoneRelocation")
		objectKey.Boolean(*v.AvailabilityZoneRelocation)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.ClusterParameterGroupName != nil {
		objectKey := object.Key("ClusterParameterGroupName")
		objectKey.String(*v.ClusterParameterGroupName)
	}

	if v.ClusterSecurityGroups != nil {
		objectKey := object.Key("ClusterSecurityGroups")
		if err := awsAwsquery_serializeDocumentClusterSecurityGroupNameList(v.ClusterSecurityGroups, objectKey); err != nil {
			return err
		}
	}

	if v.ClusterType != nil {
		objectKey := object.Key("ClusterType")
		objectKey.String(*v.ClusterType)
	}

	if v.ClusterVersion != nil {
		objectKey := object.Key("ClusterVersion")
		objectKey.String(*v.ClusterVersion)
	}

	if v.ElasticIp != nil {
		objectKey := object.Key("ElasticIp")
		objectKey.String(*v.ElasticIp)
	}

	if v.Encrypted != nil {
		objectKey := object.Key("Encrypted")
		objectKey.Boolean(*v.Encrypted)
	}

	if v.EnhancedVpcRouting != nil {
		objectKey := object.Key("EnhancedVpcRouting")
		objectKey.Boolean(*v.EnhancedVpcRouting)
	}

	if v.HsmClientCertificateIdentifier != nil {
		objectKey := object.Key("HsmClientCertificateIdentifier")
		objectKey.String(*v.HsmClientCertificateIdentifier)
	}

	if v.HsmConfigurationIdentifier != nil {
		objectKey := object.Key("HsmConfigurationIdentifier")
		objectKey.String(*v.HsmConfigurationIdentifier)
	}

	if v.KmsKeyId != nil {
		objectKey := object.Key("KmsKeyId")
		objectKey.String(*v.KmsKeyId)
	}

	if v.MaintenanceTrackName != nil {
		objectKey := object.Key("MaintenanceTrackName")
		objectKey.String(*v.MaintenanceTrackName)
	}

	if v.ManualSnapshotRetentionPeriod != nil {
		objectKey := object.Key("ManualSnapshotRetentionPeriod")
		objectKey.Integer(*v.ManualSnapshotRetentionPeriod)
	}

	if v.MasterUserPassword != nil {
		objectKey := object.Key("MasterUserPassword")
		objectKey.String(*v.MasterUserPassword)
	}

	if v.NewClusterIdentifier != nil {
		objectKey := object.Key("NewClusterIdentifier")
		objectKey.String(*v.NewClusterIdentifier)
	}

	if v.NodeType != nil {
		objectKey := object.Key("NodeType")
		objectKey.String(*v.NodeType)
	}

	if v.NumberOfNodes != nil {
		objectKey := object.Key("NumberOfNodes")
		objectKey.Integer(*v.NumberOfNodes)
	}

	if v.Port != nil {
		objectKey := object.Key("Port")
		objectKey.Integer(*v.Port)
	}

	if v.PreferredMaintenanceWindow != nil {
		objectKey := object.Key("PreferredMaintenanceWindow")
		objectKey.String(*v.PreferredMaintenanceWindow)
	}

	if v.PubliclyAccessible != nil {
		objectKey := object.Key("PubliclyAccessible")
		objectKey.Boolean(*v.PubliclyAccessible)
	}

	if v.VpcSecurityGroupIds != nil {
		objectKey := object.Key("VpcSecurityGroupIds")
		if err := awsAwsquery_serializeDocumentVpcSecurityGroupIdList(v.VpcSecurityGroupIds, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyClusterMaintenanceInput(v *ModifyClusterMaintenanceInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.DeferMaintenance != nil {
		objectKey := object.Key("DeferMaintenance")
		objectKey.Boolean(*v.DeferMaintenance)
	}

	if v.DeferMaintenanceDuration != nil {
		objectKey := object.Key("DeferMaintenanceDuration")
		objectKey.Integer(*v.DeferMaintenanceDuration)
	}

	if v.DeferMaintenanceEndTime != nil {
		objectKey := object.Key("DeferMaintenanceEndTime")
		objectKey.String(smithytime.FormatDateTime(*v.DeferMaintenanceEndTime))
	}

	if v.DeferMaintenanceIdentifier != nil {
		objectKey := object.Key("DeferMaintenanceIdentifier")
		objectKey.String(*v.DeferMaintenanceIdentifier)
	}

	if v.DeferMaintenanceStartTime != nil {
		objectKey := object.Key("DeferMaintenanceStartTime")
		objectKey.String(smithytime.FormatDateTime(*v.DeferMaintenanceStartTime))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyClusterParameterGroupInput(v *ModifyClusterParameterGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ParameterGroupName != nil {
		objectKey := object.Key("ParameterGroupName")
		objectKey.String(*v.ParameterGroupName)
	}

	if v.Parameters != nil {
		objectKey := object.Key("Parameters")
		if err := awsAwsquery_serializeDocumentParametersList(v.Parameters, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyClusterSnapshotInput(v *ModifyClusterSnapshotInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Force {
		objectKey := object.Key("Force")
		objectKey.Boolean(v.Force)
	}

	if v.ManualSnapshotRetentionPeriod != nil {
		objectKey := object.Key("ManualSnapshotRetentionPeriod")
		objectKey.Integer(*v.ManualSnapshotRetentionPeriod)
	}

	if v.SnapshotIdentifier != nil {
		objectKey := object.Key("SnapshotIdentifier")
		objectKey.String(*v.SnapshotIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyClusterSnapshotScheduleInput(v *ModifyClusterSnapshotScheduleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.DisassociateSchedule != nil {
		objectKey := object.Key("DisassociateSchedule")
		objectKey.Boolean(*v.DisassociateSchedule)
	}

	if v.ScheduleIdentifier != nil {
		objectKey := object.Key("ScheduleIdentifier")
		objectKey.String(*v.ScheduleIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyClusterSubnetGroupInput(v *ModifyClusterSubnetGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterSubnetGroupName != nil {
		objectKey := object.Key("ClusterSubnetGroupName")
		objectKey.String(*v.ClusterSubnetGroupName)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.SubnetIds != nil {
		objectKey := object.Key("SubnetIds")
		if err := awsAwsquery_serializeDocumentSubnetIdentifierList(v.SubnetIds, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyEndpointAccessInput(v *ModifyEndpointAccessInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EndpointName != nil {
		objectKey := object.Key("EndpointName")
		objectKey.String(*v.EndpointName)
	}

	if v.VpcSecurityGroupIds != nil {
		objectKey := object.Key("VpcSecurityGroupIds")
		if err := awsAwsquery_serializeDocumentVpcSecurityGroupIdList(v.VpcSecurityGroupIds, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyEventSubscriptionInput(v *ModifyEventSubscriptionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enabled != nil {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(*v.Enabled)
	}

	if v.EventCategories != nil {
		objectKey := object.Key("EventCategories")
		if err := awsAwsquery_serializeDocumentEventCategoriesList(v.EventCategories, objectKey); err != nil {
			return err
		}
	}

	if v.Severity != nil {
		objectKey := object.Key("Severity")
		objectKey.String(*v.Severity)
	}

	if v.SnsTopicArn != nil {
		objectKey := object.Key("SnsTopicArn")
		objectKey.String(*v.SnsTopicArn)
	}

	if v.SourceIds != nil {
		objectKey := object.Key("SourceIds")
		if err := awsAwsquery_serializeDocumentSourceIdsList(v.SourceIds, objectKey); err != nil {
			return err
		}
	}

	if v.SourceType != nil {
		objectKey := object.Key("SourceType")
		objectKey.String(*v.SourceType)
	}

	if v.SubscriptionName != nil {
		objectKey := object.Key("SubscriptionName")
		objectKey.String(*v.SubscriptionName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyScheduledActionInput(v *ModifyScheduledActionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enable != nil {
		objectKey := object.Key("Enable")
		objectKey.Boolean(*v.Enable)
	}

	if v.EndTime != nil {
		objectKey := object.Key("EndTime")
		objectKey.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.IamRole != nil {
		objectKey := object.Key("IamRole")
		objectKey.String(*v.IamRole)
	}

	if v.Schedule != nil {
		objectKey := object.Key("Schedule")
		objectKey.String(*v.Schedule)
	}

	if v.ScheduledActionDescription != nil {
		objectKey := object.Key("ScheduledActionDescription")
		objectKey.String(*v.ScheduledActionDescription)
	}

	if v.ScheduledActionName != nil {
		objectKey := object.Key("ScheduledActionName")
		objectKey.String(*v.ScheduledActionName)
	}

	if v.StartTime != nil {
		objectKey := object.Key("StartTime")
		objectKey.String(smithytime.FormatDateTime(*v.StartTime))
	}

	if v.TargetAction != nil {
		objectKey := object.Key("TargetAction")
		if err := awsAwsquery_serializeDocumentScheduledActionType(v.TargetAction, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifySnapshotCopyRetentionPeriodInput(v *ModifySnapshotCopyRetentionPeriodInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.Manual {
		objectKey := object.Key("Manual")
		objectKey.Boolean(v.Manual)
	}

	{
		objectKey := object.Key("RetentionPeriod")
		objectKey.Integer(v.RetentionPeriod)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifySnapshotScheduleInput(v *ModifySnapshotScheduleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ScheduleDefinitions != nil {
		objectKey := object.Key("ScheduleDefinitions")
		if err := awsAwsquery_serializeDocumentScheduleDefinitionList(v.ScheduleDefinitions, objectKey); err != nil {
			return err
		}
	}

	if v.ScheduleIdentifier != nil {
		objectKey := object.Key("ScheduleIdentifier")
		objectKey.String(*v.ScheduleIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyUsageLimitInput(v *ModifyUsageLimitInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Amount != nil {
		objectKey := object.Key("Amount")
		objectKey.Long(*v.Amount)
	}

	if len(v.BreachAction) > 0 {
		objectKey := object.Key("BreachAction")
		objectKey.String(string(v.BreachAction))
	}

	if v.UsageLimitId != nil {
		objectKey := object.Key("UsageLimitId")
		objectKey.String(*v.UsageLimitId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPauseClusterInput(v *PauseClusterInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPurchaseReservedNodeOfferingInput(v *PurchaseReservedNodeOfferingInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NodeCount != nil {
		objectKey := object.Key("NodeCount")
		objectKey.Integer(*v.NodeCount)
	}

	if v.ReservedNodeOfferingId != nil {
		objectKey := object.Key("ReservedNodeOfferingId")
		objectKey.String(*v.ReservedNodeOfferingId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRebootClusterInput(v *RebootClusterInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRejectDataShareInput(v *RejectDataShareInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DataShareArn != nil {
		objectKey := object.Key("DataShareArn")
		objectKey.String(*v.DataShareArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentResetClusterParameterGroupInput(v *ResetClusterParameterGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ParameterGroupName != nil {
		objectKey := object.Key("ParameterGroupName")
		objectKey.String(*v.ParameterGroupName)
	}

	if v.Parameters != nil {
		objectKey := object.Key("Parameters")
		if err := awsAwsquery_serializeDocumentParametersList(v.Parameters, objectKey); err != nil {
			return err
		}
	}

	if v.ResetAllParameters {
		objectKey := object.Key("ResetAllParameters")
		objectKey.Boolean(v.ResetAllParameters)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentResizeClusterInput(v *ResizeClusterInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Classic != nil {
		objectKey := object.Key("Classic")
		objectKey.Boolean(*v.Classic)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.ClusterType != nil {
		objectKey := object.Key("ClusterType")
		objectKey.String(*v.ClusterType)
	}

	if v.NodeType != nil {
		objectKey := object.Key("NodeType")
		objectKey.String(*v.NodeType)
	}

	if v.NumberOfNodes != nil {
		objectKey := object.Key("NumberOfNodes")
		objectKey.Integer(*v.NumberOfNodes)
	}

	if v.ReservedNodeId != nil {
		objectKey := object.Key("ReservedNodeId")
		objectKey.String(*v.ReservedNodeId)
	}

	if v.TargetReservedNodeOfferingId != nil {
		objectKey := object.Key("TargetReservedNodeOfferingId")
		objectKey.String(*v.TargetReservedNodeOfferingId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRestoreFromClusterSnapshotInput(v *RestoreFromClusterSnapshotInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AdditionalInfo != nil {
		objectKey := object.Key("AdditionalInfo")
		objectKey.String(*v.AdditionalInfo)
	}

	if v.AllowVersionUpgrade != nil {
		objectKey := object.Key("AllowVersionUpgrade")
		objectKey.Boolean(*v.AllowVersionUpgrade)
	}

	if len(v.AquaConfigurationStatus) > 0 {
		objectKey := object.Key("AquaConfigurationStatus")
		objectKey.String(string(v.AquaConfigurationStatus))
	}

	if v.AutomatedSnapshotRetentionPeriod != nil {
		objectKey := object.Key("AutomatedSnapshotRetentionPeriod")
		objectKey.Integer(*v.AutomatedSnapshotRetentionPeriod)
	}

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if v.AvailabilityZoneRelocation != nil {
		objectKey := object.Key("AvailabilityZoneRelocation")
		objectKey.Boolean(*v.AvailabilityZoneRelocation)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.ClusterParameterGroupName != nil {
		objectKey := object.Key("ClusterParameterGroupName")
		objectKey.String(*v.ClusterParameterGroupName)
	}

	if v.ClusterSecurityGroups != nil {
		objectKey := object.Key("ClusterSecurityGroups")
		if err := awsAwsquery_serializeDocumentClusterSecurityGroupNameList(v.ClusterSecurityGroups, objectKey); err != nil {
			return err
		}
	}

	if v.ClusterSubnetGroupName != nil {
		objectKey := object.Key("ClusterSubnetGroupName")
		objectKey.String(*v.ClusterSubnetGroupName)
	}

	if v.DefaultIamRoleArn != nil {
		objectKey := object.Key("DefaultIamRoleArn")
		objectKey.String(*v.DefaultIamRoleArn)
	}

	if v.ElasticIp != nil {
		objectKey := object.Key("ElasticIp")
		objectKey.String(*v.ElasticIp)
	}

	if v.EnhancedVpcRouting != nil {
		objectKey := object.Key("EnhancedVpcRouting")
		objectKey.Boolean(*v.EnhancedVpcRouting)
	}

	if v.HsmClientCertificateIdentifier != nil {
		objectKey := object.Key("HsmClientCertificateIdentifier")
		objectKey.String(*v.HsmClientCertificateIdentifier)
	}

	if v.HsmConfigurationIdentifier != nil {
		objectKey := object.Key("HsmConfigurationIdentifier")
		objectKey.String(*v.HsmConfigurationIdentifier)
	}

	if v.IamRoles != nil {
		objectKey := object.Key("IamRoles")
		if err := awsAwsquery_serializeDocumentIamRoleArnList(v.IamRoles, objectKey); err != nil {
			return err
		}
	}

	if v.KmsKeyId != nil {
		objectKey := object.Key("KmsKeyId")
		objectKey.String(*v.KmsKeyId)
	}

	if v.MaintenanceTrackName != nil {
		objectKey := object.Key("MaintenanceTrackName")
		objectKey.String(*v.MaintenanceTrackName)
	}

	if v.ManualSnapshotRetentionPeriod != nil {
		objectKey := object.Key("ManualSnapshotRetentionPeriod")
		objectKey.Integer(*v.ManualSnapshotRetentionPeriod)
	}

	if v.NodeType != nil {
		objectKey := object.Key("NodeType")
		objectKey.String(*v.NodeType)
	}

	if v.NumberOfNodes != nil {
		objectKey := object.Key("NumberOfNodes")
		objectKey.Integer(*v.NumberOfNodes)
	}

	if v.OwnerAccount != nil {
		objectKey := object.Key("OwnerAccount")
		objectKey.String(*v.OwnerAccount)
	}

	if v.Port != nil {
		objectKey := object.Key("Port")
		objectKey.Integer(*v.Port)
	}

	if v.PreferredMaintenanceWindow != nil {
		objectKey := object.Key("PreferredMaintenanceWindow")
		objectKey.String(*v.PreferredMaintenanceWindow)
	}

	if v.PubliclyAccessible != nil {
		objectKey := object.Key("PubliclyAccessible")
		objectKey.Boolean(*v.PubliclyAccessible)
	}

	if v.ReservedNodeId != nil {
		objectKey := object.Key("ReservedNodeId")
		objectKey.String(*v.ReservedNodeId)
	}

	if v.SnapshotClusterIdentifier != nil {
		objectKey := object.Key("SnapshotClusterIdentifier")
		objectKey.String(*v.SnapshotClusterIdentifier)
	}

	if v.SnapshotIdentifier != nil {
		objectKey := object.Key("SnapshotIdentifier")
		objectKey.String(*v.SnapshotIdentifier)
	}

	if v.SnapshotScheduleIdentifier != nil {
		objectKey := object.Key("SnapshotScheduleIdentifier")
		objectKey.String(*v.SnapshotScheduleIdentifier)
	}

	if v.TargetReservedNodeOfferingId != nil {
		objectKey := object.Key("TargetReservedNodeOfferingId")
		objectKey.String(*v.TargetReservedNodeOfferingId)
	}

	if v.VpcSecurityGroupIds != nil {
		objectKey := object.Key("VpcSecurityGroupIds")
		if err := awsAwsquery_serializeDocumentVpcSecurityGroupIdList(v.VpcSecurityGroupIds, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRestoreTableFromClusterSnapshotInput(v *RestoreTableFromClusterSnapshotInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.EnableCaseSensitiveIdentifier != nil {
		objectKey := object.Key("EnableCaseSensitiveIdentifier")
		objectKey.Boolean(*v.EnableCaseSensitiveIdentifier)
	}

	if v.NewTableName != nil {
		objectKey := object.Key("NewTableName")
		objectKey.String(*v.NewTableName)
	}

	if v.SnapshotIdentifier != nil {
		objectKey := object.Key("SnapshotIdentifier")
		objectKey.String(*v.SnapshotIdentifier)
	}

	if v.SourceDatabaseName != nil {
		objectKey := object.Key("SourceDatabaseName")
		objectKey.String(*v.SourceDatabaseName)
	}

	if v.SourceSchemaName != nil {
		objectKey := object.Key("SourceSchemaName")
		objectKey.String(*v.SourceSchemaName)
	}

	if v.SourceTableName != nil {
		objectKey := object.Key("SourceTableName")
		objectKey.String(*v.SourceTableName)
	}

	if v.TargetDatabaseName != nil {
		objectKey := object.Key("TargetDatabaseName")
		objectKey.String(*v.TargetDatabaseName)
	}

	if v.TargetSchemaName != nil {
		objectKey := object.Key("TargetSchemaName")
		objectKey.String(*v.TargetSchemaName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentResumeClusterInput(v *ResumeClusterInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRevokeClusterSecurityGroupIngressInput(v *RevokeClusterSecurityGroupIngressInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CIDRIP != nil {
		objectKey := object.Key("CIDRIP")
		objectKey.String(*v.CIDRIP)
	}

	if v.ClusterSecurityGroupName != nil {
		objectKey := object.Key("ClusterSecurityGroupName")
		objectKey.String(*v.ClusterSecurityGroupName)
	}

	if v.EC2SecurityGroupName != nil {
		objectKey := object.Key("EC2SecurityGroupName")
		objectKey.String(*v.EC2SecurityGroupName)
	}

	if v.EC2SecurityGroupOwnerId != nil {
		objectKey := object.Key("EC2SecurityGroupOwnerId")
		objectKey.String(*v.EC2SecurityGroupOwnerId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRevokeEndpointAccessInput(v *RevokeEndpointAccessInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Account != nil {
		objectKey := object.Key("Account")
		objectKey.String(*v.Account)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.Force {
		objectKey := object.Key("Force")
		objectKey.Boolean(v.Force)
	}

	if v.VpcIds != nil {
		objectKey := object.Key("VpcIds")
		if err := awsAwsquery_serializeDocumentVpcIdentifierList(v.VpcIds, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRevokeSnapshotAccessInput(v *RevokeSnapshotAccessInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AccountWithRestoreAccess != nil {
		objectKey := object.Key("AccountWithRestoreAccess")
		objectKey.String(*v.AccountWithRestoreAccess)
	}

	if v.SnapshotClusterIdentifier != nil {
		objectKey := object.Key("SnapshotClusterIdentifier")
		objectKey.String(*v.SnapshotClusterIdentifier)
	}

	if v.SnapshotIdentifier != nil {
		objectKey := object.Key("SnapshotIdentifier")
		objectKey.String(*v.SnapshotIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRotateEncryptionKeyInput(v *RotateEncryptionKeyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUpdatePartnerStatusInput(v *UpdatePartnerStatusInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AccountId != nil {
		objectKey := object.Key("AccountId")
		objectKey.String(*v.AccountId)
	}

	if v.ClusterIdentifier != nil {
		objectKey := object.Key("ClusterIdentifier")
		objectKey.String(*v.ClusterIdentifier)
	}

	if v.DatabaseName != nil {
		objectKey := object.Key("DatabaseName")
		objectKey.String(*v.DatabaseName)
	}

	if v.PartnerName != nil {
		objectKey := object.Key("PartnerName")
		objectKey.String(*v.PartnerName)
	}

	if len(v.Status) > 0 {
		objectKey := object.Key("Status")
		objectKey.String(string(v.Status))
	}

	if v.StatusMessage != nil {
		objectKey := object.Key("StatusMessage")
		objectKey.String(*v.StatusMessage)
	}

	return nil
}
