// Code generated by smithy-go-codegen DO NOT EDIT.

package rds

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/rds/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns information about custom Availability Zones (AZs). A custom AZ is an
// on-premises AZ that is integrated with a VMware vSphere cluster. For more
// information about RDS on VMware, see the  RDS on VMware User Guide.
// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
func (c *Client) DescribeCustomAvailabilityZones(ctx context.Context, params *DescribeCustomAvailabilityZonesInput, optFns ...func(*Options)) (*DescribeCustomAvailabilityZonesOutput, error) {
	if params == nil {
		params = &DescribeCustomAvailabilityZonesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeCustomAvailabilityZones", params, optFns, c.addOperationDescribeCustomAvailabilityZonesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeCustomAvailabilityZonesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeCustomAvailabilityZonesInput struct {

	// The custom AZ identifier. If this parameter is specified, information from only
	// the specific custom AZ is returned.
	CustomAvailabilityZoneId *string

	// A filter that specifies one or more custom AZs to describe.
	Filters []types.Filter

	// An optional pagination token provided by a previous
	// DescribeCustomAvailabilityZones request. If this parameter is specified, the
	// response includes only records beyond the marker, up to the value specified by
	// MaxRecords.
	Marker *string

	// The maximum number of records to include in the response. If more records exist
	// than the specified MaxRecords value, a pagination token called a marker is
	// included in the response so you can retrieve the remaining results. Default: 100
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int32

	noSmithyDocumentSerde
}

type DescribeCustomAvailabilityZonesOutput struct {

	// The list of CustomAvailabilityZone objects for the Amazon Web Services account.
	CustomAvailabilityZones []types.CustomAvailabilityZone

	// An optional pagination token provided by a previous
	// DescribeCustomAvailabilityZones request. If this parameter is specified, the
	// response includes only records beyond the marker, up to the value specified by
	// MaxRecords.
	Marker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeCustomAvailabilityZonesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDescribeCustomAvailabilityZones{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDescribeCustomAvailabilityZones{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeCustomAvailabilityZonesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeCustomAvailabilityZones(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeCustomAvailabilityZonesAPIClient is a client that implements the
// DescribeCustomAvailabilityZones operation.
type DescribeCustomAvailabilityZonesAPIClient interface {
	DescribeCustomAvailabilityZones(context.Context, *DescribeCustomAvailabilityZonesInput, ...func(*Options)) (*DescribeCustomAvailabilityZonesOutput, error)
}

var _ DescribeCustomAvailabilityZonesAPIClient = (*Client)(nil)

// DescribeCustomAvailabilityZonesPaginatorOptions is the paginator options for
// DescribeCustomAvailabilityZones
type DescribeCustomAvailabilityZonesPaginatorOptions struct {
	// The maximum number of records to include in the response. If more records exist
	// than the specified MaxRecords value, a pagination token called a marker is
	// included in the response so you can retrieve the remaining results. Default: 100
	// Constraints: Minimum 20, maximum 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeCustomAvailabilityZonesPaginator is a paginator for
// DescribeCustomAvailabilityZones
type DescribeCustomAvailabilityZonesPaginator struct {
	options   DescribeCustomAvailabilityZonesPaginatorOptions
	client    DescribeCustomAvailabilityZonesAPIClient
	params    *DescribeCustomAvailabilityZonesInput
	nextToken *string
	firstPage bool
}

// NewDescribeCustomAvailabilityZonesPaginator returns a new
// DescribeCustomAvailabilityZonesPaginator
func NewDescribeCustomAvailabilityZonesPaginator(client DescribeCustomAvailabilityZonesAPIClient, params *DescribeCustomAvailabilityZonesInput, optFns ...func(*DescribeCustomAvailabilityZonesPaginatorOptions)) *DescribeCustomAvailabilityZonesPaginator {
	if params == nil {
		params = &DescribeCustomAvailabilityZonesInput{}
	}

	options := DescribeCustomAvailabilityZonesPaginatorOptions{}
	if params.MaxRecords != nil {
		options.Limit = *params.MaxRecords
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeCustomAvailabilityZonesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeCustomAvailabilityZonesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeCustomAvailabilityZones page.
func (p *DescribeCustomAvailabilityZonesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeCustomAvailabilityZonesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxRecords = limit

	result, err := p.client.DescribeCustomAvailabilityZones(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.Marker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeCustomAvailabilityZones(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "rds",
		OperationName: "DescribeCustomAvailabilityZones",
	}
}
