// Code generated by smithy-go-codegen DO NOT EDIT.

package personalize

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/personalize/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a recommender with the recipe (a Domain dataset group use case) you
// specify. You create recommenders for a Domain dataset group and specify the
// recommender's Amazon Resource Name (ARN) when you make a GetRecommendations
// (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
// request. Status A recommender can be in one of the following states:
//
// * CREATE
// PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
// * DELETE PENDING >
// DELETE IN_PROGRESS
//
// To get the recommender status, call DescribeRecommender.
// Wait until the status of the recommender is ACTIVE before asking the recommender
// for recommendations. Related APIs
//
// * ListRecommenders
//
// * DescribeRecommender
//
// *
// UpdateRecommender
//
// * DeleteRecommender
func (c *Client) CreateRecommender(ctx context.Context, params *CreateRecommenderInput, optFns ...func(*Options)) (*CreateRecommenderOutput, error) {
	if params == nil {
		params = &CreateRecommenderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRecommender", params, optFns, c.addOperationCreateRecommenderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRecommenderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateRecommenderInput struct {

	// The Amazon Resource Name (ARN) of the destination domain dataset group for the
	// recommender.
	//
	// This member is required.
	DatasetGroupArn *string

	// The name of the recommender.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the recipe that the recommender will use. For
	// a recommender, a recipe is a Domain dataset group use case. Only Domain dataset
	// group use cases can be used to create a recommender. For information about use
	// cases see Choosing recommender use cases
	// (https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html).
	//
	// This member is required.
	RecipeArn *string

	// The configuration details of the recommender.
	RecommenderConfig *types.RecommenderConfig

	noSmithyDocumentSerde
}

type CreateRecommenderOutput struct {

	// The Amazon Resource Name (ARN) of the recommender.
	RecommenderArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRecommenderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateRecommender{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateRecommender{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateRecommenderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRecommender(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateRecommender(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "personalize",
		OperationName: "CreateRecommender",
	}
}
